<?php
/**
 * @package Module EB Ajax Search for Joomla!
 * @version 2.1: mod_ebajaxsearch.php Oct 2025
 * @author url: https://www/extnbakers.com
 * @copyright Copyright (C) 2022 extnbakers.com. All rights reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
**/
use Joomla\CMS\Language\Text; 
class Pagination{
	var $baseURL		= '';
	var $totalRows  	= '';
	var $perPage	 	= 10;
	var $numLinks		= 3;
	var $currentPage	= 0;
	//var $firstLink   	= Text::_('MOD_SEARCHAJAX_PAGI_FIRSTLINK')'&lsaquo; First';
	//var $nextLink		= Text::_('MOD_SEARCHAJAX_PAGI_NEXTLINK')'&gt;';
	//var $prevLink		= Text::_('MOD_SEARCHAJAX_PAGI_PREVLINK'); '&lt;';
	//var $lastLink		= Text::_('MOD_SEARCHAJAX_PAGI_LASTLINK');
	var $fullTagOpen	= '<div class="eb_ajaxsearch_pagination">';
	var $fullTagClose	= '</div>';
	var $firstTagOpen	= '';
	var $firstTagClose	= '&nbsp;';
	var $lastTagOpen	= '&nbsp;';
	var $lastTagClose	= '';
	var $curTagOpen		= '&nbsp;<b class="pagination_link">';
	var $curTagClose	= '</b>';
	var $nextTagOpen	= '&nbsp;';
	var $nextTagClose	= '&nbsp;';
	var $prevTagOpen	= '&nbsp;';
	var $prevTagClose	= '';
	var $numTagOpen		= '&nbsp;';
	var $numTagClose	= '';
	var $anchorClass	= '';
	var $showCount      = true;
	var $currentOffset	= 0;
	var $contentDiv     = '';
    var $additionalParam= '';
	var $link_func      = '';
	var $redirect_url   = 0;
	function __construct($params = array()){
		if (count($params) > 0){
			$this->initialize($params);		
		}
		if ($this->anchorClass != ''){
			$this->anchorClass = 'class="'.$this->anchorClass.'" ';
		}	
	}
	function initialize($params = array()){
		if (count($params) > 0){
			foreach ($params as $key => $val){
				if (isset($this->$key)){
					$this->$key = $val;
				}
			}		
		}
	}
	/**
	 * Generate the pagination links
	 */	
	function createLinks(){ 
		// If total number of rows is zero, do not need to continue
		if ($this->totalRows == 0 OR $this->perPage == 0){
		   return '';
		}
		// Calculate the total number of pages
		$numPages = ceil($this->totalRows / $this->perPage);
		// Is there only one page? will not need to continue
		if ($numPages == 1){
			if ($this->showCount){
				$info = Text::_('MOD_SEARCHAJAX_PAGI_SHOWING_TEXT').' : ' . $this->totalRows;
				return $info;
			}else{
				return '';
			}
		}
		// Determine the current page	
		if ( ! is_numeric($this->currentPage)){
			$this->currentPage = 0;
		}
		// Links content string variable
		$output = '';
		// Showing links notification
		if ($this->showCount){
		   $currentOffset = $this->currentPage;
		    if($this->redirect_url == 1){
		   		$info = '<a class="eb_viewall" href="javascript:void(0);">'.Text::_('MOD_SEARCHAJAX_VIEW_ALL_RESULTES').' </a>';
		    } else {
		    	$info = '';
		    }
		   $info .=  Text::_('MOD_SEARCHAJAX_PAGI_SHOWING_TEXT').' ' . ( $currentOffset + 1 ) . Text::_('MOD_SEARCHAJAX_PAGI_TO_TEXT') ;
		   if( ( $currentOffset + $this->perPage ) <= ( $this->totalRows -1 ) )
			  $info .= $currentOffset + $this->perPage;
		   else
			  $info .= $this->totalRows;
		   $info .= Text::_('MOD_SEARCHAJAX_PAGI_OFF_TEXT') . $this->totalRows . ' | ';
		   $output .= $info;
		}
		$this->numLinks = (int)$this->numLinks;
		// Is the page number beyond the result range? the last page will show
		if ($this->currentPage > $this->totalRows){
			$this->currentPage = ($numPages - 1) * $this->perPage;
		}
		$uriPageNum = $this->currentPage;
		$this->currentPage = floor(($this->currentPage/$this->perPage) + 1);
		// Calculate the start and end numbers. 
		$start = (($this->currentPage - $this->numLinks) > 0) ? $this->currentPage - ($this->numLinks - 1) : 1;
		$end   = (($this->currentPage + $this->numLinks) < $numPages) ? $this->currentPage + $this->numLinks : $numPages;
		// Render the "First" link
		if  ($this->currentPage > $this->numLinks){
			$output .= $this->firstTagOpen 
				. $this->getAJAXlink( '' , Text::_('MOD_SEARCHAJAX_PAGI_FIRSTLINK'))
				. $this->firstTagClose; 
		}
		// Render the "previous" link
		if  ($this->currentPage != 1){
			$i = $uriPageNum - $this->perPage;
			if ($i == 0) $i = '';
			$output .= $this->prevTagOpen 
				. $this->getAJAXlink( $i, Text::_('MOD_SEARCHAJAX_PAGI_PREVLINK') )
				. $this->prevTagClose;
		}
		// Write the digit links
		for ($loop = $start -1; $loop <= $end; $loop++){
			$i = ($loop * $this->perPage) - $this->perPage;
			if ($i >= 0){
				if ($this->currentPage == $loop){
					$output .= $this->curTagOpen.$loop.$this->curTagClose;
				}else{
					$n = ($i == 0) ? '' : $i;
					$output .= $this->numTagOpen
						. $this->getAJAXlink( $n, $loop )
						. $this->numTagClose;
				}
			}
		}
		// Render the "next" link
		if ($this->currentPage < $numPages){
			$output .= $this->nextTagOpen 
				. $this->getAJAXlink( $this->currentPage * $this->perPage , Text::_('MOD_SEARCHAJAX_PAGI_NEXTLINK') )
				. $this->nextTagClose;
		}
		// Render the "Last" link
		if (($this->currentPage + $this->numLinks) < $numPages){
			$i = (($numPages * $this->perPage) - $this->perPage);
			$output .= $this->lastTagOpen . $this->getAJAXlink( $i, Text::_('MOD_SEARCHAJAX_PAGI_LASTLINK') ) . $this->lastTagClose;
		}
		// Remove double slashes
		$output = preg_replace("#([^:])//+#", "\\1/", $output);
		// Add the wrapper HTML if exists
		$output = $this->fullTagOpen.$output.$this->fullTagClose;
		return $output;		
	}
	function getAJAXlink( $count, $text) {
        if($this->link_func == '' && $this->contentDiv == '')
            return '<a href="'.$this->baseURL.'?'.$count.'"'.$this->anchorClass.'>'.$text.'</a>';
		$pageCount = $count?$count:0;
		if(!empty($this->link_func)){
			$linkClick = 'onclick="'.$this->link_func.'('.$pageCount.')"';
		}else{
			$this->additionalParam = "{'page' : $pageCount}";
			$linkClick = "onclick=\"$.post('". $this->baseURL."', ". $this->additionalParam .", function(data){
					   $('#". $this->contentDiv . "').html(data); }); return false;\"";
		}
	    return "<a class='pagination_link' href=\"javascript:void(0);\" " . $this->anchorClass . "
				". $linkClick .">". $text .'</a>';
	}
}
?>