/* jce - 2.9.97 | 2025-12-15 | https://www.joomlacontenteditor.net | Source: https://github.com/widgetfactory/jce | Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
!function($) {
    var counter = 0;
    function parseUrl(url) {
        var data = {};
        return url && (url = url.substring(url.indexOf("?") + 1), $.each(url.replace(/\+/g, " ").split("&"), function(i, value) {
            var value = value.split("="), key = decodeURIComponent(value[0]);
            2 === value.length && "string" == typeof (value = decodeURIComponent(value[1])) && value.length && (data[key] = value);
        })), data;
    }
    function upload(url, file) {
        return new Promise(function(resolve, reject) {
            var xhr = new XMLHttpRequest(), formData = new FormData();
            xhr.upload && (xhr.upload.onprogress = function(e) {
                e.lengthComputable && (file.loaded = Math.min(file.size, e.loaded));
            }), xhr.onreadystatechange = function() {
                4 == xhr.readyState && (200 === xhr.status ? resolve(xhr.responseText) : reject(), 
                file = formData = null);
            };
            var name = (name = file.target_name || file.name).replace(/[\+\\\/\?\#%&<>"\'=\[\]\{\},;@\^\(\)\xa3\u20ac$~]/g, ""), name = {
                method: "upload",
                id: function() {
                    for (var guid = new Date().getTime().toString(32), i = 0; i < 5; i++) guid += Math.floor(65535 * Math.random()).toString(32);
                    return "wf_" + guid + (counter++).toString(32);
                }(),
                inline: 1,
                name: name
            }, Joomla = window.Joomla || {};
            Joomla.getOptions && (Joomla = Joomla.getOptions("csrf.token") || "") && (name[Joomla] = 1), 
            xhr.open("post", url, !0), xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest"), 
            $.each(name, function(key, value) {
                formData.append(key, value);
            }), formData.append("file", file), xhr.send(formData);
        });
    }
    function mimeFromExt(url) {
        return {
            jpg: "image/jpeg",
            jpeg: "image/jpeg",
            png: "image/png",
            gif: "image/gif",
            webp: "image/webp",
            apng: "image/apng",
            mp4: "video/mp4",
            m4v: "video/x-m4v",
            ogg: "audio/ogg",
            ogv: "video/ogg",
            webm: "video/webm",
            mp3: "audio/mpeg",
            wav: "audio/wav",
            pdf: "application/pdf",
            zip: "application/zip",
            tar: "application/x-tar",
            doc: "application/msword",
            docx: "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            dot: "application/msword",
            dotx: "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
            xls: "application/vnd.ms-excel",
            xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            ppt: "application/vnd.ms-powerpoint",
            pps: "application/vnd.ms-powerpoint",
            pptx: "application/vnd.openxmlformats-officedocument.presentationml.presentation",
            ppsx: "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
            odt: "application/vnd.oasis.opendocument.text",
            odp: "application/vnd.oasis.opendocument.presentation",
            ods: "application/vnd.oasis.opendocument.spreadsheet",
            odg: "application/vnd.oasis.opendocument.graphics"
        }[url.split(".").pop().toLowerCase()] || "";
    }
    function createPreview(field, url, mimeType) {
        var el;
        field && field.previewElement && (field.previewElement.innerHTML = "", (mimeType = mimeType && 0 !== mimeType.indexOf("text/") ? mimeType : mimeFromExt(url)) && 0 === mimeType.indexOf("image/") ? ((el = document.createElement("img")).src = url, 
        el.alt = "Preview") : mimeType && 0 === mimeType.indexOf("video/") ? ((el = document.createElement("video")).preload = "metadata", 
        el.controls = !0, el.src = url, el.type = mimeType) : mimeType && 0 === mimeType.indexOf("audio/") ? ((el = document.createElement("audio")).preload = "none", 
        el.controls = !0, el.src = url, el.type = mimeType) : ((el = document.createElement("object")).data = url, 
        el.type = mimeType || "application/octet-stream"), field.previewElement.appendChild(el));
    }
    function isImage(file) {
        return /\.(jpg|jpeg|png|apng|gif|webp)$/i.test(file);
    }
    function isAdmin(value) {
        return value && -1 != value.indexOf("/administrator/");
    }
    function getBasePath(elm) {
        var path = "", $wrapper = $(elm).parents(".field-media-wrapper"), $wrapper = $wrapper.data("fieldMedia") || $wrapper.get(0);
        return (path = (path = $wrapper ? $wrapper.options ? $wrapper.options.basepath || "" : $wrapper.basePath || "" : path) || $(elm).data("basepath") || "") && !isAdmin(path) && isAdmin(document.location.href) && (path += "administrator/"), 
        path;
    }
    function getDimensions(elm, url) {
        return new Promise(function(resolve, reject) {
            var img;
            isImage(url) ? ((img = new Image()).onload = function() {
                resolve({
                    width: this.width,
                    height: this.height
                });
            }, img.onerror = function() {
                reject();
            }, img.src = function(elm, url) {
                return (elm = isAdmin(elm = getBasePath(elm)) ? elm.replace(/\/administrator\//, "/") : elm) + url;
            }(elm, url)) : reject();
        });
    }
    function updateMediaUrl(row, options) {
        $(row).find(".field-media-wrapper").add(row).each(function() {
            var $inp = $(this).find(".field-media-input"), id = $inp.attr("id");
            if ($inp.attr("disabled")) return !0;
            if (!id) return !0;
            -1 !== id.indexOf("rowX") && (id = id.replace("rowX", "row" + $(row).index()), 
            $inp.attr("id", id)), $(this).addClass("wf-media-wrapper");
            var dataUrl = $(this).data("url") || $(this).attr("url") || "", $linkBtn = $(this).find('a[href*="index.php?option=com_media"].modal.btn'), params = parseUrl(dataUrl = $linkBtn.length && !dataUrl ? $linkBtn.attr("href") || "" : dataUrl), dataUrl = "images", plugin = params.plugin || "browser";
            if (params.mediatype ? dataUrl = params.mediatype : "files" == params.view && (dataUrl = "files"), 
            $inp.hasClass("wf-media-input-converted")) {
                try {
                    supportedExtensions = JSON.parse($(this).attr("supported-extensions") || "{}");
                } catch (e) {
                    supportedExtensions = !1;
                }
                supportedExtensions && (extensions = [], $.each(supportedExtensions, function(key, values) {
                    Array.isArray(values) && values.length && (extensions = extensions.concat(values));
                }), extensions.length) && (dataUrl = extensions.join(",")), params.converted = 1;
                var extensions, name = $inp.attr("name") || "", base = "local-images:";
                params.path && -1 !== params.path.indexOf(":") && (base = params.path.split(":")[0] + ":"), 
                name && (name = name.replace(/jform\[com_fields\]\[([\w-]+)\].*/, "$1"), 
                (name = options.mediafields[name] || {}).directory ? (":" !== base.charAt(base.length - 1) && "/" !== base.charAt(base.length - 1) && (base += "/"), 
                params.path = base + name.directory.replace(/^\/+/, "")) : params.path = base);
            }
            name = getBasePath($inp) + "index.php?option=com_jce&task=mediafield.display&plugin=" + plugin + "&fieldid=" + id + "&mediatype=" + dataUrl;
            options.context && (params.context = options.context);
            $.each([ "option", "task", "plugin", "fieldid", "mediatype", "element", "view", "tmpl" ], function(i, key) {
                delete params[key];
            }), name += "&" + $.param(params), this.hasAttribute("data-url") && this.setAttribute("data-url", name), 
            $(this).is("joomla-field-media, .wf-media-wrapper-custom") && (this.setAttribute("url", name), 
            base = Joomla.sanitizeHtml('<iframe src="' + name + '" class="iframe" title="" width="100%" height="100%"></iframe>', {
                iframe: [ "src", "class", "title", "width", "height" ]
            }), $(this).find(".joomla-modal").attr("data-url", name).attr("data-iframe", base), 
            $(this).removeAttr("modal-width").removeAttr("modal-height")), $linkBtn.length && $linkBtn.attr("href", name);
        });
    }
    function cleanInputValue(elm) {
        var val = $(elm).val() || "";
        -1 != val.indexOf("#joomlaImage") && (val = val.substring(0, val.indexOf("#")), 
        $(elm).val(val).attr("value", val));
    }
    $.fn.WfMediaUpload = function() {
        return this.each(function() {
            var elm = this;
            function insertFile(value, data) {
                var $wrapper = ($wrapper = $(elm).parents(".field-media-wrapper")).data("fieldMedia") || $wrapper.get(0);
                $wrapper && $wrapper.setValue ? $wrapper.setValue(value, data || {}) : $(elm).val(value).trigger("change");
            }
            function uploadAndInsert(url, file) {
                var params;
                file.name && (params = parseUrl(url), url = getBasePath(elm) + "index.php?option=com_jce&task=plugin.rpc", 
                $.each([ "option", "task" ], function(i, key) {
                    delete params[key];
                }), params.plugin = params.plugin || "browser", params.standalone || (params.standalone = 1), 
                url += "&" + $.param(params), !function(file, filter) {
                    return filter = filter.replace(/[^\w_,]/gi, "").toLowerCase(), 
                    new RegExp(".(" + ({
                        images: "jpg,jpeg,png,apng,gif,webp",
                        media: "avi,wmv,wm,asf,asx,wmx,wvx,mov,qt,mpg,mpeg,m4a,m4v,swf,dcr,rm,ra,ram,divx,mp4,ogv,ogg,webm,flv,f4v,mp3,ogg,wav,xap",
                        html: "html,htm,txt",
                        files: "doc,docx,dot,dotx,ppt,pps,pptx,ppsx,xls,xlsx,gif,jpeg,jpg,png,webp,apng,pdf,zip,tar,gz,swf,rar,mov,mp4,m4a,flv,mkv,webm,ogg,ogv,qt,wmv,asx,asf,avi,wav,mp3,aiff,oga,odt,odg,odp,ods,odf,rtf,txt,csv,htm,html"
                    }[filter] || filter).split(",").join("|") + ")$", "i").test(file.name);
                }(file, params.filter || params.mediatype || "images") ? alert("The selected file is not supported.") : ($(elm).prop("disabled", !0).addClass("wf-media-upload-busy"), 
                upload(url, file).then(function(response) {
                    $(elm).prop("disabled", !1).removeAttr("disabled").removeClass("wf-media-upload-busy");
                    try {
                        var o = JSON.parse(response), error = "Unable to upload file";
                        if ($.isPlainObject(o)) {
                            o.error && (error = o.error.message || error);
                            var r = o.result;
                            if (r) {
                                var files = r.files || [], item = files.length ? files[0] : {};
                                if (item.file) return void getDimensions(elm, item.file).then(function(data) {
                                    insertFile(item.file, data);
                                }, function() {
                                    insertFile(item.file);
                                });
                            }
                        }
                        alert(error);
                    } catch (e) {
                        alert("The server returned an invalid JSON response");
                    }
                }, function() {
                    return $(elm).prop("disabled", !1).removeAttr("disabled").removeClass("wf-media-upload-busy"), 
                    !1;
                })));
            }
            var url = function(elm) {
                var url = "", $wrapper = ($wrapper = $(elm).parents(".field-media-wrapper")).data("fieldMedia") || $wrapper.get(0);
                return (url = $wrapper ? $wrapper.options ? $wrapper.options.url || "" : $wrapper.getAttribute("data-url") || $wrapper.getAttribute("url") || "" : url) || $(elm).siblings("a.modal").attr("href") || "";
            }(elm);
            if (!url) return !1;
            var $selectBtn = $(elm).parent().find(".button-select, .modal.btn"), $uploadBtn = ($(elm).parent().find(".wf-media-upload-button").remove(), 
            $('<a title="Upload" role="button" class="btn btn-outline-secondary wf-media-upload-button" aria-label="Upload"><i role="presentation" class="icon-upload"></i><input type="file" aria-hidden="true" /></a>'));
            $uploadBtn.insertAfter($selectBtn), $('input[type="file"]', $uploadBtn).on("change", function(e) {
                e.preventDefault(), this.files && (e = this.files[0]) && uploadAndInsert(url, e);
            }), $(elm).on("drag dragstart dragend dragover dragenter dragleave drop", function(e) {
                e.preventDefault(), e.stopPropagation();
            }).on("dragover dragenter", function(e) {
                $(this).addClass("wf-media-upload-hover");
            }).on("dragleave", function(e) {
                $(this).removeClass("wf-media-upload-hover");
            }).on("drop", function(e) {
                var e = e.originalEvent.dataTransfer;
                e && e.files && e.files.length && (e = e.files[0]) && uploadAndInsert(url, e), 
                $(this).removeClass("wf-media-upload-hover");
            });
        });
    }, $(document).ready(function($) {
        var options = Joomla.getOptions("plg_system_jce", {});
        function isActiveField(elm) {
            return $(elm).find(".wf-media-input-active").length;
        }
        $("[data-wf-converted]").addClass("wf-media-input-converted"), $(".wf-media-input").parents(".field-media-wrapper, .fc-field-value-properties-box").addClass("wf-media-wrapper"), 
        options.convert && $(".field-media-wrapper, .fc-field-value-properties-box").not(".wf-media-wrapper").addClass("wf-media-wrapper").find(".field-media-input").addClass("wf-media-input wf-media-input-active wf-media-input-converted"), 
        $(".wf-media-input-converted").addClass("wf-media-input wf-media-input-active").parents(".field-media-wrapper").each(function() {
            updateMediaUrl(this, options);
        }), $(".wf-media-input").not(".wf-media-input-active").prop("disabled", !0).parent().find("button, a.btn").prop("disabled", !0).on("click", function(e) {
            e.preventDefault(), e.stopImmediatePropagation();
        }).removeAttr("onclick").hide(), $(".wf-media-input-no-select-button").parent().find(".button-select").prop("disabled", !0).on("click", function(e) {
            e.preventDefault(), e.stopImmediatePropagation();
        }).removeAttr("onclick").hide(), $(".wf-media-input").parents(".subform-repeatable-group").each(function(i, row) {
            if (!isActiveField(row)) return $(row).parents("joomla-field-subform").find("button").hide().prop("disabled", !0).on("click", function(e) {
                e.preventDefault(), e.stopImmediatePropagation();
            }), !0;
            updateMediaUrl(row, options);
        }), $(".wf-media-input-active").removeAttr("readonly"), $("joomla-field-media.wf-media-wrapper").on("joomla-field-media:update", function(e) {
            var setValueFunction, markValidFunction, url, field = this;
            field.inputElement && ($(this).find("input.wf-media-input-converted").length ? (updateMediaUrl(this, options), 
            setValueFunction = field.setValue || function() {}, field.setValue = function(value, data) {
                var parts;
                field.markValid && (field.markValid(), value && isImage(value) && -1 === value.indexOf("://") && (parts = value.split("/"), 
                value += "#joomlaImage://local-" + parts.shift() + "/" + parts.join("/"), 
                data) && "object" == typeof data && (value += "?width=" + data.width + "&height=" + data.height), 
                setValueFunction(value));
            }) : (cleanInputValue(field.inputElement), markValidFunction = field.markValid || function() {}, 
            field.markValid = function() {
                cleanInputValue(this.inputElement), field.querySelector('label[for="' + this.inputElement.id + '"]') && markValidFunction.apply(this);
            }, url = field.basePath + field.inputElement.value, field.inputElement.addEventListener("change", function(e) {
                e.stopImmediatePropagation(), cleanInputValue(this), field.querySelector('label[for="' + this.id + '"]') && markValidFunction.apply(this), 
                this.value ? (url = field.basePath + this.value, field.previewElement && (field.previewElement.innerHTML = ""), 
                fetch(url, {
                    method: "HEAD"
                }).then(function(res) {
                    res.ok && (res = (res.headers.get("Content-Type") || "").split(";")[0].trim(), 
                    field.mimeType = res || mimeFromExt(url));
                }).catch(function() {
                    field.mimeType = mimeFromExt(url);
                }).finally(function() {
                    createPreview(field, url, field.mimeType);
                }), $(document).trigger("t4:media-selected", {
                    selectedUrl: field.basePath + this.value
                }), $(this).trigger("change")) : field.updatePreview();
            }, !0), field.inputElement.value && createPreview(field, url, field.mimeType)));
        }).trigger("joomla-field-media:update").each(function() {
            updateMediaUrl(this, options);
        }), $(document).on("subform-row-add", function(evt, row) {
            evt = evt.originalEvent;
            evt && evt.detail && (row = evt.detail.row || row), options.convert && $(row).find(".field-media-input").not(".wf-media-input-active").addClass("wf-media-input wf-media-input-active wf-media-input-converted"), 
            0 != $(row).find(".wf-media-input").length && (isActiveField(row) ? ($(row).find(".wf-media-input").each(function() {
                $(this).parents("joomla-field-media").addClass("wf-media-wrapper"), 
                $(this).hasClass("wf-media-input-active") && $(this).removeAttr("readonly");
            }), $(row).find("joomla-field-media.wf-media-wrapper").trigger("joomla-field-media:update"), 
            updateMediaUrl(row, options), $(row).find(".wf-media-input-upload").WfMediaUpload()) : ($(row).find(".wf-media-input").each(function() {
                $(this).prop("disabled", !0).parents("joomla-field-media").addClass("wf-media-wrapper");
            }), $(row).find("joomla-field-media").each(function() {
                var elm;
                $(this).find("button").hide().prop("disabled", !0), (elm = this).button && elm.button.hasAttribute("disabled") && elm.button.addEventListener("click", function(e) {
                    e.preventDefault(), e.stopImmediatePropagation();
                }, !0), elm.buttonClearEl && elm.buttonClearEl.hasAttribute("disabled") && elm.buttonClearEl.addEventListener("click", function(e) {
                    e.preventDefault(), e.stopImmediatePropagation();
                }, !0);
            }), $(row).parents("joomla-field-subform").find("button").hide().prop("disabled", !0).on("click", function(e) {
                e.preventDefault(), e.stopImmediatePropagation();
            }), $(row).find(".wf-media-input").each(function() {
                $(this).prop("disabled", !0).parents("joomla-field-media").addClass("wf-media-wrapper");
            }), $(row).find(".btn-group").hide().find("button").prop("disabled", !0)));
        }), options.upload && $(".wf-media-input-converted").addClass("wf-media-input-upload"), 
        $(".wf-media-input-upload").not('[name*="media-repeat"]').WfMediaUpload(), 
        $(".wf-media-wrapper .modal-header h3").html("&nbsp;"), $(".wf-media-wrapper").find("button.button-select").on("click", function(e) {
            e.preventDefault();
        }), $(document).on("joomla-dialog:open", function(e) {
            var ifr, e = e.target;
            $(e).hasClass("joomla-dialog-media-field") && (ifr = e.querySelector("iframe")) && -1 != ifr.src.indexOf("index.php?option=com_jce") && $(e).addClass("wf-media-dialog");
        });
    });
}(jQuery);