/* CodeMirror, copyright (c) by Marijn Haverbeke and others. Distributed under an MIT license: http://codemirror.net/LICENSE */
!function() {
    "use strict";
    let rangeFrom = [], rangeTo = [];
    var numbers = "lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map(s => s ? parseInt(s, 36) : 1);
    for (let i = 0, n = 0; i < numbers.length; i++) (i % 2 ? rangeTo : rangeFrom).push(n += numbers[i]);
    function isRegionalIndicator(code) {
        return 127462 <= code && code <= 127487;
    }
    const ZWJ = 8205;
    function findClusterBreak$1(str, pos, forward = !0, includeExtending = !0) {
        return (forward ? nextClusterBreak : function(str, pos, includeExtending) {
            for (;0 < pos; ) {
                var found = nextClusterBreak(str, pos - 2, includeExtending);
                if (found < pos) return found;
                pos--;
            }
            return 0;
        })(str, pos, includeExtending);
    }
    function nextClusterBreak(str, pos, includeExtending) {
        if (pos != str.length) {
            pos && surrogateLow$1(str.charCodeAt(pos)) && surrogateHigh$1(str.charCodeAt(pos - 1)) && pos--;
            let prev = codePointAt$1(str, pos);
            for (pos += codePointSize$1(prev); pos < str.length; ) {
                var next = codePointAt$1(str, pos);
                if (prev == ZWJ || next == ZWJ || includeExtending && function(code) {
                    if (!(code < 768)) for (let from = 0, to = rangeFrom.length; ;) {
                        var mid = from + to >> 1;
                        if (code < rangeFrom[mid]) to = mid; else {
                            if (!(code >= rangeTo[mid])) return 1;
                            from = 1 + mid;
                        }
                        if (from == to) return;
                    }
                }(next)) pos += next < 65536 ? 1 : 2, prev = next; else {
                    if (!isRegionalIndicator(next)) break;
                    {
                        let countBefore = 0, i = pos - 2;
                        for (;0 <= i && isRegionalIndicator(codePointAt$1(str, i)); ) countBefore++, 
                        i -= 2;
                        if (countBefore % 2 == 0) break;
                        pos += 2;
                    }
                }
            }
        }
        return pos;
    }
    function codePointAt$1(str, pos) {
        var code0 = str.charCodeAt(pos);
        return surrogateHigh$1(code0) && pos + 1 != str.length && surrogateLow$1(str = str.charCodeAt(pos + 1)) ? str - 56320 + (code0 - 55296 << 10) + 65536 : code0;
    }
    function surrogateLow$1(ch) {
        return 56320 <= ch && ch < 57344;
    }
    function surrogateHigh$1(ch) {
        return 55296 <= ch && ch < 56320;
    }
    function codePointSize$1(code) {
        return code < 65536 ? 1 : 2;
    }
    class Text {
        lineAt(pos) {
            if (pos < 0 || pos > this.length) throw new RangeError(`Invalid position ${pos} in document of length ` + this.length);
            return this.lineInner(pos, !1, 1, 0);
        }
        line(n) {
            if (n < 1 || n > this.lines) throw new RangeError(`Invalid line number ${n} in ${this.lines}-line document`);
            return this.lineInner(n, !0, 1, 0);
        }
        replace(from, to, text) {
            [ from, to ] = clip(this, from, to);
            var parts = [];
            return this.decompose(0, from, parts, 2), text.length && text.decompose(0, text.length, parts, 3), 
            this.decompose(to, this.length, parts, 1), TextNode.from(parts, this.length - (to - from) + text.length);
        }
        append(other) {
            return this.replace(this.length, this.length, other);
        }
        slice(from, to = this.length) {
            [ from, to ] = clip(this, from, to);
            var parts = [];
            return this.decompose(from, to, parts, 0), TextNode.from(parts, to - from);
        }
        eq(other) {
            if (other == this) return !0;
            if (other.length != this.length || other.lines != this.lines) return !1;
            var start = this.scanIdentical(other, 1), end = this.length - this.scanIdentical(other, -1), a = new RawTextCursor(this), b = new RawTextCursor(other);
            for (let skip = start, pos = start; ;) {
                if (a.next(skip), b.next(skip), skip = 0, a.lineBreak != b.lineBreak || a.done != b.done || a.value != b.value) return !1;
                if (pos += a.value.length, a.done || pos >= end) return !0;
            }
        }
        iter(dir = 1) {
            return new RawTextCursor(this, dir);
        }
        iterRange(from, to = this.length) {
            return new PartialTextCursor(this, from, to);
        }
        iterLines(from, to) {
            let inner;
            return inner = null == from ? this.iter() : (null == to && (to = this.lines + 1), 
            from = this.line(from).from, this.iterRange(from, Math.max(from, to == this.lines + 1 ? this.length : to <= 1 ? 0 : this.line(to - 1).to))), 
            new LineCursor(inner);
        }
        toString() {
            return this.sliceString(0);
        }
        toJSON() {
            var lines = [];
            return this.flatten(lines), lines;
        }
        constructor() {}
        static of(text) {
            if (0 == text.length) throw new RangeError("A document must have at least one line");
            return 1 != text.length || text[0] ? text.length <= 32 ? new TextLeaf(text) : TextNode.from(TextLeaf.split(text, [])) : Text.empty;
        }
    }
    class TextLeaf extends Text {
        constructor(text, length = function(text) {
            let length = -1;
            for (var line of text) length += line.length + 1;
            return length;
        }(text)) {
            super(), this.text = text, this.length = length;
        }
        get lines() {
            return this.text.length;
        }
        get children() {
            return null;
        }
        lineInner(target, isLine, line, offset) {
            for (let i = 0; ;i++) {
                var string = this.text[i], end = offset + string.length;
                if (target <= (isLine ? line : end)) return new Line$1(offset, end, line, string);
                offset = end + 1, line++;
            }
        }
        decompose(from, to, target, open) {
            to = from <= 0 && to >= this.length ? this : new TextLeaf(sliceText(this.text, from, to), Math.min(to, this.length) - Math.max(0, from));
            1 & open ? (from = target.pop(), (open = appendText(to.text, from.text.slice(), 0, to.length)).length <= 32 ? target.push(new TextLeaf(open, from.length + to.length)) : (from = open.length >> 1, 
            target.push(new TextLeaf(open.slice(0, from)), new TextLeaf(open.slice(from))))) : target.push(to);
        }
        replace(from, to, text) {
            if (!(text instanceof TextLeaf)) return super.replace(from, to, text);
            [ from, to ] = clip(this, from, to);
            var lines = appendText(this.text, appendText(text.text, sliceText(this.text, 0, from)), to), text = this.length + text.length - (to - from);
            return lines.length <= 32 ? new TextLeaf(lines, text) : TextNode.from(TextLeaf.split(lines, []), text);
        }
        sliceString(from, to = this.length, lineSep = "\n") {
            [ from, to ] = clip(this, from, to);
            let result = "";
            for (let pos = 0, i = 0; pos <= to && i < this.text.length; i++) {
                var line = this.text[i], end = pos + line.length;
                pos > from && i && (result += lineSep), from < end && to > pos && (result += line.slice(Math.max(0, from - pos), to - pos)), 
                pos = end + 1;
            }
            return result;
        }
        flatten(target) {
            for (var line of this.text) target.push(line);
        }
        scanIdentical() {
            return 0;
        }
        static split(text, target) {
            let part = [], len = -1;
            for (var line of text) part.push(line), len += line.length + 1, 32 == part.length && (target.push(new TextLeaf(part, len)), 
            part = [], len = -1);
            return -1 < len && target.push(new TextLeaf(part, len)), target;
        }
    }
    class TextNode extends Text {
        constructor(children, length) {
            super(), this.children = children, this.length = length, this.lines = 0;
            for (var child of children) this.lines += child.lines;
        }
        lineInner(target, isLine, line, offset) {
            for (let i = 0; ;i++) {
                var child = this.children[i], end = offset + child.length, endLine = line + child.lines - 1;
                if (target <= (isLine ? endLine : end)) return child.lineInner(target, isLine, line, offset);
                offset = end + 1, line = 1 + endLine;
            }
        }
        decompose(from, to, target, open) {
            for (let i = 0, pos = 0; pos <= to && i < this.children.length; i++) {
                var childOpen, child = this.children[i], end = pos + child.length;
                from <= end && to >= pos && (childOpen = open & ((pos <= from ? 1 : 0) | (to <= end ? 2 : 0)), 
                pos >= from && end <= to && !childOpen ? target.push(child) : child.decompose(from - pos, to - pos, target, childOpen)), 
                pos = end + 1;
            }
        }
        replace(from, to, text) {
            if ([ from, to ] = clip(this, from, to), text.lines < this.lines) for (let i = 0, pos = 0; i < this.children.length; i++) {
                var updated, child = this.children[i], end = pos + child.length;
                if (from >= pos && to <= end) return updated = child.replace(from - pos, to - pos, text), 
                child = this.lines - child.lines + updated.lines, updated.lines < child >> 4 && updated.lines > child >> 6 ? ((child = this.children.slice())[i] = updated, 
                new TextNode(child, this.length - (to - from) + text.length)) : super.replace(pos, end, updated);
                pos = end + 1;
            }
            return super.replace(from, to, text);
        }
        sliceString(from, to = this.length, lineSep = "\n") {
            [ from, to ] = clip(this, from, to);
            let result = "";
            for (let i = 0, pos = 0; i < this.children.length && pos <= to; i++) {
                var child = this.children[i], end = pos + child.length;
                pos > from && i && (result += lineSep), from < end && to > pos && (result += child.sliceString(from - pos, to - pos, lineSep)), 
                pos = end + 1;
            }
            return result;
        }
        flatten(target) {
            for (var child of this.children) child.flatten(target);
        }
        scanIdentical(other, dir) {
            if (!(other instanceof TextNode)) return 0;
            let length = 0, [ iA, iB, eA, eB ] = 0 < dir ? [ 0, 0, this.children.length, other.children.length ] : [ this.children.length - 1, other.children.length - 1, -1, -1 ];
            for (;;iA += dir, iB += dir) {
                if (iA == eA || iB == eB) return length;
                var chA = this.children[iA], chB = other.children[iB];
                if (chA != chB) return length + chA.scanIdentical(chB, dir);
                length += chA.length + 1;
            }
        }
        static from(children, length = children.reduce((l, ch) => l + ch.length + 1, -1)) {
            let lines = 0;
            for (var ch of children) lines += ch.lines;
            if (lines < 32) {
                var flat = [];
                for (let ch of children) ch.flatten(flat);
                return new TextLeaf(flat, length);
            }
            let chunk = Math.max(32, lines >> 5), maxChunk = chunk << 1, minChunk = chunk >> 1, chunked = [], currentLines = 0, currentLen = -1, currentChunk = [];
            function flush() {
                0 != currentLines && (chunked.push(1 == currentChunk.length ? currentChunk[0] : TextNode.from(currentChunk, currentLen)), 
                currentLen = -1, currentLines = currentChunk.length = 0);
            }
            for (var child of children) !function add(child) {
                let last;
                if (child.lines > maxChunk && child instanceof TextNode) for (var node of child.children) add(node); else child.lines > minChunk && (currentLines > minChunk || !currentLines) ? (flush(), 
                chunked.push(child)) : child instanceof TextLeaf && currentLines && (last = currentChunk[currentChunk.length - 1]) instanceof TextLeaf && child.lines + last.lines <= 32 ? (currentLines += child.lines, 
                currentLen += child.length + 1, currentChunk[currentChunk.length - 1] = new TextLeaf(last.text.concat(child.text), last.length + 1 + child.length)) : (currentLines + child.lines > chunk && flush(), 
                currentLines += child.lines, currentLen += child.length + 1, currentChunk.push(child));
            }(child);
            return flush(), 1 == chunked.length ? chunked[0] : new TextNode(chunked, length);
        }
    }
    function appendText(text, target, from = 0, to = 1e9) {
        for (let pos = 0, i = 0, first = !0; i < text.length && pos <= to; i++) {
            let line = text[i], end = pos + line.length;
            from <= end && (to < end && (line = line.slice(0, to - pos)), pos < from && (line = line.slice(from - pos)), 
            first ? (target[target.length - 1] += line, first = !1) : target.push(line)), 
            pos = end + 1;
        }
        return target;
    }
    function sliceText(text, from, to) {
        return appendText(text, [ "" ], from, to);
    }
    Text.empty = new TextLeaf([ "" ], 0);
    class RawTextCursor {
        constructor(text, dir = 1) {
            this.dir = dir, this.done = !1, this.lineBreak = !1, this.value = "", 
            this.nodes = [ text ], this.offsets = [ 0 < dir ? 1 : (text instanceof TextLeaf ? text.text : text.children).length << 1 ];
        }
        nextInner(skip, dir) {
            for (this.done = this.lineBreak = !1; ;) {
                var last = this.nodes.length - 1, top = this.nodes[last], offsetValue = this.offsets[last], offset = offsetValue >> 1, size = (top instanceof TextLeaf ? top.text : top.children).length;
                if (offset == (0 < dir ? size : 0)) {
                    if (0 == last) return this.done = !0, this.value = "", this;
                    0 < dir && this.offsets[last - 1]++, this.nodes.pop(), this.offsets.pop();
                } else if ((1 & offsetValue) == (0 < dir ? 0 : 1)) {
                    if (this.offsets[last] += dir, 0 == skip) return this.lineBreak = !0, 
                    this.value = "\n", this;
                    skip--;
                } else if (top instanceof TextLeaf) {
                    size = top.text[offset + (dir < 0 ? -1 : 0)];
                    if (this.offsets[last] += dir, size.length > Math.max(0, skip)) return this.value = 0 == skip ? size : 0 < dir ? size.slice(skip) : size.slice(0, size.length - skip), 
                    this;
                    skip -= size.length;
                } else {
                    let next = top.children[offset + (dir < 0 ? -1 : 0)];
                    skip > next.length ? (skip -= next.length, this.offsets[last] += dir) : (dir < 0 && this.offsets[last]--, 
                    this.nodes.push(next), this.offsets.push(0 < dir ? 1 : (next instanceof TextLeaf ? next.text : next.children).length << 1));
                }
            }
        }
        next(skip = 0) {
            return skip < 0 && (this.nextInner(-skip, -this.dir), skip = this.value.length), 
            this.nextInner(skip, this.dir);
        }
    }
    class PartialTextCursor {
        constructor(text, start, end) {
            this.value = "", this.done = !1, this.cursor = new RawTextCursor(text, end < start ? -1 : 1), 
            this.pos = end < start ? text.length : 0, this.from = Math.min(start, end), 
            this.to = Math.max(start, end);
        }
        nextInner(skip, dir) {
            var limit, value;
            return (dir < 0 ? this.pos <= this.from : this.pos >= this.to) ? (this.value = "", 
            this.done = !0) : (skip += Math.max(0, dir < 0 ? this.pos - this.to : this.from - this.pos), 
            limit = dir < 0 ? this.pos - this.from : this.to - this.pos, value = (limit -= skip = limit < skip ? limit : skip, 
            this.cursor.next(skip))["value"], this.pos += (value.length + skip) * dir, 
            this.value = value.length <= limit ? value : dir < 0 ? value.slice(value.length - limit) : value.slice(0, limit), 
            this.done = !this.value), this;
        }
        next(skip = 0) {
            return skip < 0 ? skip = Math.max(skip, this.from - this.pos) : 0 < skip && (skip = Math.min(skip, this.to - this.pos)), 
            this.nextInner(skip, this.cursor.dir);
        }
        get lineBreak() {
            return this.cursor.lineBreak && "" != this.value;
        }
    }
    class LineCursor {
        constructor(inner) {
            this.inner = inner, this.afterBreak = !0, this.value = "", this.done = !1;
        }
        next(skip = 0) {
            var {
                done: skip,
                lineBreak,
                value
            } = this.inner.next(skip);
            return skip && this.afterBreak ? (this.value = "", this.afterBreak = !1) : skip ? (this.done = !0, 
            this.value = "") : lineBreak ? this.afterBreak ? this.value = "" : (this.afterBreak = !0, 
            this.next()) : (this.value = value, this.afterBreak = !1), this;
        }
        get lineBreak() {
            return !1;
        }
    }
    "undefined" != typeof Symbol && (Text.prototype[Symbol.iterator] = function() {
        return this.iter();
    }, RawTextCursor.prototype[Symbol.iterator] = PartialTextCursor.prototype[Symbol.iterator] = LineCursor.prototype[Symbol.iterator] = function() {
        return this;
    });
    let Line$1 = class {
        constructor(from, to, number, text) {
            this.from = from, this.to = to, this.number = number, this.text = text;
        }
        get length() {
            return this.to - this.from;
        }
    };
    function clip(text, from, to) {
        return [ from = Math.max(0, Math.min(text.length, from)), Math.max(from, Math.min(text.length, to)) ];
    }
    function findClusterBreak(str, pos, forward = !0, includeExtending = !0) {
        return findClusterBreak$1(str, pos, forward, includeExtending);
    }
    function codePointAt(str, pos) {
        var ch, code0 = str.charCodeAt(pos);
        return 55296 <= (ch = code0) && ch < 56320 && pos + 1 != str.length && function(ch) {
            return 56320 <= ch && ch < 57344;
        }(ch = str.charCodeAt(pos + 1)) ? ch - 56320 + (code0 - 55296 << 10) + 65536 : code0;
    }
    function fromCodePoint(code) {
        return code <= 65535 ? String.fromCharCode(code) : (code -= 65536, String.fromCharCode(55296 + (code >> 10), 56320 + (1023 & code)));
    }
    function codePointSize(code) {
        return code < 65536 ? 1 : 2;
    }
    const DefaultSplit = /\r\n?|\n/;
    var MapMode = function(MapMode) {
        return MapMode[MapMode.Simple = 0] = "Simple", MapMode[MapMode.TrackDel = 1] = "TrackDel", 
        MapMode[MapMode.TrackBefore = 2] = "TrackBefore", MapMode[MapMode.TrackAfter = 3] = "TrackAfter", 
        MapMode;
    }(MapMode = MapMode || {});
    class ChangeDesc {
        constructor(sections) {
            this.sections = sections;
        }
        get length() {
            let result = 0;
            for (let i = 0; i < this.sections.length; i += 2) result += this.sections[i];
            return result;
        }
        get newLength() {
            let result = 0;
            for (let i = 0; i < this.sections.length; i += 2) {
                var ins = this.sections[i + 1];
                result += ins < 0 ? this.sections[i] : ins;
            }
            return result;
        }
        get empty() {
            return 0 == this.sections.length || 2 == this.sections.length && this.sections[1] < 0;
        }
        iterGaps(f) {
            for (let i = 0, posA = 0, posB = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++];
                ins < 0 ? (f(posA, posB, len), posB += len) : posB += ins, posA += len;
            }
        }
        iterChangedRanges(f, individual = !1) {
            iterChanges(this, f, individual);
        }
        get invertedDesc() {
            var sections = [];
            for (let i = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++];
                ins < 0 ? sections.push(len, ins) : sections.push(ins, len);
            }
            return new ChangeDesc(sections);
        }
        composeDesc(other) {
            return this.empty ? other : other.empty ? this : composeSets(this, other);
        }
        mapDesc(other, before = !1) {
            return other.empty ? this : mapSet(this, other, before);
        }
        mapPos(pos, assoc = -1, mode = MapMode.Simple) {
            let posA = 0, posB = 0;
            for (let i = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++], endA = posA + len;
                if (ins < 0) {
                    if (pos < endA) return posB + (pos - posA);
                    posB += len;
                } else {
                    if (mode != MapMode.Simple && pos <= endA && (mode == MapMode.TrackDel && posA < pos && pos < endA || mode == MapMode.TrackBefore && posA < pos || mode == MapMode.TrackAfter && pos < endA)) return null;
                    if (pos < endA || endA == pos && assoc < 0 && !len) return pos == posA || assoc < 0 ? posB : posB + ins;
                    posB += ins;
                }
                posA = endA;
            }
            if (pos > posA) throw new RangeError(`Position ${pos} is out of range for changeset of length ` + posA);
            return posB;
        }
        touchesRange(from, to = from) {
            for (let i = 0, pos = 0; i < this.sections.length && pos <= to; ) {
                var len = this.sections[i++], ins = this.sections[i++], len = pos + len;
                if (0 <= ins && pos <= to && from <= len) return !(pos < from && to < len) || "cover";
                pos = len;
            }
            return !1;
        }
        toString() {
            let result = "";
            for (let i = 0; i < this.sections.length; ) {
                var len = this.sections[i++], ins = this.sections[i++];
                result += (result ? " " : "") + len + (0 <= ins ? ":" + ins : "");
            }
            return result;
        }
        toJSON() {
            return this.sections;
        }
        static fromJSON(json) {
            if (!Array.isArray(json) || json.length % 2 || json.some(a => "number" != typeof a)) throw new RangeError("Invalid JSON representation of ChangeDesc");
            return new ChangeDesc(json);
        }
        static create(sections) {
            return new ChangeDesc(sections);
        }
    }
    class ChangeSet extends ChangeDesc {
        constructor(sections, inserted) {
            super(sections), this.inserted = inserted;
        }
        apply(doc) {
            if (this.length != doc.length) throw new RangeError("Applying change set to a document with the wrong length");
            return iterChanges(this, (fromA, toA, fromB, _toB, text) => doc = doc.replace(fromB, fromB + (toA - fromA), text), !1), 
            doc;
        }
        mapDesc(other, before = !1) {
            return mapSet(this, other, before, !0);
        }
        invert(doc) {
            var sections = this.sections.slice(), inserted = [];
            for (let i = 0, pos = 0; i < sections.length; i += 2) {
                var len = sections[i], ins = sections[i + 1];
                if (0 <= ins) {
                    sections[i] = ins, sections[i + 1] = len;
                    for (var index = i >> 1; inserted.length < index; ) inserted.push(Text.empty);
                    inserted.push(len ? doc.slice(pos, pos + len) : Text.empty);
                }
                pos += len;
            }
            return new ChangeSet(sections, inserted);
        }
        compose(other) {
            return this.empty ? other : other.empty ? this : composeSets(this, other, !0);
        }
        map(other, before = !1) {
            return other.empty ? this : mapSet(this, other, before, !0);
        }
        iterChanges(f, individual = !1) {
            iterChanges(this, f, individual);
        }
        get desc() {
            return ChangeDesc.create(this.sections);
        }
        filter(ranges) {
            var resultSections = [], resultInserted = [], filteredSections = [], iter = new SectionIter(this);
            done: for (let i = 0, pos = 0; ;) {
                for (var next = i == ranges.length ? 1e9 : ranges[i++]; pos < next || pos == next && 0 == iter.len; ) {
                    if (iter.done) break done;
                    var len = Math.min(iter.len, next - pos), ins = (addSection(filteredSections, len, -1), 
                    -1 == iter.ins ? -1 : 0 == iter.off ? iter.ins : 0);
                    addSection(resultSections, len, ins), 0 < ins && addInsert(resultInserted, resultSections, iter.text), 
                    iter.forward(len), pos += len;
                }
                for (var end = ranges[i++]; pos < end; ) {
                    if (iter.done) break done;
                    let len = Math.min(iter.len, end - pos);
                    addSection(resultSections, len, -1), addSection(filteredSections, len, -1 == iter.ins ? -1 : 0 == iter.off ? iter.ins : 0), 
                    iter.forward(len), pos += len;
                }
            }
            return {
                changes: new ChangeSet(resultSections, resultInserted),
                filtered: ChangeDesc.create(filteredSections)
            };
        }
        toJSON() {
            var parts = [];
            for (let i = 0; i < this.sections.length; i += 2) {
                var len = this.sections[i], ins = this.sections[i + 1];
                parts.push(ins < 0 ? len : 0 == ins ? [ len ] : [ len ].concat(this.inserted[i >> 1].toJSON()));
            }
            return parts;
        }
        static of(changes, length, lineSep) {
            let sections = [], inserted = [], pos = 0, total = null;
            function flush(force = !1) {
                (force || sections.length) && (pos < length && addSection(sections, length - pos, -1), 
                force = new ChangeSet(sections, inserted), total = total ? total.compose(force.map(total)) : force, 
                sections = [], inserted = [], pos = 0);
            }
            return function process(spec) {
                if (Array.isArray(spec)) for (var sub of spec) process(sub); else if (spec instanceof ChangeSet) {
                    if (spec.length != length) throw new RangeError(`Mismatched change set length (got ${spec.length}, expected ${length})`);
                    flush(), total = total ? total.compose(spec.map(total)) : spec;
                } else {
                    var {
                        from: spec,
                        to = spec,
                        insert
                    } = spec;
                    if (to < spec || spec < 0 || length < to) throw new RangeError(`Invalid change range ${spec} to ${to} (in doc of length ${length})`);
                    var insLen = (insert = insert ? "string" == typeof insert ? Text.of(insert.split(lineSep || DefaultSplit)) : insert : Text.empty).length;
                    spec == to && 0 == insLen || (spec < pos && flush(), spec > pos && addSection(sections, spec - pos, -1), 
                    addSection(sections, to - spec, insLen), addInsert(inserted, sections, insert), 
                    pos = to);
                }
            }(changes), flush(!total), total;
        }
        static empty(length) {
            return new ChangeSet(length ? [ length, -1 ] : [], []);
        }
        static fromJSON(json) {
            if (!Array.isArray(json)) throw new RangeError("Invalid JSON representation of ChangeSet");
            var sections = [], inserted = [];
            for (let i = 0; i < json.length; i++) {
                var part = json[i];
                if ("number" == typeof part) sections.push(part, -1); else {
                    if (!Array.isArray(part) || "number" != typeof part[0] || part.some((e, i) => i && "string" != typeof e)) throw new RangeError("Invalid JSON representation of ChangeSet");
                    if (1 == part.length) sections.push(part[0], 0); else {
                        for (;inserted.length < i; ) inserted.push(Text.empty);
                        inserted[i] = Text.of(part.slice(1)), sections.push(part[0], inserted[i].length);
                    }
                }
            }
            return new ChangeSet(sections, inserted);
        }
        static createSet(sections, inserted) {
            return new ChangeSet(sections, inserted);
        }
    }
    function addSection(sections, len, ins, forceJoin = !1) {
        var last;
        0 == len && ins <= 0 || (0 <= (last = sections.length - 2) && ins <= 0 && ins == sections[1 + last] ? sections[last] += len : 0 <= last && 0 == len && 0 == sections[last] ? sections[1 + last] += ins : forceJoin ? (sections[last] += len, 
        sections[1 + last] += ins) : sections.push(len, ins));
    }
    function addInsert(values, sections, value) {
        if (0 != value.length) {
            var index = sections.length - 2 >> 1;
            if (index < values.length) values[values.length - 1] = values[values.length - 1].append(value); else {
                for (;values.length < index; ) values.push(Text.empty);
                values.push(value);
            }
        }
    }
    function iterChanges(desc, f, individual) {
        var inserted = desc.inserted;
        for (let posA = 0, posB = 0, i = 0; i < desc.sections.length; ) {
            let len = desc.sections[i++], ins = desc.sections[i++];
            if (ins < 0) posA += len, posB += len; else {
                let endA = posA, endB = posB, text = Text.empty;
                for (;endA += len, endB += ins, ins && inserted && (text = text.append(inserted[i - 2 >> 1])), 
                !(individual || i == desc.sections.length || desc.sections[i + 1] < 0); ) len = desc.sections[i++], 
                ins = desc.sections[i++];
                f(posA, endA, posB, endB, text), posA = endA, posB = endB;
            }
        }
    }
    function mapSet(setA, setB, before, mkSet = !1) {
        var sections = [], insert = mkSet ? [] : null, a = new SectionIter(setA), b = new SectionIter(setB);
        for (let inserted = -1; ;) {
            if (a.done && b.len || b.done && a.len) throw new Error("Mismatched change set lengths");
            if (-1 == a.ins && -1 == b.ins) {
                var len = Math.min(a.len, b.len);
                addSection(sections, len, -1), a.forward(len), b.forward(len);
            } else if (0 <= b.ins && (a.ins < 0 || inserted == a.i || 0 == a.off && (b.len < a.len || b.len == a.len && !before))) {
                let len = b.len;
                for (addSection(sections, b.ins, -1); len; ) {
                    var piece = Math.min(a.len, len);
                    0 <= a.ins && inserted < a.i && a.len <= piece && (addSection(sections, 0, a.ins), 
                    insert && addInsert(insert, sections, a.text), inserted = a.i), 
                    a.forward(piece), len -= piece;
                }
                b.next();
            } else {
                if (!(0 <= a.ins)) {
                    if (a.done && b.done) return insert ? ChangeSet.createSet(sections, insert) : ChangeDesc.create(sections);
                    throw new Error("Mismatched change set lengths");
                }
                {
                    let len = 0, left = a.len;
                    for (;left; ) if (-1 == b.ins) {
                        let piece = Math.min(left, b.len);
                        len += piece, left -= piece, b.forward(piece);
                    } else {
                        if (!(0 == b.ins && b.len < left)) break;
                        left -= b.len, b.next();
                    }
                    addSection(sections, len, inserted < a.i ? a.ins : 0), insert && inserted < a.i && addInsert(insert, sections, a.text), 
                    inserted = a.i, a.forward(a.len - left);
                }
            }
        }
    }
    function composeSets(setA, setB, mkSet = !1) {
        var sections = [], insert = mkSet ? [] : null, a = new SectionIter(setA), b = new SectionIter(setB);
        for (let open = !1; ;) {
            if (a.done && b.done) return insert ? ChangeSet.createSet(sections, insert) : ChangeDesc.create(sections);
            if (0 == a.ins) addSection(sections, a.len, 0, open), a.next(); else if (0 != b.len || b.done) {
                if (a.done || b.done) throw new Error("Mismatched change set lengths");
                var insB, len = Math.min(a.len2, b.len), sectionLen = sections.length;
                -1 == a.ins ? (addSection(sections, len, insB = -1 == b.ins ? -1 : b.off ? 0 : b.ins, open), 
                insert && insB && addInsert(insert, sections, b.text)) : -1 == b.ins ? (addSection(sections, a.off ? 0 : a.len, len, open), 
                insert && addInsert(insert, sections, a.textBit(len))) : (addSection(sections, a.off ? 0 : a.len, b.off ? 0 : b.ins, open), 
                insert && !b.off && addInsert(insert, sections, b.text)), open = (a.ins > len || 0 <= b.ins && b.len > len) && (open || sectionLen < sections.length), 
                a.forward2(len), b.forward(len);
            } else addSection(sections, 0, b.ins, open), insert && addInsert(insert, sections, b.text), 
            b.next();
        }
    }
    class SectionIter {
        constructor(set) {
            this.set = set, this.i = 0, this.next();
        }
        next() {
            var sections = this.set["sections"];
            this.i < sections.length ? (this.len = sections[this.i++], this.ins = sections[this.i++]) : (this.len = 0, 
            this.ins = -2), this.off = 0;
        }
        get done() {
            return -2 == this.ins;
        }
        get len2() {
            return this.ins < 0 ? this.len : this.ins;
        }
        get text() {
            var inserted = this.set["inserted"], index = this.i - 2 >> 1;
            return index >= inserted.length ? Text.empty : inserted[index];
        }
        textBit(len) {
            var inserted = this.set["inserted"], index = this.i - 2 >> 1;
            return index >= inserted.length && !len ? Text.empty : inserted[index].slice(this.off, null == len ? void 0 : this.off + len);
        }
        forward(len) {
            len == this.len ? this.next() : (this.len -= len, this.off += len);
        }
        forward2(len) {
            -1 == this.ins ? this.forward(len) : len == this.ins ? this.next() : (this.ins -= len, 
            this.off += len);
        }
    }
    class SelectionRange {
        constructor(from, to, flags) {
            this.from = from, this.to = to, this.flags = flags;
        }
        get anchor() {
            return 32 & this.flags ? this.to : this.from;
        }
        get head() {
            return 32 & this.flags ? this.from : this.to;
        }
        get empty() {
            return this.from == this.to;
        }
        get assoc() {
            return 8 & this.flags ? -1 : 16 & this.flags ? 1 : 0;
        }
        get bidiLevel() {
            var level = 7 & this.flags;
            return 7 == level ? null : level;
        }
        get goalColumn() {
            var value = this.flags >> 6;
            return 16777215 == value ? void 0 : value;
        }
        map(change, assoc = -1) {
            let from, to;
            return this.empty ? from = to = change.mapPos(this.from, assoc) : (from = change.mapPos(this.from, 1), 
            to = change.mapPos(this.to, -1)), from == this.from && to == this.to ? this : new SelectionRange(from, to, this.flags);
        }
        extend(from, to = from) {
            return from <= this.anchor && to >= this.anchor ? EditorSelection.range(from, to) : (to = Math.abs(from - this.anchor) > Math.abs(to - this.anchor) ? from : to, 
            EditorSelection.range(this.anchor, to));
        }
        eq(other, includeAssoc = !1) {
            return !(this.anchor != other.anchor || this.head != other.head || includeAssoc && this.empty && this.assoc != other.assoc);
        }
        toJSON() {
            return {
                anchor: this.anchor,
                head: this.head
            };
        }
        static fromJSON(json) {
            if (json && "number" == typeof json.anchor && "number" == typeof json.head) return EditorSelection.range(json.anchor, json.head);
            throw new RangeError("Invalid JSON representation for SelectionRange");
        }
        static create(from, to, flags) {
            return new SelectionRange(from, to, flags);
        }
    }
    class EditorSelection {
        constructor(ranges, mainIndex) {
            this.ranges = ranges, this.mainIndex = mainIndex;
        }
        map(change, assoc = -1) {
            return change.empty ? this : EditorSelection.create(this.ranges.map(r => r.map(change, assoc)), this.mainIndex);
        }
        eq(other, includeAssoc = !1) {
            if (this.ranges.length != other.ranges.length || this.mainIndex != other.mainIndex) return !1;
            for (let i = 0; i < this.ranges.length; i++) if (!this.ranges[i].eq(other.ranges[i], includeAssoc)) return !1;
            return !0;
        }
        get main() {
            return this.ranges[this.mainIndex];
        }
        asSingle() {
            return 1 == this.ranges.length ? this : new EditorSelection([ this.main ], 0);
        }
        addRange(range, main = !0) {
            return EditorSelection.create([ range ].concat(this.ranges), main ? 0 : this.mainIndex + 1);
        }
        replaceRange(range, which = this.mainIndex) {
            var ranges = this.ranges.slice();
            return ranges[which] = range, EditorSelection.create(ranges, this.mainIndex);
        }
        toJSON() {
            return {
                ranges: this.ranges.map(r => r.toJSON()),
                main: this.mainIndex
            };
        }
        static fromJSON(json) {
            if (!json || !Array.isArray(json.ranges) || "number" != typeof json.main || json.main >= json.ranges.length) throw new RangeError("Invalid JSON representation for EditorSelection");
            return new EditorSelection(json.ranges.map(r => SelectionRange.fromJSON(r)), json.main);
        }
        static single(anchor, head = anchor) {
            return new EditorSelection([ EditorSelection.range(anchor, head) ], 0);
        }
        static create(ranges, mainIndex = 0) {
            if (0 == ranges.length) throw new RangeError("A selection needs at least one range");
            for (let pos = 0, i = 0; i < ranges.length; i++) {
                var range = ranges[i];
                if (range.empty ? range.from <= pos : range.from < pos) return EditorSelection.normalized(ranges.slice(), mainIndex);
                pos = range.to;
            }
            return new EditorSelection(ranges, mainIndex);
        }
        static cursor(pos, assoc = 0, bidiLevel, goalColumn) {
            return SelectionRange.create(pos, pos, (0 == assoc ? 0 : assoc < 0 ? 8 : 16) | (null == bidiLevel ? 7 : Math.min(6, bidiLevel)) | (null != goalColumn ? goalColumn : 16777215) << 6);
        }
        static range(anchor, head, goalColumn, bidiLevel) {
            goalColumn = (null != goalColumn ? goalColumn : 16777215) << 6 | (null == bidiLevel ? 7 : Math.min(6, bidiLevel));
            return head < anchor ? SelectionRange.create(head, anchor, 48 | goalColumn) : SelectionRange.create(anchor, head, (anchor < head ? 8 : 0) | goalColumn);
        }
        static normalized(ranges, mainIndex = 0) {
            var main = ranges[mainIndex];
            ranges.sort((a, b) => a.from - b.from), mainIndex = ranges.indexOf(main);
            for (let i = 1; i < ranges.length; i++) {
                var from, range = ranges[i], prev = ranges[i - 1];
                (range.empty ? range.from <= prev.to : range.from < prev.to) && (from = prev.from, 
                prev = Math.max(range.to, prev.to), i <= mainIndex && mainIndex--, 
                ranges.splice(--i, 2, range.anchor > range.head ? EditorSelection.range(prev, from) : EditorSelection.range(from, prev)));
            }
            return new EditorSelection(ranges, mainIndex);
        }
    }
    function checkSelection(selection, docLength) {
        for (var range of selection.ranges) if (range.to > docLength) throw new RangeError("Selection points outside of document");
    }
    let nextID = 0;
    class Facet {
        constructor(combine, compareInput, compare, isStatic, enables) {
            this.combine = combine, this.compareInput = compareInput, this.compare = compare, 
            this.isStatic = isStatic, this.id = nextID++, this.default = combine([]), 
            this.extensions = "function" == typeof enables ? enables(this) : enables;
        }
        get reader() {
            return this;
        }
        static define(config = {}) {
            return new Facet(config.combine || (a => a), config.compareInput || ((a, b) => a === b), config.compare || (config.combine ? (a, b) => a === b : sameArray$1), !!config.static, config.enables);
        }
        of(value) {
            return new FacetProvider([], this, 0, value);
        }
        compute(deps, get) {
            if (this.isStatic) throw new Error("Can't compute a static facet");
            return new FacetProvider(deps, this, 1, get);
        }
        computeN(deps, get) {
            if (this.isStatic) throw new Error("Can't compute a static facet");
            return new FacetProvider(deps, this, 2, get);
        }
        from(field, get) {
            return get = get || (x => x), this.compute([ field ], state => get(state.field(field)));
        }
    }
    function sameArray$1(a, b) {
        return a == b || a.length == b.length && a.every((e, i) => e === b[i]);
    }
    class FacetProvider {
        constructor(dependencies, facet, type, value) {
            this.dependencies = dependencies, this.facet = facet, this.type = type, 
            this.value = value, this.id = nextID++;
        }
        dynamicSlot(addresses) {
            var _a, dep;
            let getter = this.value, compare = this.facet.compareInput, id = this.id, idx = addresses[id] >> 1, multi = 2 == this.type, depDoc = !1, depSel = !1, depAddrs = [];
            for (dep of this.dependencies) "doc" == dep ? depDoc = !0 : "selection" == dep ? depSel = !0 : 0 == (1 & (null != (_a = addresses[dep.id]) ? _a : 1)) && depAddrs.push(addresses[dep.id]);
            return {
                create(state) {
                    return state.values[idx] = getter(state), 1;
                },
                update(state, tr) {
                    if (depDoc && tr.docChanged || depSel && (tr.docChanged || tr.selection) || ensureAll(state, depAddrs)) {
                        tr = getter(state);
                        if (multi ? !compareArray(tr, state.values[idx], compare) : !compare(tr, state.values[idx])) return state.values[idx] = tr, 
                        1;
                    }
                    return 0;
                },
                reconfigure: (state, oldState) => {
                    let newVal, oldAddr = oldState.config.address[id];
                    if (null != oldAddr) {
                        var oldVal = getAddr(oldState, oldAddr);
                        if (this.dependencies.every(dep => dep instanceof Facet ? oldState.facet(dep) === state.facet(dep) : !(dep instanceof StateField) || oldState.field(dep, !1) == state.field(dep, !1)) || (multi ? compareArray(newVal = getter(state), oldVal, compare) : compare(newVal = getter(state), oldVal))) return state.values[idx] = oldVal, 
                        0;
                    } else newVal = getter(state);
                    return state.values[idx] = newVal, 1;
                }
            };
        }
    }
    function compareArray(a, b, compare) {
        if (a.length == b.length) {
            for (let i = 0; i < a.length; i++) if (!compare(a[i], b[i])) return;
            return 1;
        }
    }
    function ensureAll(state, addrs) {
        let changed = !1;
        for (var addr of addrs) 1 & ensureAddr(state, addr) && (changed = !0);
        return changed;
    }
    const initField = Facet.define({
        static: !0
    });
    class StateField {
        constructor(id, createF, updateF, compareF, spec) {
            this.id = id, this.createF = createF, this.updateF = updateF, this.compareF = compareF, 
            this.spec = spec, this.provides = void 0;
        }
        static define(config) {
            var field = new StateField(nextID++, config.create, config.update, config.compare || ((a, b) => a === b), config);
            return config.provide && (field.provides = config.provide(field)), field;
        }
        create(state) {
            var init = state.facet(initField).find(i => i.field == this);
            return ((null == init ? void 0 : init.create) || this.createF)(state);
        }
        slot(addresses) {
            let idx = addresses[this.id] >> 1;
            return {
                create: state => (state.values[idx] = this.create(state), 1),
                update: (state, tr) => {
                    var oldVal = state.values[idx], tr = this.updateF(oldVal, tr);
                    return this.compareF(oldVal, tr) ? 0 : (state.values[idx] = tr, 
                    1);
                },
                reconfigure: (state, oldState) => {
                    var init = state.facet(initField), oldInit = oldState.facet(initField);
                    if ((init = init.find(i => i.field == this)) && init != oldInit.find(i => i.field == this)) state.values[idx] = init.create(state); else {
                        if (null != oldState.config.address[this.id]) return state.values[idx] = oldState.field(this), 
                        0;
                        state.values[idx] = this.create(state);
                    }
                    return 1;
                }
            };
        }
        init(create) {
            return [ this, initField.of({
                field: this,
                create: create
            }) ];
        }
        get extension() {
            return this;
        }
    }
    const Prec_ = {
        lowest: 4,
        low: 3,
        default: 2,
        high: 1,
        highest: 0
    };
    function prec(value) {
        return ext => new PrecExtension(ext, value);
    }
    const Prec = {
        highest: prec(Prec_.highest),
        high: prec(Prec_.high),
        default: prec(Prec_.default),
        low: prec(Prec_.low),
        lowest: prec(Prec_.lowest)
    };
    class PrecExtension {
        constructor(inner, prec) {
            this.inner = inner, this.prec = prec;
        }
    }
    class Compartment {
        of(ext) {
            return new CompartmentInstance(this, ext);
        }
        reconfigure(content) {
            return Compartment.reconfigure.of({
                compartment: this,
                extension: content
            });
        }
        get(state) {
            return state.config.compartments.get(this);
        }
    }
    class CompartmentInstance {
        constructor(compartment, inner) {
            this.compartment = compartment, this.inner = inner;
        }
    }
    class Configuration {
        constructor(base, compartments, dynamicSlots, address, staticValues, facets) {
            for (this.base = base, this.compartments = compartments, this.dynamicSlots = dynamicSlots, 
            this.address = address, this.staticValues = staticValues, this.facets = facets, 
            this.statusTemplate = []; this.statusTemplate.length < dynamicSlots.length; ) this.statusTemplate.push(0);
        }
        staticFacet(facet) {
            var addr = this.address[facet.id];
            return null == addr ? facet.default : this.staticValues[addr >> 1];
        }
        static resolve(base, compartments, oldState) {
            var ext, fields = [], facets = Object.create(null), newCompartments = new Map();
            for (ext of function(extension, compartments, newCompartments) {
                let result = [ [], [], [], [], [] ], seen = new Map();
                return function inner(ext, prec) {
                    var known = seen.get(ext);
                    if (null != known) {
                        if (known <= prec) return;
                        var found = result[known].indexOf(ext);
                        -1 < found && result[known].splice(found, 1), ext instanceof CompartmentInstance && newCompartments.delete(ext.compartment);
                    }
                    if (seen.set(ext, prec), Array.isArray(ext)) for (var e of ext) inner(e, prec); else if (ext instanceof CompartmentInstance) {
                        if (newCompartments.has(ext.compartment)) throw new RangeError("Duplicate use of compartment in extensions");
                        known = compartments.get(ext.compartment) || ext.inner, 
                        newCompartments.set(ext.compartment, known), inner(known, prec);
                    } else if (ext instanceof PrecExtension) inner(ext.inner, ext.prec); else if (ext instanceof StateField) result[prec].push(ext), 
                    ext.provides && inner(ext.provides, prec); else if (ext instanceof FacetProvider) result[prec].push(ext), 
                    ext.facet.extensions && inner(ext.facet.extensions, Prec_.default); else {
                        let content = ext.extension;
                        if (!content) throw new Error(`Unrecognized extension value in extension set (${ext}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);
                        inner(content, prec);
                    }
                }(extension, Prec_.default), result.reduce((a, b) => a.concat(b));
            }(base, compartments, newCompartments)) (ext instanceof StateField ? fields : facets[ext.facet.id] || (facets[ext.facet.id] = [])).push(ext);
            let address = Object.create(null);
            var staticValues = [], dynamicSlots = [];
            for (let field of fields) address[field.id] = dynamicSlots.length << 1, 
            dynamicSlots.push(a => field.slot(a));
            var id, oldFacets = null == oldState ? void 0 : oldState.config.facets;
            for (id in facets) {
                let providers = facets[id], facet = providers[0].facet;
                var oldProviders = oldFacets && oldFacets[id] || [];
                if (providers.every(p => 0 == p.type)) address[facet.id] = staticValues.length << 1 | 1, 
                sameArray$1(oldProviders, providers) ? staticValues.push(oldState.facet(facet)) : (oldProviders = facet.combine(providers.map(p => p.value)), 
                staticValues.push(oldState && facet.compare(oldProviders, oldState.facet(facet)) ? oldState.facet(facet) : oldProviders)); else {
                    for (let p of providers) 0 == p.type ? (address[p.id] = staticValues.length << 1 | 1, 
                    staticValues.push(p.value)) : (address[p.id] = dynamicSlots.length << 1, 
                    dynamicSlots.push(a => p.dynamicSlot(a)));
                    address[facet.id] = dynamicSlots.length << 1, dynamicSlots.push(a => function(addresses, facet, providers) {
                        let providerAddrs = providers.map(p => addresses[p.id]), providerTypes = providers.map(p => p.type), dynamic = providerAddrs.filter(p => !(1 & p)), idx = addresses[facet.id] >> 1;
                        function get(state) {
                            var values = [];
                            for (let i = 0; i < providerAddrs.length; i++) {
                                var value = getAddr(state, providerAddrs[i]);
                                if (2 == providerTypes[i]) for (var val of value) values.push(val); else values.push(value);
                            }
                            return facet.combine(values);
                        }
                        return {
                            create(state) {
                                for (var addr of providerAddrs) ensureAddr(state, addr);
                                return state.values[idx] = get(state), 1;
                            },
                            update(state, tr) {
                                var value;
                                return !ensureAll(state, dynamic) || (value = get(state), 
                                facet.compare(value, state.values[idx])) ? 0 : (state.values[idx] = value, 
                                1);
                            },
                            reconfigure(state, oldState) {
                                var depChanged = ensureAll(state, providerAddrs), oldProviders = oldState.config.facets[facet.id], oldState = oldState.facet(facet);
                                return oldProviders && !depChanged && sameArray$1(providers, oldProviders) || (depChanged = get(state), 
                                facet.compare(depChanged, oldState)) ? (state.values[idx] = oldState, 
                                0) : (state.values[idx] = depChanged, 1);
                            }
                        };
                    }(a, facet, providers));
                }
            }
            compartments = dynamicSlots.map(f => f(address));
            return new Configuration(base, newCompartments, compartments, address, staticValues, facets);
        }
    }
    function ensureAddr(state, addr) {
        if (1 & addr) return 2;
        var addr = addr >> 1, status = state.status[addr];
        if (4 == status) throw new Error("Cyclic dependency between fields and/or facets");
        if (2 & status) return status;
        state.status[addr] = 4;
        status = state.computeSlot(state, state.config.dynamicSlots[addr]);
        return state.status[addr] = 2 | status;
    }
    function getAddr(state, addr) {
        return (1 & addr ? state.config.staticValues : state.values)[addr >> 1];
    }
    const languageData = Facet.define(), allowMultipleSelections = Facet.define({
        combine: values => values.some(v => v),
        static: !0
    }), lineSeparator = Facet.define({
        combine: values => values.length ? values[0] : void 0,
        static: !0
    }), changeFilter = Facet.define(), transactionFilter = Facet.define(), transactionExtender = Facet.define(), readOnly = Facet.define({
        combine: values => !!values.length && values[0]
    });
    class Annotation {
        constructor(type, value) {
            this.type = type, this.value = value;
        }
        static define() {
            return new AnnotationType();
        }
    }
    class AnnotationType {
        of(value) {
            return new Annotation(this, value);
        }
    }
    class StateEffectType {
        constructor(map) {
            this.map = map;
        }
        of(value) {
            return new StateEffect(this, value);
        }
    }
    class StateEffect {
        constructor(type, value) {
            this.type = type, this.value = value;
        }
        map(mapping) {
            mapping = this.type.map(this.value, mapping);
            return void 0 === mapping ? void 0 : mapping == this.value ? this : new StateEffect(this.type, mapping);
        }
        is(type) {
            return this.type == type;
        }
        static define(spec = {}) {
            return new StateEffectType(spec.map || (v => v));
        }
        static mapEffects(effects, mapping) {
            if (!effects.length) return effects;
            var effect, result = [];
            for (effect of effects) {
                var mapped = effect.map(mapping);
                mapped && result.push(mapped);
            }
            return result;
        }
    }
    StateEffect.reconfigure = StateEffect.define(), StateEffect.appendConfig = StateEffect.define();
    class Transaction {
        constructor(startState, changes, selection, effects, annotations, scrollIntoView) {
            this.startState = startState, this.changes = changes, this.selection = selection, 
            this.effects = effects, this.annotations = annotations, this.scrollIntoView = scrollIntoView, 
            this._doc = null, this._state = null, selection && checkSelection(selection, changes.newLength), 
            annotations.some(a => a.type == Transaction.time) || (this.annotations = annotations.concat(Transaction.time.of(Date.now())));
        }
        static create(startState, changes, selection, effects, annotations, scrollIntoView) {
            return new Transaction(startState, changes, selection, effects, annotations, scrollIntoView);
        }
        get newDoc() {
            return this._doc || (this._doc = this.changes.apply(this.startState.doc));
        }
        get newSelection() {
            return this.selection || this.startState.selection.map(this.changes);
        }
        get state() {
            return this._state || this.startState.applyTransaction(this), this._state;
        }
        annotation(type) {
            for (var ann of this.annotations) if (ann.type == type) return ann.value;
        }
        get docChanged() {
            return !this.changes.empty;
        }
        get reconfigured() {
            return this.startState.config != this.state.config;
        }
        isUserEvent(event) {
            var e = this.annotation(Transaction.userEvent);
            return !(!e || !(e == event || e.length > event.length && e.slice(0, event.length) == event && "." == e[event.length]));
        }
    }
    function mergeTransaction(a, b, sequential) {
        let mapForA, mapForB, changes;
        return {
            changes: changes = sequential ? (mapForA = b.changes, mapForB = ChangeSet.empty(b.changes.length), 
            a.changes.compose(b.changes)) : (mapForA = b.changes.map(a.changes), 
            mapForB = a.changes.mapDesc(b.changes, !0), a.changes.compose(mapForA)),
            selection: b.selection ? b.selection.map(mapForB) : null == (sequential = a.selection) ? void 0 : sequential.map(mapForA),
            effects: StateEffect.mapEffects(a.effects, mapForA).concat(StateEffect.mapEffects(b.effects, mapForB)),
            annotations: a.annotations.length ? a.annotations.concat(b.annotations) : b.annotations,
            scrollIntoView: a.scrollIntoView || b.scrollIntoView
        };
    }
    function resolveTransactionInner(state, spec, docSize) {
        let sel = spec.selection, annotations = asArray$1(spec.annotations);
        return spec.userEvent && (annotations = annotations.concat(Transaction.userEvent.of(spec.userEvent))), 
        {
            changes: spec.changes instanceof ChangeSet ? spec.changes : ChangeSet.of(spec.changes || [], docSize, state.facet(lineSeparator)),
            selection: sel && (sel instanceof EditorSelection ? sel : EditorSelection.single(sel.anchor, sel.head)),
            effects: asArray$1(spec.effects),
            annotations: annotations,
            scrollIntoView: !!spec.scrollIntoView
        };
    }
    function resolveTransaction(state, specs, filter) {
        let s = resolveTransactionInner(state, specs.length ? specs[0] : {}, state.doc.length);
        specs.length && !1 === specs[0].filter && (filter = !1);
        for (let i = 1; i < specs.length; i++) {
            !1 === specs[i].filter && (filter = !1);
            var seq = !!specs[i].sequential;
            s = mergeTransaction(s, resolveTransactionInner(state, specs[i], seq ? s.changes.newLength : state.doc.length), seq);
        }
        var tr = Transaction.create(state, s.changes, s.selection, s.effects, s.annotations, s.scrollIntoView);
        return function(tr) {
            let state = tr.startState, extenders = state.facet(transactionExtender), spec = tr;
            for (let i = extenders.length - 1; 0 <= i; i--) {
                var extension = extenders[i](tr);
                extension && Object.keys(extension).length && (spec = mergeTransaction(spec, resolveTransactionInner(state, extension, tr.changes.newLength), !0));
            }
            return spec == tr ? tr : Transaction.create(state, tr.changes, tr.selection, spec.effects, spec.annotations, spec.scrollIntoView);
        }(filter ? function(tr) {
            let state = tr.startState, result = !0;
            for (var filter of state.facet(changeFilter)) {
                filter = filter(tr);
                if (!1 === filter) {
                    result = !1;
                    break;
                }
                Array.isArray(filter) && (result = !0 === result ? filter : function(a, b) {
                    var result = [];
                    for (let iA = 0, iB = 0; ;) {
                        let from, to;
                        if (iA < a.length && (iB == b.length || b[iB] >= a[iA])) from = a[iA++], 
                        to = a[iA++]; else {
                            if (!(iB < b.length)) return result;
                            from = b[iB++], to = b[iB++];
                        }
                        !result.length || result[result.length - 1] < from ? result.push(from, to) : result[result.length - 1] < to && (result[result.length - 1] = to);
                    }
                }(result, filter));
            }
            if (!0 !== result) {
                let changes, back;
                var filtered;
                !1 === result ? (back = tr.changes.invertedDesc, changes = ChangeSet.empty(state.doc.length)) : (filtered = tr.changes.filter(result), 
                changes = filtered.changes, back = filtered.filtered.mapDesc(filtered.changes).invertedDesc), 
                tr = Transaction.create(state, changes, tr.selection && tr.selection.map(back), StateEffect.mapEffects(tr.effects, back), tr.annotations, tr.scrollIntoView);
            }
            var filters = state.facet(transactionFilter);
            for (let i = filters.length - 1; 0 <= i; i--) {
                var filtered = filters[i](tr);
                tr = filtered instanceof Transaction ? filtered : Array.isArray(filtered) && 1 == filtered.length && filtered[0] instanceof Transaction ? filtered[0] : resolveTransaction(state, asArray$1(filtered), !1);
            }
            return tr;
        }(tr) : tr);
    }
    Transaction.time = Annotation.define(), Transaction.userEvent = Annotation.define(), 
    Transaction.addToHistory = Annotation.define(), Transaction.remote = Annotation.define();
    const none$3 = [];
    function asArray$1(value) {
        return null == value ? none$3 : Array.isArray(value) ? value : [ value ];
    }
    var CharCategory = function(CharCategory) {
        return CharCategory[CharCategory.Word = 0] = "Word", CharCategory[CharCategory.Space = 1] = "Space", 
        CharCategory[CharCategory.Other = 2] = "Other", CharCategory;
    }(CharCategory = CharCategory || {});
    const nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
    let wordChar;
    try {
        wordChar = new RegExp("[\\p{Alphabetic}\\p{Number}_]", "u");
    } catch (_) {}
    function makeCategorizer(wordChars) {
        return char => {
            if (!/\S/.test(char)) return CharCategory.Space;
            if (function(str) {
                if (wordChar) return wordChar.test(str);
                for (let i = 0; i < str.length; i++) {
                    var ch = str[i];
                    if (/\w/.test(ch) || "\x80" < ch && (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch))) return 1;
                }
            }(char)) return CharCategory.Word;
            for (let i = 0; i < wordChars.length; i++) if (-1 < char.indexOf(wordChars[i])) return CharCategory.Word;
            return CharCategory.Other;
        };
    }
    class EditorState {
        constructor(config, doc, selection, values, computeSlot, tr) {
            this.config = config, this.doc = doc, this.selection = selection, this.values = values, 
            this.status = config.statusTemplate.slice(), this.computeSlot = computeSlot, 
            tr && (tr._state = this);
            for (let i = 0; i < this.config.dynamicSlots.length; i++) ensureAddr(this, i << 1);
            this.computeSlot = null;
        }
        field(field, require = !0) {
            field = this.config.address[field.id];
            if (null != field) return ensureAddr(this, field), getAddr(this, field);
            if (require) throw new RangeError("Field is not present in this state");
        }
        update(...specs) {
            return resolveTransaction(this, specs, !0);
        }
        applyTransaction(tr) {
            let conf = this.config, {
                base,
                compartments
            } = conf;
            for (var effect of tr.effects) effect.is(Compartment.reconfigure) ? (conf && (compartments = new Map(), 
            conf.compartments.forEach((val, key) => compartments.set(key, val)), 
            conf = null), compartments.set(effect.value.compartment, effect.value.extension)) : effect.is(StateEffect.reconfigure) ? (conf = null, 
            base = effect.value) : effect.is(StateEffect.appendConfig) && (conf = null, 
            base = asArray$1(base).concat(effect.value));
            let startValues;
            startValues = conf ? tr.startState.values.slice() : (conf = Configuration.resolve(base, compartments, this), 
            new EditorState(conf, this.doc, this.selection, conf.dynamicSlots.map(() => null), (state, slot) => slot.reconfigure(state, this), null).values);
            var selection = tr.startState.facet(allowMultipleSelections) ? tr.newSelection : tr.newSelection.asSingle();
            new EditorState(conf, tr.newDoc, selection, startValues, (state, slot) => slot.update(state, tr), tr);
        }
        replaceSelection(text) {
            return "string" == typeof text && (text = this.toText(text)), this.changeByRange(range => ({
                changes: {
                    from: range.from,
                    to: range.to,
                    insert: text
                },
                range: EditorSelection.cursor(range.from + text.length)
            }));
        }
        changeByRange(f) {
            var sel = this.selection, result1 = f(sel.ranges[0]);
            let changes = this.changes(result1.changes), ranges = [ result1.range ], effects = asArray$1(result1.effects);
            for (let i = 1; i < sel.ranges.length; i++) {
                var result = f(sel.ranges[i]), newChanges = this.changes(result.changes), newMapped = newChanges.map(changes);
                for (let j = 0; j < i; j++) ranges[j] = ranges[j].map(newMapped);
                newChanges = changes.mapDesc(newChanges, !0);
                ranges.push(result.range.map(newChanges)), changes = changes.compose(newMapped), 
                effects = StateEffect.mapEffects(effects, newMapped).concat(StateEffect.mapEffects(asArray$1(result.effects), newChanges));
            }
            return {
                changes: changes,
                selection: EditorSelection.create(ranges, sel.mainIndex),
                effects: effects
            };
        }
        changes(spec = []) {
            return spec instanceof ChangeSet ? spec : ChangeSet.of(spec, this.doc.length, this.facet(EditorState.lineSeparator));
        }
        toText(string) {
            return Text.of(string.split(this.facet(EditorState.lineSeparator) || DefaultSplit));
        }
        sliceDoc(from = 0, to = this.doc.length) {
            return this.doc.sliceString(from, to, this.lineBreak);
        }
        facet(facet) {
            var addr = this.config.address[facet.id];
            return null == addr ? facet.default : (ensureAddr(this, addr), getAddr(this, addr));
        }
        toJSON(fields) {
            var result = {
                doc: this.sliceDoc(),
                selection: this.selection.toJSON()
            };
            if (fields) for (var prop in fields) {
                var value = fields[prop];
                value instanceof StateField && null != this.config.address[value.id] && (result[prop] = value.spec.toJSON(this.field(fields[prop]), this));
            }
            return result;
        }
        static fromJSON(json, config = {}, fields) {
            if (!json || "string" != typeof json.doc) throw new RangeError("Invalid JSON representation for EditorState");
            var fieldInit = [];
            if (fields) for (var prop in fields) if (Object.prototype.hasOwnProperty.call(json, prop)) {
                let field = fields[prop], value = json[prop];
                fieldInit.push(field.init(state => field.spec.fromJSON(value, state)));
            }
            return EditorState.create({
                doc: json.doc,
                selection: EditorSelection.fromJSON(json.selection),
                extensions: config.extensions ? fieldInit.concat([ config.extensions ]) : fieldInit
            });
        }
        static create(config = {}) {
            var configuration = Configuration.resolve(config.extensions || [], new Map()), doc = config.doc instanceof Text ? config.doc : Text.of((config.doc || "").split(configuration.staticFacet(EditorState.lineSeparator) || DefaultSplit));
            let selection = config.selection ? config.selection instanceof EditorSelection ? config.selection : EditorSelection.single(config.selection.anchor, config.selection.head) : EditorSelection.single(0);
            return checkSelection(selection, doc.length), configuration.staticFacet(allowMultipleSelections) || (selection = selection.asSingle()), 
            new EditorState(configuration, doc, selection, configuration.dynamicSlots.map(() => null), (state, slot) => slot.create(state), null);
        }
        get tabSize() {
            return this.facet(EditorState.tabSize);
        }
        get lineBreak() {
            return this.facet(EditorState.lineSeparator) || "\n";
        }
        get readOnly() {
            return this.facet(readOnly);
        }
        phrase(phrase, ...insert) {
            for (var map of this.facet(EditorState.phrases)) if (Object.prototype.hasOwnProperty.call(map, phrase)) {
                phrase = map[phrase];
                break;
            }
            return phrase = insert.length ? phrase.replace(/\$(\$|\d*)/g, (m, i) => {
                return "$" == i ? "$" : !(i = +(i || 1)) || i > insert.length ? m : insert[i - 1];
            }) : phrase;
        }
        languageDataAt(name, pos, side = -1) {
            var provider, values = [];
            for (provider of this.facet(languageData)) for (var result of provider(this, pos, side)) Object.prototype.hasOwnProperty.call(result, name) && values.push(result[name]);
            return values;
        }
        charCategorizer(at) {
            return makeCategorizer(this.languageDataAt("wordChars", at).join(""));
        }
        wordAt(pos) {
            var {
                text,
                from,
                length
            } = this.doc.lineAt(pos), cat = this.charCategorizer(pos);
            let start = pos - from, end = pos - from;
            for (;0 < start; ) {
                var prev = findClusterBreak(text, start, !1);
                if (cat(text.slice(prev, start)) != CharCategory.Word) break;
                start = prev;
            }
            for (;end < length; ) {
                var next = findClusterBreak(text, end);
                if (cat(text.slice(end, next)) != CharCategory.Word) break;
                end = next;
            }
            return start == end ? null : EditorSelection.range(start + from, end + from);
        }
    }
    function combineConfig(configs, defaults, combine = {}) {
        var config, result = {};
        for (config of configs) for (var key of Object.keys(config)) {
            var value = config[key], current = result[key];
            if (void 0 === current) result[key] = value; else if (current !== value && void 0 !== value) {
                if (!Object.hasOwnProperty.call(combine, key)) throw new Error("Config merge conflict for field " + key);
                result[key] = combine[key](current, value);
            }
        }
        for (let key in defaults) void 0 === result[key] && (result[key] = defaults[key]);
        return result;
    }
    EditorState.allowMultipleSelections = allowMultipleSelections, EditorState.tabSize = Facet.define({
        combine: values => values.length ? values[0] : 4
    }), EditorState.lineSeparator = lineSeparator, EditorState.readOnly = readOnly, 
    EditorState.phrases = Facet.define({
        compare(a, b) {
            var kA = Object.keys(a), kB = Object.keys(b);
            return kA.length == kB.length && kA.every(k => a[k] == b[k]);
        }
    }), EditorState.languageData = languageData, EditorState.changeFilter = changeFilter, 
    EditorState.transactionFilter = transactionFilter, EditorState.transactionExtender = transactionExtender, 
    Compartment.reconfigure = StateEffect.define();
    class RangeValue {
        eq(other) {
            return this == other;
        }
        range(from, to = from) {
            return Range$1.create(from, to, this);
        }
    }
    RangeValue.prototype.startSide = RangeValue.prototype.endSide = 0, RangeValue.prototype.point = !1, 
    RangeValue.prototype.mapMode = MapMode.TrackDel;
    let Range$1 = class Range {
        constructor(from, to, value) {
            this.from = from, this.to = to, this.value = value;
        }
        static create(from, to, value) {
            return new Range(from, to, value);
        }
    };
    function cmpRange(a, b) {
        return a.from - b.from || a.value.startSide - b.value.startSide;
    }
    class Chunk {
        constructor(from, to, value, maxPoint) {
            this.from = from, this.to = to, this.value = value, this.maxPoint = maxPoint;
        }
        get length() {
            return this.to[this.to.length - 1];
        }
        findIndex(pos, side, end, startAt = 0) {
            var arr = end ? this.to : this.from;
            for (let lo = startAt, hi = arr.length; ;) {
                if (lo == hi) return lo;
                var mid = lo + hi >> 1, diff = arr[mid] - pos || (end ? this.value[mid].endSide : this.value[mid].startSide) - side;
                if (mid == lo) return 0 <= diff ? lo : hi;
                0 <= diff ? hi = mid : lo = 1 + mid;
            }
        }
        between(offset, from, to, f) {
            for (let i = this.findIndex(from, -1e9, !0), e = this.findIndex(to, 1e9, !1, i); i < e; i++) if (!1 === f(this.from[i] + offset, this.to[i] + offset, this.value[i])) return !1;
        }
        map(offset, changes) {
            let value = [], from = [], to = [], newPos = -1, maxPoint = -1;
            for (let i = 0; i < this.value.length; i++) {
                let val = this.value[i], curFrom = this.from[i] + offset, curTo = this.to[i] + offset, newFrom, newTo;
                if (curFrom == curTo) {
                    var mapped = changes.mapPos(curFrom, val.startSide, val.mapMode);
                    if (null == mapped) continue;
                    if (newFrom = newTo = mapped, val.startSide != val.endSide && (newTo = changes.mapPos(curFrom, val.endSide)) < newFrom) continue;
                } else if (newFrom = changes.mapPos(curFrom, val.startSide), newTo = changes.mapPos(curTo, val.endSide), 
                newFrom > newTo || newFrom == newTo && 0 < val.startSide && val.endSide <= 0) continue;
                (newTo - newFrom || val.endSide - val.startSide) < 0 || (newPos < 0 && (newPos = newFrom), 
                val.point && (maxPoint = Math.max(maxPoint, newTo - newFrom)), value.push(val), 
                from.push(newFrom - newPos), to.push(newTo - newPos));
            }
            return {
                mapped: value.length ? new Chunk(from, to, value, maxPoint) : null,
                pos: newPos
            };
        }
    }
    class RangeSet {
        constructor(chunkPos, chunk, nextLayer, maxPoint) {
            this.chunkPos = chunkPos, this.chunk = chunk, this.nextLayer = nextLayer, 
            this.maxPoint = maxPoint;
        }
        static create(chunkPos, chunk, nextLayer, maxPoint) {
            return new RangeSet(chunkPos, chunk, nextLayer, maxPoint);
        }
        get length() {
            var last = this.chunk.length - 1;
            return last < 0 ? 0 : Math.max(this.chunkEnd(last), this.nextLayer.length);
        }
        get size() {
            if (this.isEmpty) return 0;
            let size = this.nextLayer.size;
            for (var chunk of this.chunk) size += chunk.value.length;
            return size;
        }
        chunkEnd(index) {
            return this.chunkPos[index] + this.chunk[index].length;
        }
        update(updateSpec) {
            let {
                add = [],
                sort = !1,
                filterFrom = 0,
                filterTo = this.length
            } = updateSpec;
            var filter = updateSpec.filter;
            if (0 == add.length && !filter) return this;
            if (sort && (add = add.slice().sort(cmpRange)), this.isEmpty) return add.length ? RangeSet.of(add) : this;
            let cur = new LayerCursor(this, null, -1).goto(0), i = 0, spill = [];
            for (var range, builder = new RangeSetBuilder(); cur.value || i < add.length; ) i < add.length && 0 <= (cur.from - add[i].from || cur.startSide - add[i].value.startSide) ? (range = add[i++], 
            builder.addInner(range.from, range.to, range.value) || spill.push(range)) : 1 == cur.rangeIndex && cur.chunkIndex < this.chunk.length && (i == add.length || this.chunkEnd(cur.chunkIndex) < add[i].from) && (!filter || filterFrom > this.chunkEnd(cur.chunkIndex) || filterTo < this.chunkPos[cur.chunkIndex]) && builder.addChunk(this.chunkPos[cur.chunkIndex], this.chunk[cur.chunkIndex]) ? cur.nextChunk() : ((!filter || filterFrom > cur.to || filterTo < cur.from || filter(cur.from, cur.to, cur.value)) && !builder.addInner(cur.from, cur.to, cur.value) && spill.push(Range$1.create(cur.from, cur.to, cur.value)), 
            cur.next());
            return builder.finishInner(this.nextLayer.isEmpty && !spill.length ? RangeSet.empty : this.nextLayer.update({
                add: spill,
                filter: filter,
                filterFrom: filterFrom,
                filterTo: filterTo
            }));
        }
        map(changes) {
            if (changes.empty || this.isEmpty) return this;
            let chunks = [], chunkPos = [], maxPoint = -1;
            for (let i = 0; i < this.chunk.length; i++) {
                var start = this.chunkPos[i], chunk = this.chunk[i], touch = changes.touchesRange(start, start + chunk.length);
                !1 === touch ? (maxPoint = Math.max(maxPoint, chunk.maxPoint), chunks.push(chunk), 
                chunkPos.push(changes.mapPos(start))) : !0 === touch && ({
                    mapped: touch,
                    pos: chunk
                } = chunk.map(start, changes), touch) && (maxPoint = Math.max(maxPoint, touch.maxPoint), 
                chunks.push(touch), chunkPos.push(chunk));
            }
            var next = this.nextLayer.map(changes);
            return 0 == chunks.length ? next : new RangeSet(chunkPos, chunks, next || RangeSet.empty, maxPoint);
        }
        between(from, to, f) {
            if (!this.isEmpty) {
                for (let i = 0; i < this.chunk.length; i++) {
                    var start = this.chunkPos[i], chunk = this.chunk[i];
                    if (start <= to && from <= start + chunk.length && !1 === chunk.between(start, from - start, to - start, f)) return;
                }
                this.nextLayer.between(from, to, f);
            }
        }
        iter(from = 0) {
            return HeapCursor.from([ this ]).goto(from);
        }
        get isEmpty() {
            return this.nextLayer == this;
        }
        static iter(sets, from = 0) {
            return HeapCursor.from(sets).goto(from);
        }
        static compare(oldSets, newSets, textDiff, comparator, minPointSize = -1) {
            var oldSets = oldSets.filter(set => 0 < set.maxPoint || !set.isEmpty && set.maxPoint >= minPointSize), newSets = newSets.filter(set => 0 < set.maxPoint || !set.isEmpty && set.maxPoint >= minPointSize), sharedChunks = findSharedChunks(oldSets, newSets, textDiff);
            let sideA = new SpanCursor(oldSets, sharedChunks, minPointSize), sideB = new SpanCursor(newSets, sharedChunks, minPointSize);
            textDiff.iterGaps((fromA, fromB, length) => compare(sideA, fromA, sideB, fromB, length, comparator)), 
            textDiff.empty && 0 == textDiff.length && compare(sideA, 0, sideB, 0, 0, comparator);
        }
        static eq(oldSets, newSets, from = 0, to) {
            null == to && (to = 1e9 - 1);
            var a = oldSets.filter(set => !set.isEmpty && newSets.indexOf(set) < 0), b = newSets.filter(set => !set.isEmpty && oldSets.indexOf(set) < 0);
            if (a.length != b.length) return !1;
            if (!a.length) return !0;
            for (var sharedChunks = findSharedChunks(a, b), sideA = new SpanCursor(a, sharedChunks, 0).goto(from), sideB = new SpanCursor(b, sharedChunks, 0).goto(from); ;) {
                if (sideA.to != sideB.to || !sameValues(sideA.active, sideB.active) || sideA.point && (!sideB.point || !sideA.point.eq(sideB.point))) return !1;
                if (sideA.to > to) return !0;
                sideA.next(), sideB.next();
            }
        }
        static spans(sets, from, to, iterator, minPointSize = -1) {
            let cursor = new SpanCursor(sets, null, minPointSize).goto(from), pos = from, openRanges = cursor.openStart;
            for (;;) {
                var active, openCount, curTo = Math.min(cursor.to, to);
                if (cursor.point ? (active = cursor.activeForPoint(cursor.to), openCount = cursor.pointFrom < from ? active.length + 1 : cursor.point.startSide < 0 ? active.length : Math.min(active.length, openRanges), 
                iterator.point(pos, curTo, cursor.point, active, openCount, cursor.pointRank), 
                openRanges = Math.min(cursor.openEnd(curTo), active.length)) : curTo > pos && (iterator.span(pos, curTo, cursor.active, openRanges), 
                openRanges = cursor.openEnd(curTo)), cursor.to > to) return openRanges + (cursor.point && cursor.to > to ? 1 : 0);
                pos = cursor.to, cursor.next();
            }
        }
        static of(ranges, sort = !1) {
            var range, build = new RangeSetBuilder();
            for (range of ranges instanceof Range$1 ? [ ranges ] : sort ? function(ranges) {
                if (1 < ranges.length) for (let prev = ranges[0], i = 1; i < ranges.length; i++) {
                    var cur = ranges[i];
                    if (0 < cmpRange(prev, cur)) return ranges.slice().sort(cmpRange);
                    prev = cur;
                }
                return ranges;
            }(ranges) : ranges) build.add(range.from, range.to, range.value);
            return build.finish();
        }
        static join(sets) {
            if (!sets.length) return RangeSet.empty;
            let result = sets[sets.length - 1];
            for (let i = sets.length - 2; 0 <= i; i--) for (let layer = sets[i]; layer != RangeSet.empty; layer = layer.nextLayer) result = new RangeSet(layer.chunkPos, layer.chunk, result, Math.max(layer.maxPoint, result.maxPoint));
            return result;
        }
    }
    RangeSet.empty = new RangeSet([], [], null, -1), RangeSet.empty.nextLayer = RangeSet.empty;
    class RangeSetBuilder {
        finishChunk(newArrays) {
            this.chunks.push(new Chunk(this.from, this.to, this.value, this.maxPoint)), 
            this.chunkPos.push(this.chunkStart), this.chunkStart = -1, this.setMaxPoint = Math.max(this.setMaxPoint, this.maxPoint), 
            this.maxPoint = -1, newArrays && (this.from = [], this.to = [], this.value = []);
        }
        constructor() {
            this.chunks = [], this.chunkPos = [], this.chunkStart = -1, this.last = null, 
            this.lastFrom = -1e9, this.lastTo = -1e9, this.from = [], this.to = [], 
            this.value = [], this.maxPoint = -1, this.setMaxPoint = -1, this.nextLayer = null;
        }
        add(from, to, value) {
            this.addInner(from, to, value) || (this.nextLayer || (this.nextLayer = new RangeSetBuilder())).add(from, to, value);
        }
        addInner(from, to, value) {
            var diff = from - this.lastTo || value.startSide - this.last.endSide;
            if (diff <= 0 && (from - this.lastFrom || value.startSide - this.last.startSide) < 0) throw new Error("Ranges must be added sorted by `from` position and `startSide`");
            return !(diff < 0 || (250 == this.from.length && this.finishChunk(!0), 
            this.chunkStart < 0 && (this.chunkStart = from), this.from.push(from - this.chunkStart), 
            this.to.push(to - this.chunkStart), this.last = value, this.lastFrom = from, 
            this.lastTo = to, this.value.push(value), value.point && (this.maxPoint = Math.max(this.maxPoint, to - from)), 
            0));
        }
        addChunk(from, chunk) {
            if ((from - this.lastTo || chunk.value[0].startSide - this.last.endSide) < 0) return !1;
            this.from.length && this.finishChunk(!0), this.setMaxPoint = Math.max(this.setMaxPoint, chunk.maxPoint), 
            this.chunks.push(chunk), this.chunkPos.push(from);
            var last = chunk.value.length - 1;
            return this.last = chunk.value[last], this.lastFrom = chunk.from[last] + from, 
            this.lastTo = chunk.to[last] + from, !0;
        }
        finish() {
            return this.finishInner(RangeSet.empty);
        }
        finishInner(next) {
            return this.from.length && this.finishChunk(!1), 0 == this.chunks.length || (next = RangeSet.create(this.chunkPos, this.chunks, this.nextLayer ? this.nextLayer.finishInner(next) : next, this.setMaxPoint), 
            this.from = null), next;
        }
    }
    function findSharedChunks(a, b, textDiff) {
        var set, inA = new Map();
        for (set of a) for (let i = 0; i < set.chunk.length; i++) set.chunk[i].maxPoint <= 0 && inA.set(set.chunk[i], set.chunkPos[i]);
        var shared = new Set();
        for (let set of b) for (let i = 0; i < set.chunk.length; i++) {
            var known = inA.get(set.chunk[i]);
            null == known || (textDiff ? textDiff.mapPos(known) : known) != set.chunkPos[i] || null != textDiff && textDiff.touchesRange(known, known + set.chunk[i].length) || shared.add(set.chunk[i]);
        }
        return shared;
    }
    class LayerCursor {
        constructor(layer, skip, minPoint, rank = 0) {
            this.layer = layer, this.skip = skip, this.minPoint = minPoint, this.rank = rank;
        }
        get startSide() {
            return this.value ? this.value.startSide : 0;
        }
        get endSide() {
            return this.value ? this.value.endSide : 0;
        }
        goto(pos, side = -1e9) {
            return this.chunkIndex = this.rangeIndex = 0, this.gotoInner(pos, side, !1), 
            this;
        }
        gotoInner(pos, side, forward) {
            for (;this.chunkIndex < this.layer.chunk.length; ) {
                var next = this.layer.chunk[this.chunkIndex];
                if (!(this.skip && this.skip.has(next) || this.layer.chunkEnd(this.chunkIndex) < pos || next.maxPoint < this.minPoint)) break;
                this.chunkIndex++, forward = !1;
            }
            this.chunkIndex < this.layer.chunk.length && (side = this.layer.chunk[this.chunkIndex].findIndex(pos - this.layer.chunkPos[this.chunkIndex], side, !0), 
            !forward || this.rangeIndex < side) && this.setRangeIndex(side), this.next();
        }
        forward(pos, side) {
            (this.to - pos || this.endSide - side) < 0 && this.gotoInner(pos, side, !0);
        }
        next() {
            for (;;) {
                if (this.chunkIndex == this.layer.chunk.length) {
                    this.from = this.to = 1e9, this.value = null;
                    break;
                }
                var chunkPos = this.layer.chunkPos[this.chunkIndex], chunk = this.layer.chunk[this.chunkIndex], from = chunkPos + chunk.from[this.rangeIndex];
                if (this.from = from, this.to = chunkPos + chunk.to[this.rangeIndex], 
                this.value = chunk.value[this.rangeIndex], this.setRangeIndex(this.rangeIndex + 1), 
                this.minPoint < 0 || this.value.point && this.to - this.from >= this.minPoint) break;
            }
        }
        setRangeIndex(index) {
            if (index == this.layer.chunk[this.chunkIndex].value.length) {
                if (this.chunkIndex++, this.skip) for (;this.chunkIndex < this.layer.chunk.length && this.skip.has(this.layer.chunk[this.chunkIndex]); ) this.chunkIndex++;
                this.rangeIndex = 0;
            } else this.rangeIndex = index;
        }
        nextChunk() {
            this.chunkIndex++, this.rangeIndex = 0, this.next();
        }
        compare(other) {
            return this.from - other.from || this.startSide - other.startSide || this.rank - other.rank || this.to - other.to || this.endSide - other.endSide;
        }
    }
    class HeapCursor {
        constructor(heap) {
            this.heap = heap;
        }
        static from(sets, skip = null, minPoint = -1) {
            var heap = [];
            for (let i = 0; i < sets.length; i++) for (let cur = sets[i]; !cur.isEmpty; cur = cur.nextLayer) cur.maxPoint >= minPoint && heap.push(new LayerCursor(cur, skip, minPoint, i));
            return 1 == heap.length ? heap[0] : new HeapCursor(heap);
        }
        get startSide() {
            return this.value ? this.value.startSide : 0;
        }
        goto(pos, side = -1e9) {
            for (var cur of this.heap) cur.goto(pos, side);
            for (let i = this.heap.length >> 1; 0 <= i; i--) heapBubble(this.heap, i);
            return this.next(), this;
        }
        forward(pos, side) {
            for (var cur of this.heap) cur.forward(pos, side);
            for (let i = this.heap.length >> 1; 0 <= i; i--) heapBubble(this.heap, i);
            (this.to - pos || this.value.endSide - side) < 0 && this.next();
        }
        next() {
            var top;
            0 == this.heap.length ? (this.from = this.to = 1e9, this.value = null, 
            this.rank = -1) : (top = this.heap[0], this.from = top.from, this.to = top.to, 
            this.value = top.value, this.rank = top.rank, top.value && top.next(), 
            heapBubble(this.heap, 0));
        }
    }
    function heapBubble(heap, index) {
        for (var cur = heap[index]; ;) {
            let childIndex = 1 + (index << 1);
            if (childIndex >= heap.length) break;
            let child = heap[childIndex];
            if (childIndex + 1 < heap.length && 0 <= child.compare(heap[childIndex + 1]) && (child = heap[childIndex + 1], 
            childIndex++), cur.compare(child) < 0) break;
            heap[childIndex] = cur, heap[index] = child, index = childIndex;
        }
    }
    class SpanCursor {
        constructor(sets, skip, minPoint) {
            this.minPoint = minPoint, this.active = [], this.activeTo = [], this.activeRank = [], 
            this.minActive = -1, this.point = null, this.pointFrom = 0, this.pointRank = 0, 
            this.to = -1e9, this.endSide = 0, this.openStart = -1, this.cursor = HeapCursor.from(sets, skip, minPoint);
        }
        goto(pos, side = -1e9) {
            return this.cursor.goto(pos, side), this.active.length = this.activeTo.length = this.activeRank.length = 0, 
            this.minActive = -1, this.to = pos, this.endSide = side, this.openStart = -1, 
            this.next(), this;
        }
        forward(pos, side) {
            for (;-1 < this.minActive && (this.activeTo[this.minActive] - pos || this.active[this.minActive].endSide - side) < 0; ) this.removeActive(this.minActive);
            this.cursor.forward(pos, side);
        }
        removeActive(index) {
            remove(this.active, index), remove(this.activeTo, index), remove(this.activeRank, index), 
            this.minActive = findMinIndex(this.active, this.activeTo);
        }
        addActive(trackOpen) {
            let i = 0, {
                value,
                to,
                rank
            } = this.cursor;
            for (;i < this.activeRank.length && 0 < (rank - this.activeRank[i] || to - this.activeTo[i]); ) i++;
            insert(this.active, i, value), insert(this.activeTo, i, to), insert(this.activeRank, i, rank), 
            trackOpen && insert(trackOpen, i, this.cursor.from), this.minActive = findMinIndex(this.active, this.activeTo);
        }
        next() {
            for (var from = this.to, wasPoint = this.point, trackOpen = (this.point = null, 
            this.openStart < 0 ? [] : null); ;) {
                var a = this.minActive;
                if (-1 < a && (this.activeTo[a] - this.cursor.from || this.active[a].endSide - this.cursor.startSide) < 0) {
                    if (this.activeTo[a] > from) {
                        this.to = this.activeTo[a], this.endSide = this.active[a].endSide;
                        break;
                    }
                    this.removeActive(a), trackOpen && remove(trackOpen, a);
                } else {
                    if (!this.cursor.value) {
                        this.to = this.endSide = 1e9;
                        break;
                    }
                    if (this.cursor.from > from) {
                        this.to = this.cursor.from, this.endSide = this.cursor.startSide;
                        break;
                    }
                    a = this.cursor.value;
                    if (a.point) {
                        if (!(wasPoint && this.cursor.to == this.to && this.cursor.from < this.cursor.to)) {
                            this.point = a, this.pointFrom = this.cursor.from, this.pointRank = this.cursor.rank, 
                            this.to = this.cursor.to, this.endSide = a.endSide, 
                            this.cursor.next(), this.forward(this.to, this.endSide);
                            break;
                        }
                    } else this.addActive(trackOpen);
                    this.cursor.next();
                }
            }
            if (trackOpen) {
                this.openStart = 0;
                for (let i = trackOpen.length - 1; 0 <= i && trackOpen[i] < from; i--) this.openStart++;
            }
        }
        activeForPoint(to) {
            if (!this.active.length) return this.active;
            var active = [];
            for (let i = this.active.length - 1; 0 <= i && !(this.activeRank[i] < this.pointRank); i--) (this.activeTo[i] > to || this.activeTo[i] == to && this.active[i].endSide >= this.point.endSide) && active.push(this.active[i]);
            return active.reverse();
        }
        openEnd(to) {
            let open = 0;
            for (let i = this.activeTo.length - 1; 0 <= i && this.activeTo[i] > to; i--) open++;
            return open;
        }
    }
    function compare(a, startA, b, startB, length, comparator) {
        a.goto(startA), b.goto(startB);
        var endB = startB + length;
        let pos = startB, dPos = startB - startA;
        for (;;) {
            var dEnd = a.to + dPos - b.to, diff = dEnd || a.endSide - b.endSide, end = diff < 0 ? a.to + dPos : b.to, clipEnd = Math.min(end, endB);
            if (a.point || b.point ? a.point && b.point && (a.point == b.point || a.point.eq(b.point)) && sameValues(a.activeForPoint(a.to), b.activeForPoint(b.to)) || comparator.comparePoint(pos, clipEnd, a.point, b.point) : clipEnd > pos && !sameValues(a.active, b.active) && comparator.compareRange(pos, clipEnd, a.active, b.active), 
            endB < end) break;
            (dEnd || a.openEnd != b.openEnd) && comparator.boundChange && comparator.boundChange(end), 
            pos = end, diff <= 0 && a.next(), 0 <= diff && b.next();
        }
    }
    function sameValues(a, b) {
        if (a.length == b.length) {
            for (let i = 0; i < a.length; i++) if (a[i] != b[i] && !a[i].eq(b[i])) return;
            return 1;
        }
    }
    function remove(array, index) {
        for (let i = index, e = array.length - 1; i < e; i++) array[i] = array[i + 1];
        array.pop();
    }
    function insert(array, index, value) {
        for (let i = array.length - 1; i >= index; i--) array[i + 1] = array[i];
        array[index] = value;
    }
    function findMinIndex(value, array) {
        let found = -1, foundPos = 1e9;
        for (let i = 0; i < array.length; i++) (array[i] - foundPos || value[i].endSide - value[found].endSide) < 0 && (found = i, 
        foundPos = array[i]);
        return found;
    }
    function countColumn(string, tabSize, to = string.length) {
        let n = 0;
        for (let i = 0; i < to && i < string.length; ) 9 == string.charCodeAt(i) ? (n += tabSize - n % tabSize, 
        i++) : (n++, i = findClusterBreak(string, i));
        return n;
    }
    function findColumn(string, col, tabSize, strict) {
        for (let i = 0, n = 0; ;) {
            if (n >= col) return i;
            if (i == string.length) break;
            n += 9 == string.charCodeAt(i) ? tabSize - n % tabSize : 1, i = findClusterBreak(string, i);
        }
        return !0 === strict ? -1 : string.length;
    }
    const COUNT = "undefined" == typeof Symbol ? "__\u037c" : Symbol.for("\u037c"), SET = "undefined" == typeof Symbol ? "__styleSet" + Math.floor(1e8 * Math.random()) : Symbol("styleSet"), top = "undefined" != typeof globalThis ? globalThis : "undefined" != typeof window ? window : {};
    class StyleModule {
        constructor(spec, options) {
            this.rules = [];
            let finish = (options || {})["finish"];
            function splitSelector(selector) {
                return /^@/.test(selector) ? [ selector ] : selector.split(/,\s*/);
            }
            for (var prop in spec) !function render(selectors, spec, target, isKeyframes) {
                var prop, local = [], isAt = /^@(\w+)\b/.exec(selectors[0]), keyframes = isAt && "keyframes" == isAt[1];
                if (isAt && null == spec) return target.push(selectors[0] + ";");
                for (prop in spec) {
                    var value = spec[prop];
                    if (/&/.test(prop)) render(prop.split(/,\s*/).map(part => selectors.map(sel => part.replace(/&/, sel))).reduce((a, b) => a.concat(b)), value, target); else if (value && "object" == typeof value) {
                        if (!isAt) throw new RangeError("The value of a property (" + prop + ") should be a primitive value.");
                        render(splitSelector(prop), value, local, keyframes);
                    } else null != value && local.push(prop.replace(/_.*/, "").replace(/[A-Z]/g, l => "-" + l.toLowerCase()) + ": " + value + ";");
                }
                (local.length || keyframes) && target.push((!finish || isAt || isKeyframes ? selectors : selectors.map(finish)).join(", ") + " {" + local.join(" ") + "}");
            }(splitSelector(prop), spec[prop], this.rules);
        }
        getRules() {
            return this.rules.join("\n");
        }
        static newName() {
            var id = top[COUNT] || 1;
            return top[COUNT] = id + 1, "\u037c" + id.toString(36);
        }
        static mount(root, modules, options) {
            let set = root[SET], nonce = options && options.nonce;
            set ? nonce && set.setNonce(nonce) : set = new StyleSet(root, nonce), 
            set.mount(Array.isArray(modules) ? modules : [ modules ], root);
        }
    }
    let adoptedSet = new Map();
    class StyleSet {
        constructor(root, nonce) {
            var doc = root.ownerDocument || root, win = doc.defaultView;
            if (!root.head && root.adoptedStyleSheets && win.CSSStyleSheet) {
                var adopted = adoptedSet.get(doc);
                if (adopted) return root[SET] = adopted;
                this.sheet = new win.CSSStyleSheet(), adoptedSet.set(doc, this);
            } else this.styleTag = doc.createElement("style"), nonce && this.styleTag.setAttribute("nonce", nonce);
            this.modules = [], root[SET] = this;
        }
        mount(modules, root) {
            var sheet = this.sheet;
            let pos = 0, j = 0;
            for (let i = 0; i < modules.length; i++) {
                let mod = modules[i], index = this.modules.indexOf(mod);
                if (index < j && -1 < index && (this.modules.splice(index, 1), j--, 
                index = -1), -1 == index) {
                    if (this.modules.splice(j++, 0, mod), sheet) for (let k = 0; k < mod.rules.length; k++) sheet.insertRule(mod.rules[k], pos++);
                } else {
                    for (;j < index; ) pos += this.modules[j++].rules.length;
                    pos += mod.rules.length, j++;
                }
            }
            if (sheet) root.adoptedStyleSheets.indexOf(this.sheet) < 0 && (root.adoptedStyleSheets = [ this.sheet, ...root.adoptedStyleSheets ]); else {
                let text = "";
                for (let i = 0; i < this.modules.length; i++) text += this.modules[i].getRules() + "\n";
                this.styleTag.textContent = text;
                root = root.head || root;
                this.styleTag.parentNode != root && root.insertBefore(this.styleTag, root.firstChild);
            }
        }
        setNonce(nonce) {
            this.styleTag && this.styleTag.getAttribute("nonce") != nonce && this.styleTag.setAttribute("nonce", nonce);
        }
    }
    for (var base = {
        8: "Backspace",
        9: "Tab",
        10: "Enter",
        12: "NumLock",
        13: "Enter",
        16: "Shift",
        17: "Control",
        18: "Alt",
        20: "CapsLock",
        27: "Escape",
        32: " ",
        33: "PageUp",
        34: "PageDown",
        35: "End",
        36: "Home",
        37: "ArrowLeft",
        38: "ArrowUp",
        39: "ArrowRight",
        40: "ArrowDown",
        44: "PrintScreen",
        45: "Insert",
        46: "Delete",
        59: ";",
        61: "=",
        91: "Meta",
        92: "Meta",
        106: "*",
        107: "+",
        108: ",",
        109: "-",
        110: ".",
        111: "/",
        144: "NumLock",
        145: "ScrollLock",
        160: "Shift",
        161: "Shift",
        162: "Control",
        163: "Control",
        164: "Alt",
        165: "Alt",
        173: "-",
        186: ";",
        187: "=",
        188: ",",
        189: "-",
        190: ".",
        191: "/",
        192: "`",
        219: "[",
        220: "\\",
        221: "]",
        222: "'"
    }, shift = {
        48: ")",
        49: "!",
        50: "@",
        51: "#",
        52: "$",
        53: "%",
        54: "^",
        55: "&",
        56: "*",
        57: "(",
        59: ":",
        61: "+",
        173: "_",
        186: ":",
        187: "+",
        188: "<",
        189: "_",
        190: ">",
        191: "?",
        192: "~",
        219: "{",
        220: "|",
        221: "}",
        222: '"'
    }, mac = "undefined" != typeof navigator && /Mac/.test(navigator.platform), ie$1 = "undefined" != typeof navigator && /MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent), i = 0; i < 10; i++) base[48 + i] = base[96 + i] = String(i);
    for (i = 1; i <= 24; i++) base[i + 111] = "F" + i;
    for (var code, i = 65; i <= 90; i++) base[i] = String.fromCharCode(i + 32), 
    shift[i] = String.fromCharCode(i);
    for (code in base) shift.hasOwnProperty(code) || (shift[code] = base[code]);
    function crelt(argument_0, argument_1) {
        var value, elt = argument_0, i = ("string" == typeof elt && (elt = document.createElement(elt)), 
        1), next = argument_1;
        if (next && "object" == typeof next && null == next.nodeType && !Array.isArray(next)) {
            for (var name in next) Object.prototype.hasOwnProperty.call(next, name) && ("string" == typeof (value = next[name]) ? elt.setAttribute(name, value) : null != value && (elt[name] = value));
            i++;
        }
        for (;i < arguments.length; i++) !function add(elt, child) {
            if ("string" == typeof child) elt.appendChild(document.createTextNode(child)); else if (null != child) if (null != child.nodeType) elt.appendChild(child); else {
                if (!Array.isArray(child)) throw new RangeError("Unsupported child node: " + child);
                for (var i = 0; i < child.length; i++) add(elt, child[i]);
            }
        }(elt, arguments[i]);
        return elt;
    }
    function getSelection(root) {
        let target;
        return (target = 11 != root.nodeType || root.getSelection ? root : root.ownerDocument).getSelection();
    }
    function contains(dom, node) {
        return !!node && (dom == node || dom.contains(1 != node.nodeType ? node.parentNode : node));
    }
    function hasSelection(dom, selection) {
        if (!selection.anchorNode) return !1;
        try {
            return contains(dom, selection.anchorNode);
        } catch (_) {
            return !1;
        }
    }
    function clientRectsFor(dom) {
        return 3 == dom.nodeType ? textRange(dom, 0, dom.nodeValue.length).getClientRects() : 1 == dom.nodeType ? dom.getClientRects() : [];
    }
    function isEquivalentPosition(node, off, targetNode, targetOff) {
        return !!targetNode && (scanFor(node, off, targetNode, targetOff, -1) || scanFor(node, off, targetNode, targetOff, 1));
    }
    function domIndex(node) {
        for (var index = 0; ;index++) if (!(node = node.previousSibling)) return index;
    }
    function isBlockElement(node) {
        return 1 == node.nodeType && /^(DIV|P|LI|UL|OL|BLOCKQUOTE|DD|DT|H\d|SECTION|PRE)$/.test(node.nodeName);
    }
    function scanFor(node, off, targetNode, targetOff, dir) {
        for (;;) {
            if (node == targetNode && off == targetOff) return !0;
            if (off == (dir < 0 ? 0 : maxOffset(node))) {
                if ("DIV" == node.nodeName) return !1;
                var parent = node.parentNode;
                if (!parent || 1 != parent.nodeType) return !1;
                off = domIndex(node) + (dir < 0 ? 0 : 1), node = parent;
            } else {
                if (1 != node.nodeType) return !1;
                if (1 == (node = node.childNodes[off + (dir < 0 ? -1 : 0)]).nodeType && "false" == node.contentEditable) return !1;
                off = dir < 0 ? maxOffset(node) : 0;
            }
        }
    }
    function maxOffset(node) {
        return (3 == node.nodeType ? node.nodeValue : node.childNodes).length;
    }
    function flattenRect(rect, left) {
        left = left ? rect.left : rect.right;
        return {
            left: left,
            right: left,
            top: rect.top,
            bottom: rect.bottom
        };
    }
    function getScale(elt, rect) {
        let scaleX = rect.width / elt.offsetWidth, scaleY = rect.height / elt.offsetHeight;
        return (.995 < scaleX && scaleX < 1.005 || !isFinite(scaleX) || Math.abs(rect.width - elt.offsetWidth) < 1) && (scaleX = 1), 
        (.995 < scaleY && scaleY < 1.005 || !isFinite(scaleY) || Math.abs(rect.height - elt.offsetHeight) < 1) && (scaleY = 1), 
        {
            scaleX: scaleX,
            scaleY: scaleY
        };
    }
    function scrollRectIntoView(dom, rect, side, x, y, xMargin, yMargin, ltr) {
        var boundingHeight, rectHeight, doc = dom.ownerDocument, win = doc.defaultView || window;
        for (let cur = dom, stop = !1; cur && !stop; ) if (1 == cur.nodeType) {
            let bounding, top = cur == doc.body, scaleX = 1, scaleY = 1;
            if (top) bounding = function(win) {
                var vp = win.visualViewport;
                return vp ? {
                    left: 0,
                    right: vp.width,
                    top: 0,
                    bottom: vp.height
                } : {
                    left: 0,
                    right: win.innerWidth,
                    top: 0,
                    bottom: win.innerHeight
                };
            }(win); else {
                if (/^(fixed|sticky)$/.test(getComputedStyle(cur).position) && (stop = !0), 
                cur.scrollHeight <= cur.clientHeight && cur.scrollWidth <= cur.clientWidth) {
                    cur = cur.assignedSlot || cur.parentNode;
                    continue;
                }
                let rect = cur.getBoundingClientRect();
                ({
                    scaleX,
                    scaleY
                } = getScale(cur, rect)), bounding = {
                    left: rect.left,
                    right: rect.left + cur.clientWidth * scaleX,
                    top: rect.top,
                    bottom: rect.top + cur.clientHeight * scaleY
                };
            }
            let moveX = 0, moveY = 0;
            if ("nearest" == y ? rect.top < bounding.top ? (moveY = rect.top - (bounding.top + yMargin), 
            0 < side && rect.bottom > bounding.bottom + moveY && (moveY = rect.bottom - bounding.bottom + yMargin)) : rect.bottom > bounding.bottom && (moveY = rect.bottom - bounding.bottom + yMargin, 
            side < 0) && rect.top - moveY < bounding.top && (moveY = rect.top - (bounding.top + yMargin)) : (rectHeight = rect.bottom - rect.top, 
            boundingHeight = bounding.bottom - bounding.top, rectHeight = "center" == y && rectHeight <= boundingHeight ? rect.top + rectHeight / 2 - boundingHeight / 2 : "start" == y || "center" == y && side < 0 ? rect.top - yMargin : rect.bottom - boundingHeight + yMargin, 
            moveY = rectHeight - bounding.top), "nearest" == x ? rect.left < bounding.left ? (moveX = rect.left - (bounding.left + xMargin), 
            0 < side && rect.right > bounding.right + moveX && (moveX = rect.right - bounding.right + xMargin)) : rect.right > bounding.right && (moveX = rect.right - bounding.right + xMargin, 
            side < 0) && rect.left < bounding.left + moveX && (moveX = rect.left - (bounding.left + xMargin)) : (boundingHeight = "center" == x ? rect.left + (rect.right - rect.left) / 2 - (bounding.right - bounding.left) / 2 : "start" == x == ltr ? rect.left - xMargin : rect.right - (bounding.right - bounding.left) + xMargin, 
            moveX = boundingHeight - bounding.left), moveX || moveY) if (top) win.scrollBy(moveX, moveY); else {
                let movedX = 0, movedY = 0;
                if (moveY && (rectHeight = cur.scrollTop, cur.scrollTop += moveY / scaleY, 
                movedY = (cur.scrollTop - rectHeight) * scaleY), moveX) {
                    let start = cur.scrollLeft;
                    cur.scrollLeft += moveX / scaleX, movedX = (cur.scrollLeft - start) * scaleX;
                }
                rect = {
                    left: rect.left - movedX,
                    top: rect.top - movedY,
                    right: rect.right - movedX,
                    bottom: rect.bottom - movedY
                }, movedX && Math.abs(movedX - moveX) < 1 && (x = "nearest"), movedY && Math.abs(movedY - moveY) < 1 && (y = "nearest");
            }
            if (top) break;
            (rect.top < bounding.top || rect.bottom > bounding.bottom || rect.left < bounding.left || rect.right > bounding.right) && (rect = {
                left: Math.max(rect.left, bounding.left),
                right: Math.min(rect.right, bounding.right),
                top: Math.max(rect.top, bounding.top),
                bottom: Math.min(rect.bottom, bounding.bottom)
            }), cur = cur.assignedSlot || cur.parentNode;
        } else {
            if (11 != cur.nodeType) break;
            cur = cur.host;
        }
    }
    class DOMSelectionState {
        constructor() {
            this.anchorNode = null, this.anchorOffset = 0, this.focusNode = null, 
            this.focusOffset = 0;
        }
        eq(domSel) {
            return this.anchorNode == domSel.anchorNode && this.anchorOffset == domSel.anchorOffset && this.focusNode == domSel.focusNode && this.focusOffset == domSel.focusOffset;
        }
        setRange(range) {
            var {
                anchorNode,
                focusNode
            } = range;
            this.set(anchorNode, Math.min(range.anchorOffset, anchorNode ? maxOffset(anchorNode) : 0), focusNode, Math.min(range.focusOffset, focusNode ? maxOffset(focusNode) : 0));
        }
        set(anchorNode, anchorOffset, focusNode, focusOffset) {
            this.anchorNode = anchorNode, this.anchorOffset = anchorOffset, this.focusNode = focusNode, 
            this.focusOffset = focusOffset;
        }
    }
    let preventScrollSupported = null;
    function focusPreventScroll(dom) {
        if (dom.setActive) return dom.setActive();
        if (preventScrollSupported) return dom.focus(preventScrollSupported);
        var stack = [];
        for (let cur = dom; cur && (stack.push(cur, cur.scrollTop, cur.scrollLeft), 
        cur != cur.ownerDocument); cur = cur.parentNode);
        if (dom.focus(null == preventScrollSupported ? {
            get preventScroll() {
                return preventScrollSupported = {
                    preventScroll: !0
                }, !0;
            }
        } : void 0), !preventScrollSupported) {
            preventScrollSupported = !1;
            for (let i = 0; i < stack.length; ) {
                var elt = stack[i++], top = stack[i++], left = stack[i++];
                elt.scrollTop != top && (elt.scrollTop = top), elt.scrollLeft != left && (elt.scrollLeft = left);
            }
        }
    }
    let scratchRange;
    function textRange(node, from, to = from) {
        var range = scratchRange = scratchRange || document.createRange();
        return range.setEnd(node, to), range.setStart(node, from), range;
    }
    function dispatchKey(elt, name, code, mods) {
        name = {
            key: name,
            code: name,
            keyCode: code,
            which: code,
            cancelable: !0
        }, mods && ({
            altKey: name.altKey,
            ctrlKey: name.ctrlKey,
            shiftKey: name.shiftKey,
            metaKey: name.metaKey
        } = mods), code = new KeyboardEvent("keydown", name), code.synthetic = !0, 
        elt.dispatchEvent(code), mods = new KeyboardEvent("keyup", name);
        return mods.synthetic = !0, elt.dispatchEvent(mods), code.defaultPrevented || mods.defaultPrevented;
    }
    function clearAttributes(node) {
        for (;node.attributes.length; ) node.removeAttributeNode(node.attributes[0]);
    }
    function isScrolledToBottom(elt) {
        return elt.scrollTop > Math.max(1, elt.scrollHeight - elt.clientHeight - 4);
    }
    function textNodeBefore(startNode, startOffset) {
        for (let node = startNode, offset = startOffset; ;) {
            if (3 == node.nodeType && 0 < offset) return {
                node: node,
                offset: offset
            };
            if (1 == node.nodeType && 0 < offset) {
                if ("false" == node.contentEditable) return null;
                node = node.childNodes[offset - 1], offset = maxOffset(node);
            } else {
                if (!node.parentNode || isBlockElement(node)) return null;
                offset = domIndex(node), node = node.parentNode;
            }
        }
    }
    function textNodeAfter(startNode, startOffset) {
        for (let node = startNode, offset = startOffset; ;) {
            if (3 == node.nodeType && offset < node.nodeValue.length) return {
                node: node,
                offset: offset
            };
            if (1 == node.nodeType && offset < node.childNodes.length) {
                if ("false" == node.contentEditable) return null;
                node = node.childNodes[offset], offset = 0;
            } else {
                if (!node.parentNode || isBlockElement(node)) return null;
                offset = domIndex(node) + 1, node = node.parentNode;
            }
        }
    }
    class DOMPos {
        constructor(node, offset, precise = !0) {
            this.node = node, this.offset = offset, this.precise = precise;
        }
        static before(dom, precise) {
            return new DOMPos(dom.parentNode, domIndex(dom), precise);
        }
        static after(dom, precise) {
            return new DOMPos(dom.parentNode, domIndex(dom) + 1, precise);
        }
    }
    const noChildren = [];
    class ContentView {
        constructor() {
            this.parent = null, this.dom = null, this.flags = 2;
        }
        get overrideDOMText() {
            return null;
        }
        get posAtStart() {
            return this.parent ? this.parent.posBefore(this) : 0;
        }
        get posAtEnd() {
            return this.posAtStart + this.length;
        }
        posBefore(view) {
            let pos = this.posAtStart;
            for (var child of this.children) {
                if (child == view) return pos;
                pos += child.length + child.breakAfter;
            }
            throw new RangeError("Invalid child in posBefore");
        }
        posAfter(view) {
            return this.posBefore(view) + view.length;
        }
        sync(view, track) {
            if (2 & this.flags) {
                var child, contentView, parent = this.dom;
                let prev = null, next;
                for (child of this.children) {
                    if (7 & child.flags && (child.dom || !(next = prev ? prev.nextSibling : parent.firstChild) || (contentView = ContentView.get(next)) && (contentView.parent || !contentView.canReuseDOM(child)) || child.reuseDOM(next), 
                    child.sync(view, track), child.flags &= -8), next = prev ? prev.nextSibling : parent.firstChild, 
                    track && !track.written && track.node == parent && next != child.dom && (track.written = !0), 
                    child.dom.parentNode == parent) for (;next && next != child.dom; ) next = rm$1(next); else parent.insertBefore(child.dom, next);
                    prev = child.dom;
                }
                for ((next = prev ? prev.nextSibling : parent.firstChild) && track && track.node == parent && (track.written = !0); next; ) next = rm$1(next);
            } else if (1 & this.flags) for (let child of this.children) 7 & child.flags && (child.sync(view, track), 
            child.flags &= -8);
        }
        reuseDOM(_dom) {}
        localPosFromDOM(node, offset) {
            let after;
            if (node == this.dom) after = this.dom.childNodes[offset]; else {
                let bias = 0 == maxOffset(node) ? 0 : 0 == offset ? -1 : 1;
                for (;;) {
                    var parent = node.parentNode;
                    if (parent == this.dom) break;
                    0 == bias && parent.firstChild != parent.lastChild && (bias = node == parent.firstChild ? -1 : 1), 
                    node = parent;
                }
                after = bias < 0 ? node : node.nextSibling;
            }
            if (after == this.dom.firstChild) return 0;
            for (;after && !ContentView.get(after); ) after = after.nextSibling;
            if (!after) return this.length;
            for (let i = 0, pos = 0; ;i++) {
                var child = this.children[i];
                if (child.dom == after) return pos;
                pos += child.length + child.breakAfter;
            }
        }
        domBoundsAround(from, to, offset = 0) {
            let fromI = -1, fromStart = -1, toI = -1, toEnd = -1;
            for (let i = 0, pos = offset, prevEnd = offset; i < this.children.length; i++) {
                var child = this.children[i], end = pos + child.length;
                if (pos < from && to < end) return child.domBoundsAround(from, to, pos);
                if (from <= end && -1 == fromI && (fromI = i, fromStart = pos), 
                pos > to && child.dom.parentNode == this.dom) {
                    toI = i, toEnd = prevEnd;
                    break;
                }
                prevEnd = end, pos = end + child.breakAfter;
            }
            return {
                from: fromStart,
                to: toEnd < 0 ? offset + this.length : toEnd,
                startDOM: (fromI ? this.children[fromI - 1].dom.nextSibling : null) || this.dom.firstChild,
                endDOM: toI < this.children.length && 0 <= toI ? this.children[toI].dom : null
            };
        }
        markDirty(andParent = !1) {
            this.flags |= 2, this.markParentsDirty(andParent);
        }
        markParentsDirty(childList) {
            for (let parent = this.parent; parent; parent = parent.parent) {
                if (childList && (parent.flags |= 2), 1 & parent.flags) return;
                parent.flags |= 1, childList = !1;
            }
        }
        setParent(parent) {
            this.parent != parent && (this.parent = parent, 7 & this.flags) && this.markParentsDirty(!0);
        }
        setDOM(dom) {
            this.dom != dom && (this.dom && (this.dom.cmView = null), (this.dom = dom).cmView = this);
        }
        get rootView() {
            for (let v = this; ;) {
                var parent = v.parent;
                if (!parent) return v;
                v = parent;
            }
        }
        replaceChildren(from, to, children = noChildren) {
            this.markDirty();
            for (let i = from; i < to; i++) {
                var child = this.children[i];
                child.parent == this && children.indexOf(child) < 0 && child.destroy();
            }
            children.length < 250 ? this.children.splice(from, to - from, ...children) : this.children = [].concat(this.children.slice(0, from), children, this.children.slice(to));
            for (let i = 0; i < children.length; i++) children[i].setParent(this);
        }
        ignoreMutation(_rec) {
            return !1;
        }
        ignoreEvent(_event) {
            return !1;
        }
        childCursor(pos = this.length) {
            return new ChildCursor(this.children, pos, this.children.length);
        }
        childPos(pos, bias = 1) {
            return this.childCursor().findPos(pos, bias);
        }
        toString() {
            var name = this.constructor.name.replace("View", "");
            return name + (this.children.length ? "(" + this.children.join() + ")" : this.length ? "[" + ("Text" == name ? this.text : this.length) + "]" : "") + (this.breakAfter ? "#" : "");
        }
        static get(node) {
            return node.cmView;
        }
        get isEditable() {
            return !0;
        }
        get isWidget() {
            return !1;
        }
        get isHidden() {
            return !1;
        }
        merge(from, to, source, hasStart, openStart, openEnd) {
            return !1;
        }
        become(other) {
            return !1;
        }
        canReuseDOM(other) {
            return other.constructor == this.constructor && !(8 & (this.flags | other.flags));
        }
        getSide() {
            return 0;
        }
        destroy() {
            for (var child of this.children) child.parent == this && child.destroy();
            this.parent = null;
        }
    }
    function rm$1(dom) {
        var next = dom.nextSibling;
        return dom.parentNode.removeChild(dom), next;
    }
    ContentView.prototype.breakAfter = 0;
    class ChildCursor {
        constructor(children, pos, i) {
            this.children = children, this.pos = pos, this.i = i, this.off = 0;
        }
        findPos(pos, bias = 1) {
            for (;;) {
                if (pos > this.pos || pos == this.pos && (0 < bias || 0 == this.i || this.children[this.i - 1].breakAfter)) return this.off = pos - this.pos, 
                this;
                var next = this.children[--this.i];
                this.pos -= next.length + next.breakAfter;
            }
        }
    }
    function replaceRange(parent, fromI, fromOff, toI, toOff, insert, breakAtStart, openStart, openEnd) {
        var children = parent["children"], before = children.length ? children[fromI] : null, last = insert.length ? insert[insert.length - 1] : null, breakAtEnd = last ? last.breakAfter : breakAtStart;
        if (!(fromI == toI && before && !breakAtStart && !breakAtEnd && insert.length < 2 && before.merge(fromOff, toOff, insert.length ? last : null, 0 == fromOff, openStart, openEnd))) {
            if (toI < children.length) {
                let after = children[toI];
                after && (toOff < after.length || after.breakAfter && null != last && last.breakAfter) ? (fromI == toI && (after = after.split(toOff), 
                toOff = 0), !breakAtEnd && last && after.merge(0, toOff, last, !0, 0, openEnd) ? insert[insert.length - 1] = after : ((toOff || after.children.length && !after.children[0].length) && after.merge(0, toOff, null, !1, 0, openEnd), 
                insert.push(after))) : null !== after && void 0 !== after && after.breakAfter && (last ? last.breakAfter = 1 : breakAtStart = 1), 
                toI++;
            }
            for (before && (before.breakAfter = breakAtStart, 0 < fromOff) && (!breakAtStart && insert.length && before.merge(fromOff, before.length, insert[0], !1, openStart, 0) ? before.breakAfter = insert.shift().breakAfter : (fromOff < before.length || before.children.length && 0 == before.children[before.children.length - 1].length) && before.merge(fromOff, before.length, null, !1, openStart, 0), 
            fromI++); fromI < toI && insert.length; ) if (children[toI - 1].become(insert[insert.length - 1])) toI--, 
            insert.pop(), openEnd = insert.length ? 0 : openStart; else {
                if (!children[fromI].become(insert[0])) break;
                fromI++, insert.shift(), openStart = insert.length ? 0 : openEnd;
            }
            !insert.length && fromI && toI < children.length && !children[fromI - 1].breakAfter && children[toI].merge(0, 0, children[fromI - 1], !1, openStart, openEnd) && fromI--, 
            (fromI < toI || insert.length) && parent.replaceChildren(fromI, toI, insert);
        }
    }
    function mergeChildrenInto(parent, from, to, insert, openStart, openEnd) {
        var view, cur = parent.childCursor(), {
            i: toI,
            off: toOff
        } = cur.findPos(to, 1), {
            i: cur,
            off: fromOff
        } = cur.findPos(from, -1);
        let dLen = from - to;
        for (view of insert) dLen += view.length;
        parent.length += dLen, replaceRange(parent, cur, fromOff, toI, toOff, insert, 0, openStart, openEnd);
    }
    var nav = "undefined" != typeof navigator ? navigator : {
        userAgent: "",
        vendor: "",
        platform: ""
    }, doc = "undefined" != typeof document ? document : {
        documentElement: {
            style: {}
        }
    }, ie_edge = /Edge\/(\d+)/.exec(nav.userAgent), ie_upto10 = /MSIE \d/.test(nav.userAgent), ie_11up = /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(nav.userAgent), ie = !!(ie_upto10 || ie_11up || ie_edge), gecko = !ie && /gecko\/(\d+)/i.test(nav.userAgent), chrome = !ie && /Chrome\/(\d+)/.exec(nav.userAgent), webkit = "webkitFontSmoothing" in doc.documentElement.style, safari = !ie && /Apple Computer/.test(nav.vendor), ios = safari && (/Mobile\/\w+/.test(nav.userAgent) || 2 < nav.maxTouchPoints), browser = {
        mac: ios || /Mac/.test(nav.platform),
        windows: /Win/.test(nav.platform),
        linux: /Linux|X11/.test(nav.platform),
        ie: ie,
        ie_version: ie_upto10 ? doc.documentMode || 6 : ie_11up ? +ie_11up[1] : ie_edge ? +ie_edge[1] : 0,
        gecko: gecko,
        gecko_version: gecko ? +(/Firefox\/(\d+)/.exec(nav.userAgent) || [ 0, 0 ])[1] : 0,
        chrome: !!chrome,
        chrome_version: chrome ? +chrome[1] : 0,
        ios: ios,
        android: /Android\b/.test(nav.userAgent),
        webkit: webkit,
        safari: safari,
        webkit_version: webkit ? +(/\bAppleWebKit\/(\d+)/.exec(nav.userAgent) || [ 0, 0 ])[1] : 0,
        tabSize: null != doc.documentElement.style.tabSize ? "tab-size" : "-moz-tab-size"
    };
    class TextView extends ContentView {
        constructor(text) {
            super(), this.text = text;
        }
        get length() {
            return this.text.length;
        }
        createDOM(textDOM) {
            this.setDOM(textDOM || document.createTextNode(this.text));
        }
        sync(view, track) {
            this.dom || this.createDOM(), this.dom.nodeValue != this.text && (track && track.node == this.dom && (track.written = !0), 
            this.dom.nodeValue = this.text);
        }
        reuseDOM(dom) {
            3 == dom.nodeType && this.createDOM(dom);
        }
        merge(from, to, source) {
            return !(8 & this.flags || source && (!(source instanceof TextView) || 256 < this.length - (to - from) + source.length || 8 & source.flags) || (this.text = this.text.slice(0, from) + (source ? source.text : "") + this.text.slice(to), 
            this.markDirty(), 0));
        }
        split(from) {
            var result = new TextView(this.text.slice(from));
            return this.text = this.text.slice(0, from), this.markDirty(), result.flags |= 8 & this.flags, 
            result;
        }
        localPosFromDOM(node, offset) {
            return node == this.dom ? offset : offset ? this.text.length : 0;
        }
        domAtPos(pos) {
            return new DOMPos(this.dom, pos);
        }
        domBoundsAround(_from, _to, offset) {
            return {
                from: offset,
                to: offset + this.length,
                startDOM: this.dom,
                endDOM: this.dom.nextSibling
            };
        }
        coordsAt(pos, side) {
            return function(text, pos, side) {
                var length = text.nodeValue.length;
                length < pos && (pos = length);
                let from = pos, to = pos, flatten = 0;
                0 == pos && side < 0 || pos == length && 0 <= side ? browser.chrome || browser.gecko || (pos ? (from--, 
                flatten = 1) : to < length && (to++, flatten = -1)) : side < 0 ? from-- : to < length && to++;
                pos = textRange(text, from, to).getClientRects();
                if (!pos.length) return null;
                let rect = pos[(flatten ? flatten < 0 : 0 <= side) ? 0 : pos.length - 1];
                browser.safari && !flatten && 0 == rect.width && (rect = Array.prototype.find.call(pos, r => r.width) || rect);
                return flatten ? flattenRect(rect, flatten < 0) : rect || null;
            }(this.dom, pos, side);
        }
    }
    class MarkView extends ContentView {
        constructor(mark, children = [], length = 0) {
            super(), this.mark = mark, this.children = children, this.length = length;
            for (var ch of children) ch.setParent(this);
        }
        setAttrs(dom) {
            if (clearAttributes(dom), this.mark.class && (dom.className = this.mark.class), 
            this.mark.attrs) for (var name in this.mark.attrs) dom.setAttribute(name, this.mark.attrs[name]);
            return dom;
        }
        canReuseDOM(other) {
            return super.canReuseDOM(other) && !(8 & (this.flags | other.flags));
        }
        reuseDOM(node) {
            node.nodeName == this.mark.tagName.toUpperCase() && (this.setDOM(node), 
            this.flags |= 6);
        }
        sync(view, track) {
            this.dom ? 4 & this.flags && this.setAttrs(this.dom) : this.setDOM(this.setAttrs(document.createElement(this.mark.tagName))), 
            super.sync(view, track);
        }
        merge(from, to, source, _hasStart, openStart, openEnd) {
            return !(source && (!(source instanceof MarkView && source.mark.eq(this.mark)) || from && openStart <= 0 || to < this.length && openEnd <= 0) || (mergeChildrenInto(this, from, to, source ? source.children.slice() : [], openStart - 1, openEnd - 1), 
            this.markDirty(), 0));
        }
        split(from) {
            let result = [], off = 0, detachFrom = -1, i = 0;
            for (var elt of this.children) {
                var end = off + elt.length;
                from < end && result.push(off < from ? elt.split(from - off) : elt), 
                detachFrom < 0 && off >= from && (detachFrom = i), off = end, i++;
            }
            var length = this.length - from;
            return this.length = from, -1 < detachFrom && (this.children.length = detachFrom, 
            this.markDirty()), new MarkView(this.mark, result, length);
        }
        domAtPos(pos) {
            return inlineDOMAtPos(this, pos);
        }
        coordsAt(pos, side) {
            return coordsInChildren(this, pos, side);
        }
    }
    class WidgetView extends ContentView {
        static create(widget, length, side) {
            return new WidgetView(widget, length, side);
        }
        constructor(widget, length, side) {
            super(), this.widget = widget, this.length = length, this.side = side, 
            this.prevWidget = null;
        }
        split(from) {
            var result = WidgetView.create(this.widget, this.length - from, this.side);
            return this.length -= from, result;
        }
        sync(view) {
            this.dom && this.widget.updateDOM(this.dom, view) || (this.dom && this.prevWidget && this.prevWidget.destroy(this.dom), 
            this.prevWidget = null, this.setDOM(this.widget.toDOM(view)), this.widget.editable) || (this.dom.contentEditable = "false");
        }
        getSide() {
            return this.side;
        }
        merge(from, to, source, hasStart, openStart, openEnd) {
            return !(source && (!(source instanceof WidgetView && this.widget.compare(source.widget)) || 0 < from && openStart <= 0 || to < this.length && openEnd <= 0) || (this.length = from + (source ? source.length : 0) + (this.length - to), 
            0));
        }
        become(other) {
            return other instanceof WidgetView && other.side == this.side && this.widget.constructor == other.widget.constructor && (this.widget.compare(other.widget) || this.markDirty(!0), 
            this.dom && !this.prevWidget && (this.prevWidget = this.widget), this.widget = other.widget, 
            this.length = other.length, !0);
        }
        ignoreMutation() {
            return !0;
        }
        ignoreEvent(event) {
            return this.widget.ignoreEvent(event);
        }
        get overrideDOMText() {
            if (0 == this.length) return Text.empty;
            let top = this;
            for (;top.parent; ) top = top.parent;
            var view = top["view"], view = view && view.state.doc, start = this.posAtStart;
            return view ? view.slice(start, start + this.length) : Text.empty;
        }
        domAtPos(pos) {
            return (this.length ? 0 == pos : 0 < this.side) ? DOMPos.before(this.dom) : DOMPos.after(this.dom, pos == this.length);
        }
        domBoundsAround() {
            return null;
        }
        coordsAt(pos, side) {
            side = this.widget.coordsAt(this.dom, pos, side);
            if (side) return side;
            let rects = this.dom.getClientRects(), rect = null;
            if (!rects.length) return null;
            var fromBack = this.side ? this.side < 0 : 0 < pos;
            for (let i = fromBack ? rects.length - 1 : 0; rect = rects[i], !(0 < pos ? 0 == i : i == rects.length - 1 || rect.top < rect.bottom); i += fromBack ? -1 : 1);
            return flattenRect(rect, !fromBack);
        }
        get isEditable() {
            return !1;
        }
        get isWidget() {
            return !0;
        }
        get isHidden() {
            return this.widget.isHidden;
        }
        destroy() {
            super.destroy(), this.dom && this.widget.destroy(this.dom);
        }
    }
    class WidgetBufferView extends ContentView {
        constructor(side) {
            super(), this.side = side;
        }
        get length() {
            return 0;
        }
        merge() {
            return !1;
        }
        become(other) {
            return other instanceof WidgetBufferView && other.side == this.side;
        }
        split() {
            return new WidgetBufferView(this.side);
        }
        sync() {
            var dom;
            this.dom || ((dom = document.createElement("img")).className = "cm-widgetBuffer", 
            dom.setAttribute("aria-hidden", "true"), this.setDOM(dom));
        }
        getSide() {
            return this.side;
        }
        domAtPos(pos) {
            return 0 < this.side ? DOMPos.before(this.dom) : DOMPos.after(this.dom);
        }
        localPosFromDOM() {
            return 0;
        }
        domBoundsAround() {
            return null;
        }
        coordsAt(pos) {
            return this.dom.getBoundingClientRect();
        }
        get overrideDOMText() {
            return Text.empty;
        }
        get isHidden() {
            return !0;
        }
    }
    function inlineDOMAtPos(parent, pos) {
        let dom = parent.dom, children = parent["children"], i = 0;
        for (let off = 0; i < children.length; i++) {
            var child = children[i], end = off + child.length;
            if (!(end == off && child.getSide() <= 0)) {
                if (pos > off && pos < end && child.dom.parentNode == dom) return child.domAtPos(pos - off);
                if (pos <= off) break;
                off = end;
            }
        }
        for (let j = i; 0 < j; j--) {
            var prev = children[j - 1];
            if (prev.dom.parentNode == dom) return prev.domAtPos(prev.length);
        }
        for (let j = i; j < children.length; j++) {
            var next = children[j];
            if (next.dom.parentNode == dom) return next.domAtPos(0);
        }
        return new DOMPos(dom, 0);
    }
    function coordsInChildren(view, pos, side) {
        let before = null, beforePos = -1, after = null, afterPos = -1;
        !function scan(view, pos) {
            for (let i = 0, off = 0; i < view.children.length && off <= pos; i++) {
                var child = view.children[i], end = off + child.length;
                pos <= end && (child.children.length ? scan(child, pos - off) : (!after || after.isHidden && (0 < side || function(a, b) {
                    return a = a.coordsAt(0, 1), b = b.coordsAt(0, 1), a && b && b.top < a.bottom;
                }(after, child))) && (pos < end || off == end && 0 < child.getSide()) ? (after = child, 
                afterPos = pos - off) : (off < pos || off == end && child.getSide() < 0 && !child.isHidden) && (before = child, 
                beforePos = pos - off)), off = end;
            }
        }(view, pos);
        pos = (side < 0 ? before : after) || before || after;
        return pos ? pos.coordsAt(Math.max(0, pos == before ? beforePos : afterPos), side) : function(view) {
            var last = view.dom.lastChild;
            if (!last) return view.dom.getBoundingClientRect();
            view = clientRectsFor(last);
            return view[view.length - 1] || null;
        }(view);
    }
    function combineAttrs(source, target) {
        for (var name in source) "class" == name && target.class ? target.class += " " + source.class : "style" == name && target.style ? target.style += ";" + source.style : target[name] = source[name];
        return target;
    }
    TextView.prototype.children = WidgetView.prototype.children = WidgetBufferView.prototype.children = noChildren;
    const noAttrs$1 = Object.create(null);
    function attrsEq(a, b, ignore) {
        if (a != b) {
            a = a || noAttrs$1, b = b || noAttrs$1;
            var key, keysA = Object.keys(a), keysB = Object.keys(b);
            if (keysA.length - (ignore && -1 < keysA.indexOf(ignore) ? 1 : 0) != keysB.length - (ignore && -1 < keysB.indexOf(ignore) ? 1 : 0)) return !1;
            for (key of keysA) if (key != ignore && (-1 == keysB.indexOf(key) || a[key] !== b[key])) return !1;
        }
        return !0;
    }
    function updateAttrs(dom, prev, attrs) {
        let changed = !1;
        if (prev) for (var name in prev) attrs && name in attrs || (changed = !0, 
        "style" == name ? dom.style.cssText = "" : dom.removeAttribute(name));
        if (attrs) for (let name in attrs) prev && prev[name] == attrs[name] || (changed = !0, 
        "style" == name ? dom.style.cssText = attrs[name] : dom.setAttribute(name, attrs[name]));
        return changed;
    }
    class WidgetType {
        eq(widget) {
            return !1;
        }
        updateDOM(dom, view) {
            return !1;
        }
        compare(other) {
            return this == other || this.constructor == other.constructor && this.eq(other);
        }
        get estimatedHeight() {
            return -1;
        }
        get lineBreaks() {
            return 0;
        }
        ignoreEvent(event) {
            return !0;
        }
        coordsAt(dom, pos, side) {
            return null;
        }
        get isHidden() {
            return !1;
        }
        get editable() {
            return !1;
        }
        destroy(dom) {}
    }
    var BlockType = function(BlockType) {
        return BlockType[BlockType.Text = 0] = "Text", BlockType[BlockType.WidgetBefore = 1] = "WidgetBefore", 
        BlockType[BlockType.WidgetAfter = 2] = "WidgetAfter", BlockType[BlockType.WidgetRange = 3] = "WidgetRange", 
        BlockType;
    }(BlockType = BlockType || {});
    class Decoration extends RangeValue {
        constructor(startSide, endSide, widget, spec) {
            super(), this.startSide = startSide, this.endSide = endSide, this.widget = widget, 
            this.spec = spec;
        }
        get heightRelevant() {
            return !1;
        }
        static mark(spec) {
            return new MarkDecoration(spec);
        }
        static widget(spec) {
            var side = Math.max(-1e4, Math.min(1e4, spec.side || 0)), block = !!spec.block;
            return side += block && !spec.inlineOrder ? 0 < side ? 3e8 : -4e8 : 0 < side ? 1e8 : -1e8, 
            new PointDecoration(spec, side, side, block, spec.widget || null, !1);
        }
        static replace(spec) {
            let block = !!spec.block, startSide, endSide;
            var start, end;
            return endSide = spec.isBlockGap ? (startSide = -5e8, 4e8) : ({
                start,
                end
            } = getInclusive(spec, block), startSide = (start ? block ? -3e8 : -1 : 5e8) - 1, 
            1 + (end ? block ? 2e8 : 1 : -6e8)), new PointDecoration(spec, startSide, endSide, block, spec.widget || null, !0);
        }
        static line(spec) {
            return new LineDecoration(spec);
        }
        static set(of, sort = !1) {
            return RangeSet.of(of, sort);
        }
        hasHeight() {
            return !!this.widget && -1 < this.widget.estimatedHeight;
        }
    }
    Decoration.none = RangeSet.empty;
    class MarkDecoration extends Decoration {
        constructor(spec) {
            var {
                start,
                end
            } = getInclusive(spec);
            super(start ? -1 : 5e8, end ? 1 : -6e8, null, spec), this.tagName = spec.tagName || "span", 
            this.class = spec.class || "", this.attrs = spec.attributes || null;
        }
        eq(other) {
            var _a;
            return this == other || other instanceof MarkDecoration && this.tagName == other.tagName && (this.class || (null == (_a = this.attrs) ? void 0 : _a.class)) == (other.class || (null == (_a = other.attrs) ? void 0 : _a.class)) && attrsEq(this.attrs, other.attrs, "class");
        }
        range(from, to = from) {
            if (to <= from) throw new RangeError("Mark decorations may not be empty");
            return super.range(from, to);
        }
    }
    MarkDecoration.prototype.point = !1;
    class LineDecoration extends Decoration {
        constructor(spec) {
            super(-2e8, -2e8, null, spec);
        }
        eq(other) {
            return other instanceof LineDecoration && this.spec.class == other.spec.class && attrsEq(this.spec.attributes, other.spec.attributes);
        }
        range(from, to = from) {
            if (to != from) throw new RangeError("Line decoration ranges must be zero-length");
            return super.range(from, to);
        }
    }
    LineDecoration.prototype.mapMode = MapMode.TrackBefore, LineDecoration.prototype.point = !0;
    class PointDecoration extends Decoration {
        constructor(spec, startSide, endSide, block, widget, isReplace) {
            super(startSide, endSide, widget, spec), this.block = block, this.isReplace = isReplace, 
            this.mapMode = block ? startSide <= 0 ? MapMode.TrackBefore : MapMode.TrackAfter : MapMode.TrackDel;
        }
        get type() {
            return this.startSide != this.endSide ? BlockType.WidgetRange : this.startSide <= 0 ? BlockType.WidgetBefore : BlockType.WidgetAfter;
        }
        get heightRelevant() {
            return this.block || !!this.widget && (5 <= this.widget.estimatedHeight || 0 < this.widget.lineBreaks);
        }
        eq(other) {
            return other instanceof PointDecoration && (a = this.widget, b = other.widget, 
            a == b || !!(a && b && a.compare(b))) && this.block == other.block && this.startSide == other.startSide && this.endSide == other.endSide;
            var a, b;
        }
        range(from, to = from) {
            if (this.isReplace && (to < from || from == to && 0 < this.startSide && this.endSide <= 0)) throw new RangeError("Invalid range for replacement decoration");
            if (this.isReplace || to == from) return super.range(from, to);
            throw new RangeError("Widget decorations can only have zero-length ranges");
        }
    }
    function getInclusive(spec, block = !1) {
        let {
            inclusiveStart: start,
            inclusiveEnd: end
        } = spec;
        return null == start && (start = spec.inclusive), null == end && (end = spec.inclusive), 
        {
            start: null !== start && void 0 !== start ? start : block,
            end: null !== end && void 0 !== end ? end : block
        };
    }
    function addRange(from, to, ranges, margin = 0) {
        var last = ranges.length - 1;
        0 <= last && ranges[last] + margin >= from ? ranges[last] = Math.max(ranges[last], to) : ranges.push(from, to);
    }
    PointDecoration.prototype.point = !0;
    class LineView extends ContentView {
        constructor() {
            super(...arguments), this.children = [], this.length = 0, this.prevAttrs = void 0, 
            this.attrs = null, this.breakAfter = 0;
        }
        merge(from, to, source, hasStart, openStart, openEnd) {
            if (source) {
                if (!(source instanceof LineView)) return !1;
                this.dom || source.transferDOM(this);
            }
            return hasStart && this.setDeco(source ? source.attrs : null), mergeChildrenInto(this, from, to, source ? source.children.slice() : [], openStart, openEnd), 
            !0;
        }
        split(at) {
            var end = new LineView();
            if (end.breakAfter = this.breakAfter, 0 != this.length) {
                let {
                    i,
                    off
                } = this.childPos(at);
                off && (end.append(this.children[i].split(off), 0), this.children[i].merge(off, this.children[i].length, null, !1, 0, 0), 
                i++);
                for (let j = i; j < this.children.length; j++) end.append(this.children[j], 0);
                for (;0 < i && 0 == this.children[i - 1].length; ) this.children[--i].destroy();
                this.children.length = i, this.markDirty(), this.length = at;
            }
            return end;
        }
        transferDOM(other) {
            this.dom && (this.markDirty(), other.setDOM(this.dom), other.prevAttrs = void 0 === this.prevAttrs ? this.attrs : this.prevAttrs, 
            this.prevAttrs = void 0, this.dom = null);
        }
        setDeco(attrs) {
            attrsEq(this.attrs, attrs) || (this.dom && (this.prevAttrs = this.attrs, 
            this.markDirty()), this.attrs = attrs);
        }
        append(child, openStart) {
            !function joinInlineInto(parent, view, open) {
                let last, children = parent.children;
                0 < open && view instanceof MarkView && children.length && (last = children[children.length - 1]) instanceof MarkView && last.mark.eq(view.mark) ? joinInlineInto(last, view.children[0], open - 1) : (children.push(view), 
                view.setParent(parent)), parent.length += view.length;
            }(this, child, openStart);
        }
        addLineDeco(deco) {
            var attrs = deco.spec.attributes, deco = deco.spec.class;
            attrs && (this.attrs = combineAttrs(attrs, this.attrs || {})), deco && (this.attrs = combineAttrs({
                class: deco
            }, this.attrs || {}));
        }
        domAtPos(pos) {
            return inlineDOMAtPos(this, pos);
        }
        reuseDOM(node) {
            "DIV" == node.nodeName && (this.setDOM(node), this.flags |= 6);
        }
        sync(view, track) {
            this.dom ? 4 & this.flags && (clearAttributes(this.dom), this.dom.className = "cm-line", 
            this.prevAttrs = this.attrs ? null : void 0) : (this.setDOM(document.createElement("div")), 
            this.dom.className = "cm-line", this.prevAttrs = this.attrs ? null : void 0), 
            void 0 !== this.prevAttrs && (updateAttrs(this.dom, this.prevAttrs, this.attrs), 
            this.dom.classList.add("cm-line"), this.prevAttrs = void 0), super.sync(view, track);
            let last = this.dom.lastChild;
            for (;last && ContentView.get(last) instanceof MarkView; ) last = last.lastChild;
            last && this.length && ("BR" == last.nodeName || 0 != (null == (view = ContentView.get(last)) ? void 0 : view.isEditable) || browser.ios && this.children.some(ch => ch instanceof TextView)) || ((track = document.createElement("BR")).cmIgnore = !0, 
            this.dom.appendChild(track));
        }
        measureTextSize() {
            if (0 == this.children.length || 20 < this.length) return null;
            let totalWidth = 0, textHeight;
            for (var child of this.children) {
                if (!(child instanceof TextView) || /[^ -~]/.test(child.text)) return null;
                child = clientRectsFor(child.dom);
                if (1 != child.length) return null;
                totalWidth += child[0].width, textHeight = child[0].height;
            }
            return totalWidth ? {
                lineHeight: this.dom.getBoundingClientRect().height,
                charWidth: totalWidth / this.length,
                textHeight: textHeight
            } : null;
        }
        coordsAt(pos, side) {
            pos = coordsInChildren(this, pos, side);
            if (!this.children.length && pos && this.parent) {
                var side = this.parent.view.viewState["heightOracle"], height = pos.bottom - pos.top;
                if (Math.abs(height - side.lineHeight) < 2 && side.textHeight < height) return height = (height - side.textHeight) / 2, 
                {
                    top: pos.top + height,
                    bottom: pos.bottom - height,
                    left: pos.left,
                    right: pos.left
                };
            }
            return pos;
        }
        become(other) {
            return other instanceof LineView && 0 == this.children.length && 0 == other.children.length && attrsEq(this.attrs, other.attrs) && this.breakAfter == other.breakAfter;
        }
        covers() {
            return !0;
        }
        static find(docView, pos) {
            for (let i = 0, off = 0; i < docView.children.length; i++) {
                var block = docView.children[i], end = off + block.length;
                if (pos <= end) {
                    if (block instanceof LineView) return block;
                    if (pos < end) break;
                }
                off = end + block.breakAfter;
            }
            return null;
        }
    }
    class BlockWidgetView extends ContentView {
        constructor(widget, length, deco) {
            super(), this.widget = widget, this.length = length, this.deco = deco, 
            this.breakAfter = 0, this.prevWidget = null;
        }
        merge(from, to, source, _takeDeco, openStart, openEnd) {
            return !(source && (!(source instanceof BlockWidgetView && this.widget.compare(source.widget)) || 0 < from && openStart <= 0 || to < this.length && openEnd <= 0) || (this.length = from + (source ? source.length : 0) + (this.length - to), 
            0));
        }
        domAtPos(pos) {
            return 0 == pos ? DOMPos.before(this.dom) : DOMPos.after(this.dom, pos == this.length);
        }
        split(at) {
            var len = this.length - at, at = (this.length = at, new BlockWidgetView(this.widget, len, this.deco));
            return at.breakAfter = this.breakAfter, at;
        }
        get children() {
            return noChildren;
        }
        sync(view) {
            this.dom && this.widget.updateDOM(this.dom, view) || (this.dom && this.prevWidget && this.prevWidget.destroy(this.dom), 
            this.prevWidget = null, this.setDOM(this.widget.toDOM(view)), this.widget.editable) || (this.dom.contentEditable = "false");
        }
        get overrideDOMText() {
            return this.parent ? this.parent.view.state.doc.slice(this.posAtStart, this.posAtEnd) : Text.empty;
        }
        domBoundsAround() {
            return null;
        }
        become(other) {
            return other instanceof BlockWidgetView && other.widget.constructor == this.widget.constructor && (other.widget.compare(this.widget) || this.markDirty(!0), 
            this.dom && !this.prevWidget && (this.prevWidget = this.widget), this.widget = other.widget, 
            this.length = other.length, this.deco = other.deco, this.breakAfter = other.breakAfter, 
            !0);
        }
        ignoreMutation() {
            return !0;
        }
        ignoreEvent(event) {
            return this.widget.ignoreEvent(event);
        }
        get isEditable() {
            return !1;
        }
        get isWidget() {
            return !0;
        }
        coordsAt(pos, side) {
            var custom = this.widget.coordsAt(this.dom, pos, side);
            return custom || (this.widget instanceof BlockGapWidget ? null : flattenRect(this.dom.getBoundingClientRect(), this.length ? 0 == pos : side <= 0));
        }
        destroy() {
            super.destroy(), this.dom && this.widget.destroy(this.dom);
        }
        covers(side) {
            var {
                startSide,
                endSide
            } = this.deco;
            return startSide != endSide && (side < 0 ? startSide < 0 : 0 < endSide);
        }
    }
    class BlockGapWidget extends WidgetType {
        constructor(height) {
            super(), this.height = height;
        }
        toDOM() {
            var elt = document.createElement("div");
            return elt.className = "cm-gap", this.updateDOM(elt), elt;
        }
        eq(other) {
            return other.height == this.height;
        }
        updateDOM(elt) {
            return elt.style.height = this.height + "px", !0;
        }
        get editable() {
            return !0;
        }
        get estimatedHeight() {
            return this.height;
        }
        ignoreEvent() {
            return !1;
        }
    }
    class ContentBuilder {
        constructor(doc, pos, end, disallowBlockEffectsFor) {
            this.doc = doc, this.pos = pos, this.end = end, this.disallowBlockEffectsFor = disallowBlockEffectsFor, 
            this.content = [], this.curLine = null, this.breakAtStart = 0, this.pendingBuffer = 0, 
            this.bufferMarks = [], this.atCursorPos = !0, this.openStart = -1, this.openEnd = -1, 
            this.text = "", this.textOff = 0, this.cursor = doc.iter(), this.skip = pos;
        }
        posCovered() {
            var last;
            return 0 == this.content.length ? !this.breakAtStart && this.doc.lineAt(this.pos).from != this.pos : !((last = this.content[this.content.length - 1]).breakAfter || last instanceof BlockWidgetView && last.deco.endSide < 0);
        }
        getLine() {
            return this.curLine || (this.content.push(this.curLine = new LineView()), 
            this.atCursorPos = !0), this.curLine;
        }
        flushBuffer(active = this.bufferMarks) {
            this.pendingBuffer && (this.curLine.append(wrapMarks(new WidgetBufferView(-1), active), active.length), 
            this.pendingBuffer = 0);
        }
        addBlockWidget(view) {
            this.flushBuffer(), this.curLine = null, this.content.push(view);
        }
        finish(openEnd) {
            this.pendingBuffer && openEnd <= this.bufferMarks.length ? this.flushBuffer() : this.pendingBuffer = 0, 
            this.posCovered() || openEnd && this.content.length && this.content[this.content.length - 1] instanceof BlockWidgetView || this.getLine();
        }
        buildText(length, active, openStart) {
            for (;0 < length; ) {
                if (this.textOff == this.text.length) {
                    var {
                        value,
                        lineBreak,
                        done
                    } = this.cursor.next(this.skip);
                    if (this.skip = 0, done) throw new Error("Ran out of text content when drawing inline views");
                    if (lineBreak) {
                        this.posCovered() || this.getLine(), this.content.length ? this.content[this.content.length - 1].breakAfter = 1 : this.breakAtStart = 1, 
                        this.flushBuffer(), this.curLine = null, this.atCursorPos = !0, 
                        length--;
                        continue;
                    }
                    this.text = value, this.textOff = 0;
                }
                done = Math.min(this.text.length - this.textOff, length, 512);
                this.flushBuffer(active.slice(active.length - openStart)), this.getLine().append(wrapMarks(new TextView(this.text.slice(this.textOff, this.textOff + done)), active), openStart), 
                this.atCursorPos = !0, this.textOff += done, length -= done, openStart = 0;
            }
        }
        span(from, to, active, openStart) {
            this.buildText(to - from, active, openStart), this.pos = to, this.openStart < 0 && (this.openStart = openStart);
        }
        point(from, to, deco, active, openStart, index) {
            if (this.disallowBlockEffectsFor[index] && deco instanceof PointDecoration) {
                if (deco.block) throw new RangeError("Block decorations may not be specified via plugins");
                if (to > this.doc.lineAt(this.pos).to) throw new RangeError("Decorations that replace line breaks may not be specified via plugins");
            }
            var view, cursorBefore, cursorAfter, line, index = to - from;
            deco instanceof PointDecoration ? deco.block ? (0 < deco.startSide && !this.posCovered() && this.getLine(), 
            this.addBlockWidget(new BlockWidgetView(deco.widget || NullWidget.block, index, deco))) : (view = WidgetView.create(deco.widget || NullWidget.inline, index, index ? 0 : deco.startSide), 
            cursorBefore = this.atCursorPos && !view.isEditable && openStart <= active.length && (from < to || 0 < deco.startSide), 
            cursorAfter = !view.isEditable && (from < to || openStart > active.length || deco.startSide <= 0), 
            line = this.getLine(), 2 != this.pendingBuffer || cursorBefore || view.isEditable || (this.pendingBuffer = 0), 
            this.flushBuffer(active), cursorBefore && (line.append(wrapMarks(new WidgetBufferView(1), active), openStart), 
            openStart = active.length + Math.max(0, openStart - active.length)), 
            line.append(wrapMarks(view, active), openStart), this.atCursorPos = cursorAfter, 
            this.pendingBuffer = cursorAfter ? from < to || openStart > active.length ? 1 : 2 : 0, 
            this.pendingBuffer && (this.bufferMarks = active.slice())) : this.doc.lineAt(this.pos).from == this.pos && this.getLine().addLineDeco(deco), 
            index && (this.textOff + index <= this.text.length ? this.textOff += index : (this.skip += index - (this.text.length - this.textOff), 
            this.text = "", this.textOff = 0), this.pos = to), this.openStart < 0 && (this.openStart = openStart);
        }
        static build(text, from, to, decorations, dynamicDecorationMap) {
            text = new ContentBuilder(text, from, to, dynamicDecorationMap);
            return text.openEnd = RangeSet.spans(decorations, from, to, text), text.openStart < 0 && (text.openStart = text.openEnd), 
            text.finish(text.openEnd), text;
        }
    }
    function wrapMarks(view, active) {
        for (var mark of active) view = new MarkView(mark, [ view ], view.length);
        return view;
    }
    class NullWidget extends WidgetType {
        constructor(tag) {
            super(), this.tag = tag;
        }
        eq(other) {
            return other.tag == this.tag;
        }
        toDOM() {
            return document.createElement(this.tag);
        }
        updateDOM(elt) {
            return elt.nodeName.toLowerCase() == this.tag;
        }
        get isHidden() {
            return !0;
        }
    }
    NullWidget.inline = new NullWidget("span"), NullWidget.block = new NullWidget("div");
    var p, Direction = function(Direction) {
        return Direction[Direction.LTR = 0] = "LTR", Direction[Direction.RTL = 1] = "RTL", 
        Direction;
    }(Direction = Direction || {});
    const LTR = Direction.LTR, RTL = Direction.RTL;
    function dec(str) {
        var result = [];
        for (let i = 0; i < str.length; i++) result.push(1 << +str[i]);
        return result;
    }
    const LowTypes = dec("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008"), ArabicTypes = dec("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333"), Brackets = Object.create(null), BracketStack = [];
    for (p of [ "()", "[]", "{}" ]) {
        var l = p.charCodeAt(0), r = p.charCodeAt(1);
        Brackets[l] = r, Brackets[r] = -l;
    }
    function charType(ch) {
        return ch <= 247 ? LowTypes[ch] : 1424 <= ch && ch <= 1524 ? 2 : 1536 <= ch && ch <= 1785 ? ArabicTypes[ch - 1536] : 1774 <= ch && ch <= 2220 ? 4 : 8192 <= ch && ch <= 8204 ? 256 : 64336 <= ch && ch <= 65023 ? 4 : 1;
    }
    const BidiRE = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;
    class BidiSpan {
        get dir() {
            return this.level % 2 ? RTL : LTR;
        }
        constructor(from, to, level) {
            this.from = from, this.to = to, this.level = level;
        }
        side(end, dir) {
            return this.dir == dir == end ? this.to : this.from;
        }
        forward(forward, dir) {
            return forward == (this.dir == dir);
        }
        static find(order, index, level, assoc) {
            let maybe = -1;
            for (let i = 0; i < order.length; i++) {
                var span = order[i];
                if (span.from <= index && span.to >= index) {
                    if (span.level == level) return i;
                    (maybe < 0 || (0 != assoc ? assoc < 0 ? span.from < index : span.to > index : order[maybe].level > span.level)) && (maybe = i);
                }
            }
            if (maybe < 0) throw new RangeError("Index out of range");
            return maybe;
        }
    }
    const types = [];
    function computeSectionOrder(line, level, baseLevel, isolates, from, to, order) {
        var outerType = level % 2 ? 2 : 1;
        !function(line, rFrom, rTo, isolates, outerType) {
            for (let iI = 0; iI <= isolates.length; iI++) {
                var from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo, prevType = iI ? 256 : outerType;
                for (let i = from, prev = prevType, prevStrong = prevType; i < to; i++) {
                    let type = charType(line.charCodeAt(i));
                    512 == type ? type = prev : 8 == type && 4 == prevStrong && (type = 16), 
                    types[i] = 4 == type ? 2 : type, 7 & type && (prevStrong = type), 
                    prev = type;
                }
                for (let i = from, prev = prevType, prevStrong = prevType; i < to; i++) {
                    let type = types[i];
                    if (128 == type) i < to - 1 && prev == types[i + 1] && 24 & prev ? type = types[i] = prev : types[i] = 256; else if (64 == type) {
                        let end = i + 1;
                        for (;end < to && 64 == types[end]; ) end++;
                        var replace = i && 8 == prev || end < rTo && 8 == types[end] ? 1 == prevStrong ? 1 : 8 : 256;
                        for (let j = i; j < end; j++) types[j] = replace;
                        i = end - 1;
                    } else 8 == type && 1 == prevStrong && (types[i] = 1);
                    7 & (prev = type) && (prevStrong = type);
                }
            }
        }(line, from, to, isolates, outerType), function(line, rFrom, rTo, isolates, outerType) {
            var oppositeType = 1 == outerType ? 2 : 1;
            for (let iI = 0, sI = 0, context = 0; iI <= isolates.length; iI++) {
                var from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
                for (let i = from, ch, br, type; i < to; i++) if (br = Brackets[ch = line.charCodeAt(i)]) if (br < 0) {
                    for (let sJ = sI - 3; 0 <= sJ; sJ -= 3) if (BracketStack[sJ + 1] == -br) {
                        var flags = BracketStack[sJ + 2];
                        let type = 2 & flags ? outerType : 4 & flags ? 1 & flags ? oppositeType : outerType : 0;
                        type && (types[i] = types[BracketStack[sJ]] = type), sI = sJ;
                        break;
                    }
                } else {
                    if (189 == BracketStack.length) break;
                    BracketStack[sI++] = i, BracketStack[sI++] = ch, BracketStack[sI++] = context;
                } else if (2 == (type = types[i]) || 1 == type) {
                    var embed = type == outerType;
                    context = embed ? 0 : 1;
                    for (let sJ = sI - 3; 0 <= sJ; sJ -= 3) {
                        var cur = BracketStack[sJ + 2];
                        if (2 & cur) break;
                        if (embed) BracketStack[sJ + 2] |= 2; else {
                            if (4 & cur) break;
                            BracketStack[sJ + 2] |= 4;
                        }
                    }
                }
            }
        }(line, from, to, isolates, outerType), function(rFrom, rTo, isolates, outerType) {
            for (let iI = 0, prev = outerType; iI <= isolates.length; iI++) {
                let from = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
                for (let i = from; i < to; ) {
                    var type = types[i];
                    if (256 == type) {
                        let end = i + 1;
                        for (;;) if (end == to) {
                            if (iI == isolates.length) break;
                            end = isolates[iI++].to, to = iI < isolates.length ? isolates[iI].from : rTo;
                        } else {
                            if (256 != types[end]) break;
                            end++;
                        }
                        var beforeL = 1 == prev, replace = beforeL == (1 == (end < rTo ? types[end] : outerType)) ? beforeL ? 1 : 2 : outerType;
                        for (let j = end, jI = iI, fromJ = jI ? isolates[jI - 1].to : rFrom; j > i; ) j == fromJ && (j = isolates[--jI].from, 
                        fromJ = jI ? isolates[jI - 1].to : rFrom), types[--j] = replace;
                        i = end;
                    } else prev = type, i++;
                }
            }
        }(from, to, isolates, outerType), function emitSpans(line, from, to, level, baseLevel, isolates, order) {
            var ourType = level % 2 ? 2 : 1;
            if (level % 2 == baseLevel % 2) for (let iCh = from, iI = 0; iCh < to; ) {
                let sameDir = !0, isNum = !1;
                (iI == isolates.length || iCh < isolates[iI].from) && (next = types[iCh]) != ourType && (sameDir = !1, 
                isNum = 16 == next);
                var next, recurse = sameDir || 1 != ourType ? null : [], localLevel = sameDir ? level : level + 1;
                let iScan = iCh;
                run: for (;;) if (iI < isolates.length && iScan == isolates[iI].from) {
                    if (isNum) break;
                    var iso = isolates[iI];
                    if (!sameDir) for (let upto = iso.to, jI = iI + 1; ;) {
                        if (upto == to) break run;
                        if (!(jI < isolates.length && isolates[jI].from == upto)) {
                            if (types[upto] == ourType) break run;
                            break;
                        }
                        upto = isolates[jI++].to;
                    }
                    iI++, recurse ? recurse.push(iso) : (iso.from > iCh && order.push(new BidiSpan(iCh, iso.from, localLevel)), 
                    computeSectionOrder(line, iso.direction == LTR != !(localLevel % 2) ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order), 
                    iCh = iso.to), iScan = iso.to;
                } else {
                    if (iScan == to || (sameDir ? types[iScan] != ourType : types[iScan] == ourType)) break;
                    iScan++;
                }
                recurse ? emitSpans(line, iCh, iScan, level + 1, baseLevel, recurse, order) : iCh < iScan && order.push(new BidiSpan(iCh, iScan, localLevel)), 
                iCh = iScan;
            } else for (let iCh = to, iI = isolates.length; iCh > from; ) {
                let sameDir = !0, isNum = !1;
                if (!iI || iCh > isolates[iI - 1].to) {
                    let next = types[iCh - 1];
                    next != ourType && (sameDir = !1, isNum = 16 == next);
                }
                let recurse = sameDir || 1 != ourType ? null : [], localLevel = sameDir ? level : level + 1, iScan = iCh;
                run: for (;;) if (iI && iScan == isolates[iI - 1].to) {
                    if (isNum) break;
                    let iso = isolates[--iI];
                    if (!sameDir) for (let upto = iso.from, jI = iI; ;) {
                        if (upto == from) break run;
                        if (!jI || isolates[jI - 1].to != upto) {
                            if (types[upto - 1] == ourType) break run;
                            break;
                        }
                        upto = isolates[--jI].from;
                    }
                    if (recurse) recurse.push(iso); else {
                        iso.to < iCh && order.push(new BidiSpan(iso.to, iCh, localLevel));
                        let dirSwap = iso.direction == LTR != !(localLevel % 2);
                        computeSectionOrder(line, dirSwap ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order), 
                        iCh = iso.from;
                    }
                    iScan = iso.from;
                } else {
                    if (iScan == from || (sameDir ? types[iScan - 1] != ourType : types[iScan - 1] == ourType)) break;
                    iScan--;
                }
                recurse ? emitSpans(line, iScan, iCh, level + 1, baseLevel, recurse, order) : iScan < iCh && order.push(new BidiSpan(iScan, iCh, localLevel)), 
                iCh = iScan;
            }
        }(line, from, to, level, baseLevel, isolates, order);
    }
    function trivialOrder(length) {
        return [ new BidiSpan(0, length, 0) ];
    }
    let movedOver = "";
    const clickAddsSelectionRange = Facet.define(), dragMovesSelection$1 = Facet.define(), mouseSelectionStyle = Facet.define(), exceptionSink = Facet.define(), updateListener = Facet.define(), inputHandler = Facet.define(), focusChangeEffect = Facet.define(), clipboardInputFilter = Facet.define(), clipboardOutputFilter = Facet.define(), perLineTextDirection = Facet.define({
        combine: values => values.some(x => x)
    }), nativeSelectionHidden = Facet.define({
        combine: values => values.some(x => x)
    }), scrollHandler = Facet.define();
    class ScrollTarget {
        constructor(range, y = "nearest", x = "nearest", yMargin = 5, xMargin = 5, isSnapshot = !1) {
            this.range = range, this.y = y, this.x = x, this.yMargin = yMargin, 
            this.xMargin = xMargin, this.isSnapshot = isSnapshot;
        }
        map(changes) {
            return changes.empty ? this : new ScrollTarget(this.range.map(changes), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
        }
        clip(state) {
            return this.range.to <= state.doc.length ? this : new ScrollTarget(EditorSelection.cursor(state.doc.length), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
        }
    }
    const scrollIntoView$1 = StateEffect.define({
        map: (t, ch) => t.map(ch)
    }), setEditContextFormatting = StateEffect.define();
    function logException(state, exception, context) {
        state = state.facet(exceptionSink);
        state.length ? state[0](exception) : window.onerror && window.onerror(String(exception), context, void 0, void 0, exception) || (context ? console.error(context + ":", exception) : console.error(exception));
    }
    const editable = Facet.define({
        combine: values => !values.length || values[0]
    });
    let nextPluginID = 0;
    const viewPlugin = Facet.define({
        combine(plugins) {
            return plugins.filter((p, i) => {
                for (let j = 0; j < i; j++) if (plugins[j].plugin == p.plugin) return !1;
                return !0;
            });
        }
    });
    class ViewPlugin {
        constructor(id, create, domEventHandlers, domEventObservers, buildExtensions) {
            this.id = id, this.create = create, this.domEventHandlers = domEventHandlers, 
            this.domEventObservers = domEventObservers, this.baseExtensions = buildExtensions(this), 
            this.extension = this.baseExtensions.concat(viewPlugin.of({
                plugin: this,
                arg: void 0
            }));
        }
        of(arg) {
            return this.baseExtensions.concat(viewPlugin.of({
                plugin: this,
                arg: arg
            }));
        }
        static define(create, spec) {
            const {
                eventHandlers,
                eventObservers,
                provide,
                decorations: deco
            } = spec || {};
            return new ViewPlugin(nextPluginID++, create, eventHandlers, eventObservers, plugin => {
                var ext = [];
                return deco && ext.push(decorations.of(view => {
                    view = view.plugin(plugin);
                    return view ? deco(view) : Decoration.none;
                })), provide && ext.push(provide(plugin)), ext;
            });
        }
        static fromClass(cls, spec) {
            return ViewPlugin.define((view, arg) => new cls(view, arg), spec);
        }
    }
    class PluginInstance {
        constructor(spec) {
            this.spec = spec, this.mustUpdate = null, this.value = null;
        }
        get plugin() {
            return this.spec && this.spec.plugin;
        }
        update(view) {
            if (this.value) {
                if (this.mustUpdate) {
                    var update = this.mustUpdate;
                    if (this.mustUpdate = null, this.value.update) try {
                        this.value.update(update);
                    } catch (e) {
                        if (logException(update.state, e, "CodeMirror plugin crashed"), 
                        this.value.destroy) try {
                            this.value.destroy();
                        } catch (_) {}
                        this.deactivate();
                    }
                }
            } else if (this.spec) try {
                this.value = this.spec.plugin.create(view, this.spec.arg);
            } catch (e) {
                logException(view.state, e, "CodeMirror plugin crashed"), this.deactivate();
            }
            return this;
        }
        destroy(view) {
            var _a;
            if (null != (_a = this.value) && _a.destroy) try {
                this.value.destroy();
            } catch (e) {
                logException(view.state, e, "CodeMirror plugin crashed");
            }
        }
        deactivate() {
            this.spec = this.value = null;
        }
    }
    const editorAttributes = Facet.define(), contentAttributes = Facet.define(), decorations = Facet.define(), outerDecorations = Facet.define(), atomicRanges = Facet.define(), bidiIsolatedRanges = Facet.define();
    function getIsolatedRanges(view, line) {
        var isolates = view.state.facet(bidiIsolatedRanges);
        if (!isolates.length) return isolates;
        isolates = isolates.map(i => i instanceof Function ? i(view) : i);
        let result = [];
        return RangeSet.spans(isolates, line.from, line.to, {
            point() {},
            span(fromDoc, toDoc, active, open) {
                var add, from = fromDoc - line.from, to = toDoc - line.from;
                let level = result;
                for (let i = active.length - 1; 0 <= i; i--, open--) {
                    let direction = active[i].spec.bidiIsolate, update;
                    null == direction && (direction = function(text, from, to) {
                        for (let i = from; i < to; i++) {
                            var type = charType(text.charCodeAt(i));
                            if (1 == type) return LTR;
                            if (2 == type || 4 == type) return RTL;
                        }
                        return LTR;
                    }(line.text, from, to)), level = (0 < open && level.length && (update = level[level.length - 1]).to == from && update.direction == direction ? (update.to = to, 
                    update) : (add = {
                        from: from,
                        to: to,
                        direction: direction,
                        inner: []
                    }, level.push(add), add)).inner;
                }
            }
        }), result;
    }
    const scrollMargins = Facet.define();
    function getScrollMargins(view) {
        let left = 0, right = 0, top = 0, bottom = 0;
        for (var source of view.state.facet(scrollMargins)) {
            source = source(view);
            source && (null != source.left && (left = Math.max(left, source.left)), 
            null != source.right && (right = Math.max(right, source.right)), null != source.top && (top = Math.max(top, source.top)), 
            null != source.bottom) && (bottom = Math.max(bottom, source.bottom));
        }
        return {
            left: left,
            right: right,
            top: top,
            bottom: bottom
        };
    }
    const styleModule = Facet.define();
    class ChangedRange {
        constructor(fromA, toA, fromB, toB) {
            this.fromA = fromA, this.toA = toA, this.fromB = fromB, this.toB = toB;
        }
        join(other) {
            return new ChangedRange(Math.min(this.fromA, other.fromA), Math.max(this.toA, other.toA), Math.min(this.fromB, other.fromB), Math.max(this.toB, other.toB));
        }
        addToSet(set) {
            let i = set.length, me = this;
            for (;0 < i; i--) {
                var range = set[i - 1];
                if (!(range.fromA > me.toA)) {
                    if (range.toA < me.fromA) break;
                    me = me.join(range), set.splice(i - 1, 1);
                }
            }
            return set.splice(i, 0, me), set;
        }
        static extendWithRanges(diff, ranges) {
            if (0 == ranges.length) return diff;
            var result = [];
            for (let dI = 0, rI = 0, posA = 0, posB = 0; ;dI++) {
                for (var next = dI == diff.length ? null : diff[dI], off = posA - posB, end = next ? next.fromB : 1e9; rI < ranges.length && ranges[rI] < end; ) {
                    var from = ranges[rI], to = ranges[rI + 1], from = Math.max(posB, from), toB = Math.min(end, to);
                    if (from <= toB && new ChangedRange(from + off, toB + off, from, toB).addToSet(result), 
                    end < to) break;
                    rI += 2;
                }
                if (!next) return result;
                new ChangedRange(next.fromA, next.toA, next.fromB, next.toB).addToSet(result), 
                posA = next.toA, posB = next.toB;
            }
        }
    }
    class ViewUpdate {
        constructor(view, state, transactions) {
            this.view = view, this.state = state, this.transactions = transactions, 
            this.flags = 0, this.startState = view.state, this.changes = ChangeSet.empty(this.startState.doc.length);
            for (var tr of transactions) this.changes = this.changes.compose(tr.changes);
            let changedRanges = [];
            this.changes.iterChangedRanges((fromA, toA, fromB, toB) => changedRanges.push(new ChangedRange(fromA, toA, fromB, toB))), 
            this.changedRanges = changedRanges;
        }
        static create(view, state, transactions) {
            return new ViewUpdate(view, state, transactions);
        }
        get viewportChanged() {
            return 0 < (4 & this.flags);
        }
        get viewportMoved() {
            return 0 < (8 & this.flags);
        }
        get heightChanged() {
            return 0 < (2 & this.flags);
        }
        get geometryChanged() {
            return this.docChanged || 0 < (18 & this.flags);
        }
        get focusChanged() {
            return 0 < (1 & this.flags);
        }
        get docChanged() {
            return !this.changes.empty;
        }
        get selectionSet() {
            return this.transactions.some(tr => tr.selection);
        }
        get empty() {
            return 0 == this.flags && 0 == this.transactions.length;
        }
    }
    class DocView extends ContentView {
        get length() {
            return this.view.state.doc.length;
        }
        constructor(view) {
            super(), this.view = view, this.decorations = [], this.dynamicDecorationMap = [ !1 ], 
            this.domChanged = null, this.hasComposition = null, this.markedForComposition = new Set(), 
            this.editContextFormatting = Decoration.none, this.lastCompositionAfterCursor = !1, 
            this.minWidth = 0, this.minWidthFrom = 0, this.minWidthTo = 0, this.impreciseAnchor = null, 
            this.impreciseHead = null, this.forceSelection = !1, this.lastUpdate = Date.now(), 
            this.setDOM(view.contentDOM), this.children = [ new LineView() ], this.children[0].setParent(this), 
            this.updateDeco(), this.updateInner([ new ChangedRange(0, 0, 0, view.state.doc.length) ], 0, null);
        }
        update(update) {
            let changedRanges = update.changedRanges, readCompositionAt = (0 < this.minWidth && changedRanges.length && (changedRanges.every(({
                fromA,
                toA
            }) => toA < this.minWidthFrom || fromA > this.minWidthTo) ? (this.minWidthFrom = update.changes.mapPos(this.minWidthFrom, 1), 
            this.minWidthTo = update.changes.mapPos(this.minWidthTo, 1)) : this.minWidth = this.minWidthFrom = this.minWidthTo = 0), 
            this.updateEditContextFormatting(update), -1);
            0 <= this.view.inputState.composing && !this.view.observer.editContext && (null != (_a = this.domChanged) && _a.newSel ? readCompositionAt = this.domChanged.newSel.head : function(changes, composition) {
                let touched = !1;
                composition && changes.iterChangedRanges((from, to) => {
                    from < composition.to && to > composition.from && (touched = !0);
                });
                return touched;
            }(update.changes, this.hasComposition) || update.selectionSet || (readCompositionAt = update.state.selection.main.head));
            var comp, _a = -1 < readCompositionAt ? function(view, changes, headPos) {
                headPos = findCompositionNode(view, headPos);
                if (!headPos) return null;
                var {
                    node: textNode,
                    from,
                    to
                } = headPos, text = textNode.nodeValue;
                if (/[\n\r]/.test(text)) return null;
                if (view.state.doc.sliceString(headPos.from, headPos.to) != text) return null;
                var headPos = changes.invertedDesc, range = new ChangedRange(headPos.mapPos(from), headPos.mapPos(to), from, to), marks = [];
                for (let parent = textNode.parentNode; ;parent = parent.parentNode) {
                    var parentView = ContentView.get(parent);
                    if (parentView instanceof MarkView) marks.push({
                        node: parent,
                        deco: parentView.mark
                    }); else {
                        if (parentView instanceof LineView || "DIV" == parent.nodeName && parent.parentNode == view.contentDOM) return {
                            range: range,
                            text: textNode,
                            marks: marks,
                            line: parent
                        };
                        if (parent == view.contentDOM) return null;
                        marks.push({
                            node: parent,
                            deco: new MarkDecoration({
                                inclusive: !0,
                                attributes: function(dom) {
                                    var attrs = Object.create(null);
                                    for (let i = 0; i < dom.attributes.length; i++) {
                                        var attr = dom.attributes[i];
                                        attrs[attr.name] = attr.value;
                                    }
                                    return attrs;
                                }(parent),
                                tagName: parent.tagName.toLowerCase()
                            })
                        });
                    }
                }
            }(this.view, update.changes, readCompositionAt) : null, from = (this.domChanged = null, 
            this.hasComposition && (this.markedForComposition.clear(), {
                from,
                to
            } = this.hasComposition, changedRanges = new ChangedRange(from, to, update.changes.mapPos(from, -1), update.changes.mapPos(to, 1)).addToSet(changedRanges.slice())), 
            this.hasComposition = _a ? {
                from: _a.range.fromB,
                to: _a.range.toB
            } : null, (browser.ie || browser.chrome) && !_a && update && update.state.doc.lines != update.startState.doc.lines && (this.forceSelection = !0), 
            this.decorations), to = this.updateDeco(), diff = (from = from, to = to, 
            diff = update.changes, comp = new DecorationComparator$1(), RangeSet.compare(from, to, diff, comp), 
            comp.changes);
            return changedRanges = ChangedRange.extendWithRanges(changedRanges, diff), 
            !!(7 & this.flags || 0 != changedRanges.length) && (this.updateInner(changedRanges, update.startState.doc.length, _a), 
            update.transactions.length && (this.lastUpdate = Date.now()), !0);
        }
        updateInner(changes, oldLength, composition) {
            this.view.viewState.mustMeasureContent = !0, this.updateChildren(changes, oldLength, composition);
            let observer = this.view["observer"];
            observer.ignore(() => {
                this.dom.style.height = this.view.viewState.contentHeight / this.view.scaleY + "px", 
                this.dom.style.flexBasis = this.minWidth ? this.minWidth + "px" : "";
                var track = browser.chrome || browser.ios ? {
                    node: observer.selectionRange.focusNode,
                    written: !1
                } : void 0;
                this.sync(this.view, track), this.flags &= -8, track && (track.written || observer.selectionRange.focusNode != track.node) && (this.forceSelection = !0), 
                this.dom.style.height = "";
            }), this.markedForComposition.forEach(cView => cView.flags &= -9);
            var gaps = [];
            if (this.view.viewport.from || this.view.viewport.to < this.view.state.doc.length) for (var child of this.children) child instanceof BlockWidgetView && child.widget instanceof BlockGapWidget && gaps.push(child.dom);
            observer.updateGaps(gaps);
        }
        updateChildren(changes, oldLength, composition) {
            var ranges = composition ? composition.range.addToSet(changes.slice()) : changes, cursor = this.childCursor(oldLength);
            for (let i = ranges.length - 1; ;i--) {
                var next = 0 <= i ? ranges[i] : null;
                if (!next) break;
                let {
                    fromA,
                    toA,
                    fromB,
                    toB
                } = next, content, breakAtStart, openStart, openEnd;
                composition && composition.range.fromB < toB && composition.range.toB > fromB ? (next = ContentBuilder.build(this.view.state.doc, fromB, composition.range.fromB, this.decorations, this.dynamicDecorationMap), 
                after = ContentBuilder.build(this.view.state.doc, composition.range.toB, toB, this.decorations, this.dynamicDecorationMap), 
                breakAtStart = next.breakAtStart, openStart = next.openStart, openEnd = after.openEnd, 
                compLine = this.compositionView(composition), after.breakAtStart ? compLine.breakAfter = 1 : after.content.length && compLine.merge(compLine.length, compLine.length, after.content[0], !1, after.openStart, 0) && (compLine.breakAfter = after.content[0].breakAfter, 
                after.content.shift()), next.content.length && compLine.merge(0, 0, next.content[next.content.length - 1], !0, 0, next.openEnd) && next.content.pop(), 
                content = next.content.concat(compLine).concat(after.content)) : {
                    content,
                    breakAtStart,
                    openStart,
                    openEnd
                } = ContentBuilder.build(this.view.state.doc, fromB, toB, this.decorations, this.dynamicDecorationMap);
                var {
                    i: next,
                    off: compLine
                } = cursor.findPos(toA, 1), {
                    i: after,
                    off: fromOff
                } = cursor.findPos(fromA, -1);
                replaceRange(this, after, fromOff, next, compLine, content, breakAtStart, openStart, openEnd);
            }
            composition && this.fixCompositionDOM(composition);
        }
        updateEditContextFormatting(update) {
            this.editContextFormatting = this.editContextFormatting.map(update.changes);
            for (var tr of update.transactions) for (var effect of tr.effects) effect.is(setEditContextFormatting) && (this.editContextFormatting = effect.value);
        }
        compositionView(composition) {
            let cur = new TextView(composition.text.nodeValue);
            cur.flags |= 8;
            for (var {
                deco
            } of composition.marks) cur = new MarkView(deco, [ cur ], cur.length);
            composition = new LineView();
            return composition.append(cur, 0), composition;
        }
        fixCompositionDOM(composition) {
            var fix = (dom, cView) => {
                cView.flags |= 8 | (cView.children.some(c => 7 & c.flags) ? 1 : 0), 
                this.markedForComposition.add(cView);
                var prev = ContentView.get(dom);
                prev && prev != cView && (prev.dom = null), cView.setDOM(dom);
            };
            let pos = this.childPos(composition.range.fromB, 1), cView = this.children[pos.i];
            fix(composition.line, cView);
            for (let i = composition.marks.length - 1; -1 <= i; i--) pos = cView.childPos(pos.off, 1), 
            cView = cView.children[pos.i], fix(0 <= i ? composition.marks[i].node : composition.text, cView);
        }
        updateSelection(mustRead = !1, fromPointer = !1) {
            !mustRead && this.view.observer.selectionRange.focusNode || this.view.observer.readSelectionRange();
            let activeElt = this.view.root.activeElement, focused = activeElt == this.dom, selectionNotFocus = !focused && !(this.view.state.facet(editable) || -1 < this.dom.tabIndex) && hasSelection(this.dom, this.view.observer.selectionRange) && !(activeElt && this.dom.contains(activeElt));
            if (focused || fromPointer || selectionNotFocus) {
                let force = this.forceSelection, main = (this.forceSelection = !1, 
                this.view.state.selection.main), anchor = this.moveToLine(this.domAtPos(main.anchor)), head = main.empty ? anchor : this.moveToLine(this.domAtPos(main.head));
                if (browser.gecko && main.empty && !this.hasComposition && 1 == (mustRead = anchor).node.nodeType && mustRead.node.firstChild && (0 == mustRead.offset || "false" == mustRead.node.childNodes[mustRead.offset - 1].contentEditable) && (mustRead.offset == mustRead.node.childNodes.length || "false" == mustRead.node.childNodes[mustRead.offset].contentEditable)) {
                    let dummy = document.createTextNode("");
                    this.view.observer.ignore(() => anchor.node.insertBefore(dummy, anchor.node.childNodes[anchor.offset] || null)), 
                    anchor = head = new DOMPos(dummy, 0), force = !0;
                }
                let domSel = this.view.observer.selectionRange;
                !force && domSel.focusNode && (isEquivalentPosition(anchor.node, anchor.offset, domSel.anchorNode, domSel.anchorOffset) && isEquivalentPosition(head.node, head.offset, domSel.focusNode, domSel.focusOffset) || this.suppressWidgetCursorChange(domSel, main)) || (this.view.observer.ignore(() => {
                    browser.android && browser.chrome && this.dom.contains(domSel.focusNode) && function(node, inside) {
                        for (let cur = node; cur && cur != inside; cur = cur.assignedSlot || cur.parentNode) if (1 == cur.nodeType && "false" == cur.contentEditable) return 1;
                        return;
                    }(domSel.focusNode, this.dom) && (this.dom.blur(), this.dom.focus({
                        preventScroll: !0
                    }));
                    var offset, rawSel = getSelection(this.view.root);
                    if (rawSel) if (main.empty) browser.gecko && (node = anchor.node, 
                    offset = anchor.offset, node = 1 != node.nodeType ? 0 : (offset && "false" == node.childNodes[offset - 1].contentEditable ? 1 : 0) | (offset < node.childNodes.length && "false" == node.childNodes[offset].contentEditable ? 2 : 0)) && 3 != node && (offset = (1 == node ? textNodeBefore : textNodeAfter)(anchor.node, anchor.offset)) && (anchor = new DOMPos(offset.node, offset.offset)), 
                    rawSel.collapse(anchor.node, anchor.offset), null != main.bidiLevel && void 0 !== rawSel.caretBidiLevel && (rawSel.caretBidiLevel = main.bidiLevel); else if (rawSel.extend) {
                        rawSel.collapse(anchor.node, anchor.offset);
                        try {
                            rawSel.extend(head.node, head.offset);
                        } catch (_) {}
                    } else {
                        var node = document.createRange();
                        main.anchor > main.head && ([ anchor, head ] = [ head, anchor ]), 
                        node.setEnd(head.node, head.offset), node.setStart(anchor.node, anchor.offset), 
                        rawSel.removeAllRanges(), rawSel.addRange(node);
                    }
                    selectionNotFocus && this.view.root.activeElement == this.dom && (this.dom.blur(), 
                    activeElt) && activeElt.focus();
                }), this.view.observer.setSelectionRange(anchor, head)), this.impreciseAnchor = anchor.precise ? null : new DOMPos(domSel.anchorNode, domSel.anchorOffset), 
                this.impreciseHead = head.precise ? null : new DOMPos(domSel.focusNode, domSel.focusOffset);
            }
        }
        suppressWidgetCursorChange(sel, cursor) {
            return this.hasComposition && cursor.empty && isEquivalentPosition(sel.focusNode, sel.focusOffset, sel.anchorNode, sel.anchorOffset) && this.posFromDOM(sel.focusNode, sel.focusOffset) == cursor.head;
        }
        enforceCursorAssoc() {
            var view, cursor, sel, anchorNode, anchorOffset, lineStart, line;
            this.hasComposition || (view = this["view"], cursor = view.state.selection.main, 
            sel = getSelection(view.root), {
                anchorNode,
                anchorOffset
            } = view.observer.selectionRange, sel && cursor.empty && cursor.assoc && sel.modify && (line = LineView.find(this, cursor.head)) && (lineStart = line.posAtStart, 
            cursor.head == lineStart || cursor.head == lineStart + line.length || (lineStart = this.coordsAt(cursor.head, -1), 
            line = this.coordsAt(cursor.head, 1), !lineStart) || !line || lineStart.bottom > line.top || (lineStart = this.domAtPos(cursor.head + cursor.assoc), 
            sel.collapse(lineStart.node, lineStart.offset), sel.modify("move", cursor.assoc < 0 ? "forward" : "backward", "lineboundary"), 
            view.observer.readSelectionRange(), line = view.observer.selectionRange, 
            view.docView.posFromDOM(line.anchorNode, line.anchorOffset) != cursor.from && sel.collapse(anchorNode, anchorOffset))));
        }
        moveToLine(pos) {
            let dom = this.dom, newPos;
            if (pos.node != dom) return pos;
            for (let i = pos.offset; !newPos && i < dom.childNodes.length; i++) {
                var view = ContentView.get(dom.childNodes[i]);
                view instanceof LineView && (newPos = view.domAtPos(0));
            }
            for (let i = pos.offset - 1; !newPos && 0 <= i; i--) {
                let view = ContentView.get(dom.childNodes[i]);
                view instanceof LineView && (newPos = view.domAtPos(view.length));
            }
            return newPos ? new DOMPos(newPos.node, newPos.offset, !0) : pos;
        }
        nearest(dom) {
            for (let cur = dom; cur; ) {
                var domView = ContentView.get(cur);
                if (domView && domView.rootView == this) return domView;
                cur = cur.parentNode;
            }
            return null;
        }
        posFromDOM(node, offset) {
            var view = this.nearest(node);
            if (view) return view.localPosFromDOM(node, offset) + view.posAtStart;
            throw new RangeError("Trying to find position for a DOM position outside of the document");
        }
        domAtPos(pos) {
            let {
                i,
                off
            } = this.childCursor().findPos(pos, -1);
            for (;i < this.children.length - 1; ) {
                var child = this.children[i];
                if (off < child.length || child instanceof LineView) break;
                i++, off = 0;
            }
            return this.children[i].domAtPos(off);
        }
        coordsAt(pos, side) {
            let best = null, bestPos = 0;
            for (let off = this.length, i = this.children.length - 1; 0 <= i; i--) {
                var child = this.children[i], end = off - child.breakAfter, start = end - child.length;
                if (end < pos) break;
                if (start <= pos && (start < pos || child.covers(-1)) && (pos < end || child.covers(1)) && (!best || child instanceof LineView && !(best instanceof LineView && 0 <= side))) best = child, 
                bestPos = start; else if (best && start == pos && end == pos && child instanceof BlockWidgetView && Math.abs(side) < 2) {
                    if (child.deco.startSide < 0) break;
                    i && (best = null);
                }
                off = start;
            }
            return best ? best.coordsAt(pos - bestPos, side) : null;
        }
        coordsForChar(pos) {
            let {
                i,
                off
            } = this.childPos(pos, 1), child = this.children[i];
            if (child instanceof LineView) {
                for (;child.children.length; ) {
                    let {
                        i,
                        off: childOff
                    } = child.childPos(off, 1);
                    for (;;i++) {
                        if (i == child.children.length) return null;
                        if ((child = child.children[i]).length) break;
                    }
                    off = childOff;
                }
                if (child instanceof TextView) {
                    pos = findClusterBreak(child.text, off);
                    if (pos != off) {
                        var rects = textRange(child.dom, off, pos).getClientRects();
                        for (let i = 0; i < rects.length; i++) {
                            var rect = rects[i];
                            if (i == rects.length - 1 || rect.top < rect.bottom && rect.left < rect.right) return rect;
                        }
                    }
                }
            }
            return null;
        }
        measureVisibleLineHeights(viewport) {
            var result = [], {
                from,
                to
            } = viewport, contentWidth = this.view.contentDOM.clientWidth, isWider = contentWidth > Math.max(this.view.scrollDOM.clientWidth, this.minWidth) + 1;
            let widest = -1, ltr = this.view.textDirection == Direction.LTR;
            for (let pos = 0, i = 0; i < this.children.length; i++) {
                var last, childRect, child = this.children[i], end = pos + child.length;
                if (to < end) break;
                pos >= from && (childRect = child.dom.getBoundingClientRect(), result.push(childRect.height), 
                isWider) && (last = (last = child.dom.lastChild) ? clientRectsFor(last) : []).length && (last = last[last.length - 1], 
                (childRect = ltr ? last.right - childRect.left : childRect.right - last.left) > widest) && (widest = childRect, 
                this.minWidth = contentWidth, this.minWidthFrom = pos, this.minWidthTo = end), 
                pos = end + child.breakAfter;
            }
            return result;
        }
        textDirectionAt(pos) {
            pos = this.childPos(pos, 1).i;
            return "rtl" == getComputedStyle(this.children[pos].dom).direction ? Direction.RTL : Direction.LTR;
        }
        measureTextSize() {
            for (var child of this.children) if (child instanceof LineView) {
                child = child.measureTextSize();
                if (child) return child;
            }
            let dummy = document.createElement("div"), lineHeight, charWidth, textHeight;
            return dummy.className = "cm-line", dummy.style.width = "99999px", dummy.style.position = "absolute", 
            dummy.textContent = "abc def ghi jkl mno pqr stu", this.view.observer.ignore(() => {
                this.dom.appendChild(dummy);
                var rect = clientRectsFor(dummy.firstChild)[0];
                lineHeight = dummy.getBoundingClientRect().height, charWidth = rect ? rect.width / 27 : 7, 
                textHeight = rect ? rect.height : lineHeight, dummy.remove();
            }), {
                lineHeight: lineHeight,
                charWidth: charWidth,
                textHeight: textHeight
            };
        }
        childCursor(pos = this.length) {
            let i = this.children.length;
            return i && (pos -= this.children[--i].length), new ChildCursor(this.children, pos, i);
        }
        computeBlockGapDeco() {
            var deco = [], vs = this.view.viewState;
            for (let pos = 0, i = 0; ;i++) {
                var height, next = i == vs.viewports.length ? null : vs.viewports[i], end = next ? next.from - 1 : this.length;
                if (end > pos && (height = (vs.lineBlockAt(end).bottom - vs.lineBlockAt(pos).top) / this.view.scaleY, 
                deco.push(Decoration.replace({
                    widget: new BlockGapWidget(height),
                    block: !0,
                    inclusive: !0,
                    isBlockGap: !0
                }).range(pos, end))), !next) break;
                pos = next.to + 1;
            }
            return Decoration.set(deco);
        }
        updateDeco() {
            let i = 1;
            var allDeco = this.view.state.facet(decorations).map(d => {
                return (this.dynamicDecorationMap[i++] = "function" == typeof d) ? d(this.view) : d;
            });
            let dynamicOuter = !1, outerDeco = this.view.state.facet(outerDecorations).map((d, i) => {
                var dynamic = "function" == typeof d;
                return dynamic && (dynamicOuter = !0), dynamic ? d(this.view) : d;
            });
            for (outerDeco.length && (this.dynamicDecorationMap[i++] = dynamicOuter, 
            allDeco.push(RangeSet.join(outerDeco))), this.decorations = [ this.editContextFormatting, ...allDeco, this.computeBlockGapDeco(), this.view.viewState.lineGapDeco ]; i < this.decorations.length; ) this.dynamicDecorationMap[i++] = !1;
            return this.decorations;
        }
        scrollIntoView(target) {
            if (target.isSnapshot) ref = this.view.viewState.lineBlockAt(target.range.head), 
            this.view.scrollDOM.scrollTop = ref.top - target.yMargin, this.view.scrollDOM.scrollLeft = target.xMargin; else {
                for (var handler of this.view.state.facet(scrollHandler)) try {
                    if (handler(this.view, target.range, target)) return !0;
                } catch (e) {
                    logException(this.view.state, e, "scroll handler");
                }
                var margins, offsetWidth, offsetHeight, ref = target["range"];
                let rect = this.coordsAt(ref.head, ref.empty ? ref.assoc : ref.head > ref.anchor ? -1 : 1), other;
                rect && (!ref.empty && (other = this.coordsAt(ref.anchor, ref.anchor > ref.head ? -1 : 1)) && (rect = {
                    left: Math.min(rect.left, other.left),
                    top: Math.min(rect.top, other.top),
                    right: Math.max(rect.right, other.right),
                    bottom: Math.max(rect.bottom, other.bottom)
                }), margins = getScrollMargins(this.view), margins = {
                    left: rect.left - margins.left,
                    top: rect.top - margins.top,
                    right: rect.right + margins.right,
                    bottom: rect.bottom + margins.bottom
                }, {
                    offsetWidth,
                    offsetHeight
                } = this.view.scrollDOM, scrollRectIntoView(this.view.scrollDOM, margins, ref.head < ref.anchor ? -1 : 1, target.x, target.y, Math.max(Math.min(target.xMargin, offsetWidth), -offsetWidth), Math.max(Math.min(target.yMargin, offsetHeight), -offsetHeight), this.view.textDirection == Direction.LTR));
            }
        }
    }
    function findCompositionNode(view, headPos) {
        var sel = view.observer.selectionRange;
        if (!sel.focusNode) return null;
        var descAfter, textBefore = textNodeBefore(sel.focusNode, sel.focusOffset), sel = textNodeAfter(sel.focusNode, sel.focusOffset);
        let textNode = textBefore || sel;
        return sel && textBefore && sel.node != textBefore.node && (!(descAfter = ContentView.get(sel.node)) || descAfter instanceof TextView && descAfter.text != sel.node.nodeValue || view.docView.lastCompositionAfterCursor && (descAfter = ContentView.get(textBefore.node)) && !(descAfter instanceof TextView && descAfter.text != textBefore.node.nodeValue)) && (textNode = sel), 
        view.docView.lastCompositionAfterCursor = textNode != textBefore, textNode ? {
            from: descAfter = headPos - textNode.offset,
            to: descAfter + textNode.node.nodeValue.length,
            node: textNode.node
        } : null;
    }
    let DecorationComparator$1 = class {
        constructor() {
            this.changes = [];
        }
        compareRange(from, to) {
            addRange(from, to, this.changes);
        }
        comparePoint(from, to) {
            addRange(from, to, this.changes);
        }
        boundChange(pos) {
            addRange(pos, pos, this.changes);
        }
    };
    function yOverlap(a, b) {
        return a.top < b.bottom - 1 && a.bottom > b.top + 1;
    }
    function upTop(rect, top) {
        return top < rect.top ? {
            top: top,
            left: rect.left,
            right: rect.right,
            bottom: rect.bottom
        } : rect;
    }
    function upBot(rect, bottom) {
        return bottom > rect.bottom ? {
            top: rect.top,
            left: rect.left,
            right: rect.right,
            bottom: bottom
        } : rect;
    }
    function domPosAtCoords(parent, x, y) {
        let closest, closestRect, closestX, closestY, closestOverlap = !1, above, below, aboveRect, belowRect;
        for (let child = parent.firstChild; child; child = child.nextSibling) {
            var rects = clientRectsFor(child);
            for (let i = 0; i < rects.length; i++) {
                let rect = rects[i];
                var dx = function(x, rect) {
                    return rect.left > x ? rect.left - x : Math.max(0, x - rect.right);
                }(x, rect = closestRect && yOverlap(closestRect, rect) ? upTop(upBot(rect, closestRect.bottom), closestRect.top) : rect), dy = function(y, rect) {
                    return rect.top > y ? rect.top - y : Math.max(0, y - rect.bottom);
                }(y, rect);
                if (0 == dx && 0 == dy) return (3 == child.nodeType ? domPosInText : domPosAtCoords)(child, x, y);
                (!closest || closestY > dy || closestY == dy && closestX > dx) && (closest = child, 
                closestRect = rect, closestX = dx, closestY = dy, closestOverlap = !dx || (x < rect.left ? 0 < i : i < rects.length - 1)), 
                0 == dx ? y > rect.bottom && (!aboveRect || aboveRect.bottom < rect.bottom) ? (above = child, 
                aboveRect = rect) : y < rect.top && (!belowRect || belowRect.top > rect.top) && (below = child, 
                belowRect = rect) : aboveRect && yOverlap(aboveRect, rect) ? aboveRect = upBot(aboveRect, rect.bottom) : belowRect && yOverlap(belowRect, rect) && (belowRect = upTop(belowRect, rect.top));
            }
        }
        var clipX;
        return aboveRect && aboveRect.bottom >= y ? (closest = above, closestRect = aboveRect) : belowRect && belowRect.top <= y && (closest = below, 
        closestRect = belowRect), closest ? (clipX = Math.max(closestRect.left, Math.min(closestRect.right, x)), 
        3 == closest.nodeType ? domPosInText(closest, clipX, y) : closestOverlap && "false" != closest.contentEditable ? domPosAtCoords(closest, clipX, y) : {
            node: parent,
            offset: Array.prototype.indexOf.call(parent.childNodes, closest) + (x >= (closestRect.left + closestRect.right) / 2 ? 1 : 0)
        }) : {
            node: parent,
            offset: 0
        };
    }
    function domPosInText(node, x, y) {
        var len = node.nodeValue.length;
        let closestOffset = -1, closestDY = 1e9, generalSide = 0;
        for (let i = 0; i < len; i++) {
            var rects = textRange(node, i, i + 1).getClientRects();
            for (let j = 0; j < rects.length; j++) {
                var rect = rects[j];
                if (rect.top != rect.bottom) {
                    generalSide = generalSide || x - rect.left;
                    var dy = (rect.top > y ? rect.top - y : y - rect.bottom) - 1;
                    if (rect.left - 1 <= x && rect.right + 1 >= x && dy < closestDY) {
                        let right = x >= (rect.left + rect.right) / 2, after = right;
                        if ((browser.chrome || browser.gecko) && textRange(node, i).getBoundingClientRect().left == rect.right && (after = !right), 
                        dy <= 0) return {
                            node: node,
                            offset: i + (after ? 1 : 0)
                        };
                        closestOffset = i + (after ? 1 : 0), closestDY = dy;
                    }
                }
            }
        }
        return {
            node: node,
            offset: -1 < closestOffset ? closestOffset : 0 < generalSide ? node.nodeValue.length : 0
        };
    }
    function posAtCoords(view, coords, precise, bias = -1) {
        var content = view.contentDOM.getBoundingClientRect(), docTop = content.top + view.viewState.paddingTop;
        let block, docHeight = view.viewState["docHeight"], {
            x,
            y
        } = coords, yOffset = y - docTop;
        if (yOffset < 0) return 0;
        if (yOffset > docHeight) return view.state.doc.length;
        for (let halfLine = view.viewState.heightOracle.textHeight / 2, bounced = !1; (block = view.elementAtHeight(yOffset)).type != BlockType.Text; ) for (;!(0 <= (yOffset = 0 < bias ? block.bottom + halfLine : block.top - halfLine) && yOffset <= docHeight); ) {
            if (bounced) return precise ? null : 0;
            bounced = !0, bias = -bias;
        }
        y = docTop + yOffset;
        docTop = block.from;
        if (docTop < view.viewport.from) return 0 == view.viewport.from ? 0 : precise ? null : posAtCoordsImprecise(view, content, block, x, y);
        if (docTop > view.viewport.to) return view.viewport.to == view.state.doc.length ? view.state.doc.length : precise ? null : posAtCoordsImprecise(view, content, block, x, y);
        var doc = view.dom.ownerDocument, root = view.root.elementFromPoint ? view.root : doc;
        let element = root.elementFromPoint(x, y);
        (element = element && !view.contentDOM.contains(element) ? null : element) || (x = Math.max(content.left + 1, Math.min(content.right - 1, x)), 
        (element = root.elementFromPoint(x, y)) && !view.contentDOM.contains(element) && (element = null));
        let node, offset = -1;
        if (element && 0 != (null == (content = view.docView.nearest(element)) ? void 0 : content.isEditable) && (doc.caretPositionFromPoint ? (root = doc.caretPositionFromPoint(x, y)) && ({
            offsetNode: node,
            offset
        } = root) : doc.caretRangeFromPoint && (content = doc.caretRangeFromPoint(x, y)) && ({
            startContainer: node,
            startOffset: offset
        } = content, !view.contentDOM.contains(node) || browser.safari && function(node, offset, x) {
            let len, scan = node;
            if (3 != node.nodeType || offset != (len = node.nodeValue.length)) return;
            for (;;) {
                var next = scan.nextSibling;
                if (next) {
                    if ("BR" == next.nodeName) break;
                    return;
                }
                next = scan.parentNode;
                if (!next || "DIV" == next.nodeName) break;
                scan = next;
            }
            return textRange(node, len - 1, len).getBoundingClientRect().right > x;
        }(node, offset, x) || browser.chrome && function(node, offset, x) {
            if (0 != offset) return;
            for (let cur = node; ;) {
                var parent = cur.parentNode;
                if (!parent || 1 != parent.nodeType || parent.firstChild != cur) return;
                if (parent.classList.contains("cm-line")) break;
                cur = parent;
            }
            offset = (1 == node.nodeType ? node : textRange(node, 0, Math.max(node.nodeValue.length, 1))).getBoundingClientRect();
            return 5 < x - offset.left;
        }(node, offset, x)) && (node = void 0), node) && (offset = Math.min(maxOffset(node), offset)), 
        !node || !view.docView.dom.contains(node)) {
            root = LineView.find(view.docView, docTop);
            if (!root) return yOffset > block.top + block.height / 2 ? block.to : block.from;
            ({
                node,
                offset
            } = domPosAtCoords(root.dom, x, y));
        }
        doc = view.docView.nearest(node);
        return doc ? doc.isWidget && 1 == (null == (content = doc.dom) ? void 0 : content.nodeType) ? (docTop = doc.dom.getBoundingClientRect(), 
        coords.y < docTop.top || coords.y <= docTop.bottom && coords.x <= (docTop.left + docTop.right) / 2 ? doc.posAtStart : doc.posAtEnd) : doc.localPosFromDOM(node, offset) + doc.posAtStart : null;
    }
    function posAtCoordsImprecise(view, contentRect, block, x, y) {
        let into = Math.round((x - contentRect.left) * view.defaultCharacterWidth);
        view.lineWrapping && block.height > 1.5 * view.defaultLineHeight && (x = view.viewState.heightOracle.textHeight, 
        contentRect = Math.floor((y - block.top - .5 * (view.defaultLineHeight - x)) / x), 
        into += contentRect * view.viewState.heightOracle.lineLength);
        y = view.state.sliceDoc(block.from, block.to);
        return block.from + findColumn(y, into, view.state.tabSize);
    }
    function blockAt(view, pos, side) {
        view = view.lineBlockAt(pos);
        if (Array.isArray(view.type)) {
            let best;
            for (var l of view.type) {
                if (l.from > pos) break;
                if (!(l.to < pos)) {
                    if (l.from < pos && l.to > pos) return l;
                    best && (l.type != BlockType.Text || best.type == l.type && !(side < 0 ? l.from < pos : l.to > pos)) || (best = l);
                }
            }
            return best || view;
        }
        return view;
    }
    function moveByChar(view, start, forward, by) {
        let line = view.state.doc.lineAt(start.head), spans = view.bidiSpans(line);
        var direction = view.textDirectionAt(line.from);
        for (let cur = start, check = null; ;) {
            let next = function(line, order, dir, start, forward) {
                let startIndex = start.head - line.from, spanI = BidiSpan.find(order, startIndex, null != (_a = start.bidiLevel) ? _a : -1, start.assoc), span = order[spanI], spanEnd = span.side(forward, dir);
                if (startIndex == spanEnd) {
                    var _a = spanI += forward ? 1 : -1;
                    if (_a < 0 || _a >= order.length) return null;
                    span = order[spanI = _a], startIndex = span.side(!forward, dir), 
                    spanEnd = span.side(forward, dir);
                }
                let nextIndex = findClusterBreak(line.text, startIndex, span.forward(forward, dir));
                return (nextIndex < span.from || nextIndex > span.to) && (nextIndex = spanEnd), 
                movedOver = line.text.slice(Math.min(startIndex, nextIndex), Math.max(startIndex, nextIndex)), 
                (start = spanI == (forward ? order.length - 1 : 0) ? null : order[spanI + (forward ? 1 : -1)]) && nextIndex == spanEnd && start.level + (forward ? 0 : 1) < span.level ? EditorSelection.cursor(start.side(!forward, dir) + line.from, start.forward(forward, dir) ? 1 : -1, start.level) : EditorSelection.cursor(nextIndex + line.from, span.forward(forward, dir) ? -1 : 1, span.level);
            }(line, spans, direction, cur, forward), char = movedOver;
            if (!next) {
                if (line.number == (forward ? view.state.doc.lines : 1)) return cur;
                char = "\n", line = view.state.doc.line(line.number + (forward ? 1 : -1)), 
                spans = view.bidiSpans(line), next = view.visualLineSide(line, !forward);
            }
            if (check) {
                if (!check(char)) return cur;
            } else {
                if (!by) return next;
                check = by(char);
            }
            cur = next;
        }
    }
    function skipAtomicRanges(atoms, pos, bias) {
        for (;;) {
            let moved = 0;
            for (var set of atoms) set.between(pos - 1, pos + 1, (from, to, value) => {
                var side;
                from < pos && pos < to && (side = moved || bias || (pos - from < to - pos ? -1 : 1), 
                pos = side < 0 ? from : to, moved = side);
            });
            if (!moved) return pos;
        }
    }
    function skipAtoms(view, oldPos, pos) {
        oldPos = skipAtomicRanges(view.state.facet(atomicRanges).map(f => f(view)), pos.from, oldPos.head > pos.from ? -1 : 1);
        return oldPos == pos.from ? pos : EditorSelection.cursor(oldPos, oldPos < pos.from ? 1 : -1);
    }
    class DOMReader {
        constructor(points, state) {
            this.points = points, this.text = "", this.lineSeparator = state.facet(EditorState.lineSeparator);
        }
        append(text) {
            this.text += text;
        }
        lineBreak() {
            this.text += "\uffff";
        }
        readRange(start, end) {
            if (start) {
                var parent = start.parentNode;
                for (let cur = start; ;) {
                    this.findPointBefore(parent, cur);
                    var oldLen = this.text.length, next = (this.readNode(cur), cur.nextSibling);
                    if (next == end) break;
                    var view = ContentView.get(cur), nextView = ContentView.get(next);
                    (view && nextView ? view.breakAfter : (view ? view.breakAfter : isBlockElement(cur)) || isBlockElement(next) && ("BR" != cur.nodeName || cur.cmIgnore) && this.text.length > oldLen) && this.lineBreak(), 
                    cur = next;
                }
                this.findPointBefore(parent, end);
            }
            return this;
        }
        readTextNode(node) {
            var point, text = node.nodeValue;
            for (point of this.points) point.node == node && (point.pos = this.text.length + Math.min(point.offset, text.length));
            for (let off = 0, re = this.lineSeparator ? null : /\r\n?|\n/g; ;) {
                let nextBreak = -1, breakSize = 1, m;
                if (this.lineSeparator ? (nextBreak = text.indexOf(this.lineSeparator, off), 
                breakSize = this.lineSeparator.length) : (m = re.exec(text)) && (nextBreak = m.index, 
                breakSize = m[0].length), this.append(text.slice(off, nextBreak < 0 ? text.length : nextBreak)), 
                nextBreak < 0) break;
                if (this.lineBreak(), 1 < breakSize) for (let point of this.points) point.node == node && point.pos > this.text.length && (point.pos -= breakSize - 1);
                off = nextBreak + breakSize;
            }
        }
        readNode(node) {
            if (!node.cmIgnore) {
                var view = ContentView.get(node), view = view && view.overrideDOMText;
                if (null != view) {
                    this.findPointInside(node, view.length);
                    for (var i = view.iter(); !i.next().done; ) i.lineBreak ? this.lineBreak() : this.append(i.value);
                } else 3 == node.nodeType ? this.readTextNode(node) : "BR" == node.nodeName ? node.nextSibling && this.lineBreak() : 1 == node.nodeType && this.readRange(node.firstChild, null);
            }
        }
        findPointBefore(node, next) {
            for (var point of this.points) point.node == node && node.childNodes[point.offset] == next && (point.pos = this.text.length);
        }
        findPointInside(node, length) {
            for (var point of this.points) (3 == node.nodeType ? point.node == node : node.contains(point.node)) && (point.pos = this.text.length + (function(parent, node, offset) {
                for (;;) {
                    if (!node || offset < maxOffset(node)) return;
                    if (node == parent) return 1;
                    offset = domIndex(node) + 1, node = node.parentNode;
                }
            }(node, point.node, point.offset) ? length : 0));
        }
    }
    class DOMPoint {
        constructor(node, offset) {
            this.node = node, this.offset = offset, this.pos = -1;
        }
    }
    class DOMChange {
        constructor(view, start, end, typeOver) {
            this.typeOver = typeOver, this.bounds = null, this.text = "", this.domChanged = -1 < start;
            var {
                impreciseHead: typeOver,
                impreciseAnchor: iAnchor
            } = view.docView;
            if (view.state.readOnly && -1 < start) this.newSel = null; else if (-1 < start && (this.bounds = view.docView.domBoundsAround(start, end, 0))) {
                start = typeOver || iAnchor ? [] : function(view) {
                    var result = [];
                    var anchorOffset, focusNode, focusOffset;
                    return view.root.activeElement == view.contentDOM && ({
                        anchorNode: view,
                        anchorOffset,
                        focusNode,
                        focusOffset
                    } = view.observer.selectionRange, view) && (result.push(new DOMPoint(view, anchorOffset)), 
                    focusNode == view && focusOffset == anchorOffset || result.push(new DOMPoint(focusNode, focusOffset))), 
                    result;
                }(view), end = new DOMReader(start, view.state);
                end.readRange(this.bounds.startDOM, this.bounds.endDOM), this.text = end.text, 
                this.newSel = function(points, base) {
                    if (0 == points.length) return null;
                    var anchor = points[0].pos, points = 2 == points.length ? points[1].pos : anchor;
                    return -1 < anchor && -1 < points ? EditorSelection.single(anchor + base, points + base) : null;
                }(start, this.bounds.from);
            } else {
                end = view.observer.selectionRange;
                let head = typeOver && typeOver.node == end.focusNode && typeOver.offset == end.focusOffset || !contains(view.contentDOM, end.focusNode) ? view.state.selection.main.head : view.docView.posFromDOM(end.focusNode, end.focusOffset), anchor = iAnchor && iAnchor.node == end.anchorNode && iAnchor.offset == end.anchorOffset || !contains(view.contentDOM, end.anchorNode) ? view.state.selection.main.anchor : view.docView.posFromDOM(end.anchorNode, end.anchorOffset);
                var start = view.viewport;
                (browser.ios || browser.chrome) && view.state.selection.main.empty && head != anchor && (0 < start.from || start.to < view.state.doc.length) && (typeOver = Math.min(head, anchor), 
                iAnchor = Math.max(head, anchor), end = start.from - typeOver, start = start.to - iAnchor, 
                0 != end && 1 != end && 0 != typeOver || 0 != start && -1 != start && iAnchor != view.state.doc.length || (head = 0, 
                anchor = view.state.doc.length)), this.newSel = EditorSelection.single(anchor, head);
            }
        }
    }
    function applyDOMChange(view, domChange) {
        let change, newSel = domChange["newSel"], sel = view.state.selection.main;
        var lastKey = view.inputState.lastKeyTime > Date.now() - 100 ? view.inputState.lastKeyCode : -1;
        if (domChange.bounds) {
            var {
                from,
                to
            } = domChange.bounds;
            let preferredPos = sel.from, preferredSide = null;
            (8 === lastKey || browser.android && domChange.text.length < to - from) && (preferredPos = sel.to, 
            preferredSide = "end");
            to = function(a, b, preferredPos, preferredSide) {
                let minLen = Math.min(a.length, b.length), from = 0;
                for (;from < minLen && a.charCodeAt(from) == b.charCodeAt(from); ) from++;
                if (from == minLen && a.length == b.length) return null;
                let toA = a.length, toB = b.length;
                for (;0 < toA && 0 < toB && a.charCodeAt(toA - 1) == b.charCodeAt(toB - 1); ) toA--, 
                toB--;
                "end" == preferredSide && (preferredSide = Math.max(0, from - Math.min(toA, toB)), 
                preferredPos -= toA + preferredSide - from);
                {
                    var move;
                    toA < from && a.length < b.length ? (move = preferredPos <= from && preferredPos >= toA ? from - preferredPos : 0, 
                    from -= move, toB = from + (toB - toA), toA = from) : toB < from && (preferredSide = preferredPos <= from && preferredPos >= toB ? from - preferredPos : 0, 
                    from -= preferredSide, toA = from + (toA - toB), toB = from);
                }
                return {
                    from: from,
                    toA: toA,
                    toB: toB
                };
            }(view.state.doc.sliceString(from, to, "\uffff"), domChange.text, preferredPos - from, preferredSide);
            to && (browser.chrome && 13 == lastKey && to.toB == to.from + 2 && "\uffff\uffff" == domChange.text.slice(to.from, to.toB) && to.toB--, 
            change = {
                from: from + to.from,
                to: from + to.toA,
                insert: Text.of(domChange.text.slice(to.from, to.toB).split("\uffff"))
            });
        } else newSel && (!view.hasFocus && view.state.facet(editable) || newSel.main.eq(sel)) && (newSel = null);
        if (!change && !newSel) return !1;
        if (!change && domChange.typeOver && !sel.empty && newSel && newSel.main.empty ? change = {
            from: sel.from,
            to: sel.to,
            insert: view.state.doc.slice(sel.from, sel.to)
        } : (browser.mac || browser.android) && change && change.from == change.to && change.from == sel.head - 1 && /^\. ?$/.test(change.insert.toString()) && "off" == view.contentDOM.getAttribute("autocorrect") ? (newSel && 2 == change.insert.length && (newSel = EditorSelection.single(newSel.main.anchor - 1, newSel.main.head - 1)), 
        change = {
            from: change.from,
            to: change.to,
            insert: Text.of([ change.insert.toString().replace(".", " ") ])
        }) : change && change.from >= sel.from && change.to <= sel.to && (change.from != sel.from || change.to != sel.to) && sel.to - sel.from - (change.to - change.from) <= 4 ? change = {
            from: sel.from,
            to: sel.to,
            insert: view.state.doc.slice(sel.from, change.from).append(change.insert).append(view.state.doc.slice(change.to, sel.to))
        } : browser.chrome && change && change.from == change.to && change.from == sel.head && "\n " == change.insert.toString() && view.lineWrapping && (newSel = newSel && EditorSelection.single(newSel.main.anchor - 1, newSel.main.head - 1), 
        change = {
            from: sel.from,
            to: sel.to,
            insert: Text.of([ " " ])
        }), change) return applyDOMChangeInner(view, change, newSel, lastKey);
        if (!newSel || newSel.main.eq(sel)) return !1;
        {
            let scrollIntoView = !1, userEvent = "select";
            return view.inputState.lastSelectionTime > Date.now() - 50 && ("select" == view.inputState.lastSelectionOrigin && (scrollIntoView = !0), 
            userEvent = view.inputState.lastSelectionOrigin), view.dispatch({
                selection: newSel,
                scrollIntoView: scrollIntoView,
                userEvent: userEvent
            }), !0;
        }
    }
    function applyDOMChangeInner(view, change, newSel, lastKey = -1) {
        if (!browser.ios || !view.inputState.flushIOSKey(change)) {
            var sel = view.state.selection.main;
            if (!browser.android || !(change.to == sel.to && (change.from == sel.from || change.from == sel.from - 1 && " " == view.state.sliceDoc(change.from, sel.from)) && 1 == change.insert.length && 2 == change.insert.lines && dispatchKey(view.contentDOM, "Enter", 13) || (change.from == sel.from - 1 && change.to == sel.to && 0 == change.insert.length || 8 == lastKey && change.insert.length < change.to - change.from && change.to > sel.head) && dispatchKey(view.contentDOM, "Backspace", 8) || change.from == sel.from && change.to == sel.to + 1 && 0 == change.insert.length && dispatchKey(view.contentDOM, "Delete", 46))) {
                let text = change.insert.toString();
                0 <= view.inputState.composing && view.inputState.composing++;
                let defaultTr, defaultInsert = () => defaultTr = defaultTr || function(view, change, newSel) {
                    let tr, startState = view.state, sel = startState.selection.main;
                    if (change.from >= sel.from && change.to <= sel.to && change.to - change.from >= (sel.to - sel.from) / 3 && (!newSel || newSel.main.empty && newSel.main.from == change.from + change.insert.length) && view.inputState.composing < 0) {
                        var before = sel.from < change.from ? startState.sliceDoc(sel.from, change.from) : "", after = sel.to > change.to ? startState.sliceDoc(change.to, sel.to) : "";
                        tr = startState.replaceSelection(view.state.toText(before + change.insert.sliceString(0, void 0, view.state.lineBreak) + after));
                    } else {
                        let changes = startState.changes(change), mainSel = newSel && newSel.main.to <= changes.newLength ? newSel.main : void 0;
                        if (1 < startState.selection.ranges.length && 0 <= view.inputState.composing && change.to <= sel.to && change.to >= sel.to - 10) {
                            let replaced = view.state.sliceDoc(change.from, change.to), compositionRange, composition = newSel && findCompositionNode(view, newSel.main.head);
                            compositionRange = composition ? (before = change.insert.length - (change.to - change.from), 
                            {
                                from: composition.from,
                                to: composition.to - before
                            }) : view.state.doc.lineAt(sel.head);
                            let offset = sel.to - change.to, size = sel.to - sel.from;
                            tr = startState.changeByRange(range => {
                                var from, to;
                                return range.from == sel.from && range.to == sel.to ? {
                                    changes: changes,
                                    range: mainSel || range.map(changes)
                                } : (from = (to = range.to - offset) - replaced.length, 
                                range.to - range.from != size || view.state.sliceDoc(from, to) != replaced || range.to >= compositionRange.from && range.from <= compositionRange.to ? {
                                    range: range
                                } : (from = startState.changes({
                                    from: from,
                                    to: to,
                                    insert: change.insert
                                }), to = range.to - sel.to, {
                                    changes: from,
                                    range: mainSel ? EditorSelection.range(Math.max(0, mainSel.anchor + to), Math.max(0, mainSel.head + to)) : range.map(from)
                                }));
                            });
                        } else tr = {
                            changes: changes,
                            selection: mainSel && startState.selection.replaceRange(mainSel)
                        };
                    }
                    let userEvent = "input.type";
                    (view.composing || view.inputState.compositionPendingChange && view.inputState.compositionEndedAt > Date.now() - 50) && (view.inputState.compositionPendingChange = !1, 
                    userEvent += ".compose", view.inputState.compositionFirstChange) && (userEvent += ".start", 
                    view.inputState.compositionFirstChange = !1);
                    return startState.update(tr, {
                        userEvent: userEvent,
                        scrollIntoView: !0
                    });
                }(view, change, newSel);
                view.state.facet(inputHandler).some(h => h(view, change.from, change.to, text, defaultInsert)) || view.dispatch(defaultInsert());
            }
        }
        return !0;
    }
    class InputState {
        setSelectionOrigin(origin) {
            this.lastSelectionOrigin = origin, this.lastSelectionTime = Date.now();
        }
        constructor(view) {
            this.view = view, this.lastKeyCode = 0, this.lastKeyTime = 0, this.lastTouchTime = 0, 
            this.lastFocusTime = 0, this.lastScrollTop = 0, this.lastScrollLeft = 0, 
            this.pendingIOSKey = void 0, this.tabFocusMode = -1, this.lastSelectionOrigin = null, 
            this.lastSelectionTime = 0, this.lastContextMenu = 0, this.scrollHandlers = [], 
            this.handlers = Object.create(null), this.composing = -1, this.compositionFirstChange = null, 
            this.compositionEndedAt = 0, this.compositionPendingKey = !1, this.compositionPendingChange = !1, 
            this.mouseSelection = null, this.draggedContent = null, this.handleEvent = this.handleEvent.bind(this), 
            this.notifiedFocused = view.hasFocus, browser.safari && view.contentDOM.addEventListener("input", () => null), 
            browser.gecko && (view = view.contentDOM.ownerDocument, appliedFirefoxHack.has(view) || (appliedFirefoxHack.add(view), 
            view.addEventListener("copy", () => {}), view.addEventListener("cut", () => {})));
        }
        handleEvent(event) {
            !function(view, event) {
                if (event.bubbles) {
                    if (event.defaultPrevented) return;
                    for (let node = event.target, cView; node != view.contentDOM; node = node.parentNode) if (!node || 11 == node.nodeType || (cView = ContentView.get(node)) && cView.ignoreEvent(event)) return;
                }
                return 1;
            }(this.view, event) || this.ignoreDuringComposition(event) || "keydown" == event.type && this.keydown(event) || (0 != this.view.updateState ? Promise.resolve().then(() => this.runHandlers(event.type, event)) : this.runHandlers(event.type, event));
        }
        runHandlers(type, event) {
            type = this.handlers[type];
            if (type) {
                for (var observer of type.observers) observer(this.view, event);
                for (var handler of type.handlers) {
                    if (event.defaultPrevented) break;
                    if (handler(this.view, event)) {
                        event.preventDefault();
                        break;
                    }
                }
            }
        }
        ensureHandlers(plugins) {
            var type, handlers = computeHandlers(plugins), prev = this.handlers, dom = this.view.contentDOM;
            for (type in handlers) if ("scroll" != type) {
                var passive = !handlers[type].handlers.length;
                let exists = prev[type];
                exists && passive != !exists.handlers.length && (dom.removeEventListener(type, this.handleEvent), 
                exists = null), exists || dom.addEventListener(type, this.handleEvent, {
                    passive: passive
                });
            }
            for (let type in prev) "scroll" == type || handlers[type] || dom.removeEventListener(type, this.handleEvent);
            this.handlers = handlers;
        }
        keydown(event) {
            if (this.lastKeyCode = event.keyCode, this.lastKeyTime = Date.now(), 
            9 == event.keyCode && -1 < this.tabFocusMode && (!this.tabFocusMode || Date.now() <= this.tabFocusMode)) return !0;
            if (0 < this.tabFocusMode && 27 != event.keyCode && modifierCodes.indexOf(event.keyCode) < 0 && (this.tabFocusMode = -1), 
            browser.android && browser.chrome && !event.synthetic && (13 == event.keyCode || 8 == event.keyCode)) return this.view.observer.delayAndroidKey(event.key, event.keyCode), 
            !0;
            let pending;
            return !browser.ios || event.synthetic || event.altKey || event.metaKey || !((pending = PendingKeys.find(key => key.keyCode == event.keyCode)) && !event.ctrlKey || -1 < EmacsyPendingKeys.indexOf(event.key) && event.ctrlKey && !event.shiftKey) ? (229 != event.keyCode && this.view.observer.forceFlush(), 
            !1) : (this.pendingIOSKey = pending || event, setTimeout(() => this.flushIOSKey(), 250), 
            !0);
        }
        flushIOSKey(change) {
            var key = this.pendingIOSKey;
            return !(!key || "Enter" == key.key && change && change.from < change.to && /^\S+$/.test(change.insert.toString())) && (this.pendingIOSKey = void 0, 
            dispatchKey(this.view.contentDOM, key.key, key.keyCode, key instanceof KeyboardEvent ? key : void 0));
        }
        ignoreDuringComposition(event) {
            return !!/^key/.test(event.type) && (0 < this.composing || !!(browser.safari && !browser.ios && this.compositionPendingKey && Date.now() - this.compositionEndedAt < 100) && !(this.compositionPendingKey = !1));
        }
        startMouseSelection(mouseSelection) {
            this.mouseSelection && this.mouseSelection.destroy(), this.mouseSelection = mouseSelection;
        }
        update(update) {
            this.view.observer.update(update), this.mouseSelection && this.mouseSelection.update(update), 
            this.draggedContent && update.docChanged && (this.draggedContent = this.draggedContent.map(update.changes)), 
            update.transactions.length && (this.lastKeyCode = this.lastSelectionTime = 0);
        }
        destroy() {
            this.mouseSelection && this.mouseSelection.destroy();
        }
    }
    function bindHandler(plugin, handler) {
        return (view, event) => {
            try {
                return handler.call(plugin, event, view);
            } catch (e) {
                logException(view.state, e);
            }
        };
    }
    function computeHandlers(plugins) {
        let result = Object.create(null);
        function record(type) {
            return result[type] || (result[type] = {
                observers: [],
                handlers: []
            });
        }
        for (var plugin of plugins) {
            let spec = plugin.spec, handlers = spec && spec.plugin.domEventHandlers, observers = spec && spec.plugin.domEventObservers;
            if (handlers) for (var type in handlers) {
                var f = handlers[type];
                f && record(type).handlers.push(bindHandler(plugin.value, f));
            }
            if (observers) for (let type in observers) {
                let f = observers[type];
                f && record(type).observers.push(bindHandler(plugin.value, f));
            }
        }
        for (let type in handlers) record(type).handlers.push(handlers[type]);
        for (let type in observers) record(type).observers.push(observers[type]);
        return result;
    }
    const PendingKeys = [ {
        key: "Backspace",
        keyCode: 8,
        inputType: "deleteContentBackward"
    }, {
        key: "Enter",
        keyCode: 13,
        inputType: "insertParagraph"
    }, {
        key: "Enter",
        keyCode: 13,
        inputType: "insertLineBreak"
    }, {
        key: "Delete",
        keyCode: 46,
        inputType: "deleteContentForward"
    } ], EmacsyPendingKeys = "dthko", modifierCodes = [ 16, 17, 18, 20, 91, 92, 224, 225 ];
    function dragScrollSpeed(dist) {
        return .7 * Math.max(0, dist) + 8;
    }
    class MouseSelection {
        constructor(view, startEvent, style, mustSelect) {
            this.view = view, this.startEvent = startEvent, this.style = style, 
            this.mustSelect = mustSelect, this.scrollSpeed = {
                x: 0,
                y: 0
            }, this.scrolling = -1, this.lastEvent = startEvent, this.scrollParents = function(dom) {
                let doc = dom.ownerDocument, x, y;
                for (let cur = dom.parentNode; cur && !(cur == doc.body || x && y); ) if (1 == cur.nodeType) !y && cur.scrollHeight > cur.clientHeight && (y = cur), 
                !x && cur.scrollWidth > cur.clientWidth && (x = cur), cur = cur.assignedSlot || cur.parentNode; else {
                    if (11 != cur.nodeType) break;
                    cur = cur.host;
                }
                return {
                    x: x,
                    y: y
                };
            }(view.contentDOM), this.atoms = view.state.facet(atomicRanges).map(f => f(view));
            style = view.contentDOM.ownerDocument;
            style.addEventListener("mousemove", this.move = this.move.bind(this)), 
            style.addEventListener("mouseup", this.up = this.up.bind(this)), this.extend = startEvent.shiftKey, 
            this.multiple = view.state.facet(EditorState.allowMultipleSelections) && function(view, event) {
                view = view.state.facet(clickAddsSelectionRange);
                return view.length ? view[0](event) : browser.mac ? event.metaKey : event.ctrlKey;
            }(view, startEvent), this.dragging = !(!function(view, event) {
                var main = view.state.selection["main"];
                if (!main.empty) {
                    main = getSelection(view.root);
                    if (!main || 0 == main.rangeCount) return 1;
                    var rects = main.getRangeAt(0).getClientRects();
                    for (let i = 0; i < rects.length; i++) {
                        var rect = rects[i];
                        if (rect.left <= event.clientX && rect.right >= event.clientX && rect.top <= event.clientY && rect.bottom >= event.clientY) return 1;
                    }
                }
                return;
            }(view, startEvent) || 1 != getClickType(startEvent)) && null;
        }
        start(event) {
            !1 === this.dragging && this.select(event);
        }
        move(event) {
            if (0 == event.buttons) return this.destroy();
            if (!(this.dragging || null == this.dragging && (a = this.startEvent, 
            b = event, Math.max(Math.abs(a.clientX - b.clientX), Math.abs(a.clientY - b.clientY)) < 10))) {
                var b;
                this.select(this.lastEvent = event);
                let sx = 0, sy = 0, left = 0, top = 0, right = this.view.win.innerWidth, bottom = this.view.win.innerHeight;
                this.scrollParents.x && ({
                    left,
                    right
                } = this.scrollParents.x.getBoundingClientRect()), this.scrollParents.y && ({
                    top,
                    bottom
                } = this.scrollParents.y.getBoundingClientRect());
                var a = getScrollMargins(this.view);
                event.clientX - a.left <= left + 6 ? sx = -dragScrollSpeed(left - event.clientX) : event.clientX + a.right >= right - 6 && (sx = dragScrollSpeed(event.clientX - right)), 
                event.clientY - a.top <= top + 6 ? sy = -dragScrollSpeed(top - event.clientY) : event.clientY + a.bottom >= bottom - 6 && (sy = dragScrollSpeed(event.clientY - bottom)), 
                this.setScrollSpeed(sx, sy);
            }
        }
        up(event) {
            null == this.dragging && this.select(this.lastEvent), this.dragging || event.preventDefault(), 
            this.destroy();
        }
        destroy() {
            this.setScrollSpeed(0, 0);
            var doc = this.view.contentDOM.ownerDocument;
            doc.removeEventListener("mousemove", this.move), doc.removeEventListener("mouseup", this.up), 
            this.view.inputState.mouseSelection = this.view.inputState.draggedContent = null;
        }
        setScrollSpeed(sx, sy) {
            this.scrollSpeed = {
                x: sx,
                y: sy
            }, sx || sy ? this.scrolling < 0 && (this.scrolling = setInterval(() => this.scroll(), 50)) : -1 < this.scrolling && (clearInterval(this.scrolling), 
            this.scrolling = -1);
        }
        scroll() {
            let {
                x,
                y
            } = this.scrollSpeed;
            x && this.scrollParents.x && (this.scrollParents.x.scrollLeft += x, 
            x = 0), y && this.scrollParents.y && (this.scrollParents.y.scrollTop += y, 
            y = 0), (x || y) && this.view.win.scrollBy(x, y), !1 === this.dragging && this.select(this.lastEvent);
        }
        skipAtoms(sel) {
            let ranges = null;
            for (let i = 0; i < sel.ranges.length; i++) {
                let range = sel.ranges[i], updated = null;
                var pos, to;
                range.empty ? (pos = skipAtomicRanges(this.atoms, range.from, 0)) != range.from && (updated = EditorSelection.cursor(pos, -1)) : (pos = skipAtomicRanges(this.atoms, range.from, -1), 
                to = skipAtomicRanges(this.atoms, range.to, 1), pos == range.from && to == range.to || (updated = EditorSelection.range(range.from == range.anchor ? pos : to, range.from == range.head ? pos : to))), 
                updated && ((ranges = ranges || sel.ranges.slice())[i] = updated);
            }
            return ranges ? EditorSelection.create(ranges, sel.mainIndex) : sel;
        }
        select(event) {
            var view = this["view"], event = this.skipAtoms(this.style.get(event, this.extend, this.multiple));
            !this.mustSelect && event.eq(view.state.selection, !1 === this.dragging) || this.view.dispatch({
                selection: event,
                userEvent: "select.pointer"
            }), this.mustSelect = !1;
        }
        update(update) {
            update.transactions.some(tr => tr.isUserEvent("input.type")) ? this.destroy() : this.style.update(update) && setTimeout(() => this.select(this.lastEvent), 20);
        }
    }
    const handlers = Object.create(null), observers = Object.create(null), brokenClipboardAPI = browser.ie && browser.ie_version < 15 || browser.ios && browser.webkit_version < 604;
    function textFilter(state, facet, text) {
        for (var filter of state.facet(facet)) text = filter(text, state);
        return text;
    }
    function doPaste(view, input) {
        input = textFilter(view.state, clipboardInputFilter, input);
        let state = view["state"], changes, i = 1, text = state.toText(input), byLine = text.lines == state.selection.ranges.length;
        if (null != lastLinewiseCopy && state.selection.ranges.every(r => r.empty) && lastLinewiseCopy == text.toString()) {
            let lastLine = -1;
            changes = state.changeByRange(range => {
                var line = state.doc.lineAt(range.from);
                if (line.from == lastLine) return {
                    range: range
                };
                lastLine = line.from;
                var insert = state.toText((byLine ? text.line(i++).text : input) + state.lineBreak);
                return {
                    changes: {
                        from: line.from,
                        insert: insert
                    },
                    range: EditorSelection.cursor(range.from + insert.length)
                };
            });
        } else changes = byLine ? state.changeByRange(range => {
            var line = text.line(i++);
            return {
                changes: {
                    from: range.from,
                    to: range.to,
                    insert: line.text
                },
                range: EditorSelection.cursor(range.from + line.length)
            };
        }) : state.replaceSelection(text);
        view.dispatch(changes, {
            userEvent: "input.paste",
            scrollIntoView: !0
        });
    }
    function rangeForClick(view, pos, bias, type) {
        if (1 == type) return EditorSelection.cursor(pos, bias);
        if (2 == type) return function(state, pos, bias = 1) {
            var categorize = state.charCategorizer(pos), line = state.doc.lineAt(pos), state = pos - line.from;
            if (0 == line.length) return EditorSelection.cursor(pos);
            0 == state ? bias = 1 : state == line.length && (bias = -1);
            let from = state, to = state;
            bias < 0 ? from = findClusterBreak(line.text, state, !1) : to = findClusterBreak(line.text, state);
            for (var cat = categorize(line.text.slice(from, to)); 0 < from; ) {
                var prev = findClusterBreak(line.text, from, !1);
                if (categorize(line.text.slice(prev, from)) != cat) break;
                from = prev;
            }
            for (;to < line.length; ) {
                var next = findClusterBreak(line.text, to);
                if (categorize(line.text.slice(to, next)) != cat) break;
                to = next;
            }
            return EditorSelection.range(from + line.from, to + line.from);
        }(view.state, pos, bias);
        {
            type = LineView.find(view.docView, pos), bias = view.state.doc.lineAt(type ? type.posAtEnd : pos);
            let from = type ? type.posAtStart : bias.from, to = type ? type.posAtEnd : bias.to;
            return to < view.state.doc.length && to == bias.to && to++, EditorSelection.range(from, to);
        }
    }
    observers.scroll = view => {
        view.inputState.lastScrollTop = view.scrollDOM.scrollTop, view.inputState.lastScrollLeft = view.scrollDOM.scrollLeft;
    }, handlers.keydown = (view, event) => (view.inputState.setSelectionOrigin("select"), 
    27 == event.keyCode && 0 != view.inputState.tabFocusMode && (view.inputState.tabFocusMode = Date.now() + 2e3), 
    !1), observers.touchstart = (view, e) => {
        view.inputState.lastTouchTime = Date.now(), view.inputState.setSelectionOrigin("select.pointer");
    }, observers.touchmove = view => {
        view.inputState.setSelectionOrigin("select.pointer");
    }, handlers.mousedown = (view, event) => {
        if (view.observer.flush(), !(view.inputState.lastTouchTime > Date.now() - 2e3)) {
            let style = null;
            for (var makeStyle of view.state.facet(mouseSelectionStyle)) if (style = makeStyle(view, event)) break;
            if (style = style || 0 != event.button ? style : function(view, event) {
                let start = queryPos(view, event), type = getClickType(event), startSel = view.state.selection;
                return {
                    update(update) {
                        update.docChanged && (start.pos = update.changes.mapPos(start.pos), 
                        startSel = startSel.map(update.changes));
                    },
                    get(event, extend, multiple) {
                        let cur = queryPos(view, event), removed, range = rangeForClick(view, cur.pos, cur.bias, type);
                        var from;
                        return start.pos == cur.pos || extend || (event = rangeForClick(view, start.pos, start.bias, type), 
                        from = Math.min(event.from, range.from), event = Math.max(event.to, range.to), 
                        range = from < range.from ? EditorSelection.range(from, event) : EditorSelection.range(event, from)), 
                        extend ? startSel.replaceRange(startSel.main.extend(range.from, range.to)) : multiple && 1 == type && 1 < startSel.ranges.length && (removed = function(sel, pos) {
                            for (let i = 0; i < sel.ranges.length; i++) {
                                var {
                                    from,
                                    to
                                } = sel.ranges[i];
                                if (from <= pos && pos <= to) return EditorSelection.create(sel.ranges.slice(0, i).concat(sel.ranges.slice(i + 1)), sel.mainIndex == i ? 0 : sel.mainIndex - (sel.mainIndex > i ? 1 : 0));
                            }
                            return null;
                        }(startSel, cur.pos)) ? removed : multiple ? startSel.addRange(range) : EditorSelection.create([ range ]);
                    }
                };
            }(view, event)) {
                var mustFocus = !view.hasFocus, mustFocus = (view.inputState.startMouseSelection(new MouseSelection(view, event, style, mustFocus)), 
                mustFocus && view.observer.ignore(() => {
                    focusPreventScroll(view.contentDOM);
                    var active = view.root.activeElement;
                    active && !active.contains(view.contentDOM) && active.blur();
                }), view.inputState.mouseSelection);
                if (mustFocus) return mustFocus.start(event), !1 === mustFocus.dragging;
            }
        }
        return !1;
    };
    let inside = (x, y, rect) => y >= rect.top && y <= rect.bottom && x >= rect.left && x <= rect.right;
    function queryPos(view, event) {
        var pos = view.posAtCoords({
            x: event.clientX,
            y: event.clientY
        }, !1);
        return {
            pos: pos,
            bias: function(view, pos, x, y) {
                var before;
                return (view = LineView.find(view.docView, pos)) && 0 != (pos = pos - view.posAtStart) && (pos == view.length || (before = view.coordsAt(pos, -1)) && inside(x, y, before) || (!(view = view.coordsAt(pos, 1)) || !inside(x, y, view)) && before && before.bottom >= y) ? -1 : 1;
            }(view, pos, event.clientX, event.clientY)
        };
    }
    const BadMouseDetail = browser.ie && browser.ie_version <= 11;
    let lastMouseDown = null, lastMouseDownCount = 0, lastMouseDownTime = 0;
    function getClickType(event) {
        var last, lastTime;
        return BadMouseDetail ? (last = lastMouseDown, lastTime = lastMouseDownTime, 
        lastMouseDown = event, lastMouseDownTime = Date.now(), lastMouseDownCount = !last || lastTime > Date.now() - 400 && Math.abs(last.clientX - event.clientX) < 2 && Math.abs(last.clientY - event.clientY) < 2 ? (lastMouseDownCount + 1) % 3 : 1) : event.detail;
    }
    function dropText(view, event, text, direct) {
        var dropPos, draggedContent;
        (text = textFilter(view.state, clipboardInputFilter, text)) && (dropPos = view.posAtCoords({
            x: event.clientX,
            y: event.clientY
        }, !1), draggedContent = view.inputState["draggedContent"], direct = direct && draggedContent && function(view, event) {
            return (view = view.state.facet(dragMovesSelection$1)).length ? view[0](event) : browser.mac ? !event.altKey : !event.ctrlKey;
        }(view, event) ? {
            from: draggedContent.from,
            to: draggedContent.to
        } : null, event = {
            from: dropPos,
            insert: text
        }, draggedContent = view.state.changes(direct ? [ direct, event ] : event), 
        view.focus(), view.dispatch({
            changes: draggedContent,
            selection: {
                anchor: draggedContent.mapPos(dropPos, -1),
                head: draggedContent.mapPos(dropPos, 1)
            },
            userEvent: direct ? "move.drop" : "input.drop"
        }), view.inputState.draggedContent = null);
    }
    handlers.dragstart = (view, event) => {
        let range = view.state["selection"]["main"];
        var cView, from = (event.target.draggable && (cView = view.docView.nearest(event.target)) && cView.isWidget && (cView = (from = cView.posAtStart) + cView.length, 
        from >= range.to || cView <= range.from) && (range = EditorSelection.range(from, cView)), 
        view)["inputState"];
        return from.mouseSelection && (from.mouseSelection.dragging = !0), from.draggedContent = range, 
        event.dataTransfer && (event.dataTransfer.setData("Text", textFilter(view.state, clipboardOutputFilter, view.state.sliceDoc(range.from, range.to))), 
        event.dataTransfer.effectAllowed = "copyMove"), !1;
    }, handlers.dragend = view => (view.inputState.draggedContent = null, !1), handlers.drop = (view, event) => {
        if (!event.dataTransfer) return !1;
        if (view.state.readOnly) return !0;
        let files = event.dataTransfer.files;
        if (files && files.length) {
            let text = Array(files.length), read = 0, finishFile = () => {
                ++read == files.length && dropText(view, event, text.filter(s => null != s).join(view.state.lineBreak), !1);
            };
            for (let i = 0; i < files.length; i++) {
                let reader = new FileReader();
                reader.onerror = finishFile, reader.onload = () => {
                    /[\x00-\x08\x0e-\x1f]{2}/.test(reader.result) || (text[i] = reader.result), 
                    finishFile();
                }, reader.readAsText(files[i]);
            }
            return !0;
        }
        var text = event.dataTransfer.getData("Text");
        return !!text && (dropText(view, event, text, !0), !0);
    }, handlers.paste = (view, event) => {
        if (view.state.readOnly) return !0;
        view.observer.flush();
        event = brokenClipboardAPI ? null : event.clipboardData;
        return event ? (doPaste(view, event.getData("text/plain") || event.getData("text/uri-list")), 
        !0) : (function(view) {
            var parent = view.dom.parentNode;
            if (parent) {
                let target = parent.appendChild(document.createElement("textarea"));
                target.style.cssText = "position: fixed; left: -10000px; top: 10px", 
                target.focus(), setTimeout(() => {
                    view.focus(), target.remove(), doPaste(view, target.value);
                }, 50);
            }
        }(view), !1);
    };
    let lastLinewiseCopy = null;
    handlers.copy = handlers.cut = (view, event) => {
        var {
            text,
            ranges,
            linewise
        } = function(state) {
            let content = [], ranges = [], linewise = !1;
            for (var range of state.selection.ranges) range.empty || (content.push(state.sliceDoc(range.from, range.to)), 
            ranges.push(range));
            if (!content.length) {
                let upto = -1;
                for (var {
                    from
                } of state.selection.ranges) {
                    from = state.doc.lineAt(from);
                    from.number > upto && (content.push(from.text), ranges.push({
                        from: from.from,
                        to: Math.min(state.doc.length, from.to + 1)
                    })), upto = from.number;
                }
                linewise = !0;
            }
            return {
                text: textFilter(state, clipboardOutputFilter, content.join(state.lineBreak)),
                ranges: ranges,
                linewise: linewise
            };
        }(view.state);
        if (!text && !linewise) return !1;
        lastLinewiseCopy = linewise ? text : null, "cut" != event.type || view.state.readOnly || view.dispatch({
            changes: ranges,
            scrollIntoView: !0,
            userEvent: "delete.cut"
        });
        linewise = brokenClipboardAPI ? null : event.clipboardData;
        return linewise ? (linewise.clearData(), linewise.setData("text/plain", text), 
        !0) : (function(view, text) {
            var parent = view.dom.parentNode;
            if (parent) {
                let target = parent.appendChild(document.createElement("textarea"));
                target.style.cssText = "position: fixed; left: -10000px; top: 10px", 
                target.value = text, target.focus(), target.selectionEnd = text.length, 
                target.selectionStart = 0, setTimeout(() => {
                    target.remove(), view.focus();
                }, 50);
            }
        }(view, text), !1);
    };
    const isFocusChange = Annotation.define();
    function focusChangeTransaction(state, focus) {
        var getEffect, effects = [];
        for (getEffect of state.facet(focusChangeEffect)) {
            var effect = getEffect(state, focus);
            effect && effects.push(effect);
        }
        return effects.length ? state.update({
            effects: effects,
            annotations: isFocusChange.of(!0)
        }) : null;
    }
    function updateForFocusChange(view) {
        setTimeout(() => {
            var focus = view.hasFocus;
            focus != view.inputState.notifiedFocused && ((focus = focusChangeTransaction(view.state, focus)) ? view.dispatch(focus) : view.update([]));
        }, 10);
    }
    observers.focus = view => {
        view.inputState.lastFocusTime = Date.now(), view.scrollDOM.scrollTop || !view.inputState.lastScrollTop && !view.inputState.lastScrollLeft || (view.scrollDOM.scrollTop = view.inputState.lastScrollTop, 
        view.scrollDOM.scrollLeft = view.inputState.lastScrollLeft), updateForFocusChange(view);
    }, observers.blur = view => {
        view.observer.clearSelectionRange(), updateForFocusChange(view);
    }, observers.compositionstart = observers.compositionupdate = view => {
        view.observer.editContext || (null == view.inputState.compositionFirstChange && (view.inputState.compositionFirstChange = !0), 
        view.inputState.composing < 0 && (view.inputState.composing = 0));
    }, observers.compositionend = view => {
        view.observer.editContext || (view.inputState.composing = -1, view.inputState.compositionEndedAt = Date.now(), 
        view.inputState.compositionPendingKey = !0, view.inputState.compositionPendingChange = 0 < view.observer.pendingRecords().length, 
        view.inputState.compositionFirstChange = null, browser.chrome && browser.android ? view.observer.flushSoon() : view.inputState.compositionPendingChange ? Promise.resolve().then(() => view.observer.flush()) : setTimeout(() => {
            view.inputState.composing < 0 && view.docView.hasComposition && view.update([]);
        }, 50));
    }, observers.contextmenu = view => {
        view.inputState.lastContextMenu = Date.now();
    }, handlers.beforeinput = (view, event) => {
        if ("insertReplacementText" == event.inputType && view.observer.editContext) {
            var from, _a = null == (_a = event.dataTransfer) ? void 0 : _a.getData("text/plain"), ranges = event.getTargetRanges();
            if (_a && ranges.length) return ranges = ranges[0], from = view.posAtDOM(ranges.startContainer, ranges.startOffset), 
            ranges = view.posAtDOM(ranges.endContainer, ranges.endOffset), applyDOMChangeInner(view, {
                from: from,
                to: ranges,
                insert: view.state.toText(_a)
            }, null), !0;
        }
        let pending;
        if (browser.chrome && browser.android && (pending = PendingKeys.find(key => key.inputType == event.inputType)) && (view.observer.delayAndroidKey(pending.key, pending.keyCode), 
        "Backspace" == pending.key || "Delete" == pending.key)) {
            let startViewHeight = (null == (from = window.visualViewport) ? void 0 : from.height) || 0;
            setTimeout(() => {
                var _a;
                ((null == (_a = window.visualViewport) ? void 0 : _a.height) || 0) > startViewHeight + 10 && view.hasFocus && (view.contentDOM.blur(), 
                view.focus());
            }, 100);
        }
        return browser.ios && "deleteContentForward" == event.inputType && view.observer.flushSoon(), 
        browser.safari && "insertText" == event.inputType && 0 <= view.inputState.composing && setTimeout(() => observers.compositionend(view, event), 20), 
        !1;
    };
    const appliedFirefoxHack = new Set();
    const wrappingWhiteSpace = [ "pre-wrap", "normal", "pre-line", "break-spaces" ];
    let heightChangeFlag = !1;
    function clearHeightChangeFlag() {
        heightChangeFlag = !1;
    }
    class HeightOracle {
        constructor(lineWrapping) {
            this.lineWrapping = lineWrapping, this.doc = Text.empty, this.heightSamples = {}, 
            this.lineHeight = 14, this.charWidth = 7, this.textHeight = 14, this.lineLength = 30;
        }
        heightForGap(from, to) {
            let lines = this.doc.lineAt(to).number - this.doc.lineAt(from).number + 1;
            return this.lineWrapping && (lines += Math.max(0, Math.ceil((to - from - lines * this.lineLength * .5) / this.lineLength))), 
            this.lineHeight * lines;
        }
        heightForLine(length) {
            return this.lineWrapping ? (1 + Math.max(0, Math.ceil((length - this.lineLength) / Math.max(1, this.lineLength - 5)))) * this.lineHeight : this.lineHeight;
        }
        setDoc(doc) {
            return this.doc = doc, this;
        }
        mustRefreshForWrapping(whiteSpace) {
            return -1 < wrappingWhiteSpace.indexOf(whiteSpace) != this.lineWrapping;
        }
        mustRefreshForHeights(lineHeights) {
            let newHeight = !1;
            for (let i = 0; i < lineHeights.length; i++) {
                var h = lineHeights[i];
                h < 0 ? i++ : this.heightSamples[Math.floor(10 * h)] || (newHeight = !0, 
                this.heightSamples[Math.floor(10 * h)] = !0);
            }
            return newHeight;
        }
        refresh(whiteSpace, lineHeight, charWidth, textHeight, lineLength, knownHeights) {
            var whiteSpace = -1 < wrappingWhiteSpace.indexOf(whiteSpace), changed = Math.round(lineHeight) != Math.round(this.lineHeight) || this.lineWrapping != whiteSpace;
            if (this.lineWrapping = whiteSpace, this.lineHeight = lineHeight, this.charWidth = charWidth, 
            this.textHeight = textHeight, this.lineLength = lineLength, changed) {
                this.heightSamples = {};
                for (let i = 0; i < knownHeights.length; i++) {
                    var h = knownHeights[i];
                    h < 0 ? i++ : this.heightSamples[Math.floor(10 * h)] = !0;
                }
            }
            return changed;
        }
    }
    class MeasuredHeights {
        constructor(from, heights) {
            this.from = from, this.heights = heights, this.index = 0;
        }
        get more() {
            return this.index < this.heights.length;
        }
    }
    class BlockInfo {
        constructor(from, length, top, height, _content) {
            this.from = from, this.length = length, this.top = top, this.height = height, 
            this._content = _content;
        }
        get type() {
            return "number" == typeof this._content ? BlockType.Text : Array.isArray(this._content) ? this._content : this._content.type;
        }
        get to() {
            return this.from + this.length;
        }
        get bottom() {
            return this.top + this.height;
        }
        get widget() {
            return this._content instanceof PointDecoration ? this._content.widget : null;
        }
        get widgetLineBreaks() {
            return "number" == typeof this._content ? this._content : 0;
        }
        join(other) {
            var content = (Array.isArray(this._content) ? this._content : [ this ]).concat(Array.isArray(other._content) ? other._content : [ other ]);
            return new BlockInfo(this.from, this.length + other.length, this.top, this.height + other.height, content);
        }
    }
    var QueryType$1 = function(QueryType) {
        return QueryType[QueryType.ByPos = 0] = "ByPos", QueryType[QueryType.ByHeight = 1] = "ByHeight", 
        QueryType[QueryType.ByPosNoHeight = 2] = "ByPosNoHeight", QueryType;
    }(QueryType$1 = QueryType$1 || {});
    class HeightMap {
        constructor(length, height, flags = 2) {
            this.length = length, this.height = height, this.flags = flags;
        }
        get outdated() {
            return 0 < (2 & this.flags);
        }
        set outdated(value) {
            this.flags = (value ? 2 : 0) | -3 & this.flags;
        }
        setHeight(height) {
            this.height != height && (.001 < Math.abs(this.height - height) && (heightChangeFlag = !0), 
            this.height = height);
        }
        replace(_from, _to, nodes) {
            return HeightMap.of(nodes);
        }
        decomposeLeft(_to, result) {
            result.push(this);
        }
        decomposeRight(_from, result) {
            result.push(this);
        }
        applyChanges(decorations, oldDoc, oracle, changes) {
            let me = this, doc = oracle.doc;
            for (let i = changes.length - 1; 0 <= i; i--) {
                let {
                    fromA,
                    toA,
                    fromB,
                    toB
                } = changes[i], start = me.lineAt(fromA, QueryType$1.ByPosNoHeight, oracle.setDoc(oldDoc), 0, 0);
                var end = start.to >= toA ? start : me.lineAt(toA, QueryType$1.ByPosNoHeight, oracle, 0, 0);
                for (toB += end.to - toA, toA = end.to; 0 < i && start.from <= changes[i - 1].toA; ) fromA = changes[i - 1].fromA, 
                fromB = changes[i - 1].fromB, i--, fromA < start.from && (start = me.lineAt(fromA, QueryType$1.ByPosNoHeight, oracle, 0, 0));
                fromB += start.from - fromA, fromA = start.from;
                end = NodeBuilder.build(oracle.setDoc(doc), decorations, fromB, toB);
                me = replace(me, me.replace(fromA, toA, end));
            }
            return me.updateHeight(oracle, 0);
        }
        static empty() {
            return new HeightMapText(0, 0);
        }
        static of(nodes) {
            if (1 == nodes.length) return nodes[0];
            let i = 0, j = nodes.length, before = 0, after = 0;
            for (;;) if (i == j) if (before > 2 * after) {
                var split = nodes[i - 1];
                split.break ? nodes.splice(--i, 1, split.left, null, split.right) : nodes.splice(--i, 1, split.left, split.right), 
                j += 1 + split.break, before -= split.size;
            } else {
                if (!(after > 2 * before)) break;
                {
                    let split = nodes[j];
                    split.break ? nodes.splice(j, 1, split.left, null, split.right) : nodes.splice(j, 1, split.left, split.right), 
                    j += 2 + split.break, after -= split.size;
                }
            } else if (before < after) {
                split = nodes[i++];
                split && (before += split.size);
            } else {
                let next = nodes[--j];
                next && (after += next.size);
            }
            let brk = 0;
            return null == nodes[i - 1] ? (brk = 1, i--) : null == nodes[i] && (brk = 1, 
            j++), new HeightMapBranch(HeightMap.of(nodes.slice(0, i)), brk, HeightMap.of(nodes.slice(j)));
        }
    }
    function replace(old, val) {
        return old == val ? old : (old.constructor != val.constructor && (heightChangeFlag = !0), 
        val);
    }
    HeightMap.prototype.size = 1;
    class HeightMapBlock extends HeightMap {
        constructor(length, height, deco) {
            super(length, height), this.deco = deco;
        }
        blockAt(_height, _oracle, top, offset) {
            return new BlockInfo(offset, this.length, top, this.height, this.deco || 0);
        }
        lineAt(_value, _type, oracle, top, offset) {
            return this.blockAt(0, oracle, top, offset);
        }
        forEachLine(from, to, oracle, top, offset, f) {
            from <= offset + this.length && offset <= to && f(this.blockAt(0, oracle, top, offset));
        }
        updateHeight(oracle, offset = 0, _force, measured) {
            return measured && measured.from <= offset && measured.more && this.setHeight(measured.heights[measured.index++]), 
            this.outdated = !1, this;
        }
        toString() {
            return `block(${this.length})`;
        }
    }
    class HeightMapText extends HeightMapBlock {
        constructor(length, height) {
            super(length, height, null), this.collapsed = 0, this.widgetHeight = 0, 
            this.breaks = 0;
        }
        blockAt(_height, _oracle, top, offset) {
            return new BlockInfo(offset, this.length, top, this.height, this.breaks);
        }
        replace(_from, _to, nodes) {
            let node = nodes[0];
            return 1 == nodes.length && (node instanceof HeightMapText || node instanceof HeightMapGap && 4 & node.flags) && Math.abs(this.length - node.length) < 10 ? (node instanceof HeightMapGap ? node = new HeightMapText(node.length, this.height) : node.height = this.height, 
            this.outdated || (node.outdated = !1), node) : HeightMap.of(nodes);
        }
        updateHeight(oracle, offset = 0, force = !1, measured) {
            return measured && measured.from <= offset && measured.more ? this.setHeight(measured.heights[measured.index++]) : (force || this.outdated) && this.setHeight(Math.max(this.widgetHeight, oracle.heightForLine(this.length - this.collapsed)) + this.breaks * oracle.lineHeight), 
            this.outdated = !1, this;
        }
        toString() {
            return `line(${this.length}${this.collapsed ? -this.collapsed : ""}${this.widgetHeight ? ":" + this.widgetHeight : ""})`;
        }
    }
    class HeightMapGap extends HeightMap {
        constructor(length) {
            super(length, 0);
        }
        heightMetrics(oracle, offset) {
            var firstLine = oracle.doc.lineAt(offset).number, offset = oracle.doc.lineAt(offset + this.length).number, lines = offset - firstLine + 1;
            let perLine, perChar = 0;
            return oracle.lineWrapping ? (oracle = Math.min(this.height, oracle.lineHeight * lines), 
            perLine = oracle / lines, this.length > 1 + lines && (perChar = (this.height - oracle) / (this.length - lines - 1))) : perLine = this.height / lines, 
            {
                firstLine: firstLine,
                lastLine: offset,
                perLine: perLine,
                perChar: perChar
            };
        }
        blockAt(height, oracle, top, offset) {
            var {
                firstLine,
                lastLine,
                perLine,
                perChar
            } = this.heightMetrics(oracle, offset);
            if (oracle.lineWrapping) return offset = offset + (height < oracle.lineHeight ? 0 : Math.round(Math.max(0, Math.min(1, (height - top) / this.height)) * this.length)), 
            perChar = perLine + (offset = oracle.doc.lineAt(offset)).length * perChar, 
            lineTop = Math.max(top, height - perChar / 2), new BlockInfo(offset.from, offset.length, lineTop, perChar, 0);
            {
                let line = Math.max(0, Math.min(lastLine - firstLine, Math.floor((height - top) / perLine)));
                var {
                    from: offset,
                    length: lineTop
                } = oracle.doc.line(firstLine + line);
                return new BlockInfo(offset, lineTop, top + perLine * line, perLine, 0);
            }
        }
        lineAt(value, type, oracle, top, offset) {
            var perChar, to;
            return type == QueryType$1.ByHeight ? this.blockAt(value, oracle, top, offset) : type == QueryType$1.ByPosNoHeight ? ({
                from: type,
                to
            } = oracle.doc.lineAt(value), new BlockInfo(type, to - type, 0, 0, 0)) : ({
                firstLine: to,
                perLine: type,
                perChar
            } = this.heightMetrics(oracle, offset), value = type + (oracle = oracle.doc.lineAt(value)).length * perChar, 
            to = top + type * (type = oracle.number - to) + perChar * (oracle.from - offset - type), 
            new BlockInfo(oracle.from, oracle.length, Math.max(top, Math.min(to, top + this.height - value)), value, 0));
        }
        forEachLine(from, to, oracle, top, offset, f) {
            from = Math.max(from, offset), to = Math.min(to, offset + this.length);
            var {
                firstLine,
                perLine,
                perChar
            } = this.heightMetrics(oracle, offset);
            for (let pos = from, lineTop = top; pos <= to; ) {
                var line = oracle.doc.lineAt(pos), linesAbove = (pos == from && (linesAbove = line.number - firstLine, 
                lineTop += perLine * linesAbove + perChar * (from - offset - linesAbove)), 
                perLine + perChar * line.length);
                f(new BlockInfo(line.from, line.length, lineTop, linesAbove, 0)), 
                lineTop += linesAbove, pos = line.to + 1;
            }
        }
        replace(from, to, nodes) {
            var last, to = this.length - to;
            return 0 < to && ((last = nodes[nodes.length - 1]) instanceof HeightMapGap ? nodes[nodes.length - 1] = new HeightMapGap(last.length + to) : nodes.push(null, new HeightMapGap(to - 1))), 
            0 < from && ((last = nodes[0]) instanceof HeightMapGap ? nodes[0] = new HeightMapGap(from + last.length) : nodes.unshift(new HeightMapGap(from - 1), null)), 
            HeightMap.of(nodes);
        }
        decomposeLeft(to, result) {
            result.push(new HeightMapGap(to - 1), null);
        }
        decomposeRight(from, result) {
            result.push(null, new HeightMapGap(this.length - from - 1));
        }
        updateHeight(oracle, offset = 0, force = !1, measured) {
            var end = offset + this.length;
            if (measured && measured.from <= offset + this.length && measured.more) {
                let nodes = [], pos = Math.max(offset, measured.from), singleHeight = -1;
                for (measured.from > offset && nodes.push(new HeightMapGap(measured.from - offset - 1).updateHeight(oracle, offset)); pos <= end && measured.more; ) {
                    var len = oracle.doc.lineAt(pos).length, height = (nodes.length && nodes.push(null), 
                    measured.heights[measured.index++]), height = (-1 == singleHeight ? singleHeight = height : .001 <= Math.abs(height - singleHeight) && (singleHeight = -2), 
                    new HeightMapText(len, height));
                    height.outdated = !1, nodes.push(height), pos += len + 1;
                }
                pos <= end && nodes.push(null, new HeightMapGap(end - pos).updateHeight(oracle, pos));
                var result = HeightMap.of(nodes);
                return (singleHeight < 0 || .001 <= Math.abs(result.height - this.height) || .001 <= Math.abs(singleHeight - this.heightMetrics(oracle, offset).perLine)) && (heightChangeFlag = !0), 
                replace(this, result);
            }
            return (force || this.outdated) && (this.setHeight(oracle.heightForGap(offset, offset + this.length)), 
            this.outdated = !1), this;
        }
        toString() {
            return `gap(${this.length})`;
        }
    }
    class HeightMapBranch extends HeightMap {
        constructor(left, brk, right) {
            super(left.length + brk + right.length, left.height + right.height, brk | (left.outdated || right.outdated ? 2 : 0)), 
            this.left = left, this.right = right, this.size = left.size + right.size;
        }
        get break() {
            return 1 & this.flags;
        }
        blockAt(height, oracle, top, offset) {
            var mid = top + this.left.height;
            return height < mid ? this.left.blockAt(height, oracle, top, offset) : this.right.blockAt(height, oracle, mid, offset + this.left.length + this.break);
        }
        lineAt(value, type, oracle, top, offset) {
            var rightTop = top + this.left.height, rightOffset = offset + this.left.length + this.break, left = type == QueryType$1.ByHeight ? value < rightTop : value < rightOffset, value = left ? this.left.lineAt(value, type, oracle, top, offset) : this.right.lineAt(value, type, oracle, rightTop, rightOffset);
            return this.break || (left ? value.to < rightOffset : value.from > rightOffset) ? value : (type = type == QueryType$1.ByPosNoHeight ? QueryType$1.ByPosNoHeight : QueryType$1.ByPos, 
            left ? value.join(this.right.lineAt(rightOffset, type, oracle, rightTop, rightOffset)) : this.left.lineAt(rightOffset, type, oracle, top, offset).join(value));
        }
        forEachLine(from, to, oracle, top, offset, f) {
            var mid, rightTop = top + this.left.height, rightOffset = offset + this.left.length + this.break;
            this.break ? (from < rightOffset && this.left.forEachLine(from, to, oracle, top, offset, f), 
            rightOffset <= to && this.right.forEachLine(from, to, oracle, rightTop, rightOffset, f)) : (from < (mid = this.lineAt(rightOffset, QueryType$1.ByPos, oracle, top, offset)).from && this.left.forEachLine(from, mid.from - 1, oracle, top, offset, f), 
            mid.to >= from && mid.from <= to && f(mid), to > mid.to && this.right.forEachLine(mid.to + 1, to, oracle, rightTop, rightOffset, f));
        }
        replace(from, to, nodes) {
            var rightStart = this.left.length + this.break;
            if (to < rightStart) return this.balanced(this.left.replace(from, to, nodes), this.right);
            if (from > this.left.length) return this.balanced(this.left, this.right.replace(from - rightStart, to - rightStart, nodes));
            var node, result = [], rightStart = (0 < from && this.decomposeLeft(from, result), 
            result.length);
            for (node of nodes) result.push(node);
            return 0 < from && mergeGaps(result, rightStart - 1), to < this.length && (nodes = result.length, 
            this.decomposeRight(to, result), mergeGaps(result, nodes)), HeightMap.of(result);
        }
        decomposeLeft(to, result) {
            let left = this.left.length;
            if (to <= left) return this.left.decomposeLeft(to, result);
            result.push(this.left), this.break && to >= ++left && result.push(null), 
            to > left && this.right.decomposeLeft(to - left, result);
        }
        decomposeRight(from, result) {
            var left = this.left.length, right = left + this.break;
            if (right <= from) return this.right.decomposeRight(from - right, result);
            from < left && this.left.decomposeRight(from, result), this.break && from < right && result.push(null), 
            result.push(this.right);
        }
        balanced(left, right) {
            return left.size > 2 * right.size || right.size > 2 * left.size ? HeightMap.of(this.break ? [ left, null, right ] : [ left, right ]) : (this.left = replace(this.left, left), 
            this.right = replace(this.right, right), this.setHeight(left.height + right.height), 
            this.outdated = left.outdated || right.outdated, this.size = left.size + right.size, 
            this.length = left.length + this.break + right.length, this);
        }
        updateHeight(oracle, offset = 0, force = !1, measured) {
            let {
                left,
                right
            } = this, rightStart = offset + left.length + this.break, rebalance = null;
            return measured && measured.from <= offset + left.length && measured.more ? rebalance = left = left.updateHeight(oracle, offset, force, measured) : left.updateHeight(oracle, offset, force), 
            measured && measured.from <= rightStart + right.length && measured.more ? rebalance = right = right.updateHeight(oracle, rightStart, force, measured) : right.updateHeight(oracle, rightStart, force), 
            rebalance ? this.balanced(left, right) : (this.height = this.left.height + this.right.height, 
            this.outdated = !1, this);
        }
        toString() {
            return this.left + (this.break ? " " : "-") + this.right;
        }
    }
    function mergeGaps(nodes, around) {
        let before, after;
        null == nodes[around] && (before = nodes[around - 1]) instanceof HeightMapGap && (after = nodes[around + 1]) instanceof HeightMapGap && nodes.splice(around - 1, 3, new HeightMapGap(before.length + 1 + after.length));
    }
    class NodeBuilder {
        constructor(pos, oracle) {
            this.pos = pos, this.oracle = oracle, this.nodes = [], this.lineStart = -1, 
            this.lineEnd = -1, this.covering = null, this.writtenTo = pos;
        }
        get isCovered() {
            return this.covering && this.nodes[this.nodes.length - 1] == this.covering;
        }
        span(_from, to) {
            var end, last;
            -1 < this.lineStart && (end = Math.min(to, this.lineEnd), (last = this.nodes[this.nodes.length - 1]) instanceof HeightMapText ? last.length += end - this.pos : (end > this.pos || !this.isCovered) && this.nodes.push(new HeightMapText(end - this.pos, -1)), 
            (this.writtenTo = end) < to) && (this.nodes.push(null), this.writtenTo++, 
            this.lineStart = -1), this.pos = to;
        }
        point(from, to, deco) {
            if (from < to || deco.heightRelevant) {
                let height = deco.widget ? deco.widget.estimatedHeight : 0;
                var breaks = deco.widget ? deco.widget.lineBreaks : 0, len = (height < 0 && (height = this.oracle.lineHeight), 
                to - from);
                deco.block ? this.addBlock(new HeightMapBlock(len, height, deco)) : (len || breaks || 5 <= height) && this.addLineDeco(height, breaks, len);
            } else from < to && this.span(from, to);
            -1 < this.lineEnd && this.lineEnd < this.pos && (this.lineEnd = this.oracle.doc.lineAt(this.pos).to);
        }
        enterLine() {
            var from, to;
            -1 < this.lineStart || ({
                from,
                to
            } = this.oracle.doc.lineAt(this.pos), this.lineStart = from, this.lineEnd = to, 
            this.writtenTo < from && ((this.writtenTo < from - 1 || null == this.nodes[this.nodes.length - 1]) && this.nodes.push(this.blankContent(this.writtenTo, from - 1)), 
            this.nodes.push(null)), this.pos > from && this.nodes.push(new HeightMapText(this.pos - from, -1)), 
            this.writtenTo = this.pos);
        }
        blankContent(from, to) {
            var gap = new HeightMapGap(to - from);
            return this.oracle.doc.lineAt(from).to == to && (gap.flags |= 4), gap;
        }
        ensureLine() {
            this.enterLine();
            var last = this.nodes.length ? this.nodes[this.nodes.length - 1] : null;
            return last instanceof HeightMapText || (last = new HeightMapText(0, -1), 
            this.nodes.push(last)), last;
        }
        addBlock(block) {
            this.enterLine();
            var deco = block.deco;
            deco && 0 < deco.startSide && !this.isCovered && this.ensureLine(), 
            this.nodes.push(block), this.writtenTo = this.pos = this.pos + block.length, 
            deco && 0 < deco.endSide && (this.covering = block);
        }
        addLineDeco(height, breaks, length) {
            var line = this.ensureLine();
            line.length += length, line.collapsed += length, line.widgetHeight = Math.max(line.widgetHeight, height), 
            line.breaks += breaks, this.writtenTo = this.pos = this.pos + length;
        }
        finish(from) {
            var node, last = 0 == this.nodes.length ? null : this.nodes[this.nodes.length - 1];
            !(-1 < this.lineStart) || last instanceof HeightMapText || this.isCovered ? (this.writtenTo < this.pos || null == last) && this.nodes.push(this.blankContent(this.writtenTo, this.pos)) : this.nodes.push(new HeightMapText(0, -1));
            let pos = from;
            for (node of this.nodes) node instanceof HeightMapText && node.updateHeight(this.oracle, pos), 
            pos += node ? node.length : 1;
            return this.nodes;
        }
        static build(oracle, decorations, from, to) {
            oracle = new NodeBuilder(from, oracle);
            return RangeSet.spans(decorations, from, to, oracle, 0), oracle.finish(from);
        }
    }
    class DecorationComparator {
        constructor() {
            this.changes = [];
        }
        compareRange() {}
        comparePoint(from, to, a, b) {
            (from < to || a && a.heightRelevant || b && b.heightRelevant) && addRange(from, to, this.changes, 5);
        }
    }
    class LineGap {
        constructor(from, to, size, displaySize) {
            this.from = from, this.to = to, this.size = size, this.displaySize = displaySize;
        }
        static same(a, b) {
            if (a.length != b.length) return !1;
            for (let i = 0; i < a.length; i++) {
                var gA = a[i], gB = b[i];
                if (gA.from != gB.from || gA.to != gB.to || gA.size != gB.size) return !1;
            }
            return !0;
        }
        draw(viewState, wrapping) {
            return Decoration.replace({
                widget: new LineGapWidget(this.displaySize * (wrapping ? viewState.scaleY : viewState.scaleX), wrapping)
            }).range(this.from, this.to);
        }
    }
    class LineGapWidget extends WidgetType {
        constructor(size, vertical) {
            super(), this.size = size, this.vertical = vertical;
        }
        eq(other) {
            return other.size == this.size && other.vertical == this.vertical;
        }
        toDOM() {
            var elt = document.createElement("div");
            return this.vertical ? elt.style.height = this.size + "px" : (elt.style.width = this.size + "px", 
            elt.style.height = "2px", elt.style.display = "inline-block"), elt;
        }
        get estimatedHeight() {
            return this.vertical ? this.size : -1;
        }
    }
    class ViewState {
        constructor(state) {
            this.state = state, this.pixelViewport = {
                left: 0,
                right: window.innerWidth,
                top: 0,
                bottom: 0
            }, this.inView = !0, this.paddingTop = 0, this.paddingBottom = 0, this.contentDOMWidth = 0, 
            this.contentDOMHeight = 0, this.editorHeight = 0, this.editorWidth = 0, 
            this.scrollTop = 0, this.scrolledToBottom = !1, this.scaleX = 1, this.scaleY = 1, 
            this.scrollAnchorPos = 0, this.scrollAnchorHeight = -1, this.scaler = IdScaler, 
            this.scrollTarget = null, this.printing = !1, this.mustMeasureContent = !0, 
            this.defaultTextDirection = Direction.LTR, this.visibleRanges = [], 
            this.mustEnforceCursorAssoc = !1;
            var guessWrapping = state.facet(contentAttributes).some(v => "function" != typeof v && "cm-lineWrapping" == v.class);
            this.heightOracle = new HeightOracle(guessWrapping), this.stateDeco = state.facet(decorations).filter(d => "function" != typeof d), 
            this.heightMap = HeightMap.empty().applyChanges(this.stateDeco, Text.empty, this.heightOracle.setDoc(state.doc), [ new ChangedRange(0, 0, 0, state.doc.length) ]);
            for (let i = 0; i < 2 && (this.viewport = this.getViewport(0, null), 
            this.updateForViewport()); i++);
            this.updateViewportLines(), this.lineGaps = this.ensureLineGaps([]), 
            this.lineGapDeco = Decoration.set(this.lineGaps.map(gap => gap.draw(this, !1))), 
            this.computeVisibleRanges();
        }
        updateForViewport() {
            var from, to, viewports = [ this.viewport ], main = this.state.selection["main"];
            for (let i = 0; i <= 1; i++) {
                let pos = i ? main.head : main.anchor;
                viewports.some(({
                    from,
                    to
                }) => pos >= from && pos <= to) || ({
                    from,
                    to
                } = this.lineBlockAt(pos), viewports.push(new Viewport(from, to)));
            }
            return this.viewports = viewports.sort((a, b) => a.from - b.from), this.updateScaler();
        }
        updateScaler() {
            var scaler = this.scaler;
            return this.scaler = this.heightMap.height <= 7e6 ? IdScaler : new BigScaler(this.heightOracle, this.heightMap, this.viewports), 
            scaler.eq(this.scaler) ? 0 : 2;
        }
        updateViewportLines() {
            this.viewportLines = [], this.heightMap.forEachLine(this.viewport.from, this.viewport.to, this.heightOracle.setDoc(this.state.doc), 0, 0, block => {
                this.viewportLines.push(scaleBlock(block, this.scaler));
            });
        }
        update(update, scrollTarget = null) {
            this.state = update.state;
            var prevDeco = this.stateDeco, contentChanges = (this.stateDeco = this.state.facet(decorations).filter(d => "function" != typeof d), 
            update.changedRanges), contentChanges = ChangedRange.extendWithRanges(contentChanges, (contentChanges = prevDeco, 
            prevDeco = this.stateDeco, diff = update ? update.changes : ChangeSet.empty(this.state.doc.length), 
            comp = new DecorationComparator(), RangeSet.compare(contentChanges, prevDeco, diff, comp, 0), 
            comp.changes)), prevDeco = this.heightMap.height, diff = this.scrolledToBottom ? null : this.scrollAnchorAt(this.scrollTop);
            clearHeightChangeFlag(), this.heightMap = this.heightMap.applyChanges(this.stateDeco, update.startState.doc, this.heightOracle.setDoc(this.state.doc), contentChanges), 
            this.heightMap.height == prevDeco && !heightChangeFlag || (update.flags |= 2), 
            diff ? (this.scrollAnchorPos = update.changes.mapPos(diff.from, -1), 
            this.scrollAnchorHeight = diff.top) : (this.scrollAnchorPos = -1, this.scrollAnchorHeight = prevDeco);
            let viewport = contentChanges.length ? this.mapViewport(this.viewport, update.changes) : this.viewport;
            var comp = (viewport = scrollTarget && (scrollTarget.range.head < viewport.from || scrollTarget.range.head > viewport.to) || !this.viewportIsAppropriate(viewport) ? this.getViewport(0, scrollTarget) : viewport).from != this.viewport.from || viewport.to != this.viewport.to;
            this.viewport = viewport, update.flags |= this.updateForViewport(), 
            (comp || !update.changes.empty || 2 & update.flags) && this.updateViewportLines(), 
            (this.lineGaps.length || 4e3 < this.viewport.to - this.viewport.from) && this.updateLineGaps(this.ensureLineGaps(this.mapLineGaps(this.lineGaps, update.changes))), 
            update.flags |= this.computeVisibleRanges(update.changes), scrollTarget && (this.scrollTarget = scrollTarget), 
            !this.mustEnforceCursorAssoc && update.selectionSet && update.view.lineWrapping && update.state.selection.main.empty && update.state.selection.main.assoc && !update.state.facet(nativeSelectionHidden) && (this.mustEnforceCursorAssoc = !0);
        }
        measure(view) {
            var dom = view.contentDOM, style = window.getComputedStyle(dom), oracle = this.heightOracle, whiteSpace = style.whiteSpace;
            this.defaultTextDirection = "rtl" == style.direction ? Direction.RTL : Direction.LTR;
            let refresh = this.heightOracle.mustRefreshForWrapping(whiteSpace);
            var domRect = dom.getBoundingClientRect();
            let measureContent = refresh || this.mustMeasureContent || this.contentDOMHeight != domRect.height, result = (this.contentDOMHeight = domRect.height, 
            this.mustMeasureContent = !1, 0), bias = 0;
            domRect.width && domRect.height && ({
                scaleX,
                scaleY
            } = getScale(dom, domRect), .005 < scaleX && .005 < Math.abs(this.scaleX - scaleX) || .005 < scaleY && .005 < Math.abs(this.scaleY - scaleY)) && (this.scaleX = scaleX, 
            this.scaleY = scaleY, result |= 16, refresh = measureContent = !0);
            var scaleX = (parseInt(style.paddingTop) || 0) * this.scaleY, scaleY = (parseInt(style.paddingBottom) || 0) * this.scaleY, style = (this.paddingTop == scaleX && this.paddingBottom == scaleY || (this.paddingTop = scaleX, 
            this.paddingBottom = scaleY, result |= 18), this.editorWidth != view.scrollDOM.clientWidth && (oracle.lineWrapping && (measureContent = !0), 
            this.editorWidth = view.scrollDOM.clientWidth, result |= 16), view.scrollDOM.scrollTop * this.scaleY), scaleX = (this.scrollTop != style && (this.scrollAnchorHeight = -1, 
            this.scrollTop = style), this.scrolledToBottom = isScrolledToBottom(view.scrollDOM), 
            (this.printing ? function(dom, paddingTop) {
                return {
                    left: 0,
                    right: (dom = dom.getBoundingClientRect()).right - dom.left,
                    top: paddingTop,
                    bottom: dom.bottom - (dom.top + paddingTop)
                };
            } : function(dom, paddingTop) {
                var rect = dom.getBoundingClientRect(), doc = dom.ownerDocument, win = doc.defaultView || window;
                let left = Math.max(0, rect.left), right = Math.min(win.innerWidth, rect.right), top = Math.max(0, rect.top), bottom = Math.min(win.innerHeight, rect.bottom);
                for (let parent = dom.parentNode; parent && parent != doc.body; ) if (1 == parent.nodeType) {
                    var parentRect, elt = parent, style = window.getComputedStyle(elt);
                    (elt.scrollHeight > elt.clientHeight || elt.scrollWidth > elt.clientWidth) && "visible" != style.overflow && (parentRect = elt.getBoundingClientRect(), 
                    left = Math.max(left, parentRect.left), right = Math.min(right, parentRect.right), 
                    top = Math.max(top, parentRect.top), bottom = Math.min(parent == dom.parentNode ? win.innerHeight : bottom, parentRect.bottom)), 
                    parent = "absolute" == style.position || "fixed" == style.position ? elt.offsetParent : elt.parentNode;
                } else {
                    if (11 != parent.nodeType) break;
                    parent = parent.host;
                }
                return {
                    left: left - rect.left,
                    right: Math.max(left, right) - rect.left,
                    top: top - (rect.top + paddingTop),
                    bottom: Math.max(top, bottom) - (rect.top + paddingTop)
                };
            })(dom, this.paddingTop)), scaleY = scaleX.top - this.pixelViewport.top, style = scaleX.bottom - this.pixelViewport.bottom, dom = (this.pixelViewport = scaleX, 
            this.pixelViewport.bottom > this.pixelViewport.top && this.pixelViewport.right > this.pixelViewport.left);
            if (dom != this.inView && (this.inView = dom) && (measureContent = !0), 
            !(this.inView || this.scrollTarget || (scaleX = view.dom, dom = scaleX.getBoundingClientRect(), 
            scaleX = scaleX.ownerDocument.defaultView || window, dom.left < scaleX.innerWidth && 0 < dom.right && dom.top < scaleX.innerHeight && 0 < dom.bottom))) return 0;
            dom = domRect.width;
            if (this.contentDOMWidth == dom && this.editorHeight == view.scrollDOM.clientHeight || (this.contentDOMWidth = domRect.width, 
            this.editorHeight = view.scrollDOM.clientHeight, result |= 16), measureContent) {
                var charWidth, textHeight, vp, lineHeights = view.docView.measureVisibleLineHeights(this.viewport);
                ((refresh = oracle.mustRefreshForHeights(lineHeights) ? !0 : refresh) || oracle.lineWrapping && Math.abs(dom - this.contentDOMWidth) > oracle.charWidth) && ({
                    lineHeight: domRect,
                    charWidth,
                    textHeight
                } = view.docView.measureTextSize(), refresh = 0 < domRect && oracle.refresh(whiteSpace, domRect, charWidth, textHeight, Math.max(5, dom / charWidth), lineHeights)) && (view.docView.minWidth = 0, 
                result |= 16), 0 < scaleY && 0 < style ? bias = Math.max(scaleY, style) : scaleY < 0 && style < 0 && (bias = Math.min(scaleY, style)), 
                clearHeightChangeFlag();
                for (vp of this.viewports) {
                    var heights = vp.from == this.viewport.from ? lineHeights : view.docView.measureVisibleLineHeights(vp);
                    this.heightMap = (refresh ? HeightMap.empty().applyChanges(this.stateDeco, Text.empty, this.heightOracle, [ new ChangedRange(0, 0, 0, view.state.doc.length) ]) : this.heightMap).updateHeight(oracle, 0, refresh, new MeasuredHeights(vp.from, heights));
                }
                heightChangeFlag && (result |= 2);
            }
            whiteSpace = !this.viewportIsAppropriate(this.viewport, bias) || this.scrollTarget && (this.scrollTarget.range.head < this.viewport.from || this.scrollTarget.range.head > this.viewport.to);
            return whiteSpace && (2 & result && (result |= this.updateScaler()), 
            this.viewport = this.getViewport(bias, this.scrollTarget), result |= this.updateForViewport()), 
            (2 & result || whiteSpace) && this.updateViewportLines(), (this.lineGaps.length || 4e3 < this.viewport.to - this.viewport.from) && this.updateLineGaps(this.ensureLineGaps(refresh ? [] : this.lineGaps, view)), 
            result |= this.computeVisibleRanges(), this.mustEnforceCursorAssoc && (this.mustEnforceCursorAssoc = !1, 
            view.docView.enforceCursorAssoc()), result;
        }
        get visibleTop() {
            return this.scaler.fromDOM(this.pixelViewport.top);
        }
        get visibleBottom() {
            return this.scaler.fromDOM(this.pixelViewport.bottom);
        }
        getViewport(bias, scrollTarget) {
            var bias = .5 - Math.max(-.5, Math.min(.5, bias / 1e3 / 2)), map = this.heightMap, oracle = this.heightOracle, {
                visibleTop,
                visibleBottom
            } = this;
            let viewport = new Viewport(map.lineAt(visibleTop - 1e3 * bias, QueryType$1.ByHeight, oracle, 0, 0).from, map.lineAt(visibleBottom + 1e3 * (1 - bias), QueryType$1.ByHeight, oracle, 0, 0).to);
            if (scrollTarget) {
                visibleTop = scrollTarget.range["head"];
                if (visibleTop < viewport.from || visibleTop > viewport.to) {
                    visibleBottom = Math.min(this.editorHeight, this.pixelViewport.bottom - this.pixelViewport.top);
                    let block = map.lineAt(visibleTop, QueryType$1.ByPos, oracle, 0, 0), topPos;
                    topPos = "center" == scrollTarget.y ? (block.top + block.bottom) / 2 - visibleBottom / 2 : "start" == scrollTarget.y || "nearest" == scrollTarget.y && visibleTop < viewport.from ? block.top : block.bottom - visibleBottom, 
                    viewport = new Viewport(map.lineAt(topPos - 500, QueryType$1.ByHeight, oracle, 0, 0).from, map.lineAt(topPos + visibleBottom + 500, QueryType$1.ByHeight, oracle, 0, 0).to);
                }
            }
            return viewport;
        }
        mapViewport(viewport, changes) {
            var from = changes.mapPos(viewport.from, -1), changes = changes.mapPos(viewport.to, 1);
            return new Viewport(this.heightMap.lineAt(from, QueryType$1.ByPos, this.heightOracle, 0, 0).from, this.heightMap.lineAt(changes, QueryType$1.ByPos, this.heightOracle, 0, 0).to);
        }
        viewportIsAppropriate({
            from,
            to
        }, bias = 0) {
            var top, bottom, visibleTop, visibleBottom;
            return !this.inView || (top = this.heightMap.lineAt(from, QueryType$1.ByPos, this.heightOracle, 0, 0)["top"], 
            bottom = this.heightMap.lineAt(to, QueryType$1.ByPos, this.heightOracle, 0, 0)["bottom"], 
            {
                visibleTop,
                visibleBottom
            } = this, (0 == from || top <= visibleTop - Math.max(10, Math.min(-bias, 250))) && (to == this.state.doc.length || bottom >= visibleBottom + Math.max(10, Math.min(bias, 250))) && visibleTop - 2e3 < top && bottom < visibleBottom + 2e3);
        }
        mapLineGaps(gaps, changes) {
            if (!gaps.length || changes.empty) return gaps;
            var gap, mapped = [];
            for (gap of gaps) changes.touchesRange(gap.from, gap.to) || mapped.push(new LineGap(changes.mapPos(gap.from), changes.mapPos(gap.to), gap.size, gap.displaySize));
            return mapped;
        }
        ensureLineGaps(current, mayMeasure) {
            let wrapping = this.heightOracle.lineWrapping, margin = wrapping ? 1e4 : 2e3, halfMargin = margin >> 1, doubleMargin = margin << 1;
            if (this.defaultTextDirection != Direction.LTR && !wrapping) return [];
            let gaps = [], addGap = (from, to, line, structure) => {
                if (!(to - from < halfMargin)) {
                    let sel = this.state.selection.main, avoid = [ sel.from ];
                    sel.empty || avoid.push(sel.to);
                    for (var pos of avoid) if (pos > from && pos < to) return addGap(from, pos - 10, line, structure), 
                    void addGap(pos + 10, to, line, structure);
                    let gap = function(array, f) {
                        for (var val of array) if (f(val)) return val;
                        return;
                    }(current, gap => gap.from >= line.from && gap.to <= line.to && Math.abs(gap.from - from) < halfMargin && Math.abs(gap.to - to) < halfMargin && !avoid.some(pos => gap.from < pos && gap.to > pos));
                    var lineStart, displaySize;
                    gap || (to < line.to && mayMeasure && wrapping && mayMeasure.visibleRanges.some(r => r.from <= to && r.to >= to) && (lineStart = mayMeasure.moveToLineBoundary(EditorSelection.cursor(to), !1, !0).head, 
                    from < lineStart) && (to = lineStart), lineStart = this.gapSize(line, from, to, structure), 
                    displaySize = wrapping || lineStart < 2e6 ? lineStart : 2e6, 
                    gap = new LineGap(from, to, lineStart, displaySize)), gaps.push(gap);
                }
            };
            var line, checkLine = line => {
                if (!(line.length < doubleMargin || line.type != BlockType.Text)) {
                    var structure = function(from, to, stateDeco) {
                        let ranges = [], pos = from, total = 0;
                        RangeSet.spans(stateDeco, from, to, {
                            span() {},
                            point(from, to) {
                                from > pos && (ranges.push({
                                    from: pos,
                                    to: from
                                }), total += from - pos), pos = to;
                            }
                        }, 20), pos < to && (ranges.push({
                            from: pos,
                            to: to
                        }), total += to - pos);
                        return {
                            total: total,
                            ranges: ranges
                        };
                    }(line.from, line.to, this.stateDeco);
                    if (!(structure.total < doubleMargin)) {
                        var target = this.scrollTarget ? this.scrollTarget.range.head : null;
                        let viewFrom, viewTo;
                        if (wrapping) {
                            var targetFrac, spaceFrac, marginHeight = margin / this.heightOracle.lineLength * this.heightOracle.lineHeight;
                            let top, bot;
                            bot = null != target ? (targetFrac = findFraction(structure, target), 
                            spaceFrac = ((this.visibleBottom - this.visibleTop) / 2 + marginHeight) / line.height, 
                            top = targetFrac - spaceFrac, targetFrac + spaceFrac) : (top = (this.visibleTop - line.top - marginHeight) / line.height, 
                            (this.visibleBottom - line.top + marginHeight) / line.height), 
                            viewFrom = findPosition(structure, top), viewTo = findPosition(structure, bot);
                        } else {
                            var marginHeight = structure.total * this.heightOracle.charWidth, marginWidth = margin * this.heightOracle.charWidth;
                            let horizOffset = 0;
                            if (2e6 < marginHeight) for (var old of current) old.from >= line.from && old.from < line.to && old.size != old.displaySize && old.from * this.heightOracle.charWidth + horizOffset < this.pixelViewport.left && (horizOffset = old.size - old.displaySize);
                            var pxLeft = this.pixelViewport.left + horizOffset, pxRight = this.pixelViewport.right + horizOffset;
                            let left, right;
                            if (null != target) {
                                let targetFrac = findFraction(structure, target), spaceFrac = ((pxRight - pxLeft) / 2 + marginWidth) / marginHeight;
                                left = targetFrac - spaceFrac, right = targetFrac + spaceFrac;
                            } else left = (pxLeft - marginWidth) / marginHeight, 
                            right = (pxRight + marginWidth) / marginHeight;
                            viewFrom = findPosition(structure, left), viewTo = findPosition(structure, right);
                        }
                        viewFrom > line.from && addGap(line.from, viewFrom, line, structure), 
                        viewTo < line.to && addGap(viewTo, line.to, line, structure);
                    }
                }
            };
            for (line of this.viewportLines) Array.isArray(line.type) ? line.type.forEach(checkLine) : checkLine(line);
            return gaps;
        }
        gapSize(line, from, to, structure) {
            to = findFraction(structure, to) - findFraction(structure, from);
            return this.heightOracle.lineWrapping ? line.height * to : structure.total * this.heightOracle.charWidth * to;
        }
        updateLineGaps(gaps) {
            LineGap.same(gaps, this.lineGaps) || (this.lineGaps = gaps, this.lineGapDeco = Decoration.set(gaps.map(gap => gap.draw(this, this.heightOracle.lineWrapping))));
        }
        computeVisibleRanges(changes) {
            let deco = this.stateDeco, ranges = (this.lineGaps.length && (deco = deco.concat(this.lineGapDeco)), 
            []), changed = (RangeSet.spans(deco, this.viewport.from, this.viewport.to, {
                span(from, to) {
                    ranges.push({
                        from: from,
                        to: to
                    });
                },
                point() {}
            }, 20), 0);
            if (ranges.length != this.visibleRanges.length) changed = 12; else for (let i = 0; i < ranges.length && !(8 & changed); i++) {
                var old = this.visibleRanges[i], nw = ranges[i];
                old.from == nw.from && old.to == nw.to || (changed |= 4, changes && changes.mapPos(old.from, -1) == nw.from && changes.mapPos(old.to, 1) == nw.to) || (changed |= 8);
            }
            return this.visibleRanges = ranges, changed;
        }
        lineBlockAt(pos) {
            return pos >= this.viewport.from && pos <= this.viewport.to && this.viewportLines.find(b => b.from <= pos && b.to >= pos) || scaleBlock(this.heightMap.lineAt(pos, QueryType$1.ByPos, this.heightOracle, 0, 0), this.scaler);
        }
        lineBlockAtHeight(height) {
            return height >= this.viewportLines[0].top && height <= this.viewportLines[this.viewportLines.length - 1].bottom && this.viewportLines.find(l => l.top <= height && l.bottom >= height) || scaleBlock(this.heightMap.lineAt(this.scaler.fromDOM(height), QueryType$1.ByHeight, this.heightOracle, 0, 0), this.scaler);
        }
        scrollAnchorAt(scrollTop) {
            var block = this.lineBlockAtHeight(scrollTop + 8);
            return block.from >= this.viewport.from || 200 < this.viewportLines[0].top - scrollTop ? block : this.viewportLines[0];
        }
        elementAtHeight(height) {
            return scaleBlock(this.heightMap.blockAt(this.scaler.fromDOM(height), this.heightOracle, 0, 0), this.scaler);
        }
        get docHeight() {
            return this.scaler.toDOM(this.heightMap.height);
        }
        get contentHeight() {
            return this.docHeight + this.paddingTop + this.paddingBottom;
        }
    }
    class Viewport {
        constructor(from, to) {
            this.from = from, this.to = to;
        }
    }
    function findPosition({
        total,
        ranges
    }, ratio) {
        if (ratio <= 0) return ranges[0].from;
        if (1 <= ratio) return ranges[ranges.length - 1].to;
        let dist = Math.floor(total * ratio);
        for (let i = 0; ;i++) {
            var {
                from,
                to
            } = ranges[i], to = to - from;
            if (dist <= to) return from + dist;
            dist -= to;
        }
    }
    function findFraction(structure, pos) {
        let counted = 0;
        for (var {
            from,
            to
        } of structure.ranges) {
            if (pos <= to) {
                counted += pos - from;
                break;
            }
            counted += to - from;
        }
        return counted / structure.total;
    }
    const IdScaler = {
        toDOM(n) {
            return n;
        },
        fromDOM(n) {
            return n;
        },
        scale: 1,
        eq(other) {
            return other == this;
        }
    };
    class BigScaler {
        constructor(oracle, heightMap, viewports) {
            let vpHeight = 0, base = 0, domBase = 0;
            this.viewports = viewports.map(({
                from,
                to
            }) => {
                var top = heightMap.lineAt(from, QueryType$1.ByPos, oracle, 0, 0).top, bottom = heightMap.lineAt(to, QueryType$1.ByPos, oracle, 0, 0).bottom;
                return vpHeight += bottom - top, {
                    from: from,
                    to: to,
                    top: top,
                    bottom: bottom,
                    domTop: 0,
                    domBottom: 0
                };
            }), this.scale = (7e6 - vpHeight) / (heightMap.height - vpHeight);
            for (var obj of this.viewports) obj.domTop = domBase + (obj.top - base) * this.scale, 
            domBase = obj.domBottom = obj.domTop + (obj.bottom - obj.top), base = obj.bottom;
        }
        toDOM(n) {
            for (let i = 0, base = 0, domBase = 0; ;i++) {
                var vp = i < this.viewports.length ? this.viewports[i] : null;
                if (!vp || n < vp.top) return domBase + (n - base) * this.scale;
                if (n <= vp.bottom) return vp.domTop + (n - vp.top);
                base = vp.bottom, domBase = vp.domBottom;
            }
        }
        fromDOM(n) {
            for (let i = 0, base = 0, domBase = 0; ;i++) {
                var vp = i < this.viewports.length ? this.viewports[i] : null;
                if (!vp || n < vp.domTop) return base + (n - domBase) / this.scale;
                if (n <= vp.domBottom) return vp.top + (n - vp.domTop);
                base = vp.bottom, domBase = vp.domBottom;
            }
        }
        eq(other) {
            return other instanceof BigScaler && this.scale == other.scale && this.viewports.length == other.viewports.length && this.viewports.every((vp, i) => vp.from == other.viewports[i].from && vp.to == other.viewports[i].to);
        }
    }
    function scaleBlock(block, scaler) {
        var bTop, bBottom;
        return 1 == scaler.scale ? block : (bTop = scaler.toDOM(block.top), bBottom = scaler.toDOM(block.bottom), 
        new BlockInfo(block.from, block.length, bTop, bBottom - bTop, Array.isArray(block._content) ? block._content.map(b => scaleBlock(b, scaler)) : block._content));
    }
    const theme = Facet.define({
        combine: strs => strs.join(" ")
    }), darkTheme = Facet.define({
        combine: values => -1 < values.indexOf(!0)
    }), baseThemeID = StyleModule.newName(), baseLightID = StyleModule.newName(), baseDarkID = StyleModule.newName(), lightDarkIDs = {
        "&light": "." + baseLightID,
        "&dark": "." + baseDarkID
    };
    function buildTheme(main, spec, scopes) {
        return new StyleModule(spec, {
            finish(sel) {
                return /&/.test(sel) ? sel.replace(/&\w*/, m => {
                    if ("&" == m) return main;
                    if (scopes && scopes[m]) return scopes[m];
                    throw new RangeError("Unsupported selector: " + m);
                }) : main + " " + sel;
            }
        });
    }
    const baseTheme$1$2 = buildTheme("." + baseThemeID, {
        "&": {
            position: "relative !important",
            boxSizing: "border-box",
            "&.cm-focused": {
                outline: "1px dotted #212121"
            },
            display: "flex !important",
            flexDirection: "column"
        },
        ".cm-scroller": {
            display: "flex !important",
            alignItems: "flex-start !important",
            fontFamily: "monospace",
            lineHeight: 1.4,
            height: "100%",
            overflowX: "auto",
            position: "relative",
            zIndex: 0,
            overflowAnchor: "none"
        },
        ".cm-content": {
            margin: 0,
            flexGrow: 2,
            flexShrink: 0,
            display: "block",
            whiteSpace: "pre",
            wordWrap: "normal",
            boxSizing: "border-box",
            minHeight: "100%",
            padding: "4px 0",
            outline: "none",
            "&[contenteditable=true]": {
                WebkitUserModify: "read-write-plaintext-only"
            }
        },
        ".cm-lineWrapping": {
            whiteSpace_fallback: "pre-wrap",
            whiteSpace: "break-spaces",
            wordBreak: "break-word",
            overflowWrap: "anywhere",
            flexShrink: 1
        },
        "&light .cm-content": {
            caretColor: "black"
        },
        "&dark .cm-content": {
            caretColor: "white"
        },
        ".cm-line": {
            display: "block",
            padding: "0 2px 0 6px"
        },
        ".cm-layer": {
            position: "absolute",
            left: 0,
            top: 0,
            contain: "size style",
            "& > *": {
                position: "absolute"
            }
        },
        "&light .cm-selectionBackground": {
            background: "#d9d9d9"
        },
        "&dark .cm-selectionBackground": {
            background: "#222"
        },
        "&light.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
            background: "#d7d4f0"
        },
        "&dark.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
            background: "#233"
        },
        ".cm-cursorLayer": {
            pointerEvents: "none"
        },
        "&.cm-focused > .cm-scroller > .cm-cursorLayer": {
            animation: "steps(1) cm-blink 1.2s infinite"
        },
        "@keyframes cm-blink": {
            "0%": {},
            "50%": {
                opacity: 0
            },
            "100%": {}
        },
        "@keyframes cm-blink2": {
            "0%": {},
            "50%": {
                opacity: 0
            },
            "100%": {}
        },
        ".cm-cursor, .cm-dropCursor": {
            borderLeft: "1.2px solid black",
            marginLeft: "-0.6px",
            pointerEvents: "none"
        },
        ".cm-cursor": {
            display: "none"
        },
        "&dark .cm-cursor": {
            borderLeftColor: "#ddd"
        },
        ".cm-dropCursor": {
            position: "absolute"
        },
        "&.cm-focused > .cm-scroller > .cm-cursorLayer .cm-cursor": {
            display: "block"
        },
        ".cm-iso": {
            unicodeBidi: "isolate"
        },
        ".cm-announced": {
            position: "fixed",
            top: "-10000px"
        },
        "@media print": {
            ".cm-announced": {
                display: "none"
            }
        },
        "&light .cm-activeLine": {
            backgroundColor: "#cceeff44"
        },
        "&dark .cm-activeLine": {
            backgroundColor: "#99eeff33"
        },
        "&light .cm-specialChar": {
            color: "red"
        },
        "&dark .cm-specialChar": {
            color: "#f78"
        },
        ".cm-gutters": {
            flexShrink: 0,
            display: "flex",
            height: "100%",
            boxSizing: "border-box",
            zIndex: 200
        },
        ".cm-gutters-before": {
            insetInlineStart: 0
        },
        ".cm-gutters-after": {
            insetInlineEnd: 0
        },
        "&light .cm-gutters": {
            backgroundColor: "#f5f5f5",
            color: "#6c6c6c",
            border: "0px solid #ddd",
            "&.cm-gutters-before": {
                borderRightWidth: "1px"
            },
            "&.cm-gutters-after": {
                borderLeftWidth: "1px"
            }
        },
        "&dark .cm-gutters": {
            backgroundColor: "#333338",
            color: "#ccc"
        },
        ".cm-gutter": {
            display: "flex !important",
            flexDirection: "column",
            flexShrink: 0,
            boxSizing: "border-box",
            minHeight: "100%",
            overflow: "hidden"
        },
        ".cm-gutterElement": {
            boxSizing: "border-box"
        },
        ".cm-lineNumbers .cm-gutterElement": {
            padding: "0 3px 0 5px",
            minWidth: "20px",
            textAlign: "right",
            whiteSpace: "nowrap"
        },
        "&light .cm-activeLineGutter": {
            backgroundColor: "#e2f2ff"
        },
        "&dark .cm-activeLineGutter": {
            backgroundColor: "#222227"
        },
        ".cm-panels": {
            boxSizing: "border-box",
            position: "sticky",
            left: 0,
            right: 0,
            zIndex: 300
        },
        "&light .cm-panels": {
            backgroundColor: "#f5f5f5",
            color: "black"
        },
        "&light .cm-panels-top": {
            borderBottom: "1px solid #ddd"
        },
        "&light .cm-panels-bottom": {
            borderTop: "1px solid #ddd"
        },
        "&dark .cm-panels": {
            backgroundColor: "#333338",
            color: "white"
        },
        ".cm-dialog": {
            padding: "2px 19px 4px 6px",
            position: "relative",
            "& label": {
                fontSize: "80%"
            }
        },
        ".cm-dialog-close": {
            position: "absolute",
            top: "3px",
            right: "4px",
            backgroundColor: "inherit",
            border: "none",
            font: "inherit",
            fontSize: "14px",
            padding: "0"
        },
        ".cm-tab": {
            display: "inline-block",
            overflow: "hidden",
            verticalAlign: "bottom"
        },
        ".cm-widgetBuffer": {
            verticalAlign: "text-top",
            height: "1em",
            width: 0,
            display: "inline"
        },
        ".cm-placeholder": {
            color: "#888",
            display: "inline-block",
            verticalAlign: "top",
            userSelect: "none"
        },
        ".cm-highlightSpace": {
            backgroundImage: "radial-gradient(circle at 50% 55%, #aaa 20%, transparent 5%)",
            backgroundPosition: "center"
        },
        ".cm-highlightTab": {
            backgroundImage: `url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="200" height="20"><path stroke="%23888" stroke-width="1" fill="none" d="M1 10H196L190 5M190 15L196 10M197 4L197 16"/></svg>')`,
            backgroundSize: "auto 100%",
            backgroundPosition: "right 90%",
            backgroundRepeat: "no-repeat"
        },
        ".cm-trailingSpace": {
            backgroundColor: "#ff332255"
        },
        ".cm-button": {
            verticalAlign: "middle",
            color: "inherit",
            fontSize: "70%",
            padding: ".2em 1em",
            borderRadius: "1px"
        },
        "&light .cm-button": {
            backgroundImage: "linear-gradient(#eff1f5, #d9d9df)",
            border: "1px solid #888",
            "&:active": {
                backgroundImage: "linear-gradient(#b4b4b4, #d0d3d6)"
            }
        },
        "&dark .cm-button": {
            backgroundImage: "linear-gradient(#393939, #111)",
            border: "1px solid #888",
            "&:active": {
                backgroundImage: "linear-gradient(#111, #333)"
            }
        },
        ".cm-textfield": {
            verticalAlign: "middle",
            color: "inherit",
            fontSize: "70%",
            border: "1px solid silver",
            padding: ".2em .5em"
        },
        "&light .cm-textfield": {
            backgroundColor: "white"
        },
        "&dark .cm-textfield": {
            border: "1px solid #555",
            backgroundColor: "inherit"
        }
    }, lightDarkIDs), observeOptions = {
        childList: !0,
        characterData: !0,
        subtree: !0,
        attributes: !0,
        characterDataOldValue: !0
    }, useCharData = browser.ie && browser.ie_version <= 11;
    class DOMObserver {
        constructor(view) {
            this.view = view, this.active = !1, this.editContext = null, this.selectionRange = new DOMSelectionState(), 
            this.selectionChanged = !1, this.delayedFlush = -1, this.resizeTimeout = -1, 
            this.queue = [], this.delayedAndroidKey = null, this.flushingAndroidKey = -1, 
            this.lastChange = 0, this.scrollTargets = [], this.intersection = null, 
            this.resizeScroll = null, this.intersecting = !1, this.gapIntersection = null, 
            this.gaps = [], this.printQuery = null, this.parentCheck = -1, this.dom = view.contentDOM, 
            this.observer = new MutationObserver(mutations => {
                for (var mut of mutations) this.queue.push(mut);
                (browser.ie && browser.ie_version <= 11 || browser.ios && view.composing) && mutations.some(m => "childList" == m.type && m.removedNodes.length || "characterData" == m.type && m.oldValue.length > m.target.nodeValue.length) ? this.flushSoon() : this.flush();
            }), !window.EditContext || !browser.android || !1 === view.constructor.EDIT_CONTEXT || browser.chrome && browser.chrome_version < 126 || (this.editContext = new EditContextManager(view), 
            view.state.facet(editable) && (view.contentDOM.editContext = this.editContext.editContext)), 
            useCharData && (this.onCharData = event => {
                this.queue.push({
                    target: event.target,
                    type: "characterData",
                    oldValue: event.prevValue
                }), this.flushSoon();
            }), this.onSelectionChange = this.onSelectionChange.bind(this), this.onResize = this.onResize.bind(this), 
            this.onPrint = this.onPrint.bind(this), this.onScroll = this.onScroll.bind(this), 
            window.matchMedia && (this.printQuery = window.matchMedia("print")), 
            "function" == typeof ResizeObserver && (this.resizeScroll = new ResizeObserver(() => {
                var _a;
                (null == (_a = this.view.docView) ? void 0 : _a.lastUpdate) < Date.now() - 75 && this.onResize();
            }), this.resizeScroll.observe(view.scrollDOM)), this.addWindowListeners(this.win = view.win), 
            this.start(), "function" == typeof IntersectionObserver && (this.intersection = new IntersectionObserver(entries => {
                this.parentCheck < 0 && (this.parentCheck = setTimeout(this.listenForScroll.bind(this), 1e3)), 
                0 < entries.length && 0 < entries[entries.length - 1].intersectionRatio != this.intersecting && (this.intersecting = !this.intersecting, 
                this.intersecting != this.view.inView) && this.onScrollChanged(document.createEvent("Event"));
            }, {
                threshold: [ 0, .001 ]
            }), this.intersection.observe(this.dom), this.gapIntersection = new IntersectionObserver(entries => {
                0 < entries.length && 0 < entries[entries.length - 1].intersectionRatio && this.onScrollChanged(document.createEvent("Event"));
            }, {})), this.listenForScroll(), this.readSelectionRange();
        }
        onScrollChanged(e) {
            this.view.inputState.runHandlers("scroll", e), this.intersecting && this.view.measure();
        }
        onScroll(e) {
            this.intersecting && this.flush(!1), this.editContext && this.view.requestMeasure(this.editContext.measureReq), 
            this.onScrollChanged(e);
        }
        onResize() {
            this.resizeTimeout < 0 && (this.resizeTimeout = setTimeout(() => {
                this.resizeTimeout = -1, this.view.requestMeasure();
            }, 50));
        }
        onPrint(event) {
            ("change" != event.type && event.type || event.matches) && (this.view.viewState.printing = !0, 
            this.view.measure(), setTimeout(() => {
                this.view.viewState.printing = !1, this.view.requestMeasure();
            }, 500));
        }
        updateGaps(gaps) {
            if (this.gapIntersection && (gaps.length != this.gaps.length || this.gaps.some((g, i) => g != gaps[i]))) {
                this.gapIntersection.disconnect();
                for (var gap of gaps) this.gapIntersection.observe(gap);
                this.gaps = gaps;
            }
        }
        onSelectionChange(event) {
            var view, sel, context, wasChanged = this.selectionChanged;
            this.readSelectionRange() && !this.delayedAndroidKey && (view = this.view, 
            sel = this.selectionRange, view.state.facet(editable) ? view.root.activeElement == this.dom : hasSelection(this.dom, sel)) && ((context = sel.anchorNode && view.docView.nearest(sel.anchorNode)) && context.ignoreEvent(event) ? wasChanged || (this.selectionChanged = !1) : (browser.ie && browser.ie_version <= 11 || browser.android && browser.chrome) && !view.state.selection.main.empty && sel.focusNode && isEquivalentPosition(sel.focusNode, sel.focusOffset, sel.anchorNode, sel.anchorOffset) ? this.flushSoon() : this.flush(!1));
        }
        readSelectionRange() {
            var local, view = this["view"], selection = getSelection(view.root);
            return !!selection && !(!(selection = browser.safari && 11 == view.root.nodeType && view.root.activeElement == this.dom && function(view, selection) {
                if (selection.getComposedRanges) {
                    selection = selection.getComposedRanges(view.root)[0];
                    if (selection) return buildSelectionRangeFromRange(view, selection);
                }
                let found = null;
                function read(event) {
                    event.preventDefault(), event.stopImmediatePropagation(), found = event.getTargetRanges()[0];
                }
                return view.contentDOM.addEventListener("beforeinput", read, !0), 
                view.dom.ownerDocument.execCommand("indent"), view.contentDOM.removeEventListener("beforeinput", read, !0), 
                found ? buildSelectionRangeFromRange(view, found) : null;
            }(this.view, selection) || selection) || this.selectionRange.eq(selection) || ((local = hasSelection(this.dom, selection)) && !this.selectionChanged && view.inputState.lastFocusTime > Date.now() - 200 && view.inputState.lastTouchTime < Date.now() - 300 && function(doc, selection) {
                let node = selection.focusNode, offset = selection.focusOffset;
                if (node && selection.anchorNode == node && selection.anchorOffset == offset) for (offset = Math.min(offset, maxOffset(node)); ;) if (offset) {
                    if (1 != node.nodeType) return;
                    var prev = node.childNodes[offset - 1];
                    "false" == prev.contentEditable ? offset-- : (node = prev, offset = maxOffset(node));
                } else {
                    if (node == doc) return 1;
                    offset = domIndex(node), node = node.parentNode;
                }
            }(this.dom, selection) ? (this.view.inputState.lastFocusTime = 0, view.docView.updateSelection(), 
            1) : (this.selectionRange.setRange(selection), local && (this.selectionChanged = !0), 
            0)));
        }
        setSelectionRange(anchor, head) {
            this.selectionRange.set(anchor.node, anchor.offset, head.node, head.offset), 
            this.selectionChanged = !1;
        }
        clearSelectionRange() {
            this.selectionRange.set(null, 0, null, 0);
        }
        listenForScroll() {
            this.parentCheck = -1;
            let i = 0, changed = null;
            for (let dom = this.dom; dom; ) if (1 == dom.nodeType) !changed && i < this.scrollTargets.length && this.scrollTargets[i] == dom ? i++ : changed = changed || this.scrollTargets.slice(0, i), 
            changed && changed.push(dom), dom = dom.assignedSlot || dom.parentNode; else {
                if (11 != dom.nodeType) break;
                dom = dom.host;
            }
            if (changed = i < this.scrollTargets.length && !changed ? this.scrollTargets.slice(0, i) : changed) {
                for (var dom of this.scrollTargets) dom.removeEventListener("scroll", this.onScroll);
                for (let dom of this.scrollTargets = changed) dom.addEventListener("scroll", this.onScroll);
            }
        }
        ignore(f) {
            if (!this.active) return f();
            try {
                return this.stop(), f();
            } finally {
                this.start(), this.clear();
            }
        }
        start() {
            this.active || (this.observer.observe(this.dom, observeOptions), useCharData && this.dom.addEventListener("DOMCharacterDataModified", this.onCharData), 
            this.active = !0);
        }
        stop() {
            this.active && (this.active = !1, this.observer.disconnect(), useCharData) && this.dom.removeEventListener("DOMCharacterDataModified", this.onCharData);
        }
        clear() {
            this.processRecords(), this.queue.length = 0, this.selectionChanged = !1;
        }
        delayAndroidKey(key, keyCode) {
            this.delayedAndroidKey || (this.flushingAndroidKey = this.view.win.requestAnimationFrame(() => {
                var key = this.delayedAndroidKey;
                key && (this.clearDelayedAndroidKey(), this.view.inputState.lastKeyCode = key.keyCode, 
                this.view.inputState.lastKeyTime = Date.now(), !this.flush()) && key.force && dispatchKey(this.dom, key.key, key.keyCode);
            })), this.delayedAndroidKey && "Enter" != key || (this.delayedAndroidKey = {
                key: key,
                keyCode: keyCode,
                force: this.lastChange < Date.now() - 50 || !(null == (key = this.delayedAndroidKey) || !key.force)
            });
        }
        clearDelayedAndroidKey() {
            this.win.cancelAnimationFrame(this.flushingAndroidKey), this.delayedAndroidKey = null, 
            this.flushingAndroidKey = -1;
        }
        flushSoon() {
            this.delayedFlush < 0 && (this.delayedFlush = this.view.win.requestAnimationFrame(() => {
                this.delayedFlush = -1, this.flush();
            }));
        }
        forceFlush() {
            0 <= this.delayedFlush && (this.view.win.cancelAnimationFrame(this.delayedFlush), 
            this.delayedFlush = -1), this.flush();
        }
        pendingRecords() {
            for (var mut of this.observer.takeRecords()) this.queue.push(mut);
            return this.queue;
        }
        processRecords() {
            var record, records = this.pendingRecords();
            records.length && (this.queue = []);
            let from = -1, to = -1, typeOver = !1;
            for (record of records) {
                var range = this.readMutation(record);
                range && (range.typeOver && (typeOver = !0), -1 == from ? {
                    from,
                    to
                } = range : (from = Math.min(range.from, from), to = Math.max(range.to, to)));
            }
            return {
                from: from,
                to: to,
                typeOver: typeOver
            };
        }
        readChange() {
            var {
                from,
                to,
                typeOver
            } = this.processRecords(), newSel = this.selectionChanged && hasSelection(this.dom, this.selectionRange);
            if (from < 0 && !newSel) return null;
            -1 < from && (this.lastChange = Date.now()), this.view.inputState.lastFocusTime = 0, 
            this.selectionChanged = !1;
            newSel = new DOMChange(this.view, from, to, typeOver);
            return this.view.docView.domChanged = {
                newSel: newSel.newSel ? newSel.newSel.main : null
            }, newSel;
        }
        flush(readSelection = !0) {
            if (0 <= this.delayedFlush || this.delayedAndroidKey) return !1;
            readSelection && this.readSelectionRange();
            var startState, handled, readSelection = this.readChange();
            return readSelection ? (startState = this.view.state, handled = applyDOMChange(this.view, readSelection), 
            this.view.state == startState && (readSelection.domChanged || readSelection.newSel && !readSelection.newSel.main.eq(this.view.state.selection.main)) && this.view.update([]), 
            handled) : (this.view.requestMeasure(), !1);
        }
        readMutation(rec) {
            var childBefore, childAfter, cView = this.view.docView.nearest(rec.target);
            return !cView || cView.ignoreMutation(rec) ? null : (cView.markDirty("attributes" == rec.type), 
            "attributes" == rec.type && (cView.flags |= 4), "childList" == rec.type ? (childBefore = findChild(cView, rec.previousSibling || rec.target.previousSibling, -1), 
            childAfter = findChild(cView, rec.nextSibling || rec.target.nextSibling, 1), 
            {
                from: childBefore ? cView.posAfter(childBefore) : cView.posAtStart,
                to: childAfter ? cView.posBefore(childAfter) : cView.posAtEnd,
                typeOver: !1
            }) : "characterData" == rec.type ? {
                from: cView.posAtStart,
                to: cView.posAtEnd,
                typeOver: rec.target.nodeValue == rec.oldValue
            } : null);
        }
        setWindow(win) {
            win != this.win && (this.removeWindowListeners(this.win), this.win = win, 
            this.addWindowListeners(this.win));
        }
        addWindowListeners(win) {
            win.addEventListener("resize", this.onResize), this.printQuery ? this.printQuery.addEventListener ? this.printQuery.addEventListener("change", this.onPrint) : this.printQuery.addListener(this.onPrint) : win.addEventListener("beforeprint", this.onPrint), 
            win.addEventListener("scroll", this.onScroll), win.document.addEventListener("selectionchange", this.onSelectionChange);
        }
        removeWindowListeners(win) {
            win.removeEventListener("scroll", this.onScroll), win.removeEventListener("resize", this.onResize), 
            this.printQuery ? this.printQuery.removeEventListener ? this.printQuery.removeEventListener("change", this.onPrint) : this.printQuery.removeListener(this.onPrint) : win.removeEventListener("beforeprint", this.onPrint), 
            win.document.removeEventListener("selectionchange", this.onSelectionChange);
        }
        update(update) {
            this.editContext && (this.editContext.update(update), update.startState.facet(editable) != update.state.facet(editable)) && (update.view.contentDOM.editContext = update.state.facet(editable) ? this.editContext.editContext : null);
        }
        destroy() {
            var _a, dom;
            this.stop(), null != (_a = this.intersection) && _a.disconnect(), null != (_a = this.gapIntersection) && _a.disconnect(), 
            null != (_a = this.resizeScroll) && _a.disconnect();
            for (dom of this.scrollTargets) dom.removeEventListener("scroll", this.onScroll);
            this.removeWindowListeners(this.win), clearTimeout(this.parentCheck), 
            clearTimeout(this.resizeTimeout), this.win.cancelAnimationFrame(this.delayedFlush), 
            this.win.cancelAnimationFrame(this.flushingAndroidKey), this.editContext && (this.view.contentDOM.editContext = null, 
            this.editContext.destroy());
        }
    }
    function findChild(cView, dom, dir) {
        for (;dom; ) {
            var curView = ContentView.get(dom);
            if (curView && curView.parent == cView) return curView;
            curView = dom.parentNode;
            dom = curView != cView.dom ? curView : 0 < dir ? dom.nextSibling : dom.previousSibling;
        }
        return null;
    }
    function buildSelectionRangeFromRange(view, range) {
        let anchorNode = range.startContainer, anchorOffset = range.startOffset, focusNode = range.endContainer, focusOffset = range.endOffset;
        range = view.docView.domAtPos(view.state.selection.main.anchor);
        return isEquivalentPosition(range.node, range.offset, focusNode, focusOffset) && ([ anchorNode, anchorOffset, focusNode, focusOffset ] = [ focusNode, focusOffset, anchorNode, anchorOffset ]), 
        {
            anchorNode: anchorNode,
            anchorOffset: anchorOffset,
            focusNode: focusNode,
            focusOffset: focusOffset
        };
    }
    class EditContextManager {
        constructor(view) {
            this.from = 0, this.to = 0, this.pendingContextChange = null, this.handlers = Object.create(null), 
            this.composing = null, this.resetRange(view.state);
            let context = this.editContext = new window.EditContext({
                text: view.state.doc.sliceString(this.from, this.to),
                selectionStart: this.toContextPos(Math.max(this.from, Math.min(this.to, view.state.selection.main.anchor))),
                selectionEnd: this.toContextPos(view.state.selection.main.head)
            });
            for (var event in this.handlers.textupdate = e => {
                var main = view.state.selection.main, {
                    anchor,
                    head
                } = main, from = this.toEditorPos(e.updateRangeStart), to = this.toEditorPos(e.updateRangeEnd);
                0 <= view.inputState.composing && !this.composing && (this.composing = {
                    contextBase: e.updateRangeStart,
                    editorBase: from,
                    drifted: !1
                });
                let change = {
                    from: from,
                    to: to,
                    insert: Text.of(e.text.split("\n"))
                };
                change.from == this.from && anchor < this.from ? change.from = anchor : change.to == this.to && anchor > this.to && (change.to = anchor), 
                change.from != change.to || change.insert.length ? ((browser.mac || browser.android) && change.from == head - 1 && /^\. ?$/.test(e.text) && "off" == view.contentDOM.getAttribute("autocorrect") && (change = {
                    from: from,
                    to: to,
                    insert: Text.of([ e.text.replace(".", " ") ])
                }), this.pendingContextChange = change, view.state.readOnly || (anchor = this.to - this.from + (change.to - change.from + change.insert.length), 
                applyDOMChangeInner(view, change, EditorSelection.single(this.toEditorPos(e.selectionStart, anchor), this.toEditorPos(e.selectionEnd, anchor)))), 
                this.pendingContextChange && (this.revertPending(view.state), this.setSelection(view.state))) : (head = EditorSelection.single(this.toEditorPos(e.selectionStart), this.toEditorPos(e.selectionEnd))).main.eq(main) || view.dispatch({
                    selection: head,
                    userEvent: "select"
                });
            }, this.handlers.characterboundsupdate = e => {
                let rects = [], prev = null;
                for (let i = this.toEditorPos(e.rangeStart), end = this.toEditorPos(e.rangeEnd); i < end; i++) {
                    var rect = view.coordsForChar(i);
                    prev = rect && new DOMRect(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top) || prev || new DOMRect(), 
                    rects.push(prev);
                }
                context.updateCharacterBounds(e.rangeStart, rects);
            }, this.handlers.textformatupdate = e => {
                var format, deco = [];
                for (format of e.getTextFormats()) {
                    var from, to, lineStyle = format.underlineStyle, thickness = format.underlineThickness;
                    "None" != lineStyle && "None" != thickness && (from = this.toEditorPos(format.rangeStart)) < (to = this.toEditorPos(format.rangeEnd)) && (lineStyle = `text-decoration: underline ${"Dashed" == lineStyle ? "dashed " : "Squiggle" == lineStyle ? "wavy " : ""}${"Thin" == thickness ? 1 : 2}px`, 
                    deco.push(Decoration.mark({
                        attributes: {
                            style: lineStyle
                        }
                    }).range(from, to)));
                }
                view.dispatch({
                    effects: setEditContextFormatting.of(Decoration.set(deco))
                });
            }, this.handlers.compositionstart = () => {
                view.inputState.composing < 0 && (view.inputState.composing = 0, 
                view.inputState.compositionFirstChange = !0);
            }, this.handlers.compositionend = () => {
                var drifted;
                view.inputState.composing = -1, view.inputState.compositionFirstChange = null, 
                this.composing && (drifted = this.composing["drifted"], this.composing = null, 
                drifted) && this.reset(view.state);
            }, this.handlers) context.addEventListener(event, this.handlers[event]);
            this.measureReq = {
                read: view => {
                    this.editContext.updateControlBounds(view.contentDOM.getBoundingClientRect());
                    view = getSelection(view.root);
                    view && view.rangeCount && this.editContext.updateSelectionBounds(view.getRangeAt(0).getBoundingClientRect());
                }
            };
        }
        applyEdits(update) {
            let off = 0, abort = !1, pending = this.pendingContextChange;
            return update.changes.iterChanges((fromA, toA, _fromB, _toB, insert) => {
                if (!abort) {
                    var dLen = insert.length - (toA - fromA);
                    if (pending && toA >= pending.to) {
                        if (pending.from == fromA && pending.to == toA && pending.insert.eq(insert)) return pending = this.pendingContextChange = null, 
                        off += dLen, void (this.to += dLen);
                        pending = null, this.revertPending(update.state);
                    }
                    if (fromA += off, (toA += off) <= this.from) this.from += dLen, 
                    this.to += dLen; else if (fromA < this.to) {
                        if (fromA < this.from || toA > this.to || 3e4 < this.to - this.from + insert.length) return void (abort = !0);
                        this.editContext.updateText(this.toContextPos(fromA), this.toContextPos(toA), insert.toString()), 
                        this.to += dLen;
                    }
                    off += dLen;
                }
            }), pending && !abort && this.revertPending(update.state), !abort;
        }
        update(update) {
            var reverted = this.pendingContextChange, startSel = update.startState.selection.main;
            this.composing && (this.composing.drifted || !update.changes.touchesRange(startSel.from, startSel.to) && update.transactions.some(tr => !tr.isUserEvent("input.type") && tr.changes.touchesRange(this.from, this.to))) ? (this.composing.drifted = !0, 
            this.composing.editorBase = update.changes.mapPos(this.composing.editorBase)) : this.applyEdits(update) && this.rangeIsValid(update.state) ? (update.docChanged || update.selectionSet || reverted) && this.setSelection(update.state) : (this.pendingContextChange = null, 
            this.reset(update.state)), (update.geometryChanged || update.docChanged || update.selectionSet) && update.view.requestMeasure(this.measureReq);
        }
        resetRange(state) {
            var head = state.selection.main["head"];
            this.from = Math.max(0, head - 1e4), this.to = Math.min(state.doc.length, head + 1e4);
        }
        reset(state) {
            this.resetRange(state), this.editContext.updateText(0, this.editContext.text.length, state.doc.sliceString(this.from, this.to)), 
            this.setSelection(state);
        }
        revertPending(state) {
            var pending = this.pendingContextChange;
            this.pendingContextChange = null, this.editContext.updateText(this.toContextPos(pending.from), this.toContextPos(pending.from + pending.insert.length), state.doc.sliceString(pending.from, pending.to));
        }
        setSelection(state) {
            var state = state.selection["main"], start = this.toContextPos(Math.max(this.from, Math.min(this.to, state.anchor))), state = this.toContextPos(state.head);
            this.editContext.selectionStart == start && this.editContext.selectionEnd == state || this.editContext.updateSelection(start, state);
        }
        rangeIsValid(state) {
            var head = state.selection.main["head"];
            return !(0 < this.from && head - this.from < 500 || this.to < state.doc.length && this.to - head < 500 || 3e4 < this.to - this.from);
        }
        toEditorPos(contextPos, clipLen = this.to - this.from) {
            contextPos = Math.min(contextPos, clipLen);
            clipLen = this.composing;
            return clipLen && clipLen.drifted ? clipLen.editorBase + (contextPos - clipLen.contextBase) : contextPos + this.from;
        }
        toContextPos(editorPos) {
            var c = this.composing;
            return c && c.drifted ? c.contextBase + (editorPos - c.editorBase) : editorPos - this.from;
        }
        destroy() {
            for (var event in this.handlers) this.editContext.removeEventListener(event, this.handlers[event]);
        }
    }
    class EditorView {
        get state() {
            return this.viewState.state;
        }
        get viewport() {
            return this.viewState.viewport;
        }
        get visibleRanges() {
            return this.viewState.visibleRanges;
        }
        get inView() {
            return this.viewState.inView;
        }
        get composing() {
            return !!this.inputState && 0 < this.inputState.composing;
        }
        get compositionStarted() {
            return !!this.inputState && 0 <= this.inputState.composing;
        }
        get root() {
            return this._root;
        }
        get win() {
            return this.dom.ownerDocument.defaultView || window;
        }
        constructor(config = {}) {
            var plugin;
            this.plugins = [], this.pluginMap = new Map(), this.editorAttrs = {}, 
            this.contentAttrs = {}, this.bidiCache = [], this.destroyed = !1, this.updateState = 2, 
            this.measureScheduled = -1, this.measureRequests = [], this.contentDOM = document.createElement("div"), 
            this.scrollDOM = document.createElement("div"), this.scrollDOM.tabIndex = -1, 
            this.scrollDOM.className = "cm-scroller", this.scrollDOM.appendChild(this.contentDOM), 
            this.announceDOM = document.createElement("div"), this.announceDOM.className = "cm-announced", 
            this.announceDOM.setAttribute("aria-live", "polite"), this.dom = document.createElement("div"), 
            this.dom.appendChild(this.announceDOM), this.dom.appendChild(this.scrollDOM), 
            config.parent && config.parent.appendChild(this.dom);
            let dispatch = config["dispatch"];
            this.dispatchTransactions = config.dispatchTransactions || (dispatch ? trs => trs.forEach(tr => dispatch(tr, this)) : trs => this.update(trs)), 
            this.dispatch = this.dispatch.bind(this), this._root = config.root || function(node) {
                for (;node; ) {
                    if (node && (9 == node.nodeType || 11 == node.nodeType && node.host)) return node;
                    node = node.assignedSlot || node.parentNode;
                }
                return null;
            }(config.parent) || document, this.viewState = new ViewState(config.state || EditorState.create(config)), 
            config.scrollTo && config.scrollTo.is(scrollIntoView$1) && (this.viewState.scrollTarget = config.scrollTo.value.clip(this.viewState.state)), 
            this.plugins = this.state.facet(viewPlugin).map(spec => new PluginInstance(spec));
            for (plugin of this.plugins) plugin.update(this);
            this.observer = new DOMObserver(this), this.inputState = new InputState(this), 
            this.inputState.ensureHandlers(this.plugins), this.docView = new DocView(this), 
            this.mountStyles(), this.updateAttrs(), this.updateState = 0, this.requestMeasure(), 
            null != (config = document.fonts) && config.ready && document.fonts.ready.then(() => this.requestMeasure());
        }
        dispatch(...input) {
            input = 1 == input.length && input[0] instanceof Transaction ? input : 1 == input.length && Array.isArray(input[0]) ? input[0] : [ this.state.update(...input) ];
            this.dispatchTransactions(input, this);
        }
        update(transactions) {
            if (0 != this.updateState) throw new Error("Calls to EditorView.update are not allowed while an update is in progress");
            let redrawn = !1, attrsChanged = !1, update, state = this.state;
            for (var tr of transactions) {
                if (tr.startState != state) throw new RangeError("Trying to update state with a transaction that doesn't start from the previous state.");
                state = tr.state;
            }
            if (this.destroyed) this.viewState.state = state; else {
                let focus = this.hasFocus, focusFlag = 0, dispatchFocus = null, pendingKey = (transactions.some(tr => tr.annotation(isFocusChange)) ? (this.inputState.notifiedFocused = focus, 
                focusFlag = 1) : focus == this.inputState.notifiedFocused || (this.inputState.notifiedFocused = focus, 
                dispatchFocus = focusChangeTransaction(state, focus)) || (focusFlag = 1), 
                this.observer.delayedAndroidKey), domChange = null;
                if (pendingKey ? (this.observer.clearDelayedAndroidKey(), (!(domChange = this.observer.readChange()) || this.state.doc.eq(state.doc)) && this.state.selection.eq(state.selection) || (domChange = null)) : this.observer.clear(), 
                state.facet(EditorState.phrases) != this.state.facet(EditorState.phrases)) return this.setState(state);
                (update = ViewUpdate.create(this, state, transactions)).flags |= focusFlag;
                let scrollTarget = this.viewState.scrollTarget;
                try {
                    this.updateState = 2;
                    for (let tr of transactions) {
                        var main, e;
                        scrollTarget = scrollTarget && scrollTarget.map(tr.changes), 
                        tr.scrollIntoView && (main = tr.state.selection["main"], 
                        scrollTarget = new ScrollTarget(main.empty ? main : EditorSelection.cursor(main.head, main.head > main.anchor ? -1 : 1)));
                        for (e of tr.effects) e.is(scrollIntoView$1) && (scrollTarget = e.value.clip(this.state));
                    }
                    this.viewState.update(update, scrollTarget), this.bidiCache = CachedOrder.update(this.bidiCache, update.changes), 
                    update.empty || (this.updatePlugins(update), this.inputState.update(update)), 
                    redrawn = this.docView.update(update), this.state.facet(styleModule) != this.styleModules && this.mountStyles(), 
                    attrsChanged = this.updateAttrs(), this.showAnnouncements(transactions), 
                    this.docView.updateSelection(redrawn, transactions.some(tr => tr.isUserEvent("select.pointer")));
                } finally {
                    this.updateState = 0;
                }
                if (update.startState.facet(theme) != update.state.facet(theme) && (this.viewState.mustMeasureContent = !0), 
                (redrawn || attrsChanged || scrollTarget || this.viewState.mustEnforceCursorAssoc || this.viewState.mustMeasureContent) && this.requestMeasure(), 
                redrawn && this.docViewUpdate(), !update.empty) for (var listener of this.state.facet(updateListener)) try {
                    listener(update);
                } catch (e) {
                    logException(this.state, e, "update listener");
                }
                (dispatchFocus || domChange) && Promise.resolve().then(() => {
                    dispatchFocus && this.state == dispatchFocus.startState && this.dispatch(dispatchFocus), 
                    domChange && !applyDOMChange(this, domChange) && pendingKey.force && dispatchKey(this.contentDOM, pendingKey.key, pendingKey.keyCode);
                });
            }
        }
        setState(newState) {
            if (0 != this.updateState) throw new Error("Calls to EditorView.setState are not allowed while an update is in progress");
            if (this.destroyed) this.viewState.state = newState; else {
                this.updateState = 2;
                var hadFocus = this.hasFocus;
                try {
                    for (var plugin of this.plugins) plugin.destroy(this);
                    this.viewState = new ViewState(newState), this.plugins = newState.facet(viewPlugin).map(spec => new PluginInstance(spec)), 
                    this.pluginMap.clear();
                    for (let plugin of this.plugins) plugin.update(this);
                    this.docView.destroy(), this.docView = new DocView(this), this.inputState.ensureHandlers(this.plugins), 
                    this.mountStyles(), this.updateAttrs(), this.bidiCache = [];
                } finally {
                    this.updateState = 0;
                }
                hadFocus && this.focus(), this.requestMeasure();
            }
        }
        updatePlugins(update) {
            var prevSpecs = update.startState.facet(viewPlugin), specs = update.state.facet(viewPlugin);
            if (prevSpecs != specs) {
                var spec, newPlugins = [];
                for (spec of specs) {
                    var found = prevSpecs.indexOf(spec);
                    found < 0 ? newPlugins.push(new PluginInstance(spec)) : ((found = this.plugins[found]).mustUpdate = update, 
                    newPlugins.push(found));
                }
                for (let plugin of this.plugins) plugin.mustUpdate != update && plugin.destroy(this);
                this.plugins = newPlugins, this.pluginMap.clear();
            } else for (var p of this.plugins) p.mustUpdate = update;
            for (let i = 0; i < this.plugins.length; i++) this.plugins[i].update(this);
            prevSpecs != specs && this.inputState.ensureHandlers(this.plugins);
        }
        docViewUpdate() {
            for (var plugin of this.plugins) {
                plugin = plugin.value;
                if (plugin && plugin.docViewUpdate) try {
                    plugin.docViewUpdate(this);
                } catch (e) {
                    logException(this.state, e, "doc view update listener");
                }
            }
        }
        measure(flush = !0) {
            if (!this.destroyed) if (-1 < this.measureScheduled && this.win.cancelAnimationFrame(this.measureScheduled), 
            this.observer.delayedAndroidKey) this.measureScheduled = -1, this.requestMeasure(); else {
                this.measureScheduled = 0, flush && this.observer.forceFlush();
                let updated = null, sDOM = this.scrollDOM, scrollTop = sDOM.scrollTop * this.scaleY, {
                    scrollAnchorPos,
                    scrollAnchorHeight
                } = this.viewState;
                1 < Math.abs(scrollTop - this.viewState.scrollTop) && (scrollAnchorHeight = -1), 
                this.viewState.scrollAnchorHeight = -1;
                try {
                    for (let i = 0; ;i++) {
                        scrollAnchorHeight < 0 && (scrollAnchorHeight = isScrolledToBottom(sDOM) ? (scrollAnchorPos = -1, 
                        this.viewState.heightMap.height) : (block = this.viewState.scrollAnchorAt(scrollTop), 
                        scrollAnchorPos = block.from, block.top)), this.updateState = 1;
                        var block, changed = this.viewState.measure(this);
                        if (!changed && !this.measureRequests.length && null == this.viewState.scrollTarget) break;
                        if (5 < i) {
                            console.warn(this.measureRequests.length ? "Measure loop restarted more than 5 times" : "Viewport failed to stabilize");
                            break;
                        }
                        let measuring = [];
                        4 & changed || ([ this.measureRequests, measuring ] = [ measuring, this.measureRequests ]);
                        var measured = measuring.map(m => {
                            try {
                                return m.read(this);
                            } catch (e) {
                                return logException(this.state, e), BadMeasure;
                            }
                        });
                        let update = ViewUpdate.create(this, this.state, []), redrawn = !1;
                        update.flags |= changed, updated ? updated.flags |= changed : updated = update, 
                        this.updateState = 2, !update.empty && (this.updatePlugins(update), 
                        this.inputState.update(update), this.updateAttrs(), redrawn = this.docView.update(update)) && this.docViewUpdate();
                        for (let i = 0; i < measuring.length; i++) if (measured[i] != BadMeasure) try {
                            var m = measuring[i];
                            m.write && m.write(measured[i], this);
                        } catch (e) {
                            logException(this.state, e);
                        }
                        if (redrawn && this.docView.updateSelection(!0), !update.viewportChanged && 0 == this.measureRequests.length) {
                            if (this.viewState.editorHeight) {
                                if (this.viewState.scrollTarget) {
                                    this.docView.scrollIntoView(this.viewState.scrollTarget), 
                                    this.viewState.scrollTarget = null, scrollAnchorHeight = -1;
                                    continue;
                                }
                                var diff = (scrollAnchorPos < 0 ? this.viewState.heightMap.height : this.viewState.lineBlockAt(scrollAnchorPos).top) - scrollAnchorHeight;
                                if (1 < diff || diff < -1) {
                                    scrollTop += diff, sDOM.scrollTop = scrollTop / this.scaleY, 
                                    scrollAnchorHeight = -1;
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                } finally {
                    this.updateState = 0, this.measureScheduled = -1;
                }
                if (updated && !updated.empty) for (var listener of this.state.facet(updateListener)) listener(updated);
            }
        }
        get themeClasses() {
            return baseThemeID + " " + (this.state.facet(darkTheme) ? baseDarkID : baseLightID) + " " + this.state.facet(theme);
        }
        updateAttrs() {
            let editorAttrs = attrsFromFacet(this, editorAttributes, {
                class: "cm-editor" + (this.hasFocus ? " cm-focused " : " ") + this.themeClasses
            }), contentAttrs = {
                spellcheck: "false",
                autocorrect: "off",
                autocapitalize: "off",
                writingsuggestions: "false",
                translate: "no",
                contenteditable: this.state.facet(editable) ? "true" : "false",
                class: "cm-content",
                style: browser.tabSize + ": " + this.state.tabSize,
                role: "textbox",
                "aria-multiline": "true"
            };
            this.state.readOnly && (contentAttrs["aria-readonly"] = "true"), attrsFromFacet(this, contentAttributes, contentAttrs);
            var changed = this.observer.ignore(() => {
                var changedContent = updateAttrs(this.contentDOM, this.contentAttrs, contentAttrs), changedEditor = updateAttrs(this.dom, this.editorAttrs, editorAttrs);
                return changedContent || changedEditor;
            });
            return this.editorAttrs = editorAttrs, this.contentAttrs = contentAttrs, 
            changed;
        }
        showAnnouncements(trs) {
            let first = !0;
            for (var tr of trs) for (var effect of tr.effects) effect.is(EditorView.announce) && (first && (this.announceDOM.textContent = ""), 
            first = !1, this.announceDOM.appendChild(document.createElement("div")).textContent = effect.value);
        }
        mountStyles() {
            this.styleModules = this.state.facet(styleModule);
            var nonce = this.state.facet(EditorView.cspNonce);
            StyleModule.mount(this.root, this.styleModules.concat(baseTheme$1$2).reverse(), nonce ? {
                nonce: nonce
            } : void 0);
        }
        readMeasured() {
            if (2 == this.updateState) throw new Error("Reading the editor layout isn't allowed during an update");
            0 == this.updateState && -1 < this.measureScheduled && this.measure(!1);
        }
        requestMeasure(request) {
            if (this.measureScheduled < 0 && (this.measureScheduled = this.win.requestAnimationFrame(() => this.measure())), 
            request && !(-1 < this.measureRequests.indexOf(request))) {
                if (null != request.key) for (let i = 0; i < this.measureRequests.length; i++) if (this.measureRequests[i].key === request.key) return void (this.measureRequests[i] = request);
                this.measureRequests.push(request);
            }
        }
        plugin(plugin) {
            let known = this.pluginMap.get(plugin);
            return (void 0 === known || known && known.plugin != plugin) && this.pluginMap.set(plugin, known = this.plugins.find(p => p.plugin == plugin) || null), 
            known && known.update(this).value;
        }
        get documentTop() {
            return this.contentDOM.getBoundingClientRect().top + this.viewState.paddingTop;
        }
        get documentPadding() {
            return {
                top: this.viewState.paddingTop,
                bottom: this.viewState.paddingBottom
            };
        }
        get scaleX() {
            return this.viewState.scaleX;
        }
        get scaleY() {
            return this.viewState.scaleY;
        }
        elementAtHeight(height) {
            return this.readMeasured(), this.viewState.elementAtHeight(height);
        }
        lineBlockAtHeight(height) {
            return this.readMeasured(), this.viewState.lineBlockAtHeight(height);
        }
        get viewportLineBlocks() {
            return this.viewState.viewportLines;
        }
        lineBlockAt(pos) {
            return this.viewState.lineBlockAt(pos);
        }
        get contentHeight() {
            return this.viewState.contentHeight;
        }
        moveByChar(start, forward, by) {
            return skipAtoms(this, start, moveByChar(this, start, forward, by));
        }
        moveByGroup(start, forward) {
            return skipAtoms(this, start, moveByChar(this, start, forward, initial => function(view, pos, start) {
                let categorize = view.state.charCategorizer(pos), cat = categorize(start);
                return next => {
                    next = categorize(next);
                    return (cat = cat == CharCategory.Space ? next : cat) == next;
                };
            }(this, start.head, initial)));
        }
        visualLineSide(line, end) {
            var order = this.bidiSpans(line), dir = this.textDirectionAt(line.from), order = order[end ? order.length - 1 : 0];
            return EditorSelection.cursor(order.side(end, dir) + line.from, order.forward(!end, dir) ? 1 : -1);
        }
        moveToLineBoundary(start, forward, includeWrap = !0) {
            return function(view, start, forward, includeWrap) {
                var line = blockAt(view, start.head, start.assoc || -1);
                if (includeWrap = includeWrap && line.type == BlockType.Text && (view.lineWrapping || line.widgetLineBreaks) ? view.coordsAtPos(start.assoc < 0 && start.head > line.from ? start.head - 1 : start.head) : null) {
                    var start = view.dom.getBoundingClientRect(), direction = view.textDirectionAt(line.from), view = view.posAtCoords({
                        x: forward == (direction == Direction.LTR) ? start.right - 1 : start.left + 1,
                        y: (includeWrap.top + includeWrap.bottom) / 2
                    });
                    if (null != view) return EditorSelection.cursor(view, forward ? -1 : 1);
                }
                return EditorSelection.cursor(forward ? line.to : line.from, forward ? -1 : 1);
            }(this, start, forward, includeWrap);
        }
        moveVertically(start, forward, distance) {
            return skipAtoms(this, start, function(view, start, forward, distance) {
                var startPos = start.head, dir = forward ? 1 : -1;
                if (startPos == (forward ? view.state.doc.length : 0)) return EditorSelection.cursor(startPos, start.assoc);
                let goal = start.goalColumn, startY;
                var rect = view.contentDOM.getBoundingClientRect(), forward = view.coordsAtPos(startPos, start.assoc || -1), start = view.documentTop, resolvedGoal = (startY = forward ? (null == goal && (goal = forward.left - rect.left), 
                dir < 0 ? forward.top : forward.bottom) : (forward = view.viewState.lineBlockAt(startPos), 
                null == goal && (goal = Math.min(rect.right - rect.left, view.defaultCharacterWidth * (startPos - forward.from))), 
                (dir < 0 ? forward.top : forward.bottom) + start), rect.left + goal), dist = null != distance ? distance : view.viewState.heightOracle.textHeight >> 1;
                for (let extra = 0; ;extra += 10) {
                    var charRect, curY = startY + (dist + extra) * dir, pos = posAtCoords(view, {
                        x: resolvedGoal,
                        y: curY
                    }, !1, dir);
                    if (curY < rect.top || curY > rect.bottom || (dir < 0 ? pos < startPos : startPos < pos)) return curY = !(charRect = view.docView.coordsForChar(pos)) || curY < charRect.top ? -1 : 1, 
                    EditorSelection.cursor(pos, curY, void 0, goal);
                }
            }(this, start, forward, distance));
        }
        domAtPos(pos) {
            return this.docView.domAtPos(pos);
        }
        posAtDOM(node, offset = 0) {
            return this.docView.posFromDOM(node, offset);
        }
        posAtCoords(coords, precise = !0) {
            return this.readMeasured(), posAtCoords(this, coords, precise);
        }
        coordsAtPos(pos, side = 1) {
            this.readMeasured();
            var line, order, rect = this.docView.coordsAt(pos, side);
            return rect && rect.left != rect.right ? (line = this.state.doc.lineAt(pos), 
            flattenRect(rect, (order = this.bidiSpans(line))[BidiSpan.find(order, pos - line.from, -1, side)].dir == Direction.LTR == 0 < side)) : rect;
        }
        coordsForChar(pos) {
            return this.readMeasured(), this.docView.coordsForChar(pos);
        }
        get defaultCharacterWidth() {
            return this.viewState.heightOracle.charWidth;
        }
        get defaultLineHeight() {
            return this.viewState.heightOracle.lineHeight;
        }
        get textDirection() {
            return this.viewState.defaultTextDirection;
        }
        textDirectionAt(pos) {
            return !this.state.facet(perLineTextDirection) || pos < this.viewport.from || pos > this.viewport.to ? this.textDirection : (this.readMeasured(), 
            this.docView.textDirectionAt(pos));
        }
        get lineWrapping() {
            return this.viewState.heightOracle.lineWrapping;
        }
        bidiSpans(line) {
            if (line.length > MaxBidiLine) return trivialOrder(line.length);
            let dir = this.textDirectionAt(line.from), isolates;
            for (var entry of this.bidiCache) if (entry.from == line.from && entry.dir == dir && (entry.fresh || function isolatesEq(a, b) {
                if (a.length == b.length) {
                    for (let i = 0; i < a.length; i++) {
                        var iA = a[i], iB = b[i];
                        if (iA.from != iB.from || iA.to != iB.to || iA.direction != iB.direction || !isolatesEq(iA.inner, iB.inner)) return;
                    }
                    return 1;
                }
            }(entry.isolates, isolates = getIsolatedRanges(this, line)))) return entry.order;
            isolates = isolates || getIsolatedRanges(this, line);
            var order = function(line, direction, isolates) {
                if (!line) return [ new BidiSpan(0, 0, direction == RTL ? 1 : 0) ];
                if (direction == LTR && !isolates.length && !BidiRE.test(line)) return trivialOrder(line.length);
                if (isolates.length) for (;line.length > types.length; ) types[types.length] = 256;
                var order = [], direction = direction == LTR ? 0 : 1;
                return computeSectionOrder(line, direction, direction, isolates, 0, line.length, order), 
                order;
            }(line.text, dir, isolates);
            return this.bidiCache.push(new CachedOrder(line.from, line.to, dir, isolates, !0, order)), 
            order;
        }
        get hasFocus() {
            var _a;
            return (this.dom.ownerDocument.hasFocus() || browser.safari && (null == (_a = this.inputState) ? void 0 : _a.lastContextMenu) > Date.now() - 3e4) && this.root.activeElement == this.contentDOM;
        }
        focus() {
            this.observer.ignore(() => {
                focusPreventScroll(this.contentDOM), this.docView.updateSelection();
            });
        }
        setRoot(root) {
            this._root != root && (this._root = root, this.observer.setWindow((9 == root.nodeType ? root : root.ownerDocument).defaultView || window), 
            this.mountStyles());
        }
        destroy() {
            this.root.activeElement == this.contentDOM && this.contentDOM.blur();
            for (var plugin of this.plugins) plugin.destroy(this);
            this.plugins = [], this.inputState.destroy(), this.docView.destroy(), 
            this.dom.remove(), this.observer.destroy(), -1 < this.measureScheduled && this.win.cancelAnimationFrame(this.measureScheduled), 
            this.destroyed = !0;
        }
        static scrollIntoView(pos, options = {}) {
            return scrollIntoView$1.of(new ScrollTarget("number" == typeof pos ? EditorSelection.cursor(pos) : pos, options.y, options.x, options.yMargin, options.xMargin));
        }
        scrollSnapshot() {
            var {
                scrollTop,
                scrollLeft
            } = this.scrollDOM, ref = this.viewState.scrollAnchorAt(scrollTop);
            return scrollIntoView$1.of(new ScrollTarget(EditorSelection.cursor(ref.from), "start", "start", ref.top - scrollTop, scrollLeft, !0));
        }
        setTabFocusMode(to) {
            null == to ? this.inputState.tabFocusMode = this.inputState.tabFocusMode < 0 ? 0 : -1 : "boolean" == typeof to ? this.inputState.tabFocusMode = to ? 0 : -1 : 0 != this.inputState.tabFocusMode && (this.inputState.tabFocusMode = Date.now() + to);
        }
        static domEventHandlers(handlers) {
            return ViewPlugin.define(() => ({}), {
                eventHandlers: handlers
            });
        }
        static domEventObservers(observers) {
            return ViewPlugin.define(() => ({}), {
                eventObservers: observers
            });
        }
        static theme(spec, options) {
            var prefix = StyleModule.newName(), prefix = [ theme.of(prefix), styleModule.of(buildTheme("." + prefix, spec)) ];
            return options && options.dark && prefix.push(darkTheme.of(!0)), prefix;
        }
        static baseTheme(spec) {
            return Prec.lowest(styleModule.of(buildTheme("." + baseThemeID, spec, lightDarkIDs)));
        }
        static findFromDOM(dom) {
            var content = dom.querySelector(".cm-content"), content = content && ContentView.get(content) || ContentView.get(dom);
            return (null == (dom = null == content ? void 0 : content.rootView) ? void 0 : dom.view) || null;
        }
    }
    EditorView.styleModule = styleModule, EditorView.inputHandler = inputHandler, 
    EditorView.clipboardInputFilter = clipboardInputFilter, EditorView.clipboardOutputFilter = clipboardOutputFilter, 
    EditorView.scrollHandler = scrollHandler, EditorView.focusChangeEffect = focusChangeEffect, 
    EditorView.perLineTextDirection = perLineTextDirection, EditorView.exceptionSink = exceptionSink, 
    EditorView.updateListener = updateListener, EditorView.editable = editable, 
    EditorView.mouseSelectionStyle = mouseSelectionStyle, EditorView.dragMovesSelection = dragMovesSelection$1, 
    EditorView.clickAddsSelectionRange = clickAddsSelectionRange, EditorView.decorations = decorations, 
    EditorView.outerDecorations = outerDecorations, EditorView.atomicRanges = atomicRanges, 
    EditorView.bidiIsolatedRanges = bidiIsolatedRanges, EditorView.scrollMargins = scrollMargins, 
    EditorView.darkTheme = darkTheme, EditorView.cspNonce = Facet.define({
        combine: values => values.length ? values[0] : ""
    }), EditorView.contentAttributes = contentAttributes, EditorView.editorAttributes = editorAttributes, 
    EditorView.lineWrapping = EditorView.contentAttributes.of({
        class: "cm-lineWrapping"
    }), EditorView.announce = StateEffect.define();
    const MaxBidiLine = 4096, BadMeasure = {};
    class CachedOrder {
        constructor(from, to, dir, isolates, fresh, order) {
            this.from = from, this.to = to, this.dir = dir, this.isolates = isolates, 
            this.fresh = fresh, this.order = order;
        }
        static update(cache, changes) {
            if (changes.empty && !cache.some(c => c.fresh)) return cache;
            var result = [], lastDir = cache.length ? cache[cache.length - 1].dir : Direction.LTR;
            for (let i = Math.max(0, cache.length - 10); i < cache.length; i++) {
                var entry = cache[i];
                entry.dir != lastDir || changes.touchesRange(entry.from, entry.to) || result.push(new CachedOrder(changes.mapPos(entry.from, 1), changes.mapPos(entry.to, -1), entry.dir, entry.isolates, !1, entry.order));
            }
            return result;
        }
    }
    function attrsFromFacet(view, facet, base) {
        for (let sources = view.state.facet(facet), i = sources.length - 1; 0 <= i; i--) {
            var source = sources[i], source = "function" == typeof source ? source(view) : source;
            source && combineAttrs(source, base);
        }
        return base;
    }
    const currentPlatform = browser.mac ? "mac" : browser.windows ? "win" : browser.linux ? "linux" : "key";
    function modifiers(name, event, shift) {
        return event.altKey && (name = "Alt-" + name), event.ctrlKey && (name = "Ctrl-" + name), 
        event.metaKey && (name = "Meta-" + name), name = !1 !== shift && event.shiftKey ? "Shift-" + name : name;
    }
    ie = Prec.default(EditorView.domEventHandlers({
        keydown(event, view) {
            return runHandlers(getKeymap(view.state), event, view, "editor");
        }
    }));
    const keymap = Facet.define({
        enables: ie
    }), Keymaps = new WeakMap();
    function getKeymap(state) {
        state = state.facet(keymap);
        let map = Keymaps.get(state);
        return map || Keymaps.set(state, map = function(bindings, platform = currentPlatform) {
            let bound = Object.create(null), isPrefix = Object.create(null), checkPrefix = (name, is) => {
                var current = isPrefix[name];
                if (null == current) isPrefix[name] = is; else if (current != is) throw new Error("Key binding " + name + " is used both as a regular binding and as a multi-stroke prefix");
            }, add = (scope, key, command, preventDefault, stopPropagation) => {
                var scopeObj = bound[scope] || (bound[scope] = Object.create(null)), parts = key.split(/ (?!$)/).map(k => function(name, platform) {
                    var parts = name.split(/-(?!$)/);
                    let result = parts[parts.length - 1];
                    "Space" == result && (result = " ");
                    let alt, ctrl, shift, meta;
                    for (let i = 0; i < parts.length - 1; ++i) {
                        var mod = parts[i];
                        if (/^(cmd|meta|m)$/i.test(mod)) meta = !0; else if (/^a(lt)?$/i.test(mod)) alt = !0; else if (/^(c|ctrl|control)$/i.test(mod)) ctrl = !0; else if (/^s(hift)?$/i.test(mod)) shift = !0; else {
                            if (!/^mod$/i.test(mod)) throw new Error("Unrecognized modifier name: " + mod);
                            "mac" == platform ? meta = !0 : ctrl = !0;
                        }
                    }
                    return alt && (result = "Alt-" + result), ctrl && (result = "Ctrl-" + result), 
                    meta && (result = "Meta-" + result), result = shift ? "Shift-" + result : result;
                }(k, platform));
                for (let i = 1; i < parts.length; i++) {
                    let prefix = parts.slice(0, i).join(" ");
                    checkPrefix(prefix, !0), scopeObj[prefix] || (scopeObj[prefix] = {
                        preventDefault: !0,
                        stopPropagation: !1,
                        run: [ view => {
                            let ourObj = storedPrefix = {
                                view: view,
                                prefix: prefix,
                                scope: scope
                            };
                            return setTimeout(() => {
                                storedPrefix == ourObj && (storedPrefix = null);
                            }, PrefixTimeout), !0;
                        } ]
                    });
                }
                var key = parts.join(" "), key = (checkPrefix(key, !1), scopeObj[key] || (scopeObj[key] = {
                    preventDefault: !1,
                    stopPropagation: !1,
                    run: (null == (key = null == (key = scopeObj._any) ? void 0 : key.run) ? void 0 : key.slice()) || []
                }));
                command && key.run.push(command), preventDefault && (key.preventDefault = !0), 
                stopPropagation && (key.stopPropagation = !0);
            };
            for (var b of bindings) {
                var scopes = b.scope ? b.scope.split(" ") : [ "editor" ];
                if (b.any) for (var scope of scopes) {
                    var key, scopeObj = bound[scope] || (bound[scope] = Object.create(null));
                    scopeObj._any || (scopeObj._any = {
                        preventDefault: !1,
                        stopPropagation: !1,
                        run: []
                    });
                    let any = b["any"];
                    for (key in scopeObj) scopeObj[key].run.push(view => any(view, currentKeyEvent));
                }
                var name = b[platform] || b.key;
                if (name) for (let scope of scopes) add(scope, name, b.run, b.preventDefault, b.stopPropagation), 
                b.shift && add(scope, "Shift-" + name, b.shift, b.preventDefault, b.stopPropagation);
            }
            return bound;
        }(state.reduce((a, b) => a.concat(b), []))), map;
    }
    let storedPrefix = null;
    const PrefixTimeout = 4e3;
    let currentKeyEvent = null;
    function runHandlers(map, event, view, scope) {
        var name = function(event) {
            return event = "Down" == (event = "Right" == (event = "Up" == (event = "Left" == (event = "Del" == (event = "Esc" == (event = !(mac && event.metaKey && event.shiftKey && !event.ctrlKey && !event.altKey || ie$1 && event.shiftKey && event.key && 1 == event.key.length || "Unidentified" == event.key) && event.key || (event.shiftKey ? shift : base)[event.keyCode] || event.key || "Unidentified") ? "Escape" : event) ? "Delete" : event) ? "ArrowLeft" : event) ? "ArrowUp" : event) ? "ArrowRight" : event) ? "ArrowDown" : event;
        }(currentKeyEvent = event), isChar = (codePointAt(name, 0) < 65536 ? 1 : 2) == name.length && " " != name;
        let prefix = "", handled = !1, prevented = !1, stopPropagation = !1, ran = (storedPrefix && storedPrefix.view == view && storedPrefix.scope == scope && (prefix = storedPrefix.prefix + " ", 
        modifierCodes.indexOf(event.keyCode) < 0) && (prevented = !0, storedPrefix = null), 
        new Set());
        var runFor = binding => {
            if (binding) {
                for (var cmd of binding.run) if (!ran.has(cmd) && (ran.add(cmd), 
                cmd(view))) return binding.stopPropagation && (stopPropagation = !0), 
                !0;
                binding.preventDefault && (binding.stopPropagation && (stopPropagation = !0), 
                prevented = !0);
            }
            return !1;
        };
        let scopeObj = map[scope], baseName, shiftName;
        return scopeObj && (runFor(scopeObj[prefix + modifiers(name, event, !isChar)]) ? handled = !0 : !isChar || !(event.altKey || event.metaKey || event.ctrlKey) || browser.windows && event.ctrlKey && event.altKey || browser.mac && event.altKey && !event.ctrlKey || !(baseName = base[event.keyCode]) || baseName == name ? isChar && event.shiftKey && runFor(scopeObj[prefix + modifiers(name, event, !0)]) && (handled = !0) : (runFor(scopeObj[prefix + modifiers(baseName, event, !0)]) || event.shiftKey && (shiftName = shift[event.keyCode]) != name && shiftName != baseName && runFor(scopeObj[prefix + modifiers(shiftName, event, !1)])) && (handled = !0), 
        !handled) && runFor(scopeObj._any) && (handled = !0), (handled = prevented ? !0 : handled) && stopPropagation && event.stopPropagation(), 
        currentKeyEvent = null, handled;
    }
    class RectangleMarker {
        constructor(className, left, top, width, height) {
            this.className = className, this.left = left, this.top = top, this.width = width, 
            this.height = height;
        }
        draw() {
            var elt = document.createElement("div");
            return elt.className = this.className, this.adjust(elt), elt;
        }
        update(elt, prev) {
            return prev.className == this.className && (this.adjust(elt), !0);
        }
        adjust(elt) {
            elt.style.left = this.left + "px", elt.style.top = this.top + "px", 
            null != this.width && (elt.style.width = this.width + "px"), elt.style.height = this.height + "px";
        }
        eq(p) {
            return this.left == p.left && this.top == p.top && this.width == p.width && this.height == p.height && this.className == p.className;
        }
        static forRange(view, className, range) {
            var pos, base;
            return range.empty ? (pos = view.coordsAtPos(range.head, range.assoc || 1)) ? (base = getBase(view), 
            [ new RectangleMarker(className, pos.left - base.left, pos.top - base.top, null, pos.bottom - pos.top) ]) : [] : function(view, className, range) {
                if (range.to <= view.viewport.from || range.from >= view.viewport.to) return [];
                let from = Math.max(range.from, view.viewport.from), to = Math.min(range.to, view.viewport.to), ltr = view.textDirection == Direction.LTR, content = view.contentDOM, contentRect = content.getBoundingClientRect(), base = getBase(view), lineElt = content.querySelector(".cm-line"), lineStyle = lineElt && window.getComputedStyle(lineElt), leftSide = contentRect.left + (lineStyle ? parseInt(lineStyle.paddingLeft) + Math.min(0, parseInt(lineStyle.textIndent)) : 0), rightSide = contentRect.right - (lineStyle ? parseInt(lineStyle.paddingRight) : 0), startBlock = blockAt(view, from, 1), endBlock = blockAt(view, to, -1), visualStart = startBlock.type == BlockType.Text ? startBlock : null, visualEnd = endBlock.type == BlockType.Text ? endBlock : null;
                visualStart && (view.lineWrapping || startBlock.widgetLineBreaks) && (visualStart = wrappedLine(view, from, 1, visualStart));
                visualEnd && (view.lineWrapping || endBlock.widgetLineBreaks) && (visualEnd = wrappedLine(view, to, -1, visualEnd));
                {
                    var top, between;
                    return visualStart && visualEnd && visualStart.from == visualEnd.from && visualStart.to == visualEnd.to ? pieces(drawForLine(range.from, range.to, visualStart)) : (top = visualStart ? drawForLine(range.from, null, visualStart) : drawForWidget(startBlock, !1), 
                    range = visualEnd ? drawForLine(null, range.to, visualEnd) : drawForWidget(endBlock, !0), 
                    between = [], (visualStart || startBlock).to < (visualEnd || endBlock).from - (visualStart && visualEnd ? 1 : 0) || 1 < startBlock.widgetLineBreaks && top.bottom + view.defaultLineHeight / 2 < range.top ? between.push(piece(leftSide, top.bottom, rightSide, range.top)) : top.bottom < range.top && view.elementAtHeight((top.bottom + range.top) / 2).type == BlockType.Text && (top.bottom = range.top = (top.bottom + range.top) / 2), 
                    pieces(top).concat(between).concat(pieces(range)));
                }
                function piece(left, top, right, bottom) {
                    return new RectangleMarker(className, left - base.left, top - base.top, right - left, bottom - top);
                }
                function pieces({
                    top,
                    bottom,
                    horizontal
                }) {
                    var pieces = [];
                    for (let i = 0; i < horizontal.length; i += 2) pieces.push(piece(horizontal[i], top, horizontal[i + 1], bottom));
                    return pieces;
                }
                function drawForLine(from, to, line) {
                    let top = 1e9, bottom = -1e9, horizontal = [];
                    function addSpan(from, fromOpen, to, toOpen, dir) {
                        from = view.coordsAtPos(from, from == line.to ? -2 : 2), 
                        to = view.coordsAtPos(to, to == line.from ? 2 : -2);
                        from && to && (top = Math.min(from.top, to.top, top), bottom = Math.max(from.bottom, to.bottom, bottom), 
                        dir == Direction.LTR ? horizontal.push(ltr && fromOpen ? leftSide : from.left, ltr && toOpen ? rightSide : to.right) : horizontal.push(!ltr && toOpen ? leftSide : to.left, !ltr && fromOpen ? rightSide : from.right));
                    }
                    var r, start = null != from ? from : line.from, end = null != to ? to : line.to;
                    for (r of view.visibleRanges) if (r.to > start && r.from < end) for (let pos = Math.max(r.from, start), endPos = Math.min(r.to, end); ;) {
                        var span, docLine = view.state.doc.lineAt(pos);
                        for (span of view.bidiSpans(docLine)) {
                            var spanFrom = span.from + docLine.from, spanTo = span.to + docLine.from;
                            if (endPos <= spanFrom) break;
                            spanTo > pos && addSpan(Math.max(spanFrom, pos), null == from && spanFrom <= start, Math.min(spanTo, endPos), null == to && end <= spanTo, span.dir);
                        }
                        if ((pos = docLine.to + 1) >= endPos) break;
                    }
                    return 0 == horizontal.length && addSpan(start, null == from, end, null == to, view.textDirection), 
                    {
                        top: top,
                        bottom: bottom,
                        horizontal: horizontal
                    };
                }
                function drawForWidget(block, top) {
                    top = contentRect.top + (top ? block.top : block.bottom);
                    return {
                        top: top,
                        bottom: top,
                        horizontal: []
                    };
                }
            }(view, className, range);
        }
    }
    function getBase(view) {
        var rect = view.scrollDOM.getBoundingClientRect();
        return {
            left: (view.textDirection == Direction.LTR ? rect.left : rect.right - view.scrollDOM.clientWidth * view.scaleX) - view.scrollDOM.scrollLeft * view.scaleX,
            top: rect.top - view.scrollDOM.scrollTop * view.scaleY
        };
    }
    function wrappedLine(view, pos, side, inside) {
        var left, pos = view.coordsAtPos(pos, 2 * side);
        return !pos || (side = view.dom.getBoundingClientRect(), pos = (pos.top + pos.bottom) / 2, 
        left = view.posAtCoords({
            x: side.left + 1,
            y: pos
        }), view = view.posAtCoords({
            x: side.right - 1,
            y: pos
        }), null == left) || null == view ? inside : {
            from: Math.max(inside.from, Math.min(left, view)),
            to: Math.min(inside.to, Math.max(left, view))
        };
    }
    class LayerView {
        constructor(view, layer) {
            this.view = view, this.layer = layer, this.drawn = [], this.scaleX = 1, 
            this.scaleY = 1, this.measureReq = {
                read: this.measure.bind(this),
                write: this.draw.bind(this)
            }, this.dom = view.scrollDOM.appendChild(document.createElement("div")), 
            this.dom.classList.add("cm-layer"), layer.above && this.dom.classList.add("cm-layer-above"), 
            layer.class && this.dom.classList.add(layer.class), this.scale(), this.dom.setAttribute("aria-hidden", "true"), 
            this.setOrder(view.state), view.requestMeasure(this.measureReq), layer.mount && layer.mount(this.dom, view);
        }
        update(update) {
            update.startState.facet(layerOrder) != update.state.facet(layerOrder) && this.setOrder(update.state), 
            (this.layer.update(update, this.dom) || update.geometryChanged) && (this.scale(), 
            update.view.requestMeasure(this.measureReq));
        }
        docViewUpdate(view) {
            !1 !== this.layer.updateOnDocViewUpdate && view.requestMeasure(this.measureReq);
        }
        setOrder(state) {
            let pos = 0, order = state.facet(layerOrder);
            for (;pos < order.length && order[pos] != this.layer; ) pos++;
            this.dom.style.zIndex = String((this.layer.above ? 150 : -1) - pos);
        }
        measure() {
            return this.layer.markers(this.view);
        }
        scale() {
            var {
                scaleX,
                scaleY
            } = this.view;
            scaleX == this.scaleX && scaleY == this.scaleY || (this.scaleX = scaleX, 
            this.scaleY = scaleY, this.dom.style.transform = `scale(${1 / scaleX}, ${1 / scaleY})`);
        }
        draw(markers) {
            if (markers.length != this.drawn.length || markers.some((p, i) => {
                return p = p, i = this.drawn[i], !(p.constructor == i.constructor && p.eq(i));
            })) {
                let old = this.dom.firstChild, oldI = 0;
                for (var marker of markers) marker.update && old && marker.constructor && this.drawn[oldI].constructor && marker.update(old, this.drawn[oldI]) ? (old = old.nextSibling, 
                oldI++) : this.dom.insertBefore(marker.draw(), old);
                for (;old; ) {
                    var next = old.nextSibling;
                    old.remove(), old = next;
                }
                this.drawn = markers;
            }
        }
        destroy() {
            this.layer.destroy && this.layer.destroy(this.dom, this.view), this.dom.remove();
        }
    }
    const layerOrder = Facet.define();
    function layer(config) {
        return [ ViewPlugin.define(v => new LayerView(v, config)), layerOrder.of(config) ];
    }
    const selectionConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                cursorBlinkRate: 1200,
                drawRangeCursor: !0
            }, {
                cursorBlinkRate: (a, b) => Math.min(a, b),
                drawRangeCursor: (a, b) => a || b
            });
        }
    });
    function configChanged(update) {
        return update.startState.facet(selectionConfig) != update.state.facet(selectionConfig);
    }
    const cursorLayer = layer({
        above: !0,
        markers(view) {
            var r, state = view["state"], conf = state.facet(selectionConfig), cursors = [];
            for (r of state.selection.ranges) {
                var prim = r == state.selection.main;
                if (r.empty || conf.drawRangeCursor) {
                    var piece, prim = prim ? "cm-cursor cm-cursor-primary" : "cm-cursor cm-cursor-secondary", cursor = r.empty ? r : EditorSelection.cursor(r.head, r.head > r.anchor ? -1 : 1);
                    for (piece of RectangleMarker.forRange(view, prim, cursor)) cursors.push(piece);
                }
            }
            return cursors;
        },
        update(update, dom) {
            update.transactions.some(tr => tr.selection) && (dom.style.animationName = "cm-blink" == dom.style.animationName ? "cm-blink2" : "cm-blink");
            var confChange = configChanged(update);
            return confChange && setBlinkRate(update.state, dom), update.docChanged || update.selectionSet || confChange;
        },
        mount(dom, view) {
            setBlinkRate(view.state, dom);
        },
        class: "cm-cursorLayer"
    });
    function setBlinkRate(state, dom) {
        dom.style.animationDuration = state.facet(selectionConfig).cursorBlinkRate + "ms";
    }
    const selectionLayer = layer({
        above: !1,
        markers(view) {
            return view.state.selection.ranges.map(r => r.empty ? [] : RectangleMarker.forRange(view, "cm-selectionBackground", r)).reduce((a, b) => a.concat(b));
        },
        update(update, dom) {
            return update.docChanged || update.selectionSet || update.viewportChanged || configChanged(update);
        },
        class: "cm-selectionLayer"
    }), hideNativeSelection = Prec.highest(EditorView.theme({
        ".cm-line": {
            "& ::selection, &::selection": {
                backgroundColor: "transparent !important"
            },
            caretColor: "transparent !important"
        },
        ".cm-content": {
            caretColor: "transparent !important",
            "& :focus": {
                caretColor: "initial !important",
                "&::selection, & ::selection": {
                    backgroundColor: "Highlight !important"
                }
            }
        }
    })), setDropCursorPos = StateEffect.define({
        map(pos, mapping) {
            return null == pos ? null : mapping.mapPos(pos);
        }
    }), dropCursorPos = StateField.define({
        create() {
            return null;
        },
        update(pos, tr) {
            return null != pos && (pos = tr.changes.mapPos(pos)), tr.effects.reduce((pos, e) => e.is(setDropCursorPos) ? e.value : pos, pos);
        }
    }), drawDropCursor = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.cursor = null, this.measureReq = {
                read: this.readPos.bind(this),
                write: this.drawCursor.bind(this)
            };
        }
        update(update) {
            var _a, cursorPos = update.state.field(dropCursorPos);
            null == cursorPos ? null != this.cursor && (null != (_a = this.cursor) && _a.remove(), 
            this.cursor = null) : (this.cursor || (this.cursor = this.view.scrollDOM.appendChild(document.createElement("div")), 
            this.cursor.className = "cm-dropCursor"), (update.startState.field(dropCursorPos) != cursorPos || update.docChanged || update.geometryChanged) && this.view.requestMeasure(this.measureReq));
        }
        readPos() {
            var outer, view = this["view"], pos = view.state.field(dropCursorPos), pos = null != pos && view.coordsAtPos(pos);
            return pos ? (outer = view.scrollDOM.getBoundingClientRect(), {
                left: pos.left - outer.left + view.scrollDOM.scrollLeft * view.scaleX,
                top: pos.top - outer.top + view.scrollDOM.scrollTop * view.scaleY,
                height: pos.bottom - pos.top
            }) : null;
        }
        drawCursor(pos) {
            var scaleX, scaleY;
            this.cursor && ({
                scaleX,
                scaleY
            } = this.view, pos ? (this.cursor.style.left = pos.left / scaleX + "px", 
            this.cursor.style.top = pos.top / scaleY + "px", this.cursor.style.height = pos.height / scaleY + "px") : this.cursor.style.left = "-100000px");
        }
        destroy() {
            this.cursor && this.cursor.remove();
        }
        setDropPos(pos) {
            this.view.state.field(dropCursorPos) != pos && this.view.dispatch({
                effects: setDropCursorPos.of(pos)
            });
        }
    }, {
        eventObservers: {
            dragover(event) {
                this.setDropPos(this.view.posAtCoords({
                    x: event.clientX,
                    y: event.clientY
                }));
            },
            dragleave(event) {
                event.target != this.view.contentDOM && this.view.contentDOM.contains(event.relatedTarget) || this.setDropPos(null);
            },
            dragend() {
                this.setDropPos(null);
            },
            drop() {
                this.setDropPos(null);
            }
        }
    });
    function iterMatches(doc, re, from, to, f) {
        re.lastIndex = 0;
        for (let cursor = doc.iterRange(from, to), pos = from, m; !cursor.next().done; pos += cursor.value.length) if (!cursor.lineBreak) for (;m = re.exec(cursor.value); ) f(pos + m.index, m);
    }
    class MatchDecorator {
        constructor(config) {
            const {
                regexp,
                decoration,
                decorate,
                boundary,
                maxLength = 1e3
            } = config;
            if (!regexp.global) throw new RangeError("The regular expression given to MatchDecorator should have its 'g' flag set");
            if (this.regexp = regexp, decorate) this.addMatch = (match, view, from, add) => decorate(add, from, from + match[0].length, match, view); else if ("function" == typeof decoration) this.addMatch = (match, view, from, add) => {
                view = decoration(match, view, from);
                view && add(from, from + match[0].length, view);
            }; else {
                if (!decoration) throw new RangeError("Either 'decorate' or 'decoration' should be provided to MatchDecorator");
                this.addMatch = (match, _view, from, add) => add(from, from + match[0].length, decoration);
            }
            this.boundary = boundary, this.maxLength = maxLength;
        }
        createDeco(view) {
            let build = new RangeSetBuilder(), add = build.add.bind(build);
            for (var {
                from,
                to
            } of function(view, maxLength) {
                var visible = view.visibleRanges;
                if (1 == visible.length && visible[0].from == view.viewport.from && visible[0].to == view.viewport.to) return visible;
                var from, to, result = [];
                for ({
                    from,
                    to
                } of visible) from = Math.max(view.state.doc.lineAt(from).from, from - maxLength), 
                to = Math.min(view.state.doc.lineAt(to).to, to + maxLength), result.length && result[result.length - 1].to >= from ? result[result.length - 1].to = to : result.push({
                    from: from,
                    to: to
                });
                return result;
            }(view, this.maxLength)) iterMatches(view.state.doc, this.regexp, from, to, (from, m) => this.addMatch(m, view, from, add));
            return build.finish();
        }
        updateDeco(update, deco) {
            let changeFrom = 1e9, changeTo = -1;
            return update.docChanged && update.changes.iterChanges((_f, _t, from, to) => {
                to >= update.view.viewport.from && from <= update.view.viewport.to && (changeFrom = Math.min(from, changeFrom), 
                changeTo = Math.max(to, changeTo));
            }), update.viewportMoved || 1e3 < changeTo - changeFrom ? this.createDeco(update.view) : -1 < changeTo ? this.updateRange(update.view, deco.map(update.changes), changeFrom, changeTo) : deco;
        }
        updateRange(view, deco, updateFrom, updateTo) {
            for (var r of view.visibleRanges) {
                let from = Math.max(r.from, updateFrom), to = Math.min(r.to, updateTo);
                if (to >= from) {
                    var fromLine = view.state.doc.lineAt(from), toLine = fromLine.to < to ? view.state.doc.lineAt(to) : fromLine;
                    let start = Math.max(r.from, fromLine.from), end = Math.min(r.to, toLine.to);
                    if (this.boundary) {
                        for (;from > fromLine.from; from--) if (this.boundary.test(fromLine.text[from - 1 - fromLine.from])) {
                            start = from;
                            break;
                        }
                        for (;to < toLine.to; to++) if (this.boundary.test(toLine.text[to - toLine.from])) {
                            end = to;
                            break;
                        }
                    }
                    let ranges = [], m, add = (from, to, deco) => ranges.push(deco.range(from, to));
                    if (fromLine == toLine) for (this.regexp.lastIndex = start - fromLine.from; (m = this.regexp.exec(fromLine.text)) && m.index < end - fromLine.from; ) this.addMatch(m, view, m.index + fromLine.from, add); else iterMatches(view.state.doc, this.regexp, start, end, (from, m) => this.addMatch(m, view, from, add));
                    deco = deco.update({
                        filterFrom: start,
                        filterTo: end,
                        filter: (from, to) => from < start || to > end,
                        add: ranges
                    });
                }
            }
            return deco;
        }
    }
    const UnicodeRegexpSupport = null != /x/.unicode ? "gu" : "g", Specials = new RegExp("[\0-\b\n-\x1f\x7f-\x9f\xad\u061c\u200b\u200e\u200f\u2028\u2029\u202d\u202e\u2066\u2067\u2069\ufeff\ufff9-\ufffc]", UnicodeRegexpSupport), Names = {
        0: "null",
        7: "bell",
        8: "backspace",
        10: "newline",
        11: "vertical tab",
        13: "carriage return",
        27: "escape",
        8203: "zero width space",
        8204: "zero width non-joiner",
        8205: "zero width joiner",
        8206: "left-to-right mark",
        8207: "right-to-left mark",
        8232: "line separator",
        8237: "left-to-right override",
        8238: "right-to-left override",
        8294: "left-to-right isolate",
        8295: "right-to-left isolate",
        8297: "pop directional isolate",
        8233: "paragraph separator",
        65279: "zero width no-break space",
        65532: "object replacement"
    };
    let _supportsTabSize = null;
    const specialCharConfig = Facet.define({
        combine(configs) {
            var _a, styles, configs = combineConfig(configs, {
                render: null,
                specialChars: Specials,
                addSpecialChars: null
            });
            return (configs.replaceTabs = (null == _supportsTabSize && "undefined" != typeof document && document.body && (styles = document.body.style, 
            _supportsTabSize = null != (null != (_a = styles.tabSize) ? _a : styles.MozTabSize)), 
            !_supportsTabSize)) && (configs.specialChars = new RegExp("\t|" + configs.specialChars.source, UnicodeRegexpSupport)), 
            configs.addSpecialChars && (configs.specialChars = new RegExp(configs.specialChars.source + "|" + configs.addSpecialChars.source, UnicodeRegexpSupport)), 
            configs;
        }
    });
    let _plugin = null;
    class SpecialCharWidget extends WidgetType {
        constructor(options, code) {
            super(), this.options = options, this.code = code;
        }
        eq(other) {
            return other.code == this.code;
        }
        toDOM(view) {
            var code = 32 <= (code = this.code) ? "\u2022" : 10 == code ? "\u2424" : String.fromCharCode(9216 + code), view = view.state.phrase("Control character") + " " + (Names[this.code] || "0x" + this.code.toString(16)), custom = this.options.render && this.options.render(this.code, view, code);
            return custom || ((custom = document.createElement("span")).textContent = code, 
            custom.title = view, custom.setAttribute("aria-label", view), custom.className = "cm-specialChar", 
            custom);
        }
        ignoreEvent() {
            return !1;
        }
    }
    class TabWidget extends WidgetType {
        constructor(width) {
            super(), this.width = width;
        }
        eq(other) {
            return other.width == this.width;
        }
        toDOM() {
            var span = document.createElement("span");
            return span.textContent = "\t", span.className = "cm-tab", span.style.width = this.width + "px", 
            span;
        }
        ignoreEvent() {
            return !1;
        }
    }
    const lineDeco = Decoration.line({
        class: "cm-activeLine"
    }), activeLineHighlighter = ViewPlugin.fromClass(class {
        constructor(view) {
            this.decorations = this.getDeco(view);
        }
        update(update) {
            (update.docChanged || update.selectionSet) && (this.decorations = this.getDeco(update.view));
        }
        getDeco(view) {
            let lastLineStart = -1, deco = [];
            for (var r of view.state.selection.ranges) {
                r = view.lineBlockAt(r.head);
                r.from > lastLineStart && (deco.push(lineDeco.range(r.from)), lastLineStart = r.from);
            }
            return Decoration.set(deco);
        }
    }, {
        decorations: v => v.decorations
    }), MaxOff = 2e3;
    function getPos(view, event) {
        var offset = view.posAtCoords({
            x: event.clientX,
            y: event.clientY
        }, !1), line = view.state.doc.lineAt(offset), off = offset - line.from, event = off > MaxOff ? -1 : off == line.length ? function(view, x) {
            var ref = view.coordsAtPos(view.viewport.from);
            return ref ? Math.round(Math.abs((ref.left - x) / view.defaultCharacterWidth)) : -1;
        }(view, event.clientX) : countColumn(line.text, view.state.tabSize, offset - line.from);
        return {
            line: line.number,
            col: event,
            off: off
        };
    }
    function rectangleSelectionStyle(view, event) {
        let start = getPos(view, event), startSel = view.state.selection;
        return start ? {
            update(update) {
                var newStart;
                update.docChanged && (newStart = update.changes.mapPos(update.startState.doc.line(start.line).from), 
                newStart = update.state.doc.lineAt(newStart), start = {
                    line: newStart.number,
                    col: start.col,
                    off: Math.min(start.off, newStart.length)
                }, startSel = startSel.map(update.changes));
            },
            get(event, _extend, multiple) {
                var event = getPos(view, event);
                return event && (event = function(state, a, b) {
                    var startLine = Math.min(a.line, b.line), endLine = Math.max(a.line, b.line), ranges = [];
                    if (a.off > MaxOff || b.off > MaxOff || a.col < 0 || b.col < 0) {
                        var startOff = Math.min(a.off, b.off), endOff = Math.max(a.off, b.off);
                        for (let i = startLine; i <= endLine; i++) {
                            var line = state.doc.line(i);
                            line.length <= endOff && ranges.push(EditorSelection.range(line.from + startOff, line.to + endOff));
                        }
                    } else {
                        var startCol = Math.min(a.col, b.col), endCol = Math.max(a.col, b.col);
                        for (let i = startLine; i <= endLine; i++) {
                            let line = state.doc.line(i);
                            var end, start = findColumn(line.text, startCol, state.tabSize, !0);
                            start < 0 ? ranges.push(EditorSelection.cursor(line.to)) : (end = findColumn(line.text, endCol, state.tabSize), 
                            ranges.push(EditorSelection.range(line.from + start, line.from + end)));
                        }
                    }
                    return ranges;
                }(view.state, start, event)).length ? multiple ? EditorSelection.create(event.concat(startSel.ranges)) : EditorSelection.create(event) : startSel;
            }
        } : null;
    }
    const keys = {
        Alt: [ 18, e => !!e.altKey ],
        Control: [ 17, e => !!e.ctrlKey ],
        Shift: [ 16, e => !!e.shiftKey ],
        Meta: [ 91, e => !!e.metaKey ]
    }, showCrosshair = {
        style: "cursor: crosshair"
    };
    class TooltipViewManager {
        constructor(view, facet, createTooltipView, removeTooltipView) {
            this.facet = facet, this.createTooltipView = createTooltipView, this.removeTooltipView = removeTooltipView, 
            this.input = view.state.facet(facet), this.tooltips = this.input.filter(t => t);
            let prev = null;
            this.tooltipViews = this.tooltips.map(t => prev = createTooltipView(t, prev));
        }
        update(update, above) {
            var _a, input = update.state.facet(this.facet), tooltips = input.filter(x => x);
            if (input === this.input) {
                for (var t of this.tooltipViews) t.update && t.update(update);
                return !1;
            }
            var tooltipView, tooltipViews = [], newAbove = above ? [] : null;
            for (let i = 0; i < tooltips.length; i++) {
                let tip = tooltips[i], known = -1;
                if (tip) {
                    for (let i = 0; i < this.tooltips.length; i++) {
                        var other = this.tooltips[i];
                        other && other.create == tip.create && (known = i);
                    }
                    known < 0 ? (tooltipViews[i] = this.createTooltipView(tip, i ? tooltipViews[i - 1] : null), 
                    newAbove && (newAbove[i] = !!tip.above)) : (tooltipView = tooltipViews[i] = this.tooltipViews[known], 
                    newAbove && (newAbove[i] = above[known]), tooltipView.update && tooltipView.update(update));
                }
            }
            for (let t of this.tooltipViews) tooltipViews.indexOf(t) < 0 && (this.removeTooltipView(t), 
            null != (_a = t.destroy)) && _a.call(t);
            return above && (newAbove.forEach((val, i) => above[i] = val), above.length = newAbove.length), 
            this.input = input, this.tooltips = tooltips, this.tooltipViews = tooltipViews, 
            !0;
        }
    }
    function windowSpace(view) {
        view = view.dom.ownerDocument.documentElement;
        return {
            top: 0,
            left: 0,
            bottom: view.clientHeight,
            right: view.clientWidth
        };
    }
    const tooltipConfig = Facet.define({
        combine: values => {
            var _a;
            return {
                position: browser.ios ? "absolute" : (null == (_a = values.find(conf => conf.position)) ? void 0 : _a.position) || "fixed",
                parent: (null == (_a = values.find(conf => conf.parent)) ? void 0 : _a.parent) || null,
                tooltipSpace: (null == (_a = values.find(conf => conf.tooltipSpace)) ? void 0 : _a.tooltipSpace) || windowSpace
            };
        }
    }), knownHeight = new WeakMap(), tooltipPlugin = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.above = [], this.inView = !0, this.madeAbsolute = !1, 
            this.lastTransaction = 0, this.measureTimeout = -1;
            var config = view.state.facet(tooltipConfig);
            this.position = config.position, this.parent = config.parent, this.classes = view.themeClasses, 
            this.createContainer(), this.measureReq = {
                read: this.readMeasure.bind(this),
                write: this.writeMeasure.bind(this),
                key: this
            }, this.resizeObserver = "function" == typeof ResizeObserver ? new ResizeObserver(() => this.measureSoon()) : null, 
            this.manager = new TooltipViewManager(view, showTooltip, (t, p) => this.createTooltip(t, p), t => {
                this.resizeObserver && this.resizeObserver.unobserve(t.dom), t.dom.remove();
            }), this.above = this.manager.tooltips.map(t => !!t.above), this.intersectionObserver = "function" == typeof IntersectionObserver ? new IntersectionObserver(entries => {
                Date.now() > this.lastTransaction - 50 && 0 < entries.length && entries[entries.length - 1].intersectionRatio < 1 && this.measureSoon();
            }, {
                threshold: [ 1 ]
            }) : null, this.observeIntersection(), view.win.addEventListener("resize", this.measureSoon = this.measureSoon.bind(this)), 
            this.maybeMeasure();
        }
        createContainer() {
            this.parent ? (this.container = document.createElement("div"), this.container.style.position = "relative", 
            this.container.className = this.view.themeClasses, this.parent.appendChild(this.container)) : this.container = this.view.dom;
        }
        observeIntersection() {
            if (this.intersectionObserver) {
                this.intersectionObserver.disconnect();
                for (var tooltip of this.manager.tooltipViews) this.intersectionObserver.observe(tooltip.dom);
            }
        }
        measureSoon() {
            this.measureTimeout < 0 && (this.measureTimeout = setTimeout(() => {
                this.measureTimeout = -1, this.maybeMeasure();
            }, 50));
        }
        update(update) {
            update.transactions.length && (this.lastTransaction = Date.now());
            var updated = this.manager.update(update, this.above);
            updated && this.observeIntersection();
            let shouldMeasure = updated || update.geometryChanged;
            updated = update.state.facet(tooltipConfig);
            if (updated.position != this.position && !this.madeAbsolute) {
                this.position = updated.position;
                for (var t of this.manager.tooltipViews) t.dom.style.position = this.position;
                shouldMeasure = !0;
            }
            if (updated.parent != this.parent) {
                this.parent && this.container.remove(), this.parent = updated.parent, 
                this.createContainer();
                for (let t of this.manager.tooltipViews) this.container.appendChild(t.dom);
                shouldMeasure = !0;
            } else this.parent && this.view.themeClasses != this.classes && (this.classes = this.container.className = this.view.themeClasses);
            shouldMeasure && this.maybeMeasure();
        }
        createTooltip(tooltip, prev) {
            var tooltipView = tooltip.create(this.view), prev = prev ? prev.dom : null;
            return tooltipView.dom.classList.add("cm-tooltip"), tooltip.arrow && !tooltipView.dom.querySelector(".cm-tooltip > .cm-tooltip-arrow") && ((tooltip = document.createElement("div")).className = "cm-tooltip-arrow", 
            tooltipView.dom.appendChild(tooltip)), tooltipView.dom.style.position = this.position, 
            tooltipView.dom.style.top = "-10000px", tooltipView.dom.style.left = "0px", 
            this.container.insertBefore(tooltipView.dom, prev), tooltipView.mount && tooltipView.mount(this.view), 
            this.resizeObserver && this.resizeObserver.observe(tooltipView.dom), 
            tooltipView;
        }
        destroy() {
            var _a, _b, tooltipView;
            this.view.win.removeEventListener("resize", this.measureSoon);
            for (tooltipView of this.manager.tooltipViews) tooltipView.dom.remove(), 
            null != (_a = tooltipView.destroy) && _a.call(tooltipView);
            this.parent && this.container.remove(), null != (_b = this.resizeObserver) && _b.disconnect(), 
            null != (_b = this.intersectionObserver) && _b.disconnect(), clearTimeout(this.measureTimeout);
        }
        readMeasure() {
            let scaleX = 1, scaleY = 1, makeAbsolute = !1;
            if ("fixed" == this.position && this.manager.tooltipViews.length && (dom = this.manager.tooltipViews[0]["dom"], 
            browser.gecko ? makeAbsolute = dom.offsetParent != this.container.ownerDocument.body : "-10000px" == dom.style.top && "0px" == dom.style.left && (dom = dom.getBoundingClientRect(), 
            makeAbsolute = 1 < Math.abs(dom.top + 1e4) || 1 < Math.abs(dom.left))), 
            makeAbsolute || "absolute" == this.position) if (this.parent) {
                let rect = this.parent.getBoundingClientRect();
                rect.width && rect.height && (scaleX = rect.width / this.parent.offsetWidth, 
                scaleY = rect.height / this.parent.offsetHeight);
            } else ({
                scaleX,
                scaleY
            } = this.view.viewState);
            var dom = this.view.scrollDOM.getBoundingClientRect(), margins = getScrollMargins(this.view);
            return {
                visible: {
                    left: dom.left + margins.left,
                    top: dom.top + margins.top,
                    right: dom.right - margins.right,
                    bottom: dom.bottom - margins.bottom
                },
                parent: (this.parent ? this.container : this.view.dom).getBoundingClientRect(),
                pos: this.manager.tooltips.map((t, i) => {
                    i = this.manager.tooltipViews[i];
                    return i.getCoords ? i.getCoords(t.pos) : this.view.coordsAtPos(t.pos);
                }),
                size: this.manager.tooltipViews.map(({
                    dom
                }) => dom.getBoundingClientRect()),
                space: this.view.state.facet(tooltipConfig).tooltipSpace(this.view),
                scaleX: scaleX,
                scaleY: scaleY,
                makeAbsolute: makeAbsolute
            };
        }
        writeMeasure(measured) {
            if (measured.makeAbsolute) {
                this.madeAbsolute = !0, this.position = "absolute";
                for (var t of this.manager.tooltipViews) t.dom.style.position = "absolute";
            }
            var {
                visible,
                space,
                scaleX,
                scaleY
            } = measured, others = [];
            for (let i = 0; i < this.manager.tooltips.length; i++) {
                var tooltip = this.manager.tooltips[i], tView = this.manager.tooltipViews[i], dom = tView["dom"], pos = measured.pos[i], size = measured.size[i];
                if (!pos || !1 !== tooltip.clip && (pos.bottom <= Math.max(visible.top, space.top) || pos.top >= Math.min(visible.bottom, space.bottom) || pos.right < Math.max(visible.left, space.left) - .1 || pos.left > Math.min(visible.right, space.right) + .1)) dom.style.top = "-10000px"; else {
                    var arrow = tooltip.arrow ? tView.dom.querySelector(".cm-tooltip-arrow") : null, arrowHeight = arrow ? 7 : 0;
                    let width = size.right - size.left, height = null != (_a = knownHeight.get(tView)) ? _a : size.bottom - size.top;
                    var _a = tView.offset || noOffset, ltr = this.view.textDirection == Direction.LTR, left = size.width > space.right - space.left ? ltr ? space.left : space.right - size.width : ltr ? Math.max(space.left, Math.min(pos.left - (arrow ? 14 : 0) + _a.x, space.right - width)) : Math.min(Math.max(space.left, pos.left - width + (arrow ? 14 : 0) - _a.x), space.right - width);
                    let above = this.above[i];
                    size = ((above = !tooltip.strictSide && (above ? pos.top - height - arrowHeight - _a.y < space.top : pos.bottom + height + arrowHeight + _a.y > space.bottom) && above == space.bottom - pos.bottom > pos.top - space.top ? this.above[i] = !above : above) ? pos.top - space.top : space.bottom - pos.bottom) - arrowHeight;
                    if (size < height && !1 !== tView.resize) {
                        if (size < this.view.defaultLineHeight) {
                            dom.style.top = "-10000px";
                            continue;
                        }
                        knownHeight.set(tView, height), dom.style.height = (height = size) / scaleY + "px";
                    } else dom.style.height && (dom.style.height = "");
                    let top = above ? pos.top - height - arrowHeight - _a.y : pos.bottom + arrowHeight + _a.y;
                    var right = left + width;
                    if (!0 !== tView.overlap) for (var r of others) r.left < right && r.right > left && r.top < top + height && r.bottom > top && (top = above ? r.top - height - 2 - arrowHeight : r.bottom + arrowHeight + 2);
                    "absolute" == this.position ? (dom.style.top = (top - measured.parent.top) / scaleY + "px", 
                    setLeftStyle(dom, (left - measured.parent.left) / scaleX)) : (dom.style.top = top / scaleY + "px", 
                    setLeftStyle(dom, left / scaleX)), arrow && (tooltip = pos.left + (ltr ? _a.x : -_a.x) - (left + 14 - 7), 
                    arrow.style.left = tooltip / scaleX + "px"), !0 !== tView.overlap && others.push({
                        left: left,
                        top: top,
                        right: right,
                        bottom: top + height
                    }), dom.classList.toggle("cm-tooltip-above", above), dom.classList.toggle("cm-tooltip-below", !above), 
                    tView.positioned && tView.positioned(measured.space);
                }
            }
        }
        maybeMeasure() {
            if (this.manager.tooltips.length && (this.view.inView && this.view.requestMeasure(this.measureReq), 
            this.inView != this.view.inView) && (this.inView = this.view.inView, 
            !this.inView)) for (var tv of this.manager.tooltipViews) tv.dom.style.top = "-10000px";
        }
    }, {
        eventObservers: {
            scroll() {
                this.maybeMeasure();
            }
        }
    });
    function setLeftStyle(elt, value) {
        var current = parseInt(elt.style.left, 10);
        (isNaN(current) || 1 < Math.abs(value - current)) && (elt.style.left = value + "px");
    }
    var IterMode, ie_upto10 = EditorView.baseTheme({
        ".cm-tooltip": {
            zIndex: 500,
            boxSizing: "border-box"
        },
        "&light .cm-tooltip": {
            border: "1px solid #bbb",
            backgroundColor: "#f5f5f5"
        },
        "&light .cm-tooltip-section:not(:first-child)": {
            borderTop: "1px solid #bbb"
        },
        "&dark .cm-tooltip": {
            backgroundColor: "#333338",
            color: "white"
        },
        ".cm-tooltip-arrow": {
            height: "7px",
            width: "14px",
            position: "absolute",
            zIndex: -1,
            overflow: "hidden",
            "&:before, &:after": {
                content: "''",
                position: "absolute",
                width: 0,
                height: 0,
                borderLeft: "7px solid transparent",
                borderRight: "7px solid transparent"
            },
            ".cm-tooltip-above &": {
                bottom: "-7px",
                "&:before": {
                    borderTop: "7px solid #bbb"
                },
                "&:after": {
                    borderTop: "7px solid #f5f5f5",
                    bottom: "1px"
                }
            },
            ".cm-tooltip-below &": {
                top: "-7px",
                "&:before": {
                    borderBottom: "7px solid #bbb"
                },
                "&:after": {
                    borderBottom: "7px solid #f5f5f5",
                    top: "1px"
                }
            }
        },
        "&dark .cm-tooltip .cm-tooltip-arrow": {
            "&:before": {
                borderTopColor: "#333338",
                borderBottomColor: "#333338"
            },
            "&:after": {
                borderTopColor: "transparent",
                borderBottomColor: "transparent"
            }
        }
    });
    const noOffset = {
        x: 0,
        y: 0
    }, showTooltip = Facet.define({
        enables: [ tooltipPlugin, ie_upto10 ]
    });
    const panelConfig = Facet.define({
        combine(configs) {
            let topContainer, bottomContainer;
            for (var c of configs) topContainer = topContainer || c.topContainer, 
            bottomContainer = bottomContainer || c.bottomContainer;
            return {
                topContainer: topContainer,
                bottomContainer: bottomContainer
            };
        }
    });
    function getPanel(view, panel) {
        view = view.plugin(panelPlugin), panel = view ? view.specs.indexOf(panel) : -1;
        return -1 < panel ? view.panels[panel] : null;
    }
    const panelPlugin = ViewPlugin.fromClass(class {
        constructor(view) {
            this.input = view.state.facet(showPanel), this.specs = this.input.filter(s => s), 
            this.panels = this.specs.map(spec => spec(view));
            var p, conf = view.state.facet(panelConfig);
            this.top = new PanelGroup(view, !0, conf.topContainer), this.bottom = new PanelGroup(view, !1, conf.bottomContainer), 
            this.top.sync(this.panels.filter(p => p.top)), this.bottom.sync(this.panels.filter(p => !p.top));
            for (p of this.panels) p.dom.classList.add("cm-panel"), p.mount && p.mount();
        }
        update(update) {
            var conf = update.state.facet(panelConfig), conf = (this.top.container != conf.topContainer && (this.top.sync([]), 
            this.top = new PanelGroup(update.view, !0, conf.topContainer)), this.bottom.container != conf.bottomContainer && (this.bottom.sync([]), 
            this.bottom = new PanelGroup(update.view, !1, conf.bottomContainer)), 
            this.top.syncClasses(), this.bottom.syncClasses(), update.state.facet(showPanel));
            if (conf != this.input) {
                var spec, p, conf = conf.filter(x => x), panels = [], top = [], bottom = [], mount = [];
                for (spec of conf) {
                    let known = this.specs.indexOf(spec), panel;
                    known < 0 ? (panel = spec(update.view), mount.push(panel)) : (panel = this.panels[known]).update && panel.update(update), 
                    panels.push(panel), (panel.top ? top : bottom).push(panel);
                }
                this.specs = conf, this.panels = panels, this.top.sync(top), this.bottom.sync(bottom);
                for (p of mount) p.dom.classList.add("cm-panel"), p.mount && p.mount();
            } else for (let p of this.panels) p.update && p.update(update);
        }
        destroy() {
            this.top.sync([]), this.bottom.sync([]);
        }
    }, {
        provide: plugin => EditorView.scrollMargins.of(view => {
            view = view.plugin(plugin);
            return view && {
                top: view.top.scrollMargin(),
                bottom: view.bottom.scrollMargin()
            };
        })
    });
    class PanelGroup {
        constructor(view, top, container) {
            this.view = view, this.top = top, this.container = container, this.dom = void 0, 
            this.classes = "", this.panels = [], this.syncClasses();
        }
        sync(panels) {
            for (var p of this.panels) p.destroy && panels.indexOf(p) < 0 && p.destroy();
            this.panels = panels, this.syncDOM();
        }
        syncDOM() {
            if (0 == this.panels.length) this.dom && (this.dom.remove(), this.dom = void 0); else {
                var parent, panel;
                this.dom || (this.dom = document.createElement("div"), this.dom.className = this.top ? "cm-panels cm-panels-top" : "cm-panels cm-panels-bottom", 
                this.dom.style[this.top ? "top" : "bottom"] = "0", (parent = this.container || this.view.dom).insertBefore(this.dom, this.top ? parent.firstChild : null));
                let curDOM = this.dom.firstChild;
                for (panel of this.panels) if (panel.dom.parentNode == this.dom) {
                    for (;curDOM != panel.dom; ) curDOM = rm(curDOM);
                    curDOM = curDOM.nextSibling;
                } else this.dom.insertBefore(panel.dom, curDOM);
                for (;curDOM; ) curDOM = rm(curDOM);
            }
        }
        scrollMargin() {
            return !this.dom || this.container ? 0 : Math.max(0, this.top ? this.dom.getBoundingClientRect().bottom - Math.max(0, this.view.scrollDOM.getBoundingClientRect().top) : Math.min(innerHeight, this.view.scrollDOM.getBoundingClientRect().bottom) - this.dom.getBoundingClientRect().top);
        }
        syncClasses() {
            if (this.container && this.classes != this.view.themeClasses) {
                for (var cls of this.classes.split(" ")) cls && this.container.classList.remove(cls);
                for (let cls of (this.classes = this.view.themeClasses).split(" ")) cls && this.container.classList.add(cls);
            }
        }
    }
    function rm(node) {
        var next = node.nextSibling;
        return node.remove(), next;
    }
    const showPanel = Facet.define({
        enables: panelPlugin
    });
    class GutterMarker extends RangeValue {
        compare(other) {
            return this == other || this.constructor == other.constructor && this.eq(other);
        }
        eq(other) {
            return !1;
        }
        destroy(dom) {}
    }
    GutterMarker.prototype.elementClass = "", GutterMarker.prototype.toDOM = void 0, 
    GutterMarker.prototype.mapMode = MapMode.TrackBefore, GutterMarker.prototype.startSide = GutterMarker.prototype.endSide = -1;
    const gutterLineClass = Facet.define(), gutterWidgetClass = Facet.define(), defaults = {
        class: "",
        renderEmptyElements: !(GutterMarker.prototype.point = !0),
        elementStyle: "",
        markers: () => RangeSet.empty,
        lineMarker: () => null,
        widgetMarker: () => null,
        lineMarkerChange: null,
        initialSpacer: null,
        updateSpacer: null,
        domEventHandlers: {},
        side: "before"
    }, activeGutters = Facet.define();
    const unfixGutters = Facet.define({
        combine: values => values.some(x => x)
    });
    function gutters() {
        return [ gutterView ];
    }
    const gutterView = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.domAfter = null, this.prevViewport = view.viewport, 
            this.dom = document.createElement("div"), this.dom.className = "cm-gutters cm-gutters-before", 
            this.dom.setAttribute("aria-hidden", "true"), this.dom.style.minHeight = this.view.contentHeight / this.view.scaleY + "px", 
            this.gutters = view.state.facet(activeGutters).map(conf => new SingleGutterView(view, conf)), 
            this.fixed = !view.state.facet(unfixGutters);
            for (var gutter of this.gutters) ("after" == gutter.config.side ? this.getDOMAfter() : this.dom).appendChild(gutter.dom);
            this.fixed && (this.dom.style.position = "sticky"), this.syncGutters(!1), 
            view.scrollDOM.insertBefore(this.dom, view.contentDOM);
        }
        getDOMAfter() {
            return this.domAfter || (this.domAfter = document.createElement("div"), 
            this.domAfter.className = "cm-gutters cm-gutters-after", this.domAfter.setAttribute("aria-hidden", "true"), 
            this.domAfter.style.minHeight = this.view.contentHeight / this.view.scaleY + "px", 
            this.domAfter.style.position = this.fixed ? "sticky" : "", this.view.scrollDOM.appendChild(this.domAfter)), 
            this.domAfter;
        }
        update(update) {
            var vpB, vpA;
            this.updateGutters(update) && (vpA = this.prevViewport, vpB = update.view.viewport, 
            vpA = Math.min(vpA.to, vpB.to) - Math.max(vpA.from, vpB.from), this.syncGutters(vpA < .8 * (vpB.to - vpB.from))), 
            update.geometryChanged && (vpA = this.view.contentHeight / this.view.scaleY + "px", 
            this.dom.style.minHeight = vpA, this.domAfter) && (this.domAfter.style.minHeight = vpA), 
            this.view.state.facet(unfixGutters) != !this.fixed && (this.fixed = !this.fixed, 
            this.dom.style.position = this.fixed ? "sticky" : "", this.domAfter) && (this.domAfter.style.position = this.fixed ? "sticky" : ""), 
            this.prevViewport = update.view.viewport;
        }
        syncGutters(detach) {
            var after = this.dom.nextSibling, lineClasses = (detach && (this.dom.remove(), 
            this.domAfter) && this.domAfter.remove(), RangeSet.iter(this.view.state.facet(gutterLineClass), this.view.viewport.from));
            let classSet = [];
            var line, contexts = this.gutters.map(gutter => new UpdateContext(gutter, this.view.viewport, -this.view.documentPadding.top));
            for (line of this.view.viewportLineBlocks) if (classSet.length && (classSet = []), 
            Array.isArray(line.type)) {
                let first = !0;
                for (var b of line.type) if (b.type == BlockType.Text && first) {
                    advanceCursor(lineClasses, classSet, b.from);
                    for (var cx of contexts) cx.line(this.view, b, classSet);
                    first = !1;
                } else if (b.widget) for (let cx of contexts) cx.widget(this.view, b);
            } else if (line.type == BlockType.Text) {
                advanceCursor(lineClasses, classSet, line.from);
                for (let cx of contexts) cx.line(this.view, line, classSet);
            } else if (line.widget) for (let cx of contexts) cx.widget(this.view, line);
            for (let cx of contexts) cx.finish();
            detach && (this.view.scrollDOM.insertBefore(this.dom, after), this.domAfter) && this.view.scrollDOM.appendChild(this.domAfter);
        }
        updateGutters(update) {
            var prev = update.startState.facet(activeGutters), cur = update.state.facet(activeGutters);
            let change = update.docChanged || update.heightChanged || update.viewportChanged || !RangeSet.eq(update.startState.facet(gutterLineClass), update.state.facet(gutterLineClass), update.view.viewport.from, update.view.viewport.to);
            if (prev == cur) for (var gutter of this.gutters) gutter.update(update) && (change = !0); else {
                change = !0;
                var conf, g, gutters = [];
                for (conf of cur) {
                    var known = prev.indexOf(conf);
                    known < 0 ? gutters.push(new SingleGutterView(this.view, conf)) : (this.gutters[known].update(update), 
                    gutters.push(this.gutters[known]));
                }
                for (g of this.gutters) g.dom.remove(), gutters.indexOf(g) < 0 && g.destroy();
                for (let g of gutters) ("after" == g.config.side ? this.getDOMAfter() : this.dom).appendChild(g.dom);
                this.gutters = gutters;
            }
            return change;
        }
        destroy() {
            for (var view of this.gutters) view.destroy();
            this.dom.remove(), this.domAfter && this.domAfter.remove();
        }
    }, {
        provide: plugin => EditorView.scrollMargins.of(view => {
            var before, value = view.plugin(plugin);
            return value && 0 != value.gutters.length && value.fixed ? (before = value.dom.offsetWidth * view.scaleX, 
            value = value.domAfter ? value.domAfter.offsetWidth * view.scaleX : 0, 
            view.textDirection == Direction.LTR ? {
                left: before,
                right: value
            } : {
                right: before,
                left: value
            }) : null;
        })
    });
    function asArray(val) {
        return Array.isArray(val) ? val : [ val ];
    }
    function advanceCursor(cursor, collect, pos) {
        for (;cursor.value && cursor.from <= pos; ) cursor.from == pos && collect.push(cursor.value), 
        cursor.next();
    }
    class UpdateContext {
        constructor(gutter, viewport, height) {
            this.gutter = gutter, this.height = height, this.i = 0, this.cursor = RangeSet.iter(gutter.markers, viewport.from);
        }
        addElement(view, block, markers) {
            var newElt, gutter = this["gutter"], above = (block.top - this.height) / view.scaleY, height = block.height / view.scaleY;
            this.i == gutter.elements.length ? (newElt = new GutterElement(view, height, above, markers), 
            gutter.elements.push(newElt), gutter.dom.appendChild(newElt.dom)) : gutter.elements[this.i].update(view, height, above, markers), 
            this.height = block.bottom, this.i++;
        }
        line(view, line, extraMarkers) {
            let localMarkers = [];
            advanceCursor(this.cursor, localMarkers, line.from), extraMarkers.length && (localMarkers = localMarkers.concat(extraMarkers));
            extraMarkers = this.gutter.config.lineMarker(view, line, localMarkers), 
            extraMarkers && localMarkers.unshift(extraMarkers), extraMarkers = this.gutter;
            0 == localMarkers.length && !extraMarkers.config.renderEmptyElements || this.addElement(view, line, localMarkers);
        }
        widget(view, block) {
            let marker = this.gutter.config.widgetMarker(view, block.widget, block), markers = marker ? [ marker ] : null;
            for (var cls of view.state.facet(gutterWidgetClass)) {
                let marker = cls(view, block.widget, block);
                marker && (markers = markers || []).push(marker);
            }
            markers && this.addElement(view, block, markers);
        }
        finish() {
            for (var gutter = this.gutter; gutter.elements.length > this.i; ) {
                var last = gutter.elements.pop();
                gutter.dom.removeChild(last.dom), last.destroy();
            }
        }
    }
    class SingleGutterView {
        constructor(view, config) {
            this.view = view, this.config = config, this.elements = [], this.spacer = null, 
            this.dom = document.createElement("div"), this.dom.className = "cm-gutter" + (this.config.class ? " " + this.config.class : "");
            for (let prop in config.domEventHandlers) this.dom.addEventListener(prop, event => {
                let target = event.target, y;
                if (target != this.dom && this.dom.contains(target)) {
                    for (;target.parentNode != this.dom; ) target = target.parentNode;
                    var rect = target.getBoundingClientRect();
                    y = (rect.top + rect.bottom) / 2;
                } else y = event.clientY;
                rect = view.lineBlockAtHeight(y - view.documentTop);
                config.domEventHandlers[prop](view, rect, event) && event.preventDefault();
            });
            this.markers = asArray(config.markers(view)), config.initialSpacer && (this.spacer = new GutterElement(view, 0, 0, [ config.initialSpacer(view) ]), 
            this.dom.appendChild(this.spacer.dom), this.spacer.dom.style.cssText += "visibility: hidden; pointer-events: none");
        }
        update(update) {
            var prevMarkers = this.markers, updated = (this.markers = asArray(this.config.markers(update.view)), 
            this.spacer && this.config.updateSpacer && (updated = this.config.updateSpacer(this.spacer.markers[0], update)) != this.spacer.markers[0] && this.spacer.update(update.view, 0, 0, [ updated ]), 
            update.view.viewport);
            return !RangeSet.eq(this.markers, prevMarkers, updated.from, updated.to) || !!this.config.lineMarkerChange && this.config.lineMarkerChange(update);
        }
        destroy() {
            for (var elt of this.elements) elt.destroy();
        }
    }
    class GutterElement {
        constructor(view, height, above, markers) {
            this.height = -1, this.above = 0, this.markers = [], this.dom = document.createElement("div"), 
            this.dom.className = "cm-gutterElement", this.update(view, height, above, markers);
        }
        update(view, height, above, markers) {
            this.height != height && (this.height = height, this.dom.style.height = height + "px"), 
            this.above != above && (this.dom.style.marginTop = (this.above = above) ? above + "px" : ""), 
            function(a, b) {
                if (a.length != b.length) return;
                for (let i = 0; i < a.length; i++) if (!a[i].compare(b[i])) return;
                return 1;
            }(this.markers, markers) || this.setMarkers(view, markers);
        }
        setMarkers(view, markers) {
            let cls = "cm-gutterElement", domPos = this.dom.firstChild;
            for (let iNew = 0, iOld = 0; ;) {
                let skipTo = iOld, marker = iNew < markers.length ? markers[iNew++] : null, matched = !1;
                if (marker) {
                    var c = marker.elementClass;
                    c && (cls += " " + c);
                    for (let i = iOld; i < this.markers.length; i++) if (this.markers[i].compare(marker)) {
                        skipTo = i, matched = !0;
                        break;
                    }
                } else skipTo = this.markers.length;
                for (;iOld < skipTo; ) {
                    var next = this.markers[iOld++];
                    next.toDOM && (next.destroy(domPos), next = domPos.nextSibling, 
                    domPos.remove(), domPos = next);
                }
                if (!marker) break;
                marker.toDOM && (matched ? domPos = domPos.nextSibling : this.dom.insertBefore(marker.toDOM(view), domPos)), 
                matched && iOld++;
            }
            this.dom.className = cls, this.markers = markers;
        }
        destroy() {
            this.setMarkers(null, []);
        }
    }
    const lineNumberMarkers = Facet.define(), lineNumberWidgetMarker = Facet.define(), lineNumberConfig = Facet.define({
        combine(values) {
            return combineConfig(values, {
                formatNumber: String,
                domEventHandlers: {}
            }, {
                domEventHandlers(a, b) {
                    var event, result = Object.assign({}, a);
                    for (event in b) {
                        let exists = result[event], add = b[event];
                        result[event] = exists ? (view, line, event) => exists(view, line, event) || add(view, line, event) : add;
                    }
                    return result;
                }
            });
        }
    });
    class NumberMarker extends GutterMarker {
        constructor(number) {
            super(), this.number = number;
        }
        eq(other) {
            return this.number == other.number;
        }
        toDOM() {
            return document.createTextNode(this.number);
        }
    }
    function formatNumber(view, number) {
        return view.state.facet(lineNumberConfig).formatNumber(number, view.state);
    }
    const lineNumberGutter = activeGutters.compute([ lineNumberConfig ], state => ({
        class: "cm-lineNumbers",
        renderEmptyElements: !1,
        markers(view) {
            return view.state.facet(lineNumberMarkers);
        },
        lineMarker(view, line, others) {
            return others.some(m => m.toDOM) ? null : new NumberMarker(formatNumber(view, view.state.doc.lineAt(line.from).number));
        },
        widgetMarker: (view, widget, block) => {
            for (var m of view.state.facet(lineNumberWidgetMarker)) {
                m = m(view, widget, block);
                if (m) return m;
            }
            return null;
        },
        lineMarkerChange: update => update.startState.facet(lineNumberConfig) != update.state.facet(lineNumberConfig),
        initialSpacer(view) {
            return new NumberMarker(formatNumber(view, maxLineNumber(view.state.doc.lines)));
        },
        updateSpacer(spacer, update) {
            update = formatNumber(update.view, maxLineNumber(update.view.state.doc.lines));
            return update == spacer.number ? spacer : new NumberMarker(update);
        },
        domEventHandlers: state.facet(lineNumberConfig).domEventHandlers,
        side: "before"
    }));
    function maxLineNumber(lines) {
        let last = 9;
        for (;last < lines; ) last = 10 * last + 9;
        return last;
    }
    const activeLineGutterMarker = new class extends GutterMarker {
        constructor() {
            super(...arguments), this.elementClass = "cm-activeLineGutter";
        }
    }(), activeLineGutterHighlighter = gutterLineClass.compute([ "selection" ], state => {
        let marks = [], last = -1;
        for (var range of state.selection.ranges) {
            range = state.doc.lineAt(range.head).from;
            range > last && (last = range, marks.push(activeLineGutterMarker.range(range)));
        }
        return RangeSet.of(marks);
    });
    let nextPropID = 0;
    class Range {
        constructor(from, to) {
            this.from = from, this.to = to;
        }
    }
    class NodeProp {
        constructor(config = {}) {
            this.id = nextPropID++, this.perNode = !!config.perNode, this.deserialize = config.deserialize || (() => {
                throw new Error("This node type doesn't define a deserialize function");
            });
        }
        add(match) {
            if (this.perNode) throw new RangeError("Can't add per-node props to node types");
            return "function" != typeof match && (match = NodeType.match(match)), 
            type => {
                type = match(type);
                return void 0 === type ? null : [ this, type ];
            };
        }
    }
    NodeProp.closedBy = new NodeProp({
        deserialize: str => str.split(" ")
    }), NodeProp.openedBy = new NodeProp({
        deserialize: str => str.split(" ")
    }), NodeProp.group = new NodeProp({
        deserialize: str => str.split(" ")
    }), NodeProp.isolate = new NodeProp({
        deserialize: value => {
            if (value && "rtl" != value && "ltr" != value && "auto" != value) throw new RangeError("Invalid value for isolate: " + value);
            return value || "auto";
        }
    }), NodeProp.contextHash = new NodeProp({
        perNode: !0
    }), NodeProp.lookAhead = new NodeProp({
        perNode: !0
    }), NodeProp.mounted = new NodeProp({
        perNode: !0
    });
    class MountedTree {
        constructor(tree, overlay, parser) {
            this.tree = tree, this.overlay = overlay, this.parser = parser;
        }
        static get(tree) {
            return tree && tree.props && tree.props[NodeProp.mounted.id];
        }
    }
    const noProps = Object.create(null);
    class NodeType {
        constructor(name, props, id, flags = 0) {
            this.name = name, this.props = props, this.id = id, this.flags = flags;
        }
        static define(spec) {
            var props = spec.props && spec.props.length ? Object.create(null) : noProps, flags = (spec.top ? 1 : 0) | (spec.skipped ? 2 : 0) | (spec.error ? 4 : 0) | (null == spec.name ? 8 : 0), type = new NodeType(spec.name || "", props, spec.id, flags);
            if (spec.props) for (var src of spec.props) if (src = Array.isArray(src) ? src : src(type)) {
                if (src[0].perNode) throw new RangeError("Can't store a per-node prop on a node type");
                props[src[0].id] = src[1];
            }
            return type;
        }
        prop(prop) {
            return this.props[prop.id];
        }
        get isTop() {
            return 0 < (1 & this.flags);
        }
        get isSkipped() {
            return 0 < (2 & this.flags);
        }
        get isError() {
            return 0 < (4 & this.flags);
        }
        get isAnonymous() {
            return 0 < (8 & this.flags);
        }
        is(name) {
            var group;
            return "string" == typeof name ? this.name == name || !!(group = this.prop(NodeProp.group)) && -1 < group.indexOf(name) : this.id == name;
        }
        static match(map) {
            let direct = Object.create(null);
            for (var prop in map) for (var name of prop.split(" ")) direct[name] = map[prop];
            return node => {
                for (let groups = node.prop(NodeProp.group), i = -1; i < (groups ? groups.length : 0); i++) {
                    var found = direct[i < 0 ? node.name : groups[i]];
                    if (found) return found;
                }
            };
        }
    }
    NodeType.none = new NodeType("", Object.create(null), 0, 8);
    class NodeSet {
        constructor(types) {
            this.types = types;
            for (let i = 0; i < types.length; i++) if (types[i].id != i) throw new RangeError("Node type ids should correspond to array positions when creating a node set");
        }
        extend(...props) {
            var type, newTypes = [];
            for (type of this.types) {
                let newProps = null;
                for (var source of props) {
                    source = source(type);
                    source && ((newProps = newProps || Object.assign({}, type.props))[source[0].id] = source[1]);
                }
                newTypes.push(newProps ? new NodeType(type.name, newProps, type.id, type.flags) : type);
            }
            return new NodeSet(newTypes);
        }
    }
    const CachedNode = new WeakMap(), CachedInnerNode = new WeakMap();
    !function(IterMode) {
        IterMode[IterMode.ExcludeBuffers = 1] = "ExcludeBuffers", IterMode[IterMode.IncludeAnonymous = 2] = "IncludeAnonymous", 
        IterMode[IterMode.IgnoreMounts = 4] = "IgnoreMounts", IterMode[IterMode.IgnoreOverlays = 8] = "IgnoreOverlays";
    }(IterMode = IterMode || {});
    class Tree {
        constructor(type, children, positions, length, props) {
            if (this.type = type, this.children = children, this.positions = positions, 
            this.length = length, this.props = null, props && props.length) {
                this.props = Object.create(null);
                for (var [ prop, value ] of props) this.props["number" == typeof prop ? prop : prop.id] = value;
            }
        }
        toString() {
            var ch, mounted = MountedTree.get(this);
            if (mounted && !mounted.overlay) return mounted.tree.toString();
            let children = "";
            for (ch of this.children) {
                var str = ch.toString();
                str && (children && (children += ","), children += str);
            }
            return this.type.name ? (/\W/.test(this.type.name) && !this.type.isError ? JSON.stringify(this.type.name) : this.type.name) + (children.length ? "(" + children + ")" : "") : children;
        }
        cursor(mode = 0) {
            return new TreeCursor(this.topNode, mode);
        }
        cursorAt(pos, side = 0, mode) {
            var scope = CachedNode.get(this) || this.topNode, scope = new TreeCursor(scope);
            return scope.moveTo(pos, side), CachedNode.set(this, scope._tree), scope;
        }
        get topNode() {
            return new TreeNode(this, 0, 0, null);
        }
        resolve(pos, side = 0) {
            pos = resolveNode(CachedNode.get(this) || this.topNode, pos, side, !1);
            return CachedNode.set(this, pos), pos;
        }
        resolveInner(pos, side = 0) {
            pos = resolveNode(CachedInnerNode.get(this) || this.topNode, pos, side, !0);
            return CachedInnerNode.set(this, pos), pos;
        }
        resolveStack(pos, side = 0) {
            return function(tree, pos, side) {
                let inner = tree.resolveInner(pos, side), layers = null;
                for (let scan = inner instanceof TreeNode ? inner : inner.context.parent; scan; scan = scan.parent) {
                    var parent, root;
                    scan.index < 0 ? (parent = scan.parent, (layers = layers || [ inner ]).push(parent.resolve(pos, side)), 
                    scan = parent) : (parent = MountedTree.get(scan.tree)) && parent.overlay && parent.overlay[0].from <= pos && parent.overlay[parent.overlay.length - 1].to >= pos && (root = new TreeNode(parent.tree, parent.overlay[0].from + scan.from, -1, scan), 
                    (layers = layers || [ inner ]).push(resolveNode(root, pos, side, !1)));
                }
                return layers ? iterStack(layers) : inner;
            }(this, pos, side);
        }
        iterate(spec) {
            for (var {
                enter,
                leave,
                from = 0,
                to = this.length
            } = spec, spec = spec.mode || 0, anon = 0 < (spec & IterMode.IncludeAnonymous), c = this.cursor(spec | IterMode.IncludeAnonymous); ;) {
                let entered = !1;
                if (c.from <= to && c.to >= from && (!anon && c.type.isAnonymous || !1 !== enter(c))) {
                    if (c.firstChild()) continue;
                    entered = !0;
                }
                for (;entered && leave && (anon || !c.type.isAnonymous) && leave(c), 
                !c.nextSibling(); ) {
                    if (!c.parent()) return;
                    entered = !0;
                }
            }
        }
        prop(prop) {
            return prop.perNode ? this.props ? this.props[prop.id] : void 0 : this.type.prop(prop);
        }
        get propValues() {
            var result = [];
            if (this.props) for (var id in this.props) result.push([ +id, this.props[id] ]);
            return result;
        }
        balance(config = {}) {
            return this.children.length <= 8 ? this : balanceRange(NodeType.none, this.children, this.positions, 0, this.children.length, 0, this.length, (children, positions, length) => new Tree(this.type, children, positions, length, this.propValues), config.makeTree || ((children, positions, length) => new Tree(NodeType.none, children, positions, length)));
        }
        static build(data) {
            let {
                buffer,
                nodeSet,
                maxBufferLength = 1024,
                reused = [],
                minRepeatType = nodeSet.types.length
            } = data, cursor = Array.isArray(buffer) ? new FlatBufferCursor(buffer, buffer.length) : buffer, types = nodeSet.types, contextHash = 0, lookAhead = 0;
            function takeNode(parentStart, minPos, children, positions, inRepeat, depth) {
                for (var {
                    id,
                    start,
                    end,
                    size
                } = cursor, lookAheadAtStart = lookAhead, contextAtStart = contextHash; size < 0; ) {
                    if (cursor.next(), -1 == size) {
                        let node = reused[id];
                        return children.push(node), void positions.push(start - parentStart);
                    }
                    if (-3 == size) return void (contextHash = id);
                    if (-4 == size) return void (lookAhead = id);
                    throw new RangeError("Unrecognized record size: " + size);
                }
                let type = types[id], node, buffer, startPos = start - parentStart;
                if (end - start <= maxBufferLength && (buffer = function(maxSize, inRepeat) {
                    let fork = cursor.fork(), size = 0, start = 0, skip = 0, minStart = fork.end - maxBufferLength, result = {
                        size: 0,
                        start: 0,
                        skip: 0
                    };
                    scan: for (var minPos = fork.pos - maxSize; fork.pos > minPos; ) {
                        var nodeSize = fork.size;
                        if (fork.id == inRepeat && 0 <= nodeSize) result.size = size, 
                        result.start = start, result.skip = skip, skip += 4, size += 4, 
                        fork.next(); else {
                            var startPos = fork.pos - nodeSize;
                            if (nodeSize < 0 || startPos < minPos || fork.start < minStart) break;
                            let localSkipped = fork.id >= minRepeatType ? 4 : 0;
                            var nodeStart = fork.start;
                            for (fork.next(); fork.pos > startPos; ) {
                                if (fork.size < 0) {
                                    if (-3 != fork.size) break scan;
                                    localSkipped += 4;
                                } else fork.id >= minRepeatType && (localSkipped += 4);
                                fork.next();
                            }
                            start = nodeStart, size += nodeSize, skip += localSkipped;
                        }
                    }
                    (inRepeat < 0 || size == maxSize) && (result.size = size, result.start = start, 
                    result.skip = skip);
                    return 4 < result.size ? result : void 0;
                }(cursor.pos - minPos, inRepeat))) {
                    var data = new Uint16Array(buffer.size - buffer.skip);
                    let endPos = cursor.pos - buffer.size, index = data.length;
                    for (;cursor.pos > endPos; ) index = function copyToBuffer(bufferStart, buffer, index) {
                        let {
                            id,
                            start,
                            end,
                            size
                        } = cursor;
                        cursor.next();
                        if (0 <= size && id < minRepeatType) {
                            let startIndex = index;
                            if (4 < size) {
                                let endPos = cursor.pos - (size - 4);
                                for (;cursor.pos > endPos; ) index = copyToBuffer(bufferStart, buffer, index);
                            }
                            buffer[--index] = startIndex, buffer[--index] = end - bufferStart, 
                            buffer[--index] = start - bufferStart, buffer[--index] = id;
                        } else -3 == size ? contextHash = id : -4 == size && (lookAhead = id);
                        return index;
                    }(buffer.start, data, index);
                    node = new TreeBuffer(data, end - buffer.start, nodeSet), startPos = buffer.start - parentStart;
                } else {
                    var endPos = cursor.pos - size, localChildren = (cursor.next(), 
                    []), localPositions = [], localInRepeat = id >= minRepeatType ? id : -1;
                    let lastGroup = 0, lastEnd = end;
                    for (;cursor.pos > endPos; ) 0 <= localInRepeat && cursor.id == localInRepeat && 0 <= cursor.size ? (cursor.end <= lastEnd - maxBufferLength && (makeRepeatLeaf(localChildren, localPositions, start, lastGroup, cursor.end, lastEnd, localInRepeat, lookAheadAtStart, contextAtStart), 
                    lastGroup = localChildren.length, lastEnd = cursor.end), cursor.next()) : 2500 < depth ? function(parentStart, minPos, children, positions) {
                        let nodes = [], nodeCount = 0, stopAt = -1;
                        for (;cursor.pos > minPos; ) {
                            var {
                                id,
                                start,
                                end,
                                size
                            } = cursor;
                            if (!(4 < size)) {
                                if (-1 < stopAt && start < stopAt) break;
                                stopAt < 0 && (stopAt = end - maxBufferLength), 
                                nodes.push(id, start, end), nodeCount++;
                            }
                            cursor.next();
                        }
                        if (nodeCount) {
                            var buffer = new Uint16Array(4 * nodeCount), start = nodes[nodes.length - 2];
                            for (let i = nodes.length - 3, j = 0; 0 <= i; i -= 3) buffer[j++] = nodes[i], 
                            buffer[j++] = nodes[i + 1] - start, buffer[j++] = nodes[i + 2] - start, 
                            buffer[j++] = j;
                            children.push(new TreeBuffer(buffer, nodes[2] - start, nodeSet)), 
                            positions.push(start - parentStart);
                        }
                    }(start, endPos, localChildren, localPositions) : takeNode(start, endPos, localChildren, localPositions, localInRepeat, depth + 1);
                    0 <= localInRepeat && 0 < lastGroup && lastGroup < localChildren.length && makeRepeatLeaf(localChildren, localPositions, start, lastGroup, start, lastEnd, localInRepeat, lookAheadAtStart, contextAtStart), 
                    localChildren.reverse(), localPositions.reverse(), node = -1 < localInRepeat && 0 < lastGroup ? (minPos = function(type, contextHash) {
                        return (children, positions, length) => {
                            let lookAhead = 0, lastI = children.length - 1, last, lookAheadProp;
                            if (0 <= lastI && (last = children[lastI]) instanceof Tree) {
                                if (!lastI && last.type == type && last.length == length) return last;
                                (lookAheadProp = last.prop(NodeProp.lookAhead)) && (lookAhead = positions[lastI] + last.length + lookAheadProp);
                            }
                            return makeTree(type, children, positions, length, lookAhead, contextHash);
                        };
                    }(type, contextAtStart), balanceRange(type, localChildren, localPositions, 0, localChildren.length, 0, end - start, minPos, minPos)) : makeTree(type, localChildren, localPositions, end - start, lookAheadAtStart - end, contextAtStart);
                }
                children.push(node), positions.push(startPos);
            }
            function makeRepeatLeaf(children, positions, base, i, from, to, type, lookAhead, contextHash) {
                for (var localChildren = [], localPositions = []; children.length > i; ) localChildren.push(children.pop()), 
                localPositions.push(positions.pop() + base - from);
                children.push(makeTree(nodeSet.types[type], localChildren, localPositions, to - from, lookAhead - to, contextHash)), 
                positions.push(from - base);
            }
            function makeTree(type, children, positions, length, lookAhead, contextHash, props) {
                if (contextHash && (contextHash = [ NodeProp.contextHash, contextHash ], 
                props = props ? [ contextHash ].concat(props) : [ contextHash ]), 
                25 < lookAhead) {
                    let pair = [ NodeProp.lookAhead, lookAhead ];
                    props = props ? [ pair ].concat(props) : [ pair ];
                }
                return new Tree(type, children, positions, length, props);
            }
            var children = [], positions = [];
            for (;0 < cursor.pos; ) takeNode(data.start || 0, data.bufferStart || 0, children, positions, -1, 0);
            var _a = null != (_a = data.length) ? _a : children.length ? positions[0] + children[0].length : 0;
            return new Tree(types[data.topID], children.reverse(), positions.reverse(), _a);
        }
    }
    Tree.empty = new Tree(NodeType.none, [], [], 0);
    class FlatBufferCursor {
        constructor(buffer, index) {
            this.buffer = buffer, this.index = index;
        }
        get id() {
            return this.buffer[this.index - 4];
        }
        get start() {
            return this.buffer[this.index - 3];
        }
        get end() {
            return this.buffer[this.index - 2];
        }
        get size() {
            return this.buffer[this.index - 1];
        }
        get pos() {
            return this.index;
        }
        next() {
            this.index -= 4;
        }
        fork() {
            return new FlatBufferCursor(this.buffer, this.index);
        }
    }
    class TreeBuffer {
        constructor(buffer, length, set) {
            this.buffer = buffer, this.length = length, this.set = set;
        }
        get type() {
            return NodeType.none;
        }
        toString() {
            var result = [];
            for (let index = 0; index < this.buffer.length; ) result.push(this.childString(index)), 
            index = this.buffer[index + 3];
            return result.join(",");
        }
        childString(index) {
            var id = this.buffer[index], endIndex = this.buffer[index + 3];
            let type = this.set.types[id], result = type.name;
            if (/\W/.test(result) && !type.isError && (result = JSON.stringify(result)), 
            endIndex == (index += 4)) return result;
            for (var children = []; index < endIndex; ) children.push(this.childString(index)), 
            index = this.buffer[index + 3];
            return result + "(" + children.join(",") + ")";
        }
        findChild(startIndex, endIndex, dir, pos, side) {
            let buffer = this["buffer"], pick = -1;
            for (let i = startIndex; i != endIndex && !(checkSide(side, pos, buffer[i + 1], buffer[i + 2]) && (pick = i, 
            0 < dir)); i = buffer[i + 3]);
            return pick;
        }
        slice(startI, endI, from) {
            var b = this.buffer;
            let copy = new Uint16Array(endI - startI), len = 0;
            for (let i = startI, j = 0; i < endI; ) {
                copy[j++] = b[i++], copy[j++] = b[i++] - from;
                var to = copy[j++] = b[i++] - from;
                copy[j++] = b[i++] - startI, len = Math.max(len, to);
            }
            return new TreeBuffer(copy, len, this.set);
        }
    }
    function checkSide(side, pos, from, to) {
        switch (side) {
          case -2:
            return from < pos;

          case -1:
            return pos <= to && from < pos;

          case 0:
            return from < pos && pos < to;

          case 1:
            return from <= pos && pos < to;

          case 2:
            return pos < to;

          case 4:
            return 1;
        }
    }
    function resolveNode(node, pos, side, overlays) {
        for (var _a; node.from == node.to || (side < 1 ? node.from >= pos : node.from > pos) || (-1 < side ? node.to <= pos : node.to < pos); ) {
            var parent = !overlays && node instanceof TreeNode && node.index < 0 ? null : node.parent;
            if (!parent) return node;
            node = parent;
        }
        var mode = overlays ? 0 : IterMode.IgnoreOverlays;
        if (overlays) for (let scan = node, parent = scan.parent; parent; parent = (scan = parent).parent) scan instanceof TreeNode && scan.index < 0 && (null == (_a = parent.enter(pos, side, mode)) ? void 0 : _a.from) != scan.from && (node = parent);
        for (;;) {
            var inner = node.enter(pos, side, mode);
            if (!inner) return node;
            node = inner;
        }
    }
    class BaseNode {
        cursor(mode = 0) {
            return new TreeCursor(this, mode);
        }
        getChild(type, before = null, after = null) {
            type = getChildren(this, type, before, after);
            return type.length ? type[0] : null;
        }
        getChildren(type, before = null, after = null) {
            return getChildren(this, type, before, after);
        }
        resolve(pos, side = 0) {
            return resolveNode(this, pos, side, !1);
        }
        resolveInner(pos, side = 0) {
            return resolveNode(this, pos, side, !0);
        }
        matchContext(context) {
            return matchNodeContext(this.parent, context);
        }
        enterUnfinishedNodesBefore(pos) {
            let scan = this.childBefore(pos), node = this;
            for (;scan; ) {
                var last = scan.lastChild;
                if (!last || last.to != scan.to) break;
                scan = last.type.isError && last.from == last.to ? (node = scan, 
                last.prevSibling) : last;
            }
            return node;
        }
        get node() {
            return this;
        }
        get next() {
            return this.parent;
        }
    }
    class TreeNode extends BaseNode {
        constructor(_tree, from, index, _parent) {
            super(), this._tree = _tree, this.from = from, this.index = index, this._parent = _parent;
        }
        get type() {
            return this._tree.type;
        }
        get name() {
            return this._tree.type.name;
        }
        get to() {
            return this.from + this._tree.length;
        }
        nextChild(i, dir, pos, side, mode = 0) {
            for (let parent = this; ;) {
                for (var {
                    children,
                    positions
                } = parent._tree, e = 0 < dir ? children.length : -1; i != e; i += dir) {
                    var next = children[i], start = positions[i] + parent.from;
                    if (checkSide(side, pos, start, start + next.length)) if (next instanceof TreeBuffer) {
                        if (!(mode & IterMode.ExcludeBuffers)) {
                            var index = next.findChild(0, next.buffer.length, dir, pos - start, side);
                            if (-1 < index) return new BufferNode(new BufferContext(parent, next, i, start), null, index);
                        }
                    } else if (mode & IterMode.IncludeAnonymous || !next.type.isAnonymous || hasChild(next)) {
                        let mounted;
                        return mode & IterMode.IgnoreMounts || !(mounted = MountedTree.get(next)) || mounted.overlay ? (index = new TreeNode(next, start, i, parent), 
                        mode & IterMode.IncludeAnonymous || !index.type.isAnonymous ? index : index.nextChild(dir < 0 ? next.children.length - 1 : 0, dir, pos, side)) : new TreeNode(mounted.tree, start, i, parent);
                    }
                }
                if (mode & IterMode.IncludeAnonymous || !parent.type.isAnonymous) return null;
                if (i = 0 <= parent.index ? parent.index + dir : dir < 0 ? -1 : parent._parent._tree.children.length, 
                !(parent = parent._parent)) return null;
            }
        }
        get firstChild() {
            return this.nextChild(0, 1, 0, 4);
        }
        get lastChild() {
            return this.nextChild(this._tree.children.length - 1, -1, 0, 4);
        }
        childAfter(pos) {
            return this.nextChild(0, 1, pos, 2);
        }
        childBefore(pos) {
            return this.nextChild(this._tree.children.length - 1, -1, pos, -2);
        }
        enter(pos, side, mode = 0) {
            let mounted;
            if (!(mode & IterMode.IgnoreOverlays) && (mounted = MountedTree.get(this._tree)) && mounted.overlay) {
                var from, to, rPos = pos - this.from;
                for ({
                    from,
                    to
                } of mounted.overlay) if ((0 < side ? from <= rPos : from < rPos) && (side < 0 ? to >= rPos : to > rPos)) return new TreeNode(mounted.tree, mounted.overlay[0].from + this.from, -1, this);
            }
            return this.nextChild(0, 1, pos, side, mode);
        }
        nextSignificantParent() {
            let val = this;
            for (;val.type.isAnonymous && val._parent; ) val = val._parent;
            return val;
        }
        get parent() {
            return this._parent ? this._parent.nextSignificantParent() : null;
        }
        get nextSibling() {
            return this._parent && 0 <= this.index ? this._parent.nextChild(this.index + 1, 1, 0, 4) : null;
        }
        get prevSibling() {
            return this._parent && 0 <= this.index ? this._parent.nextChild(this.index - 1, -1, 0, 4) : null;
        }
        get tree() {
            return this._tree;
        }
        toTree() {
            return this._tree;
        }
        toString() {
            return this._tree.toString();
        }
    }
    function getChildren(node, type, before, after) {
        var cur = node.cursor(), result = [];
        if (!cur.firstChild()) return result;
        if (null != before) for (let found = !1; !found; ) if (found = cur.type.is(before), 
        !cur.nextSibling()) return result;
        for (;;) {
            if (null != after && cur.type.is(after)) return result;
            if (cur.type.is(type) && result.push(cur.node), !cur.nextSibling()) return null == after ? result : [];
        }
    }
    function matchNodeContext(node, context, i = context.length - 1) {
        for (let p = node; 0 <= i; p = p.parent) {
            if (!p) return !1;
            if (!p.type.isAnonymous) {
                if (context[i] && context[i] != p.name) return !1;
                i--;
            }
        }
        return !0;
    }
    class BufferContext {
        constructor(parent, buffer, index, start) {
            this.parent = parent, this.buffer = buffer, this.index = index, this.start = start;
        }
    }
    class BufferNode extends BaseNode {
        get name() {
            return this.type.name;
        }
        get from() {
            return this.context.start + this.context.buffer.buffer[this.index + 1];
        }
        get to() {
            return this.context.start + this.context.buffer.buffer[this.index + 2];
        }
        constructor(context, _parent, index) {
            super(), this.context = context, this._parent = _parent, this.index = index, 
            this.type = context.buffer.set.types[context.buffer.buffer[index]];
        }
        child(dir, pos, side) {
            var buffer = this.context["buffer"], buffer = buffer.findChild(this.index + 4, buffer.buffer[this.index + 3], dir, pos - this.context.start, side);
            return buffer < 0 ? null : new BufferNode(this.context, this, buffer);
        }
        get firstChild() {
            return this.child(1, 0, 4);
        }
        get lastChild() {
            return this.child(-1, 0, 4);
        }
        childAfter(pos) {
            return this.child(1, pos, 2);
        }
        childBefore(pos) {
            return this.child(-1, pos, -2);
        }
        enter(pos, side, mode = 0) {
            return mode & IterMode.ExcludeBuffers || (mode = this.context.buffer, 
            (mode = mode.findChild(this.index + 4, mode.buffer[this.index + 3], 0 < side ? 1 : -1, pos - this.context.start, side)) < 0) ? null : new BufferNode(this.context, this, mode);
        }
        get parent() {
            return this._parent || this.context.parent.nextSignificantParent();
        }
        externalSibling(dir) {
            return this._parent ? null : this.context.parent.nextChild(this.context.index + dir, dir, 0, 4);
        }
        get nextSibling() {
            var buffer = this.context["buffer"], after = buffer.buffer[this.index + 3];
            return after < (this._parent ? buffer.buffer[this._parent.index + 3] : buffer.buffer.length) ? new BufferNode(this.context, this._parent, after) : this.externalSibling(1);
        }
        get prevSibling() {
            var buffer = this.context["buffer"], parentStart = this._parent ? this._parent.index + 4 : 0;
            return this.index == parentStart ? this.externalSibling(-1) : new BufferNode(this.context, this._parent, buffer.findChild(parentStart, this.index, -1, 0, 4));
        }
        get tree() {
            return null;
        }
        toTree() {
            var from, children = [], positions = [], buffer = this.context["buffer"], startI = this.index + 4, endI = buffer.buffer[this.index + 3];
            return startI < endI && (from = buffer.buffer[this.index + 1], children.push(buffer.slice(startI, endI, from)), 
            positions.push(0)), new Tree(this.type, children, positions, this.to - this.from);
        }
        toString() {
            return this.context.buffer.childString(this.index);
        }
    }
    function iterStack(heads) {
        if (!heads.length) return null;
        let pick = 0, picked = heads[0];
        for (let i = 1; i < heads.length; i++) {
            var node = heads[i];
            (node.from > picked.from || node.to < picked.to) && (picked = node, 
            pick = i);
        }
        var next = picked instanceof TreeNode && picked.index < 0 ? null : picked.parent, newHeads = heads.slice();
        return next ? newHeads[pick] = next : newHeads.splice(pick, 1), new StackIterator(newHeads, picked);
    }
    class StackIterator {
        constructor(heads, node) {
            this.heads = heads, this.node = node;
        }
        get next() {
            return iterStack(this.heads);
        }
    }
    class TreeCursor {
        get name() {
            return this.type.name;
        }
        constructor(node, mode = 0) {
            if (this.mode = mode, this.buffer = null, this.stack = [], this.index = 0, 
            this.bufferNode = null, node instanceof TreeNode) this.yieldNode(node); else {
                this._tree = node.context.parent, this.buffer = node.context;
                for (let n = node._parent; n; n = n._parent) this.stack.unshift(n.index);
                this.bufferNode = node, this.yieldBuf(node.index);
            }
        }
        yieldNode(node) {
            return !!node && (this._tree = node, this.type = node.type, this.from = node.from, 
            this.to = node.to, !0);
        }
        yieldBuf(index, type) {
            this.index = index;
            var {
                start,
                buffer
            } = this.buffer;
            return this.type = type || buffer.set.types[buffer.buffer[index]], this.from = start + buffer.buffer[index + 1], 
            this.to = start + buffer.buffer[index + 2], !0;
        }
        yield(node) {
            return !!node && (node instanceof TreeNode ? (this.buffer = null, this.yieldNode(node)) : (this.buffer = node.context, 
            this.yieldBuf(node.index, node.type)));
        }
        toString() {
            return this.buffer ? this.buffer.buffer.childString(this.index) : this._tree.toString();
        }
        enterChild(dir, pos, side) {
            var buffer;
            return this.buffer ? (buffer = this.buffer["buffer"], !((buffer = buffer.findChild(this.index + 4, buffer.buffer[this.index + 3], dir, pos - this.buffer.start, side)) < 0) && (this.stack.push(this.index), 
            this.yieldBuf(buffer))) : this.yield(this._tree.nextChild(dir < 0 ? this._tree._tree.children.length - 1 : 0, dir, pos, side, this.mode));
        }
        firstChild() {
            return this.enterChild(1, 0, 4);
        }
        lastChild() {
            return this.enterChild(-1, 0, 4);
        }
        childAfter(pos) {
            return this.enterChild(1, pos, 2);
        }
        childBefore(pos) {
            return this.enterChild(-1, pos, -2);
        }
        enter(pos, side, mode = this.mode) {
            return this.buffer ? !(mode & IterMode.ExcludeBuffers) && this.enterChild(1, pos, side) : this.yield(this._tree.enter(pos, side, mode));
        }
        parent() {
            var parent;
            return this.buffer ? this.stack.length ? this.yieldBuf(this.stack.pop()) : (parent = this.mode & IterMode.IncludeAnonymous ? this.buffer.parent : this.buffer.parent.nextSignificantParent(), 
            this.buffer = null, this.yieldNode(parent)) : this.yieldNode(this.mode & IterMode.IncludeAnonymous ? this._tree._parent : this._tree.parent);
        }
        sibling(dir) {
            if (!this.buffer) return !!this._tree._parent && this.yield(this._tree.index < 0 ? null : this._tree._parent.nextChild(this._tree.index + dir, dir, 0, 4, this.mode));
            var buffer = this.buffer["buffer"], d = this.stack.length - 1;
            if (dir < 0) {
                var parentStart = d < 0 ? 0 : this.stack[d] + 4;
                if (this.index != parentStart) return this.yieldBuf(buffer.findChild(parentStart, this.index, -1, 0, 4));
            } else {
                parentStart = buffer.buffer[this.index + 3];
                if (parentStart < (d < 0 ? buffer.buffer.length : buffer.buffer[this.stack[d] + 3])) return this.yieldBuf(parentStart);
            }
            return d < 0 && this.yield(this.buffer.parent.nextChild(this.buffer.index + dir, dir, 0, 4, this.mode));
        }
        nextSibling() {
            return this.sibling(1);
        }
        prevSibling() {
            return this.sibling(-1);
        }
        atLastNode(dir) {
            let index, parent, buffer = this["buffer"];
            if (buffer) {
                if (0 < dir) {
                    if (this.index < buffer.buffer.buffer.length) return !1;
                } else for (let i = 0; i < this.index; i++) if (buffer.buffer.buffer[i + 3] < this.index) return !1;
                ({
                    index,
                    parent
                } = buffer);
            } else ({
                index,
                _parent: parent
            } = this._tree);
            for (;parent; {
                index,
                _parent: parent
            } = parent) if (-1 < index) for (let i = index + dir, e = dir < 0 ? -1 : parent._tree.children.length; i != e; i += dir) {
                var child = parent._tree.children[i];
                if (this.mode & IterMode.IncludeAnonymous || child instanceof TreeBuffer || !child.type.isAnonymous || hasChild(child)) return !1;
            }
            return !0;
        }
        move(dir, enter) {
            if (enter && this.enterChild(dir, 0, 4)) return !0;
            for (;;) {
                if (this.sibling(dir)) return !0;
                if (this.atLastNode(dir) || !this.parent()) return !1;
            }
        }
        next(enter = !0) {
            return this.move(1, enter);
        }
        prev(enter = !0) {
            return this.move(-1, enter);
        }
        moveTo(pos, side = 0) {
            for (;(this.from == this.to || (side < 1 ? this.from >= pos : this.from > pos) || (-1 < side ? this.to <= pos : this.to < pos)) && this.parent(); );
            for (;this.enterChild(1, pos, side); );
            return this;
        }
        get node() {
            if (!this.buffer) return this._tree;
            let cache = this.bufferNode, result = null, depth = 0;
            if (cache && cache.context == this.buffer) scan: for (let index = this.index, d = this.stack.length; 0 <= d; ) {
                for (let c = cache; c; c = c._parent) if (c.index == index) {
                    if (index == this.index) return c;
                    result = c, depth = d + 1;
                    break scan;
                }
                index = this.stack[--d];
            }
            for (let i = depth; i < this.stack.length; i++) result = new BufferNode(this.buffer, result, this.stack[i]);
            return this.bufferNode = new BufferNode(this.buffer, result, this.index);
        }
        get tree() {
            return this.buffer ? null : this._tree._tree;
        }
        iterate(enter, leave) {
            for (let depth = 0; ;) {
                let mustLeave = !1;
                if (this.type.isAnonymous || !1 !== enter(this)) {
                    if (this.firstChild()) {
                        depth++;
                        continue;
                    }
                    this.type.isAnonymous || (mustLeave = !0);
                }
                for (;;) {
                    if (mustLeave && leave && leave(this), mustLeave = this.type.isAnonymous, 
                    !depth) return;
                    if (this.nextSibling()) break;
                    this.parent(), depth--, mustLeave = !0;
                }
            }
        }
        matchContext(context) {
            if (!this.buffer) return matchNodeContext(this.node.parent, context);
            var buffer = this.buffer["buffer"], types = buffer.set["types"];
            for (let i = context.length - 1, d = this.stack.length - 1; 0 <= i; d--) {
                if (d < 0) return matchNodeContext(this._tree, context, i);
                var type = types[buffer.buffer[this.stack[d]]];
                if (!type.isAnonymous) {
                    if (context[i] && context[i] != type.name) return !1;
                    i--;
                }
            }
            return !0;
        }
    }
    function hasChild(tree) {
        return tree.children.some(ch => ch instanceof TreeBuffer || !ch.type.isAnonymous || hasChild(ch));
    }
    const nodeSizeCache = new WeakMap();
    function nodeSize(balanceType, node) {
        if (!balanceType.isAnonymous || node instanceof TreeBuffer || node.type != balanceType) return 1;
        let size = nodeSizeCache.get(node);
        if (null == size) {
            size = 1;
            for (var child of node.children) {
                if (child.type != balanceType || !(child instanceof Tree)) {
                    size = 1;
                    break;
                }
                size += nodeSize(balanceType, child);
            }
            nodeSizeCache.set(node, size);
        }
        return size;
    }
    function balanceRange(balanceType, children, positions, from, to, start, length, mkTop, mkTree) {
        let total = 0;
        for (let i = from; i < to; i++) total += nodeSize(balanceType, children[i]);
        let maxChild = Math.ceil(1.5 * total / 8), localChildren = [], localPositions = [];
        return function divide(children, positions, from, to, offset) {
            for (let i = from; i < to; ) {
                let groupFrom = i, groupStart = positions[i], groupSize = nodeSize(balanceType, children[i]);
                for (i++; i < to; i++) {
                    var nextSize = nodeSize(balanceType, children[i]);
                    if (groupSize + nextSize >= maxChild) break;
                    groupSize += nextSize;
                }
                if (i == groupFrom + 1) {
                    if (groupSize > maxChild) {
                        var only = children[groupFrom];
                        divide(only.children, only.positions, 0, only.children.length, positions[groupFrom] + offset);
                        continue;
                    }
                    localChildren.push(children[groupFrom]);
                } else only = positions[i - 1] + children[i - 1].length - groupStart, 
                localChildren.push(balanceRange(balanceType, children, positions, groupFrom, i, groupStart, only, null, mkTree));
                localPositions.push(groupStart + offset - start);
            }
        }(children, positions, from, to, 0), (mkTop || mkTree)(localChildren, localPositions, length);
    }
    class NodeWeakMap {
        constructor() {
            this.map = new WeakMap();
        }
        setBuffer(buffer, index, value) {
            let inner = this.map.get(buffer);
            inner || this.map.set(buffer, inner = new Map()), inner.set(index, value);
        }
        getBuffer(buffer, index) {
            buffer = this.map.get(buffer);
            return buffer && buffer.get(index);
        }
        set(node, value) {
            node instanceof BufferNode ? this.setBuffer(node.context.buffer, node.index, value) : node instanceof TreeNode && this.map.set(node.tree, value);
        }
        get(node) {
            return node instanceof BufferNode ? this.getBuffer(node.context.buffer, node.index) : node instanceof TreeNode ? this.map.get(node.tree) : void 0;
        }
        cursorSet(cursor, value) {
            cursor.buffer ? this.setBuffer(cursor.buffer.buffer, cursor.index, value) : this.map.set(cursor.tree, value);
        }
        cursorGet(cursor) {
            return cursor.buffer ? this.getBuffer(cursor.buffer.buffer, cursor.index) : this.map.get(cursor.tree);
        }
    }
    class TreeFragment {
        constructor(from, to, tree, offset, openStart = !1, openEnd = !1) {
            this.from = from, this.to = to, this.tree = tree, this.offset = offset, 
            this.open = (openStart ? 1 : 0) | (openEnd ? 2 : 0);
        }
        get openStart() {
            return 0 < (1 & this.open);
        }
        get openEnd() {
            return 0 < (2 & this.open);
        }
        static addTree(tree, fragments = [], partial = !1) {
            var f, result = [ new TreeFragment(0, tree.length, tree, 0, !1, partial) ];
            for (f of fragments) f.to > tree.length && result.push(f);
            return result;
        }
        static applyChanges(fragments, changes, minGap = 128) {
            if (!changes.length) return fragments;
            var result = [];
            let fI = 1, nextF = fragments.length ? fragments[0] : null;
            for (let cI = 0, pos = 0, off = 0; ;cI++) {
                var fFrom, fTo, nextC = cI < changes.length ? changes[cI] : null, nextPos = nextC ? nextC.fromA : 1e9;
                if (nextPos - pos >= minGap) for (;nextF && nextF.from < nextPos; ) {
                    let cut = nextF;
                    if ((pos >= cut.from || nextPos <= cut.to || off) && (fFrom = Math.max(cut.from, pos) - off, 
                    fTo = Math.min(cut.to, nextPos) - off, cut = fTo <= fFrom ? null : new TreeFragment(fFrom, fTo, cut.tree, cut.offset + off, 0 < cI, !!nextC)), 
                    cut && result.push(cut), nextF.to > nextPos) break;
                    nextF = fI < fragments.length ? fragments[fI++] : null;
                }
                if (!nextC) break;
                pos = nextC.toA, off = nextC.toA - nextC.toB;
            }
            return result;
        }
    }
    class Parser {
        startParse(input, fragments, ranges) {
            return "string" == typeof input && (input = new StringInput(input)), 
            ranges = ranges ? ranges.length ? ranges.map(r => new Range(r.from, r.to)) : [ new Range(0, 0) ] : [ new Range(0, input.length) ], 
            this.createParse(input, fragments || [], ranges);
        }
        parse(input, fragments, ranges) {
            for (var parse = this.startParse(input, fragments, ranges); ;) {
                var done = parse.advance();
                if (done) return done;
            }
        }
    }
    class StringInput {
        constructor(string) {
            this.string = string;
        }
        get length() {
            return this.string.length;
        }
        chunk(from) {
            return this.string.slice(from);
        }
        get lineChunks() {
            return !1;
        }
        read(from, to) {
            return this.string.slice(from, to);
        }
    }
    function parseMixed(nest) {
        return (parse, input, fragments, ranges) => new MixedParse(parse, nest, input, fragments, ranges);
    }
    class InnerParse {
        constructor(parser, parse, overlay, target, from) {
            this.parser = parser, this.parse = parse, this.overlay = overlay, this.target = target, 
            this.from = from;
        }
    }
    function checkRanges(ranges) {
        if (!ranges.length || ranges.some(r => r.from >= r.to)) throw new RangeError("Invalid inner parse ranges given: " + JSON.stringify(ranges));
    }
    class ActiveOverlay {
        constructor(parser, predicate, mounts, index, start, target, prev) {
            this.parser = parser, this.predicate = predicate, this.mounts = mounts, 
            this.index = index, this.start = start, this.target = target, this.prev = prev, 
            this.depth = 0, this.ranges = [];
        }
    }
    const stoppedInner = new NodeProp({
        perNode: !0
    });
    class MixedParse {
        constructor(base, nest, input, fragments, ranges) {
            this.nest = nest, this.input = input, this.fragments = fragments, this.ranges = ranges, 
            this.inner = [], this.innerDone = 0, this.baseTree = null, this.stoppedAt = null, 
            this.baseParse = base;
        }
        advance() {
            if (this.baseParse) {
                let done = this.baseParse.advance();
                if (!done) return null;
                if (this.baseParse = null, this.baseTree = done, this.startInner(), 
                null != this.stoppedAt) for (let inner of this.inner) inner.parse.stopAt(this.stoppedAt);
            }
            if (this.innerDone == this.inner.length) {
                let result = this.baseTree;
                return result = null != this.stoppedAt ? new Tree(result.type, result.children, result.positions, result.length, result.propValues.concat([ [ stoppedInner, this.stoppedAt ] ])) : result;
            }
            var props, inner = this.inner[this.innerDone], done = inner.parse.advance();
            return done && (this.innerDone++, (props = Object.assign(Object.create(null), inner.target.props))[NodeProp.mounted.id] = new MountedTree(done, inner.overlay, inner.parser), 
            inner.target.props = props), null;
        }
        get parsedPos() {
            if (this.baseParse) return 0;
            let pos = this.input.length;
            for (let i = this.innerDone; i < this.inner.length; i++) this.inner[i].from < pos && (pos = Math.min(pos, this.inner[i].parse.parsedPos));
            return pos;
        }
        stopAt(pos) {
            if (this.stoppedAt = pos, this.baseParse) this.baseParse.stopAt(pos); else for (let i = this.innerDone; i < this.inner.length; i++) this.inner[i].parse.stopAt(pos);
        }
        startInner() {
            var ranges, oldMounts, fragmentCursor = new FragmentCursor$2(this.fragments);
            let overlay = null, covered = null, cursor = new TreeCursor(new TreeNode(this.baseTree, this.ranges[0].from, 0, null), IterMode.IncludeAnonymous | IterMode.IgnoreMounts);
            scan: for (let nest, isCovered; ;) {
                let enter = !0, range;
                if (null != this.stoppedAt && cursor.from >= this.stoppedAt) enter = !1; else if (fragmentCursor.hasNode(cursor)) {
                    if (overlay) {
                        var match = overlay.mounts.find(m => m.frag.from <= cursor.from && m.frag.to >= cursor.to && m.mount.overlay);
                        if (match) for (var r of match.mount.overlay) {
                            let from = r.from + match.pos, to = r.to + match.pos;
                            from >= cursor.from && to <= cursor.to && !overlay.ranges.some(r => r.from < to && r.to > from) && overlay.ranges.push({
                                from: from,
                                to: to
                            });
                        }
                    }
                    enter = !1;
                } else covered && (isCovered = function(covered, from, to) {
                    for (var range of covered) {
                        if (range.from >= to) break;
                        if (range.to > from) return range.from <= from && range.to >= to ? 2 : 1;
                    }
                    return 0;
                }(covered.ranges, cursor.from, cursor.to)) ? enter = 2 != isCovered : !cursor.type.isAnonymous && (nest = this.nest(cursor, this.input)) && (cursor.from < cursor.to || !nest.overlay) ? (cursor.tree || function(cursor) {
                    let node = cursor["node"], stack = [], buffer = node.context.buffer;
                    for (;stack.push(cursor.index), cursor.parent(), !cursor.tree; );
                    let base = cursor.tree, i = base.children.indexOf(buffer), buf = base.children[i], b = buf.buffer, newStack = [ i ];
                    base.children[i] = function split(startI, endI, type, innerOffset, length, stackPos) {
                        var targetI = stack[stackPos], children = [], positions = [], startI = (sliceBuf(buf, startI, targetI, children, positions, innerOffset), 
                        b[targetI + 1]), to = b[targetI + 2], to = (newStack.push(children.length), 
                        stackPos ? split(targetI + 4, b[targetI + 3], buf.set.types[b[targetI]], startI, to - startI, stackPos - 1) : node.toTree());
                        return children.push(to), positions.push(startI - innerOffset), 
                        sliceBuf(buf, b[targetI + 3], endI, children, positions, innerOffset), 
                        new Tree(type, children, positions, length);
                    }(0, b.length, NodeType.none, 0, buf.length, stack.length - 1);
                    for (var index of newStack) {
                        var tree = cursor.tree.children[index], pos = cursor.tree.positions[index];
                        cursor.yield(new TreeNode(tree, pos + cursor.from, index, cursor._tree));
                    }
                }(cursor), oldMounts = fragmentCursor.findMounts(cursor.from, nest.parser), 
                "function" == typeof nest.overlay ? overlay = new ActiveOverlay(nest.parser, nest.overlay, oldMounts, this.inner.length, cursor.from, cursor.tree, overlay) : ((ranges = punchRanges(this.ranges, nest.overlay || (cursor.from < cursor.to ? [ new Range(cursor.from, cursor.to) ] : []))).length && checkRanges(ranges), 
                !ranges.length && nest.overlay || this.inner.push(new InnerParse(nest.parser, ranges.length ? nest.parser.startParse(this.input, enterFragments(oldMounts, ranges), ranges) : nest.parser.startParse(""), nest.overlay ? nest.overlay.map(r => new Range(r.from - cursor.from, r.to - cursor.from)) : null, cursor.tree, (ranges.length ? ranges[0] : cursor).from)), 
                nest.overlay ? ranges.length && (covered = {
                    ranges: ranges,
                    depth: 0,
                    prev: covered
                }) : enter = !1)) : overlay && (range = overlay.predicate(cursor)) && (range = !0 === range ? new Range(cursor.from, cursor.to) : range).from < range.to && (0 <= (oldMounts = overlay.ranges.length - 1) && overlay.ranges[oldMounts].to == range.from ? overlay.ranges[oldMounts] = {
                    from: overlay.ranges[oldMounts].from,
                    to: range.to
                } : overlay.ranges.push(range));
                if (enter && cursor.firstChild()) overlay && overlay.depth++, covered && covered.depth++; else for (;!cursor.nextSibling(); ) {
                    if (!cursor.parent()) break scan;
                    if (overlay && !--overlay.depth) {
                        let ranges = punchRanges(this.ranges, overlay.ranges);
                        ranges.length && (checkRanges(ranges), this.inner.splice(overlay.index, 0, new InnerParse(overlay.parser, overlay.parser.startParse(this.input, enterFragments(overlay.mounts, ranges), ranges), overlay.ranges.map(r => new Range(r.from - overlay.start, r.to - overlay.start)), overlay.target, ranges[0].from))), 
                        overlay = overlay.prev;
                    }
                    covered && !--covered.depth && (covered = covered.prev);
                }
            }
        }
    }
    function sliceBuf(buf, startI, endI, nodes, positions, off) {
        var from;
        startI < endI && (from = buf.buffer[startI + 1], nodes.push(buf.slice(startI, endI, from)), 
        positions.push(from - off));
    }
    class StructureCursor {
        constructor(root, offset) {
            this.offset = offset, this.done = !1, this.cursor = root.cursor(IterMode.IncludeAnonymous | IterMode.IgnoreMounts);
        }
        moveTo(pos) {
            for (var cursor = this["cursor"], p = pos - this.offset; !this.done && cursor.from < p; ) cursor.to >= pos && cursor.enter(p, 1, IterMode.IgnoreOverlays | IterMode.ExcludeBuffers) || cursor.next(!1) || (this.done = !0);
        }
        hasNode(cursor) {
            if (this.moveTo(cursor.from), !this.done && this.cursor.from + this.offset == cursor.from && this.cursor.tree) for (let tree = this.cursor.tree; ;) {
                if (tree == cursor.tree) return !0;
                if (!(tree.children.length && 0 == tree.positions[0] && tree.children[0] instanceof Tree)) break;
                tree = tree.children[0];
            }
            return !1;
        }
    }
    let FragmentCursor$2 = class {
        constructor(fragments) {
            var _a;
            this.fragments = fragments, this.curTo = 0, this.fragI = 0, fragments.length ? (fragments = this.curFrag = fragments[0], 
            this.curTo = null != (_a = fragments.tree.prop(stoppedInner)) ? _a : fragments.to, 
            this.inner = new StructureCursor(fragments.tree, -fragments.offset)) : this.curFrag = this.inner = null;
        }
        hasNode(node) {
            for (;this.curFrag && node.from >= this.curTo; ) this.nextFrag();
            return this.curFrag && this.curFrag.from <= node.from && this.curTo >= node.to && this.inner.hasNode(node);
        }
        nextFrag() {
            var _a, frag;
            this.fragI++, this.fragI == this.fragments.length ? this.curFrag = this.inner = null : (frag = this.curFrag = this.fragments[this.fragI], 
            this.curTo = null != (_a = frag.tree.prop(stoppedInner)) ? _a : frag.to, 
            this.inner = new StructureCursor(frag.tree, -frag.offset));
        }
        findMounts(pos, parser) {
            var _a, result = [];
            if (this.inner) {
                this.inner.cursor.moveTo(pos, 1);
                for (let pos = this.inner.cursor.node; pos; pos = pos.parent) {
                    var mount = null == (_a = pos.tree) ? void 0 : _a.prop(NodeProp.mounted);
                    if (mount && mount.parser == parser) for (let i = this.fragI; i < this.fragments.length; i++) {
                        var frag = this.fragments[i];
                        if (frag.from >= pos.to) break;
                        frag.tree == this.curFrag.tree && result.push({
                            frag: frag,
                            pos: pos.from - frag.offset,
                            mount: mount
                        });
                    }
                }
            }
            return result;
        }
    };
    function punchRanges(outer, ranges) {
        let copy = null, current = ranges;
        for (let i = 1, j = 0; i < outer.length; i++) for (var gapFrom = outer[i - 1].to, gapTo = outer[i].from; j < current.length; j++) {
            var r = current[j];
            if (r.from >= gapTo) break;
            r.to <= gapFrom || (copy || (current = copy = ranges.slice()), r.from < gapFrom ? (copy[j] = new Range(r.from, gapFrom), 
            r.to > gapTo && copy.splice(j + 1, 0, new Range(gapTo, r.to))) : r.to > gapTo ? copy[j--] = new Range(gapTo, r.to) : copy.splice(j--, 1));
        }
        return current;
    }
    function enterFragments(mounts, ranges) {
        var result = [];
        for (let {
            pos,
            mount,
            frag
        } of mounts) {
            var startPos = pos + (mount.overlay ? mount.overlay[0].from : 0), endPos = startPos + mount.tree.length, from = Math.max(frag.from, startPos), to = Math.min(frag.to, endPos);
            if (mount.overlay) {
                var changes = function(a, b, from, to) {
                    let iA = 0, iB = 0, inA = !1, inB = !1, pos = -1e9;
                    for (var result = []; ;) {
                        var start, end, nextA = iA == a.length ? 1e9 : inA ? a[iA].to : a[iA].from, nextB = iB == b.length ? 1e9 : inB ? b[iB].to : b[iB].from;
                        if (inA != inB && (start = Math.max(pos, from)) < (end = Math.min(nextA, nextB, to)) && result.push(new Range(start, end)), 
                        1e9 == (pos = Math.min(nextA, nextB))) break;
                        nextA == pos && (inA ? (inA = !1, iA++) : inA = !0), nextB == pos && (inB ? (inB = !1, 
                        iB++) : inB = !0);
                    }
                    return result;
                }(ranges, mount.overlay.map(r => new Range(r.from + pos, r.to + pos)), from, to);
                for (let i = 0, pos = from; ;i++) {
                    var last = i == changes.length, end = last ? to : changes[i].from;
                    if (end > pos && result.push(new TreeFragment(pos, end, mount.tree, -startPos, frag.from >= pos || frag.openStart, frag.to <= end || frag.openEnd)), 
                    last) break;
                    pos = changes[i].to;
                }
            } else result.push(new TreeFragment(from, to, mount.tree, -startPos, frag.from >= startPos || frag.openStart, frag.to <= endPos || frag.openEnd));
        }
        return result;
    }
    let nextTagID = 0;
    class Tag {
        constructor(name, set, base, modified) {
            this.name = name, this.set = set, this.base = base, this.modified = modified, 
            this.id = nextTagID++;
        }
        toString() {
            let name = this["name"];
            for (var mod of this.modified) mod.name && (name = `${mod.name}(${name})`);
            return name;
        }
        static define(nameOrParent, parent) {
            var name = "string" == typeof nameOrParent ? nameOrParent : "?";
            if (null != (parent = nameOrParent instanceof Tag ? nameOrParent : parent) && parent.base) throw new Error("Can not derive from a modified tag");
            var tag = new Tag(name, [], null, []);
            if (tag.set.push(tag), parent) for (var t of parent.set) tag.set.push(t);
            return tag;
        }
        static defineModifier(name) {
            let mod = new Modifier(name);
            return tag => -1 < tag.modified.indexOf(mod) ? tag : Modifier.get(tag.base || tag, tag.modified.concat(mod).sort((a, b) => a.id - b.id));
        }
    }
    let nextModifierID = 0;
    class Modifier {
        constructor(name) {
            this.name = name, this.instances = [], this.id = nextModifierID++;
        }
        static get(base, mods) {
            if (!mods.length) return base;
            var exists = mods[0].instances.find(t => {
                return t.base == base && (a = mods, b = t.modified, a.length == b.length) && a.every((x, i) => x == b[i]);
                var a, b;
            });
            if (exists) return exists;
            var m, set = [], tag = new Tag(base.name, set, base, mods);
            for (m of mods) m.instances.push(tag);
            var parent, configs = function(array) {
                var sets = [ [] ];
                for (let i = 0; i < array.length; i++) for (let j = 0, e = sets.length; j < e; j++) sets.push(sets[j].concat(array[i]));
                return sets.sort((a, b) => b.length - a.length);
            }(mods);
            for (parent of base.set) if (!parent.modified.length) for (var config of configs) set.push(Modifier.get(parent, config));
            return tag;
        }
    }
    function styleTags(spec) {
        var prop, byName = Object.create(null);
        for (prop in spec) {
            let tags = spec[prop];
            Array.isArray(tags) || (tags = [ tags ]);
            for (var part of prop.split(" ")) if (part) {
                let pieces = [], mode = 2, rest = part;
                for (let pos = 0; ;) {
                    if ("..." == rest && 0 < pos && pos + 3 == part.length) {
                        mode = 1;
                        break;
                    }
                    var m = /^"(?:[^"\\]|\\.)*?"|[^\/!]+/.exec(rest);
                    if (!m) throw new RangeError("Invalid path: " + part);
                    if (pieces.push("*" == m[0] ? "" : '"' == m[0][0] ? JSON.parse(m[0]) : m[0]), 
                    (pos += m[0].length) == part.length) break;
                    m = part[pos++];
                    if (pos == part.length && "!" == m) {
                        mode = 0;
                        break;
                    }
                    if ("/" != m) throw new RangeError("Invalid path: " + part);
                    rest = part.slice(pos);
                }
                var last = pieces.length - 1, inner = pieces[last];
                if (!inner) throw new RangeError("Invalid path: " + part);
                last = new Rule(tags, mode, 0 < last ? pieces.slice(0, last) : null);
                byName[inner] = last.sort(byName[inner]);
            }
        }
        return ruleNodeProp.add(byName);
    }
    const ruleNodeProp = new NodeProp();
    class Rule {
        constructor(tags, mode, context, next) {
            this.tags = tags, this.mode = mode, this.context = context, this.next = next;
        }
        get opaque() {
            return 0 == this.mode;
        }
        get inherit() {
            return 1 == this.mode;
        }
        sort(other) {
            return !other || other.depth < this.depth ? (this.next = other, this) : (other.next = this.sort(other.next), 
            other);
        }
        get depth() {
            return this.context ? this.context.length : 0;
        }
    }
    function tagHighlighter(tags, options) {
        let map = Object.create(null);
        for (var style of tags) if (Array.isArray(style.tag)) for (var tag of style.tag) map[tag.id] = style.class; else map[style.tag.id] = style.class;
        let {
            scope,
            all = null
        } = options || {};
        return {
            style: tags => {
                let cls = all;
                for (var tag of tags) for (var sub of tag.set) {
                    sub = map[sub.id];
                    if (sub) {
                        cls = cls ? cls + " " + sub : sub;
                        break;
                    }
                }
                return cls;
            },
            scope: scope
        };
    }
    function highlightTree(tree, highlighter, putStyle, from = 0, to = tree.length) {
        highlighter = new HighlightBuilder(from, Array.isArray(highlighter) ? highlighter : [ highlighter ], putStyle);
        highlighter.highlightRange(tree.cursor(), from, to, "", highlighter.highlighters), 
        highlighter.flush(to);
    }
    Rule.empty = new Rule([], 2, null);
    class HighlightBuilder {
        constructor(at, highlighters, span) {
            this.at = at, this.highlighters = highlighters, this.span = span, this.class = "";
        }
        startSpan(at, cls) {
            cls != this.class && (this.flush(at), at > this.at && (this.at = at), 
            this.class = cls);
        }
        flush(to) {
            to > this.at && this.class && this.span(this.at, to, this.class);
        }
        highlightRange(cursor, from, to, inheritedClass, highlighters) {
            let {
                type,
                from: start,
                to: end
            } = cursor;
            if (!(to <= start || end <= from)) {
                type.isTop && (highlighters = this.highlighters.filter(h => !h.scope || h.scope(type)));
                let cls = inheritedClass;
                var rule = function(node) {
                    let rule = node.type.prop(ruleNodeProp);
                    for (;rule && rule.context && !node.matchContext(rule.context); ) rule = rule.next;
                    return rule || null;
                }(cursor) || Rule.empty, tagCls = function(highlighters, tags) {
                    let result = null;
                    for (var highlighter of highlighters) {
                        highlighter = highlighter.style(tags);
                        highlighter && (result = result ? result + " " + highlighter : highlighter);
                    }
                    return result;
                }(highlighters, rule.tags);
                if (tagCls && (cls && (cls += " "), cls += tagCls, 1 == rule.mode) && (inheritedClass += (inheritedClass ? " " : "") + tagCls), 
                this.startSpan(Math.max(from, start), cls), !rule.opaque) {
                    let mounted = cursor.tree && cursor.tree.prop(NodeProp.mounted);
                    if (mounted && mounted.overlay) {
                        var inner = cursor.node.enter(mounted.overlay[0].from + start, 1), innerHighlighters = this.highlighters.filter(h => !h.scope || h.scope(mounted.tree.type)), hasChild = cursor.firstChild();
                        for (let i = 0, pos = start; ;i++) {
                            var next = i < mounted.overlay.length ? mounted.overlay[i] : null, nextPos = next ? next.from + start : end, rangeFrom = Math.max(from, pos), rangeTo = Math.min(to, nextPos);
                            if (rangeFrom < rangeTo && hasChild) for (;cursor.from < rangeTo && (this.highlightRange(cursor, rangeFrom, rangeTo, inheritedClass, highlighters), 
                            this.startSpan(Math.min(rangeTo, cursor.to), cls), !(cursor.to >= nextPos)) && cursor.nextSibling(); );
                            if (!next || to < nextPos) break;
                            (pos = next.to + start) > from && (this.highlightRange(inner.cursor(), Math.max(from, next.from + start), Math.min(to, pos), "", innerHighlighters), 
                            this.startSpan(Math.min(to, pos), cls));
                        }
                        hasChild && cursor.parent();
                    } else if (cursor.firstChild()) {
                        mounted && (inheritedClass = "");
                        do {
                            if (!(cursor.to <= from)) {
                                if (cursor.from >= to) break;
                                this.highlightRange(cursor, from, to, inheritedClass, highlighters), 
                                this.startSpan(Math.min(to, cursor.to), cls);
                            }
                        } while (cursor.nextSibling());
                        cursor.parent();
                    }
                }
            }
        }
    }
    var ie_11up = Tag.define, ie_edge = ie_11up(), gecko = ie_11up(), chrome = ie_11up(gecko), ios = ie_11up(gecko), safari = ie_11up(), webkit = ie_11up(safari), nav = ie_11up(safari), doc = ie_11up(), ie = ie_11up(doc), ie_upto10 = ie_11up(), operator = ie_11up(), punctuation = ie_11up(), bracket = ie_11up(punctuation), meta = ie_11up();
    const tags$1 = {
        comment: ie_edge,
        lineComment: ie_11up(ie_edge),
        blockComment: ie_11up(ie_edge),
        docComment: ie_11up(ie_edge),
        name: gecko,
        variableName: ie_11up(gecko),
        typeName: chrome,
        tagName: ie_11up(chrome),
        propertyName: ios,
        attributeName: ie_11up(ios),
        className: ie_11up(gecko),
        labelName: ie_11up(gecko),
        namespace: ie_11up(gecko),
        macroName: ie_11up(gecko),
        literal: safari,
        string: webkit,
        docString: ie_11up(webkit),
        character: ie_11up(webkit),
        attributeValue: ie_11up(webkit),
        number: nav,
        integer: ie_11up(nav),
        float: ie_11up(nav),
        bool: ie_11up(safari),
        regexp: ie_11up(safari),
        escape: ie_11up(safari),
        color: ie_11up(safari),
        url: ie_11up(safari),
        keyword: ie_upto10,
        self: ie_11up(ie_upto10),
        null: ie_11up(ie_upto10),
        atom: ie_11up(ie_upto10),
        unit: ie_11up(ie_upto10),
        modifier: ie_11up(ie_upto10),
        operatorKeyword: ie_11up(ie_upto10),
        controlKeyword: ie_11up(ie_upto10),
        definitionKeyword: ie_11up(ie_upto10),
        moduleKeyword: ie_11up(ie_upto10),
        operator: operator,
        derefOperator: ie_11up(operator),
        arithmeticOperator: ie_11up(operator),
        logicOperator: ie_11up(operator),
        bitwiseOperator: ie_11up(operator),
        compareOperator: ie_11up(operator),
        updateOperator: ie_11up(operator),
        definitionOperator: ie_11up(operator),
        typeOperator: ie_11up(operator),
        controlOperator: ie_11up(operator),
        punctuation: punctuation,
        separator: ie_11up(punctuation),
        bracket: bracket,
        angleBracket: ie_11up(bracket),
        squareBracket: ie_11up(bracket),
        paren: ie_11up(bracket),
        brace: ie_11up(bracket),
        content: doc,
        heading: ie,
        heading1: ie_11up(ie),
        heading2: ie_11up(ie),
        heading3: ie_11up(ie),
        heading4: ie_11up(ie),
        heading5: ie_11up(ie),
        heading6: ie_11up(ie),
        contentSeparator: ie_11up(doc),
        list: ie_11up(doc),
        quote: ie_11up(doc),
        emphasis: ie_11up(doc),
        strong: ie_11up(doc),
        link: ie_11up(doc),
        monospace: ie_11up(doc),
        strikethrough: ie_11up(doc),
        inserted: ie_11up(),
        deleted: ie_11up(),
        changed: ie_11up(),
        invalid: ie_11up(),
        meta: meta,
        documentMeta: ie_11up(meta),
        annotation: ie_11up(meta),
        processingInstruction: ie_11up(meta),
        definition: Tag.defineModifier("definition"),
        constant: Tag.defineModifier("constant"),
        function: Tag.defineModifier("function"),
        standard: Tag.defineModifier("standard"),
        local: Tag.defineModifier("local"),
        special: Tag.defineModifier("special")
    };
    for (let name in tags$1) {
        var val = tags$1[name];
        val instanceof Tag && (val.name = name);
    }
    tagHighlighter([ {
        tag: tags$1.link,
        class: "tok-link"
    }, {
        tag: tags$1.heading,
        class: "tok-heading"
    }, {
        tag: tags$1.emphasis,
        class: "tok-emphasis"
    }, {
        tag: tags$1.strong,
        class: "tok-strong"
    }, {
        tag: tags$1.keyword,
        class: "tok-keyword"
    }, {
        tag: tags$1.atom,
        class: "tok-atom"
    }, {
        tag: tags$1.bool,
        class: "tok-bool"
    }, {
        tag: tags$1.url,
        class: "tok-url"
    }, {
        tag: tags$1.labelName,
        class: "tok-labelName"
    }, {
        tag: tags$1.inserted,
        class: "tok-inserted"
    }, {
        tag: tags$1.deleted,
        class: "tok-deleted"
    }, {
        tag: tags$1.literal,
        class: "tok-literal"
    }, {
        tag: tags$1.string,
        class: "tok-string"
    }, {
        tag: tags$1.number,
        class: "tok-number"
    }, {
        tag: [ tags$1.regexp, tags$1.escape, tags$1.special(tags$1.string) ],
        class: "tok-string2"
    }, {
        tag: tags$1.variableName,
        class: "tok-variableName"
    }, {
        tag: tags$1.local(tags$1.variableName),
        class: "tok-variableName tok-local"
    }, {
        tag: tags$1.definition(tags$1.variableName),
        class: "tok-variableName tok-definition"
    }, {
        tag: tags$1.special(tags$1.variableName),
        class: "tok-variableName2"
    }, {
        tag: tags$1.definition(tags$1.propertyName),
        class: "tok-propertyName tok-definition"
    }, {
        tag: tags$1.typeName,
        class: "tok-typeName"
    }, {
        tag: tags$1.namespace,
        class: "tok-namespace"
    }, {
        tag: tags$1.className,
        class: "tok-className"
    }, {
        tag: tags$1.macroName,
        class: "tok-macroName"
    }, {
        tag: tags$1.propertyName,
        class: "tok-propertyName"
    }, {
        tag: tags$1.operator,
        class: "tok-operator"
    }, {
        tag: tags$1.comment,
        class: "tok-comment"
    }, {
        tag: tags$1.meta,
        class: "tok-meta"
    }, {
        tag: tags$1.invalid,
        class: "tok-invalid"
    }, {
        tag: tags$1.punctuation,
        class: "tok-punctuation"
    } ]);
    const languageDataProp = new NodeProp();
    function defineLanguageFacet(baseData) {
        return Facet.define({
            combine: baseData ? values => values.concat(baseData) : void 0
        });
    }
    const sublanguageProp = new NodeProp();
    class Language {
        constructor(data, parser, extraExtensions = [], name = "") {
            this.data = data, this.name = name, EditorState.prototype.hasOwnProperty("tree") || Object.defineProperty(EditorState.prototype, "tree", {
                get() {
                    return syntaxTree(this);
                }
            }), this.parser = parser, this.extension = [ language.of(this), EditorState.languageData.of((state, pos, side) => {
                var top = topNodeAt(state, pos, side), data = top.type.prop(languageDataProp);
                if (!data) return [];
                var base = state.facet(data), data = top.type.prop(sublanguageProp);
                if (data) {
                    var sublang, innerNode = top.resolve(pos - top.from, side);
                    for (sublang of data) if (sublang.test(innerNode, state)) {
                        let data = state.facet(sublang.facet);
                        return "replace" == sublang.type ? data : data.concat(base);
                    }
                }
                return base;
            }) ].concat(extraExtensions);
        }
        isActiveAt(state, pos, side = -1) {
            return topNodeAt(state, pos, side).type.prop(languageDataProp) == this.data;
        }
        findRegions(state) {
            var lang = state.facet(language);
            if ((null == lang ? void 0 : lang.data) == this.data) return [ {
                from: 0,
                to: state.doc.length
            } ];
            if (!lang || !lang.allowsNesting) return [];
            let result = [], explore = (tree, from) => {
                if (tree.prop(languageDataProp) == this.data) result.push({
                    from: from,
                    to: from + tree.length
                }); else {
                    var mount = tree.prop(NodeProp.mounted);
                    if (mount) {
                        if (mount.tree.prop(languageDataProp) == this.data) {
                            if (mount.overlay) for (var r of mount.overlay) result.push({
                                from: r.from + from,
                                to: r.to + from
                            }); else result.push({
                                from: from,
                                to: from + tree.length
                            });
                            return;
                        }
                        if (mount.overlay) {
                            var size = result.length;
                            if (explore(mount.tree, mount.overlay[0].from + from), 
                            result.length > size) return;
                        }
                    }
                    for (let i = 0; i < tree.children.length; i++) {
                        var ch = tree.children[i];
                        ch instanceof Tree && explore(ch, tree.positions[i] + from);
                    }
                }
            };
            return explore(syntaxTree(state), 0), result;
        }
        get allowsNesting() {
            return !0;
        }
    }
    function topNodeAt(state, pos, side) {
        let topLang = state.facet(language), tree = syntaxTree(state).topNode;
        if (!topLang || topLang.allowsNesting) for (let node = tree; node; node = node.enter(pos, side, IterMode.ExcludeBuffers)) node.type.isTop && (tree = node);
        return tree;
    }
    Language.setState = StateEffect.define();
    class LRLanguage extends Language {
        constructor(data, parser, name) {
            super(data, parser, [], name), this.parser = parser;
        }
        static define(spec) {
            let data = defineLanguageFacet(spec.languageData);
            return new LRLanguage(data, spec.parser.configure({
                props: [ languageDataProp.add(type => type.isTop ? data : void 0) ]
            }), spec.name);
        }
        configure(options, name) {
            return new LRLanguage(this.data, this.parser.configure(options), name || this.name);
        }
        get allowsNesting() {
            return this.parser.hasWrappers();
        }
    }
    function syntaxTree(state) {
        state = state.field(Language.state, !1);
        return state ? state.tree : Tree.empty;
    }
    class DocInput {
        constructor(doc) {
            this.doc = doc, this.cursorPos = 0, this.string = "", this.cursor = doc.iter();
        }
        get length() {
            return this.doc.length;
        }
        syncTo(pos) {
            return this.string = this.cursor.next(pos - this.cursorPos).value, this.cursorPos = pos + this.string.length, 
            this.cursorPos - this.string.length;
        }
        chunk(pos) {
            return this.syncTo(pos), this.string;
        }
        get lineChunks() {
            return !0;
        }
        read(from, to) {
            var stringStart = this.cursorPos - this.string.length;
            return from < stringStart || to >= this.cursorPos ? this.doc.sliceString(from, to) : this.string.slice(from - stringStart, to - stringStart);
        }
    }
    let currentContext = null;
    class ParseContext {
        constructor(parser, state, fragments = [], tree, treeLen, viewport, skipped, scheduleOn) {
            this.parser = parser, this.state = state, this.fragments = fragments, 
            this.tree = tree, this.treeLen = treeLen, this.viewport = viewport, 
            this.skipped = skipped, this.scheduleOn = scheduleOn, this.parse = null, 
            this.tempSkipped = [];
        }
        static create(parser, state, viewport) {
            return new ParseContext(parser, state, [], Tree.empty, 0, viewport, [], null);
        }
        startParse() {
            return this.parser.startParse(new DocInput(this.state.doc), this.fragments);
        }
        work(until, upto) {
            return null != upto && upto >= this.state.doc.length && (upto = void 0), 
            this.tree != Tree.empty && this.isDone(null != upto ? upto : this.state.doc.length) ? (this.takeTree(), 
            !0) : this.withContext(() => {
                var _a;
                if ("number" == typeof until) {
                    let endTime = Date.now() + until;
                    until = () => Date.now() > endTime;
                }
                for (this.parse || (this.parse = this.startParse()), null != upto && (null == this.parse.stoppedAt || this.parse.stoppedAt > upto) && upto < this.state.doc.length && this.parse.stopAt(upto); ;) {
                    var done = this.parse.advance();
                    if (done) {
                        if (this.fragments = this.withoutTempSkipped(TreeFragment.addTree(done, this.fragments, null != this.parse.stoppedAt)), 
                        this.treeLen = null != (_a = this.parse.stoppedAt) ? _a : this.state.doc.length, 
                        this.tree = done, this.parse = null, !(this.treeLen < (null != upto ? upto : this.state.doc.length))) return !0;
                        this.parse = this.startParse();
                    }
                    if (until()) return !1;
                }
            });
        }
        takeTree() {
            let pos, tree;
            this.parse && (pos = this.parse.parsedPos) >= this.treeLen && ((null == this.parse.stoppedAt || this.parse.stoppedAt > pos) && this.parse.stopAt(pos), 
            this.withContext(() => {
                for (;!(tree = this.parse.advance()); );
            }), this.treeLen = pos, this.tree = tree, this.fragments = this.withoutTempSkipped(TreeFragment.addTree(this.tree, this.fragments, !0)), 
            this.parse = null);
        }
        withContext(f) {
            var prev = currentContext;
            currentContext = this;
            try {
                return f();
            } finally {
                currentContext = prev;
            }
        }
        withoutTempSkipped(fragments) {
            for (var r; r = this.tempSkipped.pop(); ) fragments = cutFragments(fragments, r.from, r.to);
            return fragments;
        }
        changes(changes, newState) {
            let {
                fragments,
                tree,
                treeLen,
                viewport,
                skipped
            } = this;
            if (this.takeTree(), !changes.empty) {
                let ranges = [];
                if (changes.iterChangedRanges((fromA, toA, fromB, toB) => ranges.push({
                    fromA: fromA,
                    toA: toA,
                    fromB: fromB,
                    toB: toB
                })), fragments = TreeFragment.applyChanges(fragments, ranges), tree = Tree.empty, 
                treeLen = 0, viewport = {
                    from: changes.mapPos(viewport.from, -1),
                    to: changes.mapPos(viewport.to, 1)
                }, this.skipped.length) {
                    skipped = [];
                    for (var r of this.skipped) {
                        var from = changes.mapPos(r.from, 1), r = changes.mapPos(r.to, -1);
                        from < r && skipped.push({
                            from: from,
                            to: r
                        });
                    }
                }
            }
            return new ParseContext(this.parser, newState, fragments, tree, treeLen, viewport, skipped, this.scheduleOn);
        }
        updateViewport(viewport) {
            if (this.viewport.from == viewport.from && this.viewport.to == viewport.to) return !1;
            this.viewport = viewport;
            var startLen = this.skipped.length;
            for (let i = 0; i < this.skipped.length; i++) {
                var {
                    from,
                    to
                } = this.skipped[i];
                from < viewport.to && to > viewport.from && (this.fragments = cutFragments(this.fragments, from, to), 
                this.skipped.splice(i--, 1));
            }
            return !(this.skipped.length >= startLen || (this.reset(), 0));
        }
        reset() {
            this.parse && (this.takeTree(), this.parse = null);
        }
        skipUntilInView(from, to) {
            this.skipped.push({
                from: from,
                to: to
            });
        }
        static getSkippingParser(until) {
            return new class extends Parser {
                createParse(input, fragments, ranges) {
                    let from = ranges[0].from, to = ranges[ranges.length - 1].to;
                    return {
                        parsedPos: from,
                        advance() {
                            var cx = currentContext;
                            if (cx) {
                                for (var r of ranges) cx.tempSkipped.push(r);
                                until && (cx.scheduleOn = cx.scheduleOn ? Promise.all([ cx.scheduleOn, until ]) : until);
                            }
                            return this.parsedPos = to, new Tree(NodeType.none, [], [], to - from);
                        },
                        stoppedAt: null,
                        stopAt() {}
                    };
                }
            }();
        }
        isDone(upto) {
            upto = Math.min(upto, this.state.doc.length);
            var frags = this.fragments;
            return this.treeLen >= upto && frags.length && 0 == frags[0].from && frags[0].to >= upto;
        }
        static get() {
            return currentContext;
        }
    }
    function cutFragments(fragments, from, to) {
        return TreeFragment.applyChanges(fragments, [ {
            fromA: from,
            toA: to,
            fromB: from,
            toB: to
        } ]);
    }
    class LanguageState {
        constructor(context) {
            this.context = context, this.tree = context.tree;
        }
        apply(tr) {
            var newCx;
            return tr.docChanged || this.tree != this.context.tree ? (newCx = this.context.changes(tr.changes, tr.state), 
            tr = this.context.treeLen == tr.startState.doc.length ? void 0 : Math.max(tr.changes.mapPos(this.context.treeLen), newCx.viewport.to), 
            newCx.work(20, tr) || newCx.takeTree(), new LanguageState(newCx)) : this;
        }
        static init(state) {
            var vpTo = Math.min(3e3, state.doc.length), state = ParseContext.create(state.facet(language).parser, state, {
                from: 0,
                to: vpTo
            });
            return state.work(20, vpTo) || state.takeTree(), new LanguageState(state);
        }
    }
    Language.state = StateField.define({
        create: LanguageState.init,
        update(value, tr) {
            for (var e of tr.effects) if (e.is(Language.setState)) return e.value;
            return tr.startState.facet(language) != tr.state.facet(language) ? LanguageState.init(tr.state) : value.apply(tr);
        }
    });
    let requestIdle = callback => {
        let timeout = setTimeout(() => callback(), 500);
        return () => clearTimeout(timeout);
    };
    "undefined" != typeof requestIdleCallback && (requestIdle = callback => {
        let idle = -1, timeout = setTimeout(() => {
            idle = requestIdleCallback(callback, {
                timeout: 400
            });
        }, 100);
        return () => idle < 0 ? clearTimeout(timeout) : cancelIdleCallback(idle);
    });
    const isInputPending = "undefined" != typeof navigator && null != (ie_edge = navigator.scheduling) && ie_edge.isInputPending ? () => navigator.scheduling.isInputPending() : null, parseWorker = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.working = null, this.workScheduled = 0, this.chunkEnd = -1, 
            this.chunkBudget = -1, this.work = this.work.bind(this), this.scheduleWork();
        }
        update(update) {
            var cx = this.view.state.field(Language.state).context;
            (cx.updateViewport(update.view.viewport) || this.view.viewport.to > cx.treeLen) && this.scheduleWork(), 
            (update.docChanged || update.selectionSet) && (this.view.hasFocus && (this.chunkBudget += 50), 
            this.scheduleWork()), this.checkAsyncSchedule(cx);
        }
        scheduleWork() {
            var state, field;
            this.working || (state = this.view["state"], (field = state.field(Language.state)).tree == field.context.tree && field.context.isDone(state.doc.length)) || (this.working = requestIdle(this.work));
        }
        work(deadline) {
            this.working = null;
            var now = Date.now();
            if (this.chunkEnd < now && (this.chunkEnd < 0 || this.view.hasFocus) && (this.chunkEnd = now + 3e4, 
            this.chunkBudget = 3e3), !(this.chunkBudget <= 0)) {
                var {
                    state,
                    viewport: {
                        to: vpTo
                    }
                } = this.view, field = state.field(Language.state);
                if (field.tree != field.context.tree || !field.context.isDone(vpTo + 1e5)) {
                    let endTime = Date.now() + Math.min(this.chunkBudget, 100, deadline && !isInputPending ? Math.max(25, deadline.timeRemaining() - 5) : 1e9);
                    deadline = field.context.treeLen < vpTo && state.doc.length > vpTo + 1e3, 
                    state = field.context.work(() => isInputPending && isInputPending() || Date.now() > endTime, vpTo + (deadline ? 0 : 1e5));
                    this.chunkBudget -= Date.now() - now, (state || this.chunkBudget <= 0) && (field.context.takeTree(), 
                    this.view.dispatch({
                        effects: Language.setState.of(new LanguageState(field.context))
                    })), 0 < this.chunkBudget && (!state || deadline) && this.scheduleWork(), 
                    this.checkAsyncSchedule(field.context);
                }
            }
        }
        checkAsyncSchedule(cx) {
            cx.scheduleOn && (this.workScheduled++, cx.scheduleOn.then(() => this.scheduleWork()).catch(err => logException(this.view.state, err)).then(() => this.workScheduled--), 
            cx.scheduleOn = null);
        }
        destroy() {
            this.working && this.working();
        }
        isWorking() {
            return !!(this.working || 0 < this.workScheduled);
        }
    }, {
        eventHandlers: {
            focus() {
                this.scheduleWork();
            }
        }
    }), language = Facet.define({
        combine(languages) {
            return languages.length ? languages[0] : null;
        },
        enables: language => [ Language.state, parseWorker, EditorView.contentAttributes.compute([ language ], state => {
            state = state.facet(language);
            return state && state.name ? {
                "data-language": state.name
            } : {};
        }) ]
    });
    class LanguageSupport {
        constructor(language, support = []) {
            this.language = language, this.support = support, this.extension = [ language, support ];
        }
    }
    const indentService = Facet.define(), indentUnit = Facet.define({
        combine: values => {
            if (!values.length) return "  ";
            let unit = values[0];
            if (!unit || /\S/.test(unit) || Array.from(unit).some(e => e != unit[0])) throw new Error("Invalid indent unit: " + JSON.stringify(values[0]));
            return unit;
        }
    });
    function getIndentUnit(state) {
        var unit = state.facet(indentUnit);
        return 9 == unit.charCodeAt(0) ? state.tabSize * unit.length : unit.length;
    }
    function indentString(state, cols) {
        let result = "", ts = state.tabSize, ch = state.facet(indentUnit)[0];
        if ("\t" == ch) {
            for (;ts <= cols; ) result += "\t", cols -= ts;
            ch = " ";
        }
        for (let i = 0; i < cols; i++) result += ch;
        return result;
    }
    function getIndentation(context, pos) {
        for (var service of (context = context instanceof EditorState ? new IndentContext(context) : context).state.facet(indentService)) {
            service = service(context, pos);
            if (void 0 !== service) return service;
        }
        var tree = syntaxTree(context.state);
        return tree.length >= pos ? function(cx, ast, pos) {
            let stack = ast.resolveStack(pos), inner = ast.resolveInner(pos, -1).resolve(pos, 0).enterUnfinishedNodesBefore(pos);
            if (inner != stack.node) {
                var add = [];
                for (let cur = inner; cur && !(cur.from < stack.node.from || cur.to > stack.node.to || cur.from == stack.node.from && cur.type == stack.node.type); cur = cur.parent) add.push(cur);
                for (let i = add.length - 1; 0 <= i; i--) stack = {
                    node: add[i],
                    next: stack
                };
            }
            return indentFor(stack, cx, pos);
        }(context, tree, pos) : null;
    }
    class IndentContext {
        constructor(state, options = {}) {
            this.state = state, this.options = options, this.unit = getIndentUnit(state);
        }
        lineAt(pos, bias = 1) {
            var line = this.state.doc.lineAt(pos), {
                simulateBreak,
                simulateDoubleBreak
            } = this.options;
            return null != simulateBreak && simulateBreak >= line.from && simulateBreak <= line.to ? simulateDoubleBreak && simulateBreak == pos ? {
                text: "",
                from: pos
            } : (bias < 0 ? simulateBreak < pos : simulateBreak <= pos) ? {
                text: line.text.slice(simulateBreak - line.from),
                from: simulateBreak
            } : {
                text: line.text.slice(0, simulateBreak - line.from),
                from: line.from
            } : line;
        }
        textAfterPos(pos, bias = 1) {
            var from;
            return this.options.simulateDoubleBreak && pos == this.options.simulateBreak ? "" : ({
                text: bias,
                from
            } = this.lineAt(pos, bias), bias.slice(pos - from, Math.min(bias.length, pos + 100 - from)));
        }
        column(pos, bias = 1) {
            var {
                text: bias,
                from
            } = this.lineAt(pos, bias);
            let result = this.countColumn(bias, pos - from);
            pos = this.options.overrideIndentation ? this.options.overrideIndentation(from) : -1;
            return -1 < pos && (result += pos - this.countColumn(bias, bias.search(/\S|$/))), 
            result;
        }
        countColumn(line, pos = line.length) {
            return countColumn(line, this.state.tabSize, pos);
        }
        lineIndent(pos, bias = 1) {
            var {
                text: pos,
                from: bias
            } = this.lineAt(pos, bias), override = this.options.overrideIndentation;
            if (override) {
                override = override(bias);
                if (-1 < override) return override;
            }
            return this.countColumn(pos, pos.search(/\S|$/));
        }
        get simulatedBreak() {
            return this.options.simulateBreak || null;
        }
    }
    const indentNodeProp = new NodeProp();
    function indentFor(stack, cx, pos) {
        for (let cur = stack; cur; cur = cur.next) {
            var strategy = function(tree) {
                var strategy = tree.type.prop(indentNodeProp);
                if (strategy) return strategy;
                let first = tree.firstChild, close;
                if (first && (close = first.type.prop(NodeProp.closedBy))) {
                    let last = tree.lastChild, closed = last && -1 < close.indexOf(last.name);
                    return cx => delimitedStrategy(cx, !0, 1, void 0, closed && !function(cx) {
                        return cx.pos == cx.options.simulateBreak && cx.options.simulateDoubleBreak;
                    }(cx) ? last.from : void 0);
                }
                return null == tree.parent ? topIndent : null;
            }(cur.node);
            if (strategy) return strategy(TreeIndentContext.create(cx, pos, cur));
        }
        return 0;
    }
    function topIndent() {
        return 0;
    }
    class TreeIndentContext extends IndentContext {
        constructor(base, pos, context) {
            super(base.state, base.options), this.base = base, this.pos = pos, this.context = context;
        }
        get node() {
            return this.context.node;
        }
        static create(base, pos, context) {
            return new TreeIndentContext(base, pos, context);
        }
        get textAfter() {
            return this.textAfterPos(this.pos);
        }
        get baseIndent() {
            return this.baseIndentFor(this.node);
        }
        baseIndentFor(node) {
            let line = this.state.doc.lineAt(node.from);
            for (;;) {
                let atBreak = node.resolve(line.from);
                for (;atBreak.parent && atBreak.parent.from == atBreak.from; ) atBreak = atBreak.parent;
                if (function(parent, of) {
                    for (let cur = of; cur; cur = cur.parent) if (parent == cur) return 1;
                    return;
                }(atBreak, node)) break;
                line = this.state.doc.lineAt(atBreak.from);
            }
            return this.lineIndent(line.from);
        }
        continue() {
            return indentFor(this.context.next, this.base, this.pos);
        }
    }
    function delimitedIndent({
        closing,
        align = !0,
        units = 1
    }) {
        return context => delimitedStrategy(context, align, units, closing);
    }
    function delimitedStrategy(context, align, units, closing, closedAt) {
        var after = context.textAfter, space = after.match(/^\s*/)[0].length, after = closing && after.slice(space, space + closing.length) == closing || closedAt == context.pos + space, closing = align ? function(context) {
            var tree = context.node, openToken = tree.childAfter(tree.from), last = tree.lastChild;
            if (!openToken) return null;
            var sim = context.options.simulateBreak, openLine = context.state.doc.lineAt(openToken.from), lineEnd = null == sim || sim <= openLine.from ? openLine.to : Math.min(openLine.to, sim);
            for (let pos = openToken.to; ;) {
                var space, next = tree.childAfter(pos);
                if (!next || next == last) return null;
                if (!next.type.isSkipped) return next.from >= lineEnd ? null : (space = /^ */.exec(openLine.text.slice(openToken.to - openLine.from))[0].length, 
                {
                    from: openToken.from,
                    to: openToken.to + space
                });
                pos = next.to;
            }
        }(context) : null;
        return closing ? after ? context.column(closing.from) : context.column(closing.to) : context.baseIndent + (after ? 0 : context.unit * units);
    }
    function continuedIndent({
        except,
        units = 1
    } = {}) {
        return context => {
            var matchExcept = except && except.test(context.textAfter);
            return context.baseIndent + (matchExcept ? 0 : units * context.unit);
        };
    }
    const foldService = Facet.define(), foldNodeProp = new NodeProp();
    function foldInside(node) {
        var first = node.firstChild, last = node.lastChild;
        return first && first.to < last.from ? {
            from: first.to,
            to: last.type.isError ? node.to : last.from
        } : null;
    }
    function foldable(state, lineStart, lineEnd) {
        for (var service of state.facet(foldService)) {
            service = service(state, lineStart, lineEnd);
            if (service) return service;
        }
        return function(state, start, end) {
            var ch, tree = syntaxTree(state);
            if (tree.length < end) return null;
            let found = null;
            for (let iter = tree.resolveStack(end, 1); iter; iter = iter.next) {
                var cur = iter.node;
                if (!(cur.to <= end || cur.from > end)) {
                    if (found && cur.from < start) break;
                    var node, prop = cur.type.prop(foldNodeProp);
                    prop && (cur.to < tree.length - 50 || tree.length == state.doc.length || (ch = void 0, 
                    !(ch = (node = cur).lastChild)) || ch.to != node.to || !ch.type.isError) && (node = prop(cur, state)) && node.from <= end && node.from >= start && node.to > end && (found = node);
                }
            }
            return found;
        }(state, lineStart, lineEnd);
    }
    function mapRange(range, mapping) {
        var from = mapping.mapPos(range.from, 1), mapping = mapping.mapPos(range.to, -1);
        return mapping <= from ? void 0 : {
            from: from,
            to: mapping
        };
    }
    const foldEffect = StateEffect.define({
        map: mapRange
    }), unfoldEffect = StateEffect.define({
        map: mapRange
    });
    function selectedLines(view) {
        var lines = [];
        for (let {
            head
        } of view.state.selection.ranges) lines.some(l => l.from <= head && l.to >= head) || lines.push(view.lineBlockAt(head));
        return lines;
    }
    const foldState = StateField.define({
        create() {
            return Decoration.none;
        },
        update(folded, tr) {
            tr.isUserEvent("delete") && tr.changes.iterChangedRanges((fromA, toA) => folded = clearTouchedFolds(folded, fromA, toA)), 
            folded = folded.map(tr.changes);
            for (let e of tr.effects) {
                var preparePlaceholder;
                e.is(foldEffect) && !function(folded, from, to) {
                    let found = !1;
                    return folded.between(from, from, (a, b) => {
                        a == from && b == to && (found = !0);
                    }), found;
                }(folded, e.value.from, e.value.to) ? (preparePlaceholder = tr.state.facet(foldConfig)["preparePlaceholder"], 
                preparePlaceholder = preparePlaceholder ? Decoration.replace({
                    widget: new PreparedFoldWidget(preparePlaceholder(tr.state, e.value))
                }) : foldWidget, folded = folded.update({
                    add: [ preparePlaceholder.range(e.value.from, e.value.to) ]
                })) : e.is(unfoldEffect) && (folded = folded.update({
                    filter: (from, to) => e.value.from != from || e.value.to != to,
                    filterFrom: e.value.from,
                    filterTo: e.value.to
                }));
            }
            return folded = tr.selection ? clearTouchedFolds(folded, tr.selection.main.head) : folded;
        },
        provide: f => EditorView.decorations.from(f),
        toJSON(folded, state) {
            let ranges = [];
            return folded.between(0, state.doc.length, (from, to) => {
                ranges.push(from, to);
            }), ranges;
        },
        fromJSON(value) {
            if (!Array.isArray(value) || value.length % 2) throw new RangeError("Invalid JSON for fold state");
            var ranges = [];
            for (let i = 0; i < value.length; ) {
                var from = value[i++], to = value[i++];
                if ("number" != typeof from || "number" != typeof to) throw new RangeError("Invalid JSON for fold state");
                ranges.push(foldWidget.range(from, to));
            }
            return Decoration.set(ranges, !0);
        }
    });
    function clearTouchedFolds(folded, from, to = from) {
        let touched = !1;
        return folded.between(from, to, (a, b) => {
            a < to && from < b && (touched = !0);
        }), touched ? folded.update({
            filterFrom: from,
            filterTo: to,
            filter: (a, b) => to <= a || b <= from
        }) : folded;
    }
    function findFold(state, from, to) {
        let found = null;
        return null != (state = state.field(foldState, !1)) && state.between(from, to, (from, to) => {
            (!found || found.from > from) && (found = {
                from: from,
                to: to
            });
        }), found;
    }
    function maybeEnable(state, other) {
        return state.field(foldState, !1) ? other : other.concat(StateEffect.appendConfig.of(codeFolding()));
    }
    function announceFold(view, range, fold = !0) {
        var lineFrom = view.state.doc.lineAt(range.from).number, range = view.state.doc.lineAt(range.to).number;
        return EditorView.announce.of(`${view.state.phrase(fold ? "Folded lines" : "Unfolded lines")} ${lineFrom} ${view.state.phrase("to")} ${range}.`);
    }
    chrome = [ {
        key: "Ctrl-Shift-[",
        mac: "Cmd-Alt-[",
        run: view => {
            for (var line of selectedLines(view)) {
                line = foldable(view.state, line.from, line.to);
                if (line) return view.dispatch({
                    effects: maybeEnable(view.state, [ foldEffect.of(line), announceFold(view, line) ])
                }), !0;
            }
            return !1;
        }
    }, {
        key: "Ctrl-Shift-]",
        mac: "Cmd-Alt-]",
        run: view => {
            if (!view.state.field(foldState, !1)) return !1;
            var line, effects = [];
            for (line of selectedLines(view)) {
                var folded = findFold(view.state, line.from, line.to);
                folded && effects.push(unfoldEffect.of(folded), announceFold(view, folded, !1));
            }
            return effects.length && view.dispatch({
                effects: effects
            }), 0 < effects.length;
        }
    }, {
        key: "Ctrl-Alt-[",
        run: view => {
            var state = view["state"], effects = [];
            for (let pos = 0; pos < state.doc.length; ) {
                var line = view.lineBlockAt(pos), range = foldable(state, line.from, line.to);
                range && effects.push(foldEffect.of(range)), pos = (range ? view.lineBlockAt(range.to) : line).to + 1;
            }
            return effects.length && view.dispatch({
                effects: maybeEnable(view.state, effects)
            }), !!effects.length;
        }
    }, {
        key: "Ctrl-Alt-]",
        run: view => {
            var field = view.state.field(foldState, !1);
            if (!field || !field.size) return !1;
            let effects = [];
            return field.between(0, view.state.doc.length, (from, to) => {
                effects.push(unfoldEffect.of({
                    from: from,
                    to: to
                }));
            }), view.dispatch({
                effects: effects
            }), !0;
        }
    } ];
    const defaultConfig = {
        placeholderDOM: null,
        preparePlaceholder: null,
        placeholderText: "\u2026"
    }, foldConfig = Facet.define({
        combine(values) {
            return combineConfig(values, defaultConfig);
        }
    });
    function codeFolding() {
        return [ foldState, baseTheme$1$1 ];
    }
    function widgetToDOM(view, prepared) {
        var state = view["state"], conf = state.facet(foldConfig), onclick = event => {
            var line = view.lineBlockAt(view.posAtDOM(event.target)), line = findFold(view.state, line.from, line.to);
            line && view.dispatch({
                effects: unfoldEffect.of(line)
            }), event.preventDefault();
        };
        return conf.placeholderDOM ? conf.placeholderDOM(view, onclick, prepared) : ((prepared = document.createElement("span")).textContent = conf.placeholderText, 
        prepared.setAttribute("aria-label", state.phrase("folded code")), prepared.title = state.phrase("unfold"), 
        prepared.className = "cm-foldPlaceholder", prepared.onclick = onclick, prepared);
    }
    const foldWidget = Decoration.replace({
        widget: new class extends WidgetType {
            toDOM(view) {
                return widgetToDOM(view, null);
            }
        }()
    });
    class PreparedFoldWidget extends WidgetType {
        constructor(value) {
            super(), this.value = value;
        }
        eq(other) {
            return this.value == other.value;
        }
        toDOM(view) {
            return widgetToDOM(view, this.value);
        }
    }
    const foldGutterDefaults = {
        openText: "\u2304",
        closedText: "\u203a",
        markerDOM: null,
        domEventHandlers: {},
        foldingChanged: () => !1
    };
    class FoldMarker extends GutterMarker {
        constructor(config, open) {
            super(), this.config = config, this.open = open;
        }
        eq(other) {
            return this.config == other.config && this.open == other.open;
        }
        toDOM(view) {
            var span;
            return this.config.markerDOM ? this.config.markerDOM(this.open) : ((span = document.createElement("span")).textContent = this.open ? this.config.openText : this.config.closedText, 
            span.title = view.state.phrase(this.open ? "Fold line" : "Unfold line"), 
            span);
        }
    }
    const baseTheme$1$1 = EditorView.baseTheme({
        ".cm-foldPlaceholder": {
            backgroundColor: "#eee",
            border: "1px solid #ddd",
            color: "#888",
            borderRadius: ".2em",
            margin: "0 1px",
            padding: "0 1px",
            cursor: "pointer"
        },
        ".cm-foldGutter span": {
            padding: "0 1px",
            cursor: "pointer"
        }
    });
    class HighlightStyle {
        constructor(specs, options) {
            this.specs = specs;
            let modSpec;
            function def(spec) {
                var cls = StyleModule.newName();
                return (modSpec = modSpec || Object.create(null))["." + cls] = spec, 
                cls;
            }
            var all = "string" == typeof options.all ? options.all : options.all ? def(options.all) : void 0;
            const scopeOpt = options.scope;
            this.scope = scopeOpt instanceof Language ? type => type.prop(languageDataProp) == scopeOpt.data : scopeOpt ? type => type == scopeOpt : void 0, 
            this.style = tagHighlighter(specs.map(style => ({
                tag: style.tag,
                class: style.class || def(Object.assign({}, style, {
                    tag: null
                }))
            })), {
                all: all
            }).style, this.module = modSpec ? new StyleModule(modSpec) : null, this.themeType = options.themeType;
        }
        static define(specs, options) {
            return new HighlightStyle(specs, options || {});
        }
    }
    const highlighterFacet = Facet.define(), fallbackHighlighter = Facet.define({
        combine(values) {
            return values.length ? [ values[0] ] : null;
        }
    });
    function getHighlighters(state) {
        var main = state.facet(highlighterFacet);
        return main.length ? main : state.facet(fallbackHighlighter);
    }
    function syntaxHighlighting(highlighter, options) {
        let ext = [ treeHighlighter ], themeType;
        return highlighter instanceof HighlightStyle && (highlighter.module && ext.push(EditorView.styleModule.of(highlighter.module)), 
        themeType = highlighter.themeType), null != options && options.fallback ? ext.push(fallbackHighlighter.of(highlighter)) : themeType ? ext.push(highlighterFacet.computeN([ EditorView.darkTheme ], state => state.facet(EditorView.darkTheme) == ("dark" == themeType) ? [ highlighter ] : [])) : ext.push(highlighterFacet.of(highlighter)), 
        ext;
    }
    class TreeHighlighter {
        constructor(view) {
            this.markCache = Object.create(null), this.tree = syntaxTree(view.state), 
            this.decorations = this.buildDeco(view, getHighlighters(view.state)), 
            this.decoratedTo = view.viewport.to;
        }
        update(update) {
            var tree = syntaxTree(update.state), highlighters = getHighlighters(update.state), styleChange = highlighters != getHighlighters(update.startState), viewport = update.view["viewport"], decoratedToMapped = update.changes.mapPos(this.decoratedTo, 1);
            tree.length < viewport.to && !styleChange && tree.type == this.tree.type && decoratedToMapped >= viewport.to ? (this.decorations = this.decorations.map(update.changes), 
            this.decoratedTo = decoratedToMapped) : (tree != this.tree || update.viewportChanged || styleChange) && (this.tree = tree, 
            this.decorations = this.buildDeco(update.view, highlighters), this.decoratedTo = viewport.to);
        }
        buildDeco(view, highlighters) {
            if (!highlighters || !this.tree.length) return Decoration.none;
            let builder = new RangeSetBuilder();
            for (var {
                from,
                to
            } of view.visibleRanges) highlightTree(this.tree, highlighters, (from, to, style) => {
                builder.add(from, to, this.markCache[style] || (this.markCache[style] = Decoration.mark({
                    class: style
                })));
            }, from, to);
            return builder.finish();
        }
    }
    const treeHighlighter = Prec.high(ViewPlugin.fromClass(TreeHighlighter, {
        decorations: v => v.decorations
    }));
    ios = HighlightStyle.define([ {
        tag: tags$1.meta,
        color: "#404740"
    }, {
        tag: tags$1.link,
        textDecoration: "underline"
    }, {
        tag: tags$1.heading,
        textDecoration: "underline",
        fontWeight: "bold"
    }, {
        tag: tags$1.emphasis,
        fontStyle: "italic"
    }, {
        tag: tags$1.strong,
        fontWeight: "bold"
    }, {
        tag: tags$1.strikethrough,
        textDecoration: "line-through"
    }, {
        tag: tags$1.keyword,
        color: "#708"
    }, {
        tag: [ tags$1.atom, tags$1.bool, tags$1.url, tags$1.contentSeparator, tags$1.labelName ],
        color: "#219"
    }, {
        tag: [ tags$1.literal, tags$1.inserted ],
        color: "#164"
    }, {
        tag: [ tags$1.string, tags$1.deleted ],
        color: "#a11"
    }, {
        tag: [ tags$1.regexp, tags$1.escape, tags$1.special(tags$1.string) ],
        color: "#e40"
    }, {
        tag: tags$1.definition(tags$1.variableName),
        color: "#00f"
    }, {
        tag: tags$1.local(tags$1.variableName),
        color: "#30a"
    }, {
        tag: [ tags$1.typeName, tags$1.namespace ],
        color: "#085"
    }, {
        tag: tags$1.className,
        color: "#167"
    }, {
        tag: [ tags$1.special(tags$1.variableName), tags$1.macroName ],
        color: "#256"
    }, {
        tag: tags$1.definition(tags$1.propertyName),
        color: "#00c"
    }, {
        tag: tags$1.comment,
        color: "#940"
    }, {
        tag: tags$1.invalid,
        color: "#f00"
    } ]), gecko = EditorView.baseTheme({
        "&.cm-focused .cm-matchingBracket": {
            backgroundColor: "#328c8252"
        },
        "&.cm-focused .cm-nonmatchingBracket": {
            backgroundColor: "#bb555544"
        }
    });
    const DefaultScanDist = 1e4, DefaultBrackets = "()[]{}", bracketMatchingConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                afterCursor: !0,
                brackets: DefaultBrackets,
                maxScanDistance: DefaultScanDist,
                renderMatch: defaultRenderMatch
            });
        }
    }), matchingMark = Decoration.mark({
        class: "cm-matchingBracket"
    }), nonmatchingMark = Decoration.mark({
        class: "cm-nonmatchingBracket"
    });
    function defaultRenderMatch(match) {
        var decorations = [], mark = match.matched ? matchingMark : nonmatchingMark;
        return decorations.push(mark.range(match.start.from, match.start.to)), match.end && decorations.push(mark.range(match.end.from, match.end.to)), 
        decorations;
    }
    const bracketMatchingUnique = [ StateField.define({
        create() {
            return Decoration.none;
        },
        update(deco, tr) {
            if (!tr.docChanged && !tr.selection) return deco;
            let decorations = [];
            var range, match, config = tr.state.facet(bracketMatchingConfig);
            for (range of tr.state.selection.ranges) range.empty && (match = matchBrackets(tr.state, range.head, -1, config) || 0 < range.head && matchBrackets(tr.state, range.head - 1, 1, config) || config.afterCursor && (matchBrackets(tr.state, range.head, 1, config) || range.head < tr.state.doc.length && matchBrackets(tr.state, range.head + 1, -1, config))) && (decorations = decorations.concat(config.renderMatch(match, tr.state)));
            return Decoration.set(decorations, !0);
        },
        provide: f => EditorView.decorations.from(f)
    }), gecko ];
    function bracketMatching(config = {}) {
        return [ bracketMatchingConfig.of(config), bracketMatchingUnique ];
    }
    const bracketMatchingHandle = new NodeProp();
    function matchingNodes(node, dir, brackets) {
        var byProp = node.prop(dir < 0 ? NodeProp.openedBy : NodeProp.closedBy);
        if (byProp) return byProp;
        if (1 == node.name.length) {
            byProp = brackets.indexOf(node.name);
            if (-1 < byProp && byProp % 2 == (dir < 0 ? 1 : 0)) return [ brackets[byProp + dir] ];
        }
        return null;
    }
    function findHandle(node) {
        var hasHandle = node.type.prop(bracketMatchingHandle);
        return hasHandle ? hasHandle(node.node) : node;
    }
    function matchBrackets(state, pos, dir, config = {}) {
        var maxScanDistance = config.maxScanDistance || DefaultScanDist, brackets = config.brackets || DefaultBrackets, config = syntaxTree(state), node = config.resolveInner(pos, dir);
        for (let cur = node; cur; cur = cur.parent) {
            var matches = matchingNodes(cur.type, dir, brackets);
            if (matches && cur.from < cur.to) {
                var handle = findHandle(cur);
                if (handle && (0 < dir ? pos >= handle.from && pos < handle.to : pos > handle.from && pos <= handle.to)) return function(dir, token, handle, matching, brackets) {
                    let parent = token.parent, firstToken = {
                        from: handle.from,
                        to: handle.to
                    }, depth = 0, cursor = null == parent ? void 0 : parent.cursor();
                    if (cursor && (dir < 0 ? cursor.childBefore(token.from) : cursor.childAfter(token.to))) do {
                        if (dir < 0 ? cursor.to <= token.from : cursor.from >= token.to) {
                            var endHandle, endHandle;
                            if (0 == depth && -1 < matching.indexOf(cursor.type.name) && cursor.from < cursor.to) return endHandle = findHandle(cursor), 
                            {
                                start: firstToken,
                                end: endHandle ? {
                                    from: endHandle.from,
                                    to: endHandle.to
                                } : void 0,
                                matched: !0
                            };
                            if (matchingNodes(cursor.type, dir, brackets)) depth++; else if (matchingNodes(cursor.type, -dir, brackets)) {
                                if (0 == depth) return endHandle = findHandle(cursor), 
                                {
                                    start: firstToken,
                                    end: endHandle && endHandle.from < endHandle.to ? {
                                        from: endHandle.from,
                                        to: endHandle.to
                                    } : void 0,
                                    matched: !1
                                };
                                depth--;
                            }
                        }
                    } while (dir < 0 ? cursor.prevSibling() : cursor.nextSibling());
                    return {
                        start: firstToken,
                        matched: !1
                    };
                }(dir, cur, handle, matches, brackets);
            }
        }
        return function(state, pos, dir, tree, tokenType, maxScanDistance, brackets) {
            var startCh = dir < 0 ? state.sliceDoc(pos - 1, pos) : state.sliceDoc(pos, pos + 1), bracket = brackets.indexOf(startCh);
            if (bracket < 0 || bracket % 2 == 0 != 0 < dir) return null;
            let startToken = {
                from: dir < 0 ? pos - 1 : pos,
                to: 0 < dir ? pos + 1 : pos
            }, iter = state.doc.iterRange(pos, 0 < dir ? state.doc.length : 0), depth = 0;
            for (let distance = 0; !iter.next().done && distance <= maxScanDistance; ) {
                var text = iter.value, basePos = (dir < 0 && (distance += text.length), 
                pos + distance * dir);
                for (let pos = 0 < dir ? 0 : text.length - 1, end = 0 < dir ? text.length : -1; pos != end; pos += dir) {
                    var found = brackets.indexOf(text[pos]);
                    if (!(found < 0 || tree.resolveInner(basePos + pos, 1).type != tokenType)) if (found % 2 == 0 == 0 < dir) depth++; else {
                        if (1 == depth) return {
                            start: startToken,
                            end: {
                                from: basePos + pos,
                                to: basePos + pos + 1
                            },
                            matched: found >> 1 == bracket >> 1
                        };
                        depth--;
                    }
                }
                0 < dir && (distance += text.length);
            }
            return iter.done ? {
                start: startToken,
                matched: !1
            } : null;
        }(state, pos, dir, config, node.type, maxScanDistance, brackets);
    }
    var noTokens = Object.create(null);
    const typeArray = [ NodeType.none ], warned = [], byTag = Object.create(null);
    var defaultTable = Object.create(null);
    for (let [ legacyName, name ] of [ [ "variable", "variableName" ], [ "variable-2", "variableName.special" ], [ "string-2", "string.special" ], [ "def", "variableName.definition" ], [ "tag", "tagName" ], [ "attribute", "attributeName" ], [ "type", "typeName" ], [ "builtin", "variableName.standard" ], [ "qualifier", "modifier" ], [ "error", "invalid" ], [ "header", "heading" ], [ "property", "propertyName" ] ]) defaultTable[legacyName] = createTokenType(noTokens, name);
    function warnForPart(part, msg) {
        -1 < warned.indexOf(part) || (warned.push(part), console.warn(msg));
    }
    function createTokenType(extra, tagStr) {
        var key, tags$1$1 = [];
        for (let name of tagStr.split(" ")) {
            let found = [];
            for (var part of name.split(".")) {
                var value = extra[part] || tags$1[part];
                value ? "function" == typeof value ? found.length ? found = found.map(value) : warnForPart(part, `Modifier ${part} used at start of tag`) : found.length ? warnForPart(part, `Tag ${part} used as modifier`) : found = Array.isArray(value) ? value : [ value ] : warnForPart(part, "Unknown highlighting tag " + part);
            }
            for (var tag of found) tags$1$1.push(tag);
        }
        return tags$1$1.length ? (key = (tagStr = tagStr.replace(/ /g, "_")) + " " + tags$1$1.map(t => t.id), 
        (byTag[key] || (key = byTag[key] = NodeType.define({
            id: typeArray.length,
            name: tagStr,
            props: [ styleTags({
                [tagStr]: tags$1$1
            }) ]
        }), typeArray.push(key), key)).id) : 0;
    }
    Direction.RTL, Direction.LTR;
    function command(f, option) {
        return ({
            state,
            dispatch
        }) => {
            var tr;
            return !state.readOnly && !!(tr = f(option, state)) && (dispatch(state.update(tr)), 
            !0);
        };
    }
    const toggleLineComment = command(changeLineComment, 0);
    webkit = command(changeBlockComment, 0);
    const toggleBlockCommentByLine = command((o, s) => changeBlockComment(o, s, function(state) {
        var ranges = [];
        for (var r of state.selection.ranges) {
            var fromLine = state.doc.lineAt(r.from);
            let toLine = r.to <= fromLine.to ? fromLine : state.doc.lineAt(r.to);
            toLine.from > fromLine.from && toLine.from == r.to && (toLine = r.to == fromLine.to + 1 ? fromLine : state.doc.lineAt(r.to - 1));
            r = ranges.length - 1;
            0 <= r && ranges[r].to > fromLine.from ? ranges[r].to = toLine.to : ranges.push({
                from: fromLine.from + /^\s*/.exec(fromLine.text)[0].length,
                to: toLine.to
            });
        }
        return ranges;
    }(s)), 0);
    function getConfig(state, pos) {
        state = state.languageDataAt("commentTokens", pos, 1);
        return state.length ? state[0] : {};
    }
    const SearchMargin = 50;
    function changeBlockComment(option, state, ranges = state.selection.ranges) {
        let tokens = ranges.map(r => getConfig(state, r.from).block);
        if (tokens.every(c => c)) {
            let comments = ranges.map((r, i) => function(state, {
                open,
                close
            }, from, to) {
                var textBefore = state.sliceDoc(from - SearchMargin, from), textAfter = state.sliceDoc(to, to + SearchMargin), spaceBefore = /\s*$/.exec(textBefore)[0].length, spaceAfter = /^\s*/.exec(textAfter)[0].length, beforeOff = textBefore.length - spaceBefore;
                if (textBefore.slice(beforeOff - open.length, beforeOff) == open && textAfter.slice(spaceAfter, spaceAfter + close.length) == close) return {
                    open: {
                        pos: from - spaceBefore,
                        margin: spaceBefore && 1
                    },
                    close: {
                        pos: to + spaceAfter,
                        margin: spaceAfter && 1
                    }
                };
                let startText, endText;
                return to - from <= 2 * SearchMargin ? startText = endText = state.sliceDoc(from, to) : (startText = state.sliceDoc(from, from + SearchMargin), 
                endText = state.sliceDoc(to - SearchMargin, to)), textBefore = /^\s*/.exec(startText)[0].length, 
                beforeOff = /\s*$/.exec(endText)[0].length, textAfter = endText.length - beforeOff - close.length, 
                startText.slice(textBefore, textBefore + open.length) == open && endText.slice(textAfter, textAfter + close.length) == close ? {
                    open: {
                        pos: from + textBefore + open.length,
                        margin: /\s/.test(startText.charAt(textBefore + open.length)) ? 1 : 0
                    },
                    close: {
                        pos: to - beforeOff - close.length,
                        margin: /\s/.test(endText.charAt(textAfter - 1)) ? 1 : 0
                    }
                } : null;
            }(state, tokens[i], r.from, r.to));
            if (2 != option && !comments.every(c => c)) return {
                changes: state.changes(ranges.map((range, i) => comments[i] ? [] : [ {
                    from: range.from,
                    insert: tokens[i].open + " "
                }, {
                    from: range.to,
                    insert: " " + tokens[i].close
                } ]))
            };
            if (1 != option && comments.some(c => c)) {
                var token, open, close, changes = [];
                for (let i = 0, comment; i < comments.length; i++) (comment = comments[i]) && (token = tokens[i], 
                {
                    open,
                    close
                } = comment, changes.push({
                    from: open.pos - token.open.length,
                    to: open.pos + open.margin
                }, {
                    from: close.pos - close.margin,
                    to: close.pos + token.close.length
                }));
                return {
                    changes: changes
                };
            }
        }
        return null;
    }
    function changeLineComment(option, state, ranges = state.selection.ranges) {
        var from, to, lines = [];
        let prevLine = -1;
        for ({
            from,
            to
        } of ranges) {
            let startI = lines.length, minIndent = 1e9;
            var token = getConfig(state, from).line;
            if (token) {
                for (let pos = from; pos <= to; ) {
                    var indent, empty, comment, line = state.doc.lineAt(pos);
                    line.from > prevLine && (from == to || to > line.from) && (prevLine = line.from, 
                    empty = (indent = /^\s*/.exec(line.text)[0].length) == line.length, 
                    comment = line.text.slice(indent, indent + token.length) == token ? indent : -1, 
                    indent < line.text.length && indent < minIndent && (minIndent = indent), 
                    lines.push({
                        line: line,
                        comment: comment,
                        token: token,
                        indent: indent,
                        empty: empty,
                        single: !1
                    })), pos = line.to + 1;
                }
                if (minIndent < 1e9) for (let i = startI; i < lines.length; i++) lines[i].indent < lines[i].line.text.length && (lines[i].indent = minIndent);
                lines.length == startI + 1 && (lines[startI].single = !0);
            }
        }
        if (2 != option && lines.some(l => l.comment < 0 && (!l.empty || l.single))) {
            var changes = [];
            for (let {
                line,
                token,
                indent,
                empty,
                single
            } of lines) !single && empty || changes.push({
                from: line.from + indent,
                insert: token + " "
            });
            ranges = state.changes(changes);
            return {
                changes: ranges,
                selection: state.selection.map(ranges, 1)
            };
        }
        if (1 != option && lines.some(l => 0 <= l.comment)) {
            let changes = [];
            for (let {
                line,
                comment,
                token
            } of lines) if (0 <= comment) {
                let from = line.from + comment, to = from + token.length;
                " " == line.text[to - line.from] && to++, changes.push({
                    from: from,
                    to: to
                });
            }
            return {
                changes: changes
            };
        }
        return null;
    }
    const fromHistory = Annotation.define(), isolateHistory = Annotation.define(), invertedEffects = Facet.define(), historyConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                minDepth: 100,
                newGroupDelay: 500,
                joinToEvent: (_t, isAdjacent) => isAdjacent
            }, {
                minDepth: Math.max,
                newGroupDelay: Math.min,
                joinToEvent: (a, b) => (tr, adj) => a(tr, adj) || b(tr, adj)
            });
        }
    }), historyField_ = StateField.define({
        create() {
            return HistoryState.empty;
        },
        update(state, tr) {
            var config = tr.state.facet(historyConfig), fromHist = tr.annotation(fromHistory);
            if (fromHist) {
                var item = HistEvent.fromTransaction(tr, fromHist.selection), from = fromHist.side;
                let other = 0 == from ? state.undone : state.done;
                return other = item ? updateBranch(other, other.length, config.minDepth, item) : addSelection(other, tr.startState.selection), 
                new HistoryState(0 == from ? fromHist.rest : other, 0 == from ? other : fromHist.rest);
            }
            var userEvent, item = tr.annotation(isolateHistory);
            return "full" != item && "before" != item || (state = state.isolate()), 
            !1 === tr.annotation(Transaction.addToHistory) ? tr.changes.empty ? state : state.addMapping(tr.changes.desc) : (from = HistEvent.fromTransaction(tr), 
            fromHist = tr.annotation(Transaction.time), userEvent = tr.annotation(Transaction.userEvent), 
            from ? state = state.addChanges(from, fromHist, userEvent, config, tr) : tr.selection && (state = state.addSelection(tr.startState.selection, fromHist, userEvent, config.newGroupDelay)), 
            "full" != item && "after" != item ? state : state.isolate());
        },
        toJSON(value) {
            return {
                done: value.done.map(e => e.toJSON()),
                undone: value.undone.map(e => e.toJSON())
            };
        },
        fromJSON(json) {
            return new HistoryState(json.done.map(HistEvent.fromJSON), json.undone.map(HistEvent.fromJSON));
        }
    });
    function cmd(side, selection) {
        return function({
            state,
            dispatch
        }) {
            var historyState;
            return !(!selection && state.readOnly || !(historyState = state.field(historyField_, !1)) || !(historyState = historyState.pop(side, state, selection)) || (dispatch(historyState), 
            0));
        };
    }
    const undo = cmd(0, !1), redo = cmd(1, !1);
    nav = cmd(0, !0), safari = cmd(1, !0);
    class HistEvent {
        constructor(changes, effects, mapped, startSelection, selectionsAfter) {
            this.changes = changes, this.effects = effects, this.mapped = mapped, 
            this.startSelection = startSelection, this.selectionsAfter = selectionsAfter;
        }
        setSelAfter(after) {
            return new HistEvent(this.changes, this.effects, this.mapped, this.startSelection, after);
        }
        toJSON() {
            var _a;
            return {
                changes: null == (_a = this.changes) ? void 0 : _a.toJSON(),
                mapped: null == (_a = this.mapped) ? void 0 : _a.toJSON(),
                startSelection: null == (_a = this.startSelection) ? void 0 : _a.toJSON(),
                selectionsAfter: this.selectionsAfter.map(s => s.toJSON())
            };
        }
        static fromJSON(json) {
            return new HistEvent(json.changes && ChangeSet.fromJSON(json.changes), [], json.mapped && ChangeDesc.fromJSON(json.mapped), json.startSelection && EditorSelection.fromJSON(json.startSelection), json.selectionsAfter.map(EditorSelection.fromJSON));
        }
        static fromTransaction(tr, selection) {
            let effects = none$2;
            for (var invert of tr.startState.facet(invertedEffects)) {
                invert = invert(tr);
                invert.length && (effects = effects.concat(invert));
            }
            return !effects.length && tr.changes.empty ? null : new HistEvent(tr.changes.invert(tr.startState.doc), effects, void 0, selection || tr.startState.selection, none$2);
        }
        static selection(selections) {
            return new HistEvent(void 0, none$2, void 0, void 0, selections);
        }
    }
    function updateBranch(branch, to, maxLen, newEvent) {
        branch = branch.slice(maxLen + 20 < to + 1 ? to - maxLen - 1 : 0, to);
        return branch.push(newEvent), branch;
    }
    function conc(a, b) {
        return a.length ? b.length ? a.concat(b) : a : b;
    }
    const none$2 = [], MaxSelectionsPerEvent = 200;
    function addSelection(branch, selection) {
        var lastEvent, sels;
        return branch.length ? (sels = (lastEvent = branch[branch.length - 1]).selectionsAfter.slice(Math.max(0, lastEvent.selectionsAfter.length - MaxSelectionsPerEvent))).length && sels[sels.length - 1].eq(selection) ? branch : (sels.push(selection), 
        updateBranch(branch, branch.length - 1, 1e9, lastEvent.setSelAfter(sels))) : [ HistEvent.selection([ selection ]) ];
    }
    function addMappingToBranch(branch, mapping) {
        if (!branch.length) return branch;
        let length = branch.length, selections = none$2;
        for (;length; ) {
            var result, event = function(event, mapping, extraSelections) {
                extraSelections = conc(event.selectionsAfter.length ? event.selectionsAfter.map(s => s.map(mapping)) : none$2, extraSelections);
                if (!event.changes) return HistEvent.selection(extraSelections);
                var mappedChanges = event.changes.map(mapping), before = mapping.mapDesc(event.changes, !0), fullMapping = event.mapped ? event.mapped.composeDesc(before) : before;
                return new HistEvent(mappedChanges, StateEffect.mapEffects(event.effects, mapping), fullMapping, event.startSelection.map(before), extraSelections);
            }(branch[length - 1], mapping, selections);
            if (event.changes && !event.changes.empty || event.effects.length) return (result = branch.slice(0, length))[length - 1] = event, 
            result;
            mapping = event.mapped, length--, selections = event.selectionsAfter;
        }
        return selections.length ? [ HistEvent.selection(selections) ] : none$2;
    }
    const joinableUserEvent = /^(input\.type|delete)($|\.)/;
    class HistoryState {
        constructor(done, undone, prevTime = 0, prevUserEvent = void 0) {
            this.done = done, this.undone = undone, this.prevTime = prevTime, this.prevUserEvent = prevUserEvent;
        }
        isolate() {
            return this.prevTime ? new HistoryState(this.done, this.undone) : this;
        }
        addChanges(event, time, userEvent, config, tr) {
            let done = this.done, lastEvent = done[done.length - 1];
            return done = lastEvent && lastEvent.changes && !lastEvent.changes.empty && event.changes && (!userEvent || joinableUserEvent.test(userEvent)) && (!lastEvent.selectionsAfter.length && time - this.prevTime < config.newGroupDelay && config.joinToEvent(tr, function(a, b) {
                let ranges = [], isAdjacent = !1;
                return a.iterChangedRanges((f, t) => ranges.push(f, t)), b.iterChangedRanges((_f, _t, f, t) => {
                    for (let i = 0; i < ranges.length; ) {
                        var from = ranges[i++], to = ranges[i++];
                        from <= t && f <= to && (isAdjacent = !0);
                    }
                }), isAdjacent;
            }(lastEvent.changes, event.changes)) || "input.type.compose" == userEvent) ? updateBranch(done, done.length - 1, config.minDepth, new HistEvent(event.changes.compose(lastEvent.changes), conc(StateEffect.mapEffects(event.effects, lastEvent.changes), lastEvent.effects), lastEvent.mapped, lastEvent.startSelection, none$2)) : updateBranch(done, done.length, config.minDepth, event), 
            new HistoryState(done, none$2, time, userEvent);
        }
        addSelection(selection, time, userEvent, newGroupDelay) {
            var b, last = this.done.length ? this.done[this.done.length - 1].selectionsAfter : none$2;
            return 0 < last.length && time - this.prevTime < newGroupDelay && userEvent == this.prevUserEvent && userEvent && /^select($|\.)/.test(userEvent) && (newGroupDelay = last[last.length - 1], 
            b = selection, newGroupDelay.ranges.length == b.ranges.length) && 0 === newGroupDelay.ranges.filter((r, i) => r.empty != b.ranges[i].empty).length ? this : new HistoryState(addSelection(this.done, selection), this.undone, time, userEvent);
        }
        addMapping(mapping) {
            return new HistoryState(addMappingToBranch(this.done, mapping), addMappingToBranch(this.undone, mapping), this.prevTime, this.prevUserEvent);
        }
        pop(side, state, onlySelection) {
            var branch = 0 == side ? this.done : this.undone;
            if (0 != branch.length) {
                var event = branch[branch.length - 1], selection = event.selectionsAfter[0] || state.selection;
                if (onlySelection && event.selectionsAfter.length) return state.update({
                    selection: event.selectionsAfter[event.selectionsAfter.length - 1],
                    annotations: fromHistory.of({
                        side: side,
                        rest: function(branch) {
                            var last = branch[branch.length - 1], newBranch = branch.slice();
                            return newBranch[branch.length - 1] = last.setSelAfter(last.selectionsAfter.slice(0, last.selectionsAfter.length - 1)), 
                            newBranch;
                        }(branch),
                        selection: selection
                    }),
                    userEvent: 0 == side ? "select.undo" : "select.redo",
                    scrollIntoView: !0
                });
                if (event.changes) {
                    let rest = 1 == branch.length ? none$2 : branch.slice(0, branch.length - 1);
                    return event.mapped && (rest = addMappingToBranch(rest, event.mapped)), 
                    state.update({
                        changes: event.changes,
                        selection: event.startSelection,
                        effects: event.effects,
                        annotations: fromHistory.of({
                            side: side,
                            rest: rest,
                            selection: selection
                        }),
                        filter: !1,
                        userEvent: 0 == side ? "undo" : "redo",
                        scrollIntoView: !0
                    });
                }
            }
            return null;
        }
    }
    HistoryState.empty = new HistoryState(none$2, none$2);
    ie_upto10 = [ {
        key: "Mod-z",
        run: undo,
        preventDefault: !0
    }, {
        key: "Mod-y",
        mac: "Mod-Shift-z",
        run: redo,
        preventDefault: !0
    }, {
        linux: "Ctrl-Shift-z",
        run: redo,
        preventDefault: !0
    }, {
        key: "Mod-u",
        run: nav,
        preventDefault: !0
    }, {
        key: "Alt-u",
        mac: "Mod-Shift-u",
        run: safari,
        preventDefault: !0
    } ];
    function updateSel(sel, by) {
        return EditorSelection.create(sel.ranges.map(by), sel.mainIndex);
    }
    function setSel(state, selection) {
        return state.update({
            selection: selection,
            scrollIntoView: !0,
            userEvent: "select"
        });
    }
    function moveSel({
        state,
        dispatch
    }, how) {
        how = updateSel(state.selection, how);
        return !how.eq(state.selection, !0) && (dispatch(setSel(state, how)), !0);
    }
    function rangeEnd(range, forward) {
        return EditorSelection.cursor(forward ? range.to : range.from);
    }
    function cursorByChar(view, forward) {
        return moveSel(view, range => range.empty ? view.moveByChar(range, forward) : rangeEnd(range, forward));
    }
    function ltrAtCursor(view) {
        return view.textDirectionAt(view.state.selection.main.head) == Direction.LTR;
    }
    operator = view => cursorByChar(view, !ltrAtCursor(view)), punctuation = view => cursorByChar(view, ltrAtCursor(view));
    function cursorByGroup(view, forward) {
        return moveSel(view, range => range.empty ? view.moveByGroup(range, forward) : rangeEnd(range, forward));
    }
    function moveBySyntax(state, start, forward) {
        let pos = syntaxTree(state).resolveInner(start.head);
        var bracketProp = forward ? NodeProp.closedBy : NodeProp.openedBy;
        for (let at = start.head; ;) {
            var next = forward ? pos.childAfter(at) : pos.childBefore(at);
            if (!next) break;
            !function(state, node, bracketProp) {
                return node.type.prop(bracketProp) || (bracketProp = node.to - node.from) && (2 < bracketProp || /[^\s,.;:]/.test(state.sliceDoc(node.from, node.to))) || node.firstChild;
            }(state, next, bracketProp) ? at = forward ? next.to : next.from : pos = next;
        }
        let bracket = pos.type.prop(bracketProp), match, newPos;
        return newPos = bracket && (match = forward ? matchBrackets(state, pos.from, 1) : matchBrackets(state, pos.to, -1)) && match.matched ? forward ? match.end.to : match.end.from : forward ? pos.to : pos.from, 
        EditorSelection.cursor(newPos, forward ? -1 : 1);
    }
    function cursorByLine(view, forward) {
        return moveSel(view, range => {
            var moved;
            return range.empty ? (moved = view.moveVertically(range, forward)).head != range.head ? moved : view.moveToLineBoundary(range, forward) : rangeEnd(range, forward);
        });
    }
    bracket = view => cursorByLine(view, !1), ie = view => cursorByLine(view, !0);
    function pageInfo(view) {
        var selfScroll = view.scrollDOM.clientHeight < view.scrollDOM.scrollHeight - 2;
        let marginTop = 0, marginBottom = 0, height;
        if (selfScroll) {
            for (var source of view.state.facet(EditorView.scrollMargins)) {
                source = source(view);
                null != source && source.top && (marginTop = Math.max(null == source ? void 0 : source.top, marginTop)), 
                null != source && source.bottom && (marginBottom = Math.max(null == source ? void 0 : source.bottom, marginBottom));
            }
            height = view.scrollDOM.clientHeight - marginTop - marginBottom;
        } else height = (view.dom.ownerDocument.defaultView || window).innerHeight;
        return {
            marginTop: marginTop,
            marginBottom: marginBottom,
            selfScroll: selfScroll,
            height: Math.max(view.defaultLineHeight, height - 5)
        };
    }
    function cursorByPage(view, forward) {
        let page = pageInfo(view);
        var startPos, scrollTop, scrollRect, state = view["state"], selection = updateSel(state.selection, range => range.empty ? view.moveVertically(range, forward, page.height) : rangeEnd(range, forward));
        if (selection.eq(state.selection)) return !1;
        let effect;
        return page.selfScroll && (startPos = view.coordsAtPos(state.selection.main.head), 
        scrollTop = (scrollRect = view.scrollDOM.getBoundingClientRect()).top + page.marginTop, 
        scrollRect = scrollRect.bottom - page.marginBottom, startPos) && startPos.top > scrollTop && startPos.bottom < scrollRect && (effect = EditorView.scrollIntoView(selection.main.head, {
            y: "start",
            yMargin: startPos.top - scrollTop
        })), view.dispatch(setSel(state, selection), {
            effects: effect
        }), !0;
    }
    doc = view => cursorByPage(view, !1), ie_11up = view => cursorByPage(view, !0);
    function moveByLineBoundary(view, start, forward) {
        let line = view.lineBlockAt(start.head), moved = view.moveToLineBoundary(start, forward);
        return moved.head == start.head && moved.head != (forward ? line.to : line.from) && (moved = view.moveToLineBoundary(start, forward, !1)), 
        moved = !forward && moved.head == line.from && line.length && (forward = /^\s*/.exec(view.state.sliceDoc(line.from, Math.min(line.from + 100, line.to)))[0].length) && start.head != line.from + forward ? EditorSelection.cursor(line.from + forward) : moved;
    }
    function extendSel(target, how) {
        var selection = updateSel(target.state.selection, range => {
            var head = how(range);
            return EditorSelection.range(range.anchor, head.head, head.goalColumn, head.bidiLevel || void 0);
        });
        return !selection.eq(target.state.selection) && (target.dispatch(setSel(target.state, selection)), 
        !0);
    }
    function selectByChar(view, forward) {
        return extendSel(view, range => view.moveByChar(range, forward));
    }
    meta = view => selectByChar(view, !ltrAtCursor(view)), ie_edge = view => selectByChar(view, ltrAtCursor(view));
    function selectByGroup(view, forward) {
        return extendSel(view, range => view.moveByGroup(range, forward));
    }
    function selectByLine(view, forward) {
        return extendSel(view, range => view.moveVertically(range, forward));
    }
    gecko = view => selectByLine(view, !1), nav = view => selectByLine(view, !0);
    function selectByPage(view, forward) {
        return extendSel(view, range => view.moveVertically(range, forward, pageInfo(view).height));
    }
    var safari = view => selectByPage(view, !1), selectPageDown = view => selectByPage(view, !0), cursorDocStart = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: 0
    })), !0), cursorDocEnd = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: state.doc.length
    })), !0), selectDocStart = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: state.selection.main.anchor,
        head: 0
    })), !0), selectDocEnd = ({
        state,
        dispatch
    }) => (dispatch(setSel(state, {
        anchor: state.selection.main.anchor,
        head: state.doc.length
    })), !0);
    function deleteBy(target, by) {
        if (target.state.readOnly) return !1;
        let event = "delete.selection", state = target["state"];
        var changes = state.changeByRange(range => {
            let {
                from,
                to
            } = range;
            if (from == to) {
                let towards = by(range);
                towards < from ? (event = "delete.backward", towards = skipAtomic(target, towards, !1)) : towards > from && (event = "delete.forward", 
                towards = skipAtomic(target, towards, !0)), from = Math.min(from, towards), 
                to = Math.max(to, towards);
            } else from = skipAtomic(target, from, !1), to = skipAtomic(target, to, !0);
            return from == to ? {
                range: range
            } : {
                changes: {
                    from: from,
                    to: to
                },
                range: EditorSelection.cursor(from, from < range.head ? -1 : 1)
            };
        });
        return !changes.changes.empty && (target.dispatch(state.update(changes, {
            scrollIntoView: !0,
            userEvent: event,
            effects: "delete.selection" == event ? EditorView.announce.of(state.phrase("Selection deleted")) : void 0
        })), !0);
    }
    function skipAtomic(target, pos, forward) {
        if (target instanceof EditorView) for (var ranges of target.state.facet(EditorView.atomicRanges).map(f => f(target))) ranges.between(pos, pos, (from, to) => {
            from < pos && pos < to && (pos = forward ? to : from);
        });
        return pos;
    }
    const deleteByChar = (target, forward, byIndentUnit) => deleteBy(target, range => {
        let pos = range.from, state = target["state"], line = state.doc.lineAt(pos), before, targetPos;
        if (byIndentUnit && !forward && pos > line.from && pos < line.from + 200 && !/[^ \t]/.test(before = line.text.slice(0, pos - line.from))) {
            if ("\t" == before[before.length - 1]) return pos - 1;
            var drop = countColumn(before, state.tabSize) % getIndentUnit(state) || getIndentUnit(state);
            for (let i = 0; i < drop && " " == before[before.length - 1 - i]; i++) pos--;
            targetPos = pos;
        } else (targetPos = findClusterBreak(line.text, pos - line.from, forward, forward) + line.from) == pos && line.number != (forward ? state.doc.lines : 1) ? targetPos += forward ? 1 : -1 : !forward && /[\ufe00-\ufe0f]/.test(line.text.slice(targetPos - line.from, pos - line.from)) && (targetPos = findClusterBreak(line.text, targetPos - line.from, !1, !1) + line.from);
        return targetPos;
    });
    var deleteCharBackward = view => deleteByChar(view, !1, !0), deleteCharForward = view => deleteByChar(view, !0, !1);
    const deleteByGroup = (target, forward) => deleteBy(target, range => {
        let pos = range.head, state = target["state"], line = state.doc.lineAt(pos);
        var categorize = state.charCategorizer(pos);
        for (let cat = null; ;) {
            if (pos == (forward ? line.to : line.from)) {
                pos == range.head && line.number != (forward ? state.doc.lines : 1) && (pos += forward ? 1 : -1);
                break;
            }
            var next = findClusterBreak(line.text, pos - line.from, forward) + line.from, nextChar = line.text.slice(Math.min(pos, next) - line.from, Math.max(pos, next) - line.from), nextCat = categorize(nextChar);
            if (null != cat && nextCat != cat) break;
            " " == nextChar && pos == range.head || (cat = nextCat), pos = next;
        }
        return pos;
    });
    var deleteGroupBackward = target => deleteByGroup(target, !1);
    function selectedLineBlocks(state) {
        let blocks = [], upto = -1;
        for (var range of state.selection.ranges) {
            let startLine = state.doc.lineAt(range.from), endLine = state.doc.lineAt(range.to);
            var prev;
            range.empty || range.to != endLine.from || (endLine = state.doc.lineAt(range.to - 1)), 
            upto >= startLine.number ? ((prev = blocks[blocks.length - 1]).to = endLine.to, 
            prev.ranges.push(range)) : blocks.push({
                from: startLine.from,
                to: endLine.to,
                ranges: [ range ]
            }), upto = endLine.number + 1;
        }
        return blocks;
    }
    function moveLine(state, dispatch, forward) {
        if (state.readOnly) return !1;
        var block, changes = [], ranges = [];
        for (block of selectedLineBlocks(state)) if (forward ? block.to != state.doc.length : 0 != block.from) {
            var nextLine = state.doc.lineAt(forward ? block.to + 1 : block.from - 1), size = nextLine.length + 1;
            if (forward) {
                changes.push({
                    from: block.to,
                    to: nextLine.to
                }, {
                    from: block.from,
                    insert: nextLine.text + state.lineBreak
                });
                for (var r of block.ranges) ranges.push(EditorSelection.range(Math.min(state.doc.length, r.anchor + size), Math.min(state.doc.length, r.head + size)));
            } else {
                changes.push({
                    from: nextLine.from,
                    to: block.from
                }, {
                    from: block.to,
                    insert: state.lineBreak + nextLine.text
                });
                for (let r of block.ranges) ranges.push(EditorSelection.range(r.anchor - size, r.head - size));
            }
        }
        return !!changes.length && (dispatch(state.update({
            changes: changes,
            scrollIntoView: !0,
            selection: EditorSelection.create(ranges, state.selection.mainIndex),
            userEvent: "move.line"
        })), !0);
    }
    function copyLine(state, dispatch, forward) {
        if (state.readOnly) return !1;
        var block, changes = [];
        for (block of selectedLineBlocks(state)) changes.push(forward ? {
            from: block.from,
            insert: state.doc.slice(block.from, block.to) + state.lineBreak
        } : {
            from: block.to,
            insert: state.lineBreak + state.doc.slice(block.from, block.to)
        });
        return dispatch(state.update({
            changes: changes,
            scrollIntoView: !0,
            userEvent: "input.copyline"
        })), !0;
    }
    var insertNewlineAndIndent = newlineAndIndent(!1);
    function newlineAndIndent(atEof) {
        return ({
            state,
            dispatch
        }) => {
            var changes;
            return !state.readOnly && (changes = state.changeByRange(range => {
                let {
                    from,
                    to
                } = range, line = state.doc.lineAt(from);
                var range = !atEof && from == to && function(state, pos) {
                    if (/\(\)|\[\]|\{\}/.test(state.sliceDoc(pos - 1, pos + 1))) return {
                        from: pos,
                        to: pos
                    };
                    var context = syntaxTree(state).resolveInner(pos);
                    let before = context.childBefore(pos), after = context.childAfter(pos), closedBy;
                    return before && after && before.to <= pos && after.from >= pos && (closedBy = before.type.prop(NodeProp.closedBy)) && -1 < closedBy.indexOf(after.name) && state.doc.lineAt(before.to).from == state.doc.lineAt(after.from).from && !/\S/.test(state.sliceDoc(before.to, after.from)) ? {
                        from: before.to,
                        to: after.from
                    } : null;
                }(state, from), cx = (atEof && (from = to = (to <= line.to ? line : state.doc.lineAt(to)).to), 
                new IndentContext(state, {
                    simulateBreak: from,
                    simulateDoubleBreak: !!range
                }));
                let indent = getIndentation(cx, from);
                for (null == indent && (indent = countColumn(/^\s*/.exec(state.doc.lineAt(from).text)[0], state.tabSize)); to < line.to && /\s/.test(line.text[to - line.from]); ) to++;
                range ? {
                    from,
                    to
                } = range : from > line.from && from < line.from + 100 && !/\S/.test(line.text.slice(0, from)) && (from = line.from);
                var insert = [ "", indentString(state, indent) ];
                return range && insert.push(indentString(state, cx.lineIndent(line.from, -1))), 
                {
                    changes: {
                        from: from,
                        to: to,
                        insert: Text.of(insert)
                    },
                    range: EditorSelection.cursor(from + 1 + insert[1].length)
                };
            }), dispatch(state.update(changes, {
                scrollIntoView: !0,
                userEvent: "input"
            })), !0);
        };
    }
    function changeBySelectedLine(state, f) {
        let atLine = -1;
        return state.changeByRange(range => {
            var changes = [];
            for (let pos = range.from; pos <= range.to; ) {
                var line = state.doc.lineAt(pos);
                line.number > atLine && (range.empty || range.to > line.from) && (f(line, changes, range), 
                atLine = line.number), pos = line.to + 1;
            }
            var changeSet = state.changes(changes);
            return {
                changes: changes,
                range: EditorSelection.range(changeSet.mapPos(range.anchor, 1), changeSet.mapPos(range.head, 1))
            };
        });
    }
    var indentMore = ({
        state,
        dispatch
    }) => !state.readOnly && (dispatch(state.update(changeBySelectedLine(state, (line, changes) => {
        changes.push({
            from: line.from,
            insert: state.facet(indentUnit)
        });
    }), {
        userEvent: "input.indent"
    })), !0), indentLess = ({
        state,
        dispatch
    }) => !state.readOnly && (dispatch(state.update(changeBySelectedLine(state, (line, changes) => {
        var space = /^\s*/.exec(line.text)[0];
        if (space) {
            let col = countColumn(space, state.tabSize), keep = 0;
            for (var insert = indentString(state, Math.max(0, col - getIndentUnit(state))); keep < space.length && keep < insert.length && space.charCodeAt(keep) == insert.charCodeAt(keep); ) keep++;
            changes.push({
                from: line.from + keep,
                to: line.from + space.length,
                insert: insert.slice(keep)
            });
        }
    }), {
        userEvent: "delete.dedent"
    })), !0), webkit = [ {
        key: "Alt-ArrowLeft",
        mac: "Ctrl-ArrowLeft",
        run: view => moveSel(view, range => moveBySyntax(view.state, range, !ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveBySyntax(view.state, range, !ltrAtCursor(view)))
    }, {
        key: "Alt-ArrowRight",
        mac: "Ctrl-ArrowRight",
        run: view => moveSel(view, range => moveBySyntax(view.state, range, ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveBySyntax(view.state, range, ltrAtCursor(view)))
    }, {
        key: "Alt-ArrowUp",
        run: ({
            state,
            dispatch
        }) => moveLine(state, dispatch, !1)
    }, {
        key: "Shift-Alt-ArrowUp",
        run: ({
            state,
            dispatch
        }) => copyLine(state, dispatch, !1)
    }, {
        key: "Alt-ArrowDown",
        run: ({
            state,
            dispatch
        }) => moveLine(state, dispatch, !0)
    }, {
        key: "Shift-Alt-ArrowDown",
        run: ({
            state,
            dispatch
        }) => copyLine(state, dispatch, !0)
    }, {
        key: "Escape",
        run: ({
            state,
            dispatch
        }) => {
            let cur = state.selection, selection = null;
            return 1 < cur.ranges.length ? selection = EditorSelection.create([ cur.main ]) : cur.main.empty || (selection = EditorSelection.create([ EditorSelection.cursor(cur.main.head) ])), 
            !!selection && (dispatch(setSel(state, selection)), !0);
        }
    }, {
        key: "Mod-Enter",
        run: newlineAndIndent(!0)
    }, {
        key: "Alt-l",
        mac: "Ctrl-l",
        run: ({
            state,
            dispatch
        }) => {
            var ranges = selectedLineBlocks(state).map(({
                from,
                to
            }) => EditorSelection.range(from, Math.min(to + 1, state.doc.length)));
            return dispatch(state.update({
                selection: EditorSelection.create(ranges),
                userEvent: "select"
            })), !0;
        }
    }, {
        key: "Mod-i",
        run: ({
            state,
            dispatch
        }) => {
            var selection = updateSel(state.selection, range => {
                let tree = syntaxTree(state), stack = tree.resolveStack(range.from, 1);
                var stackBefore;
                for (let cur = stack = range.empty && (stackBefore = tree.resolveStack(range.from, -1)).node.from >= stack.node.from && stackBefore.node.to <= stack.node.to ? stackBefore : stack; cur; cur = cur.next) {
                    var node = cur["node"];
                    if ((node.from < range.from && node.to >= range.to || node.to > range.to && node.from <= range.from) && cur.next) return EditorSelection.range(node.to, node.from);
                }
                return range;
            });
            return !selection.eq(state.selection) && (dispatch(setSel(state, selection)), 
            !0);
        },
        preventDefault: !0
    }, {
        key: "Mod-[",
        run: indentLess
    }, {
        key: "Mod-]",
        run: indentMore
    }, {
        key: "Mod-Alt-\\",
        run: ({
            state,
            dispatch
        }) => {
            if (state.readOnly) return !1;
            let updated = Object.create(null), context = new IndentContext(state, {
                overrideIndentation: start => {
                    start = updated[start];
                    return null == start ? -1 : start;
                }
            });
            var changes = changeBySelectedLine(state, (line, changes, range) => {
                let indent = getIndentation(context, line.from);
                var cur, norm;
                null != indent && (/\S/.test(line.text) || (indent = 0), (cur = /^\s*/.exec(line.text)[0]) != (norm = indentString(state, indent)) || range.from < line.from + cur.length) && (updated[line.from] = indent, 
                changes.push({
                    from: line.from,
                    to: line.from + cur.length,
                    insert: norm
                }));
            });
            return changes.changes.empty || dispatch(state.update(changes, {
                userEvent: "indent"
            })), !0;
        }
    }, {
        key: "Shift-Mod-k",
        run: view => {
            if (view.state.readOnly) return !1;
            let state = view["state"], changes = state.changes(selectedLineBlocks(state).map(({
                from,
                to
            }) => (0 < from ? from-- : to < state.doc.length && to++, {
                from: from,
                to: to
            })));
            var selection = updateSel(state.selection, range => {
                let dist = void 0;
                var block, pos;
                return view.lineWrapping && (block = view.lineBlockAt(range.head), 
                pos = view.coordsAtPos(range.head, range.assoc || 1)) && (dist = block.bottom + view.documentTop - pos.bottom + view.defaultLineHeight / 2), 
                view.moveVertically(range, !0, dist);
            }).map(changes);
            return view.dispatch({
                changes: changes,
                selection: selection,
                scrollIntoView: !0,
                userEvent: "delete.line"
            }), !0;
        }
    }, {
        key: "Shift-Mod-\\",
        run: ({
            state,
            dispatch
        }) => function(state, dispatch) {
            let found = !1, selection = updateSel(state.selection, range => {
                var matching = matchBrackets(state, range.head, -1) || matchBrackets(state, range.head, 1) || 0 < range.head && matchBrackets(state, range.head - 1, 1) || range.head < state.doc.length && matchBrackets(state, range.head + 1, -1);
                if (!matching || !matching.end) return range;
                found = !0;
                range = matching.start.from == range.head ? matching.end.to : matching.end.from;
                return EditorSelection.cursor(range);
            });
            return !!found && (dispatch(setSel(state, selection)), !0);
        }(state, dispatch)
    }, {
        key: "Mod-/",
        run: target => {
            var state = target["state"], state = state.doc.lineAt(state.selection.main.from), state = getConfig(target.state, state.from);
            return state.line ? toggleLineComment(target) : !!state.block && toggleBlockCommentByLine(target);
        }
    }, {
        key: "Alt-A",
        run: webkit
    }, {
        key: "Ctrl-m",
        mac: "Shift-Alt-m",
        run: view => (view.setTabFocusMode(), !0)
    } ].concat([ {
        key: "ArrowLeft",
        run: operator,
        shift: meta,
        preventDefault: !0
    }, {
        key: "Mod-ArrowLeft",
        mac: "Alt-ArrowLeft",
        run: view => cursorByGroup(view, !ltrAtCursor(view)),
        shift: view => selectByGroup(view, !ltrAtCursor(view)),
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowLeft",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, !ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, !ltrAtCursor(view))),
        preventDefault: !0
    }, {
        key: "ArrowRight",
        run: punctuation,
        shift: ie_edge,
        preventDefault: !0
    }, {
        key: "Mod-ArrowRight",
        mac: "Alt-ArrowRight",
        run: view => cursorByGroup(view, ltrAtCursor(view)),
        shift: view => selectByGroup(view, ltrAtCursor(view)),
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowRight",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, ltrAtCursor(view))),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, ltrAtCursor(view))),
        preventDefault: !0
    }, {
        key: "ArrowUp",
        run: bracket,
        shift: gecko,
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowUp",
        run: cursorDocStart,
        shift: selectDocStart
    }, {
        mac: "Ctrl-ArrowUp",
        run: doc,
        shift: safari
    }, {
        key: "ArrowDown",
        run: ie,
        shift: nav,
        preventDefault: !0
    }, {
        mac: "Cmd-ArrowDown",
        run: cursorDocEnd,
        shift: selectDocEnd
    }, {
        mac: "Ctrl-ArrowDown",
        run: ie_11up,
        shift: selectPageDown
    }, {
        key: "PageUp",
        run: doc,
        shift: safari
    }, {
        key: "PageDown",
        run: ie_11up,
        shift: selectPageDown
    }, {
        key: "Home",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, !1)),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, !1)),
        preventDefault: !0
    }, {
        key: "Mod-Home",
        run: cursorDocStart,
        shift: selectDocStart
    }, {
        key: "End",
        run: view => moveSel(view, range => moveByLineBoundary(view, range, !0)),
        shift: view => extendSel(view, range => moveByLineBoundary(view, range, !0)),
        preventDefault: !0
    }, {
        key: "Mod-End",
        run: cursorDocEnd,
        shift: selectDocEnd
    }, {
        key: "Enter",
        run: insertNewlineAndIndent,
        shift: insertNewlineAndIndent
    }, {
        key: "Mod-a",
        run: ({
            state,
            dispatch
        }) => (dispatch(state.update({
            selection: {
                anchor: 0,
                head: state.doc.length
            },
            userEvent: "select"
        })), !0)
    }, {
        key: "Backspace",
        run: deleteCharBackward,
        shift: deleteCharBackward
    }, {
        key: "Delete",
        run: deleteCharForward
    }, {
        key: "Mod-Backspace",
        mac: "Alt-Backspace",
        run: deleteGroupBackward
    }, {
        key: "Mod-Delete",
        mac: "Alt-Delete",
        run: target => deleteByGroup(target, !0)
    }, {
        mac: "Mod-Backspace",
        run: view => deleteBy(view, range => {
            var lineStart = view.moveToLineBoundary(range, !1).head;
            return range.head > lineStart ? lineStart : Math.max(0, range.head - 1);
        })
    }, {
        mac: "Mod-Delete",
        run: view => deleteBy(view, range => {
            var lineStart = view.moveToLineBoundary(range, !0).head;
            return range.head < lineStart ? lineStart : Math.min(view.state.doc.length, range.head + 1);
        })
    } ].concat([ {
        key: "Ctrl-b",
        run: operator,
        shift: meta,
        preventDefault: !0
    }, {
        key: "Ctrl-f",
        run: punctuation,
        shift: ie_edge
    }, {
        key: "Ctrl-p",
        run: bracket,
        shift: gecko
    }, {
        key: "Ctrl-n",
        run: ie,
        shift: nav
    }, {
        key: "Ctrl-a",
        run: view => moveSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).from, 1)),
        shift: view => extendSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).from))
    }, {
        key: "Ctrl-e",
        run: view => moveSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).to, -1)),
        shift: view => extendSel(view, range => EditorSelection.cursor(view.lineBlockAt(range.head).to))
    }, {
        key: "Ctrl-d",
        run: deleteCharForward
    }, {
        key: "Ctrl-h",
        run: deleteCharBackward
    }, {
        key: "Ctrl-k",
        run: view => deleteBy(view, range => {
            var lineEnd = view.lineBlockAt(range.head).to;
            return range.head < lineEnd ? lineEnd : Math.min(view.state.doc.length, range.head + 1);
        })
    }, {
        key: "Ctrl-Alt-h",
        run: deleteGroupBackward
    }, {
        key: "Ctrl-o",
        run: ({
            state,
            dispatch
        }) => {
            var changes;
            return !state.readOnly && (changes = state.changeByRange(range => ({
                changes: {
                    from: range.from,
                    to: range.to,
                    insert: Text.of([ "", "" ])
                },
                range: EditorSelection.cursor(range.from)
            })), dispatch(state.update(changes, {
                scrollIntoView: !0,
                userEvent: "input"
            })), !0);
        }
    }, {
        key: "Ctrl-t",
        run: ({
            state,
            dispatch
        }) => {
            var changes;
            return !state.readOnly && !(changes = state.changeByRange(range => {
                var pos, from, line;
                return range.empty && 0 != range.from && range.from != state.doc.length ? {
                    changes: {
                        from: from = (pos = range.from) == (line = state.doc.lineAt(pos)).from ? pos - 1 : findClusterBreak(line.text, pos - line.from, !1) + line.from,
                        to: line = pos == line.to ? pos + 1 : findClusterBreak(line.text, pos - line.from, !0) + line.from,
                        insert: state.doc.slice(pos, line).append(state.doc.slice(from, pos))
                    },
                    range: EditorSelection.cursor(line)
                } : {
                    range: range
                };
            })).changes.empty && (dispatch(state.update(changes, {
                scrollIntoView: !0,
                userEvent: "move.character"
            })), !0);
        }
    }, {
        key: "Ctrl-v",
        run: ie_11up
    } ].map(b => ({
        mac: b.key,
        run: b.run,
        shift: b.shift
    })))), doc = {
        key: "Tab",
        run: indentMore,
        shift: indentLess
    };
    const basicNormalize = "function" == typeof String.prototype.normalize ? x => x.normalize("NFKD") : x => x;
    class SearchCursor {
        constructor(text, query, from = 0, to = text.length, normalize, test) {
            this.test = test, this.value = {
                from: 0,
                to: 0
            }, this.done = !1, this.matches = [], this.buffer = "", this.bufferPos = 0, 
            this.iter = text.iterRange(from, to), this.bufferStart = from, this.normalize = normalize ? x => normalize(basicNormalize(x)) : basicNormalize, 
            this.query = this.normalize(query);
        }
        peek() {
            if (this.bufferPos == this.buffer.length) {
                if (this.bufferStart += this.buffer.length, this.iter.next(), this.iter.done) return -1;
                this.bufferPos = 0, this.buffer = this.iter.value;
            }
            return codePointAt(this.buffer, this.bufferPos);
        }
        next() {
            for (;this.matches.length; ) this.matches.pop();
            return this.nextOverlapping();
        }
        nextOverlapping() {
            for (;;) {
                var next = this.peek();
                if (next < 0) return this.done = !0, this;
                var str = fromCodePoint(next), start = this.bufferStart + this.bufferPos, norm = (this.bufferPos += next < 65536 ? 1 : 2, 
                this.normalize(str));
                if (norm.length) for (let i = 0, pos = start; ;i++) {
                    var code = norm.charCodeAt(i), match = this.match(code, pos, this.bufferPos + this.bufferStart);
                    if (i == norm.length - 1) {
                        if (match) return this.value = match, this;
                        break;
                    }
                    pos == start && i < str.length && str.charCodeAt(i) == code && pos++;
                }
            }
        }
        match(code, pos, end) {
            let match = null;
            for (let i = 0; i < this.matches.length; i += 2) {
                let index = this.matches[i], keep = !1;
                this.query.charCodeAt(index) == code && (index == this.query.length - 1 ? match = {
                    from: this.matches[i + 1],
                    to: end
                } : (this.matches[i]++, keep = !0)), keep || (this.matches.splice(i, 2), 
                i -= 2);
            }
            return this.query.charCodeAt(0) == code && (1 == this.query.length ? match = {
                from: pos,
                to: end
            } : this.matches.push(1, pos)), match = match && this.test && !this.test(match.from, match.to, this.buffer, this.bufferStart) ? null : match;
        }
    }
    "undefined" != typeof Symbol && (SearchCursor.prototype[Symbol.iterator] = function() {
        return this;
    });
    const empty = {
        from: -1,
        to: -1,
        match: /.*/.exec("")
    }, baseFlags = "gm" + (null == /x/.unicode ? "" : "u");
    class RegExpCursor {
        constructor(text, query, options, from = 0, to = text.length) {
            if (this.text = text, this.to = to, this.curLine = "", this.done = !1, 
            this.value = empty, /\\[sWDnr]|\n|\r|\[\^/.test(query)) return new MultilineRegExpCursor(text, query, options, from, to);
            this.re = new RegExp(query, baseFlags + (null != options && options.ignoreCase ? "i" : "")), 
            this.test = null == options ? void 0 : options.test, this.iter = text.iter();
            to = text.lineAt(from);
            this.curLineStart = to.from, this.matchPos = toCharEnd(text, from), 
            this.getLine(this.curLineStart);
        }
        getLine(skip) {
            this.iter.next(skip), this.iter.lineBreak ? this.curLine = "" : (this.curLine = this.iter.value, 
            this.curLineStart + this.curLine.length > this.to && (this.curLine = this.curLine.slice(0, this.to - this.curLineStart)), 
            this.iter.next());
        }
        nextLine() {
            this.curLineStart = this.curLineStart + this.curLine.length + 1, this.curLineStart > this.to ? this.curLine = "" : this.getLine(0);
        }
        next() {
            for (let off = this.matchPos - this.curLineStart; ;) {
                this.re.lastIndex = off;
                var match = this.matchPos <= this.to && this.re.exec(this.curLine);
                if (match) {
                    var from = this.curLineStart + match.index, to = from + match[0].length;
                    if (this.matchPos = toCharEnd(this.text, to + (from == to ? 1 : 0)), 
                    from == this.curLineStart + this.curLine.length && this.nextLine(), 
                    (from < to || from > this.value.to) && (!this.test || this.test(from, to, match))) return this.value = {
                        from: from,
                        to: to,
                        match: match
                    }, this;
                    off = this.matchPos - this.curLineStart;
                } else {
                    if (!(this.curLineStart + this.curLine.length < this.to)) return this.done = !0, 
                    this;
                    this.nextLine(), off = 0;
                }
            }
        }
    }
    const flattened = new WeakMap();
    class FlattenedDoc {
        constructor(from, text) {
            this.from = from, this.text = text;
        }
        get to() {
            return this.from + this.text.length;
        }
        static get(doc, from, to) {
            var flat, cached = flattened.get(doc);
            if (!cached || cached.from >= to || cached.to <= from) return flat = new FlattenedDoc(from, doc.sliceString(from, to)), 
            flattened.set(doc, flat), flat;
            if (cached.from == from && cached.to == to) return cached;
            let {
                text,
                from: cachedFrom
            } = cached;
            return cachedFrom > from && (text = doc.sliceString(from, cachedFrom) + text, 
            cachedFrom = from), cached.to < to && (text += doc.sliceString(cached.to, to)), 
            flattened.set(doc, new FlattenedDoc(cachedFrom, text)), new FlattenedDoc(from, text.slice(from - cachedFrom, to - cachedFrom));
        }
    }
    class MultilineRegExpCursor {
        constructor(text, query, options, from, to) {
            this.text = text, this.to = to, this.done = !1, this.value = empty, 
            this.matchPos = toCharEnd(text, from), this.re = new RegExp(query, baseFlags + (null != options && options.ignoreCase ? "i" : "")), 
            this.test = null == options ? void 0 : options.test, this.flat = FlattenedDoc.get(text, from, this.chunkEnd(from + 5e3));
        }
        chunkEnd(pos) {
            return (pos >= this.to ? this : this.text.lineAt(pos)).to;
        }
        next() {
            for (;;) {
                var off = this.re.lastIndex = this.matchPos - this.flat.from;
                let match = this.re.exec(this.flat.text);
                if (match && !match[0] && match.index == off && (this.re.lastIndex = 1 + off, 
                match = this.re.exec(this.flat.text)), match) {
                    var off = this.flat.from + match.index, to = off + match[0].length;
                    if ((this.flat.to >= this.to || match.index + match[0].length <= this.flat.text.length - 10) && (!this.test || this.test(off, to, match))) return this.value = {
                        from: off,
                        to: to,
                        match: match
                    }, this.matchPos = toCharEnd(this.text, to + (off == to ? 1 : 0)), 
                    this;
                }
                if (this.flat.to == this.to) return this.done = !0, this;
                this.flat = FlattenedDoc.get(this.text, this.flat.from, this.chunkEnd(this.flat.from + 2 * this.flat.text.length));
            }
        }
    }
    function toCharEnd(text, pos) {
        if (!(pos >= text.length)) {
            let line = text.lineAt(pos), next;
            for (;pos < line.to && 56320 <= (next = line.text.charCodeAt(pos - line.from)) && next < 57344; ) pos++;
        }
        return pos;
    }
    function createLineDialog(view) {
        let input = crelt("input", {
            class: "cm-textfield",
            name: "line",
            value: String(view.state.doc.lineAt(view.state.selection.main.head).number)
        });
        function go() {
            var match = /^([+-])?(\d+)?(:\d+)?(%)?$/.exec(input.value);
            if (match) {
                var state = view["state"], startLine = state.doc.lineAt(state.selection.main.head), [ , match, ln, cl, percent ] = match, cl = cl ? +cl.slice(1) : 0;
                let line = ln ? +ln : startLine.number;
                if (ln && percent) {
                    let pc = line / 100;
                    match && (pc = pc * ("-" == match ? -1 : 1) + startLine.number / state.doc.lines), 
                    line = Math.round(state.doc.lines * pc);
                } else ln && match && (line = line * ("-" == match ? -1 : 1) + startLine.number);
                percent = state.doc.line(Math.max(1, Math.min(state.doc.lines, line))), 
                ln = EditorSelection.cursor(percent.from + Math.max(0, Math.min(cl, percent.length)));
                view.dispatch({
                    effects: [ dialogEffect.of(!1), EditorView.scrollIntoView(ln.from, {
                        y: "center"
                    }) ],
                    selection: ln
                }), view.focus();
            }
        }
        return {
            dom: crelt("form", {
                class: "cm-gotoLine",
                onkeydown: event => {
                    27 == event.keyCode ? (event.preventDefault(), view.dispatch({
                        effects: dialogEffect.of(!1)
                    }), view.focus()) : 13 == event.keyCode && (event.preventDefault(), 
                    go());
                },
                onsubmit: event => {
                    event.preventDefault(), go();
                }
            }, crelt("label", view.state.phrase("Go to line"), ": ", input), " ", crelt("button", {
                class: "cm-button",
                type: "submit"
            }, view.state.phrase("go")), crelt("button", {
                name: "close",
                onclick: () => {
                    view.dispatch({
                        effects: dialogEffect.of(!1)
                    }), view.focus();
                },
                "aria-label": view.state.phrase("close"),
                type: "button"
            }, [ "\xd7" ]))
        };
    }
    "undefined" != typeof Symbol && (RegExpCursor.prototype[Symbol.iterator] = MultilineRegExpCursor.prototype[Symbol.iterator] = function() {
        return this;
    });
    const dialogEffect = StateEffect.define(), dialogField = StateField.define({
        create() {
            return !0;
        },
        update(value, tr) {
            for (var e of tr.effects) e.is(dialogEffect) && (value = e.value);
            return value;
        },
        provide: f => showPanel.from(f, val => val ? createLineDialog : null)
    });
    const baseTheme$1 = EditorView.baseTheme({
        ".cm-panel.cm-gotoLine": {
            padding: "2px 6px 4px",
            position: "relative",
            "& label": {
                fontSize: "80%"
            },
            "& [name=close]": {
                position: "absolute",
                top: "0",
                bottom: "0",
                right: "4px",
                backgroundColor: "inherit",
                border: "none",
                font: "inherit",
                padding: "0"
            }
        }
    }), defaultHighlightOptions = {
        highlightWordAroundCursor: !1,
        minSelectionLength: 1,
        maxMatches: 100,
        wholeWords: !1
    }, highlightConfig = Facet.define({
        combine(options) {
            return combineConfig(options, defaultHighlightOptions, {
                highlightWordAroundCursor: (a, b) => a || b,
                minSelectionLength: Math.min,
                maxMatches: Math.min
            });
        }
    });
    const matchDeco = Decoration.mark({
        class: "cm-selectionMatch"
    }), mainMatchDeco = Decoration.mark({
        class: "cm-selectionMatch cm-selectionMatch-main"
    });
    function insideWordBoundaries(check, state, from, to) {
        return !(0 != from && check(state.sliceDoc(from - 1, from)) == CharCategory.Word || to != state.doc.length && check(state.sliceDoc(to, to + 1)) == CharCategory.Word);
    }
    const matchHighlighter = ViewPlugin.fromClass(class {
        constructor(view) {
            this.decorations = this.getDeco(view);
        }
        update(update) {
            (update.selectionSet || update.docChanged || update.viewportChanged) && (this.decorations = this.getDeco(update.view));
        }
        getDeco(view) {
            var conf = view.state.facet(highlightConfig), state = view["state"], sel = state.selection;
            if (1 < sel.ranges.length) return Decoration.none;
            let range = sel.main, query, check = null;
            if (range.empty) {
                if (!conf.highlightWordAroundCursor) return Decoration.none;
                sel = state.wordAt(range.head);
                if (!sel) return Decoration.none;
                check = state.charCategorizer(range.head), query = state.sliceDoc(sel.from, sel.to);
            } else {
                sel = range.to - range.from;
                if (sel < conf.minSelectionLength || 200 < sel) return Decoration.none;
                if (conf.wholeWords) {
                    if (query = state.sliceDoc(range.from, range.to), !insideWordBoundaries(check = state.charCategorizer(range.head), state, range.from, range.to) || !function(check, state, from, to) {
                        return check(state.sliceDoc(from, from + 1)) == CharCategory.Word && check(state.sliceDoc(to - 1, to)) == CharCategory.Word;
                    }(check, state, range.from, range.to)) return Decoration.none;
                } else if (!(query = state.sliceDoc(range.from, range.to))) return Decoration.none;
            }
            var part, deco = [];
            for (part of view.visibleRanges) for (var cursor = new SearchCursor(state.doc, query, part.from, part.to); !cursor.next().done; ) {
                var {
                    from,
                    to
                } = cursor.value;
                if ((!check || insideWordBoundaries(check, state, from, to)) && (range.empty && from <= range.from && to >= range.to ? deco.push(mainMatchDeco.range(from, to)) : (from >= range.to || to <= range.from) && deco.push(matchDeco.range(from, to)), 
                deco.length > conf.maxMatches)) return Decoration.none;
            }
            return Decoration.set(deco);
        }
    }, {
        decorations: v => v.decorations
    }), defaultTheme$1 = EditorView.baseTheme({
        ".cm-selectionMatch": {
            backgroundColor: "#99ff7780"
        },
        ".cm-searchMatch .cm-selectionMatch": {
            backgroundColor: "transparent"
        }
    });
    const searchConfigFacet = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                top: !1,
                caseSensitive: !1,
                literal: !1,
                regexp: !1,
                wholeWord: !1,
                createPanel: view => new SearchPanel(view),
                scrollToMatch: range => EditorView.scrollIntoView(range)
            });
        }
    });
    class SearchQuery {
        constructor(config) {
            this.search = config.search, this.caseSensitive = !!config.caseSensitive, 
            this.literal = !!config.literal, this.regexp = !!config.regexp, this.replace = config.replace || "", 
            this.valid = !!this.search && (!this.regexp || function(source) {
                try {
                    return new RegExp(source, baseFlags), !0;
                } catch (_a) {
                    return !1;
                }
            }(this.search)), this.unquoted = this.unquote(this.search), this.wholeWord = !!config.wholeWord;
        }
        unquote(text) {
            return this.literal ? text : text.replace(/\\([nrt\\])/g, (_, ch) => "n" == ch ? "\n" : "r" == ch ? "\r" : "t" == ch ? "\t" : "\\");
        }
        eq(other) {
            return this.search == other.search && this.replace == other.replace && this.caseSensitive == other.caseSensitive && this.regexp == other.regexp && this.wholeWord == other.wholeWord;
        }
        create() {
            return new (this.regexp ? RegExpQuery : StringQuery)(this);
        }
        getCursor(state, from = 0, to) {
            state = state.doc ? state : EditorState.create({
                doc: state
            });
            return null == to && (to = state.doc.length), (this.regexp ? regexpCursor : stringCursor)(this, state, from, to);
        }
    }
    class QueryType {
        constructor(spec) {
            this.spec = spec;
        }
    }
    function stringCursor(spec, state, from, to) {
        return new SearchCursor(state.doc, spec.unquoted, from, to, spec.caseSensitive ? void 0 : x => x.toLowerCase(), spec.wholeWord ? (doc = state.doc, 
        categorizer = state.charCategorizer(state.selection.main.head), (from, to, buf, bufPos) => ((from < bufPos || bufPos + buf.length < to) && (bufPos = Math.max(0, from - 2), 
        buf = doc.sliceString(bufPos, Math.min(doc.length, to + 2))), !(categorizer(charBefore(buf, from - bufPos)) == CharCategory.Word && categorizer(charAfter(buf, from - bufPos)) == CharCategory.Word || categorizer(charAfter(buf, to - bufPos)) == CharCategory.Word && categorizer(charBefore(buf, to - bufPos)) == CharCategory.Word))) : void 0);
        var doc, categorizer;
    }
    class StringQuery extends QueryType {
        constructor(spec) {
            super(spec);
        }
        nextMatch(state, curFrom, curTo) {
            let cursor = stringCursor(this.spec, state, curTo, state.doc.length).nextOverlapping();
            var end;
            return cursor.done && (end = Math.min(state.doc.length, curFrom + this.spec.unquoted.length), 
            cursor = stringCursor(this.spec, state, 0, end).nextOverlapping()), 
            cursor.done || cursor.value.from == curFrom && cursor.value.to == curTo ? null : cursor.value;
        }
        prevMatchInRange(state, from, to) {
            for (let pos = to; ;) {
                var start = Math.max(from, pos - 1e4 - this.spec.unquoted.length);
                let cursor = stringCursor(this.spec, state, start, pos), range = null;
                for (;!cursor.nextOverlapping().done; ) range = cursor.value;
                if (range) return range;
                if (start == from) return null;
                pos -= 1e4;
            }
        }
        prevMatch(state, curFrom, curTo) {
            let found = this.prevMatchInRange(state, 0, curFrom);
            return !(found = found || this.prevMatchInRange(state, Math.max(0, curTo - this.spec.unquoted.length), state.doc.length)) || found.from == curFrom && found.to == curTo ? null : found;
        }
        getReplacement(_result) {
            return this.spec.unquote(this.spec.replace);
        }
        matchAll(state, limit) {
            for (var cursor = stringCursor(this.spec, state, 0, state.doc.length), ranges = []; !cursor.next().done; ) {
                if (limit <= ranges.length) return null;
                ranges.push(cursor.value);
            }
            return ranges;
        }
        highlight(state, from, to, add) {
            for (var cursor = stringCursor(this.spec, state, Math.max(0, from - this.spec.unquoted.length), Math.min(to + this.spec.unquoted.length, state.doc.length)); !cursor.next().done; ) add(cursor.value.from, cursor.value.to);
        }
    }
    function regexpCursor(spec, state, from, to) {
        return new RegExpCursor(state.doc, spec.search, {
            ignoreCase: !spec.caseSensitive,
            test: spec.wholeWord ? (categorizer = state.charCategorizer(state.selection.main.head), 
            (_from, _to, match) => !match[0].length || (categorizer(charBefore(match.input, match.index)) != CharCategory.Word || categorizer(charAfter(match.input, match.index)) != CharCategory.Word) && (categorizer(charAfter(match.input, match.index + match[0].length)) != CharCategory.Word || categorizer(charBefore(match.input, match.index + match[0].length)) != CharCategory.Word)) : void 0
        }, from, to);
        var categorizer;
    }
    function charBefore(str, index) {
        return str.slice(findClusterBreak(str, index, !1), index);
    }
    function charAfter(str, index) {
        return str.slice(index, findClusterBreak(str, index));
    }
    class RegExpQuery extends QueryType {
        nextMatch(state, curFrom, curTo) {
            let cursor = regexpCursor(this.spec, state, curTo, state.doc.length).next();
            return (cursor = cursor.done ? regexpCursor(this.spec, state, 0, curFrom).next() : cursor).done ? null : cursor.value;
        }
        prevMatchInRange(state, from, to) {
            for (let size = 1; ;size++) {
                var start = Math.max(from, to - 1e4 * size);
                let cursor = regexpCursor(this.spec, state, start, to), range = null;
                for (;!cursor.next().done; ) range = cursor.value;
                if (range && (start == from || range.from > start + 10)) return range;
                if (start == from) return null;
            }
        }
        prevMatch(state, curFrom, curTo) {
            return this.prevMatchInRange(state, 0, curFrom) || this.prevMatchInRange(state, curTo, state.doc.length);
        }
        getReplacement(result) {
            return this.spec.unquote(this.spec.replace).replace(/\$([$&]|\d+)/g, (m, i) => {
                if ("&" == i) return result.match[0];
                if ("$" == i) return "$";
                for (let l = i.length; 0 < l; l--) {
                    var n = +i.slice(0, l);
                    if (0 < n && n < result.match.length) return result.match[n] + i.slice(l);
                }
                return m;
            });
        }
        matchAll(state, limit) {
            for (var cursor = regexpCursor(this.spec, state, 0, state.doc.length), ranges = []; !cursor.next().done; ) {
                if (limit <= ranges.length) return null;
                ranges.push(cursor.value);
            }
            return ranges;
        }
        highlight(state, from, to, add) {
            for (var cursor = regexpCursor(this.spec, state, Math.max(0, from - 250), Math.min(to + 250, state.doc.length)); !cursor.next().done; ) add(cursor.value.from, cursor.value.to);
        }
    }
    const setSearchQuery = StateEffect.define(), togglePanel = StateEffect.define(), searchState = StateField.define({
        create(state) {
            return new SearchState(defaultQuery(state).create(), null);
        },
        update(value, tr) {
            for (var effect of tr.effects) effect.is(setSearchQuery) ? value = new SearchState(effect.value.create(), value.panel) : effect.is(togglePanel) && (value = new SearchState(value.query, effect.value ? createSearchPanel : null));
            return value;
        },
        provide: f => showPanel.from(f, val => val.panel)
    });
    class SearchState {
        constructor(query, panel) {
            this.query = query, this.panel = panel;
        }
    }
    const matchMark = Decoration.mark({
        class: "cm-searchMatch"
    }), selectedMatchMark = Decoration.mark({
        class: "cm-searchMatch cm-searchMatch-selected"
    });
    safari = ViewPlugin.fromClass(class {
        constructor(view) {
            this.view = view, this.decorations = this.highlight(view.state.field(searchState));
        }
        update(update) {
            var state = update.state.field(searchState);
            (state != update.startState.field(searchState) || update.docChanged || update.selectionSet || update.viewportChanged) && (this.decorations = this.highlight(state));
        }
        highlight({
            query,
            panel
        }) {
            if (!panel || !query.spec.valid) return Decoration.none;
            let view = this["view"], builder = new RangeSetBuilder();
            for (let i = 0, ranges = view.visibleRanges, l = ranges.length; i < l; i++) {
                let {
                    from,
                    to
                } = ranges[i];
                for (;i < l - 1 && to > ranges[i + 1].from - 500; ) to = ranges[++i].to;
                query.highlight(view.state, from, to, (from, to) => {
                    var selected = view.state.selection.ranges.some(r => r.from == from && r.to == to);
                    builder.add(from, to, selected ? selectedMatchMark : matchMark);
                });
            }
            return builder.finish();
        }
    }, {
        decorations: v => v.decorations
    });
    function searchCommand(f) {
        return view => {
            var state = view.state.field(searchState, !1);
            return state && state.query.spec.valid ? f(view, state) : openSearchPanel(view);
        };
    }
    const findNext = searchCommand((view, {
        query
    }) => {
        var config, to = view.state.selection.main["to"], query = query.nextMatch(view.state, to, to);
        return !!query && (to = EditorSelection.single(query.from, query.to), config = view.state.facet(searchConfigFacet), 
        view.dispatch({
            selection: to,
            effects: [ announceMatch(view, query), config.scrollToMatch(to.main, view) ],
            userEvent: "select.search"
        }), selectSearchInput(view), !0);
    }), findPrevious = searchCommand((view, {
        query
    }) => {
        var state = view["state"], from = state.selection.main["from"], query = query.prevMatch(state, from, from);
        return !!query && (state = EditorSelection.single(query.from, query.to), 
        from = view.state.facet(searchConfigFacet), view.dispatch({
            selection: state,
            effects: [ announceMatch(view, query), from.scrollToMatch(state.main, view) ],
            userEvent: "select.search"
        }), selectSearchInput(view), !0);
    }), selectMatches = searchCommand((view, {
        query
    }) => {
        query = query.matchAll(view.state, 1e3);
        return !(!query || !query.length || (view.dispatch({
            selection: EditorSelection.create(query.map(r => EditorSelection.range(r.from, r.to))),
            userEvent: "select.search.matches"
        }), 0));
    });
    const replaceNext = searchCommand((view, {
        query
    }) => {
        var state = view["state"], {
            from,
            to
        } = state.selection.main;
        if (state.readOnly) return !1;
        var match = query.nextMatch(state, from, from);
        if (!match) return !1;
        let next = match, changes = [], selection, replacement;
        match = [], next.from == from && next.to == to && (replacement = state.toText(query.getReplacement(next)), 
        changes.push({
            from: next.from,
            to: next.to,
            insert: replacement
        }), next = query.nextMatch(state, next.from, next.to), match.push(EditorView.announce.of(state.phrase("replaced match on line $", state.doc.lineAt(from).number) + "."))), 
        to = view.state.changes(changes);
        return next && (selection = EditorSelection.single(next.from, next.to).map(to), 
        match.push(announceMatch(view, next)), match.push(state.facet(searchConfigFacet).scrollToMatch(selection.main, view))), 
        view.dispatch({
            changes: to,
            selection: selection,
            effects: match,
            userEvent: "input.replace"
        }), !0;
    }), replaceAll = searchCommand((view, {
        query
    }) => {
        var changes, announceText;
        return !view.state.readOnly && !!(changes = query.matchAll(view.state, 1e9).map(match => {
            var {
                from,
                to
            } = match;
            return {
                from: from,
                to: to,
                insert: query.getReplacement(match)
            };
        })).length && (announceText = view.state.phrase("replaced $ matches", changes.length) + ".", 
        view.dispatch({
            changes: changes,
            effects: EditorView.announce.of(announceText),
            userEvent: "input.replace.all"
        }), !0);
    });
    function createSearchPanel(view) {
        return view.state.facet(searchConfigFacet).createPanel(view);
    }
    function defaultQuery(state, fallback) {
        var _a, sel = state.selection.main, sel = sel.empty || sel.to > sel.from + 100 ? "" : state.sliceDoc(sel.from, sel.to);
        return fallback && !sel ? fallback : (state = state.facet(searchConfigFacet), 
        new SearchQuery({
            search: (null != (_a = null == fallback ? void 0 : fallback.literal) ? _a : state.literal) ? sel : sel.replace(/\n/g, "\\n"),
            caseSensitive: null != (_a = null == fallback ? void 0 : fallback.caseSensitive) ? _a : state.caseSensitive,
            literal: null != (sel = null == fallback ? void 0 : fallback.literal) ? sel : state.literal,
            regexp: null != (_a = null == fallback ? void 0 : fallback.regexp) ? _a : state.regexp,
            wholeWord: null != (sel = null == fallback ? void 0 : fallback.wholeWord) ? sel : state.wholeWord
        }));
    }
    function getSearchInput(view) {
        view = getPanel(view, createSearchPanel);
        return view && view.dom.querySelector("[main-field]");
    }
    function selectSearchInput(view) {
        var input = getSearchInput(view);
        input && input == view.root.activeElement && input.select();
    }
    const openSearchPanel = view => {
        var searchInput, query, state = view.state.field(searchState, !1);
        return state && state.panel ? (searchInput = getSearchInput(view)) && searchInput != view.root.activeElement && ((query = defaultQuery(view.state, state.query.spec)).valid && view.dispatch({
            effects: setSearchQuery.of(query)
        }), searchInput.focus(), searchInput.select()) : view.dispatch({
            effects: [ togglePanel.of(!0), state ? setSearchQuery.of(defaultQuery(view.state, state.query.spec)) : StateEffect.appendConfig.of(searchExtensions) ]
        }), !0;
    }, closeSearchPanel = view => {
        var state = view.state.field(searchState, !1);
        return !(!state || !state.panel || ((state = getPanel(view, createSearchPanel)) && state.dom.contains(view.root.activeElement) && view.focus(), 
        view.dispatch({
            effects: togglePanel.of(!1)
        }), 0));
    };
    selectPageDown = [ {
        key: "Mod-f",
        run: openSearchPanel,
        scope: "editor search-panel"
    }, {
        key: "F3",
        run: findNext,
        shift: findPrevious,
        scope: "editor search-panel",
        preventDefault: !0
    }, {
        key: "Mod-g",
        run: findNext,
        shift: findPrevious,
        scope: "editor search-panel",
        preventDefault: !0
    }, {
        key: "Escape",
        run: closeSearchPanel,
        scope: "editor search-panel"
    }, {
        key: "Mod-Shift-l",
        run: ({
            state,
            dispatch
        }) => {
            var sel = state.selection;
            if (1 < sel.ranges.length || sel.main.empty) return !1;
            var {
                from,
                to: sel
            } = sel.main;
            let ranges = [], main = 0;
            for (var cur = new SearchCursor(state.doc, state.sliceDoc(from, sel)); !cur.next().done; ) {
                if (1e3 < ranges.length) return !1;
                cur.value.from == from && (main = ranges.length), ranges.push(EditorSelection.range(cur.value.from, cur.value.to));
            }
            return dispatch(state.update({
                selection: EditorSelection.create(ranges, main),
                userEvent: "select.search.matches"
            })), !0;
        }
    }, {
        key: "Mod-Alt-g",
        run: view => {
            let panel = getPanel(view, createLineDialog);
            var effects;
            return panel || (effects = [ dialogEffect.of(!0) ], null == view.state.field(dialogField, !1) && effects.push(StateEffect.appendConfig.of([ dialogField, baseTheme$1 ])), 
            view.dispatch({
                effects: effects
            }), panel = getPanel(view, createLineDialog)), panel && panel.dom.querySelector("input").select(), 
            !0;
        }
    }, {
        key: "Mod-d",
        run: ({
            state,
            dispatch
        }) => {
            var ranges = state.selection["ranges"];
            if (ranges.some(sel => sel.from === sel.to)) return (({
                state,
                dispatch
            }) => {
                var selection = state["selection"], newSel = EditorSelection.create(selection.ranges.map(range => state.wordAt(range.head) || EditorSelection.cursor(range.head)), selection.mainIndex);
                return !newSel.eq(selection) && (dispatch(state.update({
                    selection: newSel
                })), !0);
            })({
                state: state,
                dispatch: dispatch
            });
            let searchedText = state.sliceDoc(ranges[0].from, ranges[0].to);
            return !state.selection.ranges.some(r => state.sliceDoc(r.from, r.to) != searchedText) && !!(ranges = function(state, query) {
                var {
                    main,
                    ranges
                } = state.selection, word = state.wordAt(main.head), fullWord = word && word.from == main.from && word.to == main.to;
                for (let cycled = !1, cursor = new SearchCursor(state.doc, query, ranges[ranges.length - 1].to); ;) if (cursor.next(), 
                cursor.done) {
                    if (cycled) return null;
                    cursor = new SearchCursor(state.doc, query, 0, Math.max(0, ranges[ranges.length - 1].from - 1)), 
                    cycled = !0;
                } else if (!cycled || !ranges.some(r => r.from == cursor.value.from)) {
                    if (fullWord) {
                        let word = state.wordAt(cursor.value.from);
                        if (!word || word.from != cursor.value.from || word.to != cursor.value.to) continue;
                    }
                    return cursor.value;
                }
            }(state, searchedText)) && (dispatch(state.update({
                selection: state.selection.addRange(EditorSelection.range(ranges.from, ranges.to), !1),
                effects: EditorView.scrollIntoView(ranges.to)
            })), !0);
        },
        preventDefault: !0
    } ];
    class SearchPanel {
        constructor(view) {
            this.view = view;
            var query = this.query = view.state.field(searchState).query.spec;
            function button(name, onclick, content) {
                return crelt("button", {
                    class: "cm-button",
                    name: name,
                    onclick: onclick,
                    type: "button"
                }, content);
            }
            this.commit = this.commit.bind(this), this.searchField = crelt("input", {
                value: query.search,
                placeholder: phrase(view, "Find"),
                "aria-label": phrase(view, "Find"),
                class: "cm-textfield",
                name: "search",
                form: "",
                "main-field": "true",
                onchange: this.commit,
                onkeyup: this.commit
            }), this.replaceField = crelt("input", {
                value: query.replace,
                placeholder: phrase(view, "Replace"),
                "aria-label": phrase(view, "Replace"),
                class: "cm-textfield",
                name: "replace",
                form: "",
                onchange: this.commit,
                onkeyup: this.commit
            }), this.caseField = crelt("input", {
                type: "checkbox",
                name: "case",
                form: "",
                checked: query.caseSensitive,
                onchange: this.commit
            }), this.reField = crelt("input", {
                type: "checkbox",
                name: "re",
                form: "",
                checked: query.regexp,
                onchange: this.commit
            }), this.wordField = crelt("input", {
                type: "checkbox",
                name: "word",
                form: "",
                checked: query.wholeWord,
                onchange: this.commit
            }), this.dom = crelt("div", {
                onkeydown: e => this.keydown(e),
                class: "cm-search"
            }, [ this.searchField, button("next", () => findNext(view), [ phrase(view, "next") ]), button("prev", () => findPrevious(view), [ phrase(view, "previous") ]), button("select", () => selectMatches(view), [ phrase(view, "all") ]), crelt("label", null, [ this.caseField, phrase(view, "match case") ]), crelt("label", null, [ this.reField, phrase(view, "regexp") ]), crelt("label", null, [ this.wordField, phrase(view, "by word") ]), ...view.state.readOnly ? [] : [ crelt("br"), this.replaceField, button("replace", () => replaceNext(view), [ phrase(view, "replace") ]), button("replaceAll", () => replaceAll(view), [ phrase(view, "replace all") ]) ], crelt("button", {
                name: "close",
                onclick: () => closeSearchPanel(view),
                "aria-label": phrase(view, "close"),
                type: "button"
            }, [ "\xd7" ]) ]);
        }
        commit() {
            var query = new SearchQuery({
                search: this.searchField.value,
                caseSensitive: this.caseField.checked,
                regexp: this.reField.checked,
                wholeWord: this.wordField.checked,
                replace: this.replaceField.value
            });
            query.eq(this.query) || (this.query = query, this.view.dispatch({
                effects: setSearchQuery.of(query)
            }));
        }
        keydown(e) {
            var view, event, scope;
            view = this.view, event = e, scope = "search-panel", runHandlers(getKeymap(view.state), event, view, scope) ? e.preventDefault() : 13 == e.keyCode && e.target == this.searchField ? (e.preventDefault(), 
            (e.shiftKey ? findPrevious : findNext)(this.view)) : 13 == e.keyCode && e.target == this.replaceField && (e.preventDefault(), 
            replaceNext(this.view));
        }
        update(update) {
            for (var tr of update.transactions) for (var effect of tr.effects) effect.is(setSearchQuery) && !effect.value.eq(this.query) && this.setQuery(effect.value);
        }
        setQuery(query) {
            this.query = query, this.searchField.value = query.search, this.replaceField.value = query.replace, 
            this.caseField.checked = query.caseSensitive, this.reField.checked = query.regexp, 
            this.wordField.checked = query.wholeWord;
        }
        mount() {
            this.searchField.select();
        }
        get pos() {
            return 80;
        }
        get top() {
            return this.view.state.facet(searchConfigFacet).top;
        }
    }
    function phrase(view, phrase) {
        return view.state.phrase(phrase);
    }
    const AnnounceMargin = 30, Break = /[\s\.,:;?!]/;
    function announceMatch(view, {
        from,
        to
    }) {
        var line = view.state.doc.lineAt(from), lineEnd = view.state.doc.lineAt(to).to, from = Math.max(line.from, from - AnnounceMargin), to = Math.min(lineEnd, to + AnnounceMargin);
        let text = view.state.sliceDoc(from, to);
        if (from != line.from) for (let i = 0; i < AnnounceMargin; i++) if (!Break.test(text[i + 1]) && Break.test(text[i])) {
            text = text.slice(i);
            break;
        }
        if (to != lineEnd) for (let i = text.length - 1; i > text.length - AnnounceMargin; i--) if (!Break.test(text[i - 1]) && Break.test(text[i])) {
            text = text.slice(0, i);
            break;
        }
        return EditorView.announce.of(`${view.state.phrase("current match")}. ${text} ${view.state.phrase("on line")} ${line.number}.`);
    }
    cursorDocStart = EditorView.baseTheme({
        ".cm-panel.cm-search": {
            padding: "2px 6px 4px",
            position: "relative",
            "& [name=close]": {
                position: "absolute",
                top: "0",
                right: "4px",
                backgroundColor: "inherit",
                border: "none",
                font: "inherit",
                padding: 0,
                margin: 0
            },
            "& input, & button, & label": {
                margin: ".2em .6em .2em 0"
            },
            "& input[type=checkbox]": {
                marginRight: ".2em"
            },
            "& label": {
                fontSize: "80%",
                whiteSpace: "pre"
            }
        },
        "&light .cm-searchMatch": {
            backgroundColor: "#ffff0054"
        },
        "&dark .cm-searchMatch": {
            backgroundColor: "#00ffff8a"
        },
        "&light .cm-searchMatch-selected": {
            backgroundColor: "#ff6a0054"
        },
        "&dark .cm-searchMatch-selected": {
            backgroundColor: "#ff00ff8a"
        }
    });
    const searchExtensions = [ searchState, Prec.low(safari), cursorDocStart ];
    function toSet(chars) {
        let flat = Object.keys(chars).join("");
        chars = /\w/.test(flat);
        return `[${chars ? "\\w" : ""}${(flat = chars ? flat.replace(/\w/g, "") : flat).replace(/[^\w\s]/g, "\\$&")}]`;
    }
    function completeFromList(list) {
        let options = list.map(o => "string" == typeof o ? {
            label: o
        } : o), [ validFor, match ] = options.every(o => /^\w+$/.test(o.label)) ? [ /\w*$/, /\w+$/ ] : function(options) {
            var label, first = Object.create(null), rest = Object.create(null);
            for ({
                label
            } of options) {
                first[label[0]] = !0;
                for (let i = 1; i < label.length; i++) rest[label[i]] = !0;
            }
            return options = toSet(first) + toSet(rest) + "*$", [ new RegExp("^" + options), new RegExp(options) ];
        }(options);
        return context => {
            var token = context.matchBefore(match);
            return token || context.explicit ? {
                from: token ? token.from : context.pos,
                options: options,
                validFor: validFor
            } : null;
        };
    }
    class Option {
        constructor(completion, source, match, score) {
            this.completion = completion, this.source = source, this.match = match, 
            this.score = score;
        }
    }
    function cur(state) {
        return state.selection.main.from;
    }
    const pickedCompletion = Annotation.define();
    const SourceCache = new WeakMap();
    function asSource(source) {
        if (!Array.isArray(source)) return source;
        let known = SourceCache.get(source);
        return known || SourceCache.set(source, known = completeFromList(source)), 
        known;
    }
    const startCompletionEffect = StateEffect.define(), closeCompletionEffect = StateEffect.define();
    class FuzzyMatcher {
        constructor(pattern) {
            this.pattern = pattern, this.chars = [], this.folded = [], this.any = [], 
            this.precise = [], this.byWord = [], this.score = 0, this.matched = [];
            for (let p = 0; p < pattern.length; ) {
                var char = codePointAt(pattern, p), size = char < 65536 ? 1 : 2, char = (this.chars.push(char), 
                pattern.slice(p, p + size)), upper = char.toUpperCase();
                this.folded.push(codePointAt(upper == char ? char.toLowerCase() : upper, 0)), 
                p += size;
            }
            this.astral = pattern.length != this.chars.length;
        }
        ret(score, matched) {
            return this.score = score, this.matched = matched, this;
        }
        match(word) {
            if (0 == this.pattern.length) return this.ret(-100, []);
            if (word.length < this.pattern.length) return null;
            var {
                chars,
                folded,
                any,
                precise,
                byWord
            } = this;
            if (1 == chars.length) {
                var first = codePointAt(word, 0), firstSize = first < 65536 ? 1 : 2;
                let score = firstSize == word.length ? 0 : -100;
                if (first != chars[0]) {
                    if (first != folded[0]) return null;
                    score += -200;
                }
                return this.ret(score, [ 0, firstSize ]);
            }
            var direct = word.indexOf(this.pattern);
            if (0 == direct) return this.ret(word.length == this.pattern.length ? 0 : -100, [ 0, this.pattern.length ]);
            let len = chars.length, anyTo = 0;
            if (direct < 0) {
                for (let i = 0, e = Math.min(word.length, 200); i < e && anyTo < len; ) {
                    var next = codePointAt(word, i);
                    next != chars[anyTo] && next != folded[anyTo] || (any[anyTo++] = i), 
                    i += next < 65536 ? 1 : 2;
                }
                if (anyTo < len) return null;
            }
            let preciseTo = 0, byWordTo = 0, byWordFolded = !1, adjacentTo = 0, adjacentStart = -1, adjacentEnd = -1, hasLower = /[a-z]/.test(word), wordAdjacent = !0;
            for (let i = 0, e = Math.min(word.length, 200), prevType = 0; i < e && byWordTo < len; ) {
                let next = codePointAt(word, i);
                direct < 0 && (preciseTo < len && next == chars[preciseTo] && (precise[preciseTo++] = i), 
                adjacentTo < len) && (next == chars[adjacentTo] || next == folded[adjacentTo] ? (0 == adjacentTo && (adjacentStart = i), 
                adjacentEnd = i + 1, adjacentTo++) : adjacentTo = 0);
                var ch = next < 255 ? 48 <= next && next <= 57 || 97 <= next && next <= 122 ? 2 : 65 <= next && next <= 90 ? 1 : 0 : (ch = fromCodePoint(next)) != ch.toLowerCase() ? 1 : ch != ch.toUpperCase() ? 2 : 0;
                (!i || 1 == ch && hasLower || 0 == prevType && 0 != ch) && (chars[byWordTo] == next || folded[byWordTo] == next && (byWordFolded = !0) ? byWord[byWordTo++] = i : byWord.length && (wordAdjacent = !1)), 
                prevType = ch, i += codePointSize(next);
            }
            return byWordTo == len && 0 == byWord[0] && wordAdjacent ? this.result((byWordFolded ? -200 : 0) - 100, byWord, word) : adjacentTo == len && 0 == adjacentStart ? this.ret(-200 - word.length + (adjacentEnd == word.length ? 0 : -100), [ 0, adjacentEnd ]) : -1 < direct ? this.ret(-700 - word.length, [ direct, direct + this.pattern.length ]) : adjacentTo == len ? this.ret(-900 - word.length, [ adjacentStart, adjacentEnd ]) : byWordTo == len ? this.result((byWordFolded ? -200 : 0) - 100 - 700 + (wordAdjacent ? 0 : -1100), byWord, word) : 2 == chars.length ? null : this.result((any[0] ? -700 : 0) - 200 - 1100, any, word);
        }
        result(score, positions, word) {
            let result = [], i = 0;
            for (var pos of positions) {
                var to = pos + (this.astral ? codePointSize(codePointAt(word, pos)) : 1);
                i && result[i - 1] == pos ? result[i - 1] = to : (result[i++] = pos, 
                result[i++] = to);
            }
            return this.ret(score - word.length, result);
        }
    }
    class StrictMatcher {
        constructor(pattern) {
            this.pattern = pattern, this.matched = [], this.score = 0, this.folded = pattern.toLowerCase();
        }
        match(word) {
            var start, match;
            return word.length < this.pattern.length || null == (match = (start = word.slice(0, this.pattern.length)) == this.pattern ? 0 : start.toLowerCase() == this.folded ? -200 : null) ? null : (this.matched = [ 0, start.length ], 
            this.score = match + (word.length == this.pattern.length ? 0 : -100), 
            this);
        }
    }
    const completionConfig = Facet.define({
        combine(configs) {
            return combineConfig(configs, {
                activateOnTyping: !0,
                activateOnCompletion: () => !1,
                activateOnTypingDelay: 100,
                selectOnOpen: !0,
                override: null,
                closeOnBlur: !0,
                maxRenderedOptions: 100,
                defaultKeymap: !0,
                tooltipClass: () => "",
                optionClass: () => "",
                aboveCursor: !1,
                icons: !0,
                addToOptions: [],
                positionInfo: defaultPositionInfo,
                filterStrict: !1,
                compareCompletions: (a, b) => a.label.localeCompare(b.label),
                interactionDelay: 75,
                updateSyncTime: 100
            }, {
                defaultKeymap: (a, b) => a && b,
                closeOnBlur: (a, b) => a && b,
                icons: (a, b) => a && b,
                tooltipClass: (a, b) => c => joinClass(a(c), b(c)),
                optionClass: (a, b) => c => joinClass(a(c), b(c)),
                addToOptions: (a, b) => a.concat(b),
                filterStrict: (a, b) => a || b
            });
        }
    });
    function joinClass(a, b) {
        return a ? b ? a + " " + b : a : b;
    }
    function defaultPositionInfo(view, list, option, info, space, tooltip) {
        let rtl = view.textDirection == Direction.RTL, left = rtl, narrow = !1, side = "top", offset, maxWidth;
        var view = list.left - space.left, spaceRight = space.right - list.right, infoWidth = info.right - info.left, info = info.bottom - info.top, view = (left && view < Math.min(infoWidth, spaceRight) ? left = !1 : !left && spaceRight < Math.min(infoWidth, view) && (left = !0), 
        infoWidth <= (left ? view : spaceRight) ? (offset = Math.max(space.top, Math.min(option.top, space.bottom - info)) - list.top, 
        maxWidth = Math.min(400, left ? view : spaceRight)) : (narrow = !0, maxWidth = Math.min(400, (rtl ? list.right : space.right - list.left) - 30), 
        infoWidth = space.bottom - list.bottom, offset = info <= infoWidth || infoWidth > list.top ? option.bottom - list.top : (side = "bottom", 
        list.bottom - option.top)), (list.bottom - list.top) / tooltip.offsetHeight), spaceRight = (list.right - list.left) / tooltip.offsetWidth;
        return {
            style: `${side}: ${offset / view}px; max-width: ${maxWidth / spaceRight}px`,
            class: "cm-completionInfo-" + (narrow ? rtl ? "left-narrow" : "right-narrow" : left ? "left" : "right")
        };
    }
    function rangeAroundSelected(total, selected, max) {
        if (total <= max) return {
            from: 0,
            to: total
        };
        if ((selected = selected < 0 ? 0 : selected) <= total >> 1) {
            let off = Math.floor(selected / max);
            return {
                from: off * max,
                to: (off + 1) * max
            };
        }
        selected = Math.floor((total - selected) / max);
        return {
            from: total - (selected + 1) * max,
            to: total - selected * max
        };
    }
    class CompletionTooltip {
        constructor(view, stateField, applyCompletion) {
            this.view = view, this.stateField = stateField, this.applyCompletion = applyCompletion, 
            this.info = null, this.infoDestroy = null, this.placeInfoReq = {
                read: () => this.measureInfo(),
                write: pos => this.placeInfo(pos),
                key: this
            }, this.space = null, this.currentClass = "";
            var applyCompletion = view.state.field(stateField), {
                options,
                selected
            } = applyCompletion.open, config = view.state.facet(completionConfig);
            this.optionContent = function(config) {
                var content = config.addToOptions.slice();
                return config.icons && content.push({
                    render(completion) {
                        var icon = document.createElement("div");
                        return icon.classList.add("cm-completionIcon"), completion.type && icon.classList.add(...completion.type.split(/\s+/g).map(cls => "cm-completionIcon-" + cls)), 
                        icon.setAttribute("aria-hidden", "true"), icon;
                    },
                    position: 20
                }), content.push({
                    render(completion, _s, _v, match) {
                        var labelElt = document.createElement("span");
                        labelElt.className = "cm-completionLabel";
                        let label = completion.displayLabel || completion.label, off = 0;
                        for (let j = 0; j < match.length; ) {
                            var from = match[j++], to = match[j++], span = (from > off && labelElt.appendChild(document.createTextNode(label.slice(off, from))), 
                            labelElt.appendChild(document.createElement("span")));
                            span.appendChild(document.createTextNode(label.slice(from, to))), 
                            span.className = "cm-completionMatchedText", off = to;
                        }
                        return off < label.length && labelElt.appendChild(document.createTextNode(label.slice(off))), 
                        labelElt;
                    },
                    position: 50
                }, {
                    render(completion) {
                        var detailElt;
                        return completion.detail ? ((detailElt = document.createElement("span")).className = "cm-completionDetail", 
                        detailElt.textContent = completion.detail, detailElt) : null;
                    },
                    position: 80
                }), content.sort((a, b) => a.position - b.position).map(a => a.render);
            }(config), this.optionClass = config.optionClass, this.tooltipClass = config.tooltipClass, 
            this.range = rangeAroundSelected(options.length, selected, config.maxRenderedOptions), 
            this.dom = document.createElement("div"), this.dom.className = "cm-tooltip-autocomplete", 
            this.updateTooltipClass(view.state), this.dom.addEventListener("mousedown", e => {
                var options = view.state.field(stateField).open["options"];
                for (let dom = e.target, match; dom && dom != this.dom; dom = dom.parentNode) if ("LI" == dom.nodeName && (match = /-(\d+)$/.exec(dom.id)) && +match[1] < options.length) return this.applyCompletion(view, options[+match[1]]), 
                void e.preventDefault();
            }), this.dom.addEventListener("focusout", e => {
                var state = view.state.field(this.stateField, !1);
                state && state.tooltip && view.state.facet(completionConfig).closeOnBlur && e.relatedTarget != view.contentDOM && view.dispatch({
                    effects: closeCompletionEffect.of(null)
                });
            }), this.showOptions(options, applyCompletion.id);
        }
        mount() {
            this.updateSel();
        }
        showOptions(options, id) {
            this.list && this.list.remove(), this.list = this.dom.appendChild(this.createListBox(options, id, this.range)), 
            this.list.addEventListener("scroll", () => {
                this.info && this.view.requestMeasure(this.placeInfoReq);
            });
        }
        update(update) {
            var options, selected, disabled, cState = update.state.field(this.stateField), prevState = update.startState.field(this.stateField);
            this.updateTooltipClass(update.state), cState != prevState && ({
                options,
                selected,
                disabled
            } = cState.open, prevState.open && prevState.open.options == options || (this.range = rangeAroundSelected(options.length, selected, update.state.facet(completionConfig).maxRenderedOptions), 
            this.showOptions(options, cState.id)), this.updateSel(), disabled != (null == (selected = prevState.open) ? void 0 : selected.disabled)) && this.dom.classList.toggle("cm-tooltip-autocomplete-disabled", !!disabled);
        }
        updateTooltipClass(state) {
            state = this.tooltipClass(state);
            if (state != this.currentClass) {
                for (var c of this.currentClass.split(" ")) c && this.dom.classList.remove(c);
                for (let c of state.split(" ")) c && this.dom.classList.add(c);
                this.currentClass = state;
            }
        }
        positioned(space) {
            this.space = space, this.info && this.view.requestMeasure(this.placeInfoReq);
        }
        updateSel() {
            let cState = this.view.state.field(this.stateField), open = cState.open;
            if ((-1 < open.selected && open.selected < this.range.from || open.selected >= this.range.to) && (this.range = rangeAroundSelected(open.options.length, open.selected, this.view.state.facet(completionConfig).maxRenderedOptions), 
            this.showOptions(open.options, cState.id)), this.updateSelectedOption(open.selected)) {
                this.destroyInfo();
                let completion = open.options[open.selected]["completion"];
                var info = completion["info"];
                info && (info = "string" == typeof info ? document.createTextNode(info) : info(completion)) && ("then" in info ? info.then(obj => {
                    obj && this.view.state.field(this.stateField, !1) == cState && this.addInfoPane(obj, completion);
                }).catch(e => logException(this.view.state, e, "completion info")) : this.addInfoPane(info, completion));
            }
        }
        addInfoPane(content, completion) {
            this.destroyInfo();
            var destroy, wrap = this.info = document.createElement("div");
            wrap.className = "cm-tooltip cm-completionInfo", null != content.nodeType ? (wrap.appendChild(content), 
            this.infoDestroy = null) : ({
                dom: content,
                destroy
            } = content, wrap.appendChild(content), this.infoDestroy = destroy || null), 
            this.dom.appendChild(wrap), this.view.requestMeasure(this.placeInfoReq);
        }
        updateSelectedOption(selected) {
            let set = null;
            for (let opt = this.list.firstChild, i = this.range.from; opt; opt = opt.nextSibling, 
            i++) "LI" == opt.nodeName && opt.id ? i == selected ? opt.hasAttribute("aria-selected") || (opt.setAttribute("aria-selected", "true"), 
            set = opt) : opt.hasAttribute("aria-selected") && opt.removeAttribute("aria-selected") : i--;
            var container, element, parent, scaleY;
            return set && (container = this.list, element = set, parent = container.getBoundingClientRect(), 
            element = element.getBoundingClientRect(), scaleY = parent.height / container.offsetHeight, 
            element.top < parent.top ? container.scrollTop -= (parent.top - element.top) / scaleY : element.bottom > parent.bottom && (container.scrollTop += (element.bottom - parent.bottom) / scaleY)), 
            set;
        }
        measureInfo() {
            var sel = this.dom.querySelector("[aria-selected]");
            if (!sel || !this.info) return null;
            var docElt, listRect = this.dom.getBoundingClientRect(), infoRect = this.info.getBoundingClientRect(), sel = sel.getBoundingClientRect();
            let space = this.space;
            return space || (docElt = this.dom.ownerDocument.documentElement, space = {
                left: 0,
                top: 0,
                right: docElt.clientWidth,
                bottom: docElt.clientHeight
            }), sel.top > Math.min(space.bottom, listRect.bottom) - 10 || sel.bottom < Math.max(space.top, listRect.top) + 10 ? null : this.view.state.facet(completionConfig).positionInfo(this.view, listRect, sel, infoRect, space, this.dom);
        }
        placeInfo(pos) {
            this.info && (pos ? (pos.style && (this.info.style.cssText = pos.style), 
            this.info.className = "cm-tooltip cm-completionInfo " + (pos.class || "")) : this.info.style.cssText = "top: -1e6px");
        }
        createListBox(options, id, range) {
            const ul = document.createElement("ul");
            ul.id = id, ul.setAttribute("role", "listbox"), ul.setAttribute("aria-expanded", "true"), 
            ul.setAttribute("aria-label", this.view.state.phrase("Completions")), 
            ul.addEventListener("mousedown", e => {
                e.target == ul && e.preventDefault();
            });
            let curSection = null;
            for (let i = range.from; i < range.to; i++) {
                var name, source, {
                    completion,
                    match
                } = options[i], section = completion["section"], li = (section && (name = "string" == typeof section ? section : section.name) != curSection && (i > range.from || 0 == range.from) && (curSection = name, 
                "string" != typeof section && section.header ? ul.appendChild(section.header(section)) : ul.appendChild(document.createElement("completion-section")).textContent = name), 
                ul.appendChild(document.createElement("li"))), section = (li.id = id + "-" + i, 
                li.setAttribute("role", "option"), this.optionClass(completion));
                section && (li.className = section);
                for (source of this.optionContent) {
                    var node = source(completion, this.view.state, this.view, match);
                    node && li.appendChild(node);
                }
            }
            return range.from && ul.classList.add("cm-completionListIncompleteTop"), 
            range.to < options.length && ul.classList.add("cm-completionListIncompleteBottom"), 
            ul;
        }
        destroyInfo() {
            this.info && (this.infoDestroy && this.infoDestroy(), this.info.remove(), 
            this.info = null);
        }
        destroy() {
            this.destroyInfo();
        }
    }
    function completionTooltip(stateField, applyCompletion) {
        return view => new CompletionTooltip(view, stateField, applyCompletion);
    }
    function score(option) {
        return 100 * (option.boost || 0) + (option.apply ? 10 : 0) + (option.info ? 5 : 0) + (option.type ? 1 : 0);
    }
    class CompletionDialog {
        constructor(options, attrs, tooltip, timestamp, selected, disabled) {
            this.options = options, this.attrs = attrs, this.tooltip = tooltip, 
            this.timestamp = timestamp, this.selected = selected, this.disabled = disabled;
        }
        setSelected(selected, id) {
            return selected == this.selected || selected >= this.options.length ? this : new CompletionDialog(this.options, makeAttrs(id, selected), this.tooltip, this.timestamp, selected, this.disabled);
        }
        static build(active, state, id, prev, conf, didSetActive) {
            if (prev && !didSetActive && active.some(s => s.isPending)) return prev.setDisabled();
            var options = function(active, state) {
                let options = [], sections = null;
                var a, opt, s, addOption = option => {
                    options.push(option);
                    option = option.completion.section;
                    if (option) {
                        sections = sections || [];
                        let name = "string" == typeof option ? option : option.name;
                        sections.some(s => s.name == name) || sections.push("string" == typeof option ? {
                            name: name
                        } : option);
                    }
                }, conf = state.facet(completionConfig);
                for (a of active) if (a.hasResult()) {
                    var getMatch = a.result.getMatch;
                    if (!1 === a.result.filter) for (var option of a.result.options) addOption(new Option(option, a.source, getMatch ? getMatch(option) : [], 1e9 - options.length)); else {
                        var match, matched, pattern = state.sliceDoc(a.from, a.to), matcher = new (conf.filterStrict ? StrictMatcher : FuzzyMatcher)(pattern);
                        for (let option of a.result.options) (match = matcher.match(option.label)) && (matched = option.displayLabel ? getMatch ? getMatch(option, match.matched) : [] : match.matched, 
                        addOption(new Option(option, a.source, matched, match.score + (option.boost || 0))));
                    }
                }
                if (sections) {
                    let sectionOrder = Object.create(null), pos = 0;
                    for (s of sections.sort((a, b) => {
                        var _a;
                        return (null != (_a = a.rank) ? _a : 1e9) - (null != (_a = b.rank) ? _a : 1e9) || (a.name < b.name ? -1 : 1);
                    })) pos -= 1e5, sectionOrder[s.name] = pos;
                    for (let option of options) {
                        var section = option.completion["section"];
                        section && (option.score += sectionOrder["string" == typeof section ? section : section.name]);
                    }
                }
                let result = [], prev = null, compare = conf.compareCompletions;
                for (opt of options.sort((a, b) => b.score - a.score || compare(a.completion, b.completion))) {
                    var cur = opt.completion;
                    !prev || prev.label != cur.label || prev.detail != cur.detail || null != prev.type && null != cur.type && prev.type != cur.type || prev.apply != cur.apply || prev.boost != cur.boost ? result.push(opt) : score(opt.completion) > score(prev) && (result[result.length - 1] = opt), 
                    prev = opt.completion;
                }
                return result;
            }(active, state);
            if (!options.length) return prev && active.some(a => a.isPending) ? prev.setDisabled() : null;
            let selected = state.facet(completionConfig).selectOnOpen ? 0 : -1;
            if (prev && prev.selected != selected && -1 != prev.selected) {
                var selectedValue = prev.options[prev.selected].completion;
                for (let i = 0; i < options.length; i++) if (options[i].completion == selectedValue) {
                    selected = i;
                    break;
                }
            }
            return new CompletionDialog(options, makeAttrs(id, selected), {
                pos: active.reduce((a, b) => b.hasResult() ? Math.min(a, b.from) : a, 1e8),
                create: createTooltip,
                above: conf.aboveCursor
            }, prev ? prev.timestamp : Date.now(), selected, !1);
        }
        map(changes) {
            return new CompletionDialog(this.options, this.attrs, Object.assign(Object.assign({}, this.tooltip), {
                pos: changes.mapPos(this.tooltip.pos)
            }), this.timestamp, this.selected, this.disabled);
        }
        setDisabled() {
            return new CompletionDialog(this.options, this.attrs, this.tooltip, this.timestamp, this.selected, !0);
        }
    }
    class CompletionState {
        constructor(active, id, open) {
            this.active = active, this.id = id, this.open = open;
        }
        static start() {
            return new CompletionState(none$1, "cm-ac-" + Math.floor(2e6 * Math.random()).toString(36), null);
        }
        update(tr) {
            let state = tr["state"], conf = state.facet(completionConfig);
            var effect;
            let active = (conf.override || state.languageDataAt("autocomplete", cur(state)).map(asSource)).map(source => {
                return (this.active.find(s => s.source == source) || new ActiveSource(source, this.active.some(a => 0 != a.state) ? 1 : 0)).update(tr, conf);
            }), open = (active.length == this.active.length && active.every((a, i) => a == this.active[i]) && (active = this.active), 
            this.open), didSet = tr.effects.some(e => e.is(setActiveEffect));
            open && tr.docChanged && (open = open.map(tr.changes)), tr.selection || active.some(a => a.hasResult() && tr.changes.touchesRange(a.from, a.to)) || !function(a, b) {
                if (a == b) return 1;
                for (let iA = 0, iB = 0; ;) {
                    for (;iA < a.length && !a[iA].hasResult(); ) iA++;
                    for (;iB < b.length && !b[iB].hasResult(); ) iB++;
                    var endA = iA == a.length, endB = iB == b.length;
                    if (endA || endB) return endA == endB;
                    if (a[iA++].result != b[iB++].result) return;
                }
            }(active, this.active) || didSet ? open = CompletionDialog.build(active, state, this.id, open, conf, didSet) : open && open.disabled && !active.some(a => a.isPending) && (open = null), 
            !open && active.every(a => !a.isPending) && active.some(a => a.hasResult()) && (active = active.map(a => a.hasResult() ? new ActiveSource(a.source, 0) : a));
            for (effect of tr.effects) effect.is(setSelectedEffect) && (open = open && open.setSelected(effect.value, this.id));
            return active == this.active && open == this.open ? this : new CompletionState(active, this.id, open);
        }
        get tooltip() {
            return this.open ? this.open.tooltip : null;
        }
        get attrs() {
            return this.open ? this.open.attrs : this.active.length ? baseAttrs : noAttrs;
        }
    }
    const baseAttrs = {
        "aria-autocomplete": "list"
    }, noAttrs = {};
    function makeAttrs(id, selected) {
        var result = {
            "aria-autocomplete": "list",
            "aria-haspopup": "listbox",
            "aria-controls": id
        };
        return -1 < selected && (result["aria-activedescendant"] = id + "-" + selected), 
        result;
    }
    const none$1 = [];
    class ActiveSource {
        constructor(source, state, explicit = !1) {
            this.source = source, this.state = state, this.explicit = explicit;
        }
        hasResult() {
            return !1;
        }
        get isPending() {
            return 1 == this.state;
        }
        update(tr, conf) {
            let type = function(tr, conf) {
                if (tr.isUserEvent("input.complete")) {
                    var completion = tr.annotation(pickedCompletion);
                    if (completion && conf.activateOnCompletion(completion)) return 12;
                }
                return (completion = tr.isUserEvent("input.type")) && conf.activateOnTyping ? 5 : completion ? 1 : tr.isUserEvent("delete.backward") ? 2 : tr.selection ? 8 : tr.docChanged ? 16 : 0;
            }(tr, conf), value = this;
            (8 & type || 16 & type && this.touches(tr)) && (value = new ActiveSource(value.source, 0)), 
            value = (value = 4 & type && 0 == value.state ? new ActiveSource(this.source, 1) : value).updateFor(tr, type);
            for (var effect of tr.effects) if (effect.is(startCompletionEffect)) value = new ActiveSource(value.source, 1, effect.value); else if (effect.is(closeCompletionEffect)) value = new ActiveSource(value.source, 0); else if (effect.is(setActiveEffect)) for (var active of effect.value) active.source == value.source && (value = active);
            return value;
        }
        updateFor(tr, type) {
            return this.map(tr.changes);
        }
        map(changes) {
            return this;
        }
        touches(tr) {
            return tr.changes.touchesRange(cur(tr.state));
        }
    }
    (class extends ActiveSource {});
    const setActiveEffect = StateEffect.define({
        map(sources, mapping) {
            return sources.map(s => s.map(mapping));
        }
    }), setSelectedEffect = StateEffect.define(), completionState = StateField.define({
        create() {
            return CompletionState.start();
        },
        update(value, tr) {
            return value.update(tr);
        },
        provide: f => [ showTooltip.from(f, val => val.tooltip), EditorView.contentAttributes.from(f, state => state.attrs) ]
    });
    function applyCompletion(view, option) {
        var apply = option.completion.apply || option.completion.label, result = view.state.field(completionState).active.find(a => a.source == option.source);
        return !1 && ("string" == typeof apply ? view.dispatch(Object.assign(Object.assign({}, function(state, text, from, to) {
            let main = state.selection["main"], fromOff = from - main.from, toOff = to - main.from;
            return Object.assign(Object.assign({}, state.changeByRange(range => {
                var lines;
                return range != main && from != to && state.sliceDoc(range.from + fromOff, range.from + toOff) != state.sliceDoc(from, to) ? {
                    range: range
                } : (lines = state.toText(text), {
                    changes: {
                        from: range.from + fromOff,
                        to: to == main.from ? range.to : range.from + toOff,
                        insert: lines
                    },
                    range: EditorSelection.cursor(range.from + fromOff + lines.length)
                });
            })), {
                scrollIntoView: !0,
                userEvent: "input.complete"
            });
        }(view.state, apply, result.from, result.to)), {
            annotations: pickedCompletion.of(option.completion)
        })) : apply(view, option.completion, result.from, result.to), !0);
    }
    const createTooltip = completionTooltip(completionState, applyCompletion);
    function moveCompletionSelection(forward, by = "option") {
        return view => {
            var cState = view.state.field(completionState, !1);
            if (!cState || !cState.open || cState.open.disabled || Date.now() - cState.open.timestamp < view.state.facet(completionConfig).interactionDelay) return !1;
            let step = 1, tooltip;
            "page" == by && (tooltip = function(view, tooltip) {
                return !(view = view.plugin(tooltipPlugin)) || (tooltip = view.manager.tooltips.indexOf(tooltip)) < 0 ? null : view.manager.tooltipViews[tooltip];
            }(view, cState.open.tooltip)) && (step = Math.max(2, Math.floor(tooltip.dom.offsetHeight / tooltip.dom.querySelector("li").offsetHeight) - 1));
            var length = cState.open.options["length"];
            let selected = -1 < cState.open.selected ? cState.open.selected + step * (forward ? 1 : -1) : forward ? 0 : length - 1;
            return selected < 0 ? selected = "page" == by ? 0 : length - 1 : selected >= length && (selected = "page" == by ? length - 1 : 0), 
            view.dispatch({
                effects: setSelectedEffect.of(selected)
            }), !0;
        };
    }
    selectDocStart = view => {
        return !!view.state.field(completionState, !1) && (view.dispatch({
            effects: startCompletionEffect.of(!0)
        }), !0);
    };
    const baseTheme = EditorView.baseTheme({
        ".cm-tooltip.cm-tooltip-autocomplete": {
            "& > ul": {
                fontFamily: "monospace",
                whiteSpace: "nowrap",
                overflow: "hidden auto",
                maxWidth_fallback: "700px",
                maxWidth: "min(700px, 95vw)",
                minWidth: "250px",
                maxHeight: "10em",
                height: "100%",
                listStyle: "none",
                margin: 0,
                padding: 0,
                "& > li, & > completion-section": {
                    padding: "1px 3px",
                    lineHeight: 1.2
                },
                "& > li": {
                    overflowX: "hidden",
                    textOverflow: "ellipsis",
                    cursor: "pointer"
                },
                "& > completion-section": {
                    display: "list-item",
                    borderBottom: "1px solid silver",
                    paddingLeft: "0.5em",
                    opacity: .7
                }
            }
        },
        "&light .cm-tooltip-autocomplete ul li[aria-selected]": {
            background: "#17c",
            color: "white"
        },
        "&light .cm-tooltip-autocomplete-disabled ul li[aria-selected]": {
            background: "#777"
        },
        "&dark .cm-tooltip-autocomplete ul li[aria-selected]": {
            background: "#347",
            color: "white"
        },
        "&dark .cm-tooltip-autocomplete-disabled ul li[aria-selected]": {
            background: "#444"
        },
        ".cm-completionListIncompleteTop:before, .cm-completionListIncompleteBottom:after": {
            content: '"\xb7\xb7\xb7"',
            opacity: .5,
            display: "block",
            textAlign: "center"
        },
        ".cm-tooltip.cm-completionInfo": {
            position: "absolute",
            padding: "3px 9px",
            width: "max-content",
            maxWidth: "400px",
            boxSizing: "border-box",
            whiteSpace: "pre-line"
        },
        ".cm-completionInfo.cm-completionInfo-left": {
            right: "100%"
        },
        ".cm-completionInfo.cm-completionInfo-right": {
            left: "100%"
        },
        ".cm-completionInfo.cm-completionInfo-left-narrow": {
            right: "30px"
        },
        ".cm-completionInfo.cm-completionInfo-right-narrow": {
            left: "30px"
        },
        "&light .cm-snippetField": {
            backgroundColor: "#00000022"
        },
        "&dark .cm-snippetField": {
            backgroundColor: "#ffffff22"
        },
        ".cm-snippetFieldPosition": {
            verticalAlign: "text-top",
            width: 0,
            height: "1.15em",
            display: "inline-block",
            margin: "0 -0.7px -.7em",
            borderLeft: "1.4px dotted #888"
        },
        ".cm-completionMatchedText": {
            textDecoration: "underline"
        },
        ".cm-completionDetail": {
            marginLeft: "0.5em",
            fontStyle: "italic"
        },
        ".cm-completionIcon": {
            fontSize: "90%",
            width: ".8em",
            display: "inline-block",
            textAlign: "center",
            paddingRight: ".6em",
            opacity: "0.6",
            boxSizing: "content-box"
        },
        ".cm-completionIcon-function, .cm-completionIcon-method": {
            "&:after": {
                content: "'\u0192'"
            }
        },
        ".cm-completionIcon-class": {
            "&:after": {
                content: "'\u25cb'"
            }
        },
        ".cm-completionIcon-interface": {
            "&:after": {
                content: "'\u25cc'"
            }
        },
        ".cm-completionIcon-variable": {
            "&:after": {
                content: "'\ud835\udc65'"
            }
        },
        ".cm-completionIcon-constant": {
            "&:after": {
                content: "'\ud835\udc36'"
            }
        },
        ".cm-completionIcon-type": {
            "&:after": {
                content: "'\ud835\udc61'"
            }
        },
        ".cm-completionIcon-enum": {
            "&:after": {
                content: "'\u222a'"
            }
        },
        ".cm-completionIcon-property": {
            "&:after": {
                content: "'\u25a1'"
            }
        },
        ".cm-completionIcon-keyword": {
            "&:after": {
                content: "'\ud83d\udd11\ufe0e'"
            }
        },
        ".cm-completionIcon-namespace": {
            "&:after": {
                content: "'\u25a2'"
            }
        },
        ".cm-completionIcon-text": {
            "&:after": {
                content: "'abc'",
                fontSize: "50%",
                verticalAlign: "middle"
            }
        }
    });
    class FieldPos {
        constructor(field, line, from, to) {
            this.field = field, this.line = line, this.from = from, this.to = to;
        }
    }
    class FieldRange {
        constructor(field, from, to) {
            this.field = field, this.from = from, this.to = to;
        }
        map(changes) {
            var from = changes.mapPos(this.from, -1, MapMode.TrackDel), changes = changes.mapPos(this.to, 1, MapMode.TrackDel);
            return null == from || null == changes ? null : new FieldRange(this.field, from, changes);
        }
    }
    class Snippet {
        constructor(lines, fieldPositions) {
            this.lines = lines, this.fieldPositions = fieldPositions;
        }
        instantiate(state, pos) {
            let text = [], lineStart = [ pos ];
            var line, lineObj = state.doc.lineAt(pos), baseIndent = /^\s*/.exec(lineObj.text)[0];
            for (line of this.lines) {
                if (text.length) {
                    let indent = baseIndent, tabs = /^\t*/.exec(line)[0].length;
                    for (let i = 0; i < tabs; i++) indent += state.facet(indentUnit);
                    lineStart.push(pos + indent.length - tabs), line = indent + line.slice(tabs);
                }
                text.push(line), pos += line.length + 1;
            }
            lineObj = this.fieldPositions.map(pos => new FieldRange(pos.field, lineStart[pos.line] + pos.from, lineStart[pos.line] + pos.to));
            return {
                text: text,
                ranges: lineObj
            };
        }
        static parse(template) {
            var line, fields = [];
            let lines = [], positions = [], m;
            for (line of template.split(/\r\n?|\n/)) {
                for (;m = /[#$]\{(?:(\d+)(?::([^}]*))?|((?:\\[{}]|[^}])*))\}/.exec(line); ) {
                    let seq = m[1] ? +m[1] : null, rawName = m[2] || m[3] || "", found = -1;
                    var name = rawName.replace(/\\[{}]/g, m => m[1]);
                    for (let i = 0; i < fields.length; i++) (null != seq ? fields[i].seq == seq : name && fields[i].name == name) && (found = i);
                    if (found < 0) {
                        let i = 0;
                        for (;i < fields.length && (null == seq || null != fields[i].seq && fields[i].seq < seq); ) i++;
                        fields.splice(i, 0, {
                            seq: seq,
                            name: name
                        }), found = i;
                        for (var pos of positions) pos.field >= found && pos.field++;
                    }
                    positions.push(new FieldPos(found, lines.length, m.index, m.index + name.length)), 
                    line = line.slice(0, m.index) + rawName + line.slice(m.index + m[0].length);
                }
                line = line.replace(/\\([{}])/g, (_, brace, index) => {
                    for (var pos of positions) pos.line == lines.length && pos.from > index && (pos.from--, 
                    pos.to--);
                    return brace;
                }), lines.push(line);
            }
            return new Snippet(lines, positions);
        }
    }
    let fieldMarker = Decoration.widget({
        widget: new class extends WidgetType {
            toDOM() {
                var span = document.createElement("span");
                return span.className = "cm-snippetFieldPosition", span;
            }
            ignoreEvent() {
                return !1;
            }
        }()
    }), fieldRange = Decoration.mark({
        class: "cm-snippetField"
    });
    class ActiveSnippet {
        constructor(ranges, active) {
            this.ranges = ranges, this.active = active, this.deco = Decoration.set(ranges.map(r => (r.from == r.to ? fieldMarker : fieldRange).range(r.from, r.to)));
        }
        map(changes) {
            var r, ranges = [];
            for (r of this.ranges) {
                var mapped = r.map(changes);
                if (!mapped) return null;
                ranges.push(mapped);
            }
            return new ActiveSnippet(ranges, this.active);
        }
        selectionInsideField(sel) {
            return sel.ranges.every(range => this.ranges.some(r => r.field == this.active && r.from <= range.from && r.to >= range.to));
        }
    }
    const setActive = StateEffect.define({
        map(value, changes) {
            return value && value.map(changes);
        }
    }), moveToField = StateEffect.define(), snippetState = StateField.define({
        create() {
            return null;
        },
        update(value, tr) {
            for (var effect of tr.effects) {
                if (effect.is(setActive)) return effect.value;
                if (effect.is(moveToField) && value) return new ActiveSnippet(value.ranges, effect.value);
            }
            return value = (value = value && tr.docChanged ? value.map(tr.changes) : value) && tr.selection && !value.selectionInsideField(tr.selection) ? null : value;
        },
        provide: f => EditorView.decorations.from(f, val => val ? val.deco : Decoration.none)
    });
    function fieldSelection(ranges, field) {
        return EditorSelection.create(ranges.filter(r => r.field == field).map(r => EditorSelection.range(r.from, r.to)));
    }
    function moveField(dir) {
        return ({
            state,
            dispatch
        }) => {
            var active = state.field(snippetState, !1);
            if (!active || dir < 0 && 0 == active.active) return !1;
            let next = active.active + dir, last = 0 < dir && !active.ranges.some(r => r.field == next + dir);
            return dispatch(state.update({
                selection: fieldSelection(active.ranges, next),
                effects: setActive.of(last ? null : new ActiveSnippet(active.ranges, next)),
                scrollIntoView: !0
            })), !0;
        };
    }
    const defaultSnippetKeymap = [ {
        key: "Tab",
        run: moveField(1),
        shift: moveField(-1)
    }, {
        key: "Escape",
        run: ({
            state,
            dispatch
        }) => {
            return !!state.field(snippetState, !1) && (dispatch(state.update({
                effects: setActive.of(null)
            })), !0);
        }
    } ], snippetKeymap = Facet.define({
        combine(maps) {
            return maps.length ? maps[0] : defaultSnippetKeymap;
        }
    }), addSnippetKeymap = Prec.highest(keymap.compute([ snippetKeymap ], state => state.facet(snippetKeymap)));
    function snippetCompletion(template, completion) {
        return Object.assign(Object.assign({}, completion), {
            apply: function(template) {
                let snippet = Snippet.parse(template);
                return (editor, completion, from, to) => {
                    var {
                        text,
                        ranges
                    } = snippet.instantiate(editor.state, from), main = editor.state.selection["main"], from = {
                        changes: {
                            from: from,
                            to: to == main.from ? main.to : to,
                            insert: Text.of(text)
                        },
                        scrollIntoView: !0,
                        annotations: completion ? [ pickedCompletion.of(completion), Transaction.userEvent.of("input.complete") ] : void 0
                    };
                    ranges.length && (from.selection = fieldSelection(ranges, 0)), 
                    ranges.some(r => 0 < r.field) && (main = new ActiveSnippet(ranges, 0), 
                    to = from.effects = [ setActive.of(main) ], void 0 === editor.state.field(snippetState, !1)) && to.push(StateEffect.appendConfig.of([ snippetState, addSnippetKeymap, snippetPointerHandler, baseTheme ])), 
                    editor.dispatch(editor.state.update(from));
                };
            }(template)
        });
    }
    const snippetPointerHandler = EditorView.domEventHandlers({
        mousedown(event, view) {
            let active = view.state.field(snippetState, !1), pos;
            if (!active || null == (pos = view.posAtCoords({
                x: event.clientX,
                y: event.clientY
            }))) return !1;
            let match = active.ranges.find(r => r.from <= pos && r.to >= pos);
            return !(!match || match.field == active.active || (view.dispatch({
                selection: fieldSelection(active.ranges, match.field),
                effects: setActive.of(active.ranges.some(r => r.field > match.field) ? new ActiveSnippet(active.ranges, match.field) : null),
                scrollIntoView: !0
            }), 0));
        }
    });
    cursorDocEnd = new class extends RangeValue {}();
    cursorDocEnd.startSide = 1;
    const completionKeymap = [ {
        key: "Ctrl-Space",
        run: selectDocStart
    }, {
        mac: "Alt-`",
        run: selectDocStart
    }, {
        key: "Escape",
        run: view => {
            var cState = view.state.field(completionState, !1);
            return !(!cState || !cState.active.some(a => 0 != a.state) || (view.dispatch({
                effects: closeCompletionEffect.of(null)
            }), 0));
        }
    }, {
        key: "ArrowDown",
        run: moveCompletionSelection(!0)
    }, {
        key: "ArrowUp",
        run: moveCompletionSelection(!(cursorDocEnd.endSide = -1))
    }, {
        key: "PageDown",
        run: moveCompletionSelection(!0, "page")
    }, {
        key: "PageUp",
        run: moveCompletionSelection(!1, "page")
    }, {
        key: "Enter",
        run: view => {
            var cState = view.state.field(completionState, !1);
            return !(view.state.readOnly || !cState || !cState.open || cState.open.selected < 0 || cState.open.disabled || Date.now() - cState.open.timestamp < view.state.facet(completionConfig).interactionDelay) && applyCompletion(view, cState.open.options[cState.open.selected]);
        }
    } ];
    class Stack {
        constructor(p, stack, state, reducePos, pos, score, buffer, bufferBase, curContext, lookAhead = 0, parent) {
            this.p = p, this.stack = stack, this.state = state, this.reducePos = reducePos, 
            this.pos = pos, this.score = score, this.buffer = buffer, this.bufferBase = bufferBase, 
            this.curContext = curContext, this.lookAhead = lookAhead, this.parent = parent;
        }
        toString() {
            return `[${this.stack.filter((_, i) => i % 3 == 0).concat(this.state)}]@` + this.pos + (this.score ? "!" + this.score : "");
        }
        static start(p, state, pos = 0) {
            var cx = p.parser.context;
            return new Stack(p, [], state, pos, pos, 0, [], 0, cx ? new StackContext(cx, cx.start) : null, 0, null);
        }
        get context() {
            return this.curContext ? this.curContext.context : null;
        }
        pushState(state, start) {
            this.stack.push(this.state, start, this.bufferBase + this.buffer.length), 
            this.state = state;
        }
        reduce(action) {
            var depth = action >> 19, type = 65535 & action, parser = this.p["parser"], lookaheadRecord = this.reducePos < this.pos - 25, dPrec = (lookaheadRecord && this.setLookAhead(this.pos), 
            parser.dynamicPrecedence(type));
            if (dPrec && (this.score += dPrec), 0 == depth) this.pushState(parser.getGoto(this.state, type, !0), this.reducePos), 
            type < parser.minRepeatTerm && this.storeNode(type, this.reducePos, this.reducePos, lookaheadRecord ? 8 : 4, !0), 
            this.reduceContext(type, this.reducePos); else {
                var base = this.stack.length - 3 * (depth - 1) - (262144 & action ? 6 : 0), dPrec = base ? this.stack[base - 2] : this.p.ranges[0].from, lookaheadRecord = this.reducePos - dPrec, depth = (2e3 <= lookaheadRecord && (null == (depth = this.p.parser.nodeSet.types[type]) || !depth.isAnonymous) && (dPrec == this.p.lastBigReductionStart ? (this.p.bigReductionCount++, 
                this.p.lastBigReductionSize = lookaheadRecord) : this.p.lastBigReductionSize < lookaheadRecord && (this.p.bigReductionCount = 1, 
                this.p.lastBigReductionStart = dPrec, this.p.lastBigReductionSize = lookaheadRecord)), 
                base ? this.stack[base - 1] : 0), lookaheadRecord = this.bufferBase + this.buffer.length - depth;
                for ((type < parser.minRepeatTerm || 131072 & action) && (depth = parser.stateFlag(this.state, 1) ? this.pos : this.reducePos, 
                this.storeNode(type, dPrec, depth, 4 + lookaheadRecord, !0)), 262144 & action ? this.state = this.stack[base] : (depth = this.stack[base - 3], 
                this.state = parser.getGoto(depth, type, !0)); this.stack.length > base; ) this.stack.pop();
                this.reduceContext(type, dPrec);
            }
        }
        storeNode(term, start, end, size = 4, mustSink = !1) {
            if (0 == term && (!this.stack.length || this.stack[this.stack.length - 1] < this.buffer.length + this.bufferBase)) {
                let cur = this, top = this.buffer.length;
                if (0 == top && cur.parent && (top = cur.bufferBase - cur.parent.bufferBase, 
                cur = cur.parent), 0 < top && 0 == cur.buffer[top - 4] && -1 < cur.buffer[top - 1]) {
                    if (start == end) return;
                    if (cur.buffer[top - 2] >= start) return void (cur.buffer[top - 2] = end);
                }
            }
            if (mustSink && this.pos != end) {
                let index = this.buffer.length;
                if (0 < index && 0 != this.buffer[index - 4]) {
                    let mustMove = !1;
                    for (let scan = index; 0 < scan && this.buffer[scan - 2] > end; scan -= 4) if (0 <= this.buffer[scan - 1]) {
                        mustMove = !0;
                        break;
                    }
                    if (mustMove) for (;0 < index && this.buffer[index - 2] > end; ) this.buffer[index] = this.buffer[index - 4], 
                    this.buffer[index + 1] = this.buffer[index - 3], this.buffer[index + 2] = this.buffer[index - 2], 
                    this.buffer[index + 3] = this.buffer[index - 1], index -= 4, 
                    4 < size && (size -= 4);
                }
                this.buffer[index] = term, this.buffer[index + 1] = start, this.buffer[index + 2] = end, 
                this.buffer[index + 3] = size;
            } else this.buffer.push(term, start, end, size);
        }
        shift(action, type, start, end) {
            var parser;
            131072 & action ? this.pushState(65535 & action, this.pos) : 0 == (262144 & action) ? (action = action, 
            parser = this.p["parser"], (end > this.pos || type <= parser.maxNode) && (this.pos = end, 
            parser.stateFlag(action, 1) || (this.reducePos = end)), this.pushState(action, start), 
            this.shiftContext(type, start), type <= parser.maxNode && this.buffer.push(type, start, end, 4)) : (this.pos = end, 
            this.shiftContext(type, start), type <= this.p.parser.maxNode && this.buffer.push(type, start, end, 4));
        }
        apply(action, next, nextStart, nextEnd) {
            65536 & action ? this.reduce(action) : this.shift(action, next, nextStart, nextEnd);
        }
        useNode(value, next) {
            let index = this.p.reused.length - 1;
            (index < 0 || this.p.reused[index] != value) && (this.p.reused.push(value), 
            index++);
            var start = this.pos;
            this.reducePos = this.pos = start + value.length, this.pushState(next, start), 
            this.buffer.push(index, start, this.reducePos, -1), this.curContext && this.updateContext(this.curContext.tracker.reuse(this.curContext.context, value, this, this.p.stream.reset(this.pos - value.length)));
        }
        split() {
            let parent = this, off = parent.buffer.length;
            for (;0 < off && parent.buffer[off - 2] > parent.reducePos; ) off -= 4;
            for (var buffer = parent.buffer.slice(off), base = parent.bufferBase + off; parent && base == parent.bufferBase; ) parent = parent.parent;
            return new Stack(this.p, this.stack.slice(), this.state, this.reducePos, this.pos, this.score, buffer, base, this.curContext, this.lookAhead, parent);
        }
        recoverByDelete(next, nextEnd) {
            var isNode = next <= this.p.parser.maxNode;
            isNode && this.storeNode(next, this.pos, nextEnd, 4), this.storeNode(0, this.pos, nextEnd, isNode ? 8 : 4), 
            this.pos = this.reducePos = nextEnd, this.score -= 190;
        }
        canShift(term) {
            for (var sim = new SimulatedStack(this); ;) {
                var action = this.p.parser.stateSlot(sim.state, 4) || this.p.parser.hasAction(sim.state, term);
                if (0 == action) return !1;
                if (0 == (65536 & action)) return !0;
                sim.reduce(action);
            }
        }
        recoverByInsert(next) {
            if (300 <= this.stack.length) return [];
            let nextStates = this.p.parser.nextStates(this.state);
            if (8 < nextStates.length || 120 <= this.stack.length) {
                var best = [];
                for (let i = 0, s; i < nextStates.length; i += 2) (s = nextStates[i + 1]) != this.state && this.p.parser.hasAction(s, next) && best.push(nextStates[i], s);
                if (this.stack.length < 120) for (let i = 0; best.length < 8 && i < nextStates.length; i += 2) {
                    let s = nextStates[i + 1];
                    best.some((v, i) => 1 & i && v == s) || best.push(nextStates[i], s);
                }
                nextStates = best;
            }
            var result = [];
            for (let i = 0; i < nextStates.length && result.length < 4; i += 2) {
                var stack, s = nextStates[i + 1];
                s != this.state && ((stack = this.split()).pushState(s, this.pos), 
                stack.storeNode(0, stack.pos, stack.pos, 4, !0), stack.shiftContext(nextStates[i], this.pos), 
                stack.reducePos = this.pos, stack.score -= 200, result.push(stack));
            }
            return result;
        }
        forceReduce() {
            var parser = this.p["parser"];
            let reduce = parser.stateSlot(this.state, 5);
            if (0 == (65536 & reduce)) return !1;
            if (!parser.validAction(this.state, reduce)) {
                var depth = reduce >> 19, term = 65535 & reduce, depth = this.stack.length - 3 * depth;
                if (depth < 0 || parser.getGoto(this.stack[depth], term, !1) < 0) {
                    parser = this.findForcedReduction();
                    if (null == parser) return !1;
                    reduce = parser;
                }
                this.storeNode(0, this.pos, this.pos, 4, !0), this.score -= 100;
            }
            return this.reducePos = this.pos, this.reduce(reduce), !0;
        }
        findForcedReduction() {
            let parser = this.p["parser"], seen = [], explore = (state, depth) => {
                if (!seen.includes(state)) return seen.push(state), parser.allActions(state, action => {
                    if (!(393216 & action)) if (65536 & action) {
                        var rDepth = (action >> 19) - depth;
                        if (1 < rDepth) {
                            var term = 65535 & action, target = this.stack.length - 3 * rDepth;
                            if (0 <= target && 0 <= parser.getGoto(this.stack[target], term, !1)) return rDepth << 19 | 65536 | term;
                        }
                    } else {
                        target = explore(action, depth + 1);
                        if (null != target) return target;
                    }
                });
            };
            return explore(this.state, 0);
        }
        forceAll() {
            for (;!this.p.parser.stateFlag(this.state, 2); ) if (!this.forceReduce()) {
                this.storeNode(0, this.pos, this.pos, 4, !0);
                break;
            }
            return this;
        }
        get deadEnd() {
            var parser;
            return 3 == this.stack.length && (parser = this.p.parser, 65535 == parser.data[parser.stateSlot(this.state, 1)]) && !parser.stateSlot(this.state, 4);
        }
        restart() {
            this.storeNode(0, this.pos, this.pos, 4, !0), this.state = this.stack[0], 
            this.stack.length = 0;
        }
        sameState(other) {
            if (this.state != other.state || this.stack.length != other.stack.length) return !1;
            for (let i = 0; i < this.stack.length; i += 3) if (this.stack[i] != other.stack[i]) return !1;
            return !0;
        }
        get parser() {
            return this.p.parser;
        }
        dialectEnabled(dialectID) {
            return this.p.parser.dialect.flags[dialectID];
        }
        shiftContext(term, start) {
            this.curContext && this.updateContext(this.curContext.tracker.shift(this.curContext.context, term, this, this.p.stream.reset(start)));
        }
        reduceContext(term, start) {
            this.curContext && this.updateContext(this.curContext.tracker.reduce(this.curContext.context, term, this, this.p.stream.reset(start)));
        }
        emitContext() {
            var last = this.buffer.length - 1;
            (last < 0 || -3 != this.buffer[last]) && this.buffer.push(this.curContext.hash, this.pos, this.pos, -3);
        }
        emitLookAhead() {
            var last = this.buffer.length - 1;
            (last < 0 || -4 != this.buffer[last]) && this.buffer.push(this.lookAhead, this.pos, this.pos, -4);
        }
        updateContext(context) {
            context != this.curContext.context && ((context = new StackContext(this.curContext.tracker, context)).hash != this.curContext.hash && this.emitContext(), 
            this.curContext = context);
        }
        setLookAhead(lookAhead) {
            lookAhead > this.lookAhead && (this.emitLookAhead(), this.lookAhead = lookAhead);
        }
        close() {
            this.curContext && this.curContext.tracker.strict && this.emitContext(), 
            0 < this.lookAhead && this.emitLookAhead();
        }
    }
    class StackContext {
        constructor(tracker, context) {
            this.tracker = tracker, this.context = context, this.hash = tracker.strict ? tracker.hash(context) : 0;
        }
    }
    class SimulatedStack {
        constructor(start) {
            this.start = start, this.state = start.state, this.stack = start.stack, 
            this.base = this.stack.length;
        }
        reduce(action) {
            var term = 65535 & action, action = action >> 19, action = (0 == action ? (this.stack == this.start.stack && (this.stack = this.stack.slice()), 
            this.stack.push(this.state, 0, 0), this.base += 3) : this.base -= 3 * (action - 1), 
            this.start.p.parser.getGoto(this.stack[this.base - 3], term, !0));
            this.state = action;
        }
    }
    class StackBufferCursor {
        constructor(stack, pos, index) {
            this.stack = stack, this.pos = pos, this.index = index, this.buffer = stack.buffer, 
            0 == this.index && this.maybeNext();
        }
        static create(stack, pos = stack.bufferBase + stack.buffer.length) {
            return new StackBufferCursor(stack, pos, pos - stack.bufferBase);
        }
        maybeNext() {
            var next = this.stack.parent;
            null != next && (this.index = this.stack.bufferBase - next.bufferBase, 
            this.stack = next, this.buffer = next.buffer);
        }
        get id() {
            return this.buffer[this.index - 4];
        }
        get start() {
            return this.buffer[this.index - 3];
        }
        get end() {
            return this.buffer[this.index - 2];
        }
        get size() {
            return this.buffer[this.index - 1];
        }
        next() {
            this.index -= 4, this.pos -= 4, 0 == this.index && this.maybeNext();
        }
        fork() {
            return new StackBufferCursor(this.stack, this.pos, this.index);
        }
    }
    function decodeArray(input, Type = Uint16Array) {
        if ("string" != typeof input) return input;
        let array = null;
        for (let pos = 0, out = 0; pos < input.length; ) {
            let value = 0;
            for (;;) {
                let next = input.charCodeAt(pos++), stop = !1;
                if (126 == next) {
                    value = 65535;
                    break;
                }
                92 <= next && next--, 34 <= next && next--;
                let digit = next - 32;
                if (46 <= digit && (digit -= 46, stop = !0), value += digit, stop) break;
                value *= 46;
            }
            array ? array[out++] = value : array = new Type(value);
        }
        return array;
    }
    class CachedToken {
        constructor() {
            this.start = -1, this.value = -1, this.end = -1, this.extended = -1, 
            this.lookAhead = 0, this.mask = 0, this.context = 0;
        }
    }
    const nullToken = new CachedToken();
    class InputStream {
        constructor(input, ranges) {
            this.input = input, this.ranges = ranges, this.chunk = "", this.chunkOff = 0, 
            this.chunk2 = "", this.chunk2Pos = 0, this.next = -1, this.token = nullToken, 
            this.rangeIndex = 0, this.pos = this.chunkPos = ranges[0].from, this.range = ranges[0], 
            this.end = ranges[ranges.length - 1].to, this.readNext();
        }
        resolveOffset(offset, assoc) {
            let range = this.range, index = this.rangeIndex, pos = this.pos + offset;
            for (;pos < range.from; ) {
                if (!index) return null;
                var next = this.ranges[--index];
                pos -= range.from - next.to, range = next;
            }
            for (;assoc < 0 ? pos > range.to : pos >= range.to; ) {
                if (index == this.ranges.length - 1) return null;
                let next = this.ranges[++index];
                pos += next.from - range.to, range = next;
            }
            return pos;
        }
        clipPos(pos) {
            if (pos >= this.range.from && pos < this.range.to) return pos;
            for (var range of this.ranges) if (range.to > pos) return Math.max(pos, range.from);
            return this.end;
        }
        peek(offset) {
            let idx = this.chunkOff + offset, pos, result;
            if (0 <= idx && idx < this.chunk.length) pos = this.pos + offset, result = this.chunk.charCodeAt(idx); else {
                offset = this.resolveOffset(offset, 1);
                if (null == offset) return -1;
                if ((pos = offset) >= this.chunk2Pos && pos < this.chunk2Pos + this.chunk2.length) result = this.chunk2.charCodeAt(pos - this.chunk2Pos); else {
                    let i = this.rangeIndex, range = this.range;
                    for (;range.to <= pos; ) range = this.ranges[++i];
                    this.chunk2 = this.input.chunk(this.chunk2Pos = pos), pos + this.chunk2.length > range.to && (this.chunk2 = this.chunk2.slice(0, range.to - pos)), 
                    result = this.chunk2.charCodeAt(0);
                }
            }
            return pos >= this.token.lookAhead && (this.token.lookAhead = pos + 1), 
            result;
        }
        acceptToken(token, endOffset = 0) {
            endOffset = endOffset ? this.resolveOffset(endOffset, -1) : this.pos;
            if (null == endOffset || endOffset < this.token.start) throw new RangeError("Token end out of bounds");
            this.token.value = token, this.token.end = endOffset;
        }
        acceptTokenTo(token, endPos) {
            this.token.value = token, this.token.end = endPos;
        }
        getChunk() {
            var chunk, chunkPos;
            this.pos >= this.chunk2Pos && this.pos < this.chunk2Pos + this.chunk2.length ? ({
                chunk,
                chunkPos
            } = this, this.chunk = this.chunk2, this.chunkPos = this.chunk2Pos, 
            this.chunk2 = chunk, this.chunk2Pos = chunkPos, this.chunkOff = this.pos - this.chunkPos) : (this.chunk2 = this.chunk, 
            this.chunk2Pos = this.chunkPos, chunk = this.input.chunk(this.pos), 
            chunkPos = this.pos + chunk.length, this.chunk = chunkPos > this.range.to ? chunk.slice(0, this.range.to - this.pos) : chunk, 
            this.chunkPos = this.pos, this.chunkOff = 0);
        }
        readNext() {
            return this.chunkOff >= this.chunk.length && (this.getChunk(), this.chunkOff == this.chunk.length) ? this.next = -1 : this.next = this.chunk.charCodeAt(this.chunkOff);
        }
        advance(n = 1) {
            for (this.chunkOff += n; this.pos + n >= this.range.to; ) {
                if (this.rangeIndex == this.ranges.length - 1) return this.setDone();
                n -= this.range.to - this.pos, this.range = this.ranges[++this.rangeIndex], 
                this.pos = this.range.from;
            }
            return this.pos += n, this.pos >= this.token.lookAhead && (this.token.lookAhead = this.pos + 1), 
            this.readNext();
        }
        setDone() {
            return this.pos = this.chunkPos = this.end, this.range = this.ranges[this.rangeIndex = this.ranges.length - 1], 
            this.chunk = "", this.next = -1;
        }
        reset(pos, token) {
            if (token ? ((this.token = token).start = pos, token.lookAhead = pos + 1, 
            token.value = token.extended = -1) : this.token = nullToken, this.pos != pos) {
                if ((this.pos = pos) == this.end) return this.setDone(), this;
                for (;pos < this.range.from; ) this.range = this.ranges[--this.rangeIndex];
                for (;pos >= this.range.to; ) this.range = this.ranges[++this.rangeIndex];
                pos >= this.chunkPos && pos < this.chunkPos + this.chunk.length ? this.chunkOff = pos - this.chunkPos : (this.chunk = "", 
                this.chunkOff = 0), this.readNext();
            }
            return this;
        }
        read(from, to) {
            if (from >= this.chunkPos && to <= this.chunkPos + this.chunk.length) return this.chunk.slice(from - this.chunkPos, to - this.chunkPos);
            if (from >= this.chunk2Pos && to <= this.chunk2Pos + this.chunk2.length) return this.chunk2.slice(from - this.chunk2Pos, to - this.chunk2Pos);
            if (from >= this.range.from && to <= this.range.to) return this.input.read(from, to);
            let result = "";
            for (var r of this.ranges) {
                if (r.from >= to) break;
                r.to > from && (result += this.input.read(Math.max(r.from, from), Math.min(r.to, to)));
            }
            return result;
        }
    }
    class TokenGroup {
        constructor(data, id) {
            this.data = data, this.id = id;
        }
        token(input, stack) {
            var parser = stack.p["parser"];
            readToken(this.data, input, stack, this.id, parser.data, parser.tokenPrecTable);
        }
    }
    TokenGroup.prototype.contextual = TokenGroup.prototype.fallback = TokenGroup.prototype.extend = !1;
    class LocalTokenGroup {
        constructor(data, precTable, elseToken) {
            this.precTable = precTable, this.elseToken = elseToken, this.data = "string" == typeof data ? decodeArray(data) : data;
        }
        token(input, stack) {
            let start = input.pos, skipped = 0;
            for (;;) {
                var atEof = input.next < 0, nextPos = input.resolveOffset(1, 1);
                if (readToken(this.data, input, stack, 0, this.data, this.precTable), 
                -1 < input.token.value) break;
                if (null == this.elseToken) return;
                if (atEof || skipped++, null == nextPos) break;
                input.reset(nextPos, input.token);
            }
            skipped && (input.reset(start, input.token), input.acceptToken(this.elseToken, skipped));
        }
    }
    LocalTokenGroup.prototype.contextual = TokenGroup.prototype.fallback = TokenGroup.prototype.extend = !1;
    class ExternalTokenizer {
        constructor(token, options = {}) {
            this.token = token, this.contextual = !!options.contextual, this.fallback = !!options.fallback, 
            this.extend = !!options.extend;
        }
    }
    function readToken(data, input, stack, group, precTable, precOffset) {
        let state = 0, groupMask = 1 << group, dialect = stack.p.parser["dialect"];
        scan: for (;0 != (groupMask & data[state]); ) {
            var accEnd = data[state + 1];
            for (let i = state + 3; i < accEnd; i += 2) if (0 < (data[i + 1] & groupMask)) {
                var term = data[i];
                if (dialect.allows(term) && (-1 == input.token.value || input.token.value == term || function(token, prev, tableData, tableOffset) {
                    prev = findOffset(tableData, tableOffset, prev);
                    return prev < 0 || findOffset(tableData, tableOffset, token) < prev;
                }(term, input.token.value, precTable, precOffset))) {
                    input.acceptToken(term);
                    break;
                }
            }
            let next = input.next, low = 0, high = data[state + 2];
            if (!(input.next < 0 && high > low && 65535 == data[accEnd + 3 * high - 3])) {
                for (;low < high; ) {
                    var mid = low + high >> 1, index = accEnd + mid + (mid << 1), from = data[index], to = data[index + 1] || 65536;
                    if (next < from) high = mid; else {
                        if (!(to <= next)) {
                            state = data[index + 2], input.advance();
                            continue scan;
                        }
                        low = 1 + mid;
                    }
                }
                break;
            }
            state = data[accEnd + 3 * high - 1];
        }
    }
    function findOffset(data, start, term) {
        for (let i = start, next; 65535 != (next = data[i]); i++) if (next == term) return i - start;
        return -1;
    }
    const verbose = "undefined" != typeof process && process.env && /\bparse\b/.test(process.env.LOG);
    let stackIDs = null;
    function cutAt(tree, pos, side) {
        var cursor = tree.cursor(IterMode.IncludeAnonymous);
        for (cursor.moveTo(pos); ;) if (!(side < 0 ? cursor.childBefore(pos) : cursor.childAfter(pos))) for (;;) {
            if ((side < 0 ? cursor.to < pos : cursor.from > pos) && !cursor.type.isError) return side < 0 ? Math.max(0, Math.min(cursor.to - 1, pos - 25)) : Math.min(tree.length, Math.max(cursor.from + 1, pos + 25));
            if (side < 0 ? cursor.prevSibling() : cursor.nextSibling()) break;
            if (!cursor.parent()) return side < 0 ? 0 : tree.length;
        }
    }
    let FragmentCursor$1 = class {
        constructor(fragments, nodeSet) {
            this.fragments = fragments, this.nodeSet = nodeSet, this.i = 0, this.fragment = null, 
            this.safeFrom = -1, this.safeTo = -1, this.trees = [], this.start = [], 
            this.index = [], this.nextFragment();
        }
        nextFragment() {
            var fr = this.fragment = this.i == this.fragments.length ? null : this.fragments[this.i++];
            if (fr) {
                for (this.safeFrom = fr.openStart ? cutAt(fr.tree, fr.from + fr.offset, 1) - fr.offset : fr.from, 
                this.safeTo = fr.openEnd ? cutAt(fr.tree, fr.to + fr.offset, -1) - fr.offset : fr.to; this.trees.length; ) this.trees.pop(), 
                this.start.pop(), this.index.pop();
                this.trees.push(fr.tree), this.start.push(-fr.offset), this.index.push(0), 
                this.nextStart = this.safeFrom;
            } else this.nextStart = 1e9;
        }
        nodeAt(pos) {
            if (pos < this.nextStart) return null;
            for (;this.fragment && this.safeTo <= pos; ) this.nextFragment();
            if (!this.fragment) return null;
            for (;;) {
                var last = this.trees.length - 1;
                if (last < 0) return this.nextFragment(), null;
                var top = this.trees[last], index = this.index[last];
                if (index == top.children.length) this.trees.pop(), this.start.pop(), 
                this.index.pop(); else {
                    var next = top.children[index], top = this.start[last] + top.positions[index];
                    if (pos < top) return this.nextStart = top, null;
                    if (next instanceof Tree) {
                        if (top == pos) {
                            if (top < this.safeFrom) return null;
                            index = top + next.length;
                            if (index <= this.safeTo) {
                                var lookAhead = next.prop(NodeProp.lookAhead);
                                if (!lookAhead || index + lookAhead < this.fragment.to) return next;
                            }
                        }
                        this.index[last]++, top + next.length >= Math.max(this.safeFrom, pos) && (this.trees.push(next), 
                        this.start.push(top), this.index.push(0));
                    } else this.index[last]++, this.nextStart = top + next.length;
                }
            }
        }
    };
    class TokenCache {
        constructor(parser, stream) {
            this.stream = stream, this.tokens = [], this.mainToken = null, this.actions = [], 
            this.tokens = parser.tokenizers.map(_ => new CachedToken());
        }
        getActions(stack) {
            let actionIndex = 0, main = null;
            var parser = stack.p["parser"], tokenizers = parser["tokenizers"], mask = parser.stateSlot(stack.state, 3), context = stack.curContext ? stack.curContext.hash : 0;
            let lookAhead = 0;
            for (let i = 0; i < tokenizers.length; i++) if (0 != (1 << i & mask)) {
                var tokenizer = tokenizers[i], token = this.tokens[i];
                if ((!main || tokenizer.fallback) && (!tokenizer.contextual && token.start == stack.pos && token.mask == mask && token.context == context || (this.updateCachedToken(token, tokenizer, stack), 
                token.mask = mask, token.context = context), token.lookAhead > token.end + 25 && (lookAhead = Math.max(token.lookAhead, lookAhead)), 
                0 != token.value)) {
                    var startIndex = actionIndex;
                    if (-1 < token.extended && (actionIndex = this.addActions(stack, token.extended, token.end, actionIndex)), 
                    actionIndex = this.addActions(stack, token.value, token.end, actionIndex), 
                    !tokenizer.extend && (main = token, actionIndex > startIndex)) break;
                }
            }
            for (;this.actions.length > actionIndex; ) this.actions.pop();
            return lookAhead && stack.setLookAhead(lookAhead), main || stack.pos != this.stream.end || ((main = new CachedToken()).value = stack.p.parser.eofTerm, 
            main.start = main.end = stack.pos, actionIndex = this.addActions(stack, main.value, main.end, actionIndex)), 
            this.mainToken = main, this.actions;
        }
        getMainToken(stack) {
            var main, p;
            return this.mainToken || ({
                pos: stack,
                p
            } = stack, (main = new CachedToken()).start = stack, main.end = Math.min(stack + 1, p.stream.end), 
            main.value = stack == p.stream.end ? p.parser.eofTerm : 0, main);
        }
        updateCachedToken(token, tokenizer, stack) {
            var start = this.stream.clipPos(stack.pos);
            if (tokenizer.token(this.stream.reset(start, token), stack), -1 < token.value) {
                var parser = stack.p["parser"];
                for (let i = 0; i < parser.specialized.length; i++) if (parser.specialized[i] == token.value) {
                    var result = parser.specializers[i](this.stream.read(token.start, token.end), stack);
                    if (0 <= result && stack.p.parser.dialect.allows(result >> 1)) {
                        0 == (1 & result) ? token.value = result >> 1 : token.extended = result >> 1;
                        break;
                    }
                }
            } else token.value = 0, token.end = this.stream.clipPos(start + 1);
        }
        putAction(action, token, end, index) {
            for (let i = 0; i < index; i += 3) if (this.actions[i] == action) return index;
            return this.actions[index++] = action, this.actions[index++] = token, 
            this.actions[index++] = end, index;
        }
        addActions(stack, token, end, index) {
            var state = stack["state"], parser = stack.p["parser"], data = parser["data"];
            for (let set = 0; set < 2; set++) for (let i = parser.stateSlot(state, set ? 2 : 1); ;i += 3) {
                if (65535 == data[i]) {
                    if (1 != data[i + 1]) {
                        0 == index && 2 == data[i + 1] && (index = this.putAction(pair(data, i + 2), token, end, index));
                        break;
                    }
                    i = pair(data, i + 2);
                }
                data[i] == token && (index = this.putAction(pair(data, i + 1), token, end, index));
            }
            return index;
        }
    }
    class Parse {
        constructor(parser, input, fragments, ranges) {
            this.parser = parser, this.input = input, this.ranges = ranges, this.recovering = 0, 
            this.nextStackID = 9812, this.minStackPos = 0, this.reused = [], this.stoppedAt = null, 
            this.lastBigReductionStart = -1, this.lastBigReductionSize = 0, this.bigReductionCount = 0, 
            this.stream = new InputStream(input, ranges), this.tokens = new TokenCache(parser, this.stream), 
            this.topTerm = parser.top[1];
            input = ranges[0].from;
            this.stacks = [ Stack.start(this, parser.top[0], input) ], this.fragments = fragments.length && this.stream.end - input > 4 * parser.bufferLength ? new FragmentCursor$1(fragments, parser.nodeSet) : null;
        }
        get parsedPos() {
            return this.minStackPos;
        }
        advance() {
            let stacks = this.stacks, pos = this.minStackPos;
            var newStacks = this.stacks = [];
            let stopped, stoppedTokens;
            if (300 < this.bigReductionCount && 1 == stacks.length) {
                for (var [ s ] = stacks; s.forceReduce() && s.stack.length && s.stack[s.stack.length - 2] >= this.lastBigReductionStart; );
                this.bigReductionCount = this.lastBigReductionSize = 0;
            }
            for (let i = 0; i < stacks.length; i++) for (var stack = stacks[i]; ;) {
                if (this.tokens.mainToken = null, stack.pos > pos) newStacks.push(stack); else {
                    if (this.advanceStack(stack, newStacks, stacks)) continue;
                    stopped || (stopped = [], stoppedTokens = []), stopped.push(stack);
                    var tok = this.tokens.getMainToken(stack);
                    stoppedTokens.push(tok.value, tok.end);
                }
                break;
            }
            if (!newStacks.length) {
                var finished = stopped && function(stacks) {
                    let best = null;
                    for (var stack of stacks) {
                        var stopped = stack.p.stoppedAt;
                        (stack.pos == stack.p.stream.end || null != stopped && stack.pos > stopped) && stack.p.parser.stateFlag(stack.state, 2) && (!best || best.score < stack.score) && (best = stack);
                    }
                    return best;
                }(stopped);
                if (finished) return verbose && console.log("Finish with " + this.stackID(finished)), 
                this.stackToTree(finished);
                if (this.parser.strict) throw verbose && stopped && console.log("Stuck with token " + (this.tokens.mainToken ? this.parser.getName(this.tokens.mainToken.value) : "none")), 
                new SyntaxError("No parse at " + pos);
                this.recovering || (this.recovering = 5);
            }
            if (this.recovering && stopped) {
                let finished = null != this.stoppedAt && stopped[0].pos > this.stoppedAt ? stopped[0] : this.runRecovery(stopped, stoppedTokens, newStacks);
                if (finished) return verbose && console.log("Force-finish " + this.stackID(finished)), 
                this.stackToTree(finished.forceAll());
            }
            if (this.recovering) {
                var maxRemaining = 1 == this.recovering ? 1 : 3 * this.recovering;
                if (newStacks.length > maxRemaining) for (newStacks.sort((a, b) => b.score - a.score); newStacks.length > maxRemaining; ) newStacks.pop();
                newStacks.some(s => s.reducePos > pos) && this.recovering--;
            } else if (1 < newStacks.length) {
                outer: for (let i = 0; i < newStacks.length - 1; i++) {
                    let stack = newStacks[i];
                    for (let j = i + 1; j < newStacks.length; j++) {
                        var other = newStacks[j];
                        if (stack.sameState(other) || 500 < stack.buffer.length && 500 < other.buffer.length) {
                            if (!(0 < (stack.score - other.score || stack.buffer.length - other.buffer.length))) {
                                newStacks.splice(i--, 1);
                                continue outer;
                            }
                            newStacks.splice(j--, 1);
                        }
                    }
                }
                12 < newStacks.length && newStacks.splice(12, newStacks.length - 12);
            }
            this.minStackPos = newStacks[0].pos;
            for (let i = 1; i < newStacks.length; i++) newStacks[i].pos < this.minStackPos && (this.minStackPos = newStacks[i].pos);
            return null;
        }
        stopAt(pos) {
            if (null != this.stoppedAt && this.stoppedAt < pos) throw new RangeError("Can't move stoppedAt forward");
            this.stoppedAt = pos;
        }
        advanceStack(stack, stacks, split) {
            var start = stack.pos, parser = this["parser"], base = verbose ? this.stackID(stack) + " -> " : "";
            if (null != this.stoppedAt && start > this.stoppedAt) return stack.forceReduce() ? stack : null;
            if (this.fragments) {
                var strictCx = stack.curContext && stack.curContext.tracker.strict, cxHash = strictCx ? stack.curContext.hash : 0;
                for (let cached = this.fragments.nodeAt(start); cached; ) {
                    var match = this.parser.nodeSet.types[cached.type.id] == cached.type ? parser.getGoto(stack.state, cached.type.id) : -1;
                    if (-1 < match && cached.length && (!strictCx || (cached.prop(NodeProp.contextHash) || 0) == cxHash)) return stack.useNode(cached, match), 
                    verbose && console.log(base + this.stackID(stack) + ` (via reuse of ${parser.getName(cached.type.id)})`), 
                    !0;
                    if (!(cached instanceof Tree) || 0 == cached.children.length || 0 < cached.positions[0]) break;
                    match = cached.children[0];
                    if (!(match instanceof Tree && 0 == cached.positions[0])) break;
                    cached = match;
                }
            }
            var defaultReduce = parser.stateSlot(stack.state, 4);
            if (0 < defaultReduce) return stack.reduce(defaultReduce), verbose && console.log(base + this.stackID(stack) + ` (via always-reduce ${parser.getName(65535 & defaultReduce)})`), 
            !0;
            if (8400 <= stack.stack.length) for (;6e3 < stack.stack.length && stack.forceReduce(); );
            var actions = this.tokens.getActions(stack);
            for (let i = 0; i < actions.length; ) {
                var action = actions[i++], term = actions[i++], end = actions[i++], last = i == actions.length || !split, localStack = last ? stack : stack.split(), main = this.tokens.mainToken;
                if (localStack.apply(action, term, main ? main.start : localStack.pos, end), 
                verbose && console.log(base + this.stackID(localStack) + ` (via ${0 == (65536 & action) ? "shift" : "reduce of " + parser.getName(65535 & action)} for ${parser.getName(term)} @ ${start}${localStack == stack ? "" : ", split"})`), 
                last) return !0;
                (localStack.pos > start ? stacks : split).push(localStack);
            }
            return !1;
        }
        advanceFully(stack, newStacks) {
            for (var pos = stack.pos; ;) {
                if (!this.advanceStack(stack, null, null)) return !1;
                if (stack.pos > pos) return pushStackDedup(stack, newStacks), !0;
            }
        }
        runRecovery(stacks, tokens, newStacks) {
            let finished = null, restarted = !1;
            for (let i = 0; i < stacks.length; i++) {
                let stack = stacks[i], token = tokens[i << 1], tokenEnd = tokens[1 + (i << 1)];
                var insert, base = verbose ? this.stackID(stack) + " -> " : "";
                if (stack.deadEnd) {
                    if (restarted) continue;
                    if (restarted = !0, stack.restart(), verbose && console.log(base + this.stackID(stack) + " (restarted)"), 
                    this.advanceFully(stack, newStacks)) continue;
                }
                let force = stack.split(), forceBase = base;
                for (let j = 0; force.forceReduce() && j < 10; j++) {
                    verbose && console.log(forceBase + this.stackID(force) + " (via force-reduce)");
                    let done = this.advanceFully(force, newStacks);
                    if (done) break;
                    verbose && (forceBase = this.stackID(force) + " -> ");
                }
                for (insert of stack.recoverByInsert(token)) verbose && console.log(base + this.stackID(insert) + " (via recover-insert)"), 
                this.advanceFully(insert, newStacks);
                this.stream.end > stack.pos ? (tokenEnd == stack.pos && (tokenEnd++, 
                token = 0), stack.recoverByDelete(token, tokenEnd), verbose && console.log(base + this.stackID(stack) + ` (via recover-delete ${this.parser.getName(token)})`), 
                pushStackDedup(stack, newStacks)) : (!finished || finished.score < stack.score) && (finished = stack);
            }
            return finished;
        }
        stackToTree(stack) {
            return stack.close(), Tree.build({
                buffer: StackBufferCursor.create(stack),
                nodeSet: this.parser.nodeSet,
                topID: this.topTerm,
                maxBufferLength: this.parser.bufferLength,
                reused: this.reused,
                start: this.ranges[0].from,
                length: stack.pos - this.ranges[0].from,
                minRepeatType: this.parser.minRepeatTerm
            });
        }
        stackID(stack) {
            let id = (stackIDs = stackIDs || new WeakMap()).get(stack);
            return id || stackIDs.set(stack, id = String.fromCodePoint(this.nextStackID++)), 
            id + stack;
        }
    }
    function pushStackDedup(stack, newStacks) {
        for (let i = 0; i < newStacks.length; i++) {
            var other = newStacks[i];
            if (other.pos == stack.pos && other.sameState(stack)) return void (newStacks[i].score < stack.score && (newStacks[i] = stack));
        }
        newStacks.push(stack);
    }
    class Dialect {
        constructor(source, flags, disabled) {
            this.source = source, this.flags = flags, this.disabled = disabled;
        }
        allows(term) {
            return !this.disabled || 0 == this.disabled[term];
        }
    }
    const id = x => x;
    class ContextTracker {
        constructor(spec) {
            this.start = spec.start, this.shift = spec.shift || id, this.reduce = spec.reduce || id, 
            this.reuse = spec.reuse || id, this.hash = spec.hash || (() => 0), this.strict = !1 !== spec.strict;
        }
    }
    class LRParser extends Parser {
        constructor(spec) {
            if (super(), this.wrappers = [], 14 != spec.version) throw new RangeError(`Parser version (${spec.version}) doesn't match runtime version (14)`);
            var nodeNames = spec.nodeNames.split(" ");
            this.minRepeatTerm = nodeNames.length;
            for (let i = 0; i < spec.repeatNodeCount; i++) nodeNames.push("");
            let topTerms = Object.keys(spec.topRules).map(r => spec.topRules[r][1]), nodeProps = [];
            for (let i = 0; i < nodeNames.length; i++) nodeProps.push([]);
            function setProp(nodeID, prop, value) {
                nodeProps[nodeID].push([ prop, prop.deserialize(String(value)) ]);
            }
            if (spec.nodeProps) for (var propSpec of spec.nodeProps) {
                let prop = propSpec[0];
                "string" == typeof prop && (prop = NodeProp[prop]);
                for (let i = 1; i < propSpec.length; ) {
                    var next = propSpec[i++];
                    if (0 <= next) setProp(next, prop, propSpec[i++]); else {
                        var value = propSpec[i + -next];
                        for (let j = -next; 0 < j; j--) setProp(propSpec[i++], prop, value);
                        i++;
                    }
                }
            }
            this.nodeSet = new NodeSet(nodeNames.map((name, i) => NodeType.define({
                name: i >= this.minRepeatTerm ? void 0 : name,
                id: i,
                props: nodeProps[i],
                top: -1 < topTerms.indexOf(i),
                error: 0 == i,
                skipped: spec.skippedNodes && -1 < spec.skippedNodes.indexOf(i)
            }))), spec.propSources && (this.nodeSet = this.nodeSet.extend(...spec.propSources)), 
            this.strict = !1, this.bufferLength = 1024;
            let tokenArray = decodeArray(spec.tokenData);
            this.context = spec.context, this.specializerSpecs = spec.specialized || [], 
            this.specialized = new Uint16Array(this.specializerSpecs.length);
            for (let i = 0; i < this.specializerSpecs.length; i++) this.specialized[i] = this.specializerSpecs[i].term;
            this.specializers = this.specializerSpecs.map(getSpecializer), this.states = decodeArray(spec.states, Uint32Array), 
            this.data = decodeArray(spec.stateData), this.goto = decodeArray(spec.goto), 
            this.maxTerm = spec.maxTerm, this.tokenizers = spec.tokenizers.map(value => "number" == typeof value ? new TokenGroup(tokenArray, value) : value), 
            this.topRules = spec.topRules, this.dialects = spec.dialects || {}, 
            this.dynamicPrecedences = spec.dynamicPrecedences || null, this.tokenPrecTable = spec.tokenPrec, 
            this.termNames = spec.termNames || null, this.maxNode = this.nodeSet.types.length - 1, 
            this.dialect = this.parseDialect(), this.top = this.topRules[Object.keys(this.topRules)[0]];
        }
        createParse(input, fragments, ranges) {
            let parse = new Parse(this, input, fragments, ranges);
            for (var w of this.wrappers) parse = w(parse, input, fragments, ranges);
            return parse;
        }
        getGoto(state, term, loose = !1) {
            var table = this.goto;
            if (term >= table[0]) return -1;
            for (let pos = table[term + 1]; ;) {
                var groupTag = table[pos++], last = 1 & groupTag, target = table[pos++];
                if (last && loose) return target;
                for (var end = pos + (groupTag >> 1); pos < end; pos++) if (table[pos] == state) return target;
                if (last) return -1;
            }
        }
        hasAction(state, terminal) {
            var data = this.data;
            for (let set = 0; set < 2; set++) for (let i = this.stateSlot(state, set ? 2 : 1), next; ;i += 3) {
                if (65535 == (next = data[i])) {
                    if (1 != data[i + 1]) {
                        if (2 == data[i + 1]) return pair(data, i + 2);
                        break;
                    }
                    next = data[i = pair(data, i + 2)];
                }
                if (next == terminal || 0 == next) return pair(data, i + 1);
            }
            return 0;
        }
        stateSlot(state, slot) {
            return this.states[6 * state + slot];
        }
        stateFlag(state, flag) {
            return 0 < (this.stateSlot(state, 0) & flag);
        }
        validAction(state, action) {
            return !!this.allActions(state, a => a == action || null);
        }
        allActions(state, action) {
            var deflt = this.stateSlot(state, 4);
            let result = deflt ? action(deflt) : void 0;
            for (let i = this.stateSlot(state, 1); null == result; i += 3) {
                if (65535 == this.data[i]) {
                    if (1 != this.data[i + 1]) break;
                    i = pair(this.data, i + 2);
                }
                result = action(pair(this.data, i + 1));
            }
            return result;
        }
        nextStates(state) {
            var result = [];
            for (let i = this.stateSlot(state, 1); ;i += 3) {
                if (65535 == this.data[i]) {
                    if (1 != this.data[i + 1]) break;
                    i = pair(this.data, i + 2);
                }
                if (0 == (1 & this.data[i + 2])) {
                    let value = this.data[i + 1];
                    result.some((v, i) => 1 & i && v == value) || result.push(this.data[i], value);
                }
            }
            return result;
        }
        configure(config) {
            let copy = Object.assign(Object.create(LRParser.prototype), this);
            if (config.props && (copy.nodeSet = this.nodeSet.extend(...config.props)), 
            config.top) {
                var info = this.topRules[config.top];
                if (!info) throw new RangeError("Invalid top rule name " + config.top);
                copy.top = info;
            }
            return config.tokenizers && (copy.tokenizers = this.tokenizers.map(t => {
                var found = config.tokenizers.find(r => r.from == t);
                return found ? found.to : t;
            })), config.specializers && (copy.specializers = this.specializers.slice(), 
            copy.specializerSpecs = this.specializerSpecs.map((s, i) => {
                var found = config.specializers.find(r => r.from == s.external);
                return found ? (found = Object.assign(Object.assign({}, s), {
                    external: found.to
                }), copy.specializers[i] = getSpecializer(found), found) : s;
            })), config.contextTracker && (copy.context = config.contextTracker), 
            config.dialect && (copy.dialect = this.parseDialect(config.dialect)), 
            null != config.strict && (copy.strict = config.strict), config.wrap && (copy.wrappers = copy.wrappers.concat(config.wrap)), 
            null != config.bufferLength && (copy.bufferLength = config.bufferLength), 
            copy;
        }
        hasWrappers() {
            return 0 < this.wrappers.length;
        }
        getName(term) {
            return this.termNames ? this.termNames[term] : String(term <= this.maxNode && this.nodeSet.types[term].name || term);
        }
        get eofTerm() {
            return this.maxNode + 1;
        }
        get topNode() {
            return this.nodeSet.types[this.top[1]];
        }
        dynamicPrecedence(term) {
            var prec = this.dynamicPrecedences;
            return null != prec && prec[term] || 0;
        }
        parseDialect(dialect) {
            var values = Object.keys(this.dialects), flags = values.map(() => !1);
            if (dialect) for (var part of dialect.split(" ")) {
                part = values.indexOf(part);
                0 <= part && (flags[part] = !0);
            }
            let disabled = null;
            for (let i = 0; i < values.length; i++) if (!flags[i]) for (let j = this.dialects[values[i]], id; 65535 != (id = this.data[j++]); ) (disabled = disabled || new Uint8Array(this.maxTerm + 1))[id] = 1;
            return new Dialect(dialect, flags, disabled);
        }
        static deserialize(spec) {
            return new LRParser(spec);
        }
    }
    function pair(data, off) {
        return data[off] | data[off + 1] << 16;
    }
    function getSpecializer(spec) {
        if (spec.external) {
            let mask = spec.extend ? 1 : 0;
            return (value, stack) => spec.external(value, stack) << 1 | mask;
        }
        return spec.get;
    }
    const Element$1 = 20, TagName = 22, Attribute = 23, AttributeName = 24, AttributeValue = 26, UnquotedAttributeValue = 27, ScriptText = 28, StyleText = 31, TextareaText = 34, CloseTag = 37, selfClosers$1 = {
        area: !0,
        base: !0,
        br: !0,
        col: !0,
        command: !0,
        embed: !0,
        frame: !0,
        hr: !0,
        img: !0,
        input: !0,
        keygen: !0,
        link: !0,
        meta: !0,
        param: !0,
        source: !0,
        track: !0,
        wbr: !0,
        menuitem: !0
    }, implicitlyClosed = {
        dd: !0,
        li: !0,
        optgroup: !0,
        option: !0,
        p: !0,
        rp: !0,
        rt: !0,
        tbody: !0,
        td: !0,
        tfoot: !0,
        th: !0,
        tr: !0
    }, closeOnOpen = {
        dd: {
            dd: !0,
            dt: !0
        },
        dt: {
            dd: !0,
            dt: !0
        },
        li: {
            li: !0
        },
        option: {
            option: !0,
            optgroup: !0
        },
        optgroup: {
            optgroup: !0
        },
        p: {
            address: !0,
            article: !0,
            aside: !0,
            blockquote: !0,
            dir: !0,
            div: !0,
            dl: !0,
            fieldset: !0,
            footer: !0,
            form: !0,
            h1: !0,
            h2: !0,
            h3: !0,
            h4: !0,
            h5: !0,
            h6: !0,
            header: !0,
            hgroup: !0,
            hr: !0,
            menu: !0,
            nav: !0,
            ol: !0,
            p: !0,
            pre: !0,
            section: !0,
            table: !0,
            ul: !0
        },
        rp: {
            rp: !0,
            rt: !0
        },
        rt: {
            rp: !0,
            rt: !0
        },
        tbody: {
            tbody: !0,
            tfoot: !0
        },
        td: {
            td: !0,
            th: !0
        },
        tfoot: {
            tbody: !0
        },
        th: {
            td: !0,
            th: !0
        },
        thead: {
            tbody: !0,
            tfoot: !0
        },
        tr: {
            tr: !0
        }
    };
    function isSpace$1(ch) {
        return 9 == ch || 10 == ch || 13 == ch || 32 == ch;
    }
    let cachedName = null, cachedInput = null, cachedPos = 0;
    function tagNameAfter(input, offset) {
        var ch, pos = input.pos + offset;
        if (cachedPos == pos && cachedInput == input) return cachedName;
        let next = input.peek(offset);
        for (;isSpace$1(next); ) next = input.peek(++offset);
        let name = "";
        for (;45 == (ch = next) || 46 == ch || 58 == ch || 65 <= ch && ch <= 90 || 95 == ch || 97 <= ch && ch <= 122 || 161 <= ch; ) name += String.fromCharCode(next), 
        next = input.peek(++offset);
        return cachedInput = input, cachedPos = pos, cachedName = name ? name.toLowerCase() : 63 == next || 33 == next ? void 0 : null;
    }
    function ElementContext(name, parent) {
        this.name = name, this.parent = parent;
    }
    const startTagTerms = [ 6, 10, 7, 8, 9 ];
    selectDocEnd = new ContextTracker({
        start: null,
        shift(context, term, stack, input) {
            return -1 < startTagTerms.indexOf(term) ? new ElementContext(tagNameAfter(input, 1) || "", context) : context;
        },
        reduce(context, term) {
            return term == Element$1 && context ? context.parent : context;
        },
        reuse(context, node, stack, input) {
            node = node.type.id;
            return 6 == node || 36 == node ? new ElementContext(tagNameAfter(input, 1) || "", context) : context;
        },
        strict: !1
    }), insertNewlineAndIndent = new ExternalTokenizer((input, stack) => {
        if (60 != input.next) input.next < 0 && stack.context && input.acceptToken(57); else {
            input.advance();
            var close = 47 == input.next, name = (close && input.advance(), tagNameAfter(input, 0));
            if (void 0 !== name) {
                if (!name) return input.acceptToken(close ? 14 : 6);
                var parent = stack.context ? stack.context.name : null;
                if (!close) return "script" == name ? input.acceptToken(7) : "style" == name ? input.acceptToken(8) : "textarea" == name ? input.acceptToken(9) : selfClosers$1.hasOwnProperty(name) ? input.acceptToken(10) : void (parent && closeOnOpen[parent] && closeOnOpen[parent][name] ? input.acceptToken(57, -1) : input.acceptToken(6));
                if (name == parent) return input.acceptToken(11);
                if (parent && implicitlyClosed[parent]) return input.acceptToken(57, -2);
                if (stack.dialectEnabled(0)) return input.acceptToken(12);
                for (let cx = stack.context; cx; cx = cx.parent) if (cx.name == name) return;
                input.acceptToken(13);
            }
        }
    }, {
        contextual: !0
    }), operator = new ExternalTokenizer(input => {
        for (let dashes = 0, i = 0; ;i++) {
            if (input.next < 0) {
                i && input.acceptToken(58);
                break;
            }
            if (45 == input.next) dashes++; else {
                if (62 == input.next && 2 <= dashes) {
                    3 <= i && input.acceptToken(58, -2);
                    break;
                }
                dashes = 0;
            }
            input.advance();
        }
    });
    meta = new ExternalTokenizer((input, stack) => {
        47 == input.next && 62 == input.peek(1) ? (stack = stack.dialectEnabled(1) || function(context) {
            for (;context; context = context.parent) if ("svg" == context.name || "math" == context.name) return !0;
            return !1;
        }(stack.context), input.acceptToken(stack ? 5 : 4, 2)) : 62 == input.next && input.acceptToken(4, 1);
    });
    function contentTokenizer(tag, textToken, endToken) {
        let lastState = 2 + tag.length;
        return new ExternalTokenizer(input => {
            for (let state = 0, matchedLen = 0, i = 0; ;i++) {
                if (input.next < 0) {
                    i && input.acceptToken(textToken);
                    break;
                }
                if (0 == state && 60 == input.next || 1 == state && 47 == input.next || 2 <= state && state < lastState && input.next == tag.charCodeAt(state - 2)) state++, 
                matchedLen++; else if (2 != state && state != lastState || !isSpace$1(input.next)) {
                    if (state == lastState && 62 == input.next) {
                        i > matchedLen ? input.acceptToken(textToken, -matchedLen) : input.acceptToken(endToken, -(matchedLen - 2));
                        break;
                    }
                    if ((10 == input.next || 13 == input.next) && i) {
                        input.acceptToken(textToken, 1);
                        break;
                    }
                    state = matchedLen = 0;
                } else matchedLen++;
                input.advance();
            }
        });
    }
    punctuation = contentTokenizer("script", 54, 1), ie_edge = contentTokenizer("style", 55, 2), 
    bracket = contentTokenizer("textarea", 56, 3), gecko = styleTags({
        "Text RawText": tags$1.content,
        "StartTag StartCloseTag SelfClosingEndTag EndTag": tags$1.angleBracket,
        TagName: tags$1.tagName,
        "MismatchedCloseTag/TagName": [ tags$1.tagName, tags$1.invalid ],
        AttributeName: tags$1.attributeName,
        "AttributeValue UnquotedAttributeValue": tags$1.attributeValue,
        Is: tags$1.definitionOperator,
        "EntityReference CharacterReference": tags$1.character,
        Comment: tags$1.blockComment,
        ProcessingInst: tags$1.processingInstruction,
        DoctypeDecl: tags$1.documentMeta
    }), ie = LRParser.deserialize({
        version: 14,
        states: ",xOVO!rOOO!WQ#tO'#CqO!]Q#tO'#CzO!bQ#tO'#C}O!gQ#tO'#DQO!lQ#tO'#DSO!qOaO'#CpO!|ObO'#CpO#XOdO'#CpO$eO!rO'#CpOOO`'#Cp'#CpO$lO$fO'#DTO$tQ#tO'#DVO$yQ#tO'#DWOOO`'#Dk'#DkOOO`'#DY'#DYQVO!rOOO%OQ&rO,59]O%ZQ&rO,59fO%fQ&rO,59iO%qQ&rO,59lO%|Q&rO,59nOOOa'#D^'#D^O&XOaO'#CxO&dOaO,59[OOOb'#D_'#D_O&lObO'#C{O&wObO,59[OOOd'#D`'#D`O'POdO'#DOO'[OdO,59[OOO`'#Da'#DaO'dO!rO,59[O'kQ#tO'#DROOO`,59[,59[OOOp'#Db'#DbO'pO$fO,59oOOO`,59o,59oO'xQ#|O,59qO'}Q#|O,59rOOO`-E7W-E7WO(SQ&rO'#CsOOQW'#DZ'#DZO(bQ&rO1G.wOOOa1G.w1G.wOOO`1G/Y1G/YO(mQ&rO1G/QOOOb1G/Q1G/QO(xQ&rO1G/TOOOd1G/T1G/TO)TQ&rO1G/WOOO`1G/W1G/WO)`Q&rO1G/YOOOa-E7[-E7[O)kQ#tO'#CyOOO`1G.v1G.vOOOb-E7]-E7]O)pQ#tO'#C|OOOd-E7^-E7^O)uQ#tO'#DPOOO`-E7_-E7_O)zQ#|O,59mOOOp-E7`-E7`OOO`1G/Z1G/ZOOO`1G/]1G/]OOO`1G/^1G/^O*PQ,UO,59_OOQW-E7X-E7XOOOa7+$c7+$cOOO`7+$t7+$tOOOb7+$l7+$lOOOd7+$o7+$oOOO`7+$r7+$rO*[Q#|O,59eO*aQ#|O,59hO*fQ#|O,59kOOO`1G/X1G/XO*kO7[O'#CvO*|OMhO'#CvOOQW1G.y1G.yOOO`1G/P1G/POOO`1G/S1G/SOOO`1G/V1G/VOOOO'#D['#D[O+_O7[O,59bOOQW,59b,59bOOOO'#D]'#D]O+pOMhO,59bOOOO-E7Y-E7YOOQW1G.|1G.|OOOO-E7Z-E7Z",
        stateData: ",]~O!^OS~OUSOVPOWQOXROYTO[]O][O^^O`^Oa^Ob^Oc^Ox^O{_O!dZO~OfaO~OfbO~OfcO~OfdO~OfeO~O!WfOPlP!ZlP~O!XiOQoP!ZoP~O!YlORrP!ZrP~OUSOVPOWQOXROYTOZqO[]O][O^^O`^Oa^Ob^Oc^Ox^O!dZO~O!ZrO~P#dO![sO!euO~OfvO~OfwO~OS|OT}OhyO~OS!POT}OhyO~OS!ROT}OhyO~OS!TOT}OhyO~OS}OT}OhyO~O!WfOPlX!ZlX~OP!WO!Z!XO~O!XiOQoX!ZoX~OQ!ZO!Z!XO~O!YlORrX!ZrX~OR!]O!Z!XO~O!Z!XO~P#dOf!_O~O![sO!e!aO~OS!bO~OS!cO~Oi!dOSgXTgXhgX~OS!fOT!gOhyO~OS!hOT!gOhyO~OS!iOT!gOhyO~OS!jOT!gOhyO~OS!gOT!gOhyO~Of!kO~Of!lO~Of!mO~OS!nO~Ok!qO!`!oO!b!pO~OS!rO~OS!sO~OS!tO~Oa!uOb!uOc!uO!`!wO!a!uO~Oa!xOb!xOc!xO!b!wO!c!xO~Oa!uOb!uOc!uO!`!{O!a!uO~Oa!xOb!xOc!xO!b!{O!c!xO~OT~bac!dx{!d~",
        goto: "%p!`PPPPPPPPPPPPPPPPPPPP!a!gP!mPP!yP!|#P#S#Y#]#`#f#i#l#r#x!aP!a!aP$O$U$l$r$x%O%U%[%bPPPPPPPP%hX^OX`pXUOX`pezabcde{!O!Q!S!UR!q!dRhUR!XhXVOX`pRkVR!XkXWOX`pRnWR!XnXXOX`pQrXR!XpXYOX`pQ`ORx`Q{aQ!ObQ!QcQ!SdQ!UeZ!e{!O!Q!S!UQ!v!oR!z!vQ!y!pR!|!yQgUR!VgQjVR!YjQmWR![mQpXR!^pQtZR!`tS_O`ToXp",
        nodeNames: "\u26a0 StartCloseTag StartCloseTag StartCloseTag EndTag SelfClosingEndTag StartTag StartTag StartTag StartTag StartTag StartCloseTag StartCloseTag StartCloseTag IncompleteCloseTag Document Text EntityReference CharacterReference InvalidEntity Element OpenTag TagName Attribute AttributeName Is AttributeValue UnquotedAttributeValue ScriptText CloseTag OpenTag StyleText CloseTag OpenTag TextareaText CloseTag OpenTag CloseTag SelfClosingTag Comment ProcessingInst MismatchedCloseTag CloseTag DoctypeDecl",
        maxTerm: 67,
        context: selectDocEnd,
        nodeProps: [ [ "closedBy", -10, 1, 2, 3, 7, 8, 9, 10, 11, 12, 13, "EndTag", 6, "EndTag SelfClosingEndTag", -4, 21, 30, 33, 36, "CloseTag" ], [ "openedBy", 4, "StartTag StartCloseTag", 5, "StartTag", -4, 29, 32, 35, 37, "OpenTag" ], [ "group", -9, 14, 17, 18, 19, 20, 39, 40, 41, 42, "Entity", 16, "Entity TextContent", -3, 28, 31, 34, "TextContent Entity" ], [ "isolate", -11, 21, 29, 30, 32, 33, 35, 36, 37, 38, 41, 42, "ltr", -3, 26, 27, 39, "" ] ],
        propSources: [ gecko ],
        skippedNodes: [ 0 ],
        repeatNodeCount: 9,
        tokenData: "!<p!aR!YOX$qXY,QYZ,QZ[$q[]&X]^,Q^p$qpq,Qqr-_rs3_sv-_vw3}wxHYx}-_}!OH{!O!P-_!P!Q$q!Q![-_![!]Mz!]!^-_!^!_!$S!_!`!;x!`!a&X!a!c-_!c!}Mz!}#R-_#R#SMz#S#T1k#T#oMz#o#s-_#s$f$q$f%W-_%W%oMz%o%p-_%p&aMz&a&b-_&b1pMz1p4U-_4U4dMz4d4e-_4e$ISMz$IS$I`-_$I`$IbMz$Ib$Kh-_$Kh%#tMz%#t&/x-_&/x&EtMz&Et&FV-_&FV;'SMz;'S;:j!#|;:j;=`3X<%l?&r-_?&r?AhMz?Ah?BY$q?BY?MnMz?MnO$q!Z$|c`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr$qrs&}sv$qvw+Pwx(tx!^$q!^!_*V!_!a&X!a#S$q#S#T&X#T;'S$q;'S;=`+z<%lO$q!R&bX`P!a`!cpOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&Xq'UV`P!cpOv&}wx'kx!^&}!^!_(V!_;'S&};'S;=`(n<%lO&}P'pT`POv'kw!^'k!_;'S'k;'S;=`(P<%lO'kP(SP;=`<%l'kp([S!cpOv(Vx;'S(V;'S;=`(h<%lO(Vp(kP;=`<%l(Vq(qP;=`<%l&}a({W`P!a`Or(trs'ksv(tw!^(t!^!_)e!_;'S(t;'S;=`*P<%lO(t`)jT!a`Or)esv)ew;'S)e;'S;=`)y<%lO)e`)|P;=`<%l)ea*SP;=`<%l(t!Q*^V!a`!cpOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!Q*vP;=`<%l*V!R*|P;=`<%l&XW+UYkWOX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+PW+wP;=`<%l+P!Z+}P;=`<%l$q!a,]``P!a`!cp!^^OX&XXY,QYZ,QZ]&X]^,Q^p&Xpq,Qqr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X!_-ljhS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx!P-_!P!Q$q!Q!^-_!^!_*V!_!a&X!a#S-_#S#T1k#T#s-_#s$f$q$f;'S-_;'S;=`3X<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q[/ebhSkWOX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!a#S/^#S#T0m#T#s/^#s$f+P$f;'S/^;'S;=`1e<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+PS0rXhSqr0msw0mx!P0m!Q!^0m!a#s0m$f;'S0m;'S;=`1_<%l?Ah0m?BY?Mn0mS1bP;=`<%l0m[1hP;=`<%l/^!V1vchS`P!a`!cpOq&Xqr1krs&}sv1kvw0mwx(tx!P1k!P!Q&X!Q!^1k!^!_*V!_!a&X!a#s1k#s$f&X$f;'S1k;'S;=`3R<%l?Ah1k?Ah?BY&X?BY?Mn1k?MnO&X!V3UP;=`<%l1k!_3[P;=`<%l-_!Z3hV!`h`P!cpOv&}wx'kx!^&}!^!_(V!_;'S&};'S;=`(n<%lO&}!_4WihSkWc!ROX5uXZ7SZ[5u[^7S^p5uqr8trs7Sst>]tw8twx7Sx!P8t!P!Q5u!Q!]8t!]!^/^!^!a7S!a#S8t#S#T;{#T#s8t#s$f5u$f;'S8t;'S;=`>V<%l?Ah8t?Ah?BY5u?BY?Mn8t?MnO5u!Z5zbkWOX5uXZ7SZ[5u[^7S^p5uqr5urs7Sst+Ptw5uwx7Sx!]5u!]!^7w!^!a7S!a#S5u#S#T7S#T;'S5u;'S;=`8n<%lO5u!R7VVOp7Sqs7St!]7S!]!^7l!^;'S7S;'S;=`7q<%lO7S!R7qOa!R!R7tP;=`<%l7S!Z8OYkWa!ROX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+P!Z8qP;=`<%l5u!_8{ihSkWOX5uXZ7SZ[5u[^7S^p5uqr8trs7Sst/^tw8twx7Sx!P8t!P!Q5u!Q!]8t!]!^:j!^!a7S!a#S8t#S#T;{#T#s8t#s$f5u$f;'S8t;'S;=`>V<%l?Ah8t?Ah?BY5u?BY?Mn8t?MnO5u!_:sbhSkWa!ROX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!a#S/^#S#T0m#T#s/^#s$f+P$f;'S/^;'S;=`1e<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+P!V<QchSOp7Sqr;{rs7Sst0mtw;{wx7Sx!P;{!P!Q7S!Q!];{!]!^=]!^!a7S!a#s;{#s$f7S$f;'S;{;'S;=`>P<%l?Ah;{?Ah?BY7S?BY?Mn;{?MnO7S!V=dXhSa!Rqr0msw0mx!P0m!Q!^0m!a#s0m$f;'S0m;'S;=`1_<%l?Ah0m?BY?Mn0m!V>SP;=`<%l;{!_>YP;=`<%l8t!_>dhhSkWOX@OXZAYZ[@O[^AY^p@OqrBwrsAYswBwwxAYx!PBw!P!Q@O!Q!]Bw!]!^/^!^!aAY!a#SBw#S#TE{#T#sBw#s$f@O$f;'SBw;'S;=`HS<%l?AhBw?Ah?BY@O?BY?MnBw?MnO@O!Z@TakWOX@OXZAYZ[@O[^AY^p@Oqr@OrsAYsw@OwxAYx!]@O!]!^Az!^!aAY!a#S@O#S#TAY#T;'S@O;'S;=`Bq<%lO@O!RA]UOpAYq!]AY!]!^Ao!^;'SAY;'S;=`At<%lOAY!RAtOb!R!RAwP;=`<%lAY!ZBRYkWb!ROX+PZ[+P^p+Pqr+Psw+Px!^+P!a#S+P#T;'S+P;'S;=`+t<%lO+P!ZBtP;=`<%l@O!_COhhSkWOX@OXZAYZ[@O[^AY^p@OqrBwrsAYswBwwxAYx!PBw!P!Q@O!Q!]Bw!]!^Dj!^!aAY!a#SBw#S#TE{#T#sBw#s$f@O$f;'SBw;'S;=`HS<%l?AhBw?Ah?BY@O?BY?MnBw?MnO@O!_DsbhSkWb!ROX+PZ[+P^p+Pqr/^sw/^x!P/^!P!Q+P!Q!^/^!a#S/^#S#T0m#T#s/^#s$f+P$f;'S/^;'S;=`1e<%l?Ah/^?Ah?BY+P?BY?Mn/^?MnO+P!VFQbhSOpAYqrE{rsAYswE{wxAYx!PE{!P!QAY!Q!]E{!]!^GY!^!aAY!a#sE{#s$fAY$f;'SE{;'S;=`G|<%l?AhE{?Ah?BYAY?BY?MnE{?MnOAY!VGaXhSb!Rqr0msw0mx!P0m!Q!^0m!a#s0m$f;'S0m;'S;=`1_<%l?Ah0m?BY?Mn0m!VHPP;=`<%lE{!_HVP;=`<%lBw!ZHcW!bx`P!a`Or(trs'ksv(tw!^(t!^!_)e!_;'S(t;'S;=`*P<%lO(t!aIYlhS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx}-_}!OKQ!O!P-_!P!Q$q!Q!^-_!^!_*V!_!a&X!a#S-_#S#T1k#T#s-_#s$f$q$f;'S-_;'S;=`3X<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q!aK_khS`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx!P-_!P!Q$q!Q!^-_!^!_*V!_!`&X!`!aMS!a#S-_#S#T1k#T#s-_#s$f$q$f;'S-_;'S;=`3X<%l?Ah-_?Ah?BY$q?BY?Mn-_?MnO$q!TM_X`P!a`!cp!eQOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X!aNZ!ZhSfQ`PkW!a`!cpOX$qXZ&XZ[$q[^&X^p$qpq&Xqr-_rs&}sv-_vw/^wx(tx}-_}!OMz!O!PMz!P!Q$q!Q![Mz![!]Mz!]!^-_!^!_*V!_!a&X!a!c-_!c!}Mz!}#R-_#R#SMz#S#T1k#T#oMz#o#s-_#s$f$q$f$}-_$}%OMz%O%W-_%W%oMz%o%p-_%p&aMz&a&b-_&b1pMz1p4UMz4U4dMz4d4e-_4e$ISMz$IS$I`-_$I`$IbMz$Ib$Je-_$Je$JgMz$Jg$Kh-_$Kh%#tMz%#t&/x-_&/x&EtMz&Et&FV-_&FV;'SMz;'S;:j!#|;:j;=`3X<%l?&r-_?&r?AhMz?Ah?BY$q?BY?MnMz?MnO$q!a!$PP;=`<%lMz!R!$ZY!a`!cpOq*Vqr!$yrs(Vsv*Vwx)ex!a*V!a!b!4t!b;'S*V;'S;=`*s<%lO*V!R!%Q]!a`!cpOr*Vrs(Vsv*Vwx)ex}*V}!O!%y!O!f*V!f!g!']!g#W*V#W#X!0`#X;'S*V;'S;=`*s<%lO*V!R!&QX!a`!cpOr*Vrs(Vsv*Vwx)ex}*V}!O!&m!O;'S*V;'S;=`*s<%lO*V!R!&vV!a`!cp!dPOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!'dX!a`!cpOr*Vrs(Vsv*Vwx)ex!q*V!q!r!(P!r;'S*V;'S;=`*s<%lO*V!R!(WX!a`!cpOr*Vrs(Vsv*Vwx)ex!e*V!e!f!(s!f;'S*V;'S;=`*s<%lO*V!R!(zX!a`!cpOr*Vrs(Vsv*Vwx)ex!v*V!v!w!)g!w;'S*V;'S;=`*s<%lO*V!R!)nX!a`!cpOr*Vrs(Vsv*Vwx)ex!{*V!{!|!*Z!|;'S*V;'S;=`*s<%lO*V!R!*bX!a`!cpOr*Vrs(Vsv*Vwx)ex!r*V!r!s!*}!s;'S*V;'S;=`*s<%lO*V!R!+UX!a`!cpOr*Vrs(Vsv*Vwx)ex!g*V!g!h!+q!h;'S*V;'S;=`*s<%lO*V!R!+xY!a`!cpOr!+qrs!,hsv!+qvw!-Swx!.[x!`!+q!`!a!/j!a;'S!+q;'S;=`!0Y<%lO!+qq!,mV!cpOv!,hvx!-Sx!`!,h!`!a!-q!a;'S!,h;'S;=`!.U<%lO!,hP!-VTO!`!-S!`!a!-f!a;'S!-S;'S;=`!-k<%lO!-SP!-kO{PP!-nP;=`<%l!-Sq!-xS!cp{POv(Vx;'S(V;'S;=`(h<%lO(Vq!.XP;=`<%l!,ha!.aX!a`Or!.[rs!-Ssv!.[vw!-Sw!`!.[!`!a!.|!a;'S!.[;'S;=`!/d<%lO!.[a!/TT!a`{POr)esv)ew;'S)e;'S;=`)y<%lO)ea!/gP;=`<%l!.[!R!/sV!a`!cp{POr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!0]P;=`<%l!+q!R!0gX!a`!cpOr*Vrs(Vsv*Vwx)ex#c*V#c#d!1S#d;'S*V;'S;=`*s<%lO*V!R!1ZX!a`!cpOr*Vrs(Vsv*Vwx)ex#V*V#V#W!1v#W;'S*V;'S;=`*s<%lO*V!R!1}X!a`!cpOr*Vrs(Vsv*Vwx)ex#h*V#h#i!2j#i;'S*V;'S;=`*s<%lO*V!R!2qX!a`!cpOr*Vrs(Vsv*Vwx)ex#m*V#m#n!3^#n;'S*V;'S;=`*s<%lO*V!R!3eX!a`!cpOr*Vrs(Vsv*Vwx)ex#d*V#d#e!4Q#e;'S*V;'S;=`*s<%lO*V!R!4XX!a`!cpOr*Vrs(Vsv*Vwx)ex#X*V#X#Y!+q#Y;'S*V;'S;=`*s<%lO*V!R!4{Y!a`!cpOr!4trs!5ksv!4tvw!6Vwx!8]x!a!4t!a!b!:]!b;'S!4t;'S;=`!;r<%lO!4tq!5pV!cpOv!5kvx!6Vx!a!5k!a!b!7W!b;'S!5k;'S;=`!8V<%lO!5kP!6YTO!a!6V!a!b!6i!b;'S!6V;'S;=`!7Q<%lO!6VP!6lTO!`!6V!`!a!6{!a;'S!6V;'S;=`!7Q<%lO!6VP!7QOxPP!7TP;=`<%l!6Vq!7]V!cpOv!5kvx!6Vx!`!5k!`!a!7r!a;'S!5k;'S;=`!8V<%lO!5kq!7yS!cpxPOv(Vx;'S(V;'S;=`(h<%lO(Vq!8YP;=`<%l!5ka!8bX!a`Or!8]rs!6Vsv!8]vw!6Vw!a!8]!a!b!8}!b;'S!8];'S;=`!:V<%lO!8]a!9SX!a`Or!8]rs!6Vsv!8]vw!6Vw!`!8]!`!a!9o!a;'S!8];'S;=`!:V<%lO!8]a!9vT!a`xPOr)esv)ew;'S)e;'S;=`)y<%lO)ea!:YP;=`<%l!8]!R!:dY!a`!cpOr!4trs!5ksv!4tvw!6Vwx!8]x!`!4t!`!a!;S!a;'S!4t;'S;=`!;r<%lO!4t!R!;]V!a`!cpxPOr*Vrs(Vsv*Vwx)ex;'S*V;'S;=`*s<%lO*V!R!;uP;=`<%l!4t!V!<TXiS`P!a`!cpOr&Xrs&}sv&Xwx(tx!^&X!^!_*V!_;'S&X;'S;=`*y<%lO&X",
        tokenizers: [ punctuation, ie_edge, bracket, meta, insertNewlineAndIndent, operator, 0, 1, 2, 3, 4, 5 ],
        topRules: {
            Document: [ 0, 15 ]
        },
        dialects: {
            noMatch: 0,
            selfClosing: 509
        },
        tokenPrec: 511
    });
    function getAttrs(openTag, input) {
        var att, attrs = Object.create(null);
        for (att of openTag.getChildren(Attribute)) {
            var name = att.getChild(AttributeName), value = att.getChild(AttributeValue) || att.getChild(UnquotedAttributeValue);
            name && (attrs[input.read(name.from, name.to)] = value ? value.type.id == AttributeValue ? input.read(value.from + 1, value.to - 1) : input.read(value.from, value.to) : "");
        }
        return attrs;
    }
    function findTagName(openTag, input) {
        openTag = openTag.getChild(TagName);
        return openTag ? input.read(openTag.from, openTag.to) : " ";
    }
    function maybeNest(node, input, tags) {
        let attrs;
        for (var tag of tags) if (!tag.attrs || tag.attrs(attrs = attrs || getAttrs(node.node.parent.firstChild, input))) return {
            parser: tag.parser
        };
        return null;
    }
    function configureNesting(tags = [], attributes = []) {
        let script = [], style = [], textarea = [], other = [];
        for (var tag of tags) ("script" == tag.tag ? script : "style" == tag.tag ? style : "textarea" == tag.tag ? textarea : other).push(tag);
        let attrs = attributes.length ? Object.create(null) : null;
        for (var attr of attributes) (attrs[attr.name] || (attrs[attr.name] = [])).push(attr);
        return parseMixed((node, input) => {
            var id = node.type.id;
            if (id == ScriptText) return maybeNest(node, input, script);
            if (id == StyleText) return maybeNest(node, input, style);
            if (id == TextareaText) return maybeNest(node, input, textarea);
            if (id == Element$1 && other.length) {
                let n = node.node, open = n.firstChild, tagName = open && findTagName(open, input), attrs;
                if (tagName) for (var tag of other) if (tag.tag == tagName && (!tag.attrs || tag.attrs(attrs = attrs || getAttrs(open, input)))) {
                    var close = n.lastChild, close = close.type.id == CloseTag ? close.from : n.to;
                    if (close > open.to) return {
                        parser: tag.parser,
                        overlay: [ {
                            from: open.to,
                            to: close
                        } ]
                    };
                }
            }
            if (attrs && id == Attribute) {
                var n = node.node;
                if (id = n.firstChild) {
                    node = attrs[input.read(id.from, id.to)];
                    if (node) for (var attr of node) if (!attr.tagName || attr.tagName == findTagName(n.parent, input)) {
                        var value = n.lastChild;
                        if (value.type.id == AttributeValue) {
                            var from = value.from + 1;
                            let last = value.lastChild, to = value.to - (last && last.isError ? 0 : 1);
                            if (to > from) return {
                                parser: attr.parser,
                                overlay: [ {
                                    from: from,
                                    to: to
                                } ]
                            };
                        } else if (value.type.id == UnquotedAttributeValue) return {
                            parser: attr.parser,
                            overlay: [ {
                                from: value.from,
                                to: value.to
                            } ]
                        };
                    }
                }
            }
            return null;
        });
    }
    const space$2 = [ 9, 10, 11, 12, 13, 32, 133, 160, 5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288 ];
    function isAlpha(ch) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122 || 161 <= ch;
    }
    function isDigit(ch) {
        return 48 <= ch && ch <= 57;
    }
    function isHex$1(ch) {
        return isDigit(ch) || 97 <= ch && ch <= 102 || 65 <= ch && ch <= 70;
    }
    nav = (id, varName, callee) => (input, stack) => {
        for (let inside = !1, dashes = 0, i = 0; ;i++) {
            var next = input["next"];
            if (isAlpha(next) || 45 == next || 95 == next || inside && isDigit(next)) !inside && (45 != next || 0 < i) && (inside = !0), 
            dashes === i && 45 == next && dashes++, input.advance(); else {
                if (92 != next || 10 == input.peek(1)) {
                    inside && input.acceptToken(2 == dashes && stack.canShift(2) ? varName : 40 == next ? callee : id);
                    break;
                }
                if (input.advance(), isHex$1(input.next)) {
                    for (;input.advance(), isHex$1(input.next); );
                    32 == input.next && input.advance();
                } else -1 < input.next && input.advance();
                inside = !0;
            }
        }
    }, deleteCharForward = new ExternalTokenizer(nav(123, 2, 124)), deleteCharBackward = new ExternalTokenizer(nav(125, 3, 4)), 
    deleteGroupBackward = new ExternalTokenizer(input => {
        var next;
        space$2.includes(input.peek(-1)) && (next = input["next"], isAlpha(next) || 95 == next || 35 == next || 46 == next || 42 == next || 91 == next || 58 == next && isAlpha(input.peek(1)) || 45 == next || 38 == next) && input.acceptToken(122);
    }), ie_11up = new ExternalTokenizer(input => {
        if (!space$2.includes(input.peek(-1))) {
            var next = input["next"];
            if (37 == next && (input.advance(), input.acceptToken(1)), isAlpha(next)) {
                for (;input.advance(), isAlpha(input.next) || isDigit(input.next); );
                input.acceptToken(1);
            }
        }
    }), indentMore = styleTags({
        "AtKeyword import charset namespace keyframes media supports": tags$1.definitionKeyword,
        "from to selector": tags$1.keyword,
        NamespaceName: tags$1.namespace,
        KeyframeName: tags$1.labelName,
        KeyframeRangeName: tags$1.operatorKeyword,
        TagName: tags$1.tagName,
        ClassName: tags$1.className,
        PseudoClassName: tags$1.constant(tags$1.className),
        IdName: tags$1.labelName,
        "FeatureName PropertyName": tags$1.propertyName,
        AttributeName: tags$1.attributeName,
        NumberLiteral: tags$1.number,
        KeywordQuery: tags$1.keyword,
        UnaryQueryOp: tags$1.operatorKeyword,
        "CallTag ValueName": tags$1.atom,
        VariableName: tags$1.variableName,
        Callee: tags$1.operatorKeyword,
        Unit: tags$1.unit,
        "UniversalSelector NestingSelector": tags$1.definitionOperator,
        "MatchOp CompareOp": tags$1.compareOperator,
        "ChildOp SiblingOp, LogicOp": tags$1.logicOperator,
        BinOp: tags$1.arithmeticOperator,
        Important: tags$1.modifier,
        Comment: tags$1.blockComment,
        ColorLiteral: tags$1.color,
        "ParenthesizedContent StringLiteral": tags$1.string,
        ":": tags$1.punctuation,
        "PseudoOp #": tags$1.derefOperator,
        "; ,": tags$1.separator,
        "( )": tags$1.paren,
        "[ ]": tags$1.squareBracket,
        "{ }": tags$1.brace
    });
    const spec_callee = {
        __proto__: null,
        lang: 38,
        "nth-child": 38,
        "nth-last-child": 38,
        "nth-of-type": 38,
        "nth-last-of-type": 38,
        dir: 38,
        "host-context": 38,
        if: 84,
        url: 124,
        "url-prefix": 124,
        domain: 124,
        regexp: 124
    }, spec_queryIdentifier = {
        __proto__: null,
        or: 98,
        and: 98,
        not: 106,
        only: 106,
        layer: 170
    }, spec_QueryCallee = {
        __proto__: null,
        selector: 112,
        layer: 166
    }, spec_AtKeyword = {
        __proto__: null,
        "@import": 162,
        "@media": 174,
        "@charset": 178,
        "@namespace": 182,
        "@keyframes": 188,
        "@supports": 200,
        "@scope": 204
    }, spec_identifier$1 = {
        __proto__: null,
        to: 207
    };
    indentLess = LRParser.deserialize({
        version: 14,
        states: "EbQYQdOOO#qQdOOP#xO`OOOOQP'#Cf'#CfOOQP'#Ce'#CeO#}QdO'#ChO$nQaO'#CcO$xQdO'#CkO%TQdO'#DpO%YQdO'#DrO%_QdO'#DuO%_QdO'#DxOOQP'#FV'#FVO&eQhO'#EhOOQS'#FU'#FUOOQS'#Ek'#EkQYQdOOO&lQdO'#EOO&PQhO'#EUO&lQdO'#EWO'aQdO'#EYO'lQdO'#E]O'tQhO'#EcO(VQdO'#EeO(bQaO'#CfO)VQ`O'#D{O)[Q`O'#F`O)gQdO'#F`QOQ`OOP)qO&jO'#CaPOOO)C@t)C@tOOQP'#Cj'#CjOOQP,59S,59SO#}QdO,59SO)|QdO,59VO%TQdO,5:[O%YQdO,5:^O%_QdO,5:aO%_QdO,5:cO%_QdO,5:dO%_QdO'#ErO*XQ`O,58}O*aQdO'#DzOOQS,58},58}OOQP'#Cn'#CnOOQO'#Dn'#DnOOQP,59V,59VO*hQ`O,59VO*mQ`O,59VOOQP'#Dq'#DqOOQP,5:[,5:[OOQO'#Ds'#DsO*rQpO,5:^O+]QaO,5:aO+sQaO,5:dOOQW'#DZ'#DZO,ZQhO'#DdO,xQhO'#FaO'tQhO'#DbO-WQ`O'#DhOOQW'#F['#F[O-]Q`O,5;SO-eQ`O'#DeOOQS-E8i-E8iOOQ['#Cs'#CsO-jQdO'#CtO.QQdO'#CzO.hQdO'#C}O/OQ!pO'#DPO1RQ!jO,5:jOOQO'#DU'#DUO*mQ`O'#DTO1cQ!nO'#FXO3`Q`O'#DVO3eQ`O'#DkOOQ['#FX'#FXO-`Q`O,5:pO3jQ!bO,5:rOOQS'#E['#E[O3rQ`O,5:tO3wQdO,5:tOOQO'#E_'#E_O4PQ`O,5:wO4UQhO,5:}O%_QdO'#DgOOQS,5;P,5;PO-eQ`O,5;PO4^QdO,5;PO4fQdO,5:gO4vQdO'#EtO5TQ`O,5;zO5TQ`O,5;zPOOO'#Ej'#EjP5`O&jO,58{POOO,58{,58{OOQP1G.n1G.nOOQP1G.q1G.qO*hQ`O1G.qO*mQ`O1G.qOOQP1G/v1G/vO5kQpO1G/xO5sQaO1G/{O6ZQaO1G/}O6qQaO1G0OO7XQaO,5;^OOQO-E8p-E8pOOQS1G.i1G.iO7cQ`O,5:fO7hQdO'#DoO7oQdO'#CrOOQP1G/x1G/xO&lQdO1G/xO7vQ!jO'#DZO8UQ!bO,59vO8^QhO,5:OOOQO'#F]'#F]O8XQ!bO,59zO'tQhO,59xO8fQhO'#EvO8sQ`O,5;{O9OQhO,59|O9uQhO'#DiOOQW,5:S,5:SOOQS1G0n1G0nOOQW,5:P,5:PO9|Q!fO'#FYOOQS'#FY'#FYOOQS'#Em'#EmO;^QdO,59`OOQ[,59`,59`O;tQdO,59fOOQ[,59f,59fO<[QdO,59iOOQ[,59i,59iOOQ[,59k,59kO&lQdO,59mO<rQhO'#EQOOQW'#EQ'#EQO=WQ`O1G0UO1[QhO1G0UOOQ[,59o,59oO'tQhO'#DXOOQ[,59q,59qO=]Q#tO,5:VOOQS1G0[1G0[OOQS1G0^1G0^OOQS1G0`1G0`O=hQ`O1G0`O=mQdO'#E`OOQS1G0c1G0cOOQS1G0i1G0iO=xQaO,5:RO-`Q`O1G0kOOQS1G0k1G0kO-eQ`O1G0kO>PQ!fO1G0ROOQO1G0R1G0ROOQO,5;`,5;`O>gQdO,5;`OOQO-E8r-E8rO>tQ`O1G1fPOOO-E8h-E8hPOOO1G.g1G.gOOQP7+$]7+$]OOQP7+%d7+%dO&lQdO7+%dOOQS1G0Q1G0QO?PQaO'#F_O?ZQ`O,5:ZO?`Q!fO'#ElO@^QdO'#FWO@hQ`O,59^O@mQ!bO7+%dO&lQdO1G/bO@uQhO1G/fOOQW1G/j1G/jOOQW1G/d1G/dOAWQhO,5;bOOQO-E8t-E8tOAfQhO'#DZOAtQhO'#F^OBPQ`O'#F^OBUQ`O,5:TOOQS-E8k-E8kOOQ[1G.z1G.zOOQ[1G/Q1G/QOOQ[1G/T1G/TOOQ[1G/X1G/XOBZQdO,5:lOOQS7+%p7+%pOB`Q`O7+%pOBeQhO'#DYOBmQ`O,59sO'tQhO,59sOOQ[1G/q1G/qOBuQ`O1G/qOOQS7+%z7+%zOBzQbO'#DPOOQO'#Eb'#EbOCYQ`O'#EaOOQO'#Ea'#EaOCeQ`O'#EwOCmQdO,5:zOOQS,5:z,5:zOOQ[1G/m1G/mOOQS7+&V7+&VO-`Q`O7+&VOCxQ!fO'#EsO&lQdO'#EsOEPQdO7+%mOOQO7+%m7+%mOOQO1G0z1G0zOEdQ!bO<<IOOElQdO'#EqOEvQ`O,5;yOOQP1G/u1G/uOOQS-E8j-E8jOFOQdO'#EpOFYQ`O,5;rOOQ]1G.x1G.xOOQP<<IO<<IOOFbQdO7+$|OOQO'#D]'#D]OFiQ!bO7+%QOFqQhO'#EoOF{Q`O,5;xO&lQdO,5;xOOQW1G/o1G/oOOQO'#ES'#ESOGTQ`O1G0WOOQS<<I[<<I[O&lQdO,59tOGnQhO1G/_OOQ[1G/_1G/_OGuQ`O1G/_OOQW-E8l-E8lOOQ[7+%]7+%]OOQO,5:{,5:{O=pQdO'#ExOCeQ`O,5;cOOQS,5;c,5;cOOQS-E8u-E8uOOQS1G0f1G0fOOQS<<Iq<<IqOG}Q!fO,5;_OOQS-E8q-E8qOOQO<<IX<<IXOOQPAN>jAN>jOIUQaO,5;]OOQO-E8o-E8oOI`QdO,5;[OOQO-E8n-E8nOOQW<<Hh<<HhOOQW<<Hl<<HlOIjQhO<<HlOI{QhO,5;ZOJWQ`O,5;ZOOQO-E8m-E8mOJ]QdO1G1dOBZQdO'#EuOJgQ`O7+%rOOQW7+%r7+%rOJoQ!bO1G/`OOQ[7+$y7+$yOJzQhO7+$yPKRQ`O'#EnOOQO,5;d,5;dOOQO-E8v-E8vOOQS1G0}1G0}OKWQ`OAN>WO&lQdO1G0uOK]Q`O7+'OOOQO,5;a,5;aOOQO-E8s-E8sOOQW<<I^<<I^OOQ[<<He<<HePOQW,5;Y,5;YOOQWG23rG23rOKeQdO7+&a",
        stateData: "Kx~O#sOS#tQQ~OW[OZ[O]TO`VOaVOi]OjWOmXO!jYO!mZO!saO!ybO!{cO!}dO#QeO#WfO#YgO#oRO~OQiOW[OZ[O]TO`VOaVOi]OjWOmXO!jYO!mZO!saO!ybO!{cO!}dO#QeO#WfO#YgO#ohO~O#m$SP~P!dO#tmO~O#ooO~O]qO`rOarOjsOmtO!juO!mwO#nvO~OpzO!^xO~P$SOc!QO#o|O#p}O~O#o!RO~O#o!TO~OW[OZ[O]TO`VOaVOjWOmXO!jYO!mZO#oRO~OS!]Oe!YO!V![O!Y!`O#q!XOp$TP~Ok$TP~P&POQ!jOe!cOm!dOp!eOr!mOt!mOz!kO!`!lO#o!bO#p!hO#}!fO~Ot!qO!`!lO#o!pO~Ot!sO#o!sO~OS!]Oe!YO!V![O!Y!`O#q!XO~Oe!vOpzO#Z!xO~O]YX`YX`!pXaYXjYXmYXpYX!^YX!jYX!mYX#nYX~O`!zO~Ok!{O#m$SXo$SX~O#m$SXo$SX~P!dO#u#OO#v#OO#w#QO~Oc#UO#o|O#p}O~OpzO!^xO~Oo$SP~P!dOe#`O~Oe#aO~Ol#bO!h#cO~O]qO`rOarOjsOmtO~Op!ia!^!ia!j!ia!m!ia#n!iad!ia~P*zOp!la!^!la!j!la!m!la#n!lad!la~P*zOR#gOS!]Oe!YOr#gOt#gO!V![O!Y!`O#q#dO#}!fO~O!R#iO!^#jOk$TXp$TX~Oe#mO~Ok#oOpzO~Oe!vO~O]#rO`#rOd#uOi#rOj#rOk#rO~P&lO]#rO`#rOi#rOj#rOk#rOl#wO~P&lO]#rO`#rOi#rOj#rOk#rOo#yO~P&lOP#zOSsXesXksXvsX!VsX!YsX!usX!wsX#qsX!TsXQsX]sX`sXdsXisXjsXmsXpsXrsXtsXzsX!`sX#osX#psX#}sXlsXosX!^sX!qsX#msX~Ov#{O!u#|O!w#}Ok$TP~P'tOe#aOS#{Xk#{Xv#{X!V#{X!Y#{X!u#{X!w#{X#q#{XQ#{X]#{X`#{Xd#{Xi#{Xj#{Xm#{Xp#{Xr#{Xt#{Xz#{X!`#{X#o#{X#p#{X#}#{Xl#{Xo#{X!^#{X!q#{X#m#{X~Oe$RO~Oe$TO~Ok$VOv#{O~Ok$WO~Ot$XO!`!lO~Op$YO~OpzO!R#iO~OpzO#Z$`O~O!q$bOk!oa#m!oao!oa~P&lOk#hX#m#hXo#hX~P!dOk!{O#m$Sao$Sa~O#u#OO#v#OO#w$hO~Ol$jO!h$kO~Op!ii!^!ii!j!ii!m!ii#n!iid!ii~P*zOp!ki!^!ki!j!ki!m!ki#n!kid!ki~P*zOp!li!^!li!j!li!m!li#n!lid!li~P*zOp#fa!^#fa~P$SOo$lO~Od$RP~P%_Od#zP~P&lO`!PXd}X!R}X!T!PX~O`$sO!T$tO~Od$uO!R#iO~Ok#jXp#jX!^#jX~P'tO!^#jOk$Tap$Ta~O!R#iOk!Uap!Ua!^!Uad!Ua`!Ua~OS!]Oe!YO!V![O!Y!`O#q$yO~Od$QP~P9dOv#{OQ#|X]#|X`#|Xd#|Xe#|Xi#|Xj#|Xk#|Xm#|Xp#|Xr#|Xt#|Xz#|X!`#|X#o#|X#p#|X#}#|Xl#|Xo#|X~O]#rO`#rOd%OOi#rOj#rOk#rO~P&lO]#rO`#rOi#rOj#rOk#rOl%PO~P&lO]#rO`#rOi#rOj#rOk#rOo%QO~P&lOe%SOS!tXk!tX!V!tX!Y!tX#q!tX~Ok%TO~Od%YOt%ZO!a%ZO~Ok%[O~Oo%cO#o%^O#}%]O~Od%dO~P$SOv#{O!^%hO!q%jOk!oi#m!oio!oi~P&lOk#ha#m#hao#ha~P!dOk!{O#m$Sio$Si~O!^%mOd$RX~P$SOd%oO~Ov#{OQ#`Xd#`Xe#`Xm#`Xp#`Xr#`Xt#`Xz#`X!^#`X!`#`X#o#`X#p#`X#}#`X~O!^%qOd#zX~P&lOd%sO~Ol%tOv#{O~OR#gOr#gOt#gO#q%vO#}!fO~O!R#iOk#jap#ja!^#ja~O`!PXd}X!R}X!^}X~O!R#iO!^%xOd$QX~O`%zO~Od%{O~O#o%|O~Ok&OO~O`&PO!R#iO~Od&ROk&QO~Od&UO~OP#zOpsX!^sXdsX~O#}%]Op#TX!^#TX~OpzO!^&WO~Oo&[O#o%^O#}%]O~Ov#{OQ#gXe#gXk#gXm#gXp#gXr#gXt#gXz#gX!^#gX!`#gX!q#gX#m#gX#o#gX#p#gX#}#gXo#gX~O!^%hO!q&`Ok!oq#m!oqo!oq~P&lOl&aOv#{O~Od#eX!^#eX~P%_O!^%mOd$Ra~Od#dX!^#dX~P&lO!^%qOd#za~Od&fO~P&lOd&gO!T&hO~Od#cX!^#cX~P9dO!^%xOd$Qa~O]&mOd&oO~OS#bae#ba!V#ba!Y#ba#q#ba~Od&qO~PG]Od&qOk&rO~Ov#{OQ#gae#gak#gam#gap#gar#gat#gaz#ga!^#ga!`#ga!q#ga#m#ga#o#ga#p#ga#}#gao#ga~Od#ea!^#ea~P$SOd#da!^#da~P&lOR#gOr#gOt#gO#q%vO#}%]O~O!R#iOd#ca!^#ca~O`&xO~O!^%xOd$Qi~P&lO]&mOd&|O~Ov#{Od|ik|i~Od&}O~PG]Ok'OO~Od'PO~O!^%xOd$Qq~Od#cq!^#cq~P&lO#s!a#t#}]#}v!m~",
        goto: "2h$UPPPPP$VP$YP$c$uP$cP%X$cPP%_PPP%e%o%oPPPPP%oPP%oP&]P%oP%o'W%oP't'w'}'}(^'}P'}P'}P'}'}P(m'}(yP(|PP)p)v$c)|$c*SP$cP$c$cP*Y*{+YP$YP+aP+dP$YP$YP$YP+j$YP+m+p+s+z$YP$YPP$YP,P,V,f,|-[-b-l-r-x.O.U.`.f.l.rPPPPPPPPPPP.x/R/w/z0|P1U1u2O2R2U2[RnQ_^OP`kz!{$dq[OPYZ`kuvwxz!v!{#`$d%mqSOPYZ`kuvwxz!v!{#`$d%mQpTR#RqQ!OVR#SrQ#S!QS$Q!i!jR$i#U!V!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'Q!U!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QU#g!Y$t&hU%`$Y%b&WR&V%_!V!iac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QR$S!kQ%W$RR&S%Xk!^]bf!Y![!g#i#j#m$P$R%X%xQ#e!YQ${#mQ%w$tQ&j%xR&w&hQ!ygQ#p!`Q$^!xR%f$`R#n!]!U!mac!c!d!e!z#a#c#t#v#x#{$a$k$p$s%h%i%q%u%z&P&d&l&x'QQ!qdR$X!rQ!PVR#TrQ#S!PR$i#TQ!SWR#VsQ!UXR#WtQ{UQ!wgQ#^yQ#o!_Q$U!nQ$[!uQ$_!yQ%e$^Q&Y%aQ&]%fR&v&XSjPzQ!}kQ$c!{R%k$dZiPkz!{$dR$P!gQ%}%SR&z&mR!rdR!teR$Z!tS%a$Y%bR&t&WV%_$Y%b&WQ#PmR$g#PQ`OSkPzU!a`k$dR$d!{Q$p#aY%p$p%u&d&l'QQ%u$sQ&d%qQ&l%zR'Q&xQ#t!cQ#v!dQ#x!eV$}#t#v#xQ%X$RR&T%XQ%y$zS&k%y&yR&y&lQ%r$pR&e%rQ%n$mR&c%nQyUR#]yQ%i$aR&_%iQ!|jS$e!|$fR$f!}Q&n%}R&{&nQ#k!ZR$x#kQ%b$YR&Z%bQ&X%aR&u&X__OP`kz!{$d^UOP`kz!{$dQ!VYQ!WZQ#XuQ#YvQ#ZwQ#[xQ$]!vQ$m#`R&b%mR$q#aQ!gaQ!oc[#q!c!d!e#t#v#xQ$a!zd$o#a$p$s%q%u%z&d&l&x'QQ$r#cQ%R#{S%g$a%iQ%l$kQ&^%hR&p&P]#s!c!d!e#t#v#xW!Z]b!g$PQ!ufQ#f!YQ#l![Q$v#iQ$w#jQ$z#mS%V$R%XR&i%xQ#h!YQ%w$tR&w&hR$|#mR$n#`QlPR#_zQ!_]Q!nbQ$O!gR%U$P",
        nodeNames: "\u26a0 Unit VariableName VariableName QueryCallee Comment StyleSheet RuleSet UniversalSelector TagSelector TagName NestingSelector ClassSelector . ClassName PseudoClassSelector : :: PseudoClassName PseudoClassName ) ( ArgList ValueName ParenthesizedValue AtKeyword # ; ] [ BracketedValue } { BracedValue ColorLiteral NumberLiteral StringLiteral BinaryExpression BinOp CallExpression Callee IfExpression if ArgList IfBranch KeywordQuery FeatureQuery FeatureName BinaryQuery LogicOp ComparisonQuery CompareOp UnaryQuery UnaryQueryOp ParenthesizedQuery SelectorQuery selector ParenthesizedSelector CallQuery ArgList , CallLiteral CallTag ParenthesizedContent PseudoClassName ArgList IdSelector IdName AttributeSelector AttributeName MatchOp ChildSelector ChildOp DescendantSelector SiblingSelector SiblingOp Block Declaration PropertyName Important ImportStatement import Layer layer LayerName layer MediaStatement media CharsetStatement charset NamespaceStatement namespace NamespaceName KeyframesStatement keyframes KeyframeName KeyframeList KeyframeSelector KeyframeRangeName SupportsStatement supports ScopeStatement scope to AtRule Styles",
        maxTerm: 143,
        nodeProps: [ [ "isolate", -2, 5, 36, "" ], [ "openedBy", 20, "(", 28, "[", 31, "{" ], [ "closedBy", 21, ")", 29, "]", 32, "}" ] ],
        propSources: [ indentMore ],
        skippedNodes: [ 0, 5, 106 ],
        repeatNodeCount: 15,
        tokenData: "JQ~R!YOX$qX^%i^p$qpq%iqr({rs-ust/itu6Wuv$qvw7Qwx7cxy9Qyz9cz{9h{|:R|}>t}!O?V!O!P?t!P!Q@]!Q![AU![!]BP!]!^B{!^!_C^!_!`DY!`!aDm!a!b$q!b!cEn!c!}$q!}#OG{#O#P$q#P#QH^#Q#R6W#R#o$q#o#pHo#p#q6W#q#rIQ#r#sIc#s#y$q#y#z%i#z$f$q$f$g%i$g#BY$q#BY#BZ%i#BZ$IS$q$IS$I_%i$I_$I|$q$I|$JO%i$JO$JT$q$JT$JU%i$JU$KV$q$KV$KW%i$KW&FU$q&FU&FV%i&FV;'S$q;'S;=`Iz<%lO$q`$tSOy%Qz;'S%Q;'S;=`%c<%lO%Q`%VS!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Q`%fP;=`<%l%Q~%nh#s~OX%QX^'Y^p%Qpq'Yqy%Qz#y%Q#y#z'Y#z$f%Q$f$g'Y$g#BY%Q#BY#BZ'Y#BZ$IS%Q$IS$I_'Y$I_$I|%Q$I|$JO'Y$JO$JT%Q$JT$JU'Y$JU$KV%Q$KV$KW'Y$KW&FU%Q&FU&FV'Y&FV;'S%Q;'S;=`%c<%lO%Q~'ah#s~!a`OX%QX^'Y^p%Qpq'Yqy%Qz#y%Q#y#z'Y#z$f%Q$f$g'Y$g#BY%Q#BY#BZ'Y#BZ$IS%Q$IS$I_'Y$I_$I|%Q$I|$JO'Y$JO$JT%Q$JT$JU'Y$JU$KV%Q$KV$KW'Y$KW&FU%Q&FU&FV'Y&FV;'S%Q;'S;=`%c<%lO%Qj)OUOy%Qz#]%Q#]#^)b#^;'S%Q;'S;=`%c<%lO%Qj)gU!a`Oy%Qz#a%Q#a#b)y#b;'S%Q;'S;=`%c<%lO%Qj*OU!a`Oy%Qz#d%Q#d#e*b#e;'S%Q;'S;=`%c<%lO%Qj*gU!a`Oy%Qz#c%Q#c#d*y#d;'S%Q;'S;=`%c<%lO%Qj+OU!a`Oy%Qz#f%Q#f#g+b#g;'S%Q;'S;=`%c<%lO%Qj+gU!a`Oy%Qz#h%Q#h#i+y#i;'S%Q;'S;=`%c<%lO%Qj,OU!a`Oy%Qz#T%Q#T#U,b#U;'S%Q;'S;=`%c<%lO%Qj,gU!a`Oy%Qz#b%Q#b#c,y#c;'S%Q;'S;=`%c<%lO%Qj-OU!a`Oy%Qz#h%Q#h#i-b#i;'S%Q;'S;=`%c<%lO%Qj-iS!qY!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Q~-xWOY-uZr-urs.bs#O-u#O#P.g#P;'S-u;'S;=`/c<%lO-u~.gOt~~.jRO;'S-u;'S;=`.s;=`O-u~.vXOY-uZr-urs.bs#O-u#O#P.g#P;'S-u;'S;=`/c;=`<%l-u<%lO-u~/fP;=`<%l-uj/nYjYOy%Qz!Q%Q!Q![0^![!c%Q!c!i0^!i#T%Q#T#Z0^#Z;'S%Q;'S;=`%c<%lO%Qj0cY!a`Oy%Qz!Q%Q!Q![1R![!c%Q!c!i1R!i#T%Q#T#Z1R#Z;'S%Q;'S;=`%c<%lO%Qj1WY!a`Oy%Qz!Q%Q!Q![1v![!c%Q!c!i1v!i#T%Q#T#Z1v#Z;'S%Q;'S;=`%c<%lO%Qj1}YrY!a`Oy%Qz!Q%Q!Q![2m![!c%Q!c!i2m!i#T%Q#T#Z2m#Z;'S%Q;'S;=`%c<%lO%Qj2tYrY!a`Oy%Qz!Q%Q!Q![3d![!c%Q!c!i3d!i#T%Q#T#Z3d#Z;'S%Q;'S;=`%c<%lO%Qj3iY!a`Oy%Qz!Q%Q!Q![4X![!c%Q!c!i4X!i#T%Q#T#Z4X#Z;'S%Q;'S;=`%c<%lO%Qj4`YrY!a`Oy%Qz!Q%Q!Q![5O![!c%Q!c!i5O!i#T%Q#T#Z5O#Z;'S%Q;'S;=`%c<%lO%Qj5TY!a`Oy%Qz!Q%Q!Q![5s![!c%Q!c!i5s!i#T%Q#T#Z5s#Z;'S%Q;'S;=`%c<%lO%Qj5zSrY!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Qd6ZUOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Qd6tS!hS!a`Oy%Qz;'S%Q;'S;=`%c<%lO%Qb7VSZQOy%Qz;'S%Q;'S;=`%c<%lO%Q~7fWOY7cZw7cwx.bx#O7c#O#P8O#P;'S7c;'S;=`8z<%lO7c~8RRO;'S7c;'S;=`8[;=`O7c~8_XOY7cZw7cwx.bx#O7c#O#P8O#P;'S7c;'S;=`8z;=`<%l7c<%lO7c~8}P;=`<%l7cj9VSeYOy%Qz;'S%Q;'S;=`%c<%lO%Q~9hOd~n9oUWQvWOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Qj:YWvW!mQOy%Qz!O%Q!O!P:r!P!Q%Q!Q![=w![;'S%Q;'S;=`%c<%lO%Qj:wU!a`Oy%Qz!Q%Q!Q![;Z![;'S%Q;'S;=`%c<%lO%Qj;bY!a`#}YOy%Qz!Q%Q!Q![;Z![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%Qj<VY!a`Oy%Qz{%Q{|<u|}%Q}!O<u!O!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj<zU!a`Oy%Qz!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj=eU!a`#}YOy%Qz!Q%Q!Q![=^![;'S%Q;'S;=`%c<%lO%Qj>O[!a`#}YOy%Qz!O%Q!O!P;Z!P!Q%Q!Q![=w![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%Qj>yS!^YOy%Qz;'S%Q;'S;=`%c<%lO%Qj?[WvWOy%Qz!O%Q!O!P:r!P!Q%Q!Q![=w![;'S%Q;'S;=`%c<%lO%Qj?yU]YOy%Qz!Q%Q!Q![;Z![;'S%Q;'S;=`%c<%lO%Q~@bTvWOy%Qz{@q{;'S%Q;'S;=`%c<%lO%Q~@xS!a`#t~Oy%Qz;'S%Q;'S;=`%c<%lO%QjAZ[#}YOy%Qz!O%Q!O!P;Z!P!Q%Q!Q![=w![!g%Q!g!h<Q!h#X%Q#X#Y<Q#Y;'S%Q;'S;=`%c<%lO%QjBUU`YOy%Qz![%Q![!]Bh!];'S%Q;'S;=`%c<%lO%QbBoSaQ!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QjCQSkYOy%Qz;'S%Q;'S;=`%c<%lO%QhCcU!TWOy%Qz!_%Q!_!`Cu!`;'S%Q;'S;=`%c<%lO%QhC|S!TW!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QlDaS!TW!hSOy%Qz;'S%Q;'S;=`%c<%lO%QjDtV!jQ!TWOy%Qz!_%Q!_!`Cu!`!aEZ!a;'S%Q;'S;=`%c<%lO%QbEbS!jQ!a`Oy%Qz;'S%Q;'S;=`%c<%lO%QjEqYOy%Qz}%Q}!OFa!O!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjFfW!a`Oy%Qz!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjGV[iY!a`Oy%Qz}%Q}!OGO!O!Q%Q!Q![GO![!c%Q!c!}GO!}#T%Q#T#oGO#o;'S%Q;'S;=`%c<%lO%QjHQSmYOy%Qz;'S%Q;'S;=`%c<%lO%QnHcSl^Oy%Qz;'S%Q;'S;=`%c<%lO%QjHtSpYOy%Qz;'S%Q;'S;=`%c<%lO%QjIVSoYOy%Qz;'S%Q;'S;=`%c<%lO%QfIhU!mQOy%Qz!_%Q!_!`6m!`;'S%Q;'S;=`%c<%lO%Q`I}P;=`<%l$q",
        tokenizers: [ deleteGroupBackward, ie_11up, deleteCharForward, deleteCharBackward, 1, 2, 3, 4, new LocalTokenGroup("m~RRYZ[z{a~~g~aO#v~~dP!P!Qg~lO#w~~", 28, 129) ],
        topRules: {
            StyleSheet: [ 0, 6 ],
            Styles: [ 1, 105 ]
        },
        specialized: [ {
            term: 124,
            get: value => spec_callee[value] || -1
        }, {
            term: 125,
            get: value => spec_queryIdentifier[value] || -1
        }, {
            term: 4,
            get: value => spec_QueryCallee[value] || -1
        }, {
            term: 25,
            get: value => spec_AtKeyword[value] || -1
        }, {
            term: 123,
            get: value => spec_identifier$1[value] || -1
        } ],
        tokenPrec: 1963
    });
    let _properties = null;
    function properties() {
        if (!_properties && "object" == typeof document && document.body) {
            var prop, style = document.body["style"], names = [], seen = new Set();
            for (prop in style) "cssText" != prop && "cssFloat" != prop && "string" == typeof style[prop] && (/[A-Z]/.test(prop) && (prop = prop.replace(/[A-Z]/g, ch => "-" + ch.toLowerCase())), 
            seen.has(prop) || (names.push(prop), seen.add(prop)));
            _properties = names.sort().map(name => ({
                type: "property",
                label: name,
                apply: name + ": "
            }));
        }
        return _properties || [];
    }
    const pseudoClasses = [ "active", "after", "any-link", "autofill", "backdrop", "before", "checked", "cue", "default", "defined", "disabled", "empty", "enabled", "file-selector-button", "first", "first-child", "first-letter", "first-line", "first-of-type", "focus", "focus-visible", "focus-within", "fullscreen", "has", "host", "host-context", "hover", "in-range", "indeterminate", "invalid", "is", "lang", "last-child", "last-of-type", "left", "link", "marker", "modal", "not", "nth-child", "nth-last-child", "nth-last-of-type", "nth-of-type", "only-child", "only-of-type", "optional", "out-of-range", "part", "placeholder", "placeholder-shown", "read-only", "read-write", "required", "right", "root", "scope", "selection", "slotted", "target", "target-text", "valid", "visited", "where" ].map(name => ({
        type: "class",
        label: name
    })), values = [ "above", "absolute", "activeborder", "additive", "activecaption", "after-white-space", "ahead", "alias", "all", "all-scroll", "alphabetic", "alternate", "always", "antialiased", "appworkspace", "asterisks", "attr", "auto", "auto-flow", "avoid", "avoid-column", "avoid-page", "avoid-region", "axis-pan", "background", "backwards", "baseline", "below", "bidi-override", "blink", "block", "block-axis", "bold", "bolder", "border", "border-box", "both", "bottom", "break", "break-all", "break-word", "bullets", "button", "button-bevel", "buttonface", "buttonhighlight", "buttonshadow", "buttontext", "calc", "capitalize", "caps-lock-indicator", "caption", "captiontext", "caret", "cell", "center", "checkbox", "circle", "cjk-decimal", "clear", "clip", "close-quote", "col-resize", "collapse", "color", "color-burn", "color-dodge", "column", "column-reverse", "compact", "condensed", "contain", "content", "contents", "content-box", "context-menu", "continuous", "copy", "counter", "counters", "cover", "crop", "cross", "crosshair", "currentcolor", "cursive", "cyclic", "darken", "dashed", "decimal", "decimal-leading-zero", "default", "default-button", "dense", "destination-atop", "destination-in", "destination-out", "destination-over", "difference", "disc", "discard", "disclosure-closed", "disclosure-open", "document", "dot-dash", "dot-dot-dash", "dotted", "double", "down", "e-resize", "ease", "ease-in", "ease-in-out", "ease-out", "element", "ellipse", "ellipsis", "embed", "end", "ethiopic-abegede-gez", "ethiopic-halehame-aa-er", "ethiopic-halehame-gez", "ew-resize", "exclusion", "expanded", "extends", "extra-condensed", "extra-expanded", "fantasy", "fast", "fill", "fill-box", "fixed", "flat", "flex", "flex-end", "flex-start", "footnotes", "forwards", "from", "geometricPrecision", "graytext", "grid", "groove", "hand", "hard-light", "help", "hidden", "hide", "higher", "highlight", "highlighttext", "horizontal", "hsl", "hsla", "hue", "icon", "ignore", "inactiveborder", "inactivecaption", "inactivecaptiontext", "infinite", "infobackground", "infotext", "inherit", "initial", "inline", "inline-axis", "inline-block", "inline-flex", "inline-grid", "inline-table", "inset", "inside", "intrinsic", "invert", "italic", "justify", "keep-all", "landscape", "large", "larger", "left", "level", "lighter", "lighten", "line-through", "linear", "linear-gradient", "lines", "list-item", "listbox", "listitem", "local", "logical", "loud", "lower", "lower-hexadecimal", "lower-latin", "lower-norwegian", "lowercase", "ltr", "luminosity", "manipulation", "match", "matrix", "matrix3d", "medium", "menu", "menutext", "message-box", "middle", "min-intrinsic", "mix", "monospace", "move", "multiple", "multiple_mask_images", "multiply", "n-resize", "narrower", "ne-resize", "nesw-resize", "no-close-quote", "no-drop", "no-open-quote", "no-repeat", "none", "normal", "not-allowed", "nowrap", "ns-resize", "numbers", "numeric", "nw-resize", "nwse-resize", "oblique", "opacity", "open-quote", "optimizeLegibility", "optimizeSpeed", "outset", "outside", "outside-shape", "overlay", "overline", "padding", "padding-box", "painted", "page", "paused", "perspective", "pinch-zoom", "plus-darker", "plus-lighter", "pointer", "polygon", "portrait", "pre", "pre-line", "pre-wrap", "preserve-3d", "progress", "push-button", "radial-gradient", "radio", "read-only", "read-write", "read-write-plaintext-only", "rectangle", "region", "relative", "repeat", "repeating-linear-gradient", "repeating-radial-gradient", "repeat-x", "repeat-y", "reset", "reverse", "rgb", "rgba", "ridge", "right", "rotate", "rotate3d", "rotateX", "rotateY", "rotateZ", "round", "row", "row-resize", "row-reverse", "rtl", "run-in", "running", "s-resize", "sans-serif", "saturation", "scale", "scale3d", "scaleX", "scaleY", "scaleZ", "screen", "scroll", "scrollbar", "scroll-position", "se-resize", "self-start", "self-end", "semi-condensed", "semi-expanded", "separate", "serif", "show", "single", "skew", "skewX", "skewY", "skip-white-space", "slide", "slider-horizontal", "slider-vertical", "sliderthumb-horizontal", "sliderthumb-vertical", "slow", "small", "small-caps", "small-caption", "smaller", "soft-light", "solid", "source-atop", "source-in", "source-out", "source-over", "space", "space-around", "space-between", "space-evenly", "spell-out", "square", "start", "static", "status-bar", "stretch", "stroke", "stroke-box", "sub", "subpixel-antialiased", "svg_masks", "super", "sw-resize", "symbolic", "symbols", "system-ui", "table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row", "table-row-group", "text", "text-bottom", "text-top", "textarea", "textfield", "thick", "thin", "threeddarkshadow", "threedface", "threedhighlight", "threedlightshadow", "threedshadow", "to", "top", "transform", "translate", "translate3d", "translateX", "translateY", "translateZ", "transparent", "ultra-condensed", "ultra-expanded", "underline", "unidirectional-pan", "unset", "up", "upper-latin", "uppercase", "url", "var", "vertical", "vertical-text", "view-box", "visible", "visibleFill", "visiblePainted", "visibleStroke", "visual", "w-resize", "wait", "wave", "wider", "window", "windowframe", "windowtext", "words", "wrap", "wrap-reverse", "x-large", "x-small", "xor", "xx-large", "xx-small" ].map(name => ({
        type: "keyword",
        label: name
    })).concat([ "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "grey", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgray", "lightgreen", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "rebeccapurple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen" ].map(name => ({
        type: "constant",
        label: name
    }))), tags = [ "a", "abbr", "address", "article", "aside", "b", "bdi", "bdo", "blockquote", "body", "br", "button", "canvas", "caption", "cite", "code", "col", "colgroup", "dd", "del", "details", "dfn", "dialog", "div", "dl", "dt", "em", "figcaption", "figure", "footer", "form", "header", "hgroup", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "meter", "nav", "ol", "output", "p", "pre", "ruby", "section", "select", "small", "source", "span", "strong", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "tr", "u", "ul" ].map(name => ({
        type: "type",
        label: name
    })), atRules = [ "@charset", "@color-profile", "@container", "@counter-style", "@font-face", "@font-feature-values", "@font-palette-values", "@import", "@keyframes", "@layer", "@media", "@namespace", "@page", "@position-try", "@property", "@scope", "@starting-style", "@supports", "@view-transition" ].map(label => ({
        type: "keyword",
        label: label
    })), identifier$1 = /^(\w[\w-]*|-\w[\w-]*|)$/, variable = /^-(-[\w-]*)?$/;
    const VariablesByNode = new NodeWeakMap(), declSelector = [ "Declaration" ];
    const cssCompletionSource = (isVariable => context => {
        var {
            state,
            pos
        } = context, node = syntaxTree(state).resolveInner(pos, -1), isDash = node.type.isError && node.from == node.to - 1 && "-" == state.doc.sliceString(node.from, node.to);
        if ("PropertyName" == node.name || (isDash || "TagName" == node.name) && /^(Block|Styles)$/.test(node.resolve(node.to).name)) return {
            from: node.from,
            options: properties(),
            validFor: identifier$1
        };
        if ("ValueName" == node.name) return {
            from: node.from,
            options: values,
            validFor: identifier$1
        };
        if ("PseudoClassName" == node.name) return {
            from: node.from,
            options: pseudoClasses,
            validFor: identifier$1
        };
        if (isVariable(node) || (context.explicit || isDash) && function(node, doc) {
            return "ArgList" == (node = "(" != node.name && !node.type.isError ? node : node.parent || node).name && "Callee" == (null == (node = null == (node = node.parent) ? void 0 : node.firstChild) ? void 0 : node.name) ? "var" == doc.sliceString(node.from, node.to) : void 0;
        }(node, state.doc)) return {
            from: isVariable(node) || isDash ? node.from : pos,
            options: function variableNames(doc, node, isVariable) {
                if (4096 < node.to - node.from) {
                    var known = VariablesByNode.get(node);
                    if (known) return known;
                    var result = [], seen = new Set(), cursor = node.cursor(IterMode.IncludeAnonymous);
                    if (cursor.firstChild()) do {
                        for (var option of variableNames(doc, cursor.node, isVariable)) seen.has(option.label) || (seen.add(option.label), 
                        result.push(option));
                    } while (cursor.nextSibling());
                    return VariablesByNode.set(node, result), result;
                }
                {
                    let result = [], seen = new Set();
                    return node.cursor().iterate(node => {
                        var _a;
                        isVariable(node) && node.matchContext(declSelector) && ":" == (null == (_a = node.node.nextSibling) ? void 0 : _a.name) && (_a = doc.sliceString(node.from, node.to), 
                        seen.has(_a) || (seen.add(_a), result.push({
                            label: _a,
                            type: "variable"
                        })));
                    }), result;
                }
            }(state.doc, function(node) {
                for (let cur = node; ;) {
                    if (cur.type.isTop) return cur;
                    if (!(cur = cur.parent)) return node;
                }
            }(node), isVariable),
            validFor: variable
        };
        if ("TagName" != node.name) return "AtKeyword" == node.name ? {
            from: node.from,
            options: atRules,
            validFor: identifier$1
        } : context.explicit ? (state = (isDash = node.resolve(pos)).childBefore(pos)) && ":" == state.name && "PseudoClassSelector" == isDash.name ? {
            from: pos,
            options: pseudoClasses,
            validFor: identifier$1
        } : state && ":" == state.name && "Declaration" == isDash.name || "ArgList" == isDash.name ? {
            from: pos,
            options: values,
            validFor: identifier$1
        } : "Block" == isDash.name || "Styles" == isDash.name ? {
            from: pos,
            options: properties(),
            validFor: identifier$1
        } : null : null;
        for (let parent = node["parent"]; parent; parent = parent.parent) if ("Block" == parent.name) return {
            from: node.from,
            options: properties(),
            validFor: identifier$1
        };
        return {
            from: node.from,
            options: tags,
            validFor: identifier$1
        };
    })(n => "VariableName" == n.name), cssLanguage = LRLanguage.define({
        name: "css",
        parser: indentLess.configure({
            props: [ indentNodeProp.add({
                Declaration: continuedIndent()
            }), foldNodeProp.add({
                "Block KeyframeList": foldInside
            }) ]
        }),
        languageData: {
            commentTokens: {
                block: {
                    open: "/*",
                    close: "*/"
                }
            },
            indentOnInput: /^\s*\}$/,
            wordChars: "-"
        }
    });
    const space$1 = [ 9, 10, 11, 12, 13, 32, 133, 160, 5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288 ];
    safari = new ContextTracker({
        start: !1,
        shift(context, term) {
            return 5 == term || 6 == term || 319 == term ? context : 320 == term;
        },
        strict: !1
    }), cursorDocStart = new ExternalTokenizer((input, stack) => {
        var next = input["next"];
        125 != next && -1 != next && !stack.context || input.acceptToken(317);
    }, {
        contextual: !0,
        fallback: !0
    }), selectDocStart = new ExternalTokenizer((input, stack) => {
        var after, next = input["next"];
        -1 < space$1.indexOf(next) || 47 == next && (47 == (after = input.peek(1)) || 42 == after) || 125 == next || 59 == next || -1 == next || stack.context || input.acceptToken(315);
    }, {
        contextual: !0
    }), cursorDocEnd = new ExternalTokenizer((input, stack) => {
        91 != input.next || stack.context || input.acceptToken(316);
    }, {
        contextual: !0
    }), selectDocEnd = new ExternalTokenizer((input, stack) => {
        var next = input["next"];
        43 == next || 45 == next ? (input.advance(), next == input.next && (input.advance(), 
        stack = !stack.context && stack.canShift(1), input.acceptToken(stack ? 1 : 2))) : 63 == next && 46 == input.peek(1) && (input.advance(), 
        input.advance(), input.next < 48 || 57 < input.next) && input.acceptToken(3);
    }, {
        contextual: !0
    });
    function identifierChar(ch, start) {
        return 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122 || 95 == ch || 192 <= ch || !start && 48 <= ch && ch <= 57;
    }
    gecko = new ExternalTokenizer((input, stack) => {
        if (60 == input.next && stack.dialectEnabled(0) && (input.advance(), 47 != input.next)) {
            let back = 0;
            for (;-1 < space$1.indexOf(input.next); ) input.advance(), back++;
            if (identifierChar(input.next, !0)) {
                for (input.advance(), back++; identifierChar(input.next, !1); ) input.advance(), 
                back++;
                for (;-1 < space$1.indexOf(input.next); ) input.advance(), back++;
                if (44 == input.next) return;
                for (let i = 0; ;i++) {
                    if (7 == i) {
                        if (identifierChar(input.next, !0)) break;
                        return;
                    }
                    if (input.next != "extends".charCodeAt(i)) break;
                    input.advance(), back++;
                }
            }
            input.acceptToken(4, -back);
        }
    }), punctuation = styleTags({
        "get set async static": tags$1.modifier,
        "for while do if else switch try catch finally return throw break continue default case": tags$1.controlKeyword,
        "in of await yield void typeof delete instanceof as satisfies": tags$1.operatorKeyword,
        "let var const using function class extends": tags$1.definitionKeyword,
        "import export from": tags$1.moduleKeyword,
        "with debugger new": tags$1.keyword,
        TemplateString: tags$1.special(tags$1.string),
        super: tags$1.atom,
        BooleanLiteral: tags$1.bool,
        this: tags$1.self,
        null: tags$1.null,
        Star: tags$1.modifier,
        VariableName: tags$1.variableName,
        "CallExpression/VariableName TaggedTemplateExpression/VariableName": tags$1.function(tags$1.variableName),
        VariableDefinition: tags$1.definition(tags$1.variableName),
        Label: tags$1.labelName,
        PropertyName: tags$1.propertyName,
        PrivatePropertyName: tags$1.special(tags$1.propertyName),
        "CallExpression/MemberExpression/PropertyName": tags$1.function(tags$1.propertyName),
        "FunctionDeclaration/VariableDefinition": tags$1.function(tags$1.definition(tags$1.variableName)),
        "ClassDeclaration/VariableDefinition": tags$1.definition(tags$1.className),
        "NewExpression/VariableName": tags$1.className,
        PropertyDefinition: tags$1.definition(tags$1.propertyName),
        PrivatePropertyDefinition: tags$1.definition(tags$1.special(tags$1.propertyName)),
        UpdateOp: tags$1.updateOperator,
        "LineComment Hashbang": tags$1.lineComment,
        BlockComment: tags$1.blockComment,
        Number: tags$1.number,
        String: tags$1.string,
        Escape: tags$1.escape,
        ArithOp: tags$1.arithmeticOperator,
        LogicOp: tags$1.logicOperator,
        BitOp: tags$1.bitwiseOperator,
        CompareOp: tags$1.compareOperator,
        RegExp: tags$1.regexp,
        Equals: tags$1.definitionOperator,
        Arrow: tags$1.function(tags$1.punctuation),
        ": Spread": tags$1.punctuation,
        "( )": tags$1.paren,
        "[ ]": tags$1.squareBracket,
        "{ }": tags$1.brace,
        "InterpolationStart InterpolationEnd": tags$1.special(tags$1.brace),
        ".": tags$1.derefOperator,
        ", ;": tags$1.separator,
        "@": tags$1.meta,
        TypeName: tags$1.typeName,
        TypeDefinition: tags$1.definition(tags$1.typeName),
        "type enum interface implements namespace module declare": tags$1.definitionKeyword,
        "abstract global Privacy readonly override": tags$1.modifier,
        "is keyof unique infer asserts": tags$1.operatorKeyword,
        JSXAttributeValue: tags$1.attributeValue,
        JSXText: tags$1.content,
        "JSXStartTag JSXStartCloseTag JSXSelfCloseEndTag JSXEndTag": tags$1.angleBracket,
        "JSXIdentifier JSXNameSpacedName": tags$1.tagName,
        "JSXAttribute/JSXIdentifier JSXAttribute/JSXNameSpacedName": tags$1.attributeName,
        "JSXBuiltin/JSXIdentifier": tags$1.standard(tags$1.tagName)
    });
    const spec_identifier = {
        __proto__: null,
        export: 20,
        as: 25,
        from: 33,
        default: 36,
        async: 41,
        function: 42,
        in: 52,
        out: 55,
        const: 56,
        extends: 60,
        this: 64,
        true: 72,
        false: 72,
        null: 84,
        void: 88,
        typeof: 92,
        super: 108,
        new: 142,
        delete: 154,
        yield: 163,
        await: 167,
        class: 172,
        public: 235,
        private: 235,
        protected: 235,
        readonly: 237,
        instanceof: 256,
        satisfies: 259,
        import: 292,
        keyof: 349,
        unique: 353,
        infer: 359,
        asserts: 395,
        is: 397,
        abstract: 417,
        implements: 419,
        type: 421,
        let: 424,
        var: 426,
        using: 429,
        interface: 435,
        enum: 439,
        namespace: 445,
        module: 447,
        declare: 451,
        global: 455,
        for: 474,
        of: 483,
        while: 486,
        with: 490,
        do: 494,
        if: 498,
        else: 500,
        switch: 504,
        case: 510,
        try: 516,
        catch: 520,
        finally: 524,
        return: 528,
        throw: 532,
        break: 536,
        continue: 540,
        debugger: 544
    }, spec_word = {
        __proto__: null,
        async: 129,
        get: 131,
        set: 133,
        declare: 195,
        public: 197,
        private: 197,
        protected: 197,
        static: 199,
        abstract: 201,
        override: 203,
        readonly: 209,
        accessor: 211,
        new: 401
    }, spec_LessThan = {
        __proto__: null,
        "<": 193
    };
    ie_edge = LRParser.deserialize({
        version: 14,
        states: "$EOQ%TQlOOO%[QlOOO'_QpOOP(lO`OOO*zQ!0MxO'#CiO+RO#tO'#CjO+aO&jO'#CjO+oO#@ItO'#DaO.QQlO'#DgO.bQlO'#DrO%[QlO'#DzO0fQlO'#ESOOQ!0Lf'#E['#E[O1PQ`O'#EXOOQO'#Ep'#EpOOQO'#Ik'#IkO1XQ`O'#GsO1dQ`O'#EoO1iQ`O'#EoO3hQ!0MxO'#JqO6[Q!0MxO'#JrO6uQ`O'#F]O6zQ,UO'#FtOOQ!0Lf'#Ff'#FfO7VO7dO'#FfO7eQMhO'#F|O9[Q`O'#F{OOQ!0Lf'#Jr'#JrOOQ!0Lb'#Jq'#JqO9aQ`O'#GwOOQ['#K^'#K^O9lQ`O'#IXO9qQ!0LrO'#IYOOQ['#J_'#J_OOQ['#I^'#I^Q`QlOOQ`QlOOO9yQ!L^O'#DvO:QQlO'#EOO:XQlO'#EQO9gQ`O'#GsO:`QMhO'#CoO:nQ`O'#EnO:yQ`O'#EyO;OQMhO'#FeO;mQ`O'#GsOOQO'#K_'#K_O;rQ`O'#K_O<QQ`O'#G{O<QQ`O'#G|O<QQ`O'#HOO9gQ`O'#HRO<wQ`O'#HUO>`Q`O'#CeO>pQ`O'#HbO>xQ`O'#HhO>xQ`O'#HjO`QlO'#HlO>xQ`O'#HnO>xQ`O'#HqO>}Q`O'#HwO?SQ!0LsO'#H}O%[QlO'#IPO?_Q!0LsO'#IRO?jQ!0LsO'#ITO9qQ!0LrO'#IVO?uQ!0MxO'#CiO@wQpO'#DlQOQ`OOO%[QlO'#EQOA_Q`O'#ETO:`QMhO'#EnOAjQ`O'#EnOAuQ!bO'#FeOOQ['#Cg'#CgOOQ!0Lb'#Dq'#DqOOQ!0Lb'#Ju'#JuO%[QlO'#JuOOQO'#Jx'#JxOOQO'#Ig'#IgOBuQpO'#EgOOQ!0Lb'#Ef'#EfOOQ!0Lb'#J|'#J|OCqQ!0MSO'#EgOC{QpO'#EWOOQO'#Jw'#JwODaQpO'#JxOEnQpO'#EWOC{QpO'#EgPE{O&2DjO'#CbPOOO)CD|)CD|OOOO'#I_'#I_OFWO#tO,59UOOQ!0Lh,59U,59UOOOO'#I`'#I`OFfO&jO,59UOFtQ!L^O'#DcOOOO'#Ib'#IbOF{O#@ItO,59{OOQ!0Lf,59{,59{OGZQlO'#IcOGnQ`O'#JsOImQ!fO'#JsO+}QlO'#JsOItQ`O,5:ROJ[Q`O'#EpOJiQ`O'#KSOJtQ`O'#KROJtQ`O'#KROJ|Q`O,5;^OKRQ`O'#KQOOQ!0Ln,5:^,5:^OKYQlO,5:^OMWQ!0MxO,5:fOMwQ`O,5:nONbQ!0LrO'#KPONiQ`O'#KOO9aQ`O'#KOON}Q`O'#KOO! VQ`O,5;]O! [Q`O'#KOO!#aQ!fO'#JrOOQ!0Lh'#Ci'#CiO%[QlO'#ESO!$PQ!fO,5:sOOQS'#Jy'#JyOOQO-E<i-E<iO9gQ`O,5=_O!$gQ`O,5=_O!$lQlO,5;ZO!&oQMhO'#EkO!(YQ`O,5;ZO!(_QlO'#DyO!(iQpO,5;dO!(qQpO,5;dO%[QlO,5;dOOQ['#FT'#FTOOQ['#FV'#FVO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eO%[QlO,5;eOOQ['#FZ'#FZO!)PQlO,5;tOOQ!0Lf,5;y,5;yOOQ!0Lf,5;z,5;zOOQ!0Lf,5;|,5;|O%[QlO'#IoO!+SQ!0LrO,5<iO%[QlO,5;eO!&oQMhO,5;eO!+qQMhO,5;eO!-cQMhO'#E^O%[QlO,5;wOOQ!0Lf,5;{,5;{O!-jQ,UO'#FjO!.gQ,UO'#KWO!.RQ,UO'#KWO!.nQ,UO'#KWOOQO'#KW'#KWO!/SQ,UO,5<SOOOW,5<`,5<`O!/eQlO'#FvOOOW'#In'#InO7VO7dO,5<QO!/lQ,UO'#FxOOQ!0Lf,5<Q,5<QO!0]Q$IUO'#CyOOQ!0Lh'#C}'#C}O!0pO#@ItO'#DRO!1^QMjO,5<eO!1eQ`O,5<hO!3QQ(CWO'#GXO!3_Q`O'#GYO!3dQ`O'#GYO!5SQ(CWO'#G^O!6XQpO'#GbOOQO'#Gn'#GnO!+xQMhO'#GmOOQO'#Gp'#GpO!+xQMhO'#GoO!6zQ$IUO'#JkOOQ!0Lh'#Jk'#JkO!7UQ`O'#JjO!7dQ`O'#JiO!7lQ`O'#CuOOQ!0Lh'#C{'#C{O!7}Q`O'#C}OOQ!0Lh'#DV'#DVOOQ!0Lh'#DX'#DXO1SQ`O'#DZO!+xQMhO'#GPO!+xQMhO'#GRO!8SQ`O'#GTO!8XQ`O'#GUO!3dQ`O'#G[O!+xQMhO'#GaO<QQ`O'#JjO!8^Q`O'#EqO!8{Q`O,5<gOOQ!0Lb'#Cr'#CrO!9TQ`O'#ErO!9}QpO'#EsOOQ!0Lb'#KQ'#KQO!:UQ!0LrO'#K`O9qQ!0LrO,5=cO`QlO,5>sOOQ['#Jg'#JgOOQ[,5>t,5>tOOQ[-E<[-E<[O!<TQ!0MxO,5:bO!9xQpO,5:`O!>nQ!0MxO,5:jO%[QlO,5:jO!AUQ!0MxO,5:lOOQO,5@y,5@yO!AuQMhO,5=_O!BTQ!0LrO'#JhO9[Q`O'#JhO!BfQ!0LrO,59ZO!BqQpO,59ZO!ByQMhO,59ZO:`QMhO,59ZO!CUQ`O,5;ZO!C^Q`O'#HaO!CrQ`O'#KcO%[QlO,5;}O!9xQpO,5<PO!CzQ`O,5=zO!DPQ`O,5=zO!DUQ`O,5=zO9qQ!0LrO,5=zO<QQ`O,5=jOOQO'#Cy'#CyO!DdQpO,5=gO!DlQMhO,5=hO!DwQ`O,5=jO!D|Q!bO,5=mO!EUQ`O'#K_O>}Q`O'#HWO9gQ`O'#HYO!EZQ`O'#HYO:`QMhO'#H[O!E`Q`O'#H[OOQ[,5=p,5=pO!EeQ`O'#H]O!EvQ`O'#CoO!E{Q`O,59PO!FVQ`O,59PO!H[QlO,59POOQ[,59P,59PO!HlQ!0LrO,59PO%[QlO,59PO!JwQlO'#HdOOQ['#He'#HeOOQ['#Hf'#HfO`QlO,5=|O!K_Q`O,5=|O`QlO,5>SO`QlO,5>UO!KdQ`O,5>WO`QlO,5>YO!KiQ`O,5>]O!KnQlO,5>cOOQ[,5>i,5>iO%[QlO,5>iO9qQ!0LrO,5>kOOQ[,5>m,5>mO# xQ`O,5>mOOQ[,5>o,5>oO# xQ`O,5>oOOQ[,5>q,5>qO#!fQpO'#D_O%[QlO'#JuO##XQpO'#JuO##cQpO'#DmO##tQpO'#DmO#&VQlO'#DmO#&^Q`O'#JtO#&fQ`O,5:WO#&kQ`O'#EtO#&yQ`O'#KTO#'RQ`O,5;_O#'WQpO'#DmO#'eQpO'#EVOOQ!0Lf,5:o,5:oO%[QlO,5:oO#'lQ`O,5:oO>}Q`O,5;YO!BqQpO,5;YO!ByQMhO,5;YO:`QMhO,5;YO#'tQ`O,5@aO#'yQ07dO,5:sOOQO-E<e-E<eO#)PQ!0MSO,5;ROC{QpO,5:rO#)ZQpO,5:rOC{QpO,5;RO!BfQ!0LrO,5:rOOQ!0Lb'#Ej'#EjOOQO,5;R,5;RO%[QlO,5;RO#)hQ!0LrO,5;RO#)sQ!0LrO,5;RO!BqQpO,5:rOOQO,5;X,5;XO#*RQ!0LrO,5;RPOOO'#I]'#I]P#*gO&2DjO,58|POOO,58|,58|OOOO-E<]-E<]OOQ!0Lh1G.p1G.pOOOO-E<^-E<^OOOO,59},59}O#*rQ!bO,59}OOOO-E<`-E<`OOQ!0Lf1G/g1G/gO#*wQ!fO,5>}O+}QlO,5>}OOQO,5?T,5?TO#+RQlO'#IcOOQO-E<a-E<aO#+`Q`O,5@_O#+hQ!fO,5@_O#+oQ`O,5@mOOQ!0Lf1G/m1G/mO%[QlO,5@nO#+wQ`O'#IiOOQO-E<g-E<gO#+oQ`O,5@mOOQ!0Lb1G0x1G0xOOQ!0Ln1G/x1G/xOOQ!0Ln1G0Y1G0YO%[QlO,5@kO#,]Q!0LrO,5@kO#,nQ!0LrO,5@kO#,uQ`O,5@jO9aQ`O,5@jO#,}Q`O,5@jO#-]Q`O'#IlO#,uQ`O,5@jOOQ!0Lb1G0w1G0wO!(iQpO,5:uO!(tQpO,5:uOOQS,5:w,5:wO#-}QdO,5:wO#.VQMhO1G2yO9gQ`O1G2yOOQ!0Lf1G0u1G0uO#.eQ!0MxO1G0uO#/jQ!0MvO,5;VOOQ!0Lh'#GW'#GWO#0WQ!0MzO'#JkO!$lQlO1G0uO#2cQ!fO'#JvO%[QlO'#JvO#2mQ`O,5:eOOQ!0Lh'#D_'#D_OOQ!0Lf1G1O1G1OO%[QlO1G1OOOQ!0Lf1G1f1G1fO#2rQ`O1G1OO#5WQ!0MxO1G1PO#5_Q!0MxO1G1PO#7uQ!0MxO1G1PO#7|Q!0MxO1G1PO#:dQ!0MxO1G1PO#<zQ!0MxO1G1PO#=RQ!0MxO1G1PO#=YQ!0MxO1G1PO#?pQ!0MxO1G1PO#?wQ!0MxO1G1PO#BUQ?MtO'#CiO#DPQ?MtO1G1`O#DWQ?MtO'#JrO#DkQ!0MxO,5?ZOOQ!0Lb-E<m-E<mO#FxQ!0MxO1G1PO#GuQ!0MzO1G1POOQ!0Lf1G1P1G1PO#HxQMjO'#J{O#ISQ`O,5:xO#IXQ!0MxO1G1cO#I{Q,UO,5<WO#JTQ,UO,5<XO#J]Q,UO'#FoO#JtQ`O'#FnOOQO'#KX'#KXOOQO'#Im'#ImO#JyQ,UO1G1nOOQ!0Lf1G1n1G1nOOOW1G1y1G1yO#K[Q?MtO'#JqO#KfQ`O,5<bO!)PQlO,5<bOOOW-E<l-E<lOOQ!0Lf1G1l1G1lO#KkQpO'#KWOOQ!0Lf,5<d,5<dO#KsQpO,5<dO#KxQMhO'#DTOOOO'#Ia'#IaO#LPO#@ItO,59mOOQ!0Lh,59m,59mO%[QlO1G2PO!8XQ`O'#IqO#L[Q`O,5<zOOQ!0Lh,5<w,5<wO!+xQMhO'#ItO#LxQMjO,5=XO!+xQMhO'#IvO#MkQMjO,5=ZO!&oQMhO,5=]OOQO1G2S1G2SO#MuQ!dO'#CrO#NYQ(CWO'#ErO$ _QpO'#GbO$ uQ!dO,5<sO$ |Q`O'#KZO9aQ`O'#KZO$![Q`O,5<uO!+xQMhO,5<tO$!aQ`O'#GZO$!rQ`O,5<tO$!wQ!dO'#GWO$#UQ!dO'#K[O$#`Q`O'#K[O!&oQMhO'#K[O$#eQ`O,5<xO$#jQlO'#JuO$#tQpO'#GcO##tQpO'#GcO$$VQ`O'#GgO!3dQ`O'#GkO$$[Q!0LrO'#IsO$$gQpO,5<|OOQ!0Lp,5<|,5<|O$$nQpO'#GcO$${QpO'#GdO$%^QpO'#GdO$%cQMjO,5=XO$%sQMjO,5=ZOOQ!0Lh,5=^,5=^O!+xQMhO,5@UO!+xQMhO,5@UO$&TQ`O'#IxO$&iQ`O,5@TO$&qQ`O,59aOOQ!0Lh,59i,59iO$'hQ$IYO,59uOOQ!0Lh'#Jo'#JoO$(ZQMjO,5<kO$(|QMjO,5<mO@oQ`O,5<oOOQ!0Lh,5<p,5<pO$)WQ`O,5<vO$)]QMjO,5<{O$)mQ`O,5@UO$){Q`O'#KOO!$lQlO1G2RO$*QQ`O1G2RO9aQ`O'#KRO9aQ`O'#EtO%[QlO'#EtO9aQ`O'#IzO$*VQ!0LrO,5@zOOQ[1G2}1G2}OOQ[1G4_1G4_OOQ!0Lf1G/|1G/|OOQ!0Lf1G/z1G/zO$,XQ!0MxO1G0UOOQ[1G2y1G2yO!&oQMhO1G2yO%[QlO1G2yO#.YQ`O1G2yO$.]QMhO'#EkOOQ!0Lb,5@S,5@SO$.jQ!0LrO,5@SOOQ[1G.u1G.uO!BfQ!0LrO1G.uO!BqQpO1G.uO!ByQMhO1G.uO$.{Q`O1G0uO$/QQ`O'#CiO$/]Q`O'#KdO$/eQ`O,5={O$/jQ`O'#KdO$/oQ`O'#KdO$/}Q`O'#JQO$0]Q`O,5@}O$0eQ!fO1G1iOOQ!0Lf1G1k1G1kO9gQ`O1G3fO@oQ`O1G3fO$0lQ`O1G3fO$0qQ`O1G3fOOQ[1G3f1G3fO!DwQ`O1G3UO!&oQMhO1G3RO$0vQ`O1G3ROOQ[1G3S1G3SO!&oQMhO1G3SO$0{Q`O1G3SO$1TQpO'#HQOOQ[1G3U1G3UO!6SQpO'#I|O!D|Q!bO1G3XOOQ[1G3X1G3XOOQ[,5=r,5=rO$1]QMhO,5=tO9gQ`O,5=tO$$VQ`O,5=vO9[Q`O,5=vO!BqQpO,5=vO!ByQMhO,5=vO:`QMhO,5=vO$1kQ`O'#KbO$1vQ`O,5=wOOQ[1G.k1G.kO$1{Q!0LrO1G.kO@oQ`O1G.kO$2WQ`O1G.kO9qQ!0LrO1G.kO$4`Q!fO,5APO$4mQ`O,5APO9aQ`O,5APO$4xQlO,5>OO$5PQ`O,5>OOOQ[1G3h1G3hO`QlO1G3hOOQ[1G3n1G3nOOQ[1G3p1G3pO>xQ`O1G3rO$5UQlO1G3tO$9YQlO'#HsOOQ[1G3w1G3wO$9gQ`O'#HyO>}Q`O'#H{OOQ[1G3}1G3}O$9oQlO1G3}O9qQ!0LrO1G4TOOQ[1G4V1G4VOOQ!0Lb'#G_'#G_O9qQ!0LrO1G4XO9qQ!0LrO1G4ZO$=vQ`O,5@aO!)PQlO,5;`O9aQ`O,5;`O>}Q`O,5:XO!)PQlO,5:XO!BqQpO,5:XO$={Q?MtO,5:XOOQO,5;`,5;`O$>VQpO'#IdO$>mQ`O,5@`OOQ!0Lf1G/r1G/rO$>uQpO'#IjO$?PQ`O,5@oOOQ!0Lb1G0y1G0yO##tQpO,5:XOOQO'#If'#IfO$?XQpO,5:qOOQ!0Ln,5:q,5:qO#'oQ`O1G0ZOOQ!0Lf1G0Z1G0ZO%[QlO1G0ZOOQ!0Lf1G0t1G0tO>}Q`O1G0tO!BqQpO1G0tO!ByQMhO1G0tOOQ!0Lb1G5{1G5{O!BfQ!0LrO1G0^OOQO1G0m1G0mO%[QlO1G0mO$?`Q!0LrO1G0mO$?kQ!0LrO1G0mO!BqQpO1G0^OC{QpO1G0^O$?yQ!0LrO1G0mOOQO1G0^1G0^O$@_Q!0MxO1G0mPOOO-E<Z-E<ZPOOO1G.h1G.hOOOO1G/i1G/iO$@iQ!bO,5<iO$@qQ!fO1G4iOOQO1G4o1G4oO%[QlO,5>}O$@{Q`O1G5yO$ATQ`O1G6XO$A]Q!fO1G6YO9aQ`O,5?TO$AgQ!0MxO1G6VO%[QlO1G6VO$AwQ!0LrO1G6VO$BYQ`O1G6UO$BYQ`O1G6UO9aQ`O1G6UO$BbQ`O,5?WO9aQ`O,5?WOOQO,5?W,5?WO$BvQ`O,5?WO$){Q`O,5?WOOQO-E<j-E<jOOQS1G0a1G0aOOQS1G0c1G0cO#.QQ`O1G0cOOQ[7+(e7+(eO!&oQMhO7+(eO%[QlO7+(eO$CUQ`O7+(eO$CaQMhO7+(eO$CoQ!0MzO,5=XO$EzQ!0MzO,5=ZO$HVQ!0MzO,5=XO$JhQ!0MzO,5=ZO$LyQ!0MzO,59uO% OQ!0MzO,5<kO%#ZQ!0MzO,5<mO%%fQ!0MzO,5<{OOQ!0Lf7+&a7+&aO%'wQ!0MxO7+&aO%(kQlO'#IeO%(xQ`O,5@bO%)QQ!fO,5@bOOQ!0Lf1G0P1G0PO%)[Q`O7+&jOOQ!0Lf7+&j7+&jO%)aQ?MtO,5:fO%[QlO7+&zO%)kQ?MtO,5:bO%)xQ?MtO,5:jO%*SQ?MtO,5:lO%*^QMhO'#IhO%*hQ`O,5@gOOQ!0Lh1G0d1G0dOOQO1G1r1G1rOOQO1G1s1G1sO%*pQ!jO,5<ZO!)PQlO,5<YOOQO-E<k-E<kOOQ!0Lf7+'Y7+'YOOOW7+'e7+'eOOOW1G1|1G1|O%*{Q`O1G1|OOQ!0Lf1G2O1G2OOOOO,59o,59oO%+QQ!dO,59oOOOO-E<_-E<_OOQ!0Lh1G/X1G/XO%+XQ!0MxO7+'kOOQ!0Lh,5?],5?]O%+{QMhO1G2fP%,SQ`O'#IqPOQ!0Lh-E<o-E<oO%,pQMjO,5?`OOQ!0Lh-E<r-E<rO%-cQMjO,5?bOOQ!0Lh-E<t-E<tO%-mQ!dO1G2wO%-tQ!dO'#CrO%.[QMhO'#KRO$#jQlO'#JuOOQ!0Lh1G2_1G2_O%.cQ`O'#IpO%.wQ`O,5@uO%.wQ`O,5@uO%/PQ`O,5@uO%/[Q`O,5@uOOQO1G2a1G2aO%/jQMjO1G2`O!+xQMhO1G2`O%/zQ(CWO'#IrO%0XQ`O,5@vO!&oQMhO,5@vO%0aQ!dO,5@vOOQ!0Lh1G2d1G2dO%2qQ!fO'#CiO%2{Q`O,5=POOQ!0Lb,5<},5<}O%3TQpO,5<}OOQ!0Lb,5=O,5=OOClQ`O,5<}O%3`QpO,5<}OOQ!0Lb,5=R,5=RO$){Q`O,5=VOOQO,5?_,5?_OOQO-E<q-E<qOOQ!0Lp1G2h1G2hO##tQpO,5<}O$#jQlO,5=PO%3nQ`O,5=OO%3yQpO,5=OO!+xQMhO'#ItO%4sQMjO1G2sO!+xQMhO'#IvO%5fQMjO1G2uO%5pQMjO1G5pO%5zQMjO1G5pOOQO,5?d,5?dOOQO-E<v-E<vOOQO1G.{1G.{O!9xQpO,59wO%[QlO,59wOOQ!0Lh,5<j,5<jO%6XQ`O1G2ZO!+xQMhO1G2bO!+xQMhO1G5pO!+xQMhO1G5pO%6^Q!0MxO7+'mOOQ!0Lf7+'m7+'mO!$lQlO7+'mO%7QQ`O,5;`OOQ!0Lb,5?f,5?fOOQ!0Lb-E<x-E<xO%7VQ!dO'#K]O#'oQ`O7+(eO4UQ!fO7+(eO$CXQ`O7+(eO%7aQ!0MvO'#CiO%7tQ!0MvO,5=SO%8fQ`O,5=SO%8nQ`O,5=SOOQ!0Lb1G5n1G5nOOQ[7+$a7+$aO!BfQ!0LrO7+$aO!BqQpO7+$aO!$lQlO7+&aO%8sQ`O'#JPO%9[Q`O,5AOOOQO1G3g1G3gO9gQ`O,5AOO%9[Q`O,5AOO%9dQ`O,5AOOOQO,5?l,5?lOOQO-E=O-E=OOOQ!0Lf7+'T7+'TO%9iQ`O7+)QO9qQ!0LrO7+)QO9gQ`O7+)QO@oQ`O7+)QOOQ[7+(p7+(pO%9nQ!0MvO7+(mO!&oQMhO7+(mO!DrQ`O7+(nOOQ[7+(n7+(nO!&oQMhO7+(nO%9xQ`O'#KaO%:TQ`O,5=lOOQO,5?h,5?hOOQO-E<z-E<zOOQ[7+(s7+(sO%;gQpO'#HZOOQ[1G3`1G3`O!&oQMhO1G3`O%[QlO1G3`O%;nQ`O1G3`O%;yQMhO1G3`O9qQ!0LrO1G3bO$$VQ`O1G3bO9[Q`O1G3bO!BqQpO1G3bO!ByQMhO1G3bO%<XQ`O'#JOO%<mQ`O,5@|O%<uQpO,5@|OOQ!0Lb1G3c1G3cOOQ[7+$V7+$VO@oQ`O7+$VO9qQ!0LrO7+$VO%=QQ`O7+$VO%[QlO1G6kO%[QlO1G6lO%=VQ!0LrO1G6kO%=aQlO1G3jO%=hQ`O1G3jO%=mQlO1G3jOOQ[7+)S7+)SO9qQ!0LrO7+)^O`QlO7+)`OOQ['#Kg'#KgOOQ['#JR'#JRO%=tQlO,5>_OOQ[,5>_,5>_O%[QlO'#HtO%>RQ`O'#HvOOQ[,5>e,5>eO9aQ`O,5>eOOQ[,5>g,5>gOOQ[7+)i7+)iOOQ[7+)o7+)oOOQ[7+)s7+)sOOQ[7+)u7+)uO%>WQpO1G5{O%>rQ?MtO1G0zO%>|Q`O1G0zOOQO1G/s1G/sO%?XQ?MtO1G/sO>}Q`O1G/sO!)PQlO'#DmOOQO,5?O,5?OOOQO-E<b-E<bOOQO,5?U,5?UOOQO-E<h-E<hO!BqQpO1G/sOOQO-E<d-E<dOOQ!0Ln1G0]1G0]OOQ!0Lf7+%u7+%uO#'oQ`O7+%uOOQ!0Lf7+&`7+&`O>}Q`O7+&`O!BqQpO7+&`OOQO7+%x7+%xO$@_Q!0MxO7+&XOOQO7+&X7+&XO%[QlO7+&XO%?cQ!0LrO7+&XO!BfQ!0LrO7+%xO!BqQpO7+%xO%?nQ!0LrO7+&XO%?|Q!0MxO7++qO%[QlO7++qO%@^Q`O7++pO%@^Q`O7++pOOQO1G4r1G4rO9aQ`O1G4rO%@fQ`O1G4rOOQS7+%}7+%}O#'oQ`O<<LPO4UQ!fO<<LPO%@tQ`O<<LPOOQ[<<LP<<LPO!&oQMhO<<LPO%[QlO<<LPO%@|Q`O<<LPO%AXQ!0MzO,5?`O%CdQ!0MzO,5?bO%EoQ!0MzO1G2`O%HQQ!0MzO1G2sO%J]Q!0MzO1G2uO%LhQ!fO,5?PO%[QlO,5?POOQO-E<c-E<cO%LrQ`O1G5|OOQ!0Lf<<JU<<JUO%LzQ?MtO1G0uO& RQ?MtO1G1PO& YQ?MtO1G1PO&#ZQ?MtO1G1PO&#bQ?MtO1G1PO&%cQ?MtO1G1PO&'dQ?MtO1G1PO&'kQ?MtO1G1PO&'rQ?MtO1G1PO&)sQ?MtO1G1PO&)zQ?MtO1G1PO&*RQ!0MxO<<JfO&+yQ?MtO1G1PO&,vQ?MvO1G1PO&-yQ?MvO'#JkO&0PQ?MtO1G1cO&0^Q?MtO1G0UO&0hQMjO,5?SOOQO-E<f-E<fO!)PQlO'#FqOOQO'#KY'#KYOOQO1G1u1G1uO&0rQ`O1G1tO&0wQ?MtO,5?ZOOOW7+'h7+'hOOOO1G/Z1G/ZO&1RQ!dO1G4wOOQ!0Lh7+(Q7+(QP!&oQMhO,5?]O!+xQMhO7+(cO&1YQ`O,5?[O9aQ`O,5?[OOQO-E<n-E<nO&1hQ`O1G6aO&1hQ`O1G6aO&1pQ`O1G6aO&1{QMjO7+'zO&2]Q!dO,5?^O&2gQ`O,5?^O!&oQMhO,5?^OOQO-E<p-E<pO&2lQ!dO1G6bO&2vQ`O1G6bO&3OQ`O1G2kO!&oQMhO1G2kOOQ!0Lb1G2i1G2iOOQ!0Lb1G2j1G2jO%3TQpO1G2iO!BqQpO1G2iOClQ`O1G2iOOQ!0Lb1G2q1G2qO&3TQpO1G2iO&3cQ`O1G2kO$){Q`O1G2jOClQ`O1G2jO$#jQlO1G2kO&3kQ`O1G2jO&4_QMjO,5?`OOQ!0Lh-E<s-E<sO&5QQMjO,5?bOOQ!0Lh-E<u-E<uO!+xQMhO7++[OOQ!0Lh1G/c1G/cO&5[Q`O1G/cOOQ!0Lh7+'u7+'uO&5aQMjO7+'|O&5qQMjO7++[O&5{QMjO7++[O&6YQ!0MxO<<KXOOQ!0Lf<<KX<<KXO&6|Q`O1G0zO!&oQMhO'#IyO&7RQ`O,5@wO&9TQ!fO<<LPO!&oQMhO1G2nO&9[Q!0LrO1G2nOOQ[<<G{<<G{O!BfQ!0LrO<<G{O&9mQ!0MxO<<I{OOQ!0Lf<<I{<<I{OOQO,5?k,5?kO&:aQ`O,5?kO&:fQ`O,5?kOOQO-E<}-E<}O&:tQ`O1G6jO&:tQ`O1G6jO9gQ`O1G6jO@oQ`O<<LlOOQ[<<Ll<<LlO&:|Q`O<<LlO9qQ!0LrO<<LlOOQ[<<LX<<LXO%9nQ!0MvO<<LXOOQ[<<LY<<LYO!DrQ`O<<LYO&;RQpO'#I{O&;^Q`O,5@{O!)PQlO,5@{OOQ[1G3W1G3WOOQO'#I}'#I}O9qQ!0LrO'#I}O&;fQpO,5=uOOQ[,5=u,5=uO&;mQpO'#EgO&;tQpO'#GeO&;yQ`O7+(zO&<OQ`O7+(zOOQ[7+(z7+(zO!&oQMhO7+(zO%[QlO7+(zO&<WQ`O7+(zOOQ[7+(|7+(|O9qQ!0LrO7+(|O$$VQ`O7+(|O9[Q`O7+(|O!BqQpO7+(|O&<cQ`O,5?jOOQO-E<|-E<|OOQO'#H^'#H^O&<nQ`O1G6hO9qQ!0LrO<<GqOOQ[<<Gq<<GqO@oQ`O<<GqO&<vQ`O7+,VO&<{Q`O7+,WO%[QlO7+,VO%[QlO7+,WOOQ[7+)U7+)UO&=QQ`O7+)UO&=VQlO7+)UO&=^Q`O7+)UOOQ[<<Lx<<LxOOQ[<<Lz<<LzOOQ[-E=P-E=POOQ[1G3y1G3yO&=cQ`O,5>`OOQ[,5>b,5>bO&=hQ`O1G4PO9aQ`O7+&fO!)PQlO7+&fOOQO7+%_7+%_O&=mQ?MtO1G6YO>}Q`O7+%_OOQ!0Lf<<Ia<<IaOOQ!0Lf<<Iz<<IzO>}Q`O<<IzOOQO<<Is<<IsO$@_Q!0MxO<<IsO%[QlO<<IsOOQO<<Id<<IdO!BfQ!0LrO<<IdO&=wQ!0LrO<<IsO&>SQ!0MxO<= ]O&>dQ`O<= [OOQO7+*^7+*^O9aQ`O7+*^OOQ[ANAkANAkO&>lQ!fOANAkO!&oQMhOANAkO#'oQ`OANAkO4UQ!fOANAkO&>sQ`OANAkO%[QlOANAkO&>{Q!0MzO7+'zO&A^Q!0MzO,5?`O&CiQ!0MzO,5?bO&EtQ!0MzO7+'|O&HVQ!fO1G4kO&HaQ?MtO7+&aO&JeQ?MvO,5=XO&LlQ?MvO,5=ZO&L|Q?MvO,5=XO&M^Q?MvO,5=ZO&MnQ?MvO,59uO' tQ?MvO,5<kO'#wQ?MvO,5<mO'&]Q?MvO,5<{O'(RQ?MtO7+'kO'(`Q?MtO7+'mO'(mQ`O,5<]OOQO7+'`7+'`OOQ!0Lh7+*c7+*cO'(rQMjO<<K}OOQO1G4v1G4vO'(yQ`O1G4vO')UQ`O1G4vO')dQ`O7++{O')dQ`O7++{O!&oQMhO1G4xO')lQ!dO1G4xO')vQ`O7++|O'*OQ`O7+(VO'*ZQ!dO7+(VOOQ!0Lb7+(T7+(TOOQ!0Lb7+(U7+(UO!BqQpO7+(TOClQ`O7+(TO'*eQ`O7+(VO!&oQMhO7+(VO$){Q`O7+(UO'*jQ`O7+(VOClQ`O7+(UO'*rQMjO<<NvOOQ!0Lh7+$}7+$}O!+xQMhO<<NvO'*|Q!dO,5?eOOQO-E<w-E<wO'+WQ!0MvO7+(YO!&oQMhO7+(YOOQ[AN=gAN=gO9gQ`O1G5VOOQO1G5V1G5VO'+hQ`O1G5VO'+mQ`O7+,UO'+mQ`O7+,UO9qQ!0LrOANBWO@oQ`OANBWOOQ[ANBWANBWOOQ[ANAsANAsOOQ[ANAtANAtO'+uQ`O,5?gOOQO-E<y-E<yO',QQ?MtO1G6gOOQO,5?i,5?iOOQO-E<{-E<{OOQ[1G3a1G3aO',[Q`O,5=POOQ[<<Lf<<LfO!&oQMhO<<LfO&;yQ`O<<LfO',aQ`O<<LfO%[QlO<<LfOOQ[<<Lh<<LhO9qQ!0LrO<<LhO$$VQ`O<<LhO9[Q`O<<LhO',iQpO1G5UO',tQ`O7+,SOOQ[AN=]AN=]O9qQ!0LrOAN=]OOQ[<= q<= qOOQ[<= r<= rO',|Q`O<= qO'-RQ`O<= rOOQ[<<Lp<<LpO'-WQ`O<<LpO'-]QlO<<LpOOQ[1G3z1G3zO>}Q`O7+)kO'-dQ`O<<JQO'-oQ?MtO<<JQOOQO<<Hy<<HyOOQ!0LfAN?fAN?fOOQOAN?_AN?_O$@_Q!0MxOAN?_OOQOAN?OAN?OO%[QlOAN?_OOQO<<Mx<<MxOOQ[G27VG27VO!&oQMhOG27VO#'oQ`OG27VO'-yQ!fOG27VO4UQ!fOG27VO'.QQ`OG27VO'.YQ?MtO<<JfO'.gQ?MvO1G2`O'0]Q?MvO,5?`O'2`Q?MvO,5?bO'4cQ?MvO1G2sO'6fQ?MvO1G2uO'8iQ?MtO<<KXO'8vQ?MtO<<I{OOQO1G1w1G1wO!+xQMhOANAiOOQO7+*b7+*bO'9TQ`O7+*bO'9`Q`O<= gO'9hQ!dO7+*dOOQ!0Lb<<Kq<<KqO$){Q`O<<KqOClQ`O<<KqO'9rQ`O<<KqO!&oQMhO<<KqOOQ!0Lb<<Ko<<KoO!BqQpO<<KoO'9}Q!dO<<KqOOQ!0Lb<<Kp<<KpO':XQ`O<<KqO!&oQMhO<<KqO$){Q`O<<KpO':^QMjOANDbO':hQ!0MvO<<KtOOQO7+*q7+*qO9gQ`O7+*qO':xQ`O<= pOOQ[G27rG27rO9qQ!0LrOG27rO!)PQlO1G5RO';QQ`O7+,RO';YQ`O1G2kO&;yQ`OANBQOOQ[ANBQANBQO!&oQMhOANBQO';_Q`OANBQOOQ[ANBSANBSO9qQ!0LrOANBSO$$VQ`OANBSOOQO'#H_'#H_OOQO7+*p7+*pOOQ[G22wG22wOOQ[ANE]ANE]OOQ[ANE^ANE^OOQ[ANB[ANB[O';gQ`OANB[OOQ[<<MV<<MVO!)PQlOAN?lOOQOG24yG24yO$@_Q!0MxOG24yO#'oQ`OLD,qOOQ[LD,qLD,qO!&oQMhOLD,qO';lQ!fOLD,qO';sQ?MvO7+'zO'=iQ?MvO,5?`O'?lQ?MvO,5?bO'AoQ?MvO7+'|O'CeQMjOG27TOOQO<<M|<<M|OOQ!0LbANA]ANA]O$){Q`OANA]OClQ`OANA]O'CuQ!dOANA]OOQ!0LbANAZANAZO'C|Q`OANA]O!&oQMhOANA]O'DXQ!dOANA]OOQ!0LbANA[ANA[OOQO<<N]<<N]OOQ[LD-^LD-^O'DcQ?MtO7+*mOOQO'#Gf'#GfOOQ[G27lG27lO&;yQ`OG27lO!&oQMhOG27lOOQ[G27nG27nO9qQ!0LrOG27nOOQ[G27vG27vO'DmQ?MtOG25WOOQOLD*eLD*eOOQ[!$(!]!$(!]O#'oQ`O!$(!]O!&oQMhO!$(!]O'DwQ!0MzOG27TOOQ!0LbG26wG26wO$){Q`OG26wO'GYQ`OG26wOClQ`OG26wO'GeQ!dOG26wO!&oQMhOG26wOOQ[LD-WLD-WO&;yQ`OLD-WOOQ[LD-YLD-YOOQ[!)9Ew!)9EwO#'oQ`O!)9EwOOQ!0LbLD,cLD,cO$){Q`OLD,cOClQ`OLD,cO'GlQ`OLD,cO'GwQ!dOLD,cOOQ[!$(!r!$(!rOOQ[!.K;c!.K;cO'HOQ?MvOG27TOOQ!0Lb!$( }!$( }O$){Q`O!$( }OClQ`O!$( }O'ItQ`O!$( }OOQ!0Lb!)9Ei!)9EiO$){Q`O!)9EiOClQ`O!)9EiOOQ!0Lb!.K;T!.K;TO$){Q`O!.K;TOOQ!0Lb!4/0o!4/0oO!)PQlO'#DzO1PQ`O'#EXO'JPQ!fO'#JqO'JWQ!L^O'#DvO'J_QlO'#EOO'JfQ!fO'#CiO'L|Q!fO'#CiO!)PQlO'#EQO'M^QlO,5;ZO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO,5;eO!)PQlO'#IoO( aQ`O,5<iO!)PQlO,5;eO( iQMhO,5;eO(#SQMhO,5;eO!)PQlO,5;wO!&oQMhO'#GmO( iQMhO'#GmO!&oQMhO'#GoO( iQMhO'#GoO1SQ`O'#DZO1SQ`O'#DZO!&oQMhO'#GPO( iQMhO'#GPO!&oQMhO'#GRO( iQMhO'#GRO!&oQMhO'#GaO( iQMhO'#GaO!)PQlO,5:jO(#ZQpO'#D_O(#eQpO'#JuO!)PQlO,5@nO'M^QlO1G0uO(#oQ?MtO'#CiO!)PQlO1G2PO!&oQMhO'#ItO( iQMhO'#ItO!&oQMhO'#IvO( iQMhO'#IvO(#yQ!dO'#CrO!&oQMhO,5<tO( iQMhO,5<tO'M^QlO1G2RO!)PQlO7+&zO!&oQMhO1G2`O( iQMhO1G2`O!&oQMhO'#ItO( iQMhO'#ItO!&oQMhO'#IvO( iQMhO'#IvO!&oQMhO1G2bO( iQMhO1G2bO'M^QlO7+'mO'M^QlO7+&aO!&oQMhOANAiO( iQMhOANAiO($^Q`O'#EoO($cQ`O'#EoO($kQ`O'#F]O($pQ`O'#EyO($uQ`O'#KSO(%QQ`O'#KQO(%]Q`O,5;ZO(%bQMjO,5<eO(%iQ`O'#GYO(%nQ`O'#GYO(%sQ`O,5<gO(%{Q`O,5;ZO(&TQ?MtO1G1`O(&[Q`O,5<tO(&aQ`O,5<tO(&fQ`O,5<vO(&kQ`O,5<vO(&pQ`O1G2RO(&uQ`O1G0uO(&zQMjO<<K}O('RQMjO<<K}O7eQMhO'#F|O9[Q`O'#F{OAjQ`O'#EnO!)PQlO,5;tO!3dQ`O'#GYO!3dQ`O'#GYO!3dQ`O'#G[O!3dQ`O'#G[O!+xQMhO7+(cO!+xQMhO7+(cO%-mQ!dO1G2wO%-mQ!dO1G2wO!&oQMhO,5=]O!&oQMhO,5=]",
        stateData: "((X~O'{OS'|OSTOS'}RQ~OPYOQYOSfOY!VOaqOdzOeyOl!POpkOrYOskOtkOzkO|YO!OYO!SWO!WkO!XkO!_XO!iuO!lZO!oYO!pYO!qYO!svO!uwO!xxO!|]O$W|O$niO%h}O%j!QO%l!OO%m!OO%n!OO%q!RO%s!SO%v!TO%w!TO%y!UO&V!WO&]!XO&_!YO&a!ZO&c![O&f!]O&l!^O&r!_O&t!`O&v!aO&x!bO&z!cO(SSO(UTO(XUO(`VO(n[O~OWtO~P`OPYOQYOSfOd!jOe!iOpkOrYOskOtkOzkO|YO!OYO!SWO!WkO!XkO!_!eO!iuO!lZO!oYO!pYO!qYO!svO!u!gO!x!hO$W!kO$niO(S!dO(UTO(XUO(`VO(n[O~Oa!wOs!nO!S!oO!b!yO!c!vO!d!vO!|;wO#T!pO#U!pO#V!xO#W!pO#X!pO#[!zO#]!zO(T!lO(UTO(XUO(d!mO(n!sO~O'}!{O~OP]XR]X[]Xa]Xj]Xr]X!Q]X!S]X!]]X!l]X!p]X#R]X#S]X#`]X#kfX#n]X#o]X#p]X#q]X#r]X#s]X#t]X#u]X#v]X#x]X#z]X#{]X$Q]X'y]X(`]X(q]X(x]X(y]X~O!g%RX~P(qO_!}O(U#PO(V!}O(W#PO~O_#QO(W#PO(X#PO(Y#QO~Ox#SO!U#TO(a#TO(b#VO~OPYOQYOSfOd!jOe!iOpkOrYOskOtkOzkO|YO!OYO!SWO!WkO!XkO!_!eO!iuO!lZO!oYO!pYO!qYO!svO!u!gO!x!hO$W!kO$niO(S;{O(UTO(XUO(`VO(n[O~O![#ZO!]#WO!Y(gP!Y(uP~P+}O!^#cO~P`OPYOQYOSfOd!jOe!iOrYOskOtkOzkO|YO!OYO!SWO!WkO!XkO!_!eO!iuO!lZO!oYO!pYO!qYO!svO!u!gO!x!hO$W!kO$niO(UTO(XUO(`VO(n[O~Op#mO![#iO!|]O#i#lO#j#iO(S;|O!k(rP~P.iO!l#oO(S#nO~O!x#sO!|]O%h#tO~O#k#uO~O!g#vO#k#uO~OP$[OR#zO[$cOj$ROr$aO!Q#yO!S#{O!]$_O!l#xO!p$[O#R$RO#n$OO#o$PO#p$PO#q$PO#r$QO#s$RO#t$RO#u$bO#v$SO#x$UO#z$WO#{$XO(`VO(q$YO(x#|O(y#}O~Oa(eX'y(eX'v(eX!k(eX!Y(eX!_(eX%i(eX!g(eX~P1qO#S$dO#`$eO$Q$eOP(fXR(fX[(fXj(fXr(fX!Q(fX!S(fX!](fX!l(fX!p(fX#R(fX#n(fX#o(fX#p(fX#q(fX#r(fX#s(fX#t(fX#u(fX#v(fX#x(fX#z(fX#{(fX(`(fX(q(fX(x(fX(y(fX!_(fX%i(fX~Oa(fX'y(fX'v(fX!Y(fX!k(fXv(fX!g(fX~P4UO#`$eO~O$]$hO$_$gO$f$mO~OSfO!_$nO$i$oO$k$qO~Oh%VOj%cOk%cOl%cOp%WOr%XOs$tOt$tOz%YO|%ZO!O%[O!S${O!_$|O!i%aO!l$xO#j%bO$W%_O$t%]O$v%^O$y%`O(S$sO(UTO(XUO(`$uO(x$}O(y%POg(]P~O!l%dO~O!S%gO!_%hO(S%fO~O!g%lO~Oa%mO'y%mO~O!Q%qO~P%[O(T!lO~P%[O%n%uO~P%[Oh%VO!l%dO(S%fO(T!lO~Oe%|O!l%dO(S%fO~Oj$RO~O!Q&RO!_&OO!l&QO%j&UO(S%fO(T!lO(UTO(XUO`)VP~O!x#sO~O%s&WO!S)RX!_)RX(S)RX~O(S&XO~Ol!PO!u&^O%j!QO%l!OO%m!OO%n!OO%q!RO%s!SO%v!TO%w!TO~Od&cOe&bO!x&`O%h&aO%{&_O~P<VOd&fOeyOl!PO!_&eO!u&^O!xxO!|]O%h}O%l!OO%m!OO%n!OO%q!RO%s!SO%v!TO%w!TO%y!UO~Ob&iO#`&lO%j&gO(T!lO~P=[O!l&mO!u&qO~O!l#oO~O!_XO~Oa%mO'w&yO'y%mO~Oa%mO'w&|O'y%mO~Oa%mO'w'OO'y%mO~O'v]X!Y]Xv]X!k]X&Z]X!_]X%i]X!g]X~P(qO!b']O!c'UO!d'UO(T!lO(UTO(XUO~Os'SO!S'RO!['VO(d'QO!^(hP!^(wP~P@cOn'`O!_'^O(S%fO~Oe'eO!l%dO(S%fO~O!Q&RO!l&QO~Os!nO!S!oO!|;wO#T!pO#U!pO#W!pO#X!pO(T!lO(UTO(XUO(d!mO(n!sO~O!b'kO!c'jO!d'jO#V!pO#['lO#]'lO~PA}Oa%mOh%VO!g#vO!l%dO'y%mO(q'nO~O!p'rO#`'pO~PC]Os!nO!S!oO(UTO(XUO(d!mO(n!sO~O!_XOs(lX!S(lX!b(lX!c(lX!d(lX!|(lX#T(lX#U(lX#V(lX#W(lX#X(lX#[(lX#](lX(T(lX(U(lX(X(lX(d(lX(n(lX~O!c'jO!d'jO(T!lO~PC{O(O'vO(P'vO(Q'xO~O_!}O(U'zO(V!}O(W'zO~O_#QO(W'zO(X'zO(Y#QO~Ov'|O~P%[Ox#SO!U#TO(a#TO(b(PO~O![(RO!Y'VX!Y']X!]'VX!]']X~P+}O!](TO!Y(gX~OP$[OR#zO[$cOj$ROr$aO!Q#yO!S#{O!](TO!l#xO!p$[O#R$RO#n$OO#o$PO#p$PO#q$PO#r$QO#s$RO#t$RO#u$bO#v$SO#x$UO#z$WO#{$XO(`VO(q$YO(x#|O(y#}O~O!Y(gX~PGvO!Y(YO~O!Y(tX!](tX!g(tX!k(tX(q(tX~O#`(tX#k#dX!^(tX~PIyO#`(ZO!Y(vX!](vX~O!]([O!Y(uX~O!Y(_O~O#`$eO~PIyO!^(`O~P`OR#zO!Q#yO!S#{O!l#xO(`VOP!na[!naj!nar!na!]!na!p!na#R!na#n!na#o!na#p!na#q!na#r!na#s!na#t!na#u!na#v!na#x!na#z!na#{!na(q!na(x!na(y!na~Oa!na'y!na'v!na!Y!na!k!nav!na!_!na%i!na!g!na~PKaO!k(aO~O!g#vO#`(bO(q'nO!](sXa(sX'y(sX~O!k(sX~PM|O!S%gO!_%hO!|]O#i(gO#j(fO(S%fO~O!](hO!k(rX~O!k(jO~O!S%gO!_%hO#j(fO(S%fO~OP(fXR(fX[(fXj(fXr(fX!Q(fX!S(fX!](fX!l(fX!p(fX#R(fX#n(fX#o(fX#p(fX#q(fX#r(fX#s(fX#t(fX#u(fX#v(fX#x(fX#z(fX#{(fX(`(fX(q(fX(x(fX(y(fX~O!g#vO!k(fX~P! jOR(lO!Q(kO!l#xO#S$dO!|!{a!S!{a~O!x!{a%h!{a!_!{a#i!{a#j!{a(S!{a~P!#kO!x(pO~OPYOQYOSfOd!jOe!iOpkOrYOskOtkOzkO|YO!OYO!SWO!WkO!XkO!_XO!iuO!lZO!oYO!pYO!qYO!svO!u!gO!x!hO$W!kO$niO(S!dO(UTO(XUO(`VO(n[O~Oh%VOp%WOr%XOs$tOt$tOz%YO|%ZO!O<eO!S${O!_$|O!i=vO!l$xO#j<kO$W%_O$t<gO$v<iO$y%`O(S(tO(UTO(XUO(`$uO(x$}O(y%PO~O#k(vO~O![(xO!k(jP~P%[O(d(zO(n[O~O!S(|O!l#xO(d(zO(n[O~OP;vOQ;vOSfOd=rOe!iOpkOr;vOskOtkOzkO|;vO!O;vO!SWO!WkO!XkO!_!eO!i;yO!lZO!o;vO!p;vO!q;vO!s;zO!u;}O!x!hO$W!kO$n=pO(S)ZO(UTO(XUO(`VO(n[O~O!]$_Oa$qa'y$qa'v$qa!k$qa!Y$qa!_$qa%i$qa!g$qa~Ol)bO~P!&oOh%VOp%WOr%XOs$tOt$tOz%YO|%ZO!O%[O!S${O!_$|O!i%aO!l$xO#j%bO$W%_O$t%]O$v%^O$y%`O(S(tO(UTO(XUO(`$uO(x$}O(y%PO~Og(oP~P!+xO!Q)gO!g)fO!_$^X$Z$^X$]$^X$_$^X$f$^X~O!g)fO!_(zX$Z(zX$](zX$_(zX$f(zX~O!Q)gO~P!.RO!Q)gO!_(zX$Z(zX$](zX$_(zX$f(zX~O!_)iO$Z)mO$])hO$_)hO$f)nO~O![)qO~P!)PO$]$hO$_$gO$f)uO~On$zX!Q$zX#S$zX'x$zX(x$zX(y$zX~OgmXg$zXnmX!]mX#`mX~P!/wOx)wO(a)xO(b)zO~On*TO!Q)|O'x)}O(x$}O(y%PO~Og){O~P!0{Og*UO~Oh%VOp%WOr%XOs$tOt$tOz%YO|%ZO!O<eO!S*WO!_*XO!i=vO!l$xO#j<kO$W%_O$t<gO$v<iO$y%`O(UTO(XUO(`$uO(x$}O(y%PO~O![*[O(S*VO!k(}P~P!1jO#k*^O~O!l*_O~Oh%VOp%WOr%XOs$tOt$tOz%YO|%ZO!O<eO!S${O!_$|O!i=vO!l$xO#j<kO$W%_O$t<gO$v<iO$y%`O(S*aO(UTO(XUO(`$uO(x$}O(y%PO~O![*dO!Y)OP~P!3iOr*pOs!nO!S*fO!b*nO!c*hO!d*hO!l*_O#[*oO%`*jO(T!lO(UTO(XUO(d!mO~O!^*mO~P!5^O#S$dOn(_X!Q(_X'x(_X(x(_X(y(_X!](_X#`(_X~Og(_X$O(_X~P!6`On*uO#`*tOg(^X!](^X~O!]*vOg(]X~Oj%cOk%cOl%cO(S&XOg(]P~Os*yO~O!l+OO~O(S(tO~Op+TO!S%gO![#iO!_%hO!|]O#i#lO#j#iO(S%fO!k(rP~O!g#vO#k+UO~O!S%gO![+WO!]([O!_%hO(S%fO!Y(uP~Os'YO!S+YO![+XO(UTO(XUO(d(zO~O!^(wP~P!9iO!]+ZOa)SX'y)SX~OP$[OR#zO[$cOj$ROr$aO!Q#yO!S#{O!l#xO!p$[O#R$RO#n$OO#o$PO#p$PO#q$PO#r$QO#s$RO#t$RO#u$bO#v$SO#x$UO#z$WO#{$XO(`VO(q$YO(x#|O(y#}O~Oa!ja!]!ja'y!ja'v!ja!Y!ja!k!jav!ja!_!ja%i!ja!g!ja~P!:aOR#zO!Q#yO!S#{O!l#xO(`VOP!ra[!raj!rar!ra!]!ra!p!ra#R!ra#n!ra#o!ra#p!ra#q!ra#r!ra#s!ra#t!ra#u!ra#v!ra#x!ra#z!ra#{!ra(q!ra(x!ra(y!ra~Oa!ra'y!ra'v!ra!Y!ra!k!rav!ra!_!ra%i!ra!g!ra~P!<wOR#zO!Q#yO!S#{O!l#xO(`VOP!ta[!taj!tar!ta!]!ta!p!ta#R!ta#n!ta#o!ta#p!ta#q!ta#r!ta#s!ta#t!ta#u!ta#v!ta#x!ta#z!ta#{!ta(q!ta(x!ta(y!ta~Oa!ta'y!ta'v!ta!Y!ta!k!tav!ta!_!ta%i!ta!g!ta~P!?_Oh%VOn+dO!_'^O%i+cO~O!g+fOa([X!_([X'y([X!]([X~Oa%mO!_XO'y%mO~Oh%VO!l%dO~Oh%VO!l%dO(S%fO~O!g#vO#k(vO~Ob+qO%j+rO(S+nO(UTO(XUO!^)WP~O!]+sO`)VX~O[+wO~O`+xO~O!_&OO(S%fO(T!lO`)VP~Oh%VO#`+}O~Oh%VOn,QO!_$|O~O!_,SO~O!Q,UO!_XO~O%n%uO~O!x,ZO~Oe,`O~Ob,aO(S#nO(UTO(XUO!^)UP~Oe%|O~O%j!QO(S&XO~P=[O[,fO`,eO~OPYOQYOSfOdzOeyOpkOrYOskOtkOzkO|YO!OYO!SWO!WkO!XkO!iuO!lZO!oYO!pYO!qYO!svO!xxO!|]O$niO%h}O(UTO(XUO(`VO(n[O~O!_!eO!u!gO$W!kO(S!dO~P!F_O`,eOa%mO'y%mO~OPYOQYOSfOd!jOe!iOpkOrYOskOtkOzkO|YO!OYO!SWO!WkO!XkO!_!eO!iuO!lZO!oYO!pYO!qYO!svO!x!hO$W!kO$niO(S!dO(UTO(XUO(`VO(n[O~Oa,kOl!OO!uwO%l!OO%m!OO%n!OO~P!HwO!l&mO~O&],qO~O!_,sO~O&n,uO&p,vOP&kaQ&kaS&kaY&kaa&kad&kae&kal&kap&kar&kas&kat&kaz&ka|&ka!O&ka!S&ka!W&ka!X&ka!_&ka!i&ka!l&ka!o&ka!p&ka!q&ka!s&ka!u&ka!x&ka!|&ka$W&ka$n&ka%h&ka%j&ka%l&ka%m&ka%n&ka%q&ka%s&ka%v&ka%w&ka%y&ka&V&ka&]&ka&_&ka&a&ka&c&ka&f&ka&l&ka&r&ka&t&ka&v&ka&x&ka&z&ka'v&ka(S&ka(U&ka(X&ka(`&ka(n&ka!^&ka&d&kab&ka&i&ka~O(S,{O~Oh!eX!]!RX!^!RX!g!RX!g!eX!l!eX#`!RX~O!]!eX!^!eX~P# }O!g-QO#`-POh(iX!]#hX!^#hX!g(iX!l(iX~O!](iX!^(iX~P#!pOh%VO!g-SO!l%dO!]!aX!^!aX~Os!nO!S!oO(UTO(XUO(d!mO~OP;vOQ;vOSfOd=rOe!iOpkOr;vOskOtkOzkO|;vO!O;vO!SWO!WkO!XkO!_!eO!i;yO!lZO!o;vO!p;vO!q;vO!s;zO!u;}O!x!hO$W!kO$n=pO(UTO(XUO(`VO(n[O~O(S<rO~P#$VO!]-WO!^(hX~O!^-YO~O!g-QO#`-PO!]#hX!^#hX~O!]-ZO!^(wX~O!^-]O~O!c-^O!d-^O(T!lO~P##tO!^-aO~P'_On-dO!_'^O~O!Y-iO~Os!{a!b!{a!c!{a!d!{a#T!{a#U!{a#V!{a#W!{a#X!{a#[!{a#]!{a(T!{a(U!{a(X!{a(d!{a(n!{a~P!#kO!p-nO#`-lO~PC]O!c-pO!d-pO(T!lO~PC{Oa%mO#`-lO'y%mO~Oa%mO!g#vO#`-lO'y%mO~Oa%mO!g#vO!p-nO#`-lO'y%mO(q'nO~O(O'vO(P'vO(Q-uO~Ov-vO~O!Y'Va!]'Va~P!:aO![-zO!Y'VX!]'VX~P%[O!](TO!Y(ga~O!Y(ga~PGvO!]([O!Y(ua~O!S%gO![.OO!_%hO(S%fO!Y']X!]']X~O#`.QO!](sa!k(saa(sa'y(sa~O!g#vO~P#,]O!](hO!k(ra~O!S%gO!_%hO#j.UO(S%fO~Op.ZO!S%gO![.WO!_%hO!|]O#i.YO#j.WO(S%fO!]'`X!k'`X~OR._O!l#xO~Oh%VOn.bO!_'^O%i.aO~Oa#ci!]#ci'y#ci'v#ci!Y#ci!k#civ#ci!_#ci%i#ci!g#ci~P!:aOn=|O!Q)|O'x)}O(x$}O(y%PO~O#k#_aa#_a#`#_a'y#_a!]#_a!k#_a!_#_a!Y#_a~P#/XO#k(_XP(_XR(_X[(_Xa(_Xj(_Xr(_X!S(_X!l(_X!p(_X#R(_X#n(_X#o(_X#p(_X#q(_X#r(_X#s(_X#t(_X#u(_X#v(_X#x(_X#z(_X#{(_X'y(_X(`(_X(q(_X!k(_X!Y(_X'v(_Xv(_X!_(_X%i(_X!g(_X~P!6`O!].oO!k(jX~P!:aO!k.rO~O!Y.tO~OP$[OR#zO!Q#yO!S#{O!l#xO!p$[O(`VO[#mia#mij#mir#mi!]#mi#R#mi#o#mi#p#mi#q#mi#r#mi#s#mi#t#mi#u#mi#v#mi#x#mi#z#mi#{#mi'y#mi(q#mi(x#mi(y#mi'v#mi!Y#mi!k#miv#mi!_#mi%i#mi!g#mi~O#n#mi~P#2wO#n$OO~P#2wOP$[OR#zOr$aO!Q#yO!S#{O!l#xO!p$[O#n$OO#o$PO#p$PO#q$PO(`VO[#mia#mij#mi!]#mi#R#mi#s#mi#t#mi#u#mi#v#mi#x#mi#z#mi#{#mi'y#mi(q#mi(x#mi(y#mi'v#mi!Y#mi!k#miv#mi!_#mi%i#mi!g#mi~O#r#mi~P#5fO#r$QO~P#5fOP$[OR#zO[$cOj$ROr$aO!Q#yO!S#{O!l#xO!p$[O#R$RO#n$OO#o$PO#p$PO#q$PO#r$QO#s$RO#t$RO#u$bO(`VOa#mi!]#mi#x#mi#z#mi#{#mi'y#mi(q#mi(x#mi(y#mi'v#mi!Y#mi!k#miv#mi!_#mi%i#mi!g#mi~O#v#mi~P#8TOP$[OR#zO[$cOj$ROr$aO!Q#yO!S#{O!l#xO!p$[O#R$RO#n$OO#o$PO#p$PO#q$PO#r$QO#s$RO#t$RO#u$bO#v$SO(`VO(y#}Oa#mi!]#mi#z#mi#{#mi'y#mi(q#mi(x#mi'v#mi!Y#mi!k#miv#mi!_#mi%i#mi!g#mi~O#x$UO~P#:kO#x#mi~P#:kO#v$SO~P#8TOP$[OR#zO[$cOj$ROr$aO!Q#yO!S#{O!l#xO!p$[O#R$RO#n$OO#o$PO#p$PO#q$PO#r$QO#s$RO#t$RO#u$bO#v$SO#x$UO(`VO(x#|O(y#}Oa#mi!]#mi#{#mi'y#mi(q#mi'v#mi!Y#mi!k#miv#mi!_#mi%i#mi!g#mi~O#z#mi~P#=aO#z$WO~P#=aOP]XR]X[]Xj]Xr]X!Q]X!S]X!l]X!p]X#R]X#S]X#`]X#kfX#n]X#o]X#p]X#q]X#r]X#s]X#t]X#u]X#v]X#x]X#z]X#{]X$Q]X(`]X(q]X(x]X(y]X!]]X!^]X~O$O]X~P#@OOP$[OR#zO[<_Oj<SOr<]O!Q#yO!S#{O!l#xO!p$[O#R<SO#n<PO#o<QO#p<QO#q<QO#r<RO#s<SO#t<SO#u<^O#v<TO#x<VO#z<XO#{<YO(`VO(q$YO(x#|O(y#}O~O$O.vO~P#B]O#S$dO#`<`O$Q<`O$O(fX!^(fX~P! jOa'ca!]'ca'y'ca'v'ca!k'ca!Y'cav'ca!_'ca%i'ca!g'ca~P!:aO[#mia#mij#mir#mi!]#mi#R#mi#r#mi#s#mi#t#mi#u#mi#v#mi#x#mi#z#mi#{#mi'y#mi(q#mi'v#mi!Y#mi!k#miv#mi!_#mi%i#mi!g#mi~OP$[OR#zO!Q#yO!S#{O!l#xO!p$[O#n$OO#o$PO#p$PO#q$PO(`VO(x#mi(y#mi~P#E_On=|O!Q)|O'x)}O(x$}O(y%POP#miR#mi!S#mi!l#mi!p#mi#n#mi#o#mi#p#mi#q#mi(`#mi~P#E_O!].zOg(oX~P!0{Og.|O~Oa$Pi!]$Pi'y$Pi'v$Pi!Y$Pi!k$Piv$Pi!_$Pi%i$Pi!g$Pi~P!:aO$].}O$_.}O~O$]/OO$_/OO~O!g)fO#`/PO!_$cX$Z$cX$]$cX$_$cX$f$cX~O![/QO~O!_)iO$Z/SO$])hO$_)hO$f/TO~O!]<ZO!^(eX~P#B]O!^/UO~O!g)fO$f(zX~O$f/WO~Ov/XO~P!&oOx)wO(a)xO(b/[O~O!S/_O~O(x$}On%aa!Q%aa'x%aa(y%aa!]%aa#`%aa~Og%aa$O%aa~P#LaO(y%POn%ca!Q%ca'x%ca(x%ca!]%ca#`%ca~Og%ca$O%ca~P#MSO!]fX!gfX!kfX!k$zX(qfX~P!/wO![/hO!]([O(S/gO!Y(uP!Y)OP~P!1jOr*pO!b*nO!c*hO!d*hO!l*_O#[*oO%`*jO(T!lO(UTO(XUO~Os<oO!S/iO![+XO!^*mO(d<nO!^(wP~P#NmO!k/jO~P#/XO!]/kO!g#vO(q'nO!k(}X~O!k/pO~O!S%gO![*[O!_%hO(S%fO!k(}P~O#k/rO~O!Y$zX!]$zX!g%RX~P!/wO!]/sO!Y)OX~P#/XO!g/uO~O!Y/wO~OpkO(S/xO~P.iOh%VOr/}O!g#vO!l%dO(q'nO~O!g+fO~Oa%mO!]0RO'y%mO~O!^0TO~P!5^O!c0UO!d0UO(T!lO~P##tOs!nO!S0VO(UTO(XUO(d!mO~O#[0XO~Og%aa!]%aa#`%aa$O%aa~P!0{Og%ca!]%ca#`%ca$O%ca~P!0{Oj%cOk%cOl%cO(S&XOg'lX!]'lX~O!]*vOg(]a~Og0bO~OR0cO!Q0cO!S0dO#S$dOn}a'x}a(x}a(y}a!]}a#`}a~Og}a$O}a~P$&vO!Q)|O'x)}On$sa(x$sa(y$sa!]$sa#`$sa~Og$sa$O$sa~P$'rO!Q)|O'x)}On$ua(x$ua(y$ua!]$ua#`$ua~Og$ua$O$ua~P$(eO#k0gO~Og%Ta!]%Ta#`%Ta$O%Ta~P!0{On0iO#`0hOg(^a!](^a~O!g#vO~O#k0lO~O!]+ZOa)Sa'y)Sa~OR#zO!Q#yO!S#{O!l#xO(`VOP!ri[!rij!rir!ri!]!ri!p!ri#R!ri#n!ri#o!ri#p!ri#q!ri#r!ri#s!ri#t!ri#u!ri#v!ri#x!ri#z!ri#{!ri(q!ri(x!ri(y!ri~Oa!ri'y!ri'v!ri!Y!ri!k!riv!ri!_!ri%i!ri!g!ri~P$*bOh%VOr%XOs$tOt$tOz%YO|%ZO!O<eO!S${O!_$|O!i=vO!l$xO#j<kO$W%_O$t<gO$v<iO$y%`O(UTO(XUO(`$uO(x$}O(y%PO~Op0uO%]0vO(S0tO~P$,xO!g+fOa([a!_([a'y([a!]([a~O#k0|O~O[]X!]fX!^fX~O!]0}O!^)WX~O!^1PO~O[1QO~Ob1SO(S+nO(UTO(XUO~O!_&OO(S%fO`'tX!]'tX~O!]+sO`)Va~O!k1VO~P!:aO[1YO~O`1ZO~O#`1^O~On1aO!_$|O~O(d(zO!^)TP~Oh%VOn1jO!_1gO%i1iO~O[1tO!]1rO!^)UX~O!^1uO~O`1wOa%mO'y%mO~O(S#nO(UTO(XUO~O#S$dO#`$eO$Q$eOP(fXR(fX[(fXr(fX!Q(fX!S(fX!](fX!l(fX!p(fX#R(fX#n(fX#o(fX#p(fX#q(fX#r(fX#s(fX#t(fX#u(fX#v(fX#x(fX#z(fX#{(fX(`(fX(q(fX(x(fX(y(fX~Oj1zO&Z1{Oa(fX~P$2cOj1zO#`$eO&Z1{O~Oa1}O~P%[Oa2PO~O&d2SOP&biQ&biS&biY&bia&bid&bie&bil&bip&bir&bis&bit&biz&bi|&bi!O&bi!S&bi!W&bi!X&bi!_&bi!i&bi!l&bi!o&bi!p&bi!q&bi!s&bi!u&bi!x&bi!|&bi$W&bi$n&bi%h&bi%j&bi%l&bi%m&bi%n&bi%q&bi%s&bi%v&bi%w&bi%y&bi&V&bi&]&bi&_&bi&a&bi&c&bi&f&bi&l&bi&r&bi&t&bi&v&bi&x&bi&z&bi'v&bi(S&bi(U&bi(X&bi(`&bi(n&bi!^&bib&bi&i&bi~Ob2YO!^2WO&i2XO~P`O!_XO!l2[O~O&p,vOP&kiQ&kiS&kiY&kia&kid&kie&kil&kip&kir&kis&kit&kiz&ki|&ki!O&ki!S&ki!W&ki!X&ki!_&ki!i&ki!l&ki!o&ki!p&ki!q&ki!s&ki!u&ki!x&ki!|&ki$W&ki$n&ki%h&ki%j&ki%l&ki%m&ki%n&ki%q&ki%s&ki%v&ki%w&ki%y&ki&V&ki&]&ki&_&ki&a&ki&c&ki&f&ki&l&ki&r&ki&t&ki&v&ki&x&ki&z&ki'v&ki(S&ki(U&ki(X&ki(`&ki(n&ki!^&ki&d&kib&ki&i&ki~O!Y2bO~O!]!aa!^!aa~P#B]Os!nO!S!oO![2hO(d!mO!]'WX!^'WX~P@cO!]-WO!^(ha~O!]'^X!^'^X~P!9iO!]-ZO!^(wa~O!^2oO~P'_Oa%mO#`2xO'y%mO~Oa%mO!g#vO#`2xO'y%mO~Oa%mO!g#vO!p2|O#`2xO'y%mO(q'nO~Oa%mO'y%mO~P!:aO!]$_Ov$qa~O!Y'Vi!]'Vi~P!:aO!](TO!Y(gi~O!]([O!Y(ui~O!Y(vi!](vi~P!:aO!](si!k(sia(si'y(si~P!:aO#`3OO!](si!k(sia(si'y(si~O!](hO!k(ri~O!S%gO!_%hO!|]O#i3TO#j3SO(S%fO~O!S%gO!_%hO#j3SO(S%fO~On3[O!_'^O%i3ZO~Oh%VOn3[O!_'^O%i3ZO~O#k%aaP%aaR%aa[%aaa%aaj%aar%aa!S%aa!l%aa!p%aa#R%aa#n%aa#o%aa#p%aa#q%aa#r%aa#s%aa#t%aa#u%aa#v%aa#x%aa#z%aa#{%aa'y%aa(`%aa(q%aa!k%aa!Y%aa'v%aav%aa!_%aa%i%aa!g%aa~P#LaO#k%caP%caR%ca[%caa%caj%car%ca!S%ca!l%ca!p%ca#R%ca#n%ca#o%ca#p%ca#q%ca#r%ca#s%ca#t%ca#u%ca#v%ca#x%ca#z%ca#{%ca'y%ca(`%ca(q%ca!k%ca!Y%ca'v%cav%ca!_%ca%i%ca!g%ca~P#MSO#k%aaP%aaR%aa[%aaa%aaj%aar%aa!S%aa!]%aa!l%aa!p%aa#R%aa#n%aa#o%aa#p%aa#q%aa#r%aa#s%aa#t%aa#u%aa#v%aa#x%aa#z%aa#{%aa'y%aa(`%aa(q%aa!k%aa!Y%aa'v%aa#`%aav%aa!_%aa%i%aa!g%aa~P#/XO#k%caP%caR%ca[%caa%caj%car%ca!S%ca!]%ca!l%ca!p%ca#R%ca#n%ca#o%ca#p%ca#q%ca#r%ca#s%ca#t%ca#u%ca#v%ca#x%ca#z%ca#{%ca'y%ca(`%ca(q%ca!k%ca!Y%ca'v%ca#`%cav%ca!_%ca%i%ca!g%ca~P#/XO#k}aP}a[}aa}aj}ar}a!l}a!p}a#R}a#n}a#o}a#p}a#q}a#r}a#s}a#t}a#u}a#v}a#x}a#z}a#{}a'y}a(`}a(q}a!k}a!Y}a'v}av}a!_}a%i}a!g}a~P$&vO#k$saP$saR$sa[$saa$saj$sar$sa!S$sa!l$sa!p$sa#R$sa#n$sa#o$sa#p$sa#q$sa#r$sa#s$sa#t$sa#u$sa#v$sa#x$sa#z$sa#{$sa'y$sa(`$sa(q$sa!k$sa!Y$sa'v$sav$sa!_$sa%i$sa!g$sa~P$'rO#k$uaP$uaR$ua[$uaa$uaj$uar$ua!S$ua!l$ua!p$ua#R$ua#n$ua#o$ua#p$ua#q$ua#r$ua#s$ua#t$ua#u$ua#v$ua#x$ua#z$ua#{$ua'y$ua(`$ua(q$ua!k$ua!Y$ua'v$uav$ua!_$ua%i$ua!g$ua~P$(eO#k%TaP%TaR%Ta[%Taa%Taj%Tar%Ta!S%Ta!]%Ta!l%Ta!p%Ta#R%Ta#n%Ta#o%Ta#p%Ta#q%Ta#r%Ta#s%Ta#t%Ta#u%Ta#v%Ta#x%Ta#z%Ta#{%Ta'y%Ta(`%Ta(q%Ta!k%Ta!Y%Ta'v%Ta#`%Tav%Ta!_%Ta%i%Ta!g%Ta~P#/XOa#cq!]#cq'y#cq'v#cq!Y#cq!k#cqv#cq!_#cq%i#cq!g#cq~P!:aO![3dO!]'XX!k'XX~P%[O!].oO!k(ja~O!].oO!k(ja~P!:aO!Y3gO~O$O!na!^!na~PKaO$O!ja!]!ja!^!ja~P#B]O$O!ra!^!ra~P!<wO$O!ta!^!ta~P!?_Og'[X!]'[X~P!+xO!].zOg(oa~OSfO!_3{O$d3|O~O!^4QO~Ov4RO~P#/XOa$mq!]$mq'y$mq'v$mq!Y$mq!k$mqv$mq!_$mq%i$mq!g$mq~P!:aO!Y4TO~P!&oO!S4UO~O!Q)|O'x)}O(y%POn'ha(x'ha!]'ha#`'ha~Og'ha$O'ha~P%,XO!Q)|O'x)}On'ja(x'ja(y'ja!]'ja#`'ja~Og'ja$O'ja~P%,zO(q$YO~P#/XO!YfX!Y$zX!]fX!]$zX!g%RX#`fX~P!/wO(S<xO~P!1jO!S%gO![4XO!_%hO(S%fO!]'dX!k'dX~O!]/kO!k(}a~O!]/kO!g#vO!k(}a~O!]/kO!g#vO(q'nO!k(}a~Og$|i!]$|i#`$|i$O$|i~P!0{O![4aO!Y'fX!]'fX~P!3iO!]/sO!Y)Oa~O!]/sO!Y)Oa~P#/XOP]XR]X[]Xj]Xr]X!Q]X!S]X!Y]X!]]X!l]X!p]X#R]X#S]X#`]X#kfX#n]X#o]X#p]X#q]X#r]X#s]X#t]X#u]X#v]X#x]X#z]X#{]X$Q]X(`]X(q]X(x]X(y]X~Oj%YX!g%YX~P%0kOj4fO!g#vO~Oh%VO!g#vO!l%dO~Oh%VOr4kO!l%dO(q'nO~Or4pO!g#vO(q'nO~Os!nO!S4qO(UTO(XUO(d!mO~O(x$}On%ai!Q%ai'x%ai(y%ai!]%ai#`%ai~Og%ai$O%ai~P%4[O(y%POn%ci!Q%ci'x%ci(x%ci!]%ci#`%ci~Og%ci$O%ci~P%4}Og(^i!](^i~P!0{O#`4wOg(^i!](^i~P!0{O!k4zO~Oa$oq!]$oq'y$oq'v$oq!Y$oq!k$oqv$oq!_$oq%i$oq!g$oq~P!:aO!Y5QO~O!]5RO!_)PX~P#/XOa$zX!_$zX%^]X'y$zX!]$zX~P!/wO%^5UOaoXnoX!QoX!_oX'xoX'yoX(xoX(yoX!]oX~Op5VO(S#nO~O%^5UO~Ob5]O%j5^O(S+nO(UTO(XUO!]'sX!^'sX~O!]0}O!^)Wa~O[5bO~O`5cO~Oa%mO'y%mO~P#/XO!]5kO#`5mO!^)TX~O!^5nO~Or5tOs!nO!S*fO!b!yO!c!vO!d!vO!|;wO#T!pO#U!pO#V!pO#W!pO#X!pO#[5sO#]!zO(T!lO(UTO(XUO(d!mO(n!sO~O!^5rO~P%:YOn5yO!_1gO%i5xO~Oh%VOn5yO!_1gO%i5xO~Ob6QO(S#nO(UTO(XUO!]'rX!^'rX~O!]1rO!^)Ua~O(UTO(XUO(d6SO~O`6WO~Oj6ZO&Z6[O~PM|O!k6]O~P%[Oa6_O~Oa6_O~P%[Ob2YO!^6dO&i2XO~P`O!g6fO~O!g6hOh(ii!](ii!^(ii!g(ii!l(iir(ii(q(ii~O!]#hi!^#hi~P#B]O#`6iO!]#hi!^#hi~O!]!ai!^!ai~P#B]Oa%mO#`6rO'y%mO~Oa%mO!g#vO#`6rO'y%mO~O!](sq!k(sqa(sq'y(sq~P!:aO!](hO!k(rq~O!S%gO!_%hO#j6yO(S%fO~O!_'^O%i6|O~On7QO!_'^O%i6|O~O#k'haP'haR'ha['haa'haj'har'ha!S'ha!l'ha!p'ha#R'ha#n'ha#o'ha#p'ha#q'ha#r'ha#s'ha#t'ha#u'ha#v'ha#x'ha#z'ha#{'ha'y'ha(`'ha(q'ha!k'ha!Y'ha'v'hav'ha!_'ha%i'ha!g'ha~P%,XO#k'jaP'jaR'ja['jaa'jaj'jar'ja!S'ja!l'ja!p'ja#R'ja#n'ja#o'ja#p'ja#q'ja#r'ja#s'ja#t'ja#u'ja#v'ja#x'ja#z'ja#{'ja'y'ja(`'ja(q'ja!k'ja!Y'ja'v'jav'ja!_'ja%i'ja!g'ja~P%,zO#k$|iP$|iR$|i[$|ia$|ij$|ir$|i!S$|i!]$|i!l$|i!p$|i#R$|i#n$|i#o$|i#p$|i#q$|i#r$|i#s$|i#t$|i#u$|i#v$|i#x$|i#z$|i#{$|i'y$|i(`$|i(q$|i!k$|i!Y$|i'v$|i#`$|iv$|i!_$|i%i$|i!g$|i~P#/XO#k%aiP%aiR%ai[%aia%aij%air%ai!S%ai!l%ai!p%ai#R%ai#n%ai#o%ai#p%ai#q%ai#r%ai#s%ai#t%ai#u%ai#v%ai#x%ai#z%ai#{%ai'y%ai(`%ai(q%ai!k%ai!Y%ai'v%aiv%ai!_%ai%i%ai!g%ai~P%4[O#k%ciP%ciR%ci[%cia%cij%cir%ci!S%ci!l%ci!p%ci#R%ci#n%ci#o%ci#p%ci#q%ci#r%ci#s%ci#t%ci#u%ci#v%ci#x%ci#z%ci#{%ci'y%ci(`%ci(q%ci!k%ci!Y%ci'v%civ%ci!_%ci%i%ci!g%ci~P%4}O!]'Xa!k'Xa~P!:aO!].oO!k(ji~O$O#ci!]#ci!^#ci~P#B]OP$[OR#zO!Q#yO!S#{O!l#xO!p$[O(`VO[#mij#mir#mi#R#mi#o#mi#p#mi#q#mi#r#mi#s#mi#t#mi#u#mi#v#mi#x#mi#z#mi#{#mi$O#mi(q#mi(x#mi(y#mi!]#mi!^#mi~O#n#mi~P%MXO#n<PO~P%MXOP$[OR#zOr<]O!Q#yO!S#{O!l#xO!p$[O#n<PO#o<QO#p<QO#q<QO(`VO[#mij#mi#R#mi#s#mi#t#mi#u#mi#v#mi#x#mi#z#mi#{#mi$O#mi(q#mi(x#mi(y#mi!]#mi!^#mi~O#r#mi~P& aO#r<RO~P& aOP$[OR#zO[<_Oj<SOr<]O!Q#yO!S#{O!l#xO!p$[O#R<SO#n<PO#o<QO#p<QO#q<QO#r<RO#s<SO#t<SO#u<^O(`VO#x#mi#z#mi#{#mi$O#mi(q#mi(x#mi(y#mi!]#mi!^#mi~O#v#mi~P&#iOP$[OR#zO[<_Oj<SOr<]O!Q#yO!S#{O!l#xO!p$[O#R<SO#n<PO#o<QO#p<QO#q<QO#r<RO#s<SO#t<SO#u<^O#v<TO(`VO(y#}O#z#mi#{#mi$O#mi(q#mi(x#mi!]#mi!^#mi~O#x<VO~P&%jO#x#mi~P&%jO#v<TO~P&#iOP$[OR#zO[<_Oj<SOr<]O!Q#yO!S#{O!l#xO!p$[O#R<SO#n<PO#o<QO#p<QO#q<QO#r<RO#s<SO#t<SO#u<^O#v<TO#x<VO(`VO(x#|O(y#}O#{#mi$O#mi(q#mi!]#mi!^#mi~O#z#mi~P&'yO#z<XO~P&'yOa#|y!]#|y'y#|y'v#|y!Y#|y!k#|yv#|y!_#|y%i#|y!g#|y~P!:aO[#mij#mir#mi#R#mi#r#mi#s#mi#t#mi#u#mi#v#mi#x#mi#z#mi#{#mi$O#mi(q#mi!]#mi!^#mi~OP$[OR#zO!Q#yO!S#{O!l#xO!p$[O#n<PO#o<QO#p<QO#q<QO(`VO(x#mi(y#mi~P&*uOn=}O!Q)|O'x)}O(x$}O(y%POP#miR#mi!S#mi!l#mi!p#mi#n#mi#o#mi#p#mi#q#mi(`#mi~P&*uO#S$dOP(_XR(_X[(_Xj(_Xn(_Xr(_X!Q(_X!S(_X!l(_X!p(_X#R(_X#n(_X#o(_X#p(_X#q(_X#r(_X#s(_X#t(_X#u(_X#v(_X#x(_X#z(_X#{(_X$O(_X'x(_X(`(_X(q(_X(x(_X(y(_X!](_X!^(_X~O$O$Pi!]$Pi!^$Pi~P#B]O$O!ri!^!ri~P$*bOg'[a!]'[a~P!0{O!^7dO~O!]'ca!^'ca~P#B]O!Y7eO~P#/XO!g#vO(q'nO!]'da!k'da~O!]/kO!k(}i~O!]/kO!g#vO!k(}i~Og$|q!]$|q#`$|q$O$|q~P!0{O!Y'fa!]'fa~P#/XO!g7lO~O!]/sO!Y)Oi~P#/XO!]/sO!Y)Oi~O!Y7oO~Oh%VOr7tO!l%dO(q'nO~Oj7vO!g#vO~Or7yO!g#vO(q'nO~O!Q)|O'x)}O(y%POn'ia(x'ia!]'ia#`'ia~Og'ia$O'ia~P&3vO!Q)|O'x)}On'ka(x'ka(y'ka!]'ka#`'ka~Og'ka$O'ka~P&4iO!Y7{O~Og%Oq!]%Oq#`%Oq$O%Oq~P!0{Og(^q!](^q~P!0{O#`7|Og(^q!](^q~P!0{Oa$oy!]$oy'y$oy'v$oy!Y$oy!k$oyv$oy!_$oy%i$oy!g$oy~P!:aO!g6hO~O!]5RO!_)Pa~O!_'^OP$TaR$Ta[$Taj$Tar$Ta!Q$Ta!S$Ta!]$Ta!l$Ta!p$Ta#R$Ta#n$Ta#o$Ta#p$Ta#q$Ta#r$Ta#s$Ta#t$Ta#u$Ta#v$Ta#x$Ta#z$Ta#{$Ta(`$Ta(q$Ta(x$Ta(y$Ta~O%i6|O~P&7ZO%^8QOa%[i!_%[i'y%[i!]%[i~Oa#cy!]#cy'y#cy'v#cy!Y#cy!k#cyv#cy!_#cy%i#cy!g#cy~P!:aO[8SO~Ob8UO(S+nO(UTO(XUO~O!]0}O!^)Wi~O`8YO~O(d(zO!]'oX!^'oX~O!]5kO!^)Ta~O!^8cO~P%:YO(n!sO~P$${O#[8dO~O!_1gO~O!_1gO%i8fO~On8iO!_1gO%i8fO~O[8nO!]'ra!^'ra~O!]1rO!^)Ui~O!k8rO~O!k8sO~O!k8vO~O!k8vO~P%[Oa8xO~O!g8yO~O!k8zO~O!](vi!^(vi~P#B]Oa%mO#`9SO'y%mO~O!](sy!k(sya(sy'y(sy~P!:aO!](hO!k(ry~O%i9VO~P&7ZO!_'^O%i9VO~O#k$|qP$|qR$|q[$|qa$|qj$|qr$|q!S$|q!]$|q!l$|q!p$|q#R$|q#n$|q#o$|q#p$|q#q$|q#r$|q#s$|q#t$|q#u$|q#v$|q#x$|q#z$|q#{$|q'y$|q(`$|q(q$|q!k$|q!Y$|q'v$|q#`$|qv$|q!_$|q%i$|q!g$|q~P#/XO#k'iaP'iaR'ia['iaa'iaj'iar'ia!S'ia!l'ia!p'ia#R'ia#n'ia#o'ia#p'ia#q'ia#r'ia#s'ia#t'ia#u'ia#v'ia#x'ia#z'ia#{'ia'y'ia(`'ia(q'ia!k'ia!Y'ia'v'iav'ia!_'ia%i'ia!g'ia~P&3vO#k'kaP'kaR'ka['kaa'kaj'kar'ka!S'ka!l'ka!p'ka#R'ka#n'ka#o'ka#p'ka#q'ka#r'ka#s'ka#t'ka#u'ka#v'ka#x'ka#z'ka#{'ka'y'ka(`'ka(q'ka!k'ka!Y'ka'v'kav'ka!_'ka%i'ka!g'ka~P&4iO#k%OqP%OqR%Oq[%Oqa%Oqj%Oqr%Oq!S%Oq!]%Oq!l%Oq!p%Oq#R%Oq#n%Oq#o%Oq#p%Oq#q%Oq#r%Oq#s%Oq#t%Oq#u%Oq#v%Oq#x%Oq#z%Oq#{%Oq'y%Oq(`%Oq(q%Oq!k%Oq!Y%Oq'v%Oq#`%Oqv%Oq!_%Oq%i%Oq!g%Oq~P#/XO!]'Xi!k'Xi~P!:aO$O#cq!]#cq!^#cq~P#B]O(x$}OP%aaR%aa[%aaj%aar%aa!S%aa!l%aa!p%aa#R%aa#n%aa#o%aa#p%aa#q%aa#r%aa#s%aa#t%aa#u%aa#v%aa#x%aa#z%aa#{%aa$O%aa(`%aa(q%aa!]%aa!^%aa~On%aa!Q%aa'x%aa(y%aa~P&HnO(y%POP%caR%ca[%caj%car%ca!S%ca!l%ca!p%ca#R%ca#n%ca#o%ca#p%ca#q%ca#r%ca#s%ca#t%ca#u%ca#v%ca#x%ca#z%ca#{%ca$O%ca(`%ca(q%ca!]%ca!^%ca~On%ca!Q%ca'x%ca(x%ca~P&JuOn=}O!Q)|O'x)}O(y%PO~P&HnOn=}O!Q)|O'x)}O(x$}O~P&JuOR0cO!Q0cO!S0dO#S$dOP}a[}aj}an}ar}a!l}a!p}a#R}a#n}a#o}a#p}a#q}a#r}a#s}a#t}a#u}a#v}a#x}a#z}a#{}a$O}a'x}a(`}a(q}a(x}a(y}a!]}a!^}a~O!Q)|O'x)}OP$saR$sa[$saj$san$sar$sa!S$sa!l$sa!p$sa#R$sa#n$sa#o$sa#p$sa#q$sa#r$sa#s$sa#t$sa#u$sa#v$sa#x$sa#z$sa#{$sa$O$sa(`$sa(q$sa(x$sa(y$sa!]$sa!^$sa~O!Q)|O'x)}OP$uaR$ua[$uaj$uan$uar$ua!S$ua!l$ua!p$ua#R$ua#n$ua#o$ua#p$ua#q$ua#r$ua#s$ua#t$ua#u$ua#v$ua#x$ua#z$ua#{$ua$O$ua(`$ua(q$ua(x$ua(y$ua!]$ua!^$ua~On=}O!Q)|O'x)}O(x$}O(y%PO~OP%TaR%Ta[%Taj%Tar%Ta!S%Ta!l%Ta!p%Ta#R%Ta#n%Ta#o%Ta#p%Ta#q%Ta#r%Ta#s%Ta#t%Ta#u%Ta#v%Ta#x%Ta#z%Ta#{%Ta$O%Ta(`%Ta(q%Ta!]%Ta!^%Ta~P'%zO$O$mq!]$mq!^$mq~P#B]O$O$oq!]$oq!^$oq~P#B]O!^9dO~O$O9eO~P!0{O!g#vO!]'di!k'di~O!g#vO(q'nO!]'di!k'di~O!]/kO!k(}q~O!Y'fi!]'fi~P#/XO!]/sO!Y)Oq~Or9lO!g#vO(q'nO~O[9nO!Y9mO~P#/XO!Y9mO~Oj9tO!g#vO~Og(^y!](^y~P!0{O!]'ma!_'ma~P#/XOa%[q!_%[q'y%[q!]%[q~P#/XO[9yO~O!]0}O!^)Wq~O#`9}O!]'oa!^'oa~O!]5kO!^)Ti~P#B]O!S:PO~O!_1gO%i:SO~O(UTO(XUO(d:XO~O!]1rO!^)Uq~O!k:[O~O!k:]O~O!k:^O~O!k:^O~P%[O#`:aO!]#hy!^#hy~O!]#hy!^#hy~P#B]O%i:fO~P&7ZO!_'^O%i:fO~O$O#|y!]#|y!^#|y~P#B]OP$|iR$|i[$|ij$|ir$|i!S$|i!l$|i!p$|i#R$|i#n$|i#o$|i#p$|i#q$|i#r$|i#s$|i#t$|i#u$|i#v$|i#x$|i#z$|i#{$|i$O$|i(`$|i(q$|i!]$|i!^$|i~P'%zO!Q)|O'x)}O(y%POP'haR'ha['haj'han'har'ha!S'ha!l'ha!p'ha#R'ha#n'ha#o'ha#p'ha#q'ha#r'ha#s'ha#t'ha#u'ha#v'ha#x'ha#z'ha#{'ha$O'ha(`'ha(q'ha(x'ha!]'ha!^'ha~O!Q)|O'x)}OP'jaR'ja['jaj'jan'jar'ja!S'ja!l'ja!p'ja#R'ja#n'ja#o'ja#p'ja#q'ja#r'ja#s'ja#t'ja#u'ja#v'ja#x'ja#z'ja#{'ja$O'ja(`'ja(q'ja(x'ja(y'ja!]'ja!^'ja~O(x$}OP%aiR%ai[%aij%ain%air%ai!Q%ai!S%ai!l%ai!p%ai#R%ai#n%ai#o%ai#p%ai#q%ai#r%ai#s%ai#t%ai#u%ai#v%ai#x%ai#z%ai#{%ai$O%ai'x%ai(`%ai(q%ai(y%ai!]%ai!^%ai~O(y%POP%ciR%ci[%cij%cin%cir%ci!Q%ci!S%ci!l%ci!p%ci#R%ci#n%ci#o%ci#p%ci#q%ci#r%ci#s%ci#t%ci#u%ci#v%ci#x%ci#z%ci#{%ci$O%ci'x%ci(`%ci(q%ci(x%ci!]%ci!^%ci~O$O$oy!]$oy!^$oy~P#B]O$O#cy!]#cy!^#cy~P#B]O!g#vO!]'dq!k'dq~O!]/kO!k(}y~O!Y'fq!]'fq~P#/XOr:pO!g#vO(q'nO~O[:tO!Y:sO~P#/XO!Y:sO~Og(^!R!](^!R~P!0{Oa%[y!_%[y'y%[y!]%[y~P#/XO!]0}O!^)Wy~O!]5kO!^)Tq~O(S:zO~O!_1gO%i:}O~O!k;QO~O%i;VO~P&7ZOP$|qR$|q[$|qj$|qr$|q!S$|q!l$|q!p$|q#R$|q#n$|q#o$|q#p$|q#q$|q#r$|q#s$|q#t$|q#u$|q#v$|q#x$|q#z$|q#{$|q$O$|q(`$|q(q$|q!]$|q!^$|q~P'%zO!Q)|O'x)}O(y%POP'iaR'ia['iaj'ian'iar'ia!S'ia!l'ia!p'ia#R'ia#n'ia#o'ia#p'ia#q'ia#r'ia#s'ia#t'ia#u'ia#v'ia#x'ia#z'ia#{'ia$O'ia(`'ia(q'ia(x'ia!]'ia!^'ia~O!Q)|O'x)}OP'kaR'ka['kaj'kan'kar'ka!S'ka!l'ka!p'ka#R'ka#n'ka#o'ka#p'ka#q'ka#r'ka#s'ka#t'ka#u'ka#v'ka#x'ka#z'ka#{'ka$O'ka(`'ka(q'ka(x'ka(y'ka!]'ka!^'ka~OP%OqR%Oq[%Oqj%Oqr%Oq!S%Oq!l%Oq!p%Oq#R%Oq#n%Oq#o%Oq#p%Oq#q%Oq#r%Oq#s%Oq#t%Oq#u%Oq#v%Oq#x%Oq#z%Oq#{%Oq$O%Oq(`%Oq(q%Oq!]%Oq!^%Oq~P'%zOg%e!Z!]%e!Z#`%e!Z$O%e!Z~P!0{O!Y;ZO~P#/XOr;[O!g#vO(q'nO~O[;^O!Y;ZO~P#/XO!]'oq!^'oq~P#B]O!]#h!Z!^#h!Z~P#B]O#k%e!ZP%e!ZR%e!Z[%e!Za%e!Zj%e!Zr%e!Z!S%e!Z!]%e!Z!l%e!Z!p%e!Z#R%e!Z#n%e!Z#o%e!Z#p%e!Z#q%e!Z#r%e!Z#s%e!Z#t%e!Z#u%e!Z#v%e!Z#x%e!Z#z%e!Z#{%e!Z'y%e!Z(`%e!Z(q%e!Z!k%e!Z!Y%e!Z'v%e!Z#`%e!Zv%e!Z!_%e!Z%i%e!Z!g%e!Z~P#/XOr;fO!g#vO(q'nO~O!Y;gO~P#/XOr;nO!g#vO(q'nO~O!Y;oO~P#/XOP%e!ZR%e!Z[%e!Zj%e!Zr%e!Z!S%e!Z!l%e!Z!p%e!Z#R%e!Z#n%e!Z#o%e!Z#p%e!Z#q%e!Z#r%e!Z#s%e!Z#t%e!Z#u%e!Z#v%e!Z#x%e!Z#z%e!Z#{%e!Z$O%e!Z(`%e!Z(q%e!Z!]%e!Z!^%e!Z~P'%zOr;rO!g#vO(q'nO~Ov(eX~P1qO!Q%qO~P!)PO(T!lO~P!)PO!YfX!]fX#`fX~P%0kOP]XR]X[]Xj]Xr]X!Q]X!S]X!]]X!]fX!l]X!p]X#R]X#S]X#`]X#`fX#kfX#n]X#o]X#p]X#q]X#r]X#s]X#t]X#u]X#v]X#x]X#z]X#{]X$Q]X(`]X(q]X(x]X(y]X~O!gfX!k]X!kfX(qfX~P'JsOP;vOQ;vOSfOd=rOe!iOpkOr;vOskOtkOzkO|;vO!O;vO!SWO!WkO!XkO!_XO!i;yO!lZO!o;vO!p;vO!q;vO!s;zO!u;}O!x!hO$W!kO$n=pO(S)ZO(UTO(XUO(`VO(n[O~O!]<ZO!^$qa~Oh%VOp%WOr%XOs$tOt$tOz%YO|%ZO!O<fO!S${O!_$|O!i=wO!l$xO#j<lO$W%_O$t<hO$v<jO$y%`O(S(tO(UTO(XUO(`$uO(x$}O(y%PO~Ol)bO~P( iOr!eX(q!eX~P# }Or(iX(q(iX~P#!pO!^]X!^fX~P'JsO!YfX!Y$zX!]fX!]$zX#`fX~P!/wO#k<OO~O!g#vO#k<OO~O#`<`O~Oj<SO~O#`<pO!](vX!^(vX~O#`<`O!](tX!^(tX~O#k<qO~Og<sO~P!0{O#k<yO~O#k<zO~O!g#vO#k<{O~O!g#vO#k<qO~O$O<|O~P#B]O#k<}O~O#k=OO~O#k=TO~O#k=UO~O#k=VO~O#k=WO~O$O=XO~P!0{O$O=YO~P!0{Ok#S#T#U#W#X#[#i#j#u$n$t$v$y%]%^%h%i%j%q%s%v%w%y%{~'}T#o!X'{(T#ps#n#qr!Q'|$]'|(S$_(d~",
        goto: "$8g)[PPPPPP)]PP)`P)qP+R/WPPPP6bPP6xPP<pPPP@dP@zP@zPPP@zPCSP@zP@zP@zPCWPC]PCzPHtPPPHxPPPPHxK{PPPLRLsPHxPHxPP! RHxPPPHxPHxP!#YHxP!&p!'u!(OP!(r!(v!(r!,TPPPPPPP!,t!'uPP!-U!.vP!2SHxHx!2X!5e!:R!:R!>QPPP!>YHxPPPPPPPPP!AiP!BvPPHx!DXPHxPHxHxHxHxHxPHx!EkP!HuP!K{P!LP!LZ!L_!L_P!HrP!Lc!LcP# iP# mHxPHx# s#$xCW@zP@zP@z@zP#&V@z@z#(i@z#+a@z#-m@z@z#.]#0q#0q#0v#1P#0q#1[PP#0qP@z#1t@z#5s@z@z6bPPP#9xPPP#:c#:cP#:cP#:y#:cPP#;PP#:vP#:v#;d#:v#<O#<U#<X)`#<[)`P#<c#<c#<cP)`P)`P)`P)`PP)`P#<i#<lP#<l)`P#<pP#<sP)`P)`P)`P)`P)`P)`)`PP#<y#=P#=[#=b#=h#=n#=t#>S#>Y#>d#>j#>t#>z#?[#?b#@S#@f#@l#@r#AQ#Ag#C[#Cj#Cq#E]#Ek#G]#Gk#Gq#Gw#G}#HX#H_#He#Ho#IR#IXPPPPPPPPPPP#I_PPPPPPP#JS#MZ#Ns#Nz$ SPPP$&nP$&w$)p$0Z$0^$0a$1`$1c$1j$1rP$1x$1{P$2i$2m$3e$4s$4x$5`PP$5e$5k$5o$5r$5v$5z$6v$7_$7v$7z$7}$8Q$8W$8Z$8_$8cR!|RoqOXst!Z#d%l&p&r&s&u,n,s2S2VY!vQ'^-`1g5qQ%svQ%{yQ&S|Q&h!VS'U!e-WQ'd!iS'j!r!yU*h$|*X*lQ+l%|Q+y&UQ,_&bQ-^']Q-h'eQ-p'kQ0U*nQ1q,`R<m;z%SdOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$_$a$e%l%s&Q&i&l&p&r&s&u&y'R'`'p(R(T(Z(b(v(x(|){*f+U+Y,k,n,s-d-l-z.Q.o.v/i0V0d0l0|1j1z1{1}2P2S2V2X2x3O3d4q5y6Z6[6_6r8i8x9SS#q];w!r)]$Z$n'V)q-P-S/Q2h3{5m6i9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sU*{%[<e<fQ+q&OQ,a&eQ,h&mQ0r+dQ0w+fQ1S+rQ1y,fQ3W.bQ5V0vQ5]0}Q6Q1rQ7O3[Q8U5^R9Y7Q'QkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n%l%s&Q&i&l&m&p&r&s&u&y'R'V'`'p(R(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=s!S!nQ!r!v!y!z$|'U']'^'j'k'l*h*l*n*o-W-^-`-p0U0X1g5q5s%[$ti#v$b$c$d$x${%O%Q%]%^%b)w*P*R*T*W*^*d*t*u+c+f+},Q.a.z/_/h/r/s/u0Y0[0g0h0i1^1a1i3Z4U4V4a4f4w5R5U5x6|7l7v7|8Q8f9V9e9n9t:S:f:t:};V;^<^<_<a<b<c<d<g<h<i<j<k<l<t<u<v<w<y<z<}=O=P=Q=R=S=T=U=X=Y=p=x=y=|=}Q&V|Q'S!eS'Y%h-ZQ+q&OQ,a&eQ0f+OQ1S+rQ1X+xQ1x,eQ1y,fQ5]0}Q5f1ZQ6Q1rQ6T1tQ6U1wQ8U5^Q8X5cQ8q6WQ9|8YQ:Y8nR<o*XrnOXst!V!Z#d%l&g&p&r&s&u,n,s2S2VR,c&i&z^OPXYstuvwz!Z!`!g!j!o#S#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n%l%s&Q&i&l&m&p&r&s&u&y'R'`'p(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=r=s[#]WZ#W#Z'V(R!b%im#h#i#l$x%d%g([(f(g(h*W*[*_+W+X+Z,j-Q.O.U.V.W.Y/h/k2[3S3T4X6h6yQ%vxQ%zyS&P|&UQ&]!TQ'a!hQ'c!iQ(o#sS+k%{%|Q+o&OQ,Y&`Q,^&bS-g'd'eQ.d(pQ0{+lQ1R+rQ1T+sQ1W+wQ1l,ZS1p,_,`Q2t-hQ5[0}Q5`1QQ5e1YQ6P1qQ8T5^Q8W5bQ9x8SR:w9y!U$zi$d%O%Q%]%^%b*P*R*^*t*u.z/r0Y0[0g0h0i4V4w7|9e=p=x=y!^%xy!i!u%z%{%|'T'c'd'e'i's*g+k+l-T-g-h-o/{0O0{2m2t2{4i4j4m7s9pQ+e%vQ,O&YQ,R&ZQ,]&bQ.c(oQ1k,YU1o,^,_,`Q3].dQ5z1lS6O1p1qQ8m6P#f=t#v$b$c$x${)w*T*W*d+c+f+},Q.a/_/h/s/u1^1a1i3Z4U4a4f5R5U5x6|7l7v8Q8f9V9n9t:S:f:t:};V;^<a<c<g<i<k<t<v<y<}=P=R=T=X=|=}o=u<^<_<b<d<h<j<l<u<w<z=O=Q=S=U=YW%Ti%V*v=pS&Y!Q&gQ&Z!RQ&[!SQ+S%cR+|&W%]%Si#v$b$c$d$x${%O%Q%]%^%b)w*P*R*T*W*^*d*t*u+c+f+},Q.a.z/_/h/r/s/u0Y0[0g0h0i1^1a1i3Z4U4V4a4f4w5R5U5x6|7l7v7|8Q8f9V9e9n9t:S:f:t:};V;^<^<_<a<b<c<d<g<h<i<j<k<l<t<u<v<w<y<z<}=O=P=Q=R=S=T=U=X=Y=p=x=y=|=}T)x$u)yV*{%[<e<fW'Y!e%h*X-ZS({#y#zQ+`%qQ+v&RS.](k(lQ1b,SQ4x0cR8^5k'QkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n%l%s&Q&i&l&m&p&r&s&u&y'R'V'`'p(R(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=s$i$^c#Y#e%p%r%t(Q(W(r(w)P)Q)R)S)T)U)V)W)X)Y)[)^)`)e)o+a+u-U-s-x-}.P.n.q.u.w.x.y/]0j2c2f2v2}3c3h3i3j3k3l3m3n3o3p3q3r3s3t3w3x4P5O5Y6k6q6v7V7W7a7b8`8|9Q9[9b9c:c:y;R;x=gT#TV#U'RkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n%l%s&Q&i&l&m&p&r&s&u&y'R'V'`'p(R(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sQ'W!eR2i-W!W!nQ!e!r!v!y!z$|'U']'^'j'k'l*X*h*l*n*o-W-^-`-p0U0X1g5q5sR1d,UnqOXst!Z#d%l&p&r&s&u,n,s2S2VQ&w!^Q't!xS(q#u<OQ+i%yQ,W&]Q,X&_Q-e'bQ-r'mS.m(v<qS0k+U<{Q0y+jQ1f,VQ2Z,uQ2],vQ2e-RQ2r-fQ2u-jS5P0l=VQ5W0zS5Z0|=WQ6j2gQ6n2sQ6s2zQ8R5XQ8}6lQ9O6oQ9R6tR:`8z$d$]c#Y#e%r%t(Q(W(r(w)P)Q)R)S)T)U)V)W)X)Y)[)^)`)e)o+a+u-U-s-x-}.P.n.q.u.x.y/]0j2c2f2v2}3c3h3i3j3k3l3m3n3o3p3q3r3s3t3w3x4P5O5Y6k6q6v7V7W7a7b8`8|9Q9[9b9c:c:y;R;x=gS(m#p'gQ(}#zS+_%p.wS.^(l(nR3U._'QkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n%l%s&Q&i&l&m&p&r&s&u&y'R'V'`'p(R(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sS#q];wQ&r!XQ&s!YQ&u![Q&v!]R2R,qQ'_!hQ+b%vQ-c'aS.`(o+eQ2p-bW3Y.c.d0q0sQ6m2qW6z3V3X3]5TU9U6{6}7PU:e9W9X9ZS;T:d:gQ;b;UR;j;cU!wQ'^-`T5o1g5q!Q_OXZ`st!V!Z#d#h%d%l&g&i&p&r&s&u(h,n,s.V2S2V]!pQ!r'^-`1g5qT#q];w%^{OPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$_$a$e%l%s&Q&i&l&m&p&r&s&u&y'R'`'p(R(T(Z(b(v(x(|){*f+U+Y+d,k,n,s-d-l-z.Q.b.o.v/i0V0d0l0|1j1z1{1}2P2S2V2X2x3O3[3d4q5y6Z6[6_6r7Q8i8x9SS({#y#zS.](k(l!s=^$Z$n'V)q-P-S/Q2h3{5m6i9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sU$fd)],hS(n#p'gU*s%R(u3vU0e*z.i7]Q5T0rQ6{3WQ9X7OR:g9Ym!tQ!r!v!y!z'^'j'k'l-`-p1g5q5sQ'r!uS(d#g1|S-n'i'uQ/n*ZQ/{*gQ2|-qQ4]/oQ4i/}Q4j0OQ4o0WQ7h4WS7s4k4mS7w4p4rQ9g7iQ9k7oQ9p7tQ9u7yS:o9l9mS;Y:p:sS;e;Z;[S;m;f;gS;q;n;oR;t;rQ#wbQ'q!uS(c#g1|S(e#m+TQ+V%eQ+g%wQ+m%}U-m'i'r'uQ.R(dQ/m*ZQ/|*gQ0P*iQ0x+hQ1m,[S2y-n-qQ3R.ZS4[/n/oQ4e/yS4h/{0WQ4l0QQ5|1nQ6u2|Q7g4WQ7k4]U7r4i4o4rQ7u4nQ8k5}S9f7h7iQ9j7oQ9r7wQ9s7xQ:V8lQ:m9gS:n9k9mQ:v9uQ;P:WS;X:o:sS;d;Y;ZS;l;e;gS;p;m;oQ;s;qQ;u;tQ=a=[Q=l=eR=m=fV!wQ'^-`%^aOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$_$a$e%l%s&Q&i&l&m&p&r&s&u&y'R'`'p(R(T(Z(b(v(x(|){*f+U+Y+d,k,n,s-d-l-z.Q.b.o.v/i0V0d0l0|1j1z1{1}2P2S2V2X2x3O3[3d4q5y6Z6[6_6r7Q8i8x9SS#wz!j!r=Z$Z$n'V)q-P-S/Q2h3{5m6i9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sR=a=r%^bOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$_$a$e%l%s&Q&i&l&m&p&r&s&u&y'R'`'p(R(T(Z(b(v(x(|){*f+U+Y+d,k,n,s-d-l-z.Q.b.o.v/i0V0d0l0|1j1z1{1}2P2S2V2X2x3O3[3d4q5y6Z6[6_6r7Q8i8x9SQ%ej!^%wy!i!u%z%{%|'T'c'd'e'i's*g+k+l-T-g-h-o/{0O0{2m2t2{4i4j4m7s9pS%}z!jQ+h%xQ,[&bW1n,],^,_,`U5}1o1p1qS8l6O6PQ:W8m!r=[$Z$n'V)q-P-S/Q2h3{5m6i9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sQ=e=qR=f=r%QeOPXYstuvw!Z!`!g!o#S#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$_$a$e%l%s&Q&i&l&p&r&s&u&y'R'`'p(T(Z(b(v(x(|){*f+U+Y+d,k,n,s-d-l-z.Q.b.o.v/i0V0d0l0|1j1z1{1}2P2S2V2X2x3O3[3d4q5y6Z6[6_6r7Q8i8x9SY#bWZ#W#Z(R!b%im#h#i#l$x%d%g([(f(g(h*W*[*_+W+X+Z,j-Q.O.U.V.W.Y/h/k2[3S3T4X6h6yQ,i&m!p=]$Z$n)q-P-S/Q2h3{5m6i9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sR=`'VU'Z!e%h*XR2k-Z%SdOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$_$a$e%l%s&Q&i&l&p&r&s&u&y'R'`'p(R(T(Z(b(v(x(|){*f+U+Y,k,n,s-d-l-z.Q.o.v/i0V0d0l0|1j1z1{1}2P2S2V2X2x3O3d4q5y6Z6[6_6r8i8x9S!r)]$Z$n'V)q-P-S/Q2h3{5m6i9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sQ,h&mQ0r+dQ3W.bQ7O3[R9Y7Q!b$Tc#Y%p(Q(W(r(w)X)Y)^)e+u-s-x-}.P.n.q/]0j2v2}3c3s5O5Y6q6v7V9Q:c;x!P<U)[)o-U.w2c2f3h3q3r3w4P6k7W7a7b8`8|9[9b9c:y;R=g!f$Vc#Y%p(Q(W(r(w)U)V)X)Y)^)e+u-s-x-}.P.n.q/]0j2v2}3c3s5O5Y6q6v7V9Q:c;x!T<W)[)o-U.w2c2f3h3n3o3q3r3w4P6k7W7a7b8`8|9[9b9c:y;R=g!^$Zc#Y%p(Q(W(r(w)^)e+u-s-x-}.P.n.q/]0j2v2}3c3s5O5Y6q6v7V9Q:c;xQ4V/fz=s)[)o-U.w2c2f3h3w4P6k7W7a7b8`8|9[9b9c:y;R=gQ=x=zR=y={'QkOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n%l%s&Q&i&l&m&p&r&s&u&y'R'V'`'p(R(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sS$oh$pR3|/P'XgOPWXYZhstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n$p%l%s&Q&i&l&m&p&r&s&u&y'R'V'`'p(R(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/P/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sT$kf$qQ$ifS)h$l)lR)t$qT$jf$qT)j$l)l'XhOPWXYZhstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$Z$_$a$e$n$p%l%s&Q&i&l&m&p&r&s&u&y'R'V'`'p(R(T(Z(b(v(x(|)q){*f+U+Y+d,k,n,s-P-S-d-l-z.Q.b.o.v/P/Q/i0V0d0l0|1j1z1{1}2P2S2V2X2h2x3O3[3d3{4q5m5y6Z6[6_6i6r7Q8i8x9S9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=sT$oh$pQ$rhR)s$p%^jOPWXYZstuvw!Z!`!g!o#S#W#Z#d#o#u#x#{$O$P$Q$R$S$T$U$V$W$X$_$a$e%l%s&Q&i&l&m&p&r&s&u&y'R'`'p(R(T(Z(b(v(x(|){*f+U+Y+d,k,n,s-d-l-z.Q.b.o.v/i0V0d0l0|1j1z1{1}2P2S2V2X2x3O3[3d4q5y6Z6[6_6r7Q8i8x9S!s=q$Z$n'V)q-P-S/Q2h3{5m6i9}:a;v;y;z;}<O<P<Q<R<S<T<U<V<W<X<Y<Z<]<`<m<p<q<s<{<|=V=W=s#glOPXZst!Z!`!o#S#d#o#{$n%l&i&l&m&p&r&s&u&y'R'`(|)q*f+Y+d,k,n,s-d.b/Q/i0V0d1j1z1{1}2P2S2V2X3[3{4q5y6Z6[6_7Q8i8x!U%Ri$d%O%Q%]%^%b*P*R*^*t*u.z/r0Y0[0g0h0i4V4w7|9e=p=x=y#f(u#v$b$c$x${)w*T*W*d+c+f+},Q.a/_/h/s/u1^1a1i3Z4U4a4f5R5U5x6|7l7v8Q8f9V9n9t:S:f:t:};V;^<a<c<g<i<k<t<v<y<}=P=R=T=X=|=}Q+P%`Q/^)|o3v<^<_<b<d<h<j<l<u<w<z=O=Q=S=U=Y!U$yi$d%O%Q%]%^%b*P*R*^*t*u.z/r0Y0[0g0h0i4V4w7|9e=p=x=yQ*`$zU*i$|*X*lQ+Q%aQ0Q*j#f=c#v$b$c$x${)w*T*W*d+c+f+},Q.a/_/h/s/u1^1a1i3Z4U4a4f5R5U5x6|7l7v8Q8f9V9n9t:S:f:t:};V;^<a<c<g<i<k<t<v<y<}=P=R=T=X=|=}n=d<^<_<b<d<h<j<l<u<w<z=O=Q=S=U=YQ=h=tQ=i=uQ=j=vR=k=w!U%Ri$d%O%Q%]%^%b*P*R*^*t*u.z/r0Y0[0g0h0i4V4w7|9e=p=x=y#f(u#v$b$c$x${)w*T*W*d+c+f+},Q.a/_/h/s/u1^1a1i3Z4U4a4f5R5U5x6|7l7v8Q8f9V9n9t:S:f:t:};V;^<a<c<g<i<k<t<v<y<}=P=R=T=X=|=}o3v<^<_<b<d<h<j<l<u<w<z=O=Q=S=U=YnoOXst!Z#d%l&p&r&s&u,n,s2S2VS*c${*WQ,|&|Q,}'OR4`/s%[%Si#v$b$c$d$x${%O%Q%]%^%b)w*P*R*T*W*^*d*t*u+c+f+},Q.a.z/_/h/r/s/u0Y0[0g0h0i1^1a1i3Z4U4V4a4f4w5R5U5x6|7l7v7|8Q8f9V9e9n9t:S:f:t:};V;^<^<_<a<b<c<d<g<h<i<j<k<l<t<u<v<w<y<z<}=O=P=Q=R=S=T=U=X=Y=p=x=y=|=}Q,P&ZQ1`,RQ5i1_R8]5jV*k$|*X*lU*k$|*X*lT5p1g5qS/y*f/iQ4n0VT7x4q:PQ+g%wQ0P*iQ0x+hQ1m,[Q5|1nQ8k5}Q:V8lR;P:W!U%Oi$d%O%Q%]%^%b*P*R*^*t*u.z/r0Y0[0g0h0i4V4w7|9e=p=x=yx*P$v)c*Q*r+R/q0^0_3y4^4{4|4}7f7z9v:l=b=n=oS0Y*q0Z#f<a#v$b$c$x${)w*T*W*d+c+f+},Q.a/_/h/s/u1^1a1i3Z4U4a4f5R5U5x6|7l7v8Q8f9V9n9t:S:f:t:};V;^<a<c<g<i<k<t<v<y<}=P=R=T=X=|=}n<b<^<_<b<d<h<j<l<u<w<z=O=Q=S=U=Y!d<t(s)a*Y*b.e.h.l/Y/f/v0p1]3`4S4_4c5h7R7U7m7p7}8P9i9q9w:q:u;W;];h=z={`<u3u7X7[7`9]:h:k;kS=P.g3aT=Q7Z9`!U%Qi$d%O%Q%]%^%b*P*R*^*t*u.z/r0Y0[0g0h0i4V4w7|9e=p=x=y|*R$v)c*S*q+R/b/q0^0_3y4^4s4{4|4}7f7z9v:l=b=n=oS0[*r0]#f<c#v$b$c$x${)w*T*W*d+c+f+},Q.a/_/h/s/u1^1a1i3Z4U4a4f5R5U5x6|7l7v8Q8f9V9n9t:S:f:t:};V;^<a<c<g<i<k<t<v<y<}=P=R=T=X=|=}n<d<^<_<b<d<h<j<l<u<w<z=O=Q=S=U=Y!h<v(s)a*Y*b.f.g.l/Y/f/v0p1]3^3`4S4_4c5h7R7S7U7m7p7}8P9i9q9w:q:u;W;];h=z={d<w3u7Y7Z7`9]9^:h:i:k;kS=R.h3bT=S7[9arnOXst!V!Z#d%l&g&p&r&s&u,n,s2S2VQ&d!UR,k&mrnOXst!V!Z#d%l&g&p&r&s&u,n,s2S2VR&d!UQ,T&[R1[+|snOXst!V!Z#d%l&g&p&r&s&u,n,s2S2VQ1h,YS5w1k1lU8e5u5v5zS:R8g8hS:{:Q:TQ;_:|R;i;`Q&k!VR,d&gR6T1tR:Y8nS&P|&UR1T+sQ&p!WR,n&qR,t&vT2T,s2VR,x&wQ,w&wR2^,xQ'w!{R-t'wSsOtQ#dXT%os#dQ#OTR'y#OQ#RUR'{#RQ)y$uR/Z)yQ#UVR(O#UQ#XWU(U#X(V-{Q(V#YR-{(WQ-X'WR2j-XQ.p(wS3e.p3fR3f.qQ-`'^R2n-`Y!rQ'^-`1g5qR'h!rQ.{)cR3z.{U#_W%g*WU(]#_(^-|Q(^#`R-|(XQ-['ZR2l-[t`OXst!V!Z#d%l&g&i&p&r&s&u,n,s2S2VS#hZ%dU#r`#h.VR.V(hQ(i#jQ.S(eW.[(i.S3P6wQ3P.TR6w3QQ)l$lR/R)lQ$phR)r$pQ$`cU)_$`-w<[Q-w;xR<[)oQ/l*ZW4Y/l4Z7j9hU4Z/m/n/oS7j4[4]R9h7k$e*O$v(s)a)c*Y*b*q*r*|*}+R.g.h.j.k.l/Y/b/d/f/q/v0^0_0p1]3^3_3`3u3y4S4^4_4c4s4u4{4|4}5h7R7S7T7U7Z7[7^7_7`7f7m7p7z7}8P9]9^9_9i9q9v9w:h:i:j:k:l:q:u;W;];h;k=b=n=o=z={Q/t*bU4b/t4d7nQ4d/vR7n4cS*l$|*XR0S*lx*Q$v)c*q*r+R/q0^0_3y4^4{4|4}7f7z9v:l=b=n=o!d.e(s)a*Y*b.g.h.l/Y/f/v0p1]3`4S4_4c5h7R7U7m7p7}8P9i9q9w:q:u;W;];h=z={U/c*Q.e7Xa7X3u7Z7[7`9]:h:k;kQ0Z*qQ3a.gU4t0Z3a9`R9`7Z|*S$v)c*q*r+R/b/q0^0_3y4^4s4{4|4}7f7z9v:l=b=n=o!h.f(s)a*Y*b.g.h.l/Y/f/v0p1]3^3`4S4_4c5h7R7S7U7m7p7}8P9i9q9w:q:u;W;];h=z={U/e*S.f7Ye7Y3u7Z7[7`9]9^:h:i:k;kQ0]*rQ3b.hU4v0]3b9aR9a7[Q*w%UR0a*wQ5S0pR8O5SQ+[%jR0o+[Q5l1bS8_5l:OR:O8`Q,V&]R1e,VQ5q1gR8b5qQ1s,aS6R1s8oR8o6TQ1O+oW5_1O5a8V9zQ5a1RQ8V5`R9z8WQ+t&PR1U+tQ2V,sR6c2VYrOXst#dQ&t!ZQ+^%lQ,m&pQ,o&rQ,p&sQ,r&uQ2Q,nS2T,s2VR6b2SQ%npQ&x!_Q&{!aQ&}!bQ'P!cQ'o!uQ+]%kQ+i%yQ+{&VQ,c&kQ,z&zW-k'i'q'r'uQ-r'mQ0R*kQ0y+jS1v,d,gQ2_,yQ2`,|Q2a,}Q2u-jW2w-m-n-q-sQ5W0zQ5d1XQ5g1]Q5{1mQ6V1xQ6a2RU6p2v2y2|Q6s2zQ8R5XQ8Z5fQ8[5hQ8a5pQ8j5|Q8p6US9P6q6uQ9R6tQ9{8XQ:U8kQ:Z8qQ:b9QQ:x9|Q;O:VQ;S:cR;a;PQ%yyQ'b!iQ'm!uU+j%z%{%|Q-R'TU-f'c'd'eS-j'i'sQ/z*gS0z+k+lQ2g-TS2s-g-hQ2z-oS4g/{0OQ5X0{Q6l2mQ6o2tQ6t2{U7q4i4j4mQ9o7sR:r9pS$wi=pR*x%VU%Ui%V=pR0`*vQ$viS(s#v+fS)a$b$cQ)c$dQ*Y$xS*b${*WQ*q%OQ*r%QQ*|%]Q*}%^Q+R%bQ.g<aQ.h<cQ.j<gQ.k<iQ.l<kQ/Y)wQ/b*PQ/d*RQ/f*TQ/q*^S/v*d/hQ0^*tQ0_*ul0p+c,Q.a1a1i3Z5x6|8f9V:S:f:};VQ1]+}Q3^<tQ3_<vQ3`<yS3u<^<_Q3y.zS4S/_4UQ4^/rQ4_/sQ4c/uQ4s0YQ4u0[Q4{0gQ4|0hQ4}0iQ5h1^Q7R<}Q7S=PQ7T=RQ7U=TQ7Z<bQ7[<dQ7^<hQ7_<jQ7`<lQ7f4VQ7m4aQ7p4fQ7z4wQ7}5RQ8P5UQ9]<zQ9^<uQ9_<wQ9i7lQ9q7vQ9v7|Q9w8QQ:h=OQ:i=QQ:j=SQ:k=UQ:l9eQ:q9nQ:u9tQ;W=XQ;]:tQ;h;^Q;k=YQ=b=pQ=n=xQ=o=yQ=z=|R={=}Q*z%[Q.i<eR7]<fnpOXst!Z#d%l&p&r&s&u,n,s2S2VQ!fPS#fZ#oQ&z!`W'f!o*f0V4qQ'}#SQ)O#{Q)p$nS,g&i&lQ,l&mQ,y&yS-O'R/iQ-b'`Q.s(|Q/V)qQ0m+YQ0s+dQ2O,kQ2q-dQ3X.bQ4O/QQ4y0dQ5v1jQ6X1zQ6Y1{Q6^1}Q6`2PQ6e2XQ7P3[Q7c3{Q8h5yQ8t6ZQ8u6[Q8w6_Q9Z7QQ:T8iR:_8x#[cOPXZst!Z!`!o#d#o#{%l&i&l&m&p&r&s&u&y'R'`(|*f+Y+d,k,n,s-d.b/i0V0d1j1z1{1}2P2S2V2X3[4q5y6Z6[6_7Q8i8xQ#YWQ#eYQ%puQ%rvS%tw!gS(Q#W(TQ(W#ZQ(r#uQ(w#xQ)P$OQ)Q$PQ)R$QQ)S$RQ)T$SQ)U$TQ)V$UQ)W$VQ)X$WQ)Y$XQ)[$ZQ)^$_Q)`$aQ)e$eW)o$n)q/Q3{Q+a%sQ+u&QS-U'V2hQ-s'pS-x(R-zQ-}(ZQ.P(bQ.n(vQ.q(xQ.u;vQ.w;yQ.x;zQ.y;}Q/]){Q0j+UQ2c-PQ2f-SQ2v-lQ2}.QQ3c.oQ3h<OQ3i<PQ3j<QQ3k<RQ3l<SQ3m<TQ3n<UQ3o<VQ3p<WQ3q<XQ3r<YQ3s.vQ3t<]Q3w<`Q3x<mQ4P<ZQ5O0lQ5Y0|Q6k<pQ6q2xQ6v3OQ7V3dQ7W<qQ7a<sQ7b<{Q8`5mQ8|6iQ9Q6rQ9[<|Q9b=VQ9c=WQ:c9SQ:y9}Q;R:aQ;x#SR=g=sR#[WR'X!el!tQ!r!v!y!z'^'j'k'l-`-p1g5q5sS'T!e-WU*g$|*X*lS-T'U']S0O*h*nQ0W*oQ2m-^Q4m0UR4r0XR(y#xQ!fQT-_'^-`]!qQ!r'^-`1g5qQ#p]R'g;wR)d$dY!uQ'^-`1g5qQ'i!rS's!v!yS'u!z5sS-o'j'kQ-q'lR2{-pT#kZ%dS#jZ%dS%jm,jU(e#h#i#lS.T(f(gQ.X(hQ0n+ZQ3Q.UU3R.V.W.YS6x3S3TR9T6yd#^W#W#Z%g(R([*W+W.O/hr#gZm#h#i#l%d(f(g(h+Z.U.V.W.Y3S3T6yS*Z$x*_Q/o*[Q1|,jQ2d-QQ4W/kQ6g2[Q7i4XQ8{6hT=_'V+XV#aW%g*WU#`W%g*WS(S#W([U(X#Z+W/hS-V'V+XT-y(R.OV'[!e%h*XQ$lfR)v$qT)k$l)lR3}/PT*]$x*_T*e${*WQ0q+cQ1_,QQ3V.aQ5j1aQ5u1iQ6}3ZQ8g5xQ9W6|Q:Q8fQ:d9VQ:|:SQ;U:fQ;`:}R;c;VnqOXst!Z#d%l&p&r&s&u,n,s2S2VQ&j!VR,c&gtmOXst!U!V!Z#d%l&g&p&r&s&u,n,s2S2VR,j&mT%km,jR1c,SR,b&eQ&T|R+z&UR+p&OT&n!W&qT&o!W&qT2U,s2V",
        nodeNames: "\u26a0 ArithOp ArithOp ?. JSXStartTag LineComment BlockComment Script Hashbang ExportDeclaration export Star as VariableName String Escape from ; default FunctionDeclaration async function VariableDefinition > < TypeParamList in out const TypeDefinition extends ThisType this LiteralType ArithOp Number BooleanLiteral TemplateType InterpolationEnd Interpolation InterpolationStart NullType null VoidType void TypeofType typeof MemberExpression . PropertyName [ TemplateString Escape Interpolation super RegExp ] ArrayExpression Spread , } { ObjectExpression Property async get set PropertyDefinition Block : NewTarget new NewExpression ) ( ArgList UnaryExpression delete LogicOp BitOp YieldExpression yield AwaitExpression await ParenthesizedExpression ClassExpression class ClassBody MethodDeclaration Decorator @ MemberExpression PrivatePropertyName CallExpression TypeArgList CompareOp < declare Privacy static abstract override PrivatePropertyDefinition PropertyDeclaration readonly accessor Optional TypeAnnotation Equals StaticBlock FunctionExpression ArrowFunction ParamList ParamList ArrayPattern ObjectPattern PatternProperty Privacy readonly Arrow MemberExpression BinaryExpression ArithOp ArithOp ArithOp ArithOp BitOp CompareOp instanceof satisfies CompareOp BitOp BitOp BitOp LogicOp LogicOp ConditionalExpression LogicOp LogicOp AssignmentExpression UpdateOp PostfixExpression CallExpression InstantiationExpression TaggedTemplateExpression DynamicImport import ImportMeta JSXElement JSXSelfCloseEndTag JSXSelfClosingTag JSXIdentifier JSXBuiltin JSXIdentifier JSXNamespacedName JSXMemberExpression JSXSpreadAttribute JSXAttribute JSXAttributeValue JSXEscape JSXEndTag JSXOpenTag JSXFragmentTag JSXText JSXEscape JSXStartCloseTag JSXCloseTag PrefixCast < ArrowFunction TypeParamList SequenceExpression InstantiationExpression KeyofType keyof UniqueType unique ImportType InferredType infer TypeName ParenthesizedType FunctionSignature ParamList NewSignature IndexedType TupleType Label ArrayType ReadonlyType ObjectType MethodType PropertyType IndexSignature PropertyDefinition CallSignature TypePredicate asserts is NewSignature new UnionType LogicOp IntersectionType LogicOp ConditionalType ParameterizedType ClassDeclaration abstract implements type VariableDeclaration let var using TypeAliasDeclaration InterfaceDeclaration interface EnumDeclaration enum EnumBody NamespaceDeclaration namespace module AmbientDeclaration declare GlobalDeclaration global ClassDeclaration ClassBody AmbientFunctionDeclaration ExportGroup VariableName VariableName ImportDeclaration ImportGroup ForStatement for ForSpec ForInSpec ForOfSpec of WhileStatement while WithStatement with DoStatement do IfStatement if else SwitchStatement switch SwitchBody CaseLabel case DefaultLabel TryStatement try CatchClause catch FinallyClause finally ReturnStatement return ThrowStatement throw BreakStatement break ContinueStatement continue DebuggerStatement debugger LabeledStatement ExpressionStatement SingleExpression SingleClassItem",
        maxTerm: 379,
        context: safari,
        nodeProps: [ [ "isolate", -8, 5, 6, 14, 37, 39, 51, 53, 55, "" ], [ "group", -26, 9, 17, 19, 68, 207, 211, 215, 216, 218, 221, 224, 234, 236, 242, 244, 246, 248, 251, 257, 263, 265, 267, 269, 271, 273, 274, "Statement", -34, 13, 14, 32, 35, 36, 42, 51, 54, 55, 57, 62, 70, 72, 76, 80, 82, 84, 85, 110, 111, 120, 121, 136, 139, 141, 142, 143, 144, 145, 147, 148, 167, 169, 171, "Expression", -23, 31, 33, 37, 41, 43, 45, 173, 175, 177, 178, 180, 181, 182, 184, 185, 186, 188, 189, 190, 201, 203, 205, 206, "Type", -3, 88, 103, 109, "ClassItem" ], [ "openedBy", 23, "<", 38, "InterpolationStart", 56, "[", 60, "{", 73, "(", 160, "JSXStartCloseTag" ], [ "closedBy", -2, 24, 168, ">", 40, "InterpolationEnd", 50, "]", 61, "}", 74, ")", 165, "JSXEndTag" ] ],
        propSources: [ punctuation ],
        skippedNodes: [ 0, 5, 6, 277 ],
        repeatNodeCount: 37,
        tokenData: "$Fq07[R!bOX%ZXY+gYZ-yZ[+g[]%Z]^.c^p%Zpq+gqr/mrs3cst:_tuEruvJSvwLkwx! Yxy!'iyz!(sz{!)}{|!,q|}!.O}!O!,q!O!P!/Y!P!Q!9j!Q!R#:O!R![#<_![!]#I_!]!^#Jk!^!_#Ku!_!`$![!`!a$$v!a!b$*T!b!c$,r!c!}Er!}#O$-|#O#P$/W#P#Q$4o#Q#R$5y#R#SEr#S#T$7W#T#o$8b#o#p$<r#p#q$=h#q#r$>x#r#s$@U#s$f%Z$f$g+g$g#BYEr#BY#BZ$A`#BZ$ISEr$IS$I_$A`$I_$I|Er$I|$I}$Dk$I}$JO$Dk$JO$JTEr$JT$JU$A`$JU$KVEr$KV$KW$A`$KW&FUEr&FU&FV$A`&FV;'SEr;'S;=`I|<%l?HTEr?HT?HU$A`?HUOEr(n%d_$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z&j&hT$i&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c&j&zP;=`<%l&c'|'U]$i&j(Y!bOY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}!b(SU(Y!bOY'}Zw'}x#O'}#P;'S'};'S;=`(f<%lO'}!b(iP;=`<%l'}'|(oP;=`<%l&}'[(y]$i&j(VpOY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(rp)wU(VpOY)rZr)rs#O)r#P;'S)r;'S;=`*Z<%lO)rp*^P;=`<%l)r'[*dP;=`<%l(r#S*nX(Vp(Y!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g#S+^P;=`<%l*g(n+dP;=`<%l%Z07[+rq$i&j(Vp(Y!b'{0/lOX%ZXY+gYZ&cZ[+g[p%Zpq+gqr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p$f%Z$f$g+g$g#BY%Z#BY#BZ+g#BZ$IS%Z$IS$I_+g$I_$JT%Z$JT$JU+g$JU$KV%Z$KV$KW+g$KW&FU%Z&FU&FV+g&FV;'S%Z;'S;=`+a<%l?HT%Z?HT?HU+g?HUO%Z07[.ST(W#S$i&j'|0/lO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c07[.n_$i&j(Vp(Y!b'|0/lOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z)3p/x`$i&j!p),Q(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`0z!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW1V`#v(Ch$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`2X!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW2d_#v(Ch$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'At3l_(U':f$i&j(Y!bOY4kYZ5qZr4krs7nsw4kwx5qx!^4k!^!_8p!_#O4k#O#P5q#P#o4k#o#p8p#p;'S4k;'S;=`:X<%lO4k(^4r_$i&j(Y!bOY4kYZ5qZr4krs7nsw4kwx5qx!^4k!^!_8p!_#O4k#O#P5q#P#o4k#o#p8p#p;'S4k;'S;=`:X<%lO4k&z5vX$i&jOr5qrs6cs!^5q!^!_6y!_#o5q#o#p6y#p;'S5q;'S;=`7h<%lO5q&z6jT$d`$i&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c`6|TOr6yrs7]s;'S6y;'S;=`7b<%lO6y`7bO$d``7eP;=`<%l6y&z7kP;=`<%l5q(^7w]$d`$i&j(Y!bOY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}!r8uZ(Y!bOY8pYZ6yZr8prs9hsw8pwx6yx#O8p#O#P6y#P;'S8p;'S;=`:R<%lO8p!r9oU$d`(Y!bOY'}Zw'}x#O'}#P;'S'};'S;=`(f<%lO'}!r:UP;=`<%l8p(^:[P;=`<%l4k%9[:hh$i&j(Vp(Y!bOY%ZYZ&cZq%Zqr<Srs&}st%ZtuCruw%Zwx(rx!^%Z!^!_*g!_!c%Z!c!}Cr!}#O%Z#O#P&c#P#R%Z#R#SCr#S#T%Z#T#oCr#o#p*g#p$g%Z$g;'SCr;'S;=`El<%lOCr(r<__WS$i&j(Vp(Y!bOY<SYZ&cZr<Srs=^sw<Swx@nx!^<S!^!_Bm!_#O<S#O#P>`#P#o<S#o#pBm#p;'S<S;'S;=`Cl<%lO<S(Q=g]WS$i&j(Y!bOY=^YZ&cZw=^wx>`x!^=^!^!_?q!_#O=^#O#P>`#P#o=^#o#p?q#p;'S=^;'S;=`@h<%lO=^&n>gXWS$i&jOY>`YZ&cZ!^>`!^!_?S!_#o>`#o#p?S#p;'S>`;'S;=`?k<%lO>`S?XSWSOY?SZ;'S?S;'S;=`?e<%lO?SS?hP;=`<%l?S&n?nP;=`<%l>`!f?xWWS(Y!bOY?qZw?qwx?Sx#O?q#O#P?S#P;'S?q;'S;=`@b<%lO?q!f@eP;=`<%l?q(Q@kP;=`<%l=^'`@w]WS$i&j(VpOY@nYZ&cZr@nrs>`s!^@n!^!_Ap!_#O@n#O#P>`#P#o@n#o#pAp#p;'S@n;'S;=`Bg<%lO@ntAwWWS(VpOYApZrAprs?Ss#OAp#O#P?S#P;'SAp;'S;=`Ba<%lOAptBdP;=`<%lAp'`BjP;=`<%l@n#WBvYWS(Vp(Y!bOYBmZrBmrs?qswBmwxApx#OBm#O#P?S#P;'SBm;'S;=`Cf<%lOBm#WCiP;=`<%lBm(rCoP;=`<%l<S%9[C}i$i&j(n%1l(Vp(Y!bOY%ZYZ&cZr%Zrs&}st%ZtuCruw%Zwx(rx!Q%Z!Q![Cr![!^%Z!^!_*g!_!c%Z!c!}Cr!}#O%Z#O#P&c#P#R%Z#R#SCr#S#T%Z#T#oCr#o#p*g#p$g%Z$g;'SCr;'S;=`El<%lOCr%9[EoP;=`<%lCr07[FRk$i&j(Vp(Y!b$]#t(S,2j(d$I[OY%ZYZ&cZr%Zrs&}st%ZtuEruw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Er![!^%Z!^!_*g!_!c%Z!c!}Er!}#O%Z#O#P&c#P#R%Z#R#SEr#S#T%Z#T#oEr#o#p*g#p$g%Z$g;'SEr;'S;=`I|<%lOEr+dHRk$i&j(Vp(Y!b$]#tOY%ZYZ&cZr%Zrs&}st%ZtuGvuw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Gv![!^%Z!^!_*g!_!c%Z!c!}Gv!}#O%Z#O#P&c#P#R%Z#R#SGv#S#T%Z#T#oGv#o#p*g#p$g%Z$g;'SGv;'S;=`Iv<%lOGv+dIyP;=`<%lGv07[JPP;=`<%lEr(KWJ_`$i&j(Vp(Y!b#p(ChOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KWKl_$i&j$Q(Ch(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z,#xLva(y+JY$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sv%ZvwM{wx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KWNW`$i&j#z(Ch(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'At! c_(X';W$i&j(VpOY!!bYZ!#hZr!!brs!#hsw!!bwx!$xx!^!!b!^!_!%z!_#O!!b#O#P!#h#P#o!!b#o#p!%z#p;'S!!b;'S;=`!'c<%lO!!b'l!!i_$i&j(VpOY!!bYZ!#hZr!!brs!#hsw!!bwx!$xx!^!!b!^!_!%z!_#O!!b#O#P!#h#P#o!!b#o#p!%z#p;'S!!b;'S;=`!'c<%lO!!b&z!#mX$i&jOw!#hwx6cx!^!#h!^!_!$Y!_#o!#h#o#p!$Y#p;'S!#h;'S;=`!$r<%lO!#h`!$]TOw!$Ywx7]x;'S!$Y;'S;=`!$l<%lO!$Y`!$oP;=`<%l!$Y&z!$uP;=`<%l!#h'l!%R]$d`$i&j(VpOY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(r!Q!&PZ(VpOY!%zYZ!$YZr!%zrs!$Ysw!%zwx!&rx#O!%z#O#P!$Y#P;'S!%z;'S;=`!']<%lO!%z!Q!&yU$d`(VpOY)rZr)rs#O)r#P;'S)r;'S;=`*Z<%lO)r!Q!'`P;=`<%l!%z'l!'fP;=`<%l!!b/5|!'t_!l/.^$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#&U!)O_!k!Lf$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z-!n!*[b$i&j(Vp(Y!b(T%&f#q(ChOY%ZYZ&cZr%Zrs&}sw%Zwx(rxz%Zz{!+d{!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW!+o`$i&j(Vp(Y!b#n(ChOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z+;x!,|`$i&j(Vp(Y!br+4YOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z,$U!.Z_!]+Jf$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[!/ec$i&j(Vp(Y!b!Q.2^OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!0p!P!Q%Z!Q![!3Y![!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#%|!0ya$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!2O!P!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z#%|!2Z_![!L^$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!3eg$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!3Y![!^%Z!^!_*g!_!g%Z!g!h!4|!h#O%Z#O#P&c#P#R%Z#R#S!3Y#S#X%Z#X#Y!4|#Y#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!5Vg$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx{%Z{|!6n|}%Z}!O!6n!O!Q%Z!Q![!8S![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!8S#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!6wc$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!8S![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!8S#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad!8_c$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![!8S![!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S!8S#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[!9uf$i&j(Vp(Y!b#o(ChOY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcxz!;Zz{#-}{!P!;Z!P!Q#/d!Q!^!;Z!^!_#(i!_!`#7S!`!a#8i!a!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z?O!;fb$i&j(Vp(Y!b!X7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z>^!<w`$i&j(Y!b!X7`OY!<nYZ&cZw!<nwx!=yx!P!<n!P!Q!Eq!Q!^!<n!^!_!Gr!_!}!<n!}#O!KS#O#P!Dy#P#o!<n#o#p!Gr#p;'S!<n;'S;=`!L]<%lO!<n<z!>Q^$i&j!X7`OY!=yYZ&cZ!P!=y!P!Q!>|!Q!^!=y!^!_!@c!_!}!=y!}#O!CW#O#P!Dy#P#o!=y#o#p!@c#p;'S!=y;'S;=`!Ek<%lO!=y<z!?Td$i&j!X7`O!^&c!_#W&c#W#X!>|#X#Z&c#Z#[!>|#[#]&c#]#^!>|#^#a&c#a#b!>|#b#g&c#g#h!>|#h#i&c#i#j!>|#j#k!>|#k#m&c#m#n!>|#n#o&c#p;'S&c;'S;=`&w<%lO&c7`!@hX!X7`OY!@cZ!P!@c!P!Q!AT!Q!}!@c!}#O!Ar#O#P!Bq#P;'S!@c;'S;=`!CQ<%lO!@c7`!AYW!X7`#W#X!AT#Z#[!AT#]#^!AT#a#b!AT#g#h!AT#i#j!AT#j#k!AT#m#n!AT7`!AuVOY!ArZ#O!Ar#O#P!B[#P#Q!@c#Q;'S!Ar;'S;=`!Bk<%lO!Ar7`!B_SOY!ArZ;'S!Ar;'S;=`!Bk<%lO!Ar7`!BnP;=`<%l!Ar7`!BtSOY!@cZ;'S!@c;'S;=`!CQ<%lO!@c7`!CTP;=`<%l!@c<z!C][$i&jOY!CWYZ&cZ!^!CW!^!_!Ar!_#O!CW#O#P!DR#P#Q!=y#Q#o!CW#o#p!Ar#p;'S!CW;'S;=`!Ds<%lO!CW<z!DWX$i&jOY!CWYZ&cZ!^!CW!^!_!Ar!_#o!CW#o#p!Ar#p;'S!CW;'S;=`!Ds<%lO!CW<z!DvP;=`<%l!CW<z!EOX$i&jOY!=yYZ&cZ!^!=y!^!_!@c!_#o!=y#o#p!@c#p;'S!=y;'S;=`!Ek<%lO!=y<z!EnP;=`<%l!=y>^!Ezl$i&j(Y!b!X7`OY&}YZ&cZw&}wx&cx!^&}!^!_'}!_#O&}#O#P&c#P#W&}#W#X!Eq#X#Z&}#Z#[!Eq#[#]&}#]#^!Eq#^#a&}#a#b!Eq#b#g&}#g#h!Eq#h#i&}#i#j!Eq#j#k!Eq#k#m&}#m#n!Eq#n#o&}#o#p'}#p;'S&};'S;=`(l<%lO&}8r!GyZ(Y!b!X7`OY!GrZw!Grwx!@cx!P!Gr!P!Q!Hl!Q!}!Gr!}#O!JU#O#P!Bq#P;'S!Gr;'S;=`!J|<%lO!Gr8r!Hse(Y!b!X7`OY'}Zw'}x#O'}#P#W'}#W#X!Hl#X#Z'}#Z#[!Hl#[#]'}#]#^!Hl#^#a'}#a#b!Hl#b#g'}#g#h!Hl#h#i'}#i#j!Hl#j#k!Hl#k#m'}#m#n!Hl#n;'S'};'S;=`(f<%lO'}8r!JZX(Y!bOY!JUZw!JUwx!Arx#O!JU#O#P!B[#P#Q!Gr#Q;'S!JU;'S;=`!Jv<%lO!JU8r!JyP;=`<%l!JU8r!KPP;=`<%l!Gr>^!KZ^$i&j(Y!bOY!KSYZ&cZw!KSwx!CWx!^!KS!^!_!JU!_#O!KS#O#P!DR#P#Q!<n#Q#o!KS#o#p!JU#p;'S!KS;'S;=`!LV<%lO!KS>^!LYP;=`<%l!KS>^!L`P;=`<%l!<n=l!Ll`$i&j(Vp!X7`OY!LcYZ&cZr!Lcrs!=ys!P!Lc!P!Q!Mn!Q!^!Lc!^!_# o!_!}!Lc!}#O#%P#O#P!Dy#P#o!Lc#o#p# o#p;'S!Lc;'S;=`#&Y<%lO!Lc=l!Mwl$i&j(Vp!X7`OY(rYZ&cZr(rrs&cs!^(r!^!_)r!_#O(r#O#P&c#P#W(r#W#X!Mn#X#Z(r#Z#[!Mn#[#](r#]#^!Mn#^#a(r#a#b!Mn#b#g(r#g#h!Mn#h#i(r#i#j!Mn#j#k!Mn#k#m(r#m#n!Mn#n#o(r#o#p)r#p;'S(r;'S;=`*a<%lO(r8Q# vZ(Vp!X7`OY# oZr# ors!@cs!P# o!P!Q#!i!Q!}# o!}#O#$R#O#P!Bq#P;'S# o;'S;=`#$y<%lO# o8Q#!pe(Vp!X7`OY)rZr)rs#O)r#P#W)r#W#X#!i#X#Z)r#Z#[#!i#[#])r#]#^#!i#^#a)r#a#b#!i#b#g)r#g#h#!i#h#i)r#i#j#!i#j#k#!i#k#m)r#m#n#!i#n;'S)r;'S;=`*Z<%lO)r8Q#$WX(VpOY#$RZr#$Rrs!Ars#O#$R#O#P!B[#P#Q# o#Q;'S#$R;'S;=`#$s<%lO#$R8Q#$vP;=`<%l#$R8Q#$|P;=`<%l# o=l#%W^$i&j(VpOY#%PYZ&cZr#%Prs!CWs!^#%P!^!_#$R!_#O#%P#O#P!DR#P#Q!Lc#Q#o#%P#o#p#$R#p;'S#%P;'S;=`#&S<%lO#%P=l#&VP;=`<%l#%P=l#&]P;=`<%l!Lc?O#&kn$i&j(Vp(Y!b!X7`OY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#W%Z#W#X#&`#X#Z%Z#Z#[#&`#[#]%Z#]#^#&`#^#a%Z#a#b#&`#b#g%Z#g#h#&`#h#i%Z#i#j#&`#j#k#&`#k#m%Z#m#n#&`#n#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z9d#(r](Vp(Y!b!X7`OY#(iZr#(irs!Grsw#(iwx# ox!P#(i!P!Q#)k!Q!}#(i!}#O#+`#O#P!Bq#P;'S#(i;'S;=`#,`<%lO#(i9d#)th(Vp(Y!b!X7`OY*gZr*grs'}sw*gwx)rx#O*g#P#W*g#W#X#)k#X#Z*g#Z#[#)k#[#]*g#]#^#)k#^#a*g#a#b#)k#b#g*g#g#h#)k#h#i*g#i#j#)k#j#k#)k#k#m*g#m#n#)k#n;'S*g;'S;=`+Z<%lO*g9d#+gZ(Vp(Y!bOY#+`Zr#+`rs!JUsw#+`wx#$Rx#O#+`#O#P!B[#P#Q#(i#Q;'S#+`;'S;=`#,Y<%lO#+`9d#,]P;=`<%l#+`9d#,cP;=`<%l#(i?O#,o`$i&j(Vp(Y!bOY#,fYZ&cZr#,frs!KSsw#,fwx#%Px!^#,f!^!_#+`!_#O#,f#O#P!DR#P#Q!;Z#Q#o#,f#o#p#+`#p;'S#,f;'S;=`#-q<%lO#,f?O#-tP;=`<%l#,f?O#-zP;=`<%l!;Z07[#.[b$i&j(Vp(Y!b'}0/l!X7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z07[#/o_$i&j(Vp(Y!bT0/lOY#/dYZ&cZr#/drs#0nsw#/dwx#4Ox!^#/d!^!_#5}!_#O#/d#O#P#1p#P#o#/d#o#p#5}#p;'S#/d;'S;=`#6|<%lO#/d06j#0w]$i&j(Y!bT0/lOY#0nYZ&cZw#0nwx#1px!^#0n!^!_#3R!_#O#0n#O#P#1p#P#o#0n#o#p#3R#p;'S#0n;'S;=`#3x<%lO#0n05W#1wX$i&jT0/lOY#1pYZ&cZ!^#1p!^!_#2d!_#o#1p#o#p#2d#p;'S#1p;'S;=`#2{<%lO#1p0/l#2iST0/lOY#2dZ;'S#2d;'S;=`#2u<%lO#2d0/l#2xP;=`<%l#2d05W#3OP;=`<%l#1p01O#3YW(Y!bT0/lOY#3RZw#3Rwx#2dx#O#3R#O#P#2d#P;'S#3R;'S;=`#3r<%lO#3R01O#3uP;=`<%l#3R06j#3{P;=`<%l#0n05x#4X]$i&j(VpT0/lOY#4OYZ&cZr#4Ors#1ps!^#4O!^!_#5Q!_#O#4O#O#P#1p#P#o#4O#o#p#5Q#p;'S#4O;'S;=`#5w<%lO#4O00^#5XW(VpT0/lOY#5QZr#5Qrs#2ds#O#5Q#O#P#2d#P;'S#5Q;'S;=`#5q<%lO#5Q00^#5tP;=`<%l#5Q05x#5zP;=`<%l#4O01p#6WY(Vp(Y!bT0/lOY#5}Zr#5}rs#3Rsw#5}wx#5Qx#O#5}#O#P#2d#P;'S#5};'S;=`#6v<%lO#5}01p#6yP;=`<%l#5}07[#7PP;=`<%l#/d)3h#7ab$i&j$Q(Ch(Vp(Y!b!X7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;ZAt#8vb$Z#t$i&j(Vp(Y!b!X7`OY!;ZYZ&cZr!;Zrs!<nsw!;Zwx!Lcx!P!;Z!P!Q#&`!Q!^!;Z!^!_#(i!_!}!;Z!}#O#,f#O#P!Dy#P#o!;Z#o#p#(i#p;'S!;Z;'S;=`#-w<%lO!;Z'Ad#:Zp$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!3Y!P!Q%Z!Q![#<_![!^%Z!^!_*g!_!g%Z!g!h!4|!h#O%Z#O#P&c#P#R%Z#R#S#<_#S#U%Z#U#V#?i#V#X%Z#X#Y!4|#Y#b%Z#b#c#>_#c#d#Bq#d#l%Z#l#m#Es#m#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#<jk$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!O%Z!O!P!3Y!P!Q%Z!Q![#<_![!^%Z!^!_*g!_!g%Z!g!h!4|!h#O%Z#O#P&c#P#R%Z#R#S#<_#S#X%Z#X#Y!4|#Y#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#>j_$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#?rd$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!R#AQ!R!S#AQ!S!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#AQ#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#A]f$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!R#AQ!R!S#AQ!S!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#AQ#S#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#Bzc$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!Y#DV!Y!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#DV#S#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#Dbe$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q!Y#DV!Y!^%Z!^!_*g!_#O%Z#O#P&c#P#R%Z#R#S#DV#S#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#E|g$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![#Ge![!^%Z!^!_*g!_!c%Z!c!i#Ge!i#O%Z#O#P&c#P#R%Z#R#S#Ge#S#T%Z#T#Z#Ge#Z#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z'Ad#Gpi$i&j(Vp(Y!bs'9tOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!Q%Z!Q![#Ge![!^%Z!^!_*g!_!c%Z!c!i#Ge!i#O%Z#O#P&c#P#R%Z#R#S#Ge#S#T%Z#T#Z#Ge#Z#b%Z#b#c#>_#c#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z*)x#Il_!g$b$i&j$O)Lv(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z)[#Jv_al$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z04f#LS^h#)`#R-<U(Vp(Y!b$n7`OY*gZr*grs'}sw*gwx)rx!P*g!P!Q#MO!Q!^*g!^!_#Mt!_!`$ f!`#O*g#P;'S*g;'S;=`+Z<%lO*g(n#MXX$k&j(Vp(Y!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g(El#M}Z#r(Ch(Vp(Y!bOY*gZr*grs'}sw*gwx)rx!_*g!_!`#Np!`#O*g#P;'S*g;'S;=`+Z<%lO*g(El#NyX$Q(Ch(Vp(Y!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g(El$ oX#s(Ch(Vp(Y!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g*)x$!ga#`*!Y$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`0z!`!a$#l!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(K[$#w_#k(Cl$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z*)x$%Vag!*r#s(Ch$f#|$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`$&[!`!a$'f!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$&g_#s(Ch$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$'qa#r(Ch$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`!a$(v!a#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$)R`#r(Ch$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(Kd$*`a(q(Ct$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!a%Z!a!b$+e!b#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$+p`$i&j#{(Ch(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z%#`$,}_!|$Ip$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z04f$.X_!S0,v$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(n$/]Z$i&jO!^$0O!^!_$0f!_#i$0O#i#j$0k#j#l$0O#l#m$2^#m#o$0O#o#p$0f#p;'S$0O;'S;=`$4i<%lO$0O(n$0VT_#S$i&jO!^&c!_#o&c#p;'S&c;'S;=`&w<%lO&c#S$0kO_#S(n$0p[$i&jO!Q&c!Q![$1f![!^&c!_!c&c!c!i$1f!i#T&c#T#Z$1f#Z#o&c#o#p$3|#p;'S&c;'S;=`&w<%lO&c(n$1kZ$i&jO!Q&c!Q![$2^![!^&c!_!c&c!c!i$2^!i#T&c#T#Z$2^#Z#o&c#p;'S&c;'S;=`&w<%lO&c(n$2cZ$i&jO!Q&c!Q![$3U![!^&c!_!c&c!c!i$3U!i#T&c#T#Z$3U#Z#o&c#p;'S&c;'S;=`&w<%lO&c(n$3ZZ$i&jO!Q&c!Q![$0O![!^&c!_!c&c!c!i$0O!i#T&c#T#Z$0O#Z#o&c#p;'S&c;'S;=`&w<%lO&c#S$4PR!Q![$4Y!c!i$4Y#T#Z$4Y#S$4]S!Q![$4Y!c!i$4Y#T#Z$4Y#q#r$0f(n$4lP;=`<%l$0O#1[$4z_!Y#)l$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z(KW$6U`#x(Ch$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z+;p$7c_$i&j(Vp(Y!b(`+4QOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[$8qk$i&j(Vp(Y!b(S,2j$_#t(d$I[OY%ZYZ&cZr%Zrs&}st%Ztu$8buw%Zwx(rx}%Z}!O$:f!O!Q%Z!Q![$8b![!^%Z!^!_*g!_!c%Z!c!}$8b!}#O%Z#O#P&c#P#R%Z#R#S$8b#S#T%Z#T#o$8b#o#p*g#p$g%Z$g;'S$8b;'S;=`$<l<%lO$8b+d$:qk$i&j(Vp(Y!b$_#tOY%ZYZ&cZr%Zrs&}st%Ztu$:fuw%Zwx(rx}%Z}!O$:f!O!Q%Z!Q![$:f![!^%Z!^!_*g!_!c%Z!c!}$:f!}#O%Z#O#P&c#P#R%Z#R#S$:f#S#T%Z#T#o$:f#o#p*g#p$g%Z$g;'S$:f;'S;=`$<f<%lO$:f+d$<iP;=`<%l$:f07[$<oP;=`<%l$8b#Jf$<{X!_#Hb(Vp(Y!bOY*gZr*grs'}sw*gwx)rx#O*g#P;'S*g;'S;=`+Z<%lO*g,#x$=sa(x+JY$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_!`Ka!`#O%Z#O#P&c#P#o%Z#o#p*g#p#q$+e#q;'S%Z;'S;=`+a<%lO%Z)>v$?V_!^(CdvBr$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z?O$@a_!q7`$i&j(Vp(Y!bOY%ZYZ&cZr%Zrs&}sw%Zwx(rx!^%Z!^!_*g!_#O%Z#O#P&c#P#o%Z#o#p*g#p;'S%Z;'S;=`+a<%lO%Z07[$Aq|$i&j(Vp(Y!b'{0/l$]#t(S,2j(d$I[OX%ZXY+gYZ&cZ[+g[p%Zpq+gqr%Zrs&}st%ZtuEruw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Er![!^%Z!^!_*g!_!c%Z!c!}Er!}#O%Z#O#P&c#P#R%Z#R#SEr#S#T%Z#T#oEr#o#p*g#p$f%Z$f$g+g$g#BYEr#BY#BZ$A`#BZ$ISEr$IS$I_$A`$I_$JTEr$JT$JU$A`$JU$KVEr$KV$KW$A`$KW&FUEr&FU&FV$A`&FV;'SEr;'S;=`I|<%l?HTEr?HT?HU$A`?HUOEr07[$D|k$i&j(Vp(Y!b'|0/l$]#t(S,2j(d$I[OY%ZYZ&cZr%Zrs&}st%ZtuEruw%Zwx(rx}%Z}!OGv!O!Q%Z!Q![Er![!^%Z!^!_*g!_!c%Z!c!}Er!}#O%Z#O#P&c#P#R%Z#R#SEr#S#T%Z#T#oEr#o#p*g#p$g%Z$g;'SEr;'S;=`I|<%lOEr",
        tokenizers: [ selectDocStart, cursorDocEnd, selectDocEnd, gecko, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, cursorDocStart, new LocalTokenGroup("$S~RRtu[#O#Pg#S#T#|~_P#o#pb~gOx~~jVO#i!P#i#j!U#j#l!P#l#m!q#m;'S!P;'S;=`#v<%lO!P~!UO!U~~!XS!Q![!e!c!i!e#T#Z!e#o#p#Z~!hR!Q![!q!c!i!q#T#Z!q~!tR!Q![!}!c!i!}#T#Z!}~#QR!Q![!P!c!i!P#T#Z!P~#^R!Q![#g!c!i#g#T#Z#g~#jS!Q![#g!c!i#g#T#Z#g#q#r!P~#yP;=`<%l!P~$RO(b~~", 141, 339), new LocalTokenGroup("j~RQYZXz{^~^O(P~~aP!P!Qd~iO(Q~~", 25, 322) ],
        topRules: {
            Script: [ 0, 7 ],
            SingleExpression: [ 1, 275 ],
            SingleClassItem: [ 2, 276 ]
        },
        dialects: {
            jsx: 0,
            ts: 15098
        },
        dynamicPrecedences: {
            80: 1,
            82: 1,
            94: 1,
            169: 1,
            199: 1
        },
        specialized: [ {
            term: 326,
            get: value => spec_identifier[value] || -1
        }, {
            term: 342,
            get: value => spec_word[value] || -1
        }, {
            term: 95,
            get: value => spec_LessThan[value] || -1
        } ],
        tokenPrec: 15124
    });
    const snippets = [ snippetCompletion("function ${name}(${params}) {\n\t${}\n}", {
        label: "function",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion("for (let ${index} = 0; ${index} < ${bound}; ${index}++) {\n\t${}\n}", {
        label: "for",
        detail: "loop",
        type: "keyword"
    }), snippetCompletion("for (let ${name} of ${collection}) {\n\t${}\n}", {
        label: "for",
        detail: "of loop",
        type: "keyword"
    }), snippetCompletion("do {\n\t${}\n} while (${})", {
        label: "do",
        detail: "loop",
        type: "keyword"
    }), snippetCompletion("while (${}) {\n\t${}\n}", {
        label: "while",
        detail: "loop",
        type: "keyword"
    }), snippetCompletion("try {\n\t${}\n} catch (${error}) {\n\t${}\n}", {
        label: "try",
        detail: "/ catch block",
        type: "keyword"
    }), snippetCompletion("if (${}) {\n\t${}\n}", {
        label: "if",
        detail: "block",
        type: "keyword"
    }), snippetCompletion("if (${}) {\n\t${}\n} else {\n\t${}\n}", {
        label: "if",
        detail: "/ else block",
        type: "keyword"
    }), snippetCompletion("class ${name} {\n\tconstructor(${params}) {\n\t\t${}\n\t}\n}", {
        label: "class",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion('import {${names}} from "${module}"\n${}', {
        label: "import",
        detail: "named",
        type: "keyword"
    }), snippetCompletion('import ${name} from "${module}"\n${}', {
        label: "import",
        detail: "default",
        type: "keyword"
    }) ], typescriptSnippets = snippets.concat([ snippetCompletion("interface ${name} {\n\t${}\n}", {
        label: "interface",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion("type ${name} = ${type}", {
        label: "type",
        detail: "definition",
        type: "keyword"
    }), snippetCompletion("enum ${name} {\n\t${}\n}", {
        label: "enum",
        detail: "definition",
        type: "keyword"
    }) ]), cache = new NodeWeakMap(), ScopeNodes = new Set([ "Script", "Block", "FunctionExpression", "FunctionDeclaration", "ArrowFunction", "MethodDeclaration", "ForStatement" ]);
    function defID(type) {
        return (node, def) => {
            node = node.node.getChild("VariableDefinition");
            return node && def(node, type), !0;
        };
    }
    const functionContext = [ "FunctionDeclaration" ], gatherCompletions = {
        FunctionDeclaration: defID("function"),
        ClassDeclaration: defID("class"),
        ClassExpression: () => !0,
        EnumDeclaration: defID("constant"),
        TypeAliasDeclaration: defID("type"),
        NamespaceDeclaration: defID("namespace"),
        VariableDefinition(node, def) {
            node.matchContext(functionContext) || def(node, "variable");
        },
        TypeDefinition(node, def) {
            def(node, "type");
        },
        __proto__: null
    };
    const Identifier = /^[\w$\xa1-\uffff][\w$\d\xa1-\uffff]*$/, dontComplete = [ "TemplateString", "String", "RegExp", "LineComment", "BlockComment", "VariableDefinition", "TypeDefinition", "Label", "PropertyDefinition", "PropertyName", "PrivatePropertyDefinition", "PrivatePropertyName", "JSXText", "JSXAttributeValue", "JSXOpenTag", "JSXCloseTag", "JSXSelfClosingTag", ".", "?." ];
    function localCompletionSource(context) {
        var inner = syntaxTree(context.state).resolveInner(context.pos, -1);
        if (-1 < dontComplete.indexOf(inner.name)) return null;
        var isWord = "VariableName" == inner.name || inner.to - inner.from < 20 && Identifier.test(context.state.sliceDoc(inner.from, inner.to));
        if (!isWord && !context.explicit) return null;
        let options = [];
        for (let pos = inner; pos; pos = pos.parent) ScopeNodes.has(pos.name) && (options = options.concat(function getScope(doc, node) {
            var cached = cache.get(node);
            if (cached) return cached;
            let completions = [], top = !0;
            function def(node, type) {
                node = doc.sliceString(node.from, node.to), completions.push({
                    label: node,
                    type: type
                });
            }
            return node.cursor(IterMode.IncludeAnonymous).iterate(node => {
                if (top) top = !1; else if (node.name) {
                    var gather = gatherCompletions[node.name];
                    if (gather && gather(node, def) || ScopeNodes.has(node.name)) return !1;
                } else if (8192 < node.to - node.from) {
                    for (var c of getScope(doc, node.node)) completions.push(c);
                    return !1;
                }
            }), cache.set(node, completions), completions;
        }(context.state.doc, pos)));
        return {
            options: options,
            from: isWord ? inner.from : context.pos,
            validFor: Identifier
        };
    }
    const javascriptLanguage = LRLanguage.define({
        name: "javascript",
        parser: ie_edge.configure({
            props: [ indentNodeProp.add({
                IfStatement: continuedIndent({
                    except: /^\s*({|else\b)/
                }),
                TryStatement: continuedIndent({
                    except: /^\s*({|catch\b|finally\b)/
                }),
                LabeledStatement: context => context.baseIndent,
                SwitchBody: context => {
                    var after = context.textAfter, closed = /^\s*\}/.test(after), after = /^\s*(case|default)\b/.test(after);
                    return context.baseIndent + (closed ? 0 : after ? 1 : 2) * context.unit;
                },
                Block: delimitedIndent({
                    closing: "}"
                }),
                ArrowFunction: cx => cx.baseIndent + cx.unit,
                "TemplateString BlockComment": () => null,
                "Statement Property": continuedIndent({
                    except: /^\s*{/
                }),
                JSXElement(context) {
                    var closed = /^\s*<\//.test(context.textAfter);
                    return context.lineIndent(context.node.from) + (closed ? 0 : context.unit);
                },
                JSXEscape(context) {
                    var closed = /\s*\}/.test(context.textAfter);
                    return context.lineIndent(context.node.from) + (closed ? 0 : context.unit);
                },
                "JSXOpenTag JSXSelfClosingTag"(context) {
                    return context.column(context.node.from) + context.unit;
                }
            }), foldNodeProp.add({
                "Block ClassBody SwitchBody EnumBody ObjectExpression ArrayExpression ObjectType": foldInside,
                BlockComment(tree) {
                    return {
                        from: tree.from + 2,
                        to: tree.to - 2
                    };
                }
            }) ]
        }),
        languageData: {
            closeBrackets: {
                brackets: [ "(", "[", "{", "'", '"', "`" ]
            },
            commentTokens: {
                line: "//",
                block: {
                    open: "/*",
                    close: "*/"
                }
            },
            indentOnInput: /^\s*(?:case |default:|\{|\}|<\/)$/,
            wordChars: "$"
        }
    }), jsxSublanguage = {
        test: node => /^JSX/.test(node.name),
        facet: defineLanguageFacet({
            commentTokens: {
                block: {
                    open: "{/*",
                    close: "*/}"
                }
            }
        })
    }, typescriptLanguage = javascriptLanguage.configure({
        dialect: "ts"
    }, "typescript"), jsxLanguage = javascriptLanguage.configure({
        dialect: "jsx",
        props: [ sublanguageProp.add(n => n.isTop ? [ jsxSublanguage ] : void 0) ]
    }), tsxLanguage = javascriptLanguage.configure({
        dialect: "jsx ts",
        props: [ sublanguageProp.add(n => n.isTop ? [ jsxSublanguage ] : void 0) ]
    }, "typescript");
    bracket = name => ({
        label: name,
        type: "keyword"
    });
    const keywords$1 = "break case const continue default delete export extends false finally in instanceof let new return static super switch this throw true typeof var yield".split(" ").map(bracket), typescriptKeywords = keywords$1.concat([ "declare", "implements", "private", "protected", "public" ].map(bracket));
    function javascript(config = {}) {
        var nodes, source, lang = config.jsx ? config.typescript ? tsxLanguage : jsxLanguage : config.typescript ? typescriptLanguage : javascriptLanguage, completions = config.typescript ? typescriptSnippets.concat(typescriptKeywords) : snippets.concat(keywords$1);
        return new LanguageSupport(lang, [ javascriptLanguage.data.of({
            autocomplete: (nodes = dontComplete, source = completeFromList(completions), 
            context => {
                for (let pos = syntaxTree(context.state).resolveInner(context.pos, -1); pos; pos = pos.parent) {
                    if (-1 < nodes.indexOf(pos.name)) return null;
                    if (pos.type.isTop) break;
                }
                return source(context);
            })
        }), javascriptLanguage.data.of({
            autocomplete: localCompletionSource
        }), config.jsx ? autoCloseTags$1 : [] ]);
    }
    function elementName$1(doc, tree, max = doc.length) {
        for (let ch = null == tree ? void 0 : tree.firstChild; ch; ch = ch.nextSibling) if ("JSXIdentifier" == ch.name || "JSXBuiltin" == ch.name || "JSXNamespacedName" == ch.name || "JSXMemberExpression" == ch.name) return doc.sliceString(ch.from, Math.min(ch.to, max));
        return "";
    }
    const android = "object" == typeof navigator && /Android\b/.test(navigator.userAgent), autoCloseTags$1 = EditorView.inputHandler.of((view, from, to, text, defaultInsert) => {
        if ((android ? view.composing : view.compositionStarted) || view.state.readOnly || from != to || ">" != text && "/" != text || !javascriptLanguage.isActiveAt(view.state, from, -1)) return !1;
        let base = defaultInsert(), state = base["state"];
        to = state.changeByRange(range => {
            let head = range["head"], around = syntaxTree(state).resolveInner(head - 1, -1), name;
            if ("JSXStartTag" == around.name && (around = around.parent), !(state.doc.sliceString(head - 1, head) != text || "JSXAttributeValue" == around.name && around.to > head)) {
                if (">" == text && "JSXFragmentTag" == around.name) return {
                    range: range,
                    changes: {
                        from: head,
                        insert: "</>"
                    }
                };
                if ("/" == text && "JSXStartCloseTag" == around.name) {
                    var empty = around.parent, base = empty.parent;
                    if (base && empty.from == head - 2 && ((name = elementName$1(state.doc, base.firstChild, head)) || "JSXFragmentTag" == (null == (empty = base.firstChild) ? void 0 : empty.name))) return base = name + ">", 
                    {
                        range: EditorSelection.cursor(head + base.length, -1),
                        changes: {
                            from: head,
                            insert: base
                        }
                    };
                } else if (">" == text) {
                    empty = function(node) {
                        for (;;) {
                            if ("JSXOpenTag" == node.name || "JSXSelfClosingTag" == node.name || "JSXFragmentTag" == node.name) return node;
                            if ("JSXEscape" == node.name || !node.parent) return null;
                            node = node.parent;
                        }
                    }(around);
                    if (empty && "JSXOpenTag" == empty.name && !/^\/?>|^<\//.test(state.doc.sliceString(head, head + 2)) && (name = elementName$1(state.doc, empty, head))) return {
                        range: range,
                        changes: {
                            from: head,
                            insert: `</${name}>`
                        }
                    };
                }
            }
            return {
                range: range
            };
        });
        return !to.changes.empty && (view.dispatch([ base, state.update(to, {
            userEvent: "input.complete",
            scrollIntoView: !0
        }) ]), !0);
    });
    meta = [ "_blank", "_self", "_top", "_parent" ], insertNewlineAndIndent = [ "ascii", "utf-8", "utf-16", "latin1", "latin1" ], 
    operator = [ "get", "post", "put", "delete" ], nav = [ "application/x-www-form-urlencoded", "multipart/form-data", "text/plain" ], 
    indentMore = [ "true", "false" ], deleteGroupBackward = {};
    const Tags = {
        a: {
            attrs: {
                href: null,
                ping: null,
                type: null,
                media: null,
                target: meta,
                hreflang: null
            }
        },
        abbr: deleteGroupBackward,
        address: deleteGroupBackward,
        area: {
            attrs: {
                alt: null,
                coords: null,
                href: null,
                target: null,
                ping: null,
                media: null,
                hreflang: null,
                type: null,
                shape: [ "default", "rect", "circle", "poly" ]
            }
        },
        article: deleteGroupBackward,
        aside: deleteGroupBackward,
        audio: {
            attrs: {
                src: null,
                mediagroup: null,
                crossorigin: [ "anonymous", "use-credentials" ],
                preload: [ "none", "metadata", "auto" ],
                autoplay: [ "autoplay" ],
                loop: [ "loop" ],
                controls: [ "controls" ]
            }
        },
        b: deleteGroupBackward,
        base: {
            attrs: {
                href: null,
                target: meta
            }
        },
        bdi: deleteGroupBackward,
        bdo: deleteGroupBackward,
        blockquote: {
            attrs: {
                cite: null
            }
        },
        body: deleteGroupBackward,
        br: deleteGroupBackward,
        button: {
            attrs: {
                form: null,
                formaction: null,
                name: null,
                value: null,
                autofocus: [ "autofocus" ],
                disabled: [ "autofocus" ],
                formenctype: nav,
                formmethod: operator,
                formnovalidate: [ "novalidate" ],
                formtarget: meta,
                type: [ "submit", "reset", "button" ]
            }
        },
        canvas: {
            attrs: {
                width: null,
                height: null
            }
        },
        caption: deleteGroupBackward,
        center: deleteGroupBackward,
        cite: deleteGroupBackward,
        code: deleteGroupBackward,
        col: {
            attrs: {
                span: null
            }
        },
        colgroup: {
            attrs: {
                span: null
            }
        },
        command: {
            attrs: {
                type: [ "command", "checkbox", "radio" ],
                label: null,
                icon: null,
                radiogroup: null,
                command: null,
                title: null,
                disabled: [ "disabled" ],
                checked: [ "checked" ]
            }
        },
        data: {
            attrs: {
                value: null
            }
        },
        datagrid: {
            attrs: {
                disabled: [ "disabled" ],
                multiple: [ "multiple" ]
            }
        },
        datalist: {
            attrs: {
                data: null
            }
        },
        dd: deleteGroupBackward,
        del: {
            attrs: {
                cite: null,
                datetime: null
            }
        },
        details: {
            attrs: {
                open: [ "open" ]
            }
        },
        dfn: deleteGroupBackward,
        div: deleteGroupBackward,
        dl: deleteGroupBackward,
        dt: deleteGroupBackward,
        em: deleteGroupBackward,
        embed: {
            attrs: {
                src: null,
                type: null,
                width: null,
                height: null
            }
        },
        eventsource: {
            attrs: {
                src: null
            }
        },
        fieldset: {
            attrs: {
                disabled: [ "disabled" ],
                form: null,
                name: null
            }
        },
        figcaption: deleteGroupBackward,
        figure: deleteGroupBackward,
        footer: deleteGroupBackward,
        form: {
            attrs: {
                action: null,
                name: null,
                "accept-charset": insertNewlineAndIndent,
                autocomplete: [ "on", "off" ],
                enctype: nav,
                method: operator,
                novalidate: [ "novalidate" ],
                target: meta
            }
        },
        h1: deleteGroupBackward,
        h2: deleteGroupBackward,
        h3: deleteGroupBackward,
        h4: deleteGroupBackward,
        h5: deleteGroupBackward,
        h6: deleteGroupBackward,
        head: {
            children: [ "title", "base", "link", "style", "meta", "script", "noscript", "command" ]
        },
        header: deleteGroupBackward,
        hgroup: deleteGroupBackward,
        hr: deleteGroupBackward,
        html: {
            attrs: {
                manifest: null
            }
        },
        i: deleteGroupBackward,
        iframe: {
            attrs: {
                src: null,
                srcdoc: null,
                name: null,
                width: null,
                height: null,
                sandbox: [ "allow-top-navigation", "allow-same-origin", "allow-forms", "allow-scripts" ],
                seamless: [ "seamless" ]
            }
        },
        img: {
            attrs: {
                alt: null,
                src: null,
                ismap: null,
                usemap: null,
                width: null,
                height: null,
                crossorigin: [ "anonymous", "use-credentials" ]
            }
        },
        input: {
            attrs: {
                alt: null,
                dirname: null,
                form: null,
                formaction: null,
                height: null,
                list: null,
                max: null,
                maxlength: null,
                min: null,
                name: null,
                pattern: null,
                placeholder: null,
                size: null,
                src: null,
                step: null,
                value: null,
                width: null,
                accept: [ "audio/*", "video/*", "image/*" ],
                autocomplete: [ "on", "off" ],
                autofocus: [ "autofocus" ],
                checked: [ "checked" ],
                disabled: [ "disabled" ],
                formenctype: nav,
                formmethod: operator,
                formnovalidate: [ "novalidate" ],
                formtarget: meta,
                multiple: [ "multiple" ],
                readonly: [ "readonly" ],
                required: [ "required" ],
                type: [ "hidden", "text", "search", "tel", "url", "email", "password", "datetime", "date", "month", "week", "time", "datetime-local", "number", "range", "color", "checkbox", "radio", "file", "submit", "image", "reset", "button" ]
            }
        },
        ins: {
            attrs: {
                cite: null,
                datetime: null
            }
        },
        kbd: deleteGroupBackward,
        keygen: {
            attrs: {
                challenge: null,
                form: null,
                name: null,
                autofocus: [ "autofocus" ],
                disabled: [ "disabled" ],
                keytype: [ "RSA" ]
            }
        },
        label: {
            attrs: {
                for: null,
                form: null
            }
        },
        legend: deleteGroupBackward,
        li: {
            attrs: {
                value: null
            }
        },
        link: {
            attrs: {
                href: null,
                type: null,
                hreflang: null,
                media: null,
                sizes: [ "all", "16x16", "16x16 32x32", "16x16 32x32 64x64" ]
            }
        },
        map: {
            attrs: {
                name: null
            }
        },
        mark: deleteGroupBackward,
        menu: {
            attrs: {
                label: null,
                type: [ "list", "context", "toolbar" ]
            }
        },
        meta: {
            attrs: {
                content: null,
                charset: insertNewlineAndIndent,
                name: [ "viewport", "application-name", "author", "description", "generator", "keywords" ],
                "http-equiv": [ "content-language", "content-type", "default-style", "refresh" ]
            }
        },
        meter: {
            attrs: {
                value: null,
                min: null,
                low: null,
                high: null,
                max: null,
                optimum: null
            }
        },
        nav: deleteGroupBackward,
        noscript: deleteGroupBackward,
        object: {
            attrs: {
                data: null,
                type: null,
                name: null,
                usemap: null,
                form: null,
                width: null,
                height: null,
                typemustmatch: [ "typemustmatch" ]
            }
        },
        ol: {
            attrs: {
                reversed: [ "reversed" ],
                start: null,
                type: [ "1", "a", "A", "i", "I" ]
            },
            children: [ "li", "script", "template", "ul", "ol" ]
        },
        optgroup: {
            attrs: {
                disabled: [ "disabled" ],
                label: null
            }
        },
        option: {
            attrs: {
                disabled: [ "disabled" ],
                label: null,
                selected: [ "selected" ],
                value: null
            }
        },
        output: {
            attrs: {
                for: null,
                form: null,
                name: null
            }
        },
        p: deleteGroupBackward,
        param: {
            attrs: {
                name: null,
                value: null
            }
        },
        pre: deleteGroupBackward,
        progress: {
            attrs: {
                value: null,
                max: null
            }
        },
        q: {
            attrs: {
                cite: null
            }
        },
        rp: deleteGroupBackward,
        rt: deleteGroupBackward,
        ruby: deleteGroupBackward,
        samp: deleteGroupBackward,
        script: {
            attrs: {
                type: [ "text/javascript" ],
                src: null,
                async: [ "async" ],
                defer: [ "defer" ],
                charset: insertNewlineAndIndent
            }
        },
        section: deleteGroupBackward,
        select: {
            attrs: {
                form: null,
                name: null,
                size: null,
                autofocus: [ "autofocus" ],
                disabled: [ "disabled" ],
                multiple: [ "multiple" ]
            }
        },
        slot: {
            attrs: {
                name: null
            }
        },
        small: deleteGroupBackward,
        source: {
            attrs: {
                src: null,
                type: null,
                media: null
            }
        },
        span: deleteGroupBackward,
        strong: deleteGroupBackward,
        style: {
            attrs: {
                type: [ "text/css" ],
                media: null,
                scoped: null
            }
        },
        sub: deleteGroupBackward,
        summary: deleteGroupBackward,
        sup: deleteGroupBackward,
        table: deleteGroupBackward,
        tbody: deleteGroupBackward,
        td: {
            attrs: {
                colspan: null,
                rowspan: null,
                headers: null
            }
        },
        template: deleteGroupBackward,
        textarea: {
            attrs: {
                dirname: null,
                form: null,
                maxlength: null,
                name: null,
                placeholder: null,
                rows: null,
                cols: null,
                autofocus: [ "autofocus" ],
                disabled: [ "disabled" ],
                readonly: [ "readonly" ],
                required: [ "required" ],
                wrap: [ "soft", "hard" ]
            }
        },
        tfoot: deleteGroupBackward,
        th: {
            attrs: {
                colspan: null,
                rowspan: null,
                headers: null,
                scope: [ "row", "col", "rowgroup", "colgroup" ]
            }
        },
        thead: deleteGroupBackward,
        time: {
            attrs: {
                datetime: null
            }
        },
        title: deleteGroupBackward,
        tr: deleteGroupBackward,
        track: {
            attrs: {
                src: null,
                label: null,
                default: null,
                kind: [ "subtitles", "captions", "descriptions", "chapters", "metadata" ],
                srclang: null
            }
        },
        ul: {
            children: [ "li", "script", "template", "ul", "ol" ]
        },
        var: deleteGroupBackward,
        video: {
            attrs: {
                src: null,
                poster: null,
                width: null,
                height: null,
                crossorigin: [ "anonymous", "use-credentials" ],
                preload: [ "auto", "metadata", "none" ],
                autoplay: [ "autoplay" ],
                mediagroup: [ "movie" ],
                muted: [ "muted" ],
                controls: [ "controls" ]
            }
        },
        wbr: deleteGroupBackward
    }, GlobalAttrs = {
        accesskey: null,
        class: null,
        contenteditable: indentMore,
        contextmenu: null,
        dir: [ "ltr", "rtl", "auto" ],
        draggable: [ "true", "false", "auto" ],
        dropzone: [ "copy", "move", "link", "string:", "file:" ],
        hidden: [ "hidden" ],
        id: null,
        inert: [ "inert" ],
        itemid: null,
        itemprop: null,
        itemref: null,
        itemscope: [ "itemscope" ],
        itemtype: null,
        lang: [ "ar", "bn", "de", "en-GB", "en-US", "es", "fr", "hi", "id", "ja", "pa", "pt", "ru", "tr", "zh" ],
        spellcheck: indentMore,
        autocorrect: indentMore,
        autocapitalize: indentMore,
        style: null,
        tabindex: null,
        title: null,
        translate: [ "yes", "no" ],
        rel: [ "stylesheet", "alternate", "author", "bookmark", "help", "license", "next", "nofollow", "noreferrer", "prefetch", "prev", "search", "tag" ],
        role: "alert application article banner button cell checkbox complementary contentinfo dialog document feed figure form grid gridcell heading img list listbox listitem main navigation region row rowgroup search switch tab table tabpanel textbox timer".split(" "),
        "aria-activedescendant": null,
        "aria-atomic": indentMore,
        "aria-autocomplete": [ "inline", "list", "both", "none" ],
        "aria-busy": indentMore,
        "aria-checked": [ "true", "false", "mixed", "undefined" ],
        "aria-controls": null,
        "aria-describedby": null,
        "aria-disabled": indentMore,
        "aria-dropeffect": null,
        "aria-expanded": [ "true", "false", "undefined" ],
        "aria-flowto": null,
        "aria-grabbed": [ "true", "false", "undefined" ],
        "aria-haspopup": indentMore,
        "aria-hidden": indentMore,
        "aria-invalid": [ "true", "false", "grammar", "spelling" ],
        "aria-label": null,
        "aria-labelledby": null,
        "aria-level": null,
        "aria-live": [ "off", "polite", "assertive" ],
        "aria-multiline": indentMore,
        "aria-multiselectable": indentMore,
        "aria-owns": null,
        "aria-posinset": null,
        "aria-pressed": [ "true", "false", "mixed", "undefined" ],
        "aria-readonly": indentMore,
        "aria-relevant": null,
        "aria-required": indentMore,
        "aria-selected": [ "true", "false", "undefined" ],
        "aria-setsize": null,
        "aria-sort": [ "ascending", "descending", "none", "other" ],
        "aria-valuemax": null,
        "aria-valuemin": null,
        "aria-valuenow": null,
        "aria-valuetext": null
    };
    var a, ie_11up = "beforeunload copy cut dragstart dragover dragleave dragenter dragend drag paste focus blur change click load mousedown mouseenter mouseleave mouseup keydown keyup resize scroll unload".split(" ").map(n => "on" + n);
    for (a of ie_11up) GlobalAttrs[a] = null;
    class Schema {
        constructor(extraTags, extraAttrs) {
            this.tags = Object.assign(Object.assign({}, Tags), extraTags), this.globalAttrs = Object.assign(Object.assign({}, GlobalAttrs), extraAttrs), 
            this.allTags = Object.keys(this.tags), this.globalAttrNames = Object.keys(this.globalAttrs);
        }
    }
    function elementName(doc, tree, max = doc.length) {
        return (tree = (tree = tree && tree.firstChild) && tree.getChild("TagName")) ? doc.sliceString(tree.from, Math.min(tree.to, max)) : "";
    }
    function findParentElement(tree, skip = !1) {
        for (;tree; tree = tree.parent) if ("Element" == tree.name) {
            if (!skip) return tree;
            skip = !1;
        }
        return null;
    }
    function allowedChildren(doc, tree, schema) {
        doc = schema.tags[elementName(doc, findParentElement(tree))];
        return (null == doc ? void 0 : doc.children) || schema.allTags;
    }
    function openTags(doc, tree) {
        var open = [];
        for (let parent = findParentElement(tree); parent && !parent.type.isTop; parent = findParentElement(parent.parent)) {
            var tagName = elementName(doc, parent);
            if (tagName && "CloseTag" == parent.lastChild.name) break;
            tagName && open.indexOf(tagName) < 0 && ("EndTag" == tree.name || tree.from >= parent.firstChild.to) && open.push(tagName);
        }
        return open;
    }
    Schema.default = new Schema();
    const identifier = /^[:\-\.\w\u00b7-\uffff]*$/;
    function completeTag(state, schema, tree, from, to) {
        let end = /\s*>/.test(state.sliceDoc(to, to + 5)) ? "" : ">";
        var parent = findParentElement(tree, !0);
        return {
            from: from,
            to: to,
            options: allowedChildren(state.doc, parent, schema).map(tagName => ({
                label: tagName,
                type: "type"
            })).concat(openTags(state.doc, tree).map((tag, i) => ({
                label: "/" + tag,
                apply: "/" + tag + end,
                type: "type",
                boost: 99 - i
            }))),
            validFor: /^\/?[:\-\.\w\u00b7-\uffff]*$/
        };
    }
    function completeCloseTag(state, tree, from, to) {
        let end = /\s*>/.test(state.sliceDoc(to, to + 5)) ? "" : ">";
        return {
            from: from,
            to: to,
            options: openTags(state.doc, tree).map((tag, i) => ({
                label: tag,
                apply: tag + end,
                type: "type",
                boost: 99 - i
            })),
            validFor: identifier
        };
    }
    function htmlCompletionFor(schema, context) {
        let {
            state,
            pos
        } = context, tree = syntaxTree(state).resolveInner(pos, -1), around = tree.resolve(pos);
        for (let scan = pos, before; around == tree && (before = tree.childBefore(scan)); ) {
            var last = before.lastChild;
            if (!last || !last.type.isError || last.from < last.to) break;
            around = tree = before, scan = last.from;
        }
        return "TagName" == tree.name ? tree.parent && /CloseTag$/.test(tree.parent.name) ? completeCloseTag(state, tree, tree.from, pos) : completeTag(state, schema, tree, tree.from, pos) : "StartTag" == tree.name ? completeTag(state, schema, tree, pos, pos) : "StartCloseTag" == tree.name || "IncompleteCloseTag" == tree.name ? completeCloseTag(state, tree, pos, pos) : "OpenTag" == tree.name || "SelfClosingTag" == tree.name || "AttributeName" == tree.name ? function(state, schema, tree, from, to) {
            return tree = findParentElement(tree), state = tree ? schema.tags[elementName(state.doc, tree)] : null, 
            tree = state && state.attrs ? Object.keys(state.attrs) : [], {
                from: from,
                to: to,
                options: (state && !1 === state.globalAttrs ? tree : tree.length ? tree.concat(schema.globalAttrNames) : schema.globalAttrNames).map(attrName => ({
                    label: attrName,
                    type: "property"
                })),
                validFor: identifier
            };
        }(state, schema, tree, "AttributeName" == tree.name ? tree.from : pos, pos) : "Is" == tree.name || "AttributeValue" == tree.name || "UnquotedAttributeValue" == tree.name ? function(state, schema, tree, from, to) {
            var _a = null == (_a = tree.parent) ? void 0 : _a.getChild("AttributeName");
            let options = [], token = void 0;
            if (_a) {
                _a = state.sliceDoc(_a.from, _a.to);
                let attrs = schema.globalAttrs[_a];
                if (attrs || (schema = (tree = findParentElement(tree)) ? schema.tags[elementName(state.doc, tree)] : null, 
                attrs = (null == schema ? void 0 : schema.attrs) && schema.attrs[_a]), 
                attrs) {
                    let base = state.sliceDoc(from, to).toLowerCase(), quoteStart = '"', quoteEnd = '"';
                    /^['"]/.test(base) ? (token = '"' == base[0] ? /^[^"]*$/ : /^[^']*$/, 
                    quoteStart = "", quoteEnd = state.sliceDoc(to, to + 1) == base[0] ? "" : base[0], 
                    base = base.slice(1), from++) : token = /^[^\s<>='"]*$/;
                    for (var value of attrs) options.push({
                        label: value,
                        apply: quoteStart + value + quoteEnd,
                        type: "constant"
                    });
                }
            }
            return {
                from: from,
                to: to,
                options: options,
                validFor: token
            };
        }(state, schema, tree, "Is" == tree.name ? pos : tree.from, pos) : !context.explicit || "Element" != around.name && "Text" != around.name && "Document" != around.name ? null : function(state, schema, tree, pos) {
            let options = [], level = 0;
            for (var tagName of allowedChildren(state.doc, tree, schema)) options.push({
                label: "<" + tagName,
                type: "type"
            });
            for (var open of openTags(state.doc, tree)) options.push({
                label: "</" + open + ">",
                type: "type",
                boost: 99 - level++
            });
            return {
                from: pos,
                to: pos,
                options: options,
                validFor: /^<\/?[:\-\.\w\u00b7-\uffff]*$/
            };
        }(state, schema, tree, pos);
    }
    const defaultNesting = [ {
        tag: "script",
        attrs: attrs => "text/typescript" == attrs.type || "ts" == attrs.lang,
        parser: typescriptLanguage.parser
    }, {
        tag: "script",
        attrs: attrs => "text/babel" == attrs.type || "text/jsx" == attrs.type,
        parser: jsxLanguage.parser
    }, {
        tag: "script",
        attrs: attrs => "text/typescript-jsx" == attrs.type,
        parser: tsxLanguage.parser
    }, {
        tag: "script",
        attrs(attrs) {
            return /^(importmap|speculationrules|application\/(.+\+)?json)$/i.test(attrs.type);
        },
        parser: javascriptLanguage.parser.configure({
            top: "SingleExpression"
        })
    }, {
        tag: "script",
        attrs(attrs) {
            return !attrs.type || /^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^module$|^$/i.test(attrs.type);
        },
        parser: javascriptLanguage.parser
    }, {
        tag: "style",
        attrs(attrs) {
            return (!attrs.lang || "css" == attrs.lang) && (!attrs.type || /^(text\/)?(x-)?(stylesheet|css)$/i.test(attrs.type));
        },
        parser: cssLanguage.parser
    } ], defaultAttrs = [ {
        name: "style",
        parser: cssLanguage.parser.configure({
            top: "Styles"
        })
    } ].concat(ie_11up.map(name => ({
        name: name,
        parser: javascriptLanguage.parser
    }))), htmlPlain = LRLanguage.define({
        name: "html",
        parser: ie.configure({
            props: [ indentNodeProp.add({
                Element(context) {
                    var after = /^(\s*)(<\/)?/.exec(context.textAfter);
                    return context.node.to <= context.pos + after[0].length ? context.continue() : context.lineIndent(context.node.from) + (after[2] ? 0 : context.unit);
                },
                "OpenTag CloseTag SelfClosingTag"(context) {
                    return context.column(context.node.from) + context.unit;
                },
                Document(context) {
                    if (context.pos + /\s*/.exec(context.textAfter)[0].length < context.node.to) return context.continue();
                    let endElt = null, close;
                    for (let cur = context.node; ;) {
                        var last = cur.lastChild;
                        if (!last || "Element" != last.name || last.to != cur.to) break;
                        endElt = cur = last;
                    }
                    return endElt && (!(close = endElt.lastChild) || "CloseTag" != close.name && "SelfClosingTag" != close.name) ? context.lineIndent(endElt.from) + context.unit : null;
                }
            }), foldNodeProp.add({
                Element(node) {
                    var first = node.firstChild, last = node.lastChild;
                    return first && "OpenTag" == first.name ? {
                        from: first.to,
                        to: "CloseTag" == last.name ? last.from : node.to
                    } : null;
                }
            }), bracketMatchingHandle.add({
                "OpenTag CloseTag": node => node.getChild("TagName")
            }) ]
        }),
        languageData: {
            commentTokens: {
                block: {
                    open: "\x3c!--",
                    close: "--\x3e"
                }
            },
            indentOnInput: /^\s*<\/\w+\W$/,
            wordChars: "-._"
        }
    }), htmlLanguage = htmlPlain.configure({
        wrap: configureNesting(defaultNesting, defaultAttrs)
    });
    function html(config = {}) {
        let dialect = "", wrap;
        !1 === config.matchClosingTags && (dialect = "noMatch"), !0 === config.selfClosingTags && (dialect = (dialect ? dialect + " " : "") + "selfClosing");
        var lang = (wrap = config.nestedLanguages && config.nestedLanguages.length || config.nestedAttributes && config.nestedAttributes.length ? configureNesting((config.nestedLanguages || []).concat(defaultNesting), (config.nestedAttributes || []).concat(defaultAttrs)) : wrap) ? htmlPlain.configure({
            wrap: wrap,
            dialect: dialect
        }) : dialect ? htmlLanguage.configure({
            dialect: dialect
        }) : htmlLanguage;
        return new LanguageSupport(lang, [ htmlLanguage.data.of({
            autocomplete: function(config) {
                var {
                    extraTags: config,
                    extraGlobalAttributes: extraAttrs
                } = config;
                let schema = extraAttrs || config ? new Schema(config, extraAttrs) : Schema.default;
                return context => htmlCompletionFor(schema, context);
            }(config)
        }), !1 !== config.autoCloseTags ? autoCloseTags : [], javascript().support, new LanguageSupport(cssLanguage, cssLanguage.data.of({
            autocomplete: cssCompletionSource
        })).support ]);
    }
    const selfClosers = new Set("area base br col command embed frame hr img input keygen link meta param source track wbr menuitem".split(" ")), autoCloseTags = EditorView.inputHandler.of((view, from, to, text, insertTransaction) => {
        if (view.composing || view.state.readOnly || from != to || ">" != text && "/" != text || !htmlLanguage.isActiveAt(view.state, from, -1)) return !1;
        let base = insertTransaction(), state = base["state"];
        to = state.changeByRange(range => {
            var _a, didType = state.doc.sliceString(range.from - 1, range.to) == text;
            let head = range["head"], after = syntaxTree(state).resolveInner(head, -1), name;
            if (didType && ">" == text && "EndTag" == after.name) {
                var tag = after.parent;
                if ("CloseTag" != (null == (_a = null == (_a = tag.parent) ? void 0 : _a.lastChild) ? void 0 : _a.name) && (name = elementName(state.doc, tag.parent, head)) && !selfClosers.has(name)) return {
                    range: range,
                    changes: {
                        from: head,
                        to: head + (">" === state.doc.sliceString(head, head + 1) ? 1 : 0),
                        insert: `</${name}>`
                    }
                };
            } else if (didType && "/" == text && "IncompleteCloseTag" == after.name) {
                let tag = after.parent;
                if (after.from == head - 2 && "CloseTag" != (null == (_a = tag.lastChild) ? void 0 : _a.name) && (name = elementName(state.doc, tag, head)) && !selfClosers.has(name)) {
                    let to = head + (">" === state.doc.sliceString(head, head + 1) ? 1 : 0), insert = name + ">";
                    return {
                        range: EditorSelection.cursor(head + insert.length, -1),
                        changes: {
                            from: head,
                            to: to,
                            insert: insert
                        }
                    };
                }
            }
            return {
                range: range
            };
        });
        return !to.changes.empty && (view.dispatch([ base, state.update(to, {
            userEvent: "input.complete",
            scrollIntoView: !0
        }) ]), !0);
    }), keywordMap = {
        abstract: 4,
        and: 5,
        array: 6,
        as: 7,
        true: 8,
        false: 8,
        break: 9,
        case: 10,
        catch: 11,
        clone: 12,
        const: 13,
        continue: 14,
        declare: 16,
        default: 15,
        do: 17,
        echo: 18,
        else: 19,
        elseif: 20,
        enddeclare: 21,
        endfor: 22,
        endforeach: 23,
        endif: 24,
        endswitch: 25,
        endwhile: 26,
        enum: 27,
        extends: 28,
        final: 29,
        finally: 30,
        fn: 31,
        for: 32,
        foreach: 33,
        from: 34,
        function: 35,
        global: 36,
        goto: 37,
        if: 38,
        implements: 39,
        include: 40,
        include_once: 41,
        instanceof: 42,
        insteadof: 43,
        interface: 44,
        list: 45,
        match: 46,
        namespace: 47,
        new: 48,
        null: 49,
        or: 50,
        print: 51,
        readonly: 52,
        require: 53,
        require_once: 54,
        return: 55,
        switch: 56,
        throw: 57,
        trait: 58,
        try: 59,
        unset: 60,
        use: 61,
        var: 62,
        public: 63,
        private: 63,
        protected: 63,
        while: 64,
        xor: 65,
        yield: 66,
        __proto__: null
    };
    function keywords(name) {
        name = keywordMap[name.toLowerCase()];
        return null == name ? -1 : name;
    }
    function isSpace(ch) {
        return 9 == ch || 10 == ch || 13 == ch || 32 == ch;
    }
    function isASCIILetter(ch) {
        return 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90;
    }
    function isIdentifierStart(ch) {
        return 95 == ch || 128 <= ch || isASCIILetter(ch);
    }
    function isHex(ch) {
        return 48 <= ch && ch <= 55 || 97 <= ch && ch <= 102 || 65 <= ch && ch <= 70;
    }
    const castTypes = {
        int: !0,
        integer: !0,
        bool: !0,
        boolean: !0,
        float: !0,
        double: !0,
        real: !0,
        string: !0,
        array: !0,
        object: !0,
        unset: !0,
        __proto__: null
    };
    deleteCharForward = new ExternalTokenizer(input => {
        if (40 == input.next) {
            input.advance();
            let peek = 0;
            for (;isSpace(input.peek(peek)); ) peek++;
            let name = "", next;
            for (;isASCIILetter(next = input.peek(peek)); ) name += String.fromCharCode(next), 
            peek++;
            for (;isSpace(input.peek(peek)); ) peek++;
            41 == input.peek(peek) && castTypes[name.toLowerCase()] && input.acceptToken(1);
        } else if (60 == input.next && 60 == input.peek(1) && 60 == input.peek(2)) {
            for (let i = 0; i < 3; i++) input.advance();
            for (;32 == input.next || 9 == input.next; ) input.advance();
            var quoted = 39 == input.next;
            if (quoted && input.advance(), isIdentifierStart(input.next)) {
                let tag = String.fromCharCode(input.next);
                for (;input.advance(), isIdentifierStart(input.next) || 48 <= input.next && input.next <= 55; ) tag += String.fromCharCode(input.next);
                if (quoted) {
                    if (39 != input.next) return;
                    input.advance();
                }
                if (10 == input.next || 13 == input.next) for (;;) {
                    var lineStart = 10 == input.next || 13 == input.next;
                    if (input.advance(), input.next < 0) return;
                    if (lineStart) {
                        for (;32 == input.next || 9 == input.next; ) input.advance();
                        let match = !0;
                        for (let i = 0; i < tag.length; i++) {
                            if (input.next != tag.charCodeAt(i)) {
                                match = !1;
                                break;
                            }
                            input.advance();
                        }
                        if (match) return input.acceptToken(2);
                    }
                }
            }
        }
    }), deleteCharBackward = new ExternalTokenizer(input => {
        input.next < 0 && input.acceptToken(278);
    }), indentLess = new ExternalTokenizer((input, stack) => {
        63 == input.next && stack.canShift(277) && 62 == input.peek(1) && input.acceptToken(277);
    });
    safari = new ExternalTokenizer((input, stack) => {
        let content = !1;
        for (;!(34 == input.next || input.next < 0 || 36 == input.next && (isIdentifierStart(input.peek(1)) || 123 == input.peek(1)) || 123 == input.next && 36 == input.peek(1)); content = !0) {
            if (92 == input.next) {
                var escaped = function(input) {
                    var after = input.peek(1);
                    if (110 == after || 114 == after || 116 == after || 118 == after || 101 == after || 102 == after || 92 == after || 36 == after || 34 == after || 123 == after) return 2;
                    if (48 <= after && after <= 55) {
                        let size = 2, next;
                        for (;size < 5 && 48 <= (next = input.peek(size)) && next <= 55; ) size++;
                        return size;
                    }
                    if (120 == after && isHex(input.peek(2))) return isHex(input.peek(3)) ? 4 : 3;
                    if (117 == after && 123 == input.peek(2)) for (let size = 3; ;size++) {
                        var next = input.peek(size);
                        if (125 == next) return 2 == size ? 0 : size + 1;
                        if (!isHex(next)) break;
                    }
                    return 0;
                }(input);
                if (escaped) {
                    if (content) break;
                    return input.acceptToken(3, escaped);
                }
            } else if (!content && (91 == input.next || 45 == input.next && 62 == input.peek(1) && isIdentifierStart(input.peek(2)) || 63 == input.next && 45 == input.peek(1) && 62 == input.peek(2) && isIdentifierStart(input.peek(3))) && stack.canShift(276)) break;
            input.advance();
        }
        content && input.acceptToken(275);
    }), punctuation = styleTags({
        "Visibility abstract final static": tags$1.modifier,
        "for foreach while do if else elseif switch try catch finally return throw break continue default case": tags$1.controlKeyword,
        "endif endfor endforeach endswitch endwhile declare enddeclare goto match": tags$1.controlKeyword,
        "and or xor yield unset clone instanceof insteadof": tags$1.operatorKeyword,
        "function fn class trait implements extends const enum global interface use var": tags$1.definitionKeyword,
        "include include_once require require_once namespace": tags$1.moduleKeyword,
        "new from echo print array list as": tags$1.keyword,
        null: tags$1.null,
        Boolean: tags$1.bool,
        VariableName: tags$1.variableName,
        "NamespaceName/...": tags$1.namespace,
        "NamedType/...": tags$1.typeName,
        Name: tags$1.name,
        "CallExpression/Name": tags$1.function(tags$1.variableName),
        "LabelStatement/Name": tags$1.labelName,
        "MemberExpression/Name": tags$1.propertyName,
        "MemberExpression/VariableName": tags$1.special(tags$1.propertyName),
        "ScopedExpression/ClassMemberName/Name": tags$1.propertyName,
        "ScopedExpression/ClassMemberName/VariableName": tags$1.special(tags$1.propertyName),
        "CallExpression/MemberExpression/Name": tags$1.function(tags$1.propertyName),
        "CallExpression/ScopedExpression/ClassMemberName/Name": tags$1.function(tags$1.propertyName),
        "MethodDeclaration/Name": tags$1.function(tags$1.definition(tags$1.variableName)),
        "FunctionDefinition/Name": tags$1.function(tags$1.definition(tags$1.variableName)),
        "ClassDeclaration/Name": tags$1.definition(tags$1.className),
        UpdateOp: tags$1.updateOperator,
        ArithOp: tags$1.arithmeticOperator,
        "LogicOp IntersectionType/&": tags$1.logicOperator,
        BitOp: tags$1.bitwiseOperator,
        CompareOp: tags$1.compareOperator,
        ControlOp: tags$1.controlOperator,
        AssignOp: tags$1.definitionOperator,
        "$ ConcatOp": tags$1.operator,
        LineComment: tags$1.lineComment,
        BlockComment: tags$1.blockComment,
        Integer: tags$1.integer,
        Float: tags$1.float,
        String: tags$1.string,
        ShellExpression: tags$1.special(tags$1.string),
        "=> ->": tags$1.punctuation,
        "( )": tags$1.paren,
        "#[ [ ]": tags$1.squareBracket,
        "${ { }": tags$1.brace,
        "-> ?->": tags$1.derefOperator,
        ", ; :: : \\": tags$1.separator,
        "PhpOpen PhpClose": tags$1.processingInstruction
    });
    const spec_name = {
        __proto__: null,
        static: 325,
        STATIC: 325,
        class: 351,
        CLASS: 351
    };
    var Type, selectDocStart = LRParser.deserialize({
        version: 14,
        states: "%#[Q`OWOOQhQaOOP%oO`OOOOO#t'#Hh'#HhO%tO#|O'#DuOOO#u'#Dx'#DxQ&SOWO'#DxO&XO$VOOOOQ#u'#Dy'#DyO&lQaO'#D}O'[QdO'#EQO+QQdO'#IqO+_QdO'#ERO-RQaO'#EXO/bQ`O'#EUO/gQ`O'#E_O2UQaO'#E_O2]Q`O'#EgO2bQ`O'#EqO-RQaO'#EqO2mQpO'#FOO2rQ`O'#FOOOQS'#Iq'#IqO2wQ`O'#ExOOQS'#Ih'#IhO5SQdO'#IeO9UQeO'#F]O-RQaO'#FlO-RQaO'#FmO-RQaO'#FnO-RQaO'#FoO-RQaO'#FoO-RQaO'#FrOOQO'#Ir'#IrO9cQ`O'#FxOOQO'#Ht'#HtO9kQ`O'#HXO:VQ`O'#FsO:bQ`O'#HfO:mQ`O'#GPO:uQaO'#GQO-RQaO'#G`O-RQaO'#GcO;bOrO'#GfOOQS'#JP'#JPOOQS'#JO'#JOOOQS'#Ie'#IeO/bQ`O'#GmO/bQ`O'#GoO/bQ`O'#GtOhQaO'#GvO;iQ`O'#GwO;nQ`O'#GzO:]Q`O'#G}O;sQeO'#HOO;sQeO'#HPO;sQeO'#HQO;}Q`O'#HRO<SQ`O'#HTO<XQaO'#HUO>hQ`O'#HVO:]Q`O'#HWO>mQ`O'#HWO;}Q`O'#HXO:]Q`O'#HZO:]Q`O'#H[O:]Q`O'#H]O>rQ`O'#H`O>}Q`O'#HaO<XQaO'#HeOOQ#u'#Ic'#IcOOQ#u'#Hj'#HjQhQaOOO:]Q`O'#HYO:QQ`O'#HYO?]O#|O'#DsPOOO)CDT)CDTOOO#t-E;f-E;fOOO#u,5:d,5:dOOO#u'#Hi'#HiO&XO$VOOO?hQ$VO'#IbOOOO'#Ib'#IbQOOOOOOOQ#y,5:i,5:iO?oQaO,5:iOOQ#u,5:k,5:kO?vQaO,5:nO?}QaO,5;VO@UQpO,5;WOBsQaO'#EuOOQS,5;`,5;`OBzQ`O,5;pOOQP'#Fd'#FdO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xO-RQaO,5;xOOQ#u'#Iv'#IvOOQS,5<z,5<zOOQ#u,5:m,5:mODsQ`O,5:sODzQ`O'#FsOESQ`O'#FsOE[Q`O,5:pOEaQaO'#E`OOQS,5:y,5:yOGeQ`O'#IjO<XQaO'#EbO<XQaO'#IjOOQS'#Ij'#IjOGlQ`O'#IiOGtQ`O,5:yO/lQaO,5:yOGyQaO'#EhOOQS,5;R,5;ROOQS,5;],5;]OHTQ`O,5;]OHsQdO'#FQOJxQ`O'#HrO2mQpO,5;jOOQS,5;j,5;jOJ}QpO,5;jOKSQtO'#EQOKaQpO,5;dO2wQ`O'#E|OOQS'#E}'#E}OOQS'#Ip'#IpOKlQaO,5:xO-RQaO,5;uOOQS,5;w,5;wO-RQaO,5;wOKsQdO,5<WOLTQdO,5<XOLeQdO,5<YOLuQdO,5<ZON|QdO,5<ZO! TQdO,5<^O! eQ`O'#FyO! pQ`O'#IuO! xQ`O,5<dOOQO-E;r-E;rO! }Q`O'#I}O:]Q`O,5=rO!!VQ`O,5=rO;}Q`O,5=sO:]Q`O,5=wO:]Q`O,5=tO!![Q`O,5=tOOQS'#EQ'#EQO!!aQ`O'#FuO!!wQ`O,5<_O!#SQ`O,5<_O!#[Q`O,5?iO!#aQ`O,5<_O!#iQ`O,5<kO!#qQdO'#GYO!$PQdO'#I|O!$[QdO,5>QO!$dQ`O,5<kO!#[Q`O,5<kO!$lQdO,5<lO!$|Q`O,5<lO!%[Q`O,5<lO!%rQdO,5<zO!'wQdO,5<}O!(XOrO'#IPOOOQ'#JS'#JSO-RQaO'#GkOOOQ'#IP'#IPO!(yOrO,5=QOOQS,5=Q,5=QO!)QQaO,5=XO!)XQ`O,5=ZO!)aQeO,5=`O!)kQ`O,5=bO!)pQaO'#GxO!)aQeO,5=cO<XQaO'#G{O!)aQeO,5=fO!$[QdO,5=iO+_QdO,5=jOOQ#u,5=j,5=jO+_QdO,5=kOOQ#u,5=k,5=kO+_QdO,5=lOOQ#u,5=l,5=lO!)wQ`O,5=mO:]Q`O,5=oO!*PQdO'#JUOOQS'#JU'#JUO!$[QdO,5=pO!+iQaO,5=qO!-xQ`O'#GWO!-}QdO'#I{O!$[QdO,5=rOOQ#u,5=s,5=sO!.YQ`O,5=uO!.]Q`O,5=vO!.bQ`O,5=wO!.mQdO,5=zOOQ#u,5=z,5=zO2mQpO,5={O!.xQ`O,5={O!.}QdO'#JVO!$[QdO,5={O!/]Q`O,5={O!/eQdO'#IgO!$[QdO,5>POOQ#u-E;h-E;hO!1QQ`O,5=tOOO#u,5:_,5:_O!1]O#|O,5:_OOO#u-E;g-E;gOOOO,5>|,5>|OOQ#y1G0T1G0TO!1eQ`O1G0YO-RQaO1G0YO!2wQ`O1G0qOOQS1G0q1G0qOOQS'#Eo'#EoOOQS'#Il'#IlO-RQaO'#IlOOQS1G0r1G0rO!4ZQ`O'#IoO!5pQ`O'#IqO!5}QaO'#EwOOQO'#Io'#IoO!6XQ`O'#InO!6aQ`O,5;aO-RQaO'#FXOOQS'#FW'#FWOOQS1G1[1G1[O!6fQdO1G1dO!8kQdO1G1dO!:WQdO1G1dO!;sQdO1G1dO!=`QdO1G1dO!>{QdO1G1dO!@hQdO1G1dO!BTQdO1G1dO!CpQdO1G1dO!E]QdO1G1dO!FxQdO1G1dO!HeQdO1G1dO!JQQdO1G1dO!KmQdO1G1dO!MYQdO1G1dO!NuQdO1G1dOOQT1G0_1G0_O!#[Q`O,5<_O#!bQaO'#EYOOQS1G0[1G0[O#!iQ`O,5:zOEdQaO,5:zO#!nQaO,5;OO#!uQdO,5:|O#$tQdO,5?UO#&sQaO'#HmO#'TQ`O,5?TOOQS1G0e1G0eO#']Q`O1G0eO#'bQ`O'#IkO#(zQ`O'#IkO#)SQ`O,5;SOG|QaO,5;SOOQS1G0w1G0wOOQO,5>^,5>^OOQO-E;p-E;pOOQS1G1U1G1UO#)pQdO'#FQO#+uQ`O'#HsOJ}QpO1G1UO2wQ`O'#HpO#+zQtO,5;eO2wQ`O'#HqO#,iQtO,5;gO#-WQaO1G1OOOQS,5;h,5;hO#/gQtO'#FQO#/tQdO1G0dO-RQaO1G0dO#1aQdO1G1aO#2|QdO1G1cOOQO,5<e,5<eO#3^Q`O'#HuO#3lQ`O,5?aOOQO1G2O1G2OO:]Q`O,5?iO!$[QdO1G3^O:]Q`O1G3^OOQ#u1G3_1G3_O#3tQ`O1G3cO!1QQ`O1G3`O:]Q`O1G3`O#4PQpO'#FvO#4_Q`O'#FvO#4oQ`O'#FvO#4zQ`O'#FvO#5SQ`O'#FzO#5XQ`O'#F{OOQO'#It'#ItO#5`Q`O'#IsO#5hQ`O,5<aOOQS1G1y1G1yO2wQ`O1G1yO#5mQ`O1G1yO#5rQ`O1G1yO!#[Q`O1G5TO#5}QdO1G5TO!#[Q`O1G1yO#6]Q`O1G2VO!#[Q`O1G2VO<XQaO,5<tO#6eQdO'#H}O#6sQdO,5?hOOQ#u1G3l1G3lO-RQaO1G2VO2wQ`O1G2VO#7OQdO1G2WO9cQ`O'#GSO9cQ`O'#GTO#9bQ`O'#GUOOQS1G2W1G2WO!.]Q`O1G2WO!1TQ`O1G2WO!1QQ`O1G2WO!$|Q`O1G2WO:]O`O,5=RO#:[O`O,5=RO#:gO!bO,5=SO#:uQ`O,5=VOOOQ-E;}-E;}OOQS1G2l1G2lO#:|QaO'#GnO#;gQ$VO1G2sO#@gQ`O1G2sO#@rQ`O'#GpO#@}Q`O'#GsOOQ#u1G2u1G2uO#AYQ`O1G2uOOQ#u'#Gu'#GuOOQ#u'#JT'#JTOOQ#u1G2z1G2zO#A_Q`O1G2zO/bQ`O1G2|O#AdQaO,5=dO#AkQ`O,5=dOOQ#u1G2}1G2}O#ApQ`O1G2}O#AuQ`O,5=gOOQ#u1G3Q1G3QO#CXQ`O1G3QOOQ#u1G3T1G3TOOQ#u1G3U1G3UOOQ#u1G3V1G3VOOQ#u1G3W1G3WO#C^Q`O'#IUO;}Q`O'#IUO#CcQ$VO1G3XO#HiQ`O1G3ZO<XQaO'#ITO#HnQdO,5=eOOQ#u1G3[1G3[O#HyQ`O1G3]O<XQaO,5<rO#IOQdO'#H|O#I^QdO,5?gOOQ#u1G3^1G3^OOQ#u1G3a1G3aO!.]Q`O1G3aOOQ#u1G3b1G3bO#IiQ`O'#H^OOQ#u1G3c1G3cO#JfQ`O1G3cO#JkQ`O1G3cOOQ#u1G3f1G3fO#J|Q`O1G3gO#KRQpO1G3gO#KZQdO'#IWO#KlQdO,5?qO:]Q`O,5?qOOQ#u1G3g1G3gO2mQpO1G3gO#KwQ`O1G3gO!$[QdO1G3gO#K|QeO'#HkO#L^QdO,5?ROOQ#u1G3k1G3kOOQ#u1G3`1G3`O!.]Q`O1G3`O!1TQ`O1G3`OOO#u1G/y1G/yO-RQaO7+%tO#LlQdO7+%tOOQS7+&]7+&]O#NXQ`O,5?WO!+iQaO,5;bO#N`Q`O,5;cO$ uQaO'#HoO$!PQ`O,5?YOOQS1G0{1G0{O$!XQ`O,5;sO$!`Q`O'#EZO$!eQ`O'#IfO$!mQ`O,5:tOOQS1G0f1G0fO$!rQ`O1G0fO$!wQ`O1G0jO<XQaO1G0jOOQO,5>X,5>XOOQO-E;k-E;kOOQS7+&P7+&PO!+iQaO,5;TO$$^QaO'#HnO$$hQ`O,5?VOOQS1G0n1G0nO$$pQ`O1G0nPOQO'#FQ'#FQOOQO,5>_,5>_OOQO-E;q-E;qOOQS7+&p7+&pOOQS,5>[,5>[OOQS-E;n-E;nO$$uQtO,5>]OOQS-E;o-E;oO$%dQdO7+&jO$'iQtO'#FQO$'vQdO7+&OOOQS1G0j1G0jOOQO,5>a,5>aOOQO-E;s-E;sOOQ#u7+(x7+(xO!$[QdO7+(xOOQ#u7+(}7+(}O#JfQ`O7+(}O#JkQ`O7+(}OOQ#u7+(z7+(zO!.]Q`O7+(zO!1TQ`O7+(zO!1QQ`O7+(zO$)cQ`O,5<bO$)mQ`O,5<bO$)xQ`O,5<fO$)}QpO,5<bO$*]Q`O,5<bO!+iQaO,5<bOOQO,5<f,5<fO$*eQpO,5<gO$*pQ`O,5<gO$+OQ`O'#HwO$+iQ`O,5?_OOQS1G1{1G1{O$+qQpO7+'eO$+|Q`O'#GOO$,XQ`O7+'eOOQS7+'e7+'eO2wQ`O7+'eO#5mQ`O7+'eO$,aQdO7+*oO2wQ`O7+*oO$,oQ`O7+'eO-RQaO7+'qO2wQ`O7+'qO$,zQ`O7+'qO$-SQdO1G2`OOQS,5>i,5>iOOQS-E;{-E;{O$.lQdO7+'qO$.|QpO7+'qO$/XQdO'#IxOOQO,5<n,5<nOOQO,5<o,5<oO$/jQpO'#GXO$/uQ`O'#GXOOQO'#Iz'#IzOOQO'#H{'#H{O$0iQ`O'#GXO#JkQ`O'#GVO$1YQdO'#GXO!.mQdO'#GZO9cQ`O'#G[OOQO'#Iy'#IyOOQO'#Hz'#HzO$1eQ`O,5<pOOQ#y,5<p,5<pOOQS7+'r7+'rO!.]Q`O7+'rO!1TQ`O7+'rO!1QQ`O7+'rOOOQ1G2m1G2mO:]O`O1G2mO$2_O!bO1G2nO$2mO`O'#GiO$2rO`O1G2nOOOQ1G2q1G2qO$2wQaO,5=YO/bQ`O'#IQO$3bQ$VO7+(_OhQaO7+(_O/bQ`O'#IRO$8bQ`O7+(_O!$[QdO7+(_O$8mQ`O7+(_O$8rQaO'#GqO$;RQ`O'#GrOOQO'#IS'#ISO$;ZQ`O,5=[OOQ#u,5=[,5=[O$;fQ`O,5=_O!$[QdO7+(aO!$[QdO7+(fO!$[QdO7+(hO$;qQaO1G3OO$;xQ`O1G3OO$;}QaO1G3OO!$[QdO7+(iO<XQaO1G3RO!$[QdO7+(lO2wQ`O'#HSO;}Q`O,5>pOOQ#u,5>p,5>pOOQ#u-E<S-E<SO$<UQaO7+(uO$<mQdO,5>oOOQS-E<R-E<RO!$[QdO7+(wO$>VQdO1G2^OOQS,5>h,5>hOOQS-E;z-E;zOOQ#u7+({7+({O$?oQ`O'#GXO:]Q`O'#H_OOQO'#IV'#IVO$@fQ`O,5=xOOQ#u,5=x,5=xO$AcQ!bO'#EQO$AzQ!bO7+(}O$BYQpO7+)RO#KRQpO7+)RO$BbQ`O'#HbO!$[QdO7+)RO$BpQdO,5>rOOQS-E<U-E<UO$COQdO1G5]O$CZQ`O7+)RO#KRQpO7+)ROOQ#u7+)R7+)RO$C`QdO,5>VOOQS-E;i-E;iO$D{QdO<<I`OOQS1G4r1G4rO$FhQ`O1G0|OOQO,5>Z,5>ZOOQO-E;m-E;mOOQS1G1_1G1_O$8rQaO,5:uO$G}QaO'#HlO$H[Q`O,5?QOOQS1G0`1G0`OOQS7+&Q7+&QO$HdQ`O7+&UO$IyQ`O1G0oO$K`Q`O,5>YOOQO,5>Y,5>YOOQO-E;l-E;lOOQS7+&Y7+&YOOQS7+&U7+&UOOQ#u<<Ld<<LdOOQ#u<<Li<<LiO$AzQ!bO<<LiOOQ#u<<Lf<<LfO!.]Q`O<<LfO!1TQ`O<<LfO$LxQ`O1G1|O$MTQ`O1G2QO!+iQaO1G1|OOQO1G2Q1G2QO$MYQ`O1G1|O$MdQ`O1G1|O$NyQ`O1G2RO% XQ`O'#F|O!+iQaO1G2ROOQO1G2R1G2ROOQO,5>c,5>cOOQO-E;u-E;uOOQS<<KP<<KPO% aQ`O'#IwO% iQ`O'#IwO% nQ`O,5<jO2wQ`O<<KPO$+qQpO<<KPO% sQ`O<<KPO2wQ`O<<NZO% {QtO<<NZO#5mQ`O<<KPO%!^QdO<<K]O%!nQpO<<K]O-RQaO<<K]O2wQ`O<<K]O%!yQdO'#HyO%#bQdO,5?dO$1YQdO,5<sO$/jQpO,5<sO%#sQ`O,5<sO#JkQ`O,5<qO!.mQdO,5<uOOQO-E;y-E;yO%$dQ!bO,5<qO%$oQ!bO'#IqO!$[QdO,5<qOOQO,5<s,5<sOOQO,5<u,5<uO%$}QdO,5<vOOQO-E;x-E;xOOQ#y1G2[1G2[OOQS<<K^<<K^O!.]Q`O<<K^O!1TQ`O<<K^OOOQ7+(X7+(XO%%YO`O7+(YOOOO,5=T,5=TOOOQ7+(Y7+(YOhQaO,5>lOOQ#u-E<O-E<OOhQaO<<KyOOQ#u<<Ky<<KyO$8mQ`O,5>mOOQO-E<P-E<PO!$[QdO<<KyO$8mQ`O<<KyO%%_Q`O<<KyO%%dQ`O,5=]O%&yQaO,5=^OOQO-E<Q-E<QOOQ#u1G2v1G2vOOQ#u<<K{<<K{OOQ#u<<LQ<<LQOOQ#u<<LS<<LSOOQT7+(j7+(jO%'ZQ`O7+(jO%'`QaO7+(jO%'gQ`O7+(jOOQ#u<<LT<<LTO%'lQ`O7+(mO%)RQ`O7+(mOOQ#u<<LW<<LWO%)WQpO,5=nOOQ#u1G4[1G4[O%)fQ`O<<LaOOQ#u<<Lc<<LcO:]Q`O,5=yO%)kQdO,5=yOOQO-E<T-E<TOOQ#u1G3d1G3dO%)vQ!bO,5;eO%*XQ!bO,5;gO#JfQ`O<<LiO%*jQ!bO'#FQP%+OQpO<<LmO!$[QdO<<LmO%+WQ`O'#HcO9cQ`O'#HcO%+cQ`O'#JWO%+kQ`O,5=|OOQ#u<<Lm<<LmO:]Q`O1G4^O%+pQdO7+*wO$BYQpO<<LmO#KRQpO<<LmO%+{Q`O1G0aOOQO,5>W,5>WOOQO-E;j-E;jO!+iQaO,5;UOOQ#uANBTANBTO#JfQ`OANBTOOQ#uANBQANBQO!.]Q`OANBQO!+iQaO7+'hOOQO7+'l7+'lO%-bQ`O7+'hO%.wQ`O7+'hO%/SQ`O7+'lO!+iQaO7+'mOOQO7+'m7+'mO%/XQ`O'#F}OOQO'#Hv'#HvO%/dQ`O,5<hOOQO,5<h,5<hO%/lQ`O7+'mO%1RQ`O'#HxO%1aQ`O,5?cO%1aQ`O,5?cOOQO1G2U1G2UO$+qQpOAN@kOOQSAN@kAN@kO2wQ`OAN@kO%1iQtOANCuO%1zQ`OAN@kO-RQaOAN@wO%2SQdOAN@wO%2dQpOAN@wOOQS,5>e,5>eOOQS-E;w-E;wOOQO1G2_1G2_O$1YQdO1G2_O$/jQpO1G2_O#JkQ`O1G2]O!.mQdO1G2aO%$dQ!bO1G2]O!$[QdO1G2]OOQO1G2a1G2aOOQO1G2]1G2]O%2oQaO'#G]OOQO1G2b1G2bOOQSAN@xAN@xO!.]Q`OAN@xOOOQ<<Kt<<KtOOQ#u1G4W1G4WOOQ#uANAeANAeOOQO1G4X1G4XO%4nQ`OANAeO!$[QdOANAeO%4sQaO1G2wO%5TQaO1G2xOOQT<<LU<<LUO%5eQ`O<<LUO%5jQaO<<LUO-RQaO,5=hOOQT<<LX<<LXOOQO1G3Y1G3YO%5qQ`O1G3YO!)aQeOANA{O%5vQdO1G3eOOQO1G3e1G3eO%6RQ`O1G3eO%6ZQ!bO,5>]O%6lQ!bO'#FQO!$[QdOANBXOOQ#uANBXANBXO:]Q`O,5=}O%7QQ`O,5=}O%7]Q`O'#IXO%7qQ`O,5?rOOQS1G3h1G3hOOQS7+)x7+)xP%+OQpOANBXO%7yQ`O1G0pOOQ#uG27oG27oOOQ#uG27lG27lO%9`Q`O<<KSO!+iQaO<<KSOOQO<<KW<<KWO%:uQ`O<<KXOOQO,5<i,5<iO-RQaO,5<iO%<[Q`O,5<iOOQO-E;t-E;tOOQO1G2S1G2SOOQO,5>d,5>dO%<dQ`O,5>dOOQO-E;v-E;vO%<iQ`O1G4}OOQSG26VG26VO$+qQpOG26VO2wQ`OG26VO%<qQdOG26cO-RQaOG26cOOQO7+'y7+'yO$1YQdO7+'yO%$dQ!bO7+'wO!$[QdO7+'wOOQO7+'{7+'{OOQO7+'w7+'wO%=RQ`OLD+}O%>bQ`O'#IqO%>lQ`O'#IhO!$[QdO'#IOO%@fQaO,5<wOOQO,5<w,5<wOOQSG26dG26dO!$[QdOG27POOQ#uG27PG27PO%BeQaO7+(cOOQTANApANApO%BuQ`OANApO%BzQ`O1G3SOOQO7+(t7+(tOOQ#uG27gG27gO%CRQ`OG27gOOQO7+)P7+)PO%CWQ`O7+)PO!$[QdO7+)POOQ#uG27sG27sOOQO1G3i1G3iO:]Q`O1G3iO%C`Q`O'#HdO9cQ`O'#HdOOQO,5>s,5>sOOQO-E<V-E<VP!$[QdOG27sO%CkQ`OAN@nO+_QdO1G2TOOQO1G2T1G2TO-RQaO1G2TOOQO1G4O1G4OOOQSLD+qLD+qO$+qQpOLD+qO%EQQdOLD+}OOQO<<Ke<<KeO!$[QdO<<KcOOQO<<Kc<<KcO:]Q`O,5<xO%EbQ`O,5<yOOQP,5>j,5>jOOQP-E;|-E;|OOQO1G2c1G2cOOQ#uLD,kLD,kOOQTG27[G27[O!$[QdOLD-RO!$[QdO<<LkOOQO<<Lk<<LkOOQO7+)T7+)TO:]Q`O,5>OO%EjQ`O,5>OPOQ#uLD-_LD-_OOQO7+'o7+'oO+_QdO7+'oOOQS!$( ]!$( ]OOQOAN@}AN@}OOQS1G2d1G2dOOQS1G2e1G2eO%EuQdO1G2eOOQ#u!$(!m!$(!mOOQOANBVANBVOOQO1G3j1G3jO:]Q`O1G3jOOQO<<KZ<<KZOOQS7+(P7+(POOQO7+)U7+)UO%FQQpO'#FOO%FVQpO'#FOO%FQQpO,5;jO%FVQpO,5;jO%F[QpO,5;jO%FaQpO,5;jO#JkQ`O'#E|O%FfQdO,5<lO%H[QaO,5;OO%F[QpO1G1UO%FaQpO1G1UO#JkQ`O'#HpO#JkQ`O'#HqO-RQaO1G0jO%HcQ`O'#FOO%HhQ`O'#FOO%HmQaO'#GQO#-WQaO'#G`O#-WQaO'#GcO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO#-WQaO,5;xO%HwQdO'#IjO%JgQdO'#IjO#-WQaO'#EbO#-WQaO'#IjO%LlQaO,5:xO#-WQaO,5;uO#-WQaO,5;wO%LsQdO,5<WO%NiQdO,5<XO&!_QdO,5<YO&$TQdO,5<ZO&%yQdO,5<ZO&&ZQdO,5<^O&(PQdO,5<}O#-WQaO1G0YO&)uQdO1G1dO&+kQdO1G1dO&-aQdO1G1dO&/VQdO1G1dO&0{QdO1G1dO&2qQdO1G1dO&4gQdO1G1dO&6]QdO1G1dO&8RQdO1G1dO&9wQdO1G1dO&;mQdO1G1dO&=cQdO1G1dO&?XQdO1G1dO&@}QdO1G1dO&BsQdO1G1dO&DiQdO,5:|O&F_QdO,5?UO&HTQdO1G0dO#-WQaO1G0dO&IyQdO1G1aO&KoQdO1G1cO#-WQaO1G2VO#-WQaO7+%tO&MeQdO7+%tO' ZQdO7+&OO#-WQaO7+'qO'#PQdO7+'qO'$uQdO<<I`O'&kQdO<<K]O#-WQaO<<K]O#-WQaOAN@wO'(aQdOAN@wO'*VQdOG26cO#-WQaOG26cO'+{QdOLD+}O'-qQaO,5;OO'/pQaO1G0jO'1lQdO'#IeO'1yQeO'#F]O'5pQeO'#F]O#-WQaO'#FlO'/pQaO'#FlO#-WQaO'#FmO'/pQaO'#FmO#-WQaO'#FnO'/pQaO'#FnO#-WQaO'#FoO'/pQaO'#FoO#-WQaO'#FoO'/pQaO'#FoO#-WQaO'#FrO'/pQaO'#FrO'9vQaO,5:nO'9}Q`O,5<kO':VQ`O1G0YO'/pQaO1G1OO';iQ`O1G2VO';qQ`O7+'qO';yQpO7+'qO'<UQpO<<K]O'<aQpOAN@wO'<lQaO'#GQO'/pQaO'#G`O'/pQaO'#GcO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO,5;xO'/pQaO'#EbO'/pQaO'#IjO'>nQaO,5:xO'/pQaO,5;uO'/pQaO,5;wO'@mQdO,5<WO'BrQdO,5<XO'DwQdO,5<YO'F|QdO,5<ZO'IRQdO,5<ZO'IrQdO,5<^O'KwQdO,5<}O'/pQaO1G0YO'M|QdO1G1dO(!RQdO1G1dO($WQdO1G1dO(&]QdO1G1dO((bQdO1G1dO(*gQdO1G1dO(,lQdO1G1dO(.qQdO1G1dO(0vQdO1G1dO(2{QdO1G1dO(5QQdO1G1dO(7VQdO1G1dO(9[QdO1G1dO(;aQdO1G1dO(=fQdO1G1dO(?kQdO,5:|O(ApQdO,5?UO(CuQdO1G0dO'/pQaO1G0dO(EzQdO1G1aO(HPQdO1G1cO'/pQaO1G2VO'/pQaO7+%tO(JUQdO7+%tO(LZQdO7+&OO'/pQaO7+'qO(N`QdO7+'qO)!eQdO<<I`O)$jQdO<<K]O'/pQaO<<K]O'/pQaOAN@wO)&oQdOAN@wO)(tQdOG26cO'/pQaOG26cO)*yQdOLD+}O)-OQaO,5;OO#-WQaO1G0jO)-VQ`O'#GPO)-_QpO,5;dO)-jQ`O,5<kO!#[Q`O,5<kO!#[Q`O1G2VO2wQ`O1G2VO2wQ`O7+'qO2wQ`O<<K]O)-rQdO,5<lO)/wQdO'#IjO)1pQdO'#IeO)2^QaO,5:nO)2eQ`O,5<kO)2mQ`O1G0YO)4PQ`O1G2VO)4XQ`O7+'qO)4aQpO7+'qO)4lQpO<<K]O)4wQpOAN@wO2wQ`O'#ExO<XQaO'#FlO<XQaO'#FmO<XQaO'#FnO<XQaO'#FoO<XQaO'#FoO<XQaO'#FrO)5SQaO'#GQO<XQaO'#G`O<XQaO'#GcO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO<XQaO,5;xO)5^Q`O'#FsO-RQaO'#EbO-RQaO'#IjO)5fQaO,5:xO<XQaO,5;uO<XQaO,5;wO)5mQdO,5<WO)7lQdO,5<XO)9kQdO,5<YO);jQdO,5<ZO)=iQdO,5<ZO)>SQdO,5<^O)@RQdO,5<lO)BQQdO,5<}O)DPQ`O'#JUO)EfQ`O'#IgO<XQaO1G0YO)F{QdO1G1dO)HzQdO1G1dO)JyQdO1G1dO)LxQdO1G1dO)NwQdO1G1dO*!vQdO1G1dO*$uQdO1G1dO*&tQdO1G1dO*(sQdO1G1dO**rQdO1G1dO*,qQdO1G1dO*.pQdO1G1dO*0oQdO1G1dO*2nQdO1G1dO*4mQdO1G1dO*6lQaO,5;OO*6sQdO,5:|O*7TQdO,5?UO*7eQaO'#HmO*7uQ`O,5?TO*7}QdO1G0dO<XQaO1G0dO*9|QdO1G1aO*;{QdO1G1cO<XQaO1G2VO!+iQaO'#ITO*=zQ`O,5=eO*>SQaO'#HkO*>^Q`O,5?RO<XQaO7+%tO*>fQdO7+%tO*@eQ`O1G0jO!+iQaO1G0jO*AzQdO7+&OO<XQaO7+'qO*CyQdO7+'qO*ExQ`O,5>oO*G_Q`O,5>VO*HtQdO<<I`O*JsQ`O7+&UO*LYQdO<<K]O<XQaO<<K]O<XQaOAN@wO*NXQdOAN@wO+!WQdOG26cO<XQaOG26cO+$VQdOLD+}O+&UQaO,5;OO<XQaO1G0jO+&]QdO'#IjO+&yQ`O'#GPO+'RQ`O,5<kO!#[Q`O,5<kO!#[Q`O1G2VO2wQ`O1G2VO2wQ`O7+'qO2wQ`O<<K]O+'ZQdO'#IeO+'wQeO'#F]O+(hQeO'#F]O+*dQaO'#F]O++|QaO'#F]O!+iQaO'#FlO!+iQaO'#FmO!+iQaO'#FnO!+iQaO'#FoO!+iQaO'#FoO!+iQaO'#FrO+-lQaO'#GQO!+iQaO'#G`O!+iQaO'#GcO+-vQaO,5:nO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO!+iQaO,5;xO+-}Q`O'#IjO$8rQaO'#EbO+/gQaOG26cO$8rQaO'#IjO+1cQ`O'#IiO+1kQaO,5:xO!+iQaO,5;uO!+iQaO,5;wO+1rQ`O,5<WO+3XQ`O,5<XO+4nQ`O,5<YO+6TQ`O,5<ZO+7jQ`O,5<ZO+9PQ`O,5<^O+:fQ`O,5<kO+:nQ`O,5<lO+<TQ`O,5<}O+=jQ`O1G0YO!+iQaO1G0YO+>|Q`O1G1dO+@cQ`O1G1dO+AxQ`O1G1dO+C_Q`O1G1dO+DtQ`O1G1dO+FZQ`O1G1dO+GpQ`O1G1dO+IVQ`O1G1dO+JlQ`O1G1dO+LRQ`O1G1dO+MhQ`O1G1dO+N}Q`O1G1dO,!dQ`O1G1dO,#yQ`O1G1dO,%`Q`O1G1dO,&uQ`O1G0dO!+iQaO1G0dO,([Q`O1G1aO,)qQ`O1G1cO,+WQ`O1G2VO$8rQaO,5<tO!+iQaO1G2VO!+iQaO7+%tO,+`Q`O7+%tO,,uQ`O7+&OO!+iQaO7+'qO,.[Q`O7+'qO,.dQ`O7+'qO,/yQpO7+'qO,0UQ`O<<I`O,1kQ`O<<K]O,3QQpO<<K]O!+iQaO<<K]O!+iQaOAN@wO,3]Q`OAN@wO,4rQpOAN@wO,4}Q`OG26cO!+iQaOG26cO,6dQ`OLD+}O,7yQaO,5;OO!+iQaO1G0jO,8QQ`O'#IjO$8rQaO'#FlO$8rQaO'#FmO$8rQaO'#FnO$8rQaO'#FoO$8rQaO'#FoO+/gQaO'#FoO$8rQaO'#FrO,9jQaO'#GQO,9tQaO'#GQO$8rQaO'#G`O+/gQaO'#G`O$8rQaO'#GcO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO$8rQaO,5;xO+/gQaO,5;xO,;vQ`O'#FsO!+iQaO'#EbO!+iQaO'#IjO,<OQaO,5:xO,<VQaO,5:xO$8rQaO,5;uO+/gQaO,5;uO$8rQaO,5;wO,>UQdO,5<WO,?wQdO,5<XO,AjQdO,5<YO,C]QdO,5<ZO,EOQdO,5<ZO,FqQ`O,5<ZO,HQQdO,5<^O,IsQdO,5<lO%=RQ`O,5<lO,KfQdO,5<}O$8rQaO1G0YO+/gQaO1G0YO,MXQdO1G1dO,NzQ`O1G1dO-!ZQdO1G1dO-#|Q`O1G1dO-%]QdO1G1dO-'OQ`O1G1dO-(_QdO1G1dO-*QQ`O1G1dO-+aQdO1G1dO--SQ`O1G1dO-.cQdO1G1dO-0UQ`O1G1dO-1eQdO1G1dO-3WQ`O1G1dO-4gQdO1G1dO-6YQ`O1G1dO-7iQdO1G1dO-9[Q`O1G1dO-:kQdO1G1dO-<^Q`O1G1dO-=mQdO1G1dO-?`Q`O1G1dO-@oQdO1G1dO-BbQ`O1G1dO-CqQdO1G1dO-EdQ`O1G1dO-FsQdO1G1dO-HfQ`O1G1dO-IuQdO1G1dO-KhQ`O1G1dO-LwQ`O,5:|O-N^Q`O,5?UO. sQdO1G0dO.#fQ`O1G0dO$8rQaO1G0dO+/gQaO1G0dO.$uQdO1G1aO.&hQ`O1G1aO.'wQdO1G1cO$8rQaO1G2VO$8rQaO7+%tO+/gQaO7+%tO.)jQdO7+%tO.+]Q`O7+%tO.,lQdO7+&OO.._Q`O7+&OO$8rQaO7+'qO./nQdO7+'qO.1aQdO<<I`O.3SQ`O<<I`O.4cQdO<<K]O$8rQaO<<K]O$8rQaOAN@wO.6UQdOAN@wO.7wQdOG26cO$8rQaOG26cO.9jQdOLD+}O.;]QaO,5;OO.;dQaO,5;OO$8rQaO1G0jO+/gQaO1G0jO.=cQ`O'#IjO.>uQdO'#IjO.B[Q`O'#IeO.BiQ`O'#GPO.BqQaO,5:nO.BxQ`O,5<kO.CQQdO'#GYO.CcQ`O,5<kO!#[Q`O,5<kO.CkQ`O1G0YO.D}QdO,5:|O.FpQdO,5?UO.HcQ`O1G2VO!#[Q`O1G2VO.HkQdO'#H}O.H|QdO,5?hO2wQ`O1G2VO2wQ`O7+'qO.I[Q`O7+'qO.IdQdO1G2`O.KPQpO7+'qO.K[QpO<<K]O2wQ`O<<K]O.KgQpOAN@wO.KrQdO'#IeO.L]Q`O'#IeO.NPQaO,5:nO.NWQaO,5:nO.N_Q`O,5<kO.NgQ`O7+'qO.NoQ`O1G0YO/!RQ`O1G0YO/#eQ`O1G2VO/#mQ`O7+'qO/#uQpO7+'qO/$QQpOAN@wO/$]QpO<<K]O/$hQpOAN@wO/$sQ`O'#GPO/${Q`O'#FsO/%TQ`O,5<kO/%]QdO'#I|O!#[Q`O,5<kO!#[Q`O1G2VO2wQ`O1G2VO2wQ`O7+'qO2wQ`O<<K]O/%kQ`O'#GPO/%sQ`O,5<kO/%{Q`O,5<kO!#[Q`O,5<kO!#[Q`O1G2VO!#[Q`O1G2VO2wQ`O1G2VO2wQ`O<<K]O2wQ`O7+'qO2wQ`O<<K]O/&TQ`O'#FsO/&]Q`O'#FsO/&eQ`O'#Fs",
        stateData: "/&z~O!eOS!fOS'SOS!hQQ~O!jTO'TRO~OPgOQ|OS!lOU_OW}OX!XO[mO]!_O^!WO`![Oa!SOb!]Ok!dOm!lOowOp!TOq!UOsuOt!gOu!VOv!POxkOykO|!bO}aO!O^O!P!eO!QxO!R}O!TpO!VlO!WlO!X!YO!Y!QO!ZzO![!cO!]!ZO!^!^O!_!fO!a!`O!b!RO!djO!nWO!pXO!z]O#X`O#dhO#fbO#gcO#sdO$[oO$dnO$eoO$hqO$krO$u!kO%TyO%U!OO%W}O%X}O%`|O'WYO'u{O~O!h!mO~O'TRO!j!iX&|!iX'Q!iX~O!j!pO~O!e!qO!f!qO!h!mO'Q!tO'S!qO~PhO!o!vO~PhO!n!tX#T!tX#s#vX'P!tX!y!tX#P!tX!p!tX~OT!tXz!tX!S!tX!c!tX!r!tX!w!tX!z!tX#X!tX#a!tX#b!tX#y!tX$R!tX$S!tX$T!tX$U!tX$V!tX$X!tX$Y!tX$Z!tX$[!tX$]!tX$^!tX$_!tX%T!tX#O!tX#Y!tX!o!tXV!tX#|!tX$O!tXw!tX{!tX~P&sOT'eXz'eX!S'eX!c'eX!w'eX!z'eX#T'eX#X'eX#a'eX#b'eX#y'eX$R'eX$S'eX$T'eX$U'eX$V'eX$X'eX$Y'eX$Z'eX$['eX$]'eX$^'eX$_'eX%T'eX~O!r!xO!n'eX'P'eX~P)dOT#SOz#QO!S#TO!c#UO!n#bO!w!yO!z!|O#T#PO#X!zO#a!{O#b!{O#y#OO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cO'P#bO~OPgOQ|OU_OW}O[mOowOs#fOxkOykO}aO!O^O!QxO!R}O!TpO!VlO!WlO!ZzO!djO!z]O#X`O#dhO#fbO#gcO#sdO$[oO$dnO$eoO$hqO%TyO%U!OO%W}O%X}O%`|O'WYO'u{O~O!z]O~O!z#iO~OP7wOQ|OU_OW}O[7zOo>uOs#fOx7xOy7xO}aO!O^O!Q8OO!R}O!T7}O!V7yO!W7yO!Z8QO!d:QO!z]O#T#mO#V#lO#X`O#dhO#fbO#gcO#sdO$[7|O$d7{O$e7|O$hqO%T8PO%U!OO%W}O%X}O%`|O'WYO'u{O#Y']P~O#O#qO~P/lO!z#rO~O#d#tO#fbO#gcO~O'a#vO~O#s#zO~OU$OO!R$OO!w#}O#s3hO'W#{O~OT'XXz'XX!S'XX!c'XX!n'XX!w'XX!z'XX#T'XX#X'XX#a'XX#b'XX#y'XX$R'XX$S'XX$T'XX$U'XX$V'XX$X'XX$Y'XX$Z'XX$['XX$]'XX$^'XX$_'XX%T'XX'P'XX!y'XX!o'XX~O#|$QO$O$RO~P3YOP7wOQ|OU_OW}O[7zOo>uOs#fOx7xOy7xO}aO!O^O!Q8OO!R}O!T7}O!V7yO!W7yO!Z8QO!d:QO!z]O#X`O#dhO#fbO#gcO#sdO$[7|O$d7{O$e7|O$hqO%T8PO%U!OO%W}O%X}O%`|O'WYO'u{OT$PXz$PX!S$PX!c$PX!n$PX!w$PX#a$PX#b$PX#y$PX$R$PX$S$PX$T$PX$U$PX$V$PX$X$PX$Y$PX$Z$PX$]$PX$^$PX$_$PX'P$PX!y$PX!o$PX~Or$TO#T8eO#V8dO~P5^O#sdO'WYO~OS$fO]$aOk$dOm$fOs$`O!a$bO$krO$u$eO~O!z$hO#T$jO'W$gO~Oo$mOs$lO#d$nO~O!z$hO#T$rO~O!U$uO$u$tO~P-ROR${O!p$zO#d$yO#g$zO&}${O~O't$}O~P;PO!z%SO~O!z%UO~O!n#bO'P#bO~P-RO!pXO~O!z%`O~OP7wOQ|OU_OW}O[7zOo>uOs#fOx7xOy7xO}aO!O^O!Q8OO!R}O!T7}O!V7yO!W7yO!Z8QO!d:QO!z]O#X`O#dhO#fbO#gcO#sdO$[7|O$d7{O$e7|O$hqO%T8PO%U!OO%W}O%X}O%`|O'WYO'u{O~O!z%dO~O]$aO~O!pXO#sdO'WYO~O]%rOs%rO#s%nO'WYO~O!j%wO'Q%wO'TRO~O'Q%zO~PhO!o%{O~PhO!r%}O~P<XO#Y&PO~P<XO!p&SO#d&RO'a&QO~OPgOQ|OU_OW}O[:WOo?jOs#fOx:UOy:UO}aO!O^O!Q:[O!R}O!T:ZO!V:VO!W:VO!Z:^O!d:TO!z]O#V&WO#X`O#dhO#fbO#gcO#sdO$[:YO$d:XO$e:YO$hqO%T:]O%U!OO%W}O%X}O%`|O'WYO'u{O~O!y'bP~P@aO!p&[O#d&]O'W$gO~OT#SOz#QO!S#TO!c#UO!w!yO!z!|O#T#PO#X!zO#a!{O#b!{O#y#OO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cO~O!y&oO~PCVO!z$hO#T&pO~Oo$mOs$lO~O!p&qO~O#O&tO#T=PO#V=OO!y']P~P<XOT8TOz8RO!S8UO!c8VO!w:_O!z!|O#T#PO#X!zO#a!{O#b!{O#y#OO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO#O'^X#Y'^X~O#P&uO~PEqO#O&xO#Y']X~O#Y&zO~O#O'PO!y'_P~P<XO!o'QO~PCVO!n#uX#T#uX#s#tX'P#uX!y#uX#P#uX!p#uX~OT#uXz#uX!S#uX!c#uX!w#uX!z#uX#X#uX#a#uX#b#uX#y#uX$R#uX$S#uX$T#uX$U#uX$V#uX$X#uX$Y#uX$Z#uX$[#uX$]#uX$^#uX$_#uX%T#uX#O#uX#Y#uX!o#uXV#uX!r#uX#|#uX$O#uXw#uX~PH[O#s'RO~O'a'UO~O#n!tX#V!tX#d!tX~P&sO!y']O#T'ZO#n'XO~O#T'aO~P-RO!n$`a'P$`a!y$`a!o$`a~PCVO!n$aa'P$aa!y$aa!o$aa~PCVO!n$ba'P$ba!y$ba!o$ba~PCVO!n$ca'P$ca!y$ca!o$ca~PCVO!z!|O#X!zO#a!{O#b!{O#y#OO%T#cOT$ca!S$ca!c$ca!n$ca!w$ca#T$ca$R$ca$S$ca$T$ca$U$ca$V$ca$X$ca$Y$ca$Z$ca$[$ca$]$ca$^$ca$_$ca'P$ca!y$ca!o$ca~Oz#QO~PMVO!n$fa'P$fa!y$fa!o$fa~PCVO!z!|O#O$mX#Y$mX~O#O'eO#Y'iX~O#Y'gO~O#T'hO'W$gO~O]'jO~O$u'nO~O!a'tO#T'rO#V'sO#d'qO$krO!y'gP~P2wO!_'zO!pXO!r'yO~O!z$hO'W$gO~O!z$hO~O!z$hO#T(OO~O!z$hO#T(QO~O#|(RO!n$|X#O$|X'P$|X~O#O(SO!n'pX'P'pX~O!n#bO'P#bO~O!r(WO#P(VO~O!n$ta'P$ta!y$ta!o$ta~PCVOl(YOw(ZO!p([O!z!|O~O$u(aO~O!z!|O#X!zO#a!{O#b!{O#y#OO~OT%Saz%Sa!S%Sa!c%Sa!n%Sa!w%Sa#T%Sa$R%Sa$S%Sa$T%Sa$U%Sa$V%Sa$X%Sa$Y%Sa$Z%Sa$[%Sa$]%Sa$^%Sa$_%Sa%T%Sa'P%Sa!y%Sa#O%Sa#P%Sa#Y%Sa!o%Sa!r%SaV%Sa#|%Sa$O%Sa!p%Sa~P!%aO!n%Va'P%Va!y%Va!o%Va~PCVO#X(dO#a(bO#b(bO'O(cOR&sX!p&sX#d&sX#g&sX&}&sX't&sX~O't(gO~P;PO!r(hO~PhO!p(kO!r(lO~O!r(hO'P(oO~PhO!b(sO~O!n(tO~P<XOZ)POn)QO~OT8TOz8RO!S8UO!c8VO!w:_O#O)TO#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!n'xX'P'xX~P!%aOPgOQ|OU_OW}O[:WOo?jOs#fOx:UOy:UO}aO!O^O!Q:[O!R}O!T:ZO!V:VO!W:VO!Z:^O!d:TO!z]O#X`O#dhO#fbO#gcO#sdO$[:YO$d:XO$e:YO$hqO%T:]O%U!OO%W}O%X}O%`|O'WYO'u{O~O#|)XO~O#O)YO!n'oX'P'oX~Ol(YO!p([O~Ow(ZO!p)`O!r)cO~O!n#bO!pXO'P#bO~O#s)fO~OV)iO#O)gO!n'yX'P'yX~O#s)kO'WYO~OT8TOz8RO!S8UO!c8VO!w:_O#O)nO#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!n'ZX'P'ZX#P'ZX~P!%aOl(YOw(ZO!p([O~O!j)tO'Q)tO~OT8TOz8RO!S8UO!c8VO!r)uO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO~P!%aOT8TOz8RO!S8UO!c8VO!w:_O#T#PO#Y)wO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO~P!%aOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y'cX#O'cX~P!%aO!r)yO!y'eX#O'eX~P)dO!y#kX#O#kX~P!+iO#O){O!y'bX~O!y)}O~O%T#cOT$Qiz$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$Z$Qi$[$Qi$]$Qi$^$Qi$_$Qi'P$Qi!y$Qi#O$Qi#P$Qi#Y$Qi!o$Qi!r$QiV$Qi#|$Qi$O$Qi!p$Qi~P!%aOz#QO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO!w!yO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi'P$Qi!y$Qi!o$Qi~P!%aOT#SOz#QO!c#UO!w!yO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cO!S$Qi!n$Qi'P$Qi!y$Qi!o$Qi~P!%aOT#SOz#QO!w!yO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cO!S$Qi!c$Qi!n$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO#T#PO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi$R$Qi$S$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO#T#PO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi$R$Qi$S$Qi$T$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO#T#PO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi$R$Qi$S$Qi$T$Qi$U$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO#T#PO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO$[#_O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$Z$Qi$]$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$Z$Qi$[$Qi$]$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO$Z#^O$[#_O$^#aO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$]$Qi'P$Qi!y$Qi!o$Qi~P!%aOz#QO$_#aO%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$Z$Qi$[$Qi$]$Qi$^$Qi'P$Qi!y$Qi!o$Qi~P!%aO_*PO~P<XO!y*SO~O#T*VO~P<XOT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO#O#Ua#Y#Ua#P#Ua!n#Ua'P#Ua!r#Ua!y#Ua!o#UaV#Ua!p#Ua~P!%aOT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO#O'^a#Y'^a#P'^a!n'^a'P'^a!r'^a!y'^a!o'^aV'^a!p'^a~P!%aO#T#mO#V#lO#O&aX#Y&aX~P<XO#O&xO#Y']a~O#Y*YO~OT8TOz8RO!S8UO!c8VO!w:_O#O*[O#P*ZO#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!y'_X~P!%aO#O*[O!y'_X~O!y*^O~O!n#wX#T#wX#s#tX'P#wX!y#wX#P#wX!p#wX~OT#wXz#wX!S#wX!c#wX!w#wX!z#wX#X#wX#a#wX#b#wX#y#wX$R#wX$S#wX$T#wX$U#wX$V#wX$X#wX$Y#wX$Z#wX$[#wX$]#wX$^#wX$_#wX%T#wX#O#wX#Y#wX!o#wXV#wX!r#wX#|#wX$O#wXw#wX~P#)XO#s*aO~O#n'XO!y#ma#T#ma#V#ma#d#ma!p#ma#P#ma!n#ma'P#ma~O#T'ZO!y#oa#n#oa#V#oa#d#oa!p#oa#P#oa!n#oa'P#oa~OPgOQ|OU_OW}O[5jOo7dOs#fOx5fOy5fO}aO!O^O!Q3xO!R}O!T5pO!V5hO!W5hO!Z3zO!d5dO!z]O#X`O#dhO#fbO#gcO#sdO$[5nO$d5lO$e5nO$hqO%T3yO%U!OO%W}O%X}O%`|O'WYO'u{O~O#n#uX#V#uX#d#uX~PH[Oz#QO!w!yO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT#Qi!S#Qi!c#Qi!n#Qi'P#Qi!y#Qi!o#Qi~P!%aOz#QO!w!yO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT#}i!S#}i!c#}i!n#}i'P#}i!y#}i!o#}i~P!%aO!n$Pi'P$Pi!y$Pi!o$Pi~PCVO#sdO'WYO#O&iX#Y&iX~O#O'eO#Y'ia~Ow(ZO!p)`O!r*rO~O#T*wO#V*yO#d*xO#n'XO~O#T*{O#V*yO#d*xO$krO~P2wO#|*|O!y$jX#O$jX~O#V*yO#d*xO~O#d*}O~O#d+PO~P2wO#O+QO!y'gX~O!y+SO~O!z+UO~O!_+YO!pXO!r+XO~O!r+[O!p'qi!n'qi'P'qi~O!r+_O#P+^O~O#d$nO!n&qX#O&qX'P&qX~O#O(SO!n'pa'P'pa~OT$tiz$ti!S$ti!c$ti!n$ti!w$ti!z$ti#T$ti#X$ti#a$ti#b$ti#y$ti#|#ha$O#ha$R$ti$S$ti$T$ti$U$ti$V$ti$X$ti$Y$ti$Z$ti$[$ti$]$ti$^$ti$_$ti%T$ti'P$ti!y$ti#O$ti#P$ti#Y$ti!o$ti!r$tiV$ti!p$ti~OS+kO]+nOm+kOs$`O!U+kO!_+qO!`+kO!a+kO!o+uO#d>xO$hqO$krO~P2wO#X+|O#a+{O#b+{O~O#d,OO%W,OO%^+}O'W$gO~O!o,PO~PCVOc%bXd%bXh%bXj%bXf%bXg%bXe%bX~PhOc,TOd,ROP%aiQ%aiS%aiU%aiW%aiX%ai[%ai]%ai^%ai`%aia%aib%aik%aim%aio%aip%aiq%ais%ait%aiu%aiv%aix%aiy%ai|%ai}%ai!O%ai!P%ai!Q%ai!R%ai!T%ai!V%ai!W%ai!X%ai!Y%ai!Z%ai![%ai!]%ai!^%ai!_%ai!a%ai!b%ai!d%ai!n%ai!p%ai!z%ai#X%ai#d%ai#f%ai#g%ai#s%ai$[%ai$d%ai$e%ai$h%ai$k%ai$u%ai%T%ai%U%ai%W%ai%X%ai%`%ai&|%ai'W%ai'u%ai'Q%ai!o%aih%aij%aif%aig%aiY%ai_%aii%aie%ai~Oc,XOd,UOh,WO~OY,YO_,ZO!o,^O~OY,YO_,ZOi%gX~Oi,`O~Oj,aO~O!n,cO~P<XO!n,eO~Of,fO~OT8TOV,gOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO~P!%aOg,hO~O!z,iO~OZ)POn)QOP%uiQ%uiS%uiU%uiW%uiX%ui[%ui]%ui^%ui`%uia%uib%uik%uim%uio%uip%uiq%uis%uit%uiu%uiv%uix%uiy%ui|%ui}%ui!O%ui!P%ui!Q%ui!R%ui!T%ui!V%ui!W%ui!X%ui!Y%ui!Z%ui![%ui!]%ui!^%ui!_%ui!a%ui!b%ui!d%ui!n%ui!p%ui!z%ui#X%ui#d%ui#f%ui#g%ui#s%ui$[%ui$d%ui$e%ui$h%ui$k%ui$u%ui%T%ui%U%ui%W%ui%X%ui%`%ui&|%ui'W%ui'u%ui'Q%ui!o%uic%uid%uih%uij%uif%uig%uiY%ui_%uii%uie%ui~O#|,mO~O#O)TO!n%ma'P%ma~O!y,pO~O'W$gO!n&pX#O&pX'P&pX~O#O)YO!n'oa'P'oa~OS+kOY,vO]+nOm+kOs$`O!U+kO!_+qO!`+kO!a+kO!o,yO#d>xO$hqO$krO~P2wO!p)`O~OU$OO!R$OO!w3nO#s3iO'W,zO~O#s,|O~O!p-OO'a'UO~O#sdO'WYO!n&zX#O&zX'P&zX~O#O)gO!n'ya'P'ya~O#s-UO~O!n&_X#O&_X'P&_X#P&_X~P<XO#O)nO!n'Za'P'Za#P'Za~Oz#QO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT!vq!S!vq!c!vq!n!vq!w!vq'P!vq!y!vq!o!vq~P!%aO!o-ZO~PCVOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y#ka#O#ka~P!%aO!y&cX#O&cX~P@aO#O){O!y'ba~O!o-_O~PCVO#P-`O~O#O-aO!o'YX~O!o-cO~O!y-dO~OT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO#O#Wi#Y#Wi~P!%aO!y&bX#O&bX~P<XO#O*[O!y'_a~O!y-jO~O#n'XO!y&ea#T&ea#V&ea#d&ea!p&ea#P&ea!n&ea'P&ea~OT#lqz#lq!S#lq!c#lq!n#lq!w#lq#T#lq#|#lq$O#lq$R#lq$S#lq$T#lq$U#lq$V#lq$X#lq$Y#lq$Z#lq$[#lq$]#lq$^#lq$_#lq%T#lq'P#lq!y#lq#O#lq#P#lq#Y#lq!o#lq!r#lqV#lq!p#lq~P!%aO#n#wX#V#wX#d#wX~P#)XOz#QO!w!yO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT#Qq!S#Qq!c#Qq!n#Qq'P#Qq!y#Qq!o#Qq~P!%aO#V-sO#d-rO~P2wO#|-tO!y$ja#O$ja~O#d-uO~O#T-vO#V-sO#d-rO#n'XO~O#V-sO#d-rO~O#T'ZO#d-xO#n'XO~O!p-yO#|-zO!y$oa#O$oa~O!a'tO#T'rO#V'sO#d'qO$krO!y&kX#O&kX~P2wO#O+QO!y'ga~O!pXO#T'ZO#n'XO~O#T.QO#d.PO!y'kP~O!pXO!r.SO~O!r.VO!p'qq!n'qq'P'qq~O!_.XO!pXO!r.SO~O!r.]O#P.[O~OT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!n$|i#O$|i'P$|i~P!%aO!n$sq'P$sq!y$sq!o$sq~PCVO#P.[O#T'ZO#n'XO~O#O.^Ow'lX!p'lX!n'lX'P'lX~O#T'ZO#d>xO#n'XO~OS+kO].cOm+kOs$`O!U+kO!`+kO!a+kO#d>xO$hqO$krO~P2wOS+kO].cOm+kOs$`O!U+kO!`+kO!a+kO#d>xO$hqO~P2wO!n#bO!p-yO'P#bO~OS+kO]+nOm+kOs$`O!U+kO!_+qO!`+kO!a+kO!o.mO#d>xO$hqO$krO~P2wO#d.rO%W.rO%^+}O'W$gO~O%W.sO~O#Y.tO~Oc%bad%bah%baj%baf%bag%bae%ba~PhOc.wOd,ROP%aqQ%aqS%aqU%aqW%aqX%aq[%aq]%aq^%aq`%aqa%aqb%aqk%aqm%aqo%aqp%aqq%aqs%aqt%aqu%aqv%aqx%aqy%aq|%aq}%aq!O%aq!P%aq!Q%aq!R%aq!T%aq!V%aq!W%aq!X%aq!Y%aq!Z%aq![%aq!]%aq!^%aq!_%aq!a%aq!b%aq!d%aq!n%aq!p%aq!z%aq#X%aq#d%aq#f%aq#g%aq#s%aq$[%aq$d%aq$e%aq$h%aq$k%aq$u%aq%T%aq%U%aq%W%aq%X%aq%`%aq&|%aq'W%aq'u%aq'Q%aq!o%aqh%aqj%aqf%aqg%aqY%aq_%aqi%aqe%aq~Oc.|Od,UOh.{O~O!r(hO~OP7wOQ|OU_OW}O[<ROo?sOs#fOx<POy<PO}aO!O^O!Q<WO!R}O!T<VO!V<QO!W<QO!Z<[O!d:RO!z]O#X`O#dhO#fbO#gcO#sdO$[<TO$d<SO$e<TO$hqO%T<YO%U!OO%W}O%X}O%`|O'WYO'u{O~O!n/PO!r/PO~OY,YO_,ZO!o/RO~OY,YO_,ZOi%ga~O!y/VO~P!+iO!n/XO~O!n/XO~P<XOQ|OW}O!R}O%W}O%X}O%`|O'u{O~OT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!n&wa#O&wa'P&wa~P!%aOT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!n$zi#O$zi'P$zi~P!%aOS+kOY/cO].cOm+kOs$`O!U+kO!`+kO!a+kO#d>xO$hqO$krO~P2wOS+kOY,vO]+nOm+kOs$`O!U+kO!_+qO!`+kO!a+kO!o/fO#d>xO$hqO$krO~P2wOw!tX!p!tX#T!tX#n!tX#s#vX#|!tX'W!tX~Ow(ZO!p)`O#T3tO#n3sO~O!p-OO'a&fa~O]/nOs/nO#sdO'WYO~OV/rO!n&za#O&za'P&za~O#O)gO!n'yi'P'yi~O#s/tO~OT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!n&_a#O&_a'P&_a#P&_a~P!%aOz#QO#T#PO$R#RO$S#VO$T#WO$U#XO$V#YO$X#[O$Y#]O$Z#^O$[#_O$]#`O$^#aO$_#aO%T#cOT!vy!S!vy!c!vy!n!vy!w!vy'P!vy!y!vy!o!vy~P!%aOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y#ji#O#ji~P!%aO_*PO!o&`X#O&`X~P<XO#O-aO!o'Ya~OT8TOz8RO!S8UO!c8VO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO#O#Wq#Y#Wq~P!%aOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y#]i#O#]i~P!%aOT8TOz8RO!S8UO!c8VO!w:_O#P/yO#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!y&ba#O&ba~P!%aO#|0OO!y$ji#O$ji~O#d0PO~O#V0SO#d0RO~P2wOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y$ji#O$ji~P!%aO!p-yO#|0TO!y$oi#O$oi~O!o0YO'W$gO~O#O0[O!y'kX~O#d0^O~O!y0_O~O!pXO!r0bO~O#T'ZO#n'XO!p'qy!n'qy'P'qy~O!n$sy'P$sy!y$sy!o$sy~PCVO#P0eO#T'ZO#n'XO~O#sdO'WYOw&mX!p&mX#O&mX!n&mX'P&mX~O#O.^Ow'la!p'la!n'la'P'la~OS+kO]0mOm+kOs$`O!U+kO!`+kO!a+kO#d>xO$hqO~P2wO#T3tO#n3sO'W$gO~O#|)XO#T'eX#n'eX'W'eX~O!n#bO!p0sO'P#bO~O#Y0wO~Oh0|O~OT<aOz<]O!S<cO!c<eO!n0}O!r0}O!w?^O#T#PO$R<_O$S<gO$T<iO$U<kO$V<mO$X<qO$Y<sO$Z<uO$[<wO$]<yO$^<{O$_<{O%T#cO~P!%aOY%fa_%fa!o%fai%fa~PhO!y1PO~O!y1PO~P!+iO!n1RO~OT8TOz8RO!S8UO!c8VO!w:_O!y1TO#P1SO#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO~P!%aO!y1TO~O!y1UO#T'ZO#d1VO#n'XO~O!y1WO~O!n#bO#|1ZO'P#bO~O#n3sOw#ma!p#ma#T#ma'W#ma~O#T3tOw#oa!p#oa#n#oa'W#oa~Ow#uX!p#uX#T#uX#n#uX#s#tX'W#uX~O!p-OO'a*`O~OV1`O!o&VX#O&VX~O#O1bO!o'zX~O!o1dO~O#O)gO!n'yq'P'yq~OT<aOz<]O!S<cO!c<eO!w?^O#T#PO$R<_O$S<gO$T<iO$U<kO$V<mO$X<qO$Y<sO$Z<uO$[<wO$]<yO$^<{O$_<{O%T#cO!o!}i#O!}i~P!%aOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y$jq#O$jq~P!%aO#|1kO!y$jq#O$jq~O#d1lO~O!pXO!z$hO#P1oO~O!o1rO'W$gO~OT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y$oq#O$oq~P!%aO#T1tO#d1sO!y&lX#O&lX~O#O0[O!y'ka~O#T'ZO#n'XO!p'q!R!n'q!R'P'q!R~O!pXO!r1yO~O!n$s!R'P$s!R!y$s!R!o$s!R~PCVO#P1{O#T'ZO#n'XO~OP7wOU_O[:rOo?tOs#fOx:rOy:rO}aO!O^O!Q<XO!T:rO!V:rO!W:rO!Z:rO!d:SO!o2XO!z]O#X`O#dhO#fbO#gcO#sdO$[<UO$d:rO$e<UO$hqO%T<ZO%U!OO'WYO~P$<UOh2ZO~OY%ei_%ei!o%eii%ei~PhOY%fi_%fi!o%fii%fi~PhO!y2^O~O!y2^O~P!+iO!y2aO~O!n#bO#|2eO'P#bO~O%W2fO%`2fO~O#n3sOw&ea!p&ea#T&ea'W&ea~Ow#wX!p#wX#T#wX#n#wX#s#tX'W#wX~OV2iO!o&Va#O&Va~O]2kOs2kO#sdO'WYO!o&{X#O&{X~O#O1bO!o'za~OT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y#^i#O#^i~P!%aOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y$jy#O$jy~P!%aOT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y$oy#O$oy~P!%aO!pXO#P2rO~O#d2sO~O#O0[O!y'ki~O!n$s!Z'P$s!Z!y$s!Z!o$s!Z~PCVOT<bOz<^O!S<dO!c<fO!w?_O#T#PO$R<`O$S<hO$T<jO$U<lO$V<nO$X<rO$Y<tO$Z<vO$[<xO$]<zO$^<|O$_<|O%T#cO~P!%aOV2{O{2zO~P)dOV2{O{2zOT'[Xz'[X!S'[X!c'[X!w'[X!z'[X#T'[X#X'[X#a'[X#b'[X#y'[X#|'[X$O'[X$R'[X$S'[X$T'[X$U'[X$V'[X$X'[X$Y'[X$Z'[X$['[X$]'[X$^'[X$_'[X%T'[X~OP7wOU_O[:rOo?tOs#fOx:rOy:rO}aO!O^O!Q<XO!T:rO!V:rO!W:rO!Z:rO!d:SO!o3OO!z]O#X`O#dhO#fbO#gcO#sdO$[<UO$d:rO$e<UO$hqO%T<ZO%U!OO'WYO~P$<UOY%eq_%eq!o%eqi%eq~PhO!y3QO~O!y%pi~PCVOe3RO~O%W3SO%`3SO~OV3VO!o&WX#O&WX~OT:bOz:`O!S:cO!c:dO!w>vO#T#PO$R:aO$S:eO$T:fO$U:gO$V:hO$X:jO$Y:kO$Z:lO$[:mO$]:nO$^:oO$_:oO%T#cO!y$j!R#O$j!R~P!%aO!n$s!c'P$s!c!y$s!c!o$s!c~PCVO!a3`O'W$gO~OV3dO!o&Wa#O&Wa~O'W$gO!n%Ri'P%Ri~O'a'_O~O'a/jO~O'a*iO~O'a1]O~OT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$ta#|$ta$O$ta'P$ta!y$ta!o$ta#O$ta~P!%aO#T3uO~P-RO#s3lO~O#s3mO~O!U$uO$u$tO~P#-WOT8TOz8RO!S8UO!c8VO!w:_O#P3pO#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO!n'^X'P'^X!y'^X!o'^X~P!%aOT6QOz6OO!S6RO!c6SO!w7oO#P5aO#T#PO$R6PO$S6TO$T6UO$U6VO$V6WO$X6YO$Y6ZO$Z6[O$[6]O$]6^O$^6_O$_6_O%T#cO#O'^X#Y'^X#|'^X$O'^X!n'^X'P'^X!r'^X!y'^X!o'^XV'^X!p'^X~P!%aO#T5OO~P#-WOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$`a#|$`a$O$`a'P$`a!y$`a!o$`a#O$`a~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$aa#|$aa$O$aa'P$aa!y$aa!o$aa#O$aa~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$ba#|$ba$O$ba'P$ba!y$ba!o$ba#O$ba~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$ca#|$ca$O$ca'P$ca!y$ca!o$ca#O$ca~P!%aOz3{O#|$ca$O$ca#O$ca~PMVOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$fa#|$fa$O$fa'P$fa!y$fa!o$fa#O$fa~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n%Va#|%Va$O%Va'P%Va!y%Va!o%Va#O%Va~P!%aOz3{O#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#|$Qi$O$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi#|$Qi$O$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOT3}Oz3{O!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!S$Qi!n$Qi#|$Qi$O$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOT3}Oz3{O!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!S$Qi!c$Qi!n$Qi#|$Qi$O$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O#T#PO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#|$Qi$O$Qi$R$Qi$S$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O#T#PO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O#T#PO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O#T#PO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O$[4YO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$Z$Qi$]$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$Z$Qi$[$Qi$]$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O$Z4XO$[4YO$^4[O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$]$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOz3{O$_4[O%T#cOT$Qi!S$Qi!c$Qi!n$Qi!w$Qi#T$Qi#|$Qi$O$Qi$R$Qi$S$Qi$T$Qi$U$Qi$V$Qi$X$Qi$Y$Qi$Z$Qi$[$Qi$]$Qi$^$Qi'P$Qi!y$Qi!o$Qi#O$Qi~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n#Ua#|#Ua$O#Ua'P#Ua!y#Ua!o#Ua#O#Ua~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n'^a#|'^a$O'^a'P'^a!y'^a!o'^a#O'^a~P!%aOz3{O!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT#Qi!S#Qi!c#Qi!n#Qi#|#Qi$O#Qi'P#Qi!y#Qi!o#Qi#O#Qi~P!%aOz3{O!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT#}i!S#}i!c#}i!n#}i#|#}i$O#}i'P#}i!y#}i!o#}i#O#}i~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$Pi#|$Pi$O$Pi'P$Pi!y$Pi!o$Pi#O$Pi~P!%aOz3{O#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT!vq!S!vq!c!vq!n!vq!w!vq#|!vq$O!vq'P!vq!y!vq!o!vq#O!vq~P!%aOz3{O!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT#Qq!S#Qq!c#Qq!n#Qq#|#Qq$O#Qq'P#Qq!y#Qq!o#Qq#O#Qq~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$sq#|$sq$O$sq'P$sq!y$sq!o$sq#O$sq~P!%aOz3{O#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cOT!vy!S!vy!c!vy!n!vy!w!vy#|!vy$O!vy'P!vy!y!vy!o!vy#O!vy~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$sy#|$sy$O$sy'P$sy!y$sy!o$sy#O$sy~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$s!R#|$s!R$O$s!R'P$s!R!y$s!R!o$s!R#O$s!R~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$s!Z#|$s!Z$O$s!Z'P$s!Z!y$s!Z!o$s!Z#O$s!Z~P!%aOT3}Oz3{O!S4OO!c4PO!w5rO#T#PO$R3|O$S4QO$T4RO$U4SO$V4TO$X4VO$Y4WO$Z4XO$[4YO$]4ZO$^4[O$_4[O%T#cO!n$s!c#|$s!c$O$s!c'P$s!c!y$s!c!o$s!c#O$s!c~P!%aOP7wOU_O[5kOo9xOs#fOx5gOy5gO}aO!O^O!Q5{O!T5qO!V5iO!W5iO!Z5}O!d5eO!z]O#T5bO#X`O#dhO#fbO#gcO#sdO$[5oO$d5mO$e5oO$hqO%T5|O%U!OO'WYO~P$<UOP7wOU_O[5kOo9xOs#fOx5gOy5gO}aO!O^O!Q5{O!T5qO!V5iO!W5iO!Z5}O!d5eO!z]O#X`O#dhO#fbO#gcO#sdO$[5oO$d5mO$e5oO$hqO%T5|O%U!OO'WYO~P$<UO#|4aO$O4bO#O'XX~P3YOP7wOU_O[5kOo9xOr4cOs#fOx5gOy5gO}aO!O^O!Q5{O!T5qO!V5iO!W5iO!Z5}O!d5eO!z]O#T4`O#V4_O#X`O#dhO#fbO#gcO#sdO$[5oO$d5mO$e5oO$hqO%T5|O%U!OO'WYOT$PXz$PX!S$PX!c$PX!n$PX!w$PX#a$PX#b$PX#y$PX#|$PX$O$PX$R$PX$S$PX$T$PX$U$PX$V$PX$X$PX$Y$PX$Z$PX$]$PX$^$PX$_$PX'P$PX!y$PX!o$PX#O$PX~P$<UOP7wOU_O[5kOo9xOr6dOs#fOx5gOy5gO}aO!O^O!Q5{O!T5qO!V5iO!W5iO!Z5}O!d5eO!z]O#T6aO#V6`O#X`O#dhO#fbO#gcO#sdO$[5oO$d5mO$e5oO$hqO%T5|O%U!OO'WYOT$PXz$PX!S$PX!c$PX!w$PX#O$PX#P$PX#Y$PX#a$PX#b$PX#y$PX#|$PX$O$PX$R$PX$S$PX$T$PX$U$PX$V$PX$X$PX$Y$PX$Z$PX$]$PX$^$PX$_$PX!n$PX'P$PX!r$PX!y$PX!o$PXV$PX!p$PX~P$<UO!r4kO~P<XO!r7iO#P5RO~OT8TOz8RO!S8UO!c8VO!r5SO!w:_O#T#PO$R8SO$S8WO$T8XO$U8YO$V8ZO$X8]O$Y8^O$Z8_O$[8`O$]8aO$^8bO$_8bO%T#cO~P!%aO!r7jO#P5VO~O!r7kO#P5ZO~O#P5ZO#T'ZO#n'XO~O#P5[O#T'ZO#n'XO~O#P5_O#T'ZO#n'XO~OP7wOU_O[5kOo9xOs#fOx5gOy5gO}aO!O^O!Q5{O!T5qO!U$uO!V5iO!W5iO!Z5