/* global jQuery */

(function ($) {
    $(document).ready(function () {
        // Upload Submit
        $('.upload-profile-container input[type="file"]').change(function (e) {
            e.preventDefault();

            var value = $(this).val(), file = this.files[0];

            if (!value || !file) {
                return false;
            }

            var url = $('form').attr('action'), fd = new FormData();

            var args = {};

            $('input[type="hidden"][value="1"]').each(function () {
                args[this.name] = 1;
            });

            var xhr = new XMLHttpRequest();
            xhr.open('POST', url + '&task=profiles.import', true);

            // set request header
            xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');

            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    var data = {};

                    // success
                    if (xhr.status === 200) {
                        try {
                            data = JSON.parse(xhr.responseText);
                        } catch (e) {
                            alert(e);
                            return false;
                        }
                    }

                    // reset
                    xhr.onreadystatechange = $.noop;
                    xhr = fd = null;

                    document.location.href = data.redirect || 'index.php?option=com_jce&view=profiles';
                }
            };

            $.each(args, function (key, value) {
                fd.append(key, value);
            });

            // convert slashes
            value = value.replace(/[\\\\]+/g, '/');

            // extract name
            var name = value.substr(value.lastIndexOf('/') + 1);

            // append file
            fd.append("profile_file", file, name);

            xhr.send(fd);
        });
    });
})(jQuery);