<?php

/**
 * @package       Joomla.Administrator
 * @subpackage    com_guidedtours
 *
 * @copyright     (C) 2023 Open Source Matters, Inc. <https://www.joomla.org>
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\Helpers\StringHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\Component\Guidedtours\Administrator\Extension\GuidedtoursComponent;

/** @var  \Joomla\Component\Guidedtours\Administrator\View\Steps\HtmlView  $this */

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('table.columns')
    ->useScript('multiselect');

$user      = $this->getCurrentUser();
$userId    = $user->id;
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$saveOrder = $listOrder == 'a.ordering';
$section   = null;
$mode      = false;
$tourId    = $this->state->get('filter.tour_id');

$canEdit              = $user->authorise('core.edit', 'com_guidedtours');
$canEditOwnTour       = $user->authorise('core.edit.own', 'com_guidedtours');
$canEditStateTour     = $user->authorise('core.edit.state', 'com_guidedtours');
$hasCheckinPermission = $user->authorise('core.manage', 'com_checkin');

if ($saveOrder && !empty($this->items)) {
    $saveOrderingUrl = 'index.php?option=com_guidedtours&task=steps.saveOrderAjax&tmpl=component&' . Session::getFormToken() . '=1';
    HTMLHelper::_('draggablelist.draggable');
}
?>

<form action="<?php echo Route::_('index.php?option=com_guidedtours&view=steps&tour_id=' . $tourId); ?>"
      method="post" name="adminForm" id="adminForm">
    <div id="j-main-container" class="j-main-container">
        <?php
        // Search tools bar
        echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]);
        ?>

        <!-- If no steps -->
        <?php if (empty($this->items)) :
            ?>
            <!-- No steps -->
            <div class="alert alert-info">
                <span class="icon-info-circle" aria-hidden="true"></span>
                <span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php endif; ?>

        <!-- If there are steps, we start with the table -->
        <?php if (!empty($this->items)) :
            ?>
            <!-- Steps table starts here -->
            <table class="table" id="stepsList">

                <caption class="visually-hidden">
                    <?php echo Text::_('COM_GUIDEDTOURS_STEPS_TABLE_CAPTION'); ?>,
                    <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?></span>,
                    <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
                </caption>

                <!-- Steps table header -->
                <thead>
                <tr>
                    <td class="w-1 text-center">
                        <?php echo HTMLHelper::_('grid.checkall'); ?>
                    </td>
                    <!-- Ordering?-->
                    <th scope="col" class="w-3 text-center d-none d-md-table-cell">
                        <?php echo HTMLHelper::_(
                            'searchtools.sort',
                            '',
                            'a.ordering',
                            $listDirn,
                            $listOrder,
                            null,
                            'asc',
                            'JGRID_HEADING_ORDERING',
                            'icon-sort'
                        ); ?>
                    </th>
                    <th scope="col" class="w-1 text-center">
                        <?php echo HTMLHelper::_(
                            'searchtools.sort',
                            'JSTATUS',
                            'a.published',
                            $listDirn,
                            $listOrder
                        ); ?>
                    </th>
                    <th scope="col">
                        <?php echo Text::_('COM_GUIDEDTOURS_STEP_TITLE'); ?>
                    </th>
                    <th scope="col" class="d-none d-md-table-cell">
                        <?php echo Text::_('COM_GUIDEDTOURS_DESCRIPTION'); ?>
                    </th>
                    <th scope="col" class="d-none d-md-table-cell">
                        <?php echo HTMLHelper::_(
                            'searchtools.sort',
                            'COM_GUIDEDTOURS_STEP_TYPE',
                            'a.type',
                            $listDirn,
                            $listOrder
                        ); ?>
                    </th>

                    <th scope="col" class="w-10 text-center d-none d-md-table-cell">
                        <?php echo HTMLHelper::_(
                            'searchtools.sort',
                            'JGRID_HEADING_ID',
                            'a.id',
                            $listDirn,
                            $listOrder
                        ); ?>
                    </th>
                </tr>
                </thead>

                <!-- Table body begins -->
                <tbody <?php if ($saveOrder) : ?>
                    class="js-draggable" data-url="<?php echo $saveOrderingUrl; ?>" data-direction="<?php echo strtolower($listDirn); ?>" data-nested="true" <?php
                       endif; ?>>
                <?php foreach ($this->items as $i => $item) :
                    $canEditOwn = $canEditOwnTour && $item->created_by == $userId;
                    $canCheckin = $hasCheckinPermission || $item->checked_out == $userId || is_null($item->checked_out);
                    $canChange  = $canEditStateTour && $canCheckin;
                    ?>

                    <!-- Row begins -->
                    <tr class="row<?php echo $i % 2; ?>" data-draggable-group="none">
                        <!-- Item Checkbox -->
                        <td class="text-center">
                            <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->title); ?>
                        </td>

                        <!-- Draggable handle -->
                        <td class="text-center d-none d-md-table-cell">
                            <?php
                            $iconClass = '';

                            if (!$canChange) {
                                $iconClass = ' inactive';
                            } elseif (!$saveOrder) {
                                $iconClass = ' inactive" title="' . Text::_('JORDERINGDISABLED');
                            }
                            ?>

                            <span class="sortable-handler <?php echo $iconClass; ?>">
                                <span class="icon-ellipsis-v" aria-hidden="true"></span>
                            </span>

                            <?php if ($canChange && $saveOrder) : ?>
                                <input type="text" class="hidden text-area-order" name="order[]" size="5" value="<?php echo $item->ordering; ?>">
                            <?php endif; ?>
                        </td>

                        <!-- Step State -->
                        <td class="text-center">
                            <?php echo HTMLHelper::_(
                                'jgrid.published',
                                $item->published,
                                $i,
                                'steps.',
                                $canChange
                            ); ?>
                        </td>

                        <!-- Step name, edit link, and note -->
                        <th scope="row">
                            <div>
                                <?php if ($item->checked_out) : ?>
                                    <?php echo HTMLHelper::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'steps.', $canCheckin); ?>
                                <?php endif; ?>
                                <?php if ($canEdit || $canEditOwn) : ?>
                                    <a href="<?php echo Route::_('index.php?option=com_guidedtours&task=step.edit&id=' . $item->id); ?> " title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape($item->title); ?>">
                                        <?php echo $this->escape($item->title); ?>
                                    </a>
                                <?php else : ?>
                                    <?php echo $this->escape($item->title); ?>
                                <?php endif; ?>
                                <?php if ($item->note) : ?>
                                    <div class="small break-word">
                                        <?php echo Text::sprintf('JGLOBAL_LIST_NOTE', $this->escape($item->note)); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </th>
                        <td class="d-none d-md-table-cell">
                            <?php echo StringHelper::truncate($item->description, 200, true, false); ?>
                        </td>

                        <!-- Step Type -->
                        <td class="d-none d-md-table-cell">
                            <?php echo Text::_(GuidedtoursComponent::STEP_TYPE_NAMES[$item->type]) ?>
                        </td>

                        <!-- Step ID -->
                        <td class="d-none d-md-table-cell text-center">
                            <?php echo (int) $item->id; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

            <?php
            // Load the pagination
            echo $this->pagination->getListFooter();
            ?>
        <?php endif; ?>

        <?php echo $this->filterForm->renderControlFields(); ?>
    </div>
</form>
